# Generated by Django 5.2 on 2025-02-17 11:21

import django.db.models.deletion
import django.db.models.functions.datetime
from django.db import migrations, models

import lamindb.base.fields
import lamindb.base.users
import lamindb.models


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0087_rename__schemas_m2m_artifact_feature_sets_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="artifactschema",
            name="slot",
            field=lamindb.base.fields.CharField(
                blank=True, default=None, max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="composite",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="SchemaComponent",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "slot",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "component",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_component",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "composite",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_composite",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "unique_together": {("composite", "component")},
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="schema",
            name="components",
            field=models.ManyToManyField(
                related_name="composites",
                through="lamindb.SchemaComponent",
                to="lamindb.schema",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="artifactschema",
            unique_together={("artifact", "schema"), ("artifact", "slot")},
        ),
        migrations.AlterUniqueTogether(
            name="schemacomponent",
            unique_together={("composite", "component"), ("composite", "slot")},
        ),
        # unrelated, not on the SQL level, just switching "editable"
        migrations.AlterField(
            model_name="artifact",
            name="_hash_type",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=None,
                editable=False,
                max_length=30,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="created_artifacts",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="hash",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=None,
                editable=False,
                max_length=22,
                null=True,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="n_files",
            field=lamindb.base.fields.BigIntegerField(
                blank=True, db_index=True, default=None, editable=False, null=True
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="n_observations",
            field=lamindb.base.fields.BigIntegerField(
                blank=True, db_index=True, default=None, editable=False, null=True
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="otype",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=None,
                editable=False,
                max_length=64,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_artifacts",
                to="lamindb.run",
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="size",
            field=lamindb.base.fields.BigIntegerField(
                blank=True, db_index=True, default=None, editable=False, null=True
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="storage",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="artifacts",
                to="lamindb.storage",
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="suffix",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, editable=False, max_length=30
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="dtype",
            field=lamindb.base.fields.CharField(
                blank=True, default=None, editable=False, max_length=64, null=True
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="hash",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=None,
                editable=False,
                max_length=22,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="itype",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=None,
                editable=False,
                max_length=120,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="maximal_set",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=False, editable=False
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="minimal_set",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=True, editable=False
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="ordered_set",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=False, editable=False
            ),
        ),
    ]
