# Generated by Django 5.2 on 2025-05-25 11:59

import django.db.models.deletion
import django.db.models.functions.datetime
from django.db import migrations, models

import lamindb.base.fields


def update_space_uids_and_create_branches(apps, schema_editor):
    Space = apps.get_model("lamindb", "Space")
    Space.objects.filter(uid="00000000").update(uid="A")
    Branch = apps.get_model("lamindb", "Branch")
    Branch.objects.get_or_create(
        id=-1,
        uid="T",
        name="Trash",
        description="The trash.",
    )
    Branch.objects.get_or_create(
        id=0,
        uid="A",
        name="Archive",
        description="The archive.",
    )
    Branch.objects.get_or_create(
        uid="M",
        name="Main",
        description="The main & default branch of the instance.",
    )


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0099_alter_writelog_seqno"),
    ]

    operations = [
        migrations.CreateModel(
            name="Branch",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(db_index=True, max_length=100)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_default="M",
                        db_index=True,
                        default="M",
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "base_manager_name": "objects",
            },
        ),
        migrations.AlterField(
            model_name="space",
            name="uid",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_default="A",
                db_index=True,
                default="A",
                editable=False,
                max_length=12,
                unique=True,
            ),
        ),
        migrations.RunPython(update_space_uids_and_create_branches),
    ]
