# Generated by Django 5.2 on 2025-07-04 18:56

import django.db.models.deletion
from django.db import migrations, models

import lamindb.base.fields
import lamindb.models.sqlrecord


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0110_rename_values_artifacts_record_linked_artifacts"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="record",
            name="_sort_order",
        ),
        migrations.RenameField(
            model_name="record",
            old_name="runs",
            new_name="linked_runs",
        ),
        migrations.AlterUniqueTogether(
            name="recordproject",
            unique_together={("record", "feature", "value")},
        ),
        migrations.CreateModel(
            name="RecordPerson",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_recordperson",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_person",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.person",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="person",
            name="records",
            field=models.ManyToManyField(
                related_name="people",
                through="lamindb.RecordPerson",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordReference",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_recordreference",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_reference",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.reference",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="reference",
            name="records",
            field=models.ManyToManyField(
                related_name="references",
                through="lamindb.RecordReference",
                to="lamindb.record",
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="records",
            field=models.ManyToManyField(
                related_name="linked_people",
                through="lamindb.RecordPerson",
                to="lamindb.record",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="records",
            field=models.ManyToManyField(
                related_name="linked_projects",
                through="lamindb.RecordProject",
                to="lamindb.record",
            ),
        ),
        migrations.AlterField(
            model_name="reference",
            name="records",
            field=models.ManyToManyField(
                related_name="linked_references",
                through="lamindb.RecordReference",
                to="lamindb.record",
            ),
        ),
    ]
