# Generated by Django 5.2 on 2025-07-06 23:09

from django.db import migrations

import lamindb.base.fields


def extenddefault_values(apps, schema_editor):
    """Lowercase default values for Space and Branch models."""
    Space = apps.get_model("lamindb", "Space")
    Branch = apps.get_model("lamindb", "Branch")

    space = Space.objects.get(uid="a")
    space.uid = 12 * "a"
    space.save()

    trash_branch = Branch.objects.get(uid="t")
    trash_branch.uid = 12 * "t"
    trash_branch.save()

    archive_branch = Branch.objects.get(uid="a")
    archive_branch.uid = 12 * "a"
    archive_branch.save()

    main_branch = Branch.objects.get(uid="m")
    main_branch.uid = 12 * "m"
    main_branch.save()


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0114_alter_run__status_code"),
    ]

    operations = [
        migrations.AlterField(
            model_name="space",
            name="uid",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_default="aaaaaaaaaaaa",
                db_index=True,
                default="aaaaaaaaaaaaa",
                editable=False,
                max_length=12,
                unique=True,
            ),
        ),
        migrations.RunPython(
            extenddefault_values,
        ),
    ]
