# Generated by Django 5.1.12 on 2025-10-06 06:11

import django.core.validators
import django.db.models.deletion
import django.db.models.functions.datetime
import django.db.models.functions.text
from django.db import migrations, models

import lamindb.base.fields
import lamindb.base.uids
import lamindb.base.users
import lamindb.models.can_curate
import lamindb.models.has_parents
import lamindb.models.run
import lamindb.models.sqlrecord

CREATE_FUNCTION_SQL = """
CREATE OR REPLACE FUNCTION is_valid_record_type(record_type_id INTEGER, record_is_type BOOLEAN)
RETURNS BOOLEAN AS $$
BEGIN
    -- Record with no type is valid
    IF record_type_id IS NULL THEN
        RETURN TRUE;
    END IF;

    -- If current record is a type, it can only reference schema-less types
    IF record_is_type THEN
        RETURN EXISTS (
            SELECT 1 FROM lamindb_record r
            WHERE r.id = record_type_id AND r.is_type AND r.schema_id IS NULL
        );
    END IF;

    -- Regular records can reference any type
    RETURN EXISTS (
        SELECT 1 FROM lamindb_record r
        WHERE r.id = record_type_id AND r.is_type
    );
END;
$$ LANGUAGE plpgsql;
"""

ADD_CONSTRAINT_SQL = """
ALTER TABLE lamindb_record
ADD CONSTRAINT record_type_is_valid_fk
CHECK (is_valid_record_type(type_id, is_type));
"""

DROP_CONSTRAINT_SQL = (
    "ALTER TABLE lamindb_record DROP CONSTRAINT IF EXISTS record_type_is_valid_fk;"
)
DROP_FUNCTION_SQL = "DROP FUNCTION IF EXISTS is_valid_record_type(INTEGER, BOOLEAN);"


def apply_postgres_constraint(apps, schema_editor):
    if schema_editor.connection.vendor == "postgresql":
        schema_editor.execute(CREATE_FUNCTION_SQL)
        schema_editor.execute(ADD_CONSTRAINT_SQL)


def revert_postgres_constraint(apps, schema_editor):
    if schema_editor.connection.vendor == "postgresql":
        schema_editor.execute(DROP_CONSTRAINT_SQL)
        schema_editor.execute(DROP_FUNCTION_SQL)


class Migration(migrations.Migration):
    replaces = [
        (
            "lamindb",
            "0037_rename_dataset_to_collection",
        ),
        (
            "lamindb",
            "0038_alter_collection_artifact_alter_collection_artifacts_and_more",
        ),
        (
            "lamindb",
            "0039_remove_collection_artifacts_collectionartifact_and_more",
        ),
        ("lamindb", "0040_alter_transform_type"),
        (
            "lamindb",
            "0041_remove_transform_short_name_transform_description_and_more",
        ),
        ("lamindb", "0042_rename_run_at_run_started_at_run_finished_at"),
        ("lamindb", "0043_run_json"),
        ("lamindb", "0044_run_replicated_outputs_transform_ulabels_and_more"),
        (
            "lamindb",
            "0045_rename_replicated_outputs_run_replicated_output_artifacts_and_more",
        ),
        ("lamindb", "0046_storage_instance_uid"),
        ("lamindb", "0047_featurevalue_artifactfeaturevalue_and_more"),
        ("lamindb", "0048_alter_artifactulabel_feature_and_more"),
        ("lamindb", "0049_rename_type_feature_dtype_and_more"),
        ("lamindb", "0050_artifactfeatureset_feature_ref_is_semantic_and_more"),
        (
            "lamindb",
            "0051_remove_feature_feature_sets_featuresetfeature_and_more",
        ),
        (
            "lamindb",
            "0052_rename_feature_value_artifactfeaturevalue_featurevalue_and_more",
        ),
        ("lamindb", "0052_squashed"),
        (
            "lamindb",
            "0053_alter_featureset_hash_alter_paramvalue_created_by_and_more",
        ),
        ("lamindb", "0054_alter_feature_previous_runs_and_more"),
        ("lamindb", "0055_artifact_type_artifactparamvalue_and_more"),
        (
            "lamindb",
            "0056_rename_ulabel_ref_is_name_artifactulabel_label_ref_is_name_and_more",
        ),
        ("lamindb", "0057_link_models_latest_report_and_others"),
        ("lamindb", "0058_artifact__actions_collection__actions"),
        (
            "lamindb",
            "0059_alter_artifact__accessor_alter_artifact__hash_type_and_more",
        ),
        ("lamindb", "0060_alter_artifact__actions"),
        (
            "lamindb",
            "0061_alter_collection_meta_artifact_alter_run_environment_and_more",
        ),
        ("lamindb", "0062_add_is_latest_field"),
        ("lamindb", "0063_populate_latest_field"),
        (
            "lamindb",
            "0064_alter_artifact_version_alter_collection_version_and_more",
        ),
        ("lamindb", "0065_remove_collection_feature_sets_and_more"),
        ("lamindb", "0066_alter_artifact__feature_values_and_more"),
        ("lamindb", "0067_alter_featurevalue_unique_together_and_more"),
        ("lamindb", "0068_alter_artifactulabel_unique_together_and_more"),
        (
            "lamindb",
            "0069_alter_artifact__accessor_alter_artifact__hash_type_and_more",
        ),
        ("lamindb", "0069_squashed"),
        ("lamindb", "0070_lamindbv1_migrate_data"),
        ("lamindb", "0071_lamindbv1_migrate_schema"),
        ("lamindb", "0072_remove_user__branch_code_remove_user_aux_and_more"),
        ("lamindb", "0073_merge_ourprojects"),
        ("lamindb", "0074_lamindbv1_part4"),
        ("lamindb", "0075_lamindbv1_part5"),
        ("lamindb", "0076_lamindbv1_part6"),
        ("lamindb", "0077_lamindbv1_part6b"),
        ("lamindb", "0078_lamindbv1_part6c"),
        ("lamindb", "0079_alter_rundata_value_json_and_more"),
        ("lamindb", "0080_polish_lamindbv1"),
        ("lamindb", "0081_revert_textfield_collection"),
        ("lamindb", "0082_alter_feature_dtype"),
        ("lamindb", "0083_alter_feature_is_type_alter_flextable_is_type_and_more"),
        ("lamindb", "0084_alter_schemafeature_feature_and_more"),
        ("lamindb", "0085_alter_feature_is_type_alter_flextable_is_type_and_more"),
        ("lamindb", "0086_various"),
        ("lamindb", "0087_rename__schemas_m2m_artifact_feature_sets_and_more"),
        ("lamindb", "0088_schema_components"),
        ("lamindb", "0089_subsequent_runs"),
        ("lamindb", "0090_runproject_project_runs"),
        ("lamindb", "0091_alter_featurevalue_options_alter_space_options_and_more"),
        ("lamindb", "0092_alter_artifactfeaturevalue_artifact_and_more"),
        ("lamindb", "0093_alter_schemacomponent_unique_together"),
        ("lamindb", "0094_writeloglock_writelogmigrationstate_and_more"),
        ("lamindb", "0095_remove_rundata_flextable"),
        ("lamindb", "0096_remove_artifact__param_values_and_more"),
        ("lamindb", "0097_remove_schemaparam_param_remove_paramvalue_param_and_more"),
        ("lamindb", "0098_alter_feature_type_alter_project_type_and_more"),
        ("lamindb", "0099_alter_writelog_seqno"),
        ("lamindb", "0100_branch_alter_artifact__branch_code_and_more"),
        ("lamindb", "0101_alter_artifact_hash_alter_feature_name_and_more"),
        ("lamindb", "0102_remove_writelog_branch_code_and_more"),
        ("lamindb", "0103_remove_writelog_migration_state_and_more"),
        ("lamindb", "0104_alter_branch_uid"),
        ("lamindb", "0105_record_unique_name"),
        ("lamindb", "0106_transfer_data_migration"),
        ("lamindb", "0107_add_schema_to_record"),
        ("lamindb", "0108_remove_record_sheet_remove_sheetproject_sheet_and_more"),
        ("lamindb", "0109_record_input_of_runs_alter_record_run_and_more"),
        ("lamindb", "0110_rename_values_artifacts_record_linked_artifacts"),
        ("lamindb", "0111_remove_record__sort_order"),
        ("lamindb", "0112_alter_recordartifact_feature_and_more"),
        ("lamindb", "0113_lower_case_branch_and_space_names"),
        ("lamindb", "0114_alter_run__status_code"),
        ("lamindb", "0115_alter_space_uid"),
        ("lamindb", "0116_remove_artifact_unique_artifact_storage_key_hash_and_more"),
        ("lamindb", "0117_fix_artifact_storage_hash_unique_constraints"),
        ("lamindb", "0118_alter_recordproject_value_projectrecord"),
        ("lamindb", "0119_rename_records_project_linked_in_records"),
        ("lamindb", "0120_add_record_fk_constraint"),
        ("lamindb", "0121_recorduser"),
        ("lamindb", "0122_remove_personproject_person_and_more"),
        (
            "lamindb",
            "0123_alter_artifact_description_alter_branch_description_and_more",
        ),
        ("lamindb", "0124_page_artifact_page_collection_page_feature_page_and_more"),
        ("lamindb", "0125_artifact_is_locked_collection_is_locked_and_more"),
        (
            "lamindb",
            "0126_alter_artifact_is_locked_alter_collection_is_locked_and_more",
        ),
        ("lamindb", "0127_alter_run_status_code_feature_dtype"),
        ("lamindb", "0128_artifact__real_key"),
        ("lamindb", "0129_remove_feature_page_remove_project_page_and_more"),
        ("lamindb", "0130_branch_space_alter_artifactblock_artifact_and_more"),
        ("lamindb", "0131_record_unique_name_type_space"),
        ("lamindb", "0132_record_parents_record_reference_and_more"),
        ("lamindb", "0133_artifactuser_artifact_users"),
    ]

    dependencies = []  # type: ignore

    operations = [
        migrations.CreateModel(
            name="Migration",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "app",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255
                    ),
                ),
                ("applied", lamindb.base.fields.DateTimeField(blank=True)),
            ],
            options={
                "db_table": "django_migrations",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Branch",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(db_index=True, max_length=100)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_12,
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Space",
            fields=[
                ("id", models.SmallAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(db_index=True, max_length=100)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_12,
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=8,
                        unique=True,
                    ),
                ),
                (
                    "handle",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.can_curate.CanCurate),
        ),
        migrations.CreateModel(
            name="Artifact",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "key",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "_real_key",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "suffix",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=30,
                    ),
                ),
                (
                    "kind",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=20,
                        null=True,
                    ),
                ),
                (
                    "otype",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "size",
                    lamindb.base.fields.BigIntegerField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        null=True,
                    ),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "n_files",
                    lamindb.base.fields.BigIntegerField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        null=True,
                    ),
                ),
                (
                    "n_observations",
                    lamindb.base.fields.BigIntegerField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        null=True,
                    ),
                ),
                (
                    "_hash_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "_key_is_virtual",
                    lamindb.base.fields.BooleanField(blank=True, default=None),
                ),
                (
                    "_overwrite_versions",
                    lamindb.base.fields.BooleanField(blank=True, default=None),
                ),
                (
                    "_actions",
                    models.ManyToManyField(
                        related_name="_action_targets", to="lamindb.artifact"
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Collection",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_20,
                        editable=False,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "key",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "_actions",
                    models.ManyToManyField(related_name="+", to="lamindb.artifact"),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "meta_artifact",
                    lamindb.base.fields.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_meta_of_collection",
                        to="lamindb.artifact",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CollectionArtifact",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_collection",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "collection",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_artifact",
                        to="lamindb.collection",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="collection",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="collections",
                through="lamindb.CollectionArtifact",
                to="lamindb.artifact",
            ),
        ),
        migrations.CreateModel(
            name="CollectionProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "collection",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.collection",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="CollectionReference",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "collection",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_reference",
                        to="lamindb.collection",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="Feature",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_12,
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=150
                    ),
                ),
                (
                    "dtype",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "is_type",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, null=True
                    ),
                ),
                (
                    "unit",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                ("array_rank", models.SmallIntegerField(db_index=True, default=0)),
                ("array_size", models.IntegerField(db_index=True, default=0)),
                (
                    "array_shape",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "proxy_dtype",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "_expect_many",
                    models.BooleanField(db_default=None, default=None, null=True),
                ),
                (
                    "_curation",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="features",
                        to="lamindb.feature",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.can_curate.CanCurate, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactReference",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_reference",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactreference",
                        to="lamindb.feature",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactRecord",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_record",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactrecord",
                        to="lamindb.feature",
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.CreateModel(
            name="ArtifactProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactproject",
                        to="lamindb.feature",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="FeatureProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.feature",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="FeatureValue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("value", models.JSONField()),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values",
                        to="lamindb.feature",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "base_manager_name": "objects",
            },
        ),
        migrations.CreateModel(
            name="ArtifactFeatureValue",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_featurevalue",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "featurevalue",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="lamindb.featurevalue",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="_feature_values",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactFeatureValue",
                to="lamindb.featurevalue",
            ),
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_12,
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "is_type",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, null=True
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                    ),
                ),
                (
                    "url",
                    lamindb.base.fields.URLField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "start_date",
                    lamindb.base.fields.DateField(blank=True, default=None, null=True),
                ),
                (
                    "end_date",
                    lamindb.base.fields.DateField(blank=True, default=None, null=True),
                ),
                ("_status_code", models.SmallIntegerField(db_index=True, default=0)),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="projects",
                        through="lamindb.ArtifactProject",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "collections",
                    models.ManyToManyField(
                        related_name="projects",
                        through="lamindb.CollectionProject",
                        to="lamindb.collection",
                    ),
                ),
                (
                    "features",
                    models.ManyToManyField(
                        related_name="projects",
                        through="lamindb.FeatureProject",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="lamindb.project"
                    ),
                ),
                (
                    "predecessors",
                    models.ManyToManyField(
                        related_name="successors", to="lamindb.project"
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="projects",
                        to="lamindb.project",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                lamindb.models.can_curate.CanCurate,
                models.Model,
                lamindb.models.sqlrecord.ValidateFields,
            ),
        ),
        migrations.AddField(
            model_name="featureproject",
            name="project",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_feature",
                to="lamindb.project",
            ),
        ),
        migrations.AddField(
            model_name="collectionproject",
            name="project",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_collection",
                to="lamindb.project",
            ),
        ),
        migrations.AddField(
            model_name="artifactproject",
            name="project",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="lamindb.project",
            ),
        ),
        migrations.CreateModel(
            name="Record",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_16,
                        editable=False,
                        max_length=16,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "is_type",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="records",
                        through="lamindb.ArtifactRecord",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="lamindb.record"
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="records",
                        to="lamindb.record",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                lamindb.models.can_curate.CanCurate,
                models.Model,
                lamindb.models.has_parents.HasParents,
            ),
        ),
        migrations.CreateModel(
            name="ProjectRecord",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_projectrecord",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.project",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.record",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="records",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.ProjectRecord",
                to="lamindb.record",
            ),
        ),
        migrations.AddField(
            model_name="artifactrecord",
            name="record",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordArtifact",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordartifact",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_artifact",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_in_record",
                        to="lamindb.artifact",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="record",
            name="linked_artifacts",
            field=models.ManyToManyField(
                related_name="linked_in_records",
                through="lamindb.RecordArtifact",
                to="lamindb.artifact",
            ),
        ),
        migrations.CreateModel(
            name="RecordProject",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordproject",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_project",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_in_record",
                        to="lamindb.project",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="project",
            name="linked_in_records",
            field=models.ManyToManyField(
                related_name="linked_projects",
                through="lamindb.RecordProject",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordRecord",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordrecord",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_record",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.record",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="record",
            name="components",
            field=models.ManyToManyField(
                related_name="composites",
                through="lamindb.RecordRecord",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="RecordReference",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordreference",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_reference",
                        to="lamindb.record",
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.CreateModel(
            name="Reference",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_12,
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "is_type",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, null=True
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                    ),
                ),
                (
                    "url",
                    lamindb.base.fields.URLField(blank=True, db_index=True, null=True),
                ),
                (
                    "pubmed_id",
                    lamindb.base.fields.BigIntegerField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "doi",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="Must be a DOI (e.g., 10.1000/xyz123 or https://doi.org/10.1000/xyz123)",
                                regex="^(?:https?://(?:dx\\.)?doi\\.org/|doi:|DOI:)?10\\.\\d+/.*$",
                            )
                        ],
                    ),
                ),
                (
                    "text",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "date",
                    lamindb.base.fields.DateField(blank=True, default=None, null=True),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="references",
                        through="lamindb.ArtifactReference",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "collections",
                    models.ManyToManyField(
                        related_name="references",
                        through="lamindb.CollectionReference",
                        to="lamindb.collection",
                    ),
                ),
                (
                    "linked_in_records",
                    models.ManyToManyField(
                        related_name="linked_references",
                        through="lamindb.RecordReference",
                        to="lamindb.record",
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="references",
                        to="lamindb.reference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                lamindb.models.can_curate.CanCurate,
                models.Model,
                lamindb.models.sqlrecord.ValidateFields,
            ),
        ),
        migrations.AddField(
            model_name="recordreference",
            name="value",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_in_record",
                to="lamindb.reference",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="references",
            field=models.ManyToManyField(
                related_name="projects", to="lamindb.reference"
            ),
        ),
        migrations.AddField(
            model_name="collectionreference",
            name="reference",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_collection",
                to="lamindb.reference",
            ),
        ),
        migrations.AddField(
            model_name="artifactreference",
            name="reference",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="lamindb.reference",
            ),
        ),
        migrations.CreateModel(
            name="ReferenceRecord",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_referencerecord",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_reference",
                        to="lamindb.record",
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.reference",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="reference",
            name="records",
            field=models.ManyToManyField(
                related_name="references",
                through="lamindb.ReferenceRecord",
                to="lamindb.record",
            ),
        ),
        migrations.CreateModel(
            name="Run",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_16,
                        editable=False,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "started_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "finished_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "_is_consecutive",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "_status_code",
                    models.SmallIntegerField(
                        db_default=-3, db_index=True, default=-3, null=True
                    ),
                ),
                (
                    "_logfile",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_logfile_of",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "environment",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_environment_of",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "initiated_by_run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="initiated_runs",
                        to="lamindb.run",
                    ),
                ),
                (
                    "report",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_report_of",
                        to="lamindb.artifact",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="referencerecord",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="reference",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.CreateModel(
            name="RecordRun",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordrun",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_run",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="record",
            name="input_of_runs",
            field=models.ManyToManyField(
                related_name="input_records", to="lamindb.run"
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="linked_runs",
            field=models.ManyToManyField(
                related_name="records", through="lamindb.RecordRun", to="lamindb.run"
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_records",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="projectrecord",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="featurevalue",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="featureproject",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="feature",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collectionreference",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collectionproject",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collectionartifact",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="_subsequent_runs",
            field=models.ManyToManyField(
                db_table="lamindb_collection__previous_runs",
                related_name="_recreated_collections",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="input_of_runs",
            field=models.ManyToManyField(
                related_name="input_collections", to="lamindb.run"
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_collections",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifactreference",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifactproject",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifactfeaturevalue",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="_subsequent_runs",
            field=models.ManyToManyField(
                db_table="lamindb_artifact__previous_runs",
                related_name="_recreated_artifacts",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="input_of_runs",
            field=models.ManyToManyField(
                related_name="input_artifacts", to="lamindb.run"
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_artifacts",
                to="lamindb.run",
            ),
        ),
        migrations.CreateModel(
            name="RunFeatureValue",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "featurevalue",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_run",
                        to="lamindb.featurevalue",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_featurevalue",
                        to="lamindb.run",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="run",
            name="_feature_values",
            field=models.ManyToManyField(
                related_name="runs",
                through="lamindb.RunFeatureValue",
                to="lamindb.featurevalue",
            ),
        ),
        migrations.CreateModel(
            name="RunProject",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_run",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.run",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="project",
            name="runs",
            field=models.ManyToManyField(
                related_name="projects", through="lamindb.RunProject", to="lamindb.run"
            ),
        ),
        migrations.CreateModel(
            name="Schema",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=20,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                ("n", lamindb.base.fields.IntegerField(blank=True)),
                (
                    "is_type",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, null=True
                    ),
                ),
                (
                    "itype",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=120,
                        null=True,
                    ),
                ),
                (
                    "otype",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "dtype",
                    lamindb.base.fields.CharField(
                        blank=True,
                        default=None,
                        editable=False,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "minimal_set",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True, editable=False
                    ),
                ),
                (
                    "ordered_set",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, editable=False
                    ),
                ),
                (
                    "maximal_set",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, editable=False
                    ),
                ),
                (
                    "_curation",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "slot",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "composite",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="schemas",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "validated_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="validated_schemas",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.can_curate.CanCurate, models.Model),
        ),
        migrations.AddField(
            model_name="record",
            name="schema",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="records",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactSchema",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "slot",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "feature_ref_is_semantic",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="_links_schema",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_links_artifact",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="feature_sets",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactSchema",
                to="lamindb.schema",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="schema",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="validated_artifacts",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="SchemaComponent",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "slot",
                    lamindb.base.fields.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "component",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_component",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "composite",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_composite",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="schema",
            name="components",
            field=models.ManyToManyField(
                related_name="composites",
                through="lamindb.SchemaComponent",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="SchemaFeature",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_feature",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "unique_together": {("schema", "feature")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="feature",
            name="schemas",
            field=models.ManyToManyField(
                related_name="features",
                through="lamindb.SchemaFeature",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="SchemaProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="schemas",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.SchemaProject",
                to="lamindb.schema",
            ),
        ),
        migrations.AddField(
            model_name="schema",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="run",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="reference",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="featurevalue",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="feature",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="branch",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="space",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.space",
            ),
        ),
        migrations.CreateModel(
            name="Storage",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_12,
                        editable=False,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "root",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "type",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=30
                    ),
                ),
                (
                    "region",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "instance_uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=12,
                        null=True,
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="artifact",
            name="storage",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="artifacts",
                to="lamindb.storage",
            ),
        ),
        migrations.CreateModel(
            name="Transform",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        max_length=16,
                        unique=True,
                    ),
                ),
                (
                    "key",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default="pipeline", max_length=20
                    ),
                ),
                (
                    "source_code",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "hash",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "_template",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="_derived_from",
                        to="lamindb.transform",
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "predecessors",
                    models.ManyToManyField(
                        related_name="successors", to="lamindb.transform"
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="run",
            name="transform",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="runs",
                to="lamindb.transform",
            ),
        ),
        migrations.CreateModel(
            name="TransformProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_transform",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "transform",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.transform",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("transform", "project")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="transforms",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.TransformProject",
                to="lamindb.transform",
            ),
        ),
        migrations.CreateModel(
            name="TransformReference",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "reference",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_transform",
                        to="lamindb.reference",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "transform",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_reference",
                        to="lamindb.transform",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("transform", "reference")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="reference",
            name="transforms",
            field=models.ManyToManyField(
                related_name="references",
                through="lamindb.TransformReference",
                to="lamindb.transform",
            ),
        ),
        migrations.CreateModel(
            name="ULabel",
            fields=[
                (
                    "is_locked",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_default=False, default=False
                    ),
                ),
                (
                    "_aux",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None, null=True
                    ),
                ),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=lamindb.base.uids.base62_8,
                        editable=False,
                        max_length=8,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=150
                    ),
                ),
                (
                    "is_type",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=False, null=True
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "reference",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "reference_type",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "branch",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_column="_branch_code",
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="lamindb.ulabel"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "space",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        db_default=1,
                        default=1,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.space",
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="ulabels",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                lamindb.models.has_parents.HasParents,
                lamindb.models.can_curate.CanCurate,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="TransformULabel",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "transform",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ulabel",
                        to="lamindb.transform",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_transform",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("transform", "ulabel")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="transform",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="transforms",
                through="lamindb.TransformULabel",
                to="lamindb.ulabel",
            ),
        ),
        migrations.CreateModel(
            name="RunULabel",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ulabel",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_run",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="run",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="runs", through="lamindb.RunULabel", to="lamindb.ulabel"
            ),
        ),
        migrations.CreateModel(
            name="RecordULabel",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordulabel",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_ulabel",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.ulabel",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="record",
            name="linked_ulabels",
            field=models.ManyToManyField(
                related_name="linked_in_records",
                through="lamindb.RecordULabel",
                to="lamindb.ulabel",
            ),
        ),
        migrations.CreateModel(
            name="CollectionULabel",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "collection",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ulabel",
                        to="lamindb.collection",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_collectionulabel",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_collection",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="collection",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="collections",
                through="lamindb.CollectionULabel",
                to="lamindb.ulabel",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactULabel",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_ulabel",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactulabel",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="artifacts",
                through="lamindb.ArtifactULabel",
                to="lamindb.ulabel",
            ),
        ),
        migrations.CreateModel(
            name="ULabelProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_ulabel",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.ulabel",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("ulabel", "project")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.ULabelProject",
                to="lamindb.ulabel",
            ),
        ),
        migrations.CreateModel(
            name="TransformBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("line_number", models.IntegerField(null=True)),
                (
                    "transform",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.transform",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="transform",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="created_transforms",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="SpaceBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "space",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.space",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="space",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="SchemaBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "schema",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.schema",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="schema",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="RunBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.run",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="run",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="created_runs",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="RootBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=255)),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="referencerecord",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="reference",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="RecordUser",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recorduser",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_user",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.user",
                    ),
                ),
            ],
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.CreateModel(
            name="RecordBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "record",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.record",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="record",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="record",
            name="linked_users",
            field=models.ManyToManyField(
                related_name="records", through="lamindb.RecordUser", to="lamindb.user"
            ),
        ),
        migrations.AddField(
            model_name="projectrecord",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="ProjectBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.project",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="project",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="featurevalue",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="featureproject",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="FeatureBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="feature",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="collectionreference",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="collectionproject",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="CollectionBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "collection",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.collection",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="collectionartifact",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="BranchBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "branch",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="branch",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifactreference",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifactproject",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifactfeaturevalue",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.FloatField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="artifact",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="created_artifacts",
                to="lamindb.user",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="artifactrecord",
            unique_together={("artifact", "record", "feature")},
        ),
        migrations.CreateModel(
            name="RecordJson",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "value",
                    lamindb.base.fields.JSONField(
                        blank=True, db_default=None, default=None
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recordjson",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_json",
                        to="lamindb.record",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AlterUniqueTogether(
            name="recordreference",
            unique_together={("record", "feature", "value")},
        ),
        migrations.AlterUniqueTogether(
            name="transform",
            unique_together={("key", "hash")},
        ),
        migrations.AddConstraint(
            model_name="space",
            constraint=models.UniqueConstraint(
                django.db.models.functions.text.Lower("name"),
                name="unique_space_name_lower",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="schemaproject",
            unique_together={("schema", "project")},
        ),
        migrations.AlterUniqueTogether(
            name="schemacomponent",
            unique_together={("composite", "slot"), ("composite", "slot", "component")},
        ),
        migrations.AlterUniqueTogether(
            name="runulabel",
            unique_together={("run", "ulabel")},
        ),
        migrations.AlterUniqueTogether(
            name="runproject",
            unique_together={("run", "project")},
        ),
        migrations.AlterUniqueTogether(
            name="runfeaturevalue",
            unique_together={("run", "featurevalue")},
        ),
        migrations.AlterUniqueTogether(
            name="referencerecord",
            unique_together={("reference", "feature", "record")},
        ),
        migrations.AlterUniqueTogether(
            name="recorduser",
            unique_together={("record", "feature", "value")},
        ),
        migrations.AddConstraint(
            model_name="record",
            constraint=models.UniqueConstraint(
                fields=("name", "type", "space"), name="unique_name_type_space"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="projectrecord",
            unique_together={("project", "feature", "record")},
        ),
        migrations.AlterUniqueTogether(
            name="featurevalue",
            unique_together={("feature", "hash")},
        ),
        migrations.AlterUniqueTogether(
            name="featureproject",
            unique_together={("feature", "project")},
        ),
        migrations.AddConstraint(
            model_name="feature",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    ("is_type", True), ("dtype__isnull", False), _connector="OR"
                ),
                name="dtype_not_null_when_is_type_false",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="collectionulabel",
            unique_together={("collection", "ulabel")},
        ),
        migrations.AlterUniqueTogether(
            name="collectionreference",
            unique_together={("collection", "reference")},
        ),
        migrations.AlterUniqueTogether(
            name="collectionproject",
            unique_together={("collection", "project")},
        ),
        migrations.AlterUniqueTogether(
            name="collectionartifact",
            unique_together={("collection", "artifact")},
        ),
        migrations.AddConstraint(
            model_name="branch",
            constraint=models.UniqueConstraint(
                django.db.models.functions.text.Lower("name"),
                name="unique_branch_name_lower",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="artifactulabel",
            unique_together={("artifact", "ulabel", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactschema",
            unique_together={("artifact", "schema"), ("artifact", "slot")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactreference",
            unique_together={("artifact", "reference", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactproject",
            unique_together={("artifact", "project", "feature")},
        ),
        migrations.AlterUniqueTogether(
            name="artifactfeaturevalue",
            unique_together={("artifact", "featurevalue")},
        ),
        migrations.AddConstraint(
            model_name="artifact",
            constraint=models.UniqueConstraint(
                condition=models.Q(("key__isnull", False)),
                fields=("storage", "key", "hash"),
                name="unique_artifact_storage_key_hash_not_null",
            ),
        ),
        migrations.AddConstraint(
            model_name="artifact",
            constraint=models.UniqueConstraint(
                condition=models.Q(("key__isnull", True)),
                fields=("storage", "hash"),
                name="unique_artifact_storage_hash_null_key",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactUser",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_user",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactuser",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.run.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "user",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("artifact", "user", "feature")},
            },
            bases=(lamindb.models.sqlrecord.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="artifact",
            name="users",
            field=models.ManyToManyField(
                related_name="+", through="lamindb.ArtifactUser", to="lamindb.user"
            ),
        ),
        migrations.RunPython(
            apply_postgres_constraint, reverse_code=revert_postgres_constraint
        ),
    ]
