# Qudix

Qudix is a lightweight terminal-based text editor that brings a modern editing experience to your command line. With mouse support, intuitive toolbar buttons, and familiar keyboard shortcuts, it makes text editing in the terminal feel natural and efficient. Derived from the highlighted letters in “[Qu]ick e[di]t ne[x]t.”


## Features

### Core Editing
- **Undo/Redo** – Full undo and redo support to easily revert or reapply changes
- **Cut/Copy/Paste** – Standard clipboard operations that work with your system clipboard
- **Delete** – Quick deletion of selected text or current line
- **Mouse Selection** – Click and drag to select text across lines, just like a GUI editor
- **Keyboard Selection** – Automatic line selection when no text is selected for quick operations

### User Interface
- **Interactive Toolbar** – Clickable buttons for common editing actions at the top of the screen
- **Line Numbers** – Built-in line numbers for easy navigation
- **Scrollbar** – Visual scrollbar for large files
- **Status Bar** – Shows current file path, save status, and action feedback
- **File Creation Dialog** – Convenient popup window to create new files when launched without a path

### System Integration
- **Cross-Platform Clipboard** – Seamless integration with macOS, Windows, and Linux system clipboards
- **File Operations** – Save with `Ctrl+S` and track unsaved changes automatically
- **Unsaved Changes Warning** – Prevents accidental data loss by prompting before exit

## Installation

Install Qudix from PyPI:

```bash
pip install qudix
```

## Usage

Launch the editor in two ways:

**Create a new file** (popup dialog will appear):
```bash
qudix
```

**Open an existing file or create one at a specific path**:
```bash
qudix /path/to/file/filename.txt
```

## Keyboard Shortcuts

| Shortcut | Action |
|----------|--------|
| `Ctrl+S` | Save file |
| `Ctrl+X` | Exit editor (prompts if unsaved) |
| `Esc` | Return focus to text area |
| `Ctrl+Home` | Jump to top of file |
| `Backspace` | Delete character or selection |

**Mouse Controls:**
- Click anywhere to position cursor
- Click and drag to select text
- Click toolbar buttons to perform actions
- Scroll wheel to navigate through file

## Build Instructions

If you want to build from source:

```bash
# Clone the repository
git clone <repository-url>
cd qudix

# Create and activate virtual environment
python -m venv .venv
source .venv/bin/activate  # On Windows: .venv\Scripts\activate

# Install in editable mode
pip install -e .
```

## Development

The project uses a standard `src/` layout with the main application code in `src/qudix/app.py`. It's built on top of [prompt_toolkit](https://github.com/prompt-toolkit/python-prompt-toolkit), which provides the terminal UI framework.

### Project Structure
```
src/qudix/
  ├── __init__.py
  └── app.py         # Main application entry point
```

## License

This project is dual-licensed under Apache-2.0 OR MIT. You may use it under the terms of either license at your option. See `LICENSE`, `LICENSE-APACHE`, and `LICENSE-MIT` for details.
