# Frequenz Weather API

[![Build Status](https://github.com/frequenz-floss/frequenz-api-weather/actions/workflows/ci.yaml/badge.svg)](https://github.com/frequenz-floss/frequenz-api-weather/actions/workflows/ci.yaml)
[![PyPI Package](https://img.shields.io/pypi/v/frequenz-api-weather)](https://pypi.org/project/frequenz-api-weather/)
[![Docs](https://img.shields.io/badge/docs-latest-informational)](https://frequenz-floss.github.io/frequenz-api-weather/)

## Overview
This Weather Forecast API provides access to weather forecast data. The forecast 
data includes features such as wind components and solar radiation levels at
specified geographic coordinates. The forecasting process involves predicting
atmospheric conditions based on various factors and models. The data provided by
this API represents the forecasted state of the atmosphere at different heights
above the ground and for various forecast creation times. 

## Objective
The primary objective of this API is to provide real-time and historical weather
forecast data to enable more efficient
energy management, trading, and planning within microgrids and larger gridpool
portfolios.

## Key Features
- Real-time Weather Forecasting: Access current atmospheric conditions based on
 recent data.
- Historical Data Access: Retrieve past weather forecasts for analysis and trend
 prediction.
- Feature Customization: Choose from a variety of weather features like wind speed,
 solar radiation, and more.
- Geographical Flexibility: Get forecasts for any location specified by latitude and
 longitude.

## Example Use Cases
- Adjusting the trading of photovoltaic (PV) surplus production based on future
 solar radiation forecasts.
- Feeding excess energy into batteries when low consumption or high production is
 forecasted.
- Dynamic pricing strategies for energy trading based on anticipated weather
 conditions.
- Resource allocation in microgrids for anticipated energy demands, guided by
 weather forecasts.
- Risk assessment and contingency planning for severe weather events.

## Target Audience
This API is designed for application developers in the energy sector who focus on
the tasks of optimizing microgrid electricity flows or trading of energy. Its design
aims to be as developer-friendly as possible, requiring no prior knowledge in
electrical engineering and systems and/or weather forecast services. 

## Contributing

If you want to know how to build this project and contribute to it, please
check out the [Contributing Guide](CONTRIBUTING.md).

