# file auto generated by mkgiacpy_pyi.py
from typing import Any

# file auto generated by mkkeywords.py
class Pygen():
     """
     The class Pygen is the main tool to interact from python/sage with the c++
     library giac via cython.  The initialisation of a Pygen just create an object
     in giac, but the mathematical computation  is not done. This class is mainly
     for cython users.  Here A is a Pygen element, and it is ready for any giac
     function.::

     >>> from giacpy import Pygen
     >>> A = Pygen('2+2')
     >>> A
     2+2
     >>> A.eval()
     4

     In general, you may prefer to directly create a Pygen and execute the
     evaluation in giac. This is exactly the meaning of the :func:`libgiac`
     function.::

     >>> a = giac('2+2')
     >>> a
     4
     >>> isinstance(a, Pygen)
     True

     """


     @classmethod
     def _repr_latex_(self,*args):

     def _repr_html_(self,*args):

     def qcas(self,*args):

     def save(self,*args):
        r'''
          Archive a Pygen element to a file in giac compressed format.

          Use the loadgiacgen command to get back the Pygen from the file.

          In C++ these files can be opened with giac::unarchive

            >>> from giacpy import *
            >>> f=giac('(x+y+z+2)**10'); g=f.normal()
            >>> g.save("fichiertest")           #  doctest: +SKIP
            >>> a=loadgiacgen("fichiertest")    #  doctest: +SKIP
            >>> from tempfile import NamedTemporaryFile
            >>> F=NamedTemporaryFile()   # chose a temporary file for a test
            >>> Fname=F.name; F.close()  # so Fname can be our filename  
            >>> g.save(Fname)
            >>> a=loadgiacgen(Fname)
            >>> a.factor()
            (x+y+z+2)**10
            >>> F.close()

        
        '''
     ####################################################
     #### Pygen methods from giac  functions ############
     ####################################################

     def Airy_Ai(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Airy_Ai:
        Airy_Ai(Real)
        Returns the value of Ai the Airy function solution of w''-xw=0. Ai(x)=Ai(0)f(z)+Ai'(0)g(z)(f and g are taylor's series sol of w''-xw=0).
        See also: 1/ Airy_Bi 
        Ex1:Airy_Ai(0)
        Ex2:Airy_Ai(1.5)
        
        '''

     def Airy_Bi(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Airy_Bi:
        Airy_Bi(Real)
        Returns the value of Ai the Airy function solution of w''-xw=0. Bi(x)=sqrt(3)(Bi(0)f(z)-Bi'(0)g(z))(f and g are taylor's series sol of w''-xw=0).
        See also: 1/ Airy_Ai 
        Ex1:Airy_Bi(1.5)
        Ex2:Airy_Bi(0)
        
        '''

     def Archive(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Archive:
        Archive(SeqVar)
        Protects the variables given as argument in an archive file.
        See also: 1/ Unarchiv 2/ archive 3/ unarchive 
        Ex1:Archive(a,b)
        
        '''

     def BesselJ(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for BesselJ:
        BesselJ(Int(p),Real(x))
        BesselJ(p,x) returns the Bessel function of the first kind Jp(x).
        See also: 1/ besselJ 2/ BesselY 3/ besselY 
        Ex1:BesselJ(2,sqrt(2))
        Ex2:BesselJ(-2,sqrt(2))
        
        '''

     def BesselY(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for BesselY:
        BesselY(Int(p),Real(x))
        BesselY(p,x) returns the Bessel function of the second kind Yp(x).
        See also: 1/ besselY 2/ BesselJ 3/ besselJ 
        Ex1:BesselY(BesselJ(2,sqrt(2)))
        Ex2:BesselY(BesselJ(-2,sqrt(2)))
        
        '''

     def Beta(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Beta:
        Beta(Expr,Expr,[Expr],[1])
        Beta(a,b)=int(t^(a-1)*(1-t)^(b-1),t=0..1), Beta(a,b,p)=int(t^(a-1)*(1-t)^(b-1),t=0..p), Beta(a,b,p,1)=Beta(a,b,p)/Beta(a,b).(Beta(x,y) returns Gamma(x)*Gamma(y)/Gamma(x+y)).
        See also: 1/ Gamma 2/ igamma 
        Ex1:Beta(x,y)
        Ex2:Beta(3,2)
        Ex3:Beta(3,2,0.5)
        Ex4:Beta(3,2,0.5,1)
        
        '''

     def BlockDiagonal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for BlockDiagonal:
        BlockDiagonal(Lst(l)||Mtrx(A))
        Returns either the diagonal matrix with diagonal l or the diagonal of A.
        See also: 1/ identity 2/ diag  
        Ex1:BlockDiagonal([[1,2],[3,4]])
        Ex2:BlockDiagonal([1,2,3])
        
        '''

     def Ci(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Ci:
        Ci(Expr)
        Cosine integral int(cos(t)/t,t=-inf..x).
        See also: 1/ Ei 2/ Si 3/ Li 
        Ex1:Ci(1.0)
        
        '''

     def Circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Circle:
        Circle(Real(xc),Real(yc),Real(r),[Intg(option)])
        Draws the circle with center (xc,yc) and radius r (by default option=1 and option=0 is to remove this circle).
        See also: 1/ circle 
        Ex1:Circle(0,1,1)
        Ex2:Circle(0,1,1,0)
        Ex3:Circle(0,1,1,1)
        
        '''

     def Col(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Col:
        Col(NULL)
        Returns the index of the column of the lightened cell in the matrixwriter.
        See also: 1/ Row 
        Ex1:Col()
        
        '''

     def CopyVar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for CopyVar:
        CopyVar(Var(var1),Var(var2))
        Copies the storage without evaluation of var1 into var2.
        See also: 1/  
        Ex1:CopyVar(A,B)
        
        '''

     def Dirac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Dirac:
        Dirac(Real)
        Function derivative of Heaviside.
        See also: 1/ Heaviside 
        Ex1:Dirac(1)
        Ex2:Dirac(-1)
        Ex3: int(Dirac(x)*(x-1)^2,x,-1,2)
        
        '''

     def Ei(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Ei:
        Ei(Expr)
        Exponential integral int(exp(t)/t,t=-inf..x).
        See also: 1/ Si 2/ Ci 3/ Li 
        Ex1:Ei(1.0)
        
        '''

     def Factor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Factor:
        Factor(Expr)
        Factors a polynomial without evaluation.
        See also: 1/ factor 2/ ifactor 3/ normal 
        Ex1:Factor(x^4-1)
        Ex2:Factor(x^4+12*x^3+54*x^2+108*x+81)
        
        '''

     def Fourier(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Fourier:
        Fourier(Expr(f),Var(t),Var(omega))
        The inert form of fourier command.
        See also: 1/ fourier 2/ ifourier 
        Ex1: F:=Fourier(y(t),t,omega);ifourier(F)
        
        '''

     def GF(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for GF:
        GF(Intg(p), Intg(n)|Minpoly,[Variable],[0|undef|Poly])
        Creates a Galois Field of characteristic p with p^n elements. The minimal polynomial is primitive except if given or if 0 is passed as the last argument.
        Ex1:GF(2,8)
        Ex2:GF(5,9,a)
        Ex3:GF(2,128,0)
        Ex4:GF(2,w^8+w^7+w^5+w+1)
        Ex5:GF(2,8,['a','G'])
        Ex6: G:=GF(2,a^8+a^6+a^3+a^2+1,['a','G'],undef)
        
        '''

     def Gamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Gamma:
        Gamma(Real(a),[Real(b)])
        Calculates Gamma at a point a (Gamma(n+1)=n! for n integer) if a>0, Gamma(a)=int(e^{-t}*t^{a-1},t=0..inf)) and Gamma(a)=Gamma(a+1)/a and Gamma(a,b)=ugamma(a,b).
        See also: 1/ Psi 2/ Beta 3/ ugamma 4/ igamma 
        Ex1:Gamma(5)
        Ex2:Gamma(1/2)
        Ex3:Gamma(gamma(-5.1))
        Ex4:Gamma(-5.1,2.1)
        
        '''

     def Heaviside(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Heaviside:
        Heaviside(Real)
        Function equal to 0 if x<0 and 1 if x>=0.
        See also: 1/ Dirac 2/ laplace 
        Ex1:Heaviside(1)
        Ex2:Heaviside(-1)
        Ex3:Heaviside(0)
        
        '''

     def Heaviside2sign(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Heaviside2sign:
        Heaviside2sign(Expr)
        Replaces Heaviside function by sign function in an expression.
        See also: 1/ sign 2/ Heaviside 3/ sign2Heaviside 4/ simpd 
        Ex1:Heaviside2sign(Heaviside(x))
        
        '''

     def Hilbert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Hilbert:
        Hilbert(Expr(f),Var(x))
        The inert form of hilbert command.
        See also: 1/ hilbert 
        Ex1:Hilbert(y(x),x)
        
        '''

     def JordanBlock(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for JordanBlock:
        JordanBlock(Expr(a),Intg(n))
        Returns an n*n matrix with a on the diagonal, 1 above and 0 everywhere else.
        See also: 1/ jordan 
        Ex1:JordanBlock(7,3)
        
        '''

     def LU(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for LU:
        LU(Mtrx(A),Var(L),Var(U),Var(P))
        For a numerical matrix A, stores in L a lower triangular matrix, in U an upper triangular  matrix and in P a permutation matrix such that P*A=L*U.
        See also: 1/ lu 2/ QR 
        Ex1:LU([[1,2],[3,4]],L,U,P)
        Ex2:LU([[6,12,18],[5,14,31],[3,8,18]],L,U,P)
        
        '''

     def LambertW(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for LambertW:
        LambertW(Real(x),[Intg(n)])
        Returns a solution for t of t*exp(t)=x
        Ex1:LambertW(1.0)
        Ex2:LambertW(ln(4))
        Ex3:LambertW(-0.1,-1)
        
        '''

     def Li(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Li:
        Li(Expr)
        Logarithm integral Li(x)=Ei(ln(x)) primitive of 1/ln(x).
        See also: 1/ Si 2/ Ci 3/ Ei 
        Ex1:Li(2.0)
        
        '''

     def Line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Line:
        Line(Expr(a),Expr(b),Expr(c),Expr(d))
        Draws the segment [a+i*b,c+i*d].
        See also: 1/ segment 
        Ex1:Line(-1,-2,1,2)
        
        '''

     def LineHorz(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for LineHorz:
        LineHorz(Expr(a))
        Draws the horizontal line y=a.
        See also: 1/ Line 2/ LineVert 
        Ex1:LineHorz(-1)
        
        '''

     def LineTan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for LineTan:
        LineTan(Expr(f(x)),[Var],Expr(a))
        Draws the tangent to y=f(x) at x=a. Do not use parentheses or put the parenthesis around the entire expression.
        See also: 1/ tangent 2/ droite_tangente 
        Ex1: LineTan sin(x),pi/4
        Ex2: LineTan sin(t),t=pi/4)
        Ex3: LineTan sin(t),t,pi/4
        Ex4: LineTan x^2-x,1
        Ex5: (LineTan sin(t),t,pi/4)
        
        '''

     def LineVert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for LineVert:
        LineVert(Expr(a))
        Draws the vertical line x=a.
        See also: 1/ Line 2/ LineHorz 
        Ex1:LineVert(2)
        
        '''

     def MSE(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for MSE:
        MSE(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def Phi(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Phi:
        Phi(Intg(n))
        Euler's function (euler(n)=card({p<n,gcd(n,p)=1})).
        See also: 1/ gcd 
        Ex1:Phi(11)
        Ex2:Phi(6)
        
        '''

     def Pi(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Pi:
        Pi()
        pi.
        See also: 1/ e 2/ i 
        Ex1: pi/4
        Ex2: Pi/4
        Ex3: evalf(pi)
        Ex4: evalf(Pi)
        
        '''

     def Psi(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Psi:
        Psi(Real(a),Intg(n))
        Psi(a,n)=n-th derivative of the function DiGamma (=ln@Gamma) at point a (Psi(a,0)=Psi(a)).
        See also: 1/ Gamma 
        Ex1:Psi(3,1)
        
        '''

     def QR(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for QR:
        QR(Mtrx,Var(Q),Var(R),[Real(eps)])
        For a numerical matrix A, stores in Q a orthogonal matrix and in U a lower triangular matrix such that A=Q*R [replacing by 0 the elements such that abs(el)<eps].
        See also: 1/ qr 2/ LU 
        Ex1:QR([[1,2],[3,4]],Q,R)
        
        '''

     def RandSeed(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for RandSeed:
        RandSeed(Intg)
        Initializes random numbers.
        See also: 1/ srand 
        Ex1:RandSeed(321)
        
        '''

     def ReLU(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ReLU:
        ReLU(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def Row(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Row:
        Row(NULL)
        Returns the index of the row of the lightened cell in the matrixwriter.
        See also: 1/ Col 
        Ex1:Row()
        
        '''

     def SortA(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for SortA:
        SortA(LstReal||Seq||Mtrx)
        Sorts the lists in increasing order (like TI).
        See also: 1/ SortD 2/ sorta 3/ sort 
        Ex1: SortA [3,4,2]
        Ex2: SortA 3,4,2
        Ex3: SortA [3,4,2],[6,4,5]
        Ex4: SortA [[3,4,2],[6,4,5]]
        
        '''

     def SortD(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for SortD:
        SortD(LstReal||Seq||Mtrx)
        Sorts the list in decreasing order (like TI).
        See also: 1/ SortA 2/ sortd 3/ sort 
        Ex1: SortD [3,4,2]
        Ex2: SortD 3,4,2
        Ex3: SortD [[3,4,2],[6,4,5]]
        Ex4: SortD [3,4,2],[6,4,5]
        
        '''

     def UTPC(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for UTPC:
        UTPC(Intg(n),Real(x0))
        Returns the probability that a Chisquare random variable is greater than x0 (n is the number of degrees of freedom).
        See also: 1/ chisquare_cdf 2/ chisquare_icdf 
        Ex1:UTPC(2,6.1)
        Ex2:UTPC(4,6.1)
        
        '''

     def UTPF(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for UTPF:
        UTPF(Intg(n),Intg(d),Real(x0))
        Returns the probability that a Fisher-Snedecor random variable is greater than x0 (n and d are the numbers of degrees of freedom).
        See also: 1/ fisher_cdf 2/ fisher_icdf 
        Ex1:UTPF(4,10,3.5)
        Ex2:UTPF(4,4,2.1)
        
        '''

     def UTPN(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for UTPN:
        UTPN(Real(mu),Real(v),Real(x0))
        Returns the probability that a Normal random variable is greater than x0 (mu is the mean and v the variance).
        See also: 1/ normal_cdf 2/ normal_icdf 
        Ex1:UTPN(1.96)
        Ex2:UTPN(1,4,2.96)+normal_cdf(1,2,2.96)
        
        '''

     def UTPT(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for UTPT:
        UTPT(Intg(n),Real(x0))
        Returns the probability that a Student random variable is greater than x0 (n is the number of degrees of freedom).
        See also: 1/ student_cdf 2/ student_icdf 
        Ex1:UTPT(3,2.35)
        Ex2:UTPT(3,-2.35)
        
        '''

     def VARS(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for VARS:
        VARS(NULL)
        List of the variables and folders of the current directory.
        See also: 1/ lvar 
        Ex1:VARS()
        
        '''

     def VAS(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for VAS:
        VAS(Poly(P))
        Returns a list of intervals containing the real roots of P. Vincent-Akritas-Strzebonski's method (VAS) is used.
        See also: 1/ VAS_positive 2/ sturmab 3/ realroot 
        Ex1:VAS(x^3-7*x+7)
        
        '''

     def VAS_positive(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for VAS_positive:
        VAS_positive(Poly(P))
        Returns a list of intervals containing the positive roots of P. Vincent-Akritas-Strzebonski's method (VAS) is used.
        See also: 1/ poslbdLMQ 2/ posubLMQ 3/ VAS 4/ realroot 
        Ex1:VAS_positive(x^3-7*x+7)
        
        '''

     def Zeta(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for Zeta:
        Zeta(Real(a))
        Returns if a>1 sum(1/n^a,n,1,+infinity).
        See also: 1/ sum 
        Ex1:Zeta(2)
        
        '''

     def a2q(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for a2q:
        a2q(Mtrx,VectVar)
        a2q(A,X)=the quadratic form q associated to A, X=vector of variables.
        See also: 1/ q2a 
        Ex1:a2q([[1,2],[4,4]],[x,y])
        Ex2:a2q([[1,3],[3,4]],[x,y])
        
        '''

     def abcuv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for abcuv:
        abcuv(Poly(a),Poly(b),Poly(c),[Var])
        Returns [u,v] such that au+bv=c for 3 polynomials a,b,c.
        See also: 1/ egcd 2/ iabcuv 
        Ex1:abcuv(x^2+2*x+1,x^2-1,x+1)
        Ex2:abcuv(X^2+2*X+1,X^2-1,X+1,X)
        Ex3:abcuv(x^2+2*x+1,x^2-1,x^3+1)
        Ex4:abcuv(X^2+2*X+1,X^2-1,X^3+1,X)
        Ex5:abcuv([1,2,1],[1,0,-1],[1,0,0,1])
        
        '''

     def about(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for about:
        about(Var(a)||Image||Audio)
        Returns the hypothesis made with assume on the variable a or describes an image object or an audio clip.
        See also: 1/ assume 2/ purge 
        Ex1:about(a)
        Ex2:about(n)
        
        '''

     def abs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for abs:
        abs(Cplx||LstCplx)
        Returns the absolute value or the norm of its argument.
        See also: 1/ arg 
        Ex1:abs(-4)
        Ex2:abs(1+2*i)
        Ex3:abs((1+2*i)^2)
        Ex4:abs([-2,1+i,-4])
        
        '''

     def abscissa(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for abscissa:
        abscissa(Pnt or Vect)
        Returns the abscissa of a point or a vector.
        See also: 1/ ordinate 2/ affix 3/ cote 4/ coordinates 
        Ex1:abscissa(point(1+2*i))
        Ex2:abscissa(point(i)-point(1+2*i))
        Ex3:abscissa(-1-i)
        Ex4:abscissa(point(1,2,3))
        
        '''

     def accumulate_head_tail(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for accumulate_head_tail:
        accumulate_head_tail(Lst(l),Intg(p),Intg(q))
        Returns the list where the first p and the last q elements of l are replaced by their sum.
        See also: 1/  
        Ex1:accumulate_head_tail([0,1,2,3,4,5,6,7,8,9],3,2)
        
        '''

     def acos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acos:
        acos(Expr)
        Arccosine.
        See also: 1/ cos 2/ acosh 
        Ex1:acos(0)
        
        '''

     def acos2asin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acos2asin:
        acos2asin(Expr)
        Replaces arccos(x) by pi/2-arcsin(x) in the argument.
        See also: 1/ acos2atan 
        Ex1:acos2asin(acos(x)+asin(x))
        Ex2:acos2asin(2*acos(x))
        
        '''

     def acos2atan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acos2atan:
        acos2atan(Expr)
        Replaces arccos(x) by pi/2-arctan(x/sqrt(1-x^2)) in the argument.
        See also: 1/ acos2asin 
        Ex1:acos2atan(2*acos(x))
        Ex2:acos2atan(acos(sqrt(1-x^2))+acos(x))
        
        '''

     def acosh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acosh:
        acosh(Expr)
        Hyperbolic arccosine.
        See also: 1/ cosh 2/ acos 
        Ex1:acosh(1)
        
        '''

     def acot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acot:
        acot(Expr)
        Arccotangent.
        See also: 1/ atan 2/ arccos 
        Ex1:acot(0)
        
        '''

     def acsc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acsc:
        acsc(Expr)
        Arccosecant: acsc(x)=asin(1/x).
        See also: 1/ asin 2/ csc 
        Ex1:acsc(1)
        Ex2:acsc(2)
        
        '''

     def acyclic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for acyclic:
        acyclic(Opt)
        Option for the random_network command.
        See also: 1/ random_network 
        
        '''

     def adaptive(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for adaptive:
        adaptive(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def add(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for add:
        add(Expr,Var,VarMin(a),VarMax(b),[VarStep(p)])
        Discrete sum (with 2 or 4 arguments return then sum from a to b if a<=b or of the opposite of the sum from b+1 to a-1 if a>b+1 or 0 if a=b+1) or the discrete primitive or sum of the elements of a list or a sequence.
        See also: 1/ + 
        Ex1:add(1/n^2,n,1,17)
        Ex2:add(1/n^2,n=1..17)
        Ex3:add(1/n^2,n,17,1)
        Ex4:add(1/n^2,n=17..1)
        Ex5:add(1/n^2,n,17,1,1)
        Ex6:add(1/n^2,n,1,17,2)
        Ex7:add([1,2,3,4])
        Ex8:add([[1,2,3,4,5,6,7,8,9],[1,2,3,4,5,6,7,8,9]])
        Ex9:add(1/(x*(x+1)),x)
        Ex10:add(cos(n*x),n)
        
        '''

     def add_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for add_arc:
        add_arc(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Returns a modified copy of a digraph G with the arc e (or trail T or list of arcs E) added to G.
        See also: 1/ add_edge 2/ delete_arc 3/ digraph 4/ edges 5/ has_arc 6/ trail 
        Ex1:add_arc(digraph(trail(1,2,3,4,5,1)),[[1,3],[2,4]])
        
        '''

     def add_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for add_edge:
        add_edge(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Returns a modified copy of an undirected graph G with the edge e (or trail T or list of edges E) added to G.
        See also: 1/ add_arc 2/ delete_edge 3/ edges 4/ graph 5/ has_edge 6/ trail 
        Ex1:add_edge(graph(trail(1,2,3,4)),[4,1])
        
        '''

     def add_vertex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for add_vertex:
        add_vertex(Graph(G),Vrtx(v)||Lst(V))
        Returns a modified copy of G with vertex v [or vertices from list V] added to G.
        See also: 1/ add_arc 2/ add_edge 3/ delete_vertex 
        Ex1:add_vertex(cycle_graph(5),["a","b"])
        
        '''

     def additionally(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for additionally:
        additionally(Expr)
        Makes an additionally assumption on a variable.
        See also: 1/ purge 2/ about 3/ assume 
        Ex1: assume(n,integer);additionally(n>5)
        Ex2: assume(n,integer);assume(n>=2,additionally)
        
        '''

     def addtable(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for addtable:
        addtable(fourier||laplace,f(x),F(s),Var(x),Var(s))
        Stores an unknown Fourier/Laplace transform pair (f,F).
        See also: 1/ fourier 2/ laplace 
        Ex1:addtable(fourier,y(x),Y(s),x,s)
        
        '''

     def adjacency_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for adjacency_matrix:
        adjacency_matrix(Graph(G))
        Returns the adjacency matrix of G (rows and columns correspond to vertex indices).
        See also: 1/ neighbors 
        Ex1:adjacency_matrix(graph(trail(1,2,3,4,2,5,1,3)))
        
        '''

     def adjoint_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for adjoint_matrix:
        adjoint_matrix(Mtrx)
        Returns the characteristic polynomial of A and the comatrix of A-xI.
        See also: 1/ pcar 
        Ex1:adjoint_matrix([[1,i],[2,3]])
        
        '''

     def affix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for affix:
        affix(Pnt||Vect)
        Complex number equal to the affix of a point or of a vector.
        See also: 1/ point 2/ vector 
        Ex1:affix(point(i))
        Ex2:affix(point(i)-point(1+2*i))
        Ex3:affix([1,2])
        
        '''

     def algsubs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for algsubs:
        algsubs(Equal(Xpr1=Xpr2),Expr(Xpr))
        Substitutes in the expression Xpr, the algebraic expression Xpr1 by the algebraic expression Xpr2.
        See also: 1/ subst 2/ subs 
        Ex1:algsubs(x^2=u,1+x^2+x^4)
        Ex2:algsubs(a*b/c=d, 2*a*b^2/c)
        Ex3:algsubs(2a=p^2-q^2,algsubs(2c=p^2+q^2,c^2-a^2))
        
        '''

     def algvar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for algvar:
        algvar(Expr)
        List of the variables by ascending algebraic extension order.
        See also: 1/ lvar 2/ lname 
        Ex1:algvar(sqrt(x)+y)
        
        '''

     def all_trig_solutions(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for all_trig_solutions:
        all_trig_solutions(:=Intg(0 or 1))
        Pseudo-variable to return the general solution (all_trig_solutions:=1) or principal solution (all_trig_solutions:=0).
        See also: 1/ cas_setup 
        Ex1: all_trig_solutions:=1
        Ex2: all_trig_solutions:=0
        
        '''

     def allpairs_distance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for allpairs_distance:
        allpairs_distance(Graph(G))
        Returns a square matrix D of order equal to the number of vertices in G such that D(i,j) is the distance between i-th and j-th vertex of the (weighted) graph G.
        See also: 1/ dijkstra 2/ graph_diameter 3/ vertex_distance 
        Ex1:allpairs_distance(graph(%{[1,2],[1,3],[1,4],[1,5],[2,3],[3,4],[4,5],[5,2]%}))
        
        '''

     def alog10(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for alog10:
        alog10(Expr)
        Function x->10^x.
        See also: 1/ log10 
        Ex1:alog10(3)
        
        '''

     def altitude(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for altitude:
        altitude((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        altitude(A,B,C) draws the altitude through A of the triangle ABC.
        See also: 1/ perpendicular 2/ orthogonal 3/ orthocenter 4/ common_perpendicular 
        Ex1:altitude(-1,1-i,i)
        
        '''

     def angle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for angle:
        angle((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        angle(A,B,C) is the value of the measure of the angle (AB,AC).
        See also: 1/ triangle 2/ bissector 3/ legend 4/ labels 5/ angleat 6/ angleatraw 
        Ex1:angle(point(0),point(i),point(1))
        Ex2:angle(0,1,i)
        Ex3:angle(0,1,i,"")
        Ex4:angle(0,1,i,"a")
        Ex5:angle(i,1,1+i,"b")
        
        '''

     def angle_radian(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for angle_radian:
        angle_radian(:=Intg(0 or 1))
        Pseudo-variable to work with radians (angle_radian:=1) or degrees (angle_radian:=0).
        See also: 1/ cas_setup 
        Ex1: angle_radian:=1
        Ex2: angle_radian:=0
        
        '''

     def angleat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for angleat:
        angleat(Pnt(A),Pnt(B),Pnt(C),(Pnt or Cplx(z0)))
        angleat(A,B,C,z0) displays at point(z0) with a legend, the value of the measure of the angle (AB,AC).
        See also: 1/ angle 2/ angleatraw 3/ legend 
        Ex1: A:=point(0);B:=point(1);C:=point(i);angleat(A,B,C,-2-i)
        
        '''

     def angleatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for angleatraw:
        angleatraw(Pnt(A)),Pnt(B),Pnt(C),(Pnt or Cplx(z0)))
        angleatraw(A,B,C,z0) displays at point(z0), the value of the measure of the angle (AB,AC).
        See also: 1/ angle 2/ angleat 
        Ex1: A:=point(0);B:=point(1);C:=point(i);angleatraw(A,B,C,-2-i)
        
        '''

     def ans(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ans:
        ans(Intg(n))
        Returns the (n+1)th answer of the command history if n>=0 or, the (-n)th previous answer if n<0 (by default n=-1 for the previous answer).
        See also: 1/ quest 
        Ex1:ans()
        Ex2:ans(2)
        Ex3:ans(-2)
        
        '''

     def antiprism_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for antiprism_graph:
        antiprism_graph(Intg(n))
        Returns an antiprism graph of order n.
        See also: 1/ prism_graph 
        Ex1:antiprism_graph(5)
        
        '''

     def append(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for append:
        append((Lst||Set||Str(L),Elem))
        Append an element to a set or at the end of a list or of a string (L:=append(L,a) or L.append(a)).
        See also: 1/ concat 2/ prepend 
        Ex1:append([1,2,4],6)
        Ex2:append(%{1,2,4%},6)
        Ex3: L:=[1,2,4];L:=append(L,6)
        Ex4: L:=[1,2,4];L.append(6)
        Ex5: S:=set[1,2,4];S:=append(S,6)
        Ex6: S:=set[1,2,4];S.append(6)
        
        '''

     def apply(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for apply:
        apply(Fnc(f),Lst(l))
        Applies the function f at the elements of the list l (option matrix for a matrix).
        See also: 1/ map 2/ unapply 3/ matrix 
        Ex1:apply(x->x^3,[1,2,3])
        Ex2:apply(x->x+1,[[1,2,3],[1,2,3]],matrix)
        
        '''

     def approx(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for approx:
        approx(Expr,[Int])
        Numerical evaluation of the first argument (we can give the number of digits as second argument).
        See also: 1/ evalb 2/ eval 
        Ex1:approx(2/3)
        Ex2:approx(2/3,2)
        Ex3:approx(2*sin(1))
        Ex4:approx(2*sin(1),40)
        Ex5:approx(sqrt(2)+pi)
        Ex6:approx(sqrt(2)+pi,30)
        
        '''

     def arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arc:
        arc(Pnt, Pnt, Real,[Var(C)],[Var(r)],[Opt(segment)])
        Draws a circular arc given by 2 vertices and the central angle [Xcas will put the center in C and the radius in r].
        See also: 1/ circle 2/ segment 3/ plotparam 
        Ex1:arc(0,1,pi/4)
        Ex2:arc(i,1,pi/4,C,r)
        Ex3:arc(i,1,pi/4,segment)
        Ex4:arc(i,1,pi/4,segment,affichage=1+rempli)
        
        '''

     def arcLen(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arcLen:
        arcLen(Expr(Xpr) or Lst([Xpr1,Xpr2]),Var,Real(a),Real(b))
        Returns the length of the arc of the curve defined by y=Xpr(or by x=Xpr1,y=Xpr2) when the parameter values are between a and b.
        See also: 1/ int 
        Ex1:arcLen(t^2,t,1,2)
        Ex2:arcLen([t,t^2],t,1,2)
        Ex3:arcLen([cos(t),sin(t)],t,1,2)
        
        '''

     def arccos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arccos:
        arccos(Expr)
        Arccosine.
        See also: 1/ cos 2/ acosh 
        Ex1:arccos(0)
        
        '''

     def arccosh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arccosh:
        arccosh(Expr)
        Hyperbolic arccosine.
        See also: 1/ cosh 2/ acos 
        Ex1:arccosh(1)
        
        '''

     def arclen(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arclen:
        arclen(Expr(Xpr) or Lst([Xpr1,Xpr2]),Var,Real(a),Real(b))
        Returns the length of the arc of the curve defined by y=Xpr(or by x=Xpr1,y=Xpr2) when the parameter values are between a and b.
        See also: 1/ int 
        Ex1:arclen(t^2,t,1,2)
        Ex2:arclen([t,t^2],t,1,2)
        Ex3:arclen([cos(t),sin(t)],t,1,2)
        
        '''

     def arcsin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arcsin:
        arcsin(Expr)
        Arcsine.
        See also: 1/ sin 
        Ex1:arcsin(0)
        
        '''

     def arcsinh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arcsinh:
        arcsinh(Expr)
        Hyperbolic arcsine.
        See also: 1/ sinh 2/ asin 
        Ex1:arcsinh(0)
        
        '''

     def arctan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arctan:
        arctan(Expr)
        Arctangent.
        See also: 1/ tan 2/ atanh 
        Ex1:arctan(0)
        
        '''

     def arctanh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arctanh:
        arctanh(Expr)
        Hyperbolic arctangent.
        See also: 1/ atan 2/ tanh 
        Ex1:arctanh(0)
        
        '''

     def area(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for area:
        area(Polygone || Expr,x=a..b,[n],[Method])
        Algebraic area of a circle, a circular arc or of a (star) polygon (e.g. triangle, square, ...) or of the area below a curve, optionally with a quadrature method (trapezoid,left_rectangle,right_rectangle,middle_point,simpson,rombergt,rombergm).
        See also: 1/ trapezoid 2/ perimeter 3/ areaatraw 4/ areaat 5/ areaplot 
        Ex1:area(triangle(0,1,i))
        Ex2:area(square(0,2))
        Ex3:area(circle(0,2))
        Ex4:area(0,1,i)
        Ex5:area(x^2,x=0..1,5,trapezoid)
        Ex6:area(x^2,x=0..1,5,simpson)
        Ex7:area(x^2,x=0..1,5,rombergm)
        
        '''

     def areaat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for areaat:
        areaat(Polygone, Pnt||Cplx(z0))
        Displays at point(z0), with a legend, the algebraic area of a circle or of a (star) polygon (e.g. triangle, square, ...)
        See also: 1/ area 2/ areaatraw 3/ polygon 4/ perimeteratraw 5/ areaplot 
        Ex1: t:=triangle(0,1,i);areaat(t,(1+i)/2)
        Ex2: c:=square(0,2);areaat(c,1+i)
        Ex3: c2:=circle(0,2);areaat(c2,1+i)
        Ex4: p:=polygon(0,1,i);areaat(p,1+i)
        Ex5: A:=point(0);B:=point(1+i);c:=carre(A,B);areaat(c,i)
        
        '''

     def areaatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for areaatraw:
        areaatraw(Polygone, Pnt||Cplx(z0))
        Displays at point(z0), the algebraic area of a circle or of a (star-)polygon (e.g. triangle, square, ...)
        See also: 1/ area 2/ areaat 3/ polygon 4/ perimeteratraw 5/ areaplot 
        Ex1:areaatraw(triangle(0,1,i),(1+i)/2)
        Ex2:areaatraw(square(0,2),1+i)
        Ex3:areaatraw(circle(0,2),1+i)
        Ex4:areaatraw(polygon(0,1,i),1+i)
        Ex5: A:=point(0);B:=point(1+i);c:=carre(A,B);areaatraw(c,i)
        
        '''

     def areaplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for areaplot:
        areaplot(Expr,x=a..b,[n],[Method])
        Displays the area below a curve, optionally with a quadrature method (trapezoid,left_rectangle,right_rectangle,middle_point).
        See also: 1/ integrate 2/ plot 3/ area 4/ areaat 5/ areaatraw 
        Ex1:areaplot(sin(x),x=0..pi)
        Ex2:areaplot(x^2,x=0..1,5,trapezoid)
        Ex3:areaplot(x^2,x=0..1,5,middle_point)
        
        '''

     def arg(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arg:
        arg(Expr)
        Returns the argument of a complex number.
        See also: 1/ abs 
        Ex1:arg(1+i)
        Ex2:arg(1+2*i)
        Ex3:arg((1+2*i)^2)
        
        '''

     def array(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for array:
        array(Opt)
        Option for convert for definitions of sparse matrices.
        See also: 1/ convert 2/ table 
        Ex1: A[0..2,0..2]:=1;A[0..1,1..2]:=2;convert(A,array)
        Ex2: B[0..1,1..2]:=1;B[2,2]:=2;convert(B,array)
        
        '''

     def arrivals(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for arrivals:
        arrivals(Graph(G),[Vrtx(v)])
        Returns the list of vertices in a digraph G which are connected to v with arcs pointing to v. If v is omitted, the list of arrivals is computed for every vertex in G.
        See also: 1/ in_degree 
        Ex1:arrivals(digraph(%{[1,2],[1,3],[2,3]%}),1)
        
        '''

     def articulation_points(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for articulation_points:
        articulation_points(Graph(G))
        Returns the list of articulation points (cut vertices) in G.
        See also: 1/ biconnected_components 2/ is_biconnected 3/ is_connected 4/ is_triconnected 
        Ex1:articulation_points(path_graph(5))
        Ex2:articulation_points(cycle_graph(5))
        
        '''

     def asin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for asin:
        asin(Expr)
        Arcsine.
        See also: 1/ sin 
        Ex1:asin(0)
        
        '''

     def asin2acos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for asin2acos:
        asin2acos(Expr)
        Replaces arcsin(x) by pi/2-arccos(x) in the argument.
        See also: 1/ asin2atan 
        Ex1:asin2acos(acos(x)+asin(x))
        Ex2:asin2acos(2*asin(x))
        
        '''

     def asin2atan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for asin2atan:
        asin2atan(Expr)
        Replaces arcsin(x) by arctan(x/sqrt(1-x^2)) in the argument.
        See also: 1/ asin2acos 
        Ex1:asin2atan(2*asin(x))
        Ex2:asin2atan(asin(sqrt(1-x^2))+asin(x))
        
        '''

     def asinh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for asinh:
        asinh(Expr)
        Hyperbolic arcsine.
        See also: 1/ sinh 2/ asin 
        Ex1:asinh(0)
        
        '''

     def assign_edge_weights(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for assign_edge_weights:
        assign_edge_weights(Graph(G),Seq(m,n)||Intrv(a..b))
        Assigns random edge weights to the edges in G and returns a modified copy of G. If integers n and m such that n>=m are specified, then the weights are integers randomly chosen in [m,n]. If an interval a..b is specified, then the weights are uniformly distributed in the interval [a,b).
        See also: 1/ set_edge_weight 2/ get_edge_weight 3/ weight_matrix 4/ random_digraph 5/ random_tournament 
        Ex1:assign_edge_weights(digraph(trail(1,2,3,4,1)),1,9)
        Ex2:assign_edge_weights(digraph(trail(1,2,3,4,1)),0..1)
        
        '''

     def assume(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for assume:
        assume(Expr)
        Makes an assumption on a variable.
        See also: 1/ purge 2/ about 3/ additionally 
        Ex1:assume(a>0)
        Ex2:assume(a=0.3)
        Ex3:assume(a:=[pi/4,0,pi/2])
        Ex4:assume(a:=[pi/4,0,pi/2,0.1])
        Ex5:assume(n,integer);
        Ex6:assume(n,integer);additionally(n>6)
        Ex7:assume(a>-10 and a<10)
        Ex8:assume((a>=2 and a<4) or a>6)
        Ex9:assume(a>=2);additionally(a<6)
        Ex10:assume(a)
        
        '''

     def at(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for at:
        at(Lst(l)||Mtrx(m),Index(j)||Lst([j,k]))
        at(l,j) (or at(m,[j,k])) is the element of the list l (or matrix m) for index=j (or for index j,k).
        See also: 1/ of 
        Ex1:at([10,11,12],1)
        Ex2:at([[1,2],[3,4]],[1,0])
        
        '''

     def atan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for atan:
        atan(Expr)
        Arctangent.
        See also: 1/ tan 2/ atanh 
        Ex1:atan(0)
        
        '''

     def atan2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for atan2:
        atan2(Real(y),Real(x))
        Returns the four-quadrant inverse tangent of real numbers y and x.
        See also: 1/ tan 2/ atan 
        Ex1:atan2(-1/2,-sqrt(3)/2)
        
        '''

     def atan2acos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for atan2acos:
        atan2acos(Expr)
        Replaces arctan(x) by pi/2-arccos(x/sqrt(1+x^2)) in the argument.
        See also: 1/ atan2acos(atan(x)) 
        
        '''

     def atan2asin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for atan2asin:
        atan2asin(Expr)
        Replaces arctan(x) by arcsin(x/sqrt(1+x^2)) in the argument.
        See also: 1/ atan2asin(atan(x)) 
        
        '''

     def atanh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for atanh:
        atanh(Expr)
        Hyperbolic arctangent.
        See also: 1/ atan 2/ tanh 
        Ex1:atanh(0)
        
        '''

     def atrig2ln(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for atrig2ln:
        atrig2ln(Expr)
        Rewrites the expression containing inverse trigonometric functions into logarithmic functions.
        See also: 1/ trig2exp 2/ exp2trig 
        Ex1:atrig2ln(atan(x))
        Ex2:atrig2ln(asin(x))
        Ex3:atrig2ln(acos(x))
        
        '''

     def augment(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for augment:
        augment(Lst,Lst||Seq,Seq||Str,Str||Mtrx,Mtrx)
        Concatenates two lists or two strings or two sequences or 2 matrices; L:=concat(L,L1) or L.concat(L1).
        See also: 1/ append 2/ cat 3/ semi_augment 4/ border 5/ + 
        Ex1:augment([1,2],[3,4,5])
        Ex2:augment("bon","jour")
        Ex3:augment([[1,2],[3,4]],[[4,5,6],[6,7,8]])
        Ex4: L:=[1,2];L.concat([3,4,5])
        Ex5: S:="abcd";S.concat("efghi")
        
        '''

     def auto_correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for auto_correlation:
        auto_correlation(Lst)
        Returns the cross-correlation of the given signal with itself.
        See also: 1/ cross_correlation 2/ correlation 
        Ex1:auto_correlation([1,-1,0,2,1])
        
        '''

     def autosimplify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for autosimplify:
        autosimplify(Cmds)
        The argument is a command that Xcas will use to rewrite answers (initial value is regroup and for no simplification it is nop or 0).
        See also: 1/ simplify 2/ factor 3/ regroup 
        Ex1:autosimplify(nop)
        Ex2:autosimplify(0)
        Ex3:autosimplify(regroup)
        Ex4:autosimplify(1)
        Ex5:autosimplify(factor)
        Ex6:autosimplify(simplify)
        
        '''

     def avance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for avance:
        avance(NULL or Real(n))
        The turtle takes n steps forward (by default n=10).
        See also: 1/ recule 2/ saute 
        Ex1: avance 30
        Ex2:avance(30)
        
        '''

     def avgRC(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for avgRC:
        avgRC(Expr(Xpr),Var(Var),[Real(h)])
        Returns (Xpr(var+h)-Xpr(Var))/h (by default h=0.001).
        See also: 1/ nDeriv 
        Ex1:avgRC(f(x),x,h)
        Ex2:avgRC(x^2,x,0.1)
        Ex3:avgRC(x^2,x)
        
        '''

     def axes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for axes:
        axes(Opt)
        Global option (Maple compatibility) of a graphic command to put or not the axes.
        See also: 1/ line_width 2/ gl_showaxes 3/ switch_axes 
        Ex1: axes=0;segment(0,point(1,1))
        Ex2: axes=1;segment(0,point(1,1),epaisseur=5)
        
        '''

     def axis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for axis:
        axis(xmin,xmax,ymin,ymax,[zmin,zmaz])
        Defines the graphic display
        Ex1:axis(-2,4,-1,6)
        
        '''

     def back(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for back:
        back(Vect or Seq or Str)
        Returns the last element of a vector or a sequence or a string.
        See also: 1/ inter 2/ head 3/ mid 4/ left 5/ right 
        Ex1:back(1,2,3)
        Ex2:back([1,2,3])
        Ex3:back("bonjour")
        
        '''

     def backward(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for backward:
        backward(NULL or Real(n))
        The turtle takes n steps back (by default n=10).
        See also: 1/ avance 2/ saute 
        Ex1: recule 30
        Ex2:backward(30)
        
        '''

     def baisse_crayon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for baisse_crayon:
        baisse_crayon(NULL)
        Presses the pencil down so that the turtle move with traces.
        See also: 1/ leve_crayon 2/ crayon 
        Ex1:baisse_crayon()
        
        '''

     def bandwidth(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bandwidth:
        bandwidth(Opt)
        Option for the kernel_density command.
        See also: 1/ kernel_density 2/ bins 
        
        '''

     def bar_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bar_plot:
        bar_plot(Mtrx)
        Draws a barplot of a one variable statistical series.
        See also: 1/ camembert 2/ histogram 3/ frequencies 
        Ex1:bar_plot([["France",6],["Allemagne",12],["Suisse",5]])
        Ex2:bar_plot([3/2,2/3,5/4,4/5,7/6,6/7,9/8,8/9,11/10])
        Ex3:bar_plot([[2,"xyz","abc"],["A",2,5],["B",5,6],["C",7,7]])
        
        '''

     def barplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for barplot:
        barplot(Mtrx)
        Draws a barplot of a one variable statistical series.
        See also: 1/ camembert 2/ histogram 3/ frequencies 
        Ex1:barplot([["France",6],["Allemagne",12],["Suisse",5]])
        Ex2:barplot([3/2,2/3,5/4,4/5,7/6,6/7,9/8,8/9,11/10])
        Ex3:barplot([[2,"xyz","abc"],["A",2,5],["B",5,6],["C",7,7]])
        
        '''

     def bartlett_hann_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bartlett_hann_window:
        bartlett_hann_window(Lst,[Interval(n1..n2)])
        Applies the Bartlett-Hann windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(bartlett_hann_window(randvector(1000,0..1)))
        
        '''

     def barycenter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for barycenter:
        barycenter([Pnt,Real],[Pnt,Real],[Pnt,Real])
        barycenter([point1,coeff1],...) draws the barycenter of point1 with weight coeff1...
        See also: 1/ isobarycenter 2/ midpoint 
        Ex1:barycenter([point(-1),1],[point(1+i),2],[point(1-i),1])
        Ex2:barycenter([[point(-1),1],[point(1+i),2],[point(1-i),1]])
        Ex3:barycenter([point(-1),point(1+i),point(1-i)],[1,2,1])
        
        '''

     def base(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for base:
        base(Opt)
        Option for convert : convert(p,base,b)= [a0,a1,..an] or convert([a0,a1,..an],base,b)=p with p=a0+a1*b+....an*b^(n-1).
        See also: 1/ convert 2/ horner 3/ revlist 
        Ex1: convert(123,base,8)
        Ex2: convert([3,7,1],base,8)
        Ex3: horner(revlist([3,7,1]),8)
        
        '''

     def basis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for basis:
        basis(Lst(vector1,..,vectorn))
        Extracts a basis from a spanning set of vectors.
        See also: 1/ ker 2/ ibasis 
        Ex1:basis([[1,2,3],[4,5,6],[7,8,9],[10,11,12]])
        
        '''

     def batons(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for batons:
        batons(Mtrx)
        Draws for k=0..nrows, the segments (xk,0)-(xk,yk) where xk=element row k column 0 and yk=element row k column j (j=1..ncols).
        See also: 1/ polygonplot 2/ scatterplot 3/ listplot 
        Ex1:batons([1,3],[2,5],[3,2])
        Ex2:batons([[1,3],[2,5],[3,2]])
        Ex3:batons([1,2,3],[3,5,2])
        
        '''

     def bellman_ford(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bellman_ford:
        bellman_ford(Graph(G),Vrtx(s),Vrtx(t)||Lst(T))
        Returns the length of the shortest path resp. of the shortest paths from s to vertex t resp. vertices in T in weighted graph G.
        See also: 1/ dijkstra 2/ shortest_path 
        Ex1:bellman_ford(graph(%{[[1,2],-1],[[2,3],-3],[[3,4],-7],[[4,5],-3],[[5,6],-3],[[1,6],-3]%}),1,4)
        
        '''

     def berlekamp_massey(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for berlekamp_massey:
        berlekamp_massey(Vect(v))
        If v=[v_0 ... v_(2n-1)], returns [b_n,...,b_0] such that b_n*v_{n+k}+...+b_0*v_k=0 for k=0..n-1.
        See also: 1/ rsolve 
        Ex1:berlekamp_massey([1,-1,3,3])
        
        '''

     def bernoulli(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bernoulli:
        bernoulli(Intg||(Intg,Var))
        bernoulli(n) is the n-th number of Bernoulli and bernoulli(n,x) is the n-th polynomial of Bernoulli and the second argument is the variable.
        See also: 1/  
        Ex1:bernoulli(6)
        Ex2:bernoulli(6,x)
        
        '''

     def bernoulli_mod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bernoulli_mod:
        bernoulli_mod(Intg,Intg)
        bernoulli_mod(k,p) returns for k even integer and p prime the k-th Bernoulli number mod p
        Ex1:bernoulli_mod(1234,10^6+3)
        
        '''

     def besselJ(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for besselJ:
        besselJ(Real(x),Int(p))
        besselJ(x,p) returns the Bessel function of the first kind Jp(x).
        See also: 1/ BesselJ 2/ BesselY 3/ besselY 
        Ex1:besselJ(sqrt(2),2)
        Ex2:besselJ(sqrt(2),-2)
        
        '''

     def besselY(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for besselY:
        besselY(Real(x),Int(p))
        besselY(x,p) returns the Bessel function of the second kind Yp(x).
        See also: 1/ BesselY 2/ BesselJ 3/ besselJ 
        Ex1:besselY(sqrt(2),2)
        Ex2:besselY(sqrt(2),-2)
        
        '''

     def betad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for betad:
        betad(Real(a>0),Real(b>0),Real(0<=x<=1))
        Returns the probability density of the Beta law (=Gamma(a+b)*x^(a-1)*(1-x)^(b-1)/(Gamma(a)*Gamma(b))).
        See also: 1/ betad_cdf 2/ betad_icdf 
        Ex1:betad(2.2,1.5,0.8)
        
        '''

     def betad_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for betad_cdf:
        betad_cdf(Real(a>0),Real(b>0),Real(0<=x0<=1),[Real(0<=y0<=1)])
        Returns the probability that a Beta random variable (with a and b as parameters) is less than x0 or between x0 and y0.
        See also: 1/ betad 2/ betad_icdf 
        Ex1:betad_cdf(2,1,0.2)
        Ex2:betad_cdf(2,1,0.1,0.3)
        
        '''

     def betad_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for betad_icdf:
        betad_icdf(Real(a>0),Real(b>0),Real(0<=p<=1))
        Returns h such that the probability that a Beta random variable is less than h is p (0<=p<=1).
        See also: 1/ betad_cdf 2/ betad 
        Ex1:betad_icdf(2,1,0.95)
        Ex2:betad_icdf(2,1,0.5)
        
        '''

     def betavariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for betavariate:
        betavariate(Real(a),Real(b))
        Returns a random real according to the Beta distribution with parameters a>0 and b>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:betavariate(1,2)
        Ex2:betavariate(1.5,4)
        
        '''

     def betweenness_centrality(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for betweenness_centrality:
        betweenness_centrality(Graph(G),[Vrtx(v)])
        Returns the betweenness centrality of a vertex v in a graph G or the list of betweenness centralities of vertices in G.
        See also: 1/ degree_centrality 2/ closeness_centrality 3/ harmonic_centrality 4/ information_centrality 5/ katz_centrality 
        Ex1:betweenness_centrality(graph(6,%{[0,2],[0,5],[1,3],[1,5],[2,5],[3,4],[3,5],[4,5]%}))
        
        '''

     def bezier(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bezier:
        bezier(Lst,[plot])
        Bezier curve defined by control points.
        See also: 1/ parameq 
        Ex1:bezier(1,1+i,2+i,3-i,plot)
        Ex2:bezier(point([0,0,0]),point([1,1,0]),point([0,1,1]),plot)
        Ex3: parameq(bezier(1,1+i,2+i,3-i))
        Ex4: parameq(bezier(point([0,0,0]),point([1,1,0]),point([0,1,1])))
        
        '''

     def bezout_entiers(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bezout_entiers:
        bezout_entiers(Intg,Intg)
        Extended greatest common divisor of 2 integers.
        See also: 1/ gcd 2/ iabcuv 3/ egcd 
        Ex1:bezout_entiers(45,75)
        Ex2:bezout_entiers(21,28)
        Ex3:bezout_entiers(30,49)
        
        '''

     def bezoutian(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bezoutian:
        bezoutian(Poly,Poly)
        Bezoutian matrix of 2 polynomials
        Ex1:bezoutian(5x^3-x,3x^2+1)
        
        '''

     def biconnected_components(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for biconnected_components:
        biconnected_components(Graph(G))
        Returns a list of lists of vertices, each sublist representing a biconnected component of G.
        See also: 1/ articulation_points 2/ is_biconnected 3/ is_connected 4/ trail 
        Ex1:biconnected_components(graph(trail(1,2,3,4,2),trail(4,5,6,7,5)))
        
        '''

     def binomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for binomial:
        binomial(Intg(n),Intg(k),[Real(p in 0..1)])
        Returns comb(n,k)*p^k*(1-p)^(n-k) or comb(n,k) if no 3rd argument.
        See also: 1/ binomial_cdf 2/ binomial_icdf 3/ multinomial 4/ randvector 5/ ranm 
        Ex1:binomial(4,2)
        Ex2:binomial(4,0,0.5)
        Ex3:binomial(4,2,0.5)
        Ex4: assume(p>=0 and p<=1);binomial(4,2,p)
        Ex5: assume(p>=0 and p<=1);binomial(4,p,2)
        Ex6: randvector(6,binomial,4,0.2)
        Ex7: ranm(4,6,binomial,4,0.7)
        
        '''

     def binomial_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for binomial_cdf:
        binomial_cdf(Intg(n),Real(p),Real(x),[Real(y)])
        Returns Proba(X<=x) or Proba(x<=X<=y) when X follows the B(n,p) law.
        See also: 1/ binomial 2/ binomial_icdf 
        Ex1:binomial_cdf(4,0.5,2)
        Ex2:binomial_cdf(4,0.1,2)
        Ex3:binomial_cdf(4,0.5,2,3)
        
        '''

     def binomial_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for binomial_icdf:
        binomial_icdf(Intg(n),Real(p),Real(t))
        Returns h such as Proba(X<=h)=t when X follows the B(n,p) law.
        See also: 1/ binomial 2/ binomial_cdf 
        Ex1:binomial_icdf(4,0.5,0.68)
        Ex2:binomial_icdf(4,0.1,0.95)
        
        '''

     def bins(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bins:
        bins(Opt)
        Option for the kernel_density command.
        See also: 1/ kernel_density 2/ bandwidth 
        
        '''

     def bipartite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bipartite:
        bipartite(Opt)
        Option for the draw_graph command
        See also: 1/ draw_graph 
        
        '''

     def bipartite_matching(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bipartite_matching:
        bipartite_matching(Graph(G,[maximize||minimize,[epsilon=Real(eps)]]))
        Returns the list of edges in a maximum matching of an undirected bipartite graph G. If G is weighted, output either minimum or maximum weighted matching, depending on the second attribute.
        See also: 1/ is_bipartite 2/ maximum_matching 
        Ex1:bipartite_matching(graph("desargues"))
        
        '''

     def bisection_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bisection_solver:
        bisection_solver(Opt)
        Argument for fsolve giving the method for solving a numerical equation.
        See also: 1/ fsolve 
        Ex1: fsolve(cos(x)=x,x,0..1,bisection_solver)
        Ex2: fsolve(cos(x)=x,x,0..1,brent_solver)
        Ex3: fsolve(cos(x)=x,x,0..1,falsepos_solver)
        Ex4: fsolve(cos(x)=x,x,0,newton_solver)
        Ex5: fsolve(cos(x)=x,x,0,secant_solver)
        Ex6: fsolve(cos(x)=x,x,0,steffenson_solver)
        
        '''

     def bisector(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bisector:
        bisector((Pnt(A) or Cplx),(Pnt(B) or Cplx),(Pnt(C) or Cplx))
        Draws the bisector of the angle (AB,AC) given by 3 points A,B,C.
        See also: 1/ angle 2/ exbisector 
        Ex1:bisector(0,1,i)
        
        '''

     def bit_depth(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bit_depth:
        bit_depth(Audio(clip)||Image(img))
        Returns the bit depth of an audio clip or image object.
        See also: 1/ channels 2/ channel_data 3/ duration 4/ samplerate 
        Ex1:bit_depth(readwav("/some/file"))
        
        '''

     def bitand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bitand:
        bitand(Intg,Intg)
        Logical bit and.
        See also: 1/ bitxor 2/ bitor 
        Ex1:bitand(0x12,0x38)
        
        '''

     def bitor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bitor:
        bitor(Intg,Intg)
        Inclusive logical bit or.
        See also: 1/ bitxor 2/ bitand 
        Ex1:bitor(0x12,0x38)
        
        '''

     def bitxor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bitxor:
        bitxor(Intg,Intg)
        Exclusive logical bit or.
        See also: 1/ bitor 2/ bitand 
        Ex1:bitxor(0x12,0x38)
        
        '''

     def blackman_harris_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for blackman_harris_window:
        blackman_harris_window(Lst,[Interval(n1..n2)])
        Applies the Blackman-Harris windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ bartlett_hann_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(blackman_harris_window(randvector(1000,0..1)))
        
        '''

     def blackman_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for blackman_window:
        blackman_window(Lst,[Real(a)],[Interval(n1..n2)])
        Applies the Blackman windowing function with parameter a (by default a=0.16) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ bartlett_harris_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(blackman_window(randvector(1000,0..1)))
        
        '''

     def block_size(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for block_size:
        block_size(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def blockmatrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for blockmatrix:
        blockmatrix(Intg(n),Intg(m),Lst)
        Returns the matrix obtained from the list divided into n lists of dimension m.
        See also: 1/ list2mat 
        Ex1:blockmatrix(2,3,[idn(2),idn(2),idn(2),idn(2),idn(2),idn(2)])
        Ex2:blockmatrix(2,2,[idn(2),newMat(2,3),newMat(3,2),idn(3)])
        
        '''

     def bohman_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bohman_window:
        bohman_window(Lst,[Interval(n1..n2)])
        Applies the Bohman windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bartlett_hann_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(bohman_window(randvector(1000,0..1)))
        
        '''

     def border(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for border:
        border(Mtrx(A),Lst(b))
        Returns the matrix obtained by augmenting A with b as the last column, if nrows(A)=size(b), border(A,b)=tran(append(tran(A),b)).
        See also: 1/ tran 2/ append 3/ augment 
        Ex1:border([[1,2,3,4],[4,5,6,8],[7,8,9,10]],[1,3,5])
        Ex2:border([[1,2,3],[4,5,6],[7,8,9]],[1,0,1])
        
        '''

     def box_constraints(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for box_constraints:
        box_constraints(Vect(x),Mtrx(bounds))
        Converts variable bounds, given in matrix form, into interval form x=a..b,y=c..d,...
        See also: 1/ nlpsolve 2/ minimize 3/ maximize 
        Ex1:box_constraints([x,y],[[-2,2],[-5,5]])
        
        '''

     def boxcar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for boxcar:
        boxcar(Real(a),Real(b),Expr(x))
        Returns the value at x of the boxcar function corresponding to a and b.
        See also: 1/ rect 2/ Heaviside 
        Ex1:boxcar(1,2,x)
        
        '''

     def boxwhisker(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for boxwhisker:
        boxwhisker(Lst,[Lst],[x=a..b||y=a..b])
        Box and Whisker plot for a statistical series.
        See also: 1/ quartiles 
        Ex1:boxwhisker([-1,1,2,2.2,3,4,-2,5])
        Ex2:boxwhisker([1,2,3,5,10,4],x=1..2)
        Ex3:boxwhisker([1,2,3,5,10,4],[1,2,3,1,2,3])
        Ex4:boxwhisker([[6,0,1,3,4,2,5],[0,1,3,4,2,5,6],[1,3,4,2,5,6,0],[3,4,2,5,6,0,1],[4,2,5,6,0,1,3],[2,5,6,0,1,3,4]])
        
        '''

     def brent_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for brent_solver:
        brent_solver(Opt)
        Argument for fsolve giving the method for solving a numerical equation.
        See also: 1/ fsolve 
        Ex1: fsolve(cos(x)=x,x,0..1,bisection_solver)
        Ex2: fsolve(cos(x)=x,x,0..1,brent_solver)
        Ex3: fsolve(cos(x)=x,x,0..1,falsepos_solver)
        Ex4: fsolve(cos(x)=x,x,0,newton_solver)
        Ex5: fsolve(cos(x)=x,x,0,secant_solver)
        Ex6: fsolve(cos(x)=x,x,0,steffenson_solver)
        
        '''

     def brown(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for brown:
        brown(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def bspline(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bspline:
        bspline(Lst(c),[x[=Lst(t)||a..b],Intg(p)])
        Returns the B-spline of degree p (default 3) defined by control points c and optionally |c|-p+1 breakpoints t in [a,b] (default a=0, b=1).
        See also: 1/ spline 2/ bezier 
        Ex1:bspline([2i,1-2i,5-i,6-4i,8+2i,5+i],x=0..15)
        
        '''

     def bvpsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for bvpsolve:
        bvpsolve(Expr(f(x,y,y')),Lst(x=a..b,y),Lst(y(a),y(b),[y'(1)]),[options])
        Returns an approximation of the function y (and optionally of y') on the interval a..b.
        See also: 1/ odesolve 
        Ex1:bvpsolve((32+2x^3-y*diff(y(x),x))/8,[x=1..3,y],[17,43/3],20)
        Ex2:bvpsolve((x^2*diff(y(x),x)^2-9y^2+4x^6)/x^5,[x=1..2,y],[0,ln(256),1],10,output=spline)
        
        '''

     def cFactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cFactor:
        cFactor(Expr)
        Factorization of the expression in ℂ (on the Gaussian integers if there are more than 2 variables).
        See also: 1/ factor 
        Ex1:cFactor(x^2*y+y)
        Ex2:cFactor(x^2*y^2+y^2+4*x^2+4)
        Ex3:cFactor(x^2*y^2+y^2+2*x^2+2)
        
        '''

     def cSolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cSolve:
        cSolve(LstEq,LstVar)
        Returns the list of complex solutions of an equation or a matrix where the rows are ℂ-solutions of a system of polynomial equations.
        See also: 1/ cZeros 2/ solve 3/ fslove 
        Ex1:cSolve(x^4-1,x)
        Ex2:cSolve(x^4-y^4 and x+y=2,[x,y])
        Ex3:cSolve(x^4-y^4 and x+y=0 and x^2=2*x,[x,y])
        Ex4:cSolve(u*v-u=v and v^2=u,[u,v])
        
        '''

     def cZeros(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cZeros:
        cZeros(Expr(Xpr)||LstExpr, [Var||LstVar])
        Returns the list of complex solutions of Xpr=0 or the matrix where the rows are the solutions of the system : Xpr1=0,Xpr2=0...
        See also: 1/ solve 
        Ex1:cZeros(x^2-1)
        Ex2:cZeros([x^2-1,x^2-y^2],[x,y])
        
        '''

     def camembert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for camembert:
        camembert(Mtrx)
        Draws pie chart of a one variable statistical series.
        See also: 1/ bar_plot 
        Ex1:camembert([["France",6],["Allemagne",12],["Suisse",5]])
        Ex2:camembert([3/2,2/3,5/4,4/5,7/6,6/7,9/8,8/9,11/10])
        Ex3:camembert([[2,"xyz","abc"],["A",2,5],["B",5,6],["C",7,7]])
        
        '''

     def canonical_form(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for canonical_form:
        canonical_form(Trinom(a*x^2+b*x+c),[Var])
        Canonical_form of a 2nd degree polynomial.
        See also: 1/  
        Ex1:canonical_form(2*x^2-12*x+1)
        Ex2:canonical_form(2*a^2-12*a+1,a)
        
        '''

     def canonical_labeling(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for canonical_labeling:
        canonical_labeling(Graph(G))
        Returns the canonical labeling of G as a permutation.
        See also: 1/ isomorphic_copy 2/ relabel_vertices 
        Ex1:canonical_labeling(graph("petersen"))
        
        '''

     def cartesian_product(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cartesian_product:
        cartesian_product(Seq(G1,G2,..))
        Returns the Cartesian product of graphs G1, G2, ... with vertices labeled as "u:v:..." where u, v, ... are vertices from G1, G2, ..., respectively.
        See also: 1/ tensor_product 
        Ex1:cartesian_product(graph(trail(1,2,3,4,5,2)),star_graph(3))
        
        '''

     def cauchy(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cauchy:
        cauchy(Real(x0),Real(a),Real(x))
        Returns the density of probability at x of the Cauchy law with parameters x0 and a (by default x0=0 and a=1).
        See also: 1/ cauchy_cdf 2/ cauchy_icdf 
        Ex1:cauchy(0.0,2.0,1.0)
        
        '''

     def cauchy_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cauchy_cdf:
        cauchy_cdf(Real(x0),Real(a),Real(x),[Real(y)])
        Returns the probability that a Cauchy random variable is less than x.
        See also: 1/ cauchyd 2/ cauchy_icdf 
        Ex1:cauchy_cdf(0.0,2.0,2.1)
        Ex2:cauchy_cdf(2,3,-1.9,1.4)
        
        '''

     def cauchy_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cauchy_icdf:
        cauchy_icdf(Real(x0),Real(a),Real(p))
        Returns h such that the probability that a Cauchy random variable is less than h is p (0<=p<=1).
        See also: 1/ cauchy_cdf 2/ cauchy 
        Ex1:cauchy_icdf(0.0,2.0,0.95)
        
        '''

     def cauchyd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cauchyd:
        cauchyd(Real(x0),Real(a),Real(x))
        Returns the density of probability at x of the Cauchy law with parameters x0 and a (by default x0=0 and a=1).
        See also: 1/ cauchy_cdf 2/ cauchy_icdf 
        Ex1:cauchyd(0.0,2.0,1.0)
        
        '''

     def cauchyd_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cauchyd_cdf:
        cauchyd_cdf(Real(x0),Real(a),Real(x),[Real(y)])
        Returns the probability that a Cauchy random variable is less than x.
        See also: 1/ cauchyd 2/ cauchy_icdf 
        Ex1:cauchyd_cdf(0.0,2.0,2.1)
        Ex2:cauchyd_cdf(2,3,-1.9,1.4)
        
        '''

     def cauchyd_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cauchyd_icdf:
        cauchyd_icdf(Real(x0),Real(a),Real(p))
        Returns h such that the probability that a Cauchy random variable is less than h is p (0<=p<=1).
        See also: 1/ cauchy_cdf 2/ cauchy 
        Ex1:cauchyd_icdf(0.0,2.0,0.95)
        
        '''

     def cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cdf:
        cdf(Func,FuncParams)
        Cumulative distribution function.
        See also: 1/ icdf 2/ binomial_cdf 3/ normald_cdf 4/ plotcdf 
        Ex1:cdf(binomial,10,0.5,4)
        Ex2:cdf(normald,0.0,1.0,2.0)
        Ex3:cdf([1,3,4,3,5,6],4)
        Ex4:cdf([1,3,4,3,5,6],plot)
        
        '''

     def ceil(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ceil:
        ceil(Real or Cplx)
        Returns the smallest integer >= to the argument.
        See also: 1/ floor 2/ round 
        Ex1:ceil(-4.2)
        Ex2:ceil(4.3+2.4*i)
        
        '''

     def ceiling(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ceiling:
        ceiling(Real or Cplx)
        Returns the smallest integer >= to the argument.
        See also: 1/ floor 2/ round 
        Ex1:ceiling(-4.2)
        Ex2:ceiling(4.3+2.4*i)
        
        '''

     def center(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for center:
        center(Crcle)
        Returns the center of a circle or sphere. For ellipse or hyperbola, returns center, one focus and a point on the conic. For a parabola, returns focus and vertex.
        See also: 1/ circle 2/ radius 
        Ex1:center(circle(1+i,2))
        Ex2:center(circumcircle(0,1,1+i))
        
        '''

     def center2interval(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for center2interval:
        center2interval(LstVal(l),[Real(a0)])
        Returns the list of intervals beginning with a0 and with l as centers.
        See also: 1/ interval2center 
        Ex1:center2interval([2,5,9],1)
        Ex2:center2interval([2,5,8])
        
        '''

     def centered_cube(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for centered_cube:
        centered_cube(Pnt(A),Pnt(B),Pnt(C))
        Draws the direct cube with center A, vertex B and such that the plane ABC contains an axis of symmetry of the cube.
        See also: 1/ parallelepiped 2/ cube 3/ icosahedron 4/ dodecahedron 5/ octahedron 6/ centered_tetrahedron 
        Ex1:centered_cube([0,0,0],[3,0,0],[0,0,1])
        Ex2:centered_cube(evalf([0,0,0],[3,2,4],[1,1,0]))
        
        '''

     def centered_tetrahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for centered_tetrahedron:
        centered_tetrahedron(Pnt(A),Pnt(B),Pnt(C))
        Draws the regular direct pyramid with center A, vertex B and a vertex in the plane (A,B,C).
        See also: 1/ cube 2/ tetrahedron 3/ icosahedron 4/ dodecahedron 5/ octahedron 
        Ex1:centered_tetrahedron([0,0,0],[3,0,0],[0,1,0])
        Ex2:centered_tetrahedron(evalf([0,0,0],[3,2,4],[1,1,0]))
        
        '''

     def cfactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cfactor:
        cfactor(Expr)
        Factorization of the expression in ℂ (on the Gaussian integers if there are more than 2 variables).
        See also: 1/ factor 
        Ex1:cfactor(x^2*y+y)
        Ex2:cfactor(x^2*y^2+y^2+4*x^2+4)
        Ex3:cfactor(x^2*y^2+y^2+2*x^2+2)
        
        '''

     def cfsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cfsolve:
        cfsolve(Expr,Var,[Guess or Interval],[Method])
        Numerical solution of an equation or a system of equations on ℂ.
        See also: 1/ fsolve 2/ nSolve 3/ csolve 4/ solve 
        Ex1:cfsolve(cos(x)=2)
        Ex2:cfsolve([x^2+y+2,x+y^2+2],[x,y])
        
        '''

     def changebase(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for changebase:
        changebase(Mtrx(A),Mtrx(P))
        Returns the matrix B=inv(P)*A*P.
        See also: 1/  
        Ex1:changebase([[1,2],[1,3]],[[1,1],[0,1]])
        Ex2:changebase([[1,2],[1,3]],[[1,0],[1,1]])
        
        '''

     def channel_data(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for channel_data:
        channel_data(Audio(clip),[Intg(chn) or matrix],[range=a..b]||Image(img),Intg(chn),Intg(x),Intg(y),Intg(width),Intg(height))
        Extracts the data from an audio clip (optionally specifying the channel and range) or image object (by specifying a rectangular portion).
        See also: 1/ set_channel_data 2/ channels 
        Ex1:channel_data(readwav("/some/file"))
        Ex2:channel_data(readwav("/some/file"),matrix)
        Ex3:channel_data(readwav("/some/file"),2)
        Ex4:channel_data(readwav("/some/file"),matrix,range=1.0..2.5)
        
        '''

     def channels(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for channels:
        channels(Audio(clip)||Image(img))
        Returns the number of channels in an audio clip or image object.
        See also: 1/ bit_depth 2/ channel_data 3/ duration 4/ samplerate 
        Ex1:channels(readwav("/some/file"))
        
        '''

     def char(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for char:
        char(Intg or Lst(Intg))
        Returns the string corresponding to the character code of the argument.
        See also: 1/ asc 2/ ord 
        Ex1:char(65)
        Ex2:char([65,66,67])
        
        '''

     def charpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for charpoly:
        charpoly(Mtrx,[Var])
        List of the coefficients of the characteristic polynomial of a matrix or characteristic polynomial of a matrix with the second argument as variable.
        See also: 1/ jordan 2/ egv 3/ egvl 4/ companion 5/ rat_jordan 6/ pmin 7/ adjoint_matrix  
        Ex1:charpoly([[1,2],[3,4]])
        Ex2:charpoly([[1,2],[3,4]],x)
        Ex3:charpoly([[1,2,3],[1,3,6],[2,5,7]])
        Ex4:charpoly([[1,2,3],[1,3,6],[2,5,7]],z)
        
        '''

     def chinrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chinrem:
        chinrem([Lst||Expr,Lst||Expr],[Lst||Expr,Lst||Expr])
        Chinese remainder for polynomials written as lists or no.
        See also: 1/ ichinrem 
        Ex1:chinrem([x+2,x^2+1],[x+1,x^2+x+1])
        Ex2:chinrem([[1,2],[1,0,1]],[[1,1],[1,1,1]])
        
        '''

     def chisquare(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquare:
        chisquare(Intg(n),Real(x0))
        Returns the probability density of the Chi^2 law at x0 (n is the number of degrees of freedom).
        See also: 1/ chisquare_cdf 2/ chisquare_icdf 3/ randvector 4/ ranm 
        Ex1:chisquare(2,3.2)
        Ex2:chisquare(4,10.5)
        Ex3: randvector(3,chisquare,2)
        Ex4: ranm(4,3,chisquare,2)
        
        '''

     def chisquare_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquare_cdf:
        chisquare_cdf(Intg(n),Real(x0))
        Returns the probability that a Chi^2 random variable is less than x0 (n is the number of degrees of freedom).
        See also: 1/ UTPC 2/ chisquare_icdf 3/ chisquared 
        Ex1:chisquare_cdf(2,6.1)
        Ex2:chisquare_cdf(4,6.1)
        
        '''

     def chisquare_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquare_icdf:
        chisquare_icdf(Intg(n),Real(p))
        Returns h such as the probability that a Chi^2 random variable is less than h is p (n is the number of degrees of freedom and 0<=p<=1).
        See also: 1/ chisquare_cdf 2/ chisquared 
        Ex1:chisquare_icdf(2,0.95)
        Ex2:chisquare_icdf(4,0.05)
        
        '''

     def chisquared(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquared:
        chisquared(Intg(n),Real(x0))
        Returns the probability density of the Chi^2 law at x0 (n is the number of degrees of freedom).
        See also: 1/ chisquare_cdf 2/ chisquare_icdf 3/ randvector 4/ ranm 
        Ex1:chisquared(2,3.2)
        Ex2:chisquared(4,10.5)
        Ex3: randvector(3,chisquare,2)
        Ex4: ranm(4,3,chisquare,2)
        
        '''

     def chisquared_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquared_cdf:
        chisquared_cdf(Intg(n),Real(x0))
        Returns the probability that a Chi^2 random variable is less than x0 (n is the number of degrees of freedom).
        See also: 1/ UTPC 2/ chisquare_icdf 3/ chisquared 
        Ex1:chisquared_cdf(2,6.1)
        Ex2:chisquared_cdf(4,6.1)
        
        '''

     def chisquared_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquared_icdf:
        chisquared_icdf(Intg(n),Real(p))
        Returns h such as the probability that a Chi^2 random variable is less than h is p (n is the number of degrees of freedom and 0<=p<=1).
        See also: 1/ chisquare_cdf 2/ chisquared 
        Ex1:chisquared_icdf(2,0.95)
        Ex2:chisquared_icdf(4,0.05)
        
        '''

     def chisquaret(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chisquaret:
        chisquaret(Data,[Func],[FuncParams])
        Chi^2 test : fitness between 2 (or n) samples or between 1 sample and a distribution law (multinomial or given by a law).
        See also: 1/ normalt 2/ studentt 3/ kolmogorovt 
        Ex1:chisquaret([57,54])
        Ex2:chisquaret([1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,1,0,1,1,0,0,0,0],[.4,.6])
        Ex3:chisquaret([57,30],[.6,.4])
        Ex4:chisquaret([17,15,12,15],[15,13,13,14])
        Ex5:chisquaret(ranv(1000,binomial,10,.5),binomial)
        Ex6:chisquaret(ranv(1000,binomial,10,.5),binomial,11,.5)
        Ex7:chisquaret(ranv(1000,normald,0,.2),normald)
        Ex8:chisquaret([11,16,17,22,14,10],[1/6,1/6,1/6,1/6,1/6,1/6])
        Ex9:chisquaret([11,16,17,22,14,10],[(1/6)$6])
        
        '''

     def choice(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for choice:
        choice(Lst(L))
        choice(L)=rand(L)=one extracted element of L.
        See also: 1/ rand  2/ sample 
        Ex1:choice([1,2,3,4,5,6])
        Ex2:choice(["r","r","r","b","n"])
        Ex3: L:=[1,2,3,4,5,6];L:=choice(L)
        Ex4: L:=[1,2,3,4,5,6];L.choice()
        
        '''

     def cholesky(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cholesky:
        cholesky(Mtrx)
        For a numerical symmetric matrix A, returns L matrix such that A=L*tran(L).
        See also: 1/ lu 2/ qr 3/ gauss 
        Ex1:cholesky([[3,1],[1,4]])
        
        '''

     def chr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chr:
        chr(Intg or Lst(Intg))
        Returns the string corresponding to the character code of the argument.
        See also: 1/ asc 2/ ord 
        Ex1:chr(65)
        Ex2:chr([65,66,67])
        
        '''

     def chrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chrem:
        chrem(LstIntg(a,b,c....),LstIntg(p,q,r,....))
        Chinese remainders for integers or for polynomials.
        See also: 1/ gcd 2/ fracmod 3/ chinrem 4/ ichinrem 
        Ex1:chrem(symbolique.)
        Ex2:chrem([2,3],[7,5])
        Ex3:chrem([2,4,6],[3,5,7])
        Ex4:chrem([2,4,6,7],[3,5,7,11])
        Ex5:chrem([2*x+1,4*x+2,6*x-1,x+1],[3,5,7,11])
        
        '''

     def chromatic_index(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chromatic_index:
        chromatic_index(Graph(G))
        Returns the number of colors in a minimal edge coloring of G.
        See also: 1/ minimal_edge_coloring 2/ chromatic_number 
        Ex1:chromatic_index(graph("petersen"))
        
        '''

     def chromatic_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chromatic_number:
        chromatic_number(Graph(G))
        Returns the chromatic number of G.
        Ex1:chromatic_number(graph("petersen"))
        
        '''

     def chromatic_polynomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for chromatic_polynomial:
        chromatic_polynomial(Graph(G),[Var(t)])
        Returns the chromatic polynomial [or its value at point t] of an undirected unweighted graph G.
        See also: 1/ flow_polynomial 2/ reliability_polynomial 3/ tutte_polynomial 
        Ex1:chromatic_polynomial(graph("petersen"))
        Ex2:chromatic_polynomial(graph("petersen"),3)
        
        '''

     def circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for circle:
        circle((Pnt(M) or Cplx(M),(Pnt(N) or Cplx(zN)),[Real(a)],[Real(b)],[Var(A)],[Var(B)])
        Define for 2-d a circle with a diameter MN (arg1=M or zM,arg2=N) or  with center and radius (arg1=M or zM,arg2=zN) and (center=M and radius=abs(zN)) [or the arc AB, A angle a, B angle b, (MN=angle 0) or M(M+zN)=angle 0] or by its equation and for 3-d with a diameter and a third point.
        See also: 1/ circumcircle 2/ incircle 3/ excircle 4/ center 5/ radius 6/ sphere 7/ Circle 
        Ex1:circle(0,point(2*i))
        Ex2:circle(i,i)
        Ex3:circle(i,1)
        Ex4:circle(0,i,pi/4,pi/2)
        Ex5:circle(0,i,pi/4,pi/2,A,B)
        Ex6:circle(x^2+y^2-x-y)
        Ex7:circle(cercle(point([-1,0,0]),point([1,0,0]),point([0,2,0])))
        Ex8:circle(cercle([-1,0,0],point([1,0,0]),[0,2,0]))
        
        '''

     def circumcircle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for circumcircle:
        circumcircle((Pnt or Cplx),(Pnt or Cplx),((Pnt or Cplx))
        circumcircle(A,B,C)=circumcircle of the triangle ABC.
        See also: 1/ circle 2/ incircle 3/ excircle 
        Ex1:circumcircle(0,1,1+i)
        
        '''

     def classes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for classes:
        classes(Lst(l),[ClassMin],[ClassSize||Lst(Center)])
        Returns the matrix [[class,number],...] obtained with class_min and class_size: see init of geo or argument 2 and 3 or with the list of centers.
        See also: 1/ histogram 2/ cumulated_frequencies 3/ bar_plot 4/ frequencies 
        Ex1:classes([1,1.2,1.4,1.6,1.8,2,2.5])
        Ex2:classes([1,1.2,1.4,1.6,1.8,2,2.5],1.2,0.5)
        Ex3:classes([1,1.2,1.4,1.6,1.8,2,2.5],1,[1.2,1.6,2,2.4])
        Ex4:classes([1,1.2,1.4,1.6,1.8,2,2.5],1,[1.2,1.6,2.2])
        Ex5:classes([0,0.5,1,1.5,2,2.5,3,3.5,4],[0..2,2..4,4..6])
        
        '''

     def clear(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for clear:
        clear(NULL)
        Clears the list of pixels.
        See also: 1/ set_pixel 2/ show_pixels 
        Ex1:clear()
        
        '''

     def clique_cover(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for clique_cover:
        clique_cover(Graph(G),[Intg(k)])
        Returns a clique vertex cover of G [containing at most k cliques].
        See also: 1/ clique_cover_number 2/ maximal_cliques 
        Ex1:clique_cover(graph("petersen"))
        Ex2:clique_cover(cycle_graph(5))
        Ex3:clique_cover(graph_complement(complete_graph(3,4)))
        
        '''

     def clique_cover_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for clique_cover_number:
        clique_cover_number(Graph(G))
        Returns the clique cover number of G.
        See also: 1/ clique_cover 3/ maximal_cliques 
        Ex1:clique_cover_number(graph("petersen"))
        Ex2:clique_cover_number(cycle_graph(5))
        Ex3:clique_cover_number(graph_complement(complete_graph(3,4)))
        
        '''

     def clique_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for clique_number:
        clique_number(Graph(G))
        Returns the clique number of G, which is equal to the size of a maximum clique in G.
        See also: 1/ maximum_clique 
        Ex1:clique_number(graph_complement(complete_graph(3,4)))
        
        '''

     def closeness_centrality(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for closeness_centrality:
        closeness_centrality(Graph(G),[Vrtx(v)])
        Returns the closeness centrality of a vertex v in a graph G or the list of closeness centralities of vertices in G.
        See also: 1/ degree_centrality 2/ betweenness_centrality 3/ harmonic_centrality 4/ information_centrality 5/ katz_centrality 
        Ex1:closeness_centrality(graph(6,%{[0,2],[0,5],[1,3],[1,5],[2,5],[3,4],[3,5],[4,5]%}))
        
        '''

     def cluster(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cluster:
        cluster(Lst(data),[opts])
        Perform hierarchical agglomerative clustering of the given data.
        See also: 1/ kmeans 2/ levenshtein 
        Ex1:cluster([[1.1,1.5],[3.2,2.5],[1.5,0.9],[3.5,2.7],[0.8,1.1],[3.1,2.2]])
        
        '''

     def clustering_coefficient(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for clustering_coefficient:
        clustering_coefficient(Graph(G),[Vrtx(v)])
        Returns the average clustering coefficient of an undirected graph G, or the local clustering coefficient of the vertex v in G.
        See also: 1/ network_transitivity 2/ number_of_triangles 
        Ex1:clustering_coefficient(graph(%{[1,2],[2,3],[2,4],[3,4],[4,1]%}))
        Ex2:clustering_coefficient(graph(%{[1,2],[2,3],[2,4],[3,4],[4,1]%}),2)
        
        '''

     def coeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for coeff:
        coeff(Expr(P),[Var])
        Returns the list of coefficients of a polynomial with respect to the 2nd argument or the coefficient of degree the 3rd argument.
        See also: 1/ pcoeff 2/ fcoeff 
        Ex1:coeff(x*3+2)
        Ex2:coeff(5*y^2-3,y)
        Ex3:coeff(5*y^2-3,y,2)
        
        '''

     def coeffs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for coeffs:
        coeffs(Expr(P),[Var])
        Returns the list of coefficients of a polynomial with respect to the 2nd argument or the coefficient of degree the 3rd argument.
        See also: 1/ pcoeff 2/ fcoeff 
        Ex1:coeffs(x*3+2)
        Ex2:coeffs(5*y^2-3,y)
        Ex3:coeffs(5*y^2-3,y,2)
        
        '''

     def col(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for col:
        col(Mtrx(A),Intg(n)||Interval(n1..n2))
        Returns column n or the sequence of the columns n1..n2 of the matrix A, or optional argument of count,count_eq,count_inf,count_sup.
        See also: 1/ row 2/ count 3/ count_eq 4/ count_inf 5/ count_sup 
        Ex1:col([[1,2,3],[4,5,6],[7,8,9]],1)
        Ex2:col([[1,2,3],[4,5,6],[7,8,9]],0..1)
        Ex3: count_eq(3,[[3,2,3],[4,3,2],[3,2,1]],col)
        
        '''

     def colDim(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colDim:
        colDim(Mtrx)
        Number of columns of a matrix.
        See also: 1/ rowdim 
        Ex1:colDim([[1,2,3],[4,5,6]])
        Ex2:colDim([[1,2],[3,4],[5,6]])
        
        '''

     def colNorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colNorm:
        colNorm(Vect or Mtrx)
        Returns the max of the l1_norm of the columns of a matrix: colNorm(a_{j,k})=max_k(sum_j(|a_{j,k}|)).
        See also: 1/ norm 
        Ex1:colNorm([[1,2],[3,-4]])
        Ex2:colNorm([[1,2,3,-4],[-5,3,2,1]])
        
        '''

     def colSwap(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colSwap:
        colSwap(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by swapping the n1-th column and the n2-th column.
        See also: 1/ rowSwap 
        Ex1:colSwap([[1,2],[3,4],[5,6]],0,1)
        
        '''

     def coldim(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for coldim:
        coldim(Mtrx)
        Number of columns of a matrix.
        See also: 1/ rowdim 
        Ex1:coldim([[1,2,3],[4,5,6]])
        Ex2:coldim([[1,2],[3,4],[5,6]])
        
        '''

     def collect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for collect:
        collect(Poly or LstPoly)
        Integer factorization of a polynomial (or of a list of poly).
        See also: 1/ factor 2/ factors 
        Ex1:collect(x^2-4)
        Ex2:collect(x^2-2)
        Ex3:collect([x^2-2,x^2-4])
        
        '''

     def colnorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colnorm:
        colnorm(Vect or Mtrx)
        Returns the max of the l1_norm of the columns of a matrix: colNorm(a_{j,k})=max_k(sum_j(|a_{j,k}|)).
        See also: 1/ norm 
        Ex1:colnorm([[1,2],[3,-4]])
        Ex2:colnorm([[1,2,3,-4],[-5,3,2,1]])
        
        '''

     def color(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for color:
        color([GeoObj or legende],Intg)
        Draws a geometrical object with colors black=0 red=1 green=2 yellow=3 blue=4, filled with the color in the interior of a closed curve,line_width_n (0<n<8) is for the width of the line and dash_line is for dotted line.
        See also: 1/ -< 2/ legende 
        Ex1:color(A,1)
        Ex2:color(F:=point(2+1.5*i),2)
        Ex3:color(point(2+1.5*i),2)
        Ex4:color(legende(1+i,"abc"),4)
        Ex5:color(square(0,1),filled+red)
        Ex6:color(carre(0,1),rempli+rouge)
        Ex7:color(circle(0,1),filled)
        Ex8:color(line(y=x),green+dash_line+line_width_2)
        Ex9:color(red);square(0,1);
        Ex10:color(red+filled);square(0,1);
        
        '''

     def colormap(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colormap:
        colormap(Str(palette)||Lst(palettes),[Intg(n)||Real(t)||Str(colorname)||display])
        Return the colormap index for a given palette name or a extract specified color(s) or display selected colormap(s).
        See also: 1/ color 2/ rgb 3/ hsv 
        Ex1:colormap("default")
        Ex2:colormap("inferno")
        Ex3:colormap("viridis",25)
        Ex4:colormap("discrete","vivid")
        Ex5:colormap(["cubic","isoluminant","haline"],display)
        
        '''

     def colspace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colspace:
        colspace(Mtrx(A), [Var(d)])
        Returns a matrix where the columns are a basis of the vector space generated by the columns of the matrix A [d is the dimension of this space].
        See also: 1/ rowspace 
        Ex1:colspace([[1,2,3],[1,2,3],[1,2,4],[1,2,5]])
        Ex2:colspace([[1,2,3],[1,3,6],[2,5,9]],d)
        
        '''

     def colswap(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for colswap:
        colswap(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by swapping the n1-th column and the n2-th column.
        See also: 1/ rowSwap 
        Ex1:colswap([[1,2],[3,4],[5,6]],0,1)
        
        '''

     def comDenom(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for comDenom:
        comDenom(Expr,[Var(Var)])
        Returns the expression after reduction to the same denominator : the numerator and the denominator are developed [according to the powers of the variable var].
        See also: 1/ normal 
        Ex1:comDenom(1/x+1/y^2+1)
        Ex2:comDenom(1/x+1/y^2+1,y)
        Ex3:comDenom(1/x+1/y^2+1,x)
        
        '''

     def comb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for comb:
        comb(Intg(n),Intg(r))
        comb(n,r)=number of combinations of r objects taken among n : n!/(r!(n-r)!) (If n<0 comb(n,r)=n(n-1)..(n-r+1)/r!).
        See also: 1/ factorial 2/ perm 
        Ex1:comb(4,2)
        
        '''

     def combine(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for combine:
        combine(Expr(Xpr),Fnc(f).)
        Combines terms in Xpr according to a [class of] function f (2nd argument).
        See also: 1/ lncollect 2/ lin 3/ tlin 4/ tcollect 
        Ex1:combine(exp(x)*exp(y),exp)
        Ex2:combine(sin(x)*cos(x),trig)
        Ex3:combine(ln(x)+ln(y),ln)
        
        '''

     def comment(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for comment:
        comment(Expr)
        Comment in a program.
        See also: 1/  
        Ex1:comment("my_comment")
        
        '''

     def common_perpendicular(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for common_perpendicular:
        common_perpendicular(Line(D1),Line(D2))
        Draws the common perpendicular of the lines D1 and D2.
        See also: 1/ altitude 2/ perpendicular 
        Ex1:common_perpendicular(line([0,0,0],[0,5,5]),line([5,0,0],[0,0,5]))
        
        '''

     def companion(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for companion:
        companion(Poly,Var)
        Companion matrix of a polynomial (an=1).
        See also: 1/ pcar 2/ rat_jordan 
        Ex1:companion(x^2+5x-7,x)
        Ex2:companion(-pcar([[1,0,1],[0,2,-1],[1,-1,1]],x),x)
        
        '''

     def compare(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for compare:
        compare(Obj(arg1),Obj(arg2))
        Returns 1 if type(arg1)<type(arg2) or if type(arg1)=type(arg2) and arg1<arg2, else returns 0.
        See also: 1/ type 
        Ex1:compare(1,2)
        Ex2:compare(1.0,2)
        Ex3:compare("ab","cd")
        
        '''

     def complete_binary_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for complete_binary_tree:
        complete_binary_tree(Intg(n))
        Returns a complete binary tree with depth n.
        See also: 1/ complete_kary_tree 2/ is_tree 3/ random_tree 
        Ex1:complete_binary_tree(3)
        
        '''

     def complete_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for complete_graph:
        complete_graph(Intg(n)||Lst(V)||Seq(n1,n2,...,nk))
        Returns a complete graph with vertices from list V or enumerated with first n integers or, when two or more positive integers n1,n2,...,nk are given, a complete k-partite graph with partition sizes n1,n2,...,nk.
        See also: 1/ edges 
        Ex1:complete_graph(4)
        Ex2:complete_graph(["one","two","three"])
        Ex3:complete_graph(2,3,4)
        
        '''

     def complete_kary_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for complete_kary_tree:
        complete_kary_tree(Intg(k),Intg(n))
        Returns a complete k-ary tree with depth n.
        See also: 1/ complete_binary_tree 2/ is_tree 3/ random_tree 
        Ex1:complete_kary_tree(2,3)
        
        '''

     def complex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for complex:
        complex(Opt)
        DOM_COMPLEX or complex is the type of a complex or of a complex variable, as returned by the type command. It is also an option of the assume command.
        See also: 1/ type 2/ assume 3/ DOM_INT 4/ DOM_FLOAT 
        Ex1: assume(a,complex)
        Ex2: assume(a,DOM_COMPLEX)
        Ex3: a:=1+i;type(a)
        
        '''

     def complex_variables(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for complex_variables:
        complex_variables(:=Intg(0 or 1))
        Pseudo-variable to work with complex variables (complex_variables:=1) or with real variables (complex_variables:=0).
        See also: 1/ cas_setup 
        Ex1: complex_variables:=1
        Ex2: complex_variables:=0
        
        '''

     def complexroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for complexroot:
        complexroot(Poly(P),Real(l),[Cplx(a)],[Cplx(b)])
        Returns the list of complex intervals of size<=l containing the roots of P (for example i[1.1,1.2]+i[2,2.4]*i pour [1.1,1.2]x[2,2.4] with optionally a=1+2*i,b=2+3*i) with multiplicities.
        See also: 1/ proot 2/ froot 3/ realroot 4/ rationalroot 5/ crationalroot 
        Ex1:complexroot(x^4+1,1e-50,0.7+i*0.7,0.8+i*0.8)
        Ex2:complexroot(x^5-2*x^4+x^3+i,0.1)
        Ex3:complexroot(x^3+8,1e-5,0,2+2*i)
        Ex4:complexroot(x^5-2*x^4+x^3+i,0.1,1+0.5*i,1.1+0.7*i)
        
        '''

     def concat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for concat:
        concat(Lst,Lst||Seq,Seq||Str,Str||Mtrx,Mtrx)
        Concatenates two lists or two strings or two sequences or 2 matrices; L:=concat(L,L1) or L.concat(L1).
        See also: 1/ append 2/ cat 3/ semi_augment 4/ border 5/ + 
        Ex1:concat([1,2],[3,4,5])
        Ex2:concat("bon","jour")
        Ex3:concat([[1,2],[3,4]],[[4,5,6],[6,7,8]])
        Ex4: L:=[1,2];L.concat([3,4,5])
        Ex5: S:="abcd";S.concat("efghi")
        
        '''

     def cond(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cond:
        cond(Mtrx,[2]||[inf])
        Condition number of a matrix, use COND(.,1) for l1, COND(.,2) for l2 norm and COND(.,inf) for linf (1 by default).
        See also: 1/ SVL 
        Ex1:cond([[1,2],[1,4]])
        Ex2:cond([[1,2],[1,4]],1)
        Ex3:cond([[1,2],[1,4]],2)
        Ex4:cond([[1,2],[1,4]],inf)
        
        '''

     def condensation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for condensation:
        condensation(Graph(G))
        Returns the graph obtained by contracting strongly connected components of the digraph G to single vertices.
        See also: 1/ strongly_connected_components 
        Ex1:condensation(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}))
        
        '''

     def cone(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cone:
        cone(Pnt(A),Vect(v),Real(t),[Real(h)])
        Draws a cone with vertex A, direction v, and with half_angle t [and with altitudes h and -h].
        See also: 1/ half_cone 2/ cylinder 
        Ex1:cone([0,0,0],[0,0,1],pi/6)
        Ex2:cone([0,0,0],[0,1,1],pi/6,4)
        
        '''

     def confrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for confrac:
        confrac(Opt)
        Option of the convert or convertir command (ex id L:=dfc(sqrt(2),1e-10)).
        See also: 1/ convert 
        Ex1: convert(sqrt(2),confrac,'L'),L
        
        '''

     def conic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for conic:
        conic(Expr,[LstVar])
        Defines a conic by its equation with x,y as default variables and draws it.
        See also: 1/ circle 2/ ellipse 3/ hyperbola 4/ parabola 5/ reduced_conic 
        Ex1:conic(x^2+y^2-x*y-3)
        Ex2:conic(x^2+2*y^2-x*y-3,x,y)
        Ex3:conic(u^2-2*v^2-2*u*v-1,[u,v])
        Ex4:conic(y^2-x*y+3,[x,y])
        
        '''

     def conj(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for conj:
        conj(Cplx)
        Returns the conjugate of a complex number.
        See also: 1/ re 2/ im 3/ tran 
        Ex1:conj(1+i)
        Ex2:conj(1+2*i)
        Ex3:conj((1+2*i)^2)
        Ex4:conj([[1+i,2,3],[1,3,6],[2,5,9-i]])
        
        '''

     def conjugate_equation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for conjugate_equation:
        conjugate_equation(Expr(y0),Lst(P),Lst(V),Var(x),Real(a))
        Returns the expression which is zero for a point x1 conjugate to x (a is the left or the right bound for x) with respect to the function y0 depending on two parameters in P with values in V.
        See also: 1/ jacobi_equation 2/ euler_lagrange 
        Ex1:conjugate_equation(A*sin(t)+B*cos(t),[A,B],[1,0],t,0)
        
        '''

     def conjugate_gradient(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for conjugate_gradient:
        conjugate_gradient(Mtrx(A),Vect(y),[Vect(x0),Real(eps)])
        Conjugate gradient algorithm to solve A*x=y approximately (precision eps) where A is a symmetric positive definite matrix, x0 an optional initial guess.
        See also: 1/ linsolve 
        Ex1:conjugate_gradient([[2,1],[1,5]],[1,0])
        Ex2:conjugate_gradient([[4,1+i],[1-i,5]],[1,0])
        Ex3:conjugate_gradient([[2,1],[1,5]],[1,0],[0.55,-0.11],1e-2)
        Ex4:conjugate_gradient([[2,1],[1,5]],[1,0],[0.55,-0.11],1e-10)
        
        '''

     def connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for connected:
        connected(Opt)
        Option for the random_regular_graph command.
        See also: 1/ directed 2/ weighted 3/ random_regular_graph 
        
        '''

     def connected_components(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for connected_components:
        connected_components(Graph(G))
        Returns a list of lists of vertices, each sublist representing a connected component of G.
        See also: 1/ articulation_points 2/ is_biconnected 3/ is_strongly_connected 4/ strongly_connected_components 5/ underlying_graph 
        Ex1:connected_components(graph_complement(cycle_graph(4)))
        
        '''

     def cont(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cont:
        cont(NULL)
        Continues execution of a stopped program.
        See also: 1/ continue 
        Ex1:cont()
        
        '''

     def contains(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for contains:
        contains((Lst(l) or Set(l)),Elem(e))
        Tests if a set contains an expression (returns the index+1 or 1 for intervals or 0).
        See also: 1/ inString 2/ member 3/ est_element 
        Ex1:contains(%{0,1,2,3%},2)
        Ex2:contains([0,1,2,3],4)
        Ex3:contains([1..2],1.5)
        
        '''

     def content(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for content:
        content(Poly(P),[Var])
        Returns the gcd of the coefficients of the polynomial P given as argument.
        See also: 1/ primpart 2/ lgcd 
        Ex1:content(2*x^2+10*x+6)
        Ex2:content([2,10,6])
        Ex3:content(2*t^2+10*t+6,t)
        
        '''

     def contourplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for contourplot:
        contourplot(Expr(Xpr),[LstVar],[LstVal])
        Draws 11 equirepartited contour-lines z=z_min,,...z=z_max of the surface z=Xpr, or the contour-lines defined by the 3-rd argument.
        See also: 1/ plotdensity 2/ plotimplicit 
        Ex1:contourplot(x^2+y^2)
        Ex2:contourplot(x^2+y^2,[x,y])
        Ex3:contourplot(x^2+2*y^2-2,[x,y],[1.0,2.0,3.0])
        Ex4:contourplot(x^2-y^2,[x=-4..4,y=-4..4],seq(k,k,-11,11,3),xstep=0.1,ystep=0.1)
        
        '''

     def contract_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for contract_edge:
        contract_edge(Graph(G),Edge(e))
        Returns a modified copy of an undirected graph G with the edge e contracted into one of its endpoints (to contract more edges apply the foldl command).
        See also: 1/ delete_edge 2/ delete_vertex 3/ foldl 
        Ex1:contract_edge(complete_graph(4),[1,3])
        
        '''

     def contract_subgraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for contract_subgraph:
        contract_subgraph(Graph(G),Lst(S),[lb])
        Returns a copy of G in which the subgraph induced by S is contracted into a single vertex (optionally labeled by lb).
        See also: 1/ contract_edge 2/ condensation 3/ delete_vertex 4/ subgraph 
        Ex1:contract_subgraph(cycle_graph(6),[0,1,5],"newLabel")
        
        '''

     def convert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for convert:
        convert(Expr(Xpr),Cmd(cmd))
        Returns the value of cmd(Xpr), cmd is the name of a command specified by the 2nd argument (for ex option sin=command trigsin).
        See also: 1/ mksa 2/ list 3/ polynom 4/ table 
        Ex1:convert(cos(x)^2,sin)
        Ex2:convert(exp(i*x),sincos)
        Ex3:convert(1/(x^4-1),parfrac)
        Ex4:convert(series(sin(x),x=0,6),polynom)
        Ex5:convert([[1,[2,0]],[2,[1,1]],[1,[0,2]]],polynom)
        Ex6:convert(%%%{1,[2,0]%%%}+%%%{2,[1,1]%%%}+%%%{1,[0,2]%%%},list)
        Ex7:convert(cos(x)^2+1,sin)
        Ex8:convert(3e10 _m,_au)
        Ex9:convert(pi _rad,_deg)
        Ex10:convert(9976/6961,confrac,'l');l
        Ex11:convert(sqrt(2),confrac,'dev');dev
        Ex12:convert(123,base,8)
        Ex13:convert([3,7,1],base,8)
        Ex14:convert([1,2,3],set[])
        Ex15:convert(pi,interval,20)
        Ex16: A[2,1]:=1;convert(A,array)
        Ex17: B[0..1,1..2]:=1;B[2,2]:=2;convert(B,array)
        
        '''

     def convertir(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for convertir:
        convertir(Expr(Xpr),Cmd(cmd))
        Returns the value of cmd(Xpr), cmd is the name of a command specified by the 2nd argument (for ex option sin=command trigsin).
        See also: 1/ mksa 2/ list 3/ polynom 4/ table 
        Ex1:convertir(cos(x)^2,sin)
        Ex2:convertir(exp(i*x),sincos)
        Ex3:convertir(1/(x^4-1),parfrac)
        Ex4:convertir(series(sin(x),x=0,6),polynom)
        Ex5:convertir([[1,[2,0]],[2,[1,1]],[1,[0,2]]],polynom)
        Ex6:convertir(%%%{1,[2,0]%%%}+%%%{2,[1,1]%%%}+%%%{1,[0,2]%%%},list)
        Ex7:convertir(cos(x)^2+1,sin)
        Ex8:convertir(3e10 _m,_au)
        Ex9:convertir(pi _rad,_deg)
        Ex10:convertir(9976/6961,confrac,'l');l
        Ex11:convertir(sqrt(2),confrac,'dev');dev
        Ex12:convertir(123,base,8)
        Ex13:convertir([3,7,1],base,8)
        Ex14:convertir([1,2,3],set[])
        Ex15:convertir(pi,interval,20)
        Ex16: A[2,1]:=1;convert(A,array)
        Ex17: B[0..1,1..2]:=1;B[2,2]:=2;convert(B,array)
        
        '''

     def convex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for convex:
        convex(Expr(f),Lst(x,y,..),[simplify])
        Returns a list of conditions under which f(x,y,..) is convex.
        See also: 1/ hessian 
        Ex1:convex(3*exp(x)+5x^4-ln(x),x)
        Ex2:convex(x^2+y^2+3z^2-x*y+2x*z+y*z,[x,y,z])
        Ex3:convex(x1^3+2x1^2+2*x1*x2+x2^2/2-8x1-2x2-8,[x1,x2],simplify)
        Ex4:convex(x1^2+2x2^2+a*x3^2-2x1*x2+2x1*x3-6x2*x3,[x1,x2,x3],simplify)
        Ex5:convex(sqrt((1+(u')^2)/(2*g*u)),u(t),simplify)
        
        '''

     def convexhull(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for convexhull:
        convexhull(Lst)
        Convex hull of a list of 2-d points.
        See also: 1/ polygon 
        Ex1:convexhull(0,1,1+i,1+2i,-1-i,1-3i,-2+i)
        Ex2:convexhull([0,1,1+i,1+2i,-1-i,1-3i,-2+i])
        Ex3: polygon(convexhull(0,1,1+i,1+2i,-1-i,1-3i,-2+i))
        
        '''

     def convolution(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for convolution:
        convolution(Lst(u),Lst(v))
        Returns the convolution of two signals or causal functions u and v.
        See also: 1/ fft 2/ cross_correlation 
        Ex1:convolution([1,2,3],[1,-1,1,-1])
        Ex2:convolution(25*exp(2*x),x*exp(-3*x),x)
        
        '''

     def coordinates(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for coordinates:
        coordinates(Pnt or Cplx or Vect)
        Returns the list (resp matrix) of the abscissa and of the ordinate of a point or a vector (resp of points or vectors).
        See also: 1/ abscissa 2/ ordinate 3/ cote 4/ vecteur 
        Ex1:coordinates(point(1+2*i))
        Ex2:coordinates(1+2*i)
        Ex3:coordinates(point(i),point(1+2*i))
        Ex4:coordinates(vecteur(point(i),point(1+2*i)))
        Ex5:coordinates(point(1+2*i)-point(i))
        Ex6:coordinates(-1-i)
        Ex7:coordinates(point(1,2,3))
        Ex8:coordinates(vecteur([1,2,3],[4,5,6]))
        
        '''

     def copy(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for copy:
        copy(Mtrx,Var)
        A:=copy(B) clones the list or matrix B into A.
        See also: 1/ =< 
        Ex1: A:=copy(B)
        
        '''

     def correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for correlation:
        correlation(Lst||Mtrx,[Lst])
        Returns the correlation of the elements of its argument.
        See also: 1/ covariance 2/ covariance_correlation 
        Ex1:correlation([[1,2],[1,1],[4,7]])
        
        '''

     def cos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cos:
        cos(Expr or Opt)
        Cosine or option of the convert or convertir command (id trigcos).
        See also: 1/ acos 2/ convert 3/ trigsin 
        Ex1:cos(0)
        Ex2: convert(cos(x)^4+sin(x)^2,cos)
        
        '''

     def cos2sintan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cos2sintan:
        cos2sintan(Expr)
        Replaces cos(x) by sin(x)/tan(x) in the argument.
        See also: 1/ tan2sincos 2/ sin2costan 3/ tan2sincos2 4/ tan2cossin2 
        Ex1:cos2sintan(cos(x))
        
        '''

     def cosh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cosh:
        cosh(Expr)
        Hyperbolic cosine.
        See also: 1/ acosh 
        Ex1:cosh(0)
        
        '''

     def cosine_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cosine_window:
        cosine_window(Lst,[Real(a)],[Interval(n1..n2)])
        Applies the cosine windowing function with parameter a>0 (by default a=1 for sine window) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ bartlett_hann_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(cosine_window(randvector(1000,0..1),1.5))
        
        '''

     def cot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cot:
        cot(Expr)
        Cotangent.
        See also: 1/ acot 2/ tan 
        Ex1:cot(pi/2)
        
        '''

     def cote(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cote:
        cote(Vect)
        Third coordinate (z) of a 3-d point.
        See also: 1/ abscissa 2/ ordinate 3/ coordinates 
        Ex1:cote(point[1,2,3])
        Ex2:cote(point(1,2,3))
        
        '''

     def count(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for count:
        count(Fnc(f)||LstIntg,(Lst||Mtrx)(l),[Opt(row||col)])
        Returns f(l[0])+f(l[1])+...+f(l[size(l)-1]) or counts the number of occurrences if the argument is a vector of integers.
        See also: 1/ count_eq 2/ count_inf 3/ count_sup 
        Ex1:count(id,[-2/5,-1,0,1,2,3/5])
        Ex2:count(1,[-2,-1,0,1,2,3])
        Ex3:count([1,3,1,1,2,10,3])
        Ex4:count((x)->x>2,[3/2,5/2,8/3])
        Ex5:count((x)->x==1,[-2,1,0,1,2,3])
        Ex6:count((x)->x>2,[[3,5/2],[4,1]])
        Ex7:count((x)->x>2,[[3,5/2],[4,1]],row)
        Ex8:count((x)->x>2,[[3,5/2],[4,1]],col)
        Ex9:count((x)->x>2 && x<4,[[3,9/2],[4,1]])
        Ex10:count((x)->x<2 || x>4,[[3,9/2],[4,1]])
        
        '''

     def count_eq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for count_eq:
        count_eq(Real(a),(Lst||Mtrx)(L),[Opt(row||col)])
        Returns the number of elements of L equal to a.
        See also: 1/ count 2/ count_inf 3/ count_sup 
        Ex1:count_eq(1,[-2,1,0,1,2,-3])
        Ex2:count_eq(4,[[3,4],[4,1]])
        Ex3:count_eq(4,[[3,4],[4,1]],row)
        Ex4:count_eq(4,[[3,4],[4,1]],col)
        
        '''

     def count_inf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for count_inf:
        count_inf(Real(a),(Lst||Mtrx)(L),[Opt(row||col)])
        Returns the number of elements of L strictly less than a.
        See also: 1/ count 2/ count_eq 3/ count_sup 
        Ex1:count_inf(1,[-2,-1,0,1,2,3])
        Ex2:count_inf(4,[[3,5],[4,1]])
        Ex3:count_inf(4,[[3,5],[4,1]],row)
        Ex4:count_inf(4,[[3,5],[4,1]],col)
        
        '''

     def count_sup(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for count_sup:
        count_sup(Real(a),(Lst||Mtrx)(L),[Opt(row||col)])
        Returns the number of elements of L strictly greater than a.
        See also: 1/ count 2/ count_inf 3/ count_eq 
        Ex1:count_sup(1,[-2,-1,0,1,2,3])
        Ex2:count_sup(3,[[3,5],[4,1]])
        Ex3:count_sup(3,[[3,5],[4,1]],row)
        Ex4:count_sup(3,[[3,5],[4,1]],col)
        
        '''

     def courbe_parametrique(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for courbe_parametrique:
        courbe_parametrique(Cplx||Lst,Var||Lst(Var))
        plotparam(a(x)+i*b(x),x=x0..x1) draws the curve X=a(x),Y=b(x) x=x0..x1 or plotparam([a(u,v),b(u,v),c(u,v)],[u=u0..u1,v=v0..v1]) draws the surface X=a(u,v),Y=b(u,v),Z=c(u,v) u=u0..u1 and v=v0..v1.
        See also: 1/ plotfunc 2/ plotpolar 3/ arc 
        Ex1:courbe_parametrique(sin(t)+i*cos(t),t)
        Ex2:courbe_parametrique(exp(i*t),t=0..pi/2,affichage=1)
        Ex3:courbe_parametrique(exp(i*t),t=0..pi/2,affichage=1+rempli)
        Ex4:courbe_parametrique([sin(x),cos(x)],x=0..1)
        Ex5:courbe_parametrique([sin(x),cos(x)],x=0..1,affichage=rouge)
        Ex6:courbe_parametrique(sin(x)+i*cos(x),x=0..1,tstep=0.01)
        Ex7:courbe_parametrique([v*cos(u),v*sin(u),v],[u,v])
        Ex8:courbe_parametrique([v*cos(u),v*sin(u),v],[u=0..pi,v=0..3],ustep=0.1,vstep=0.2)
        
        '''

     def courbe_polaire(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for courbe_polaire:
        courbe_polaire(Expr,Var,VarMin,VarMax)
        plotpolar(f(x),x,a,b) draws the polar curve r=f(x) for x in [a,b].
        See also: 1/ plotparam 2/ plotfunc 3/ plotpolar 
        Ex1:courbe_polaire(sin(2*x),x,0,pi)
        Ex2:courbe_polaire(sin(2*x),x,0,pi,tstep=0.1)
        
        '''

     def covariance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for covariance:
        covariance(Lst||Mtrx,[Lst])
        Returns the covariance of the elements of its argument.
        See also: 1/ correlation 2/ covariance_correlation 
        Ex1:covariance([[1,2],[1,1],[4,7]])
        
        '''

     def covariance_correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for covariance_correlation:
        covariance_correlation(Lst||Mtrx,[Lst])
        Returns the list of the covariance and the correlation of the elements of its argument.
        See also: 1/ covariance 2/ correlation 
        Ex1:covariance_correlation([[1,2],[1,1],[4,7]])
        
        '''

     def cpartfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cpartfrac:
        cpartfrac(RatFrac)
        Performs partial fraction decomposition in ℂ of a fraction.
        See also: 1/ factor 2/ normal 
        Ex1:cpartfrac((x)/(4-x^2))
        Ex2:cpartfrac((x^2-2*x+3)/(x^2-3*x+2))
        Ex3:cpartfrac(a/(z*(z-b)),z)
        
        '''

     def crationalroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for crationalroot:
        crationalroot(Poly(P))
        Returns the list of complex rational roots of P without indicating the multiplicity.
        See also: 1/ proot 2/ froot 3/ complexroot 4/ rationalroot 5/ realroot 
        Ex1:crationalroot(2*x^3+(-5-7*i)*x^2+(-4+14*i)*x+8-4*i)
        
        '''

     def crayon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for crayon:
        crayon(Color)
        Changes the color of the pencil (without parameter, returns the current color).
        See also: 1/ leve_crayon 2/ baisse_crayon 
        Ex1: crayon vert
        Ex2:crayon(rouge)
        Ex3:crayon(5)
        Ex4:crayon(gomme)
        
        '''

     def createwav(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for createwav:
        createwav(Lst(data),[opts])
        Returns an audio clip created from data, optionally setting channel count, bit depth, sample rate, duration and/or normalization level.
        See also: 1/ readwav 2/ writewav 3/ playsnd 
        Ex1:createwav(duration=3.5)
        Ex2:createwav(sin(2*pi*440*soundsec(2)),samplerate=48000)
        Ex3:createwav(sin(2*pi*440*soundsec(2)),bit_depth=8)
        Ex4:createwav(10*sin(2*pi*440*soundsec(2)),normalize=-3)
        Ex5: t:=soundsec(3):;L,R:=sin(2*pi*440*t),sin(2*pi*445*t):;createwav([L,R])
        
        '''

     def cross(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cross:
        cross(Vect(v1),Vect(v2))
        Wedge product.
        See also: 1/ dot 
        Ex1:cross([1,2],[3,4])
        Ex2:cross([1,2,3],[4,5,6])
        
        '''

     def crossP(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for crossP:
        crossP(Vect(v1),Vect(v2))
        Wedge product.
        See also: 1/ dot 
        Ex1:crossP([1,2],[3,4])
        Ex2:crossP([1,2,3],[4,5,6])
        
        '''

     def cross_correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cross_correlation:
        cross_correlation(cross_correlation(Lst(u),Lst(v)))
        Returns the cross_correlation of two signals u and v.
        See also: 1/ auto_correlation 2/ correlation 
        Ex1:cross_correlation([1,2],[3,4,5])
        
        '''

     def cross_entropy(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cross_entropy:
        cross_entropy(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def cross_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cross_point:
        cross_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def cross_ratio(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cross_ratio:
        cross_ratio(Pnt or Cplx(a),Pnt or Cplx(b),Pnt or Cplx(c),Pnt or Cplx(d))
        Returns the complex number equal to ((c-a)/(c-b))/((d-a)/(d-b)).
        See also: 1/ harmonic_conjugate 2/ is_conjugate 
        Ex1:cross_ratio(i,2+i,3/2+i,3+i)
        Ex2:cross_ratio(0,1+i,1,i)
        Ex3:cross_ratio(0,1,2,3)
        
        '''

     def crossproduct(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for crossproduct:
        crossproduct(Vect(v1),Vect(v2))
        Wedge product.
        See also: 1/ dot 
        Ex1:crossproduct([1,2],[3,4])
        Ex2:crossproduct([1,2,3],[4,5,6])
        
        '''

     def csc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for csc:
        csc(Expr)
        Cosecant: csc(x)=1/sin(x).
        See also: 1/ sin 2/ acsc 
        Ex1:csc(pi/2)
        
        '''

     def csolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for csolve:
        csolve(LstEq,LstVar)
        Returns the list of complex solutions of an equation or a matrix where the rows are ℂ-solutions of a system of polynomial equations.
        See also: 1/ cZeros 2/ solve 3/ fslove 
        Ex1:csolve(x^4-1,x)
        Ex2:csolve(x^4-y^4 and x+y=2,[x,y])
        Ex3:csolve(x^4-y^4 and x+y=0 and x^2=2*x,[x,y])
        Ex4:csolve(u*v-u=v and v^2=u,[u,v])
        
        '''

     def csv2gen(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for csv2gen:
        csv2gen(Strng(filename),Strng(sep),Strng(nl),Strng(decsep),Strng(eof),[string])
        Reads a file (or string) in CSV format.
        See also: 1/ read 
        Ex1:csv2gen("mat.txt",",",char(10),".")
        
        '''

     def cube(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cube:
        cube(Pnt(A),Pnt(B),Pnt(C))
        Draws the direct cube with vertices A,B with a face in the plane (A,B,C).
        See also: 1/ parallelepiped 2/ cylinder 3/ icosahedron 4/ dodecahedron 5/ octahedron 6/ tetrahedron 7/ centered_cube 
        Ex1:cube([0,0,0],[3,0,0],[0,0,1]) 
        Ex2: A,B,C:=point(1,0,0),point(1,1,0),point(0,1,0);c:=cube(A,B,C);A,B,C,D,E,F,G,H:=sommets(c); 
        Ex3: A,B,K:=point(1,0,0),point(1,1,0),point(0,2,0);c:=cube(A,B,C);A,B,C,D,E,F,G,H:=sommets(c); 
        Ex4: c:=cube([0,0,0],[1,0,0],[0,1,0]);c1,c2,c4,c3,c5,c6,c7,c8:=sommets(c); 
        Ex5: c:=cube([0,0,0],[0,2,0],[0,0,1]);c1,c2,c4,c3,c5,c6,c7,c8:=sommets(c); 
        
        '''

     def cumSum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cumSum:
        cumSum(Lst(l)||Seq||Str)
        Returns the list (or the sequence or the string) lr where the elements are the cumulative sum of the list l: lr[k]=sum(l[j],j=0..k) (or lr=sum(l[j],j=0..k)$(k=0..size(l)-1)).
        See also: 1/ sum 
        Ex1:cumSum([0,1,2,3,4])
        Ex2:cumSum(1.2,3,4.5,6)
        Ex3:cumSum("a","b","c","d")
        
        '''

     def cumsum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cumsum:
        cumsum(Lst(l)||Seq||Str)
        Returns the list (or the sequence or the string) lr where the elements are the cumulative sum of the list l: lr[k]=sum(l[j],j=0..k) (or lr=sum(l[j],j=0..k)$(k=0..size(l)-1)).
        See also: 1/ sum 
        Ex1:cumsum([0,1,2,3,4])
        Ex2:cumsum(1.2,3,4.5,6)
        Ex3:cumsum("a","b","c","d")
        
        '''

     def cumulated_frequencies(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cumulated_frequencies:
        cumulated_frequencies(Lst || Mtrx)
        Draws the diagram of the cumulated frequencies (rows=[value,frequencies])
        See also: 1/ histogram 2/ classes 3/ bar_plot 
        Ex1:cumulated_frequencies([1,2,1,1,2,1,2,4,3,3])
        Ex2:cumulated_frequencies([(rand(6)+1)$(k=1..100)])
        Ex3:cumulated_frequencies([[1,0.3],[2,0.5],[3,0.2]])
        Ex4:cumulated_frequencies([[1..2,0.3],[2..3,0.5],[3..4,0.2]])
        Ex5:cumulated_frequencies([[1..2,0.3,0.5],[2..3,0.5,0.2],[3..4,0.2,0.3]])
        
        '''

     def curl(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for curl:
        curl(Lst(A,B,C),Lst(x,y,z))
        curl([A,B,C],[x,y,z])=[dC/dy-dB/dz,dA/dz-dC/dx,dB/dx-dA/dy].
        See also: 1/ derive 2/ divergence 
        Ex1:curl([2*x*y,x*z,y*z],[x,y,z])
        
        '''

     def current_sheet(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for current_sheet:
        current_sheet([Intg||Inter],[Intg||Letter],[Letter])
        Content of the matrix editor or spreadsheet.
        Ex1:current_sheet(1,2)
        Ex2:current_sheet(A1..A5,B,G)
        
        '''

     def curvature(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for curvature:
        curvature(Curve,Point)
        Curvature of curve C at point M.
        See also: 1/ osculating_circle 2/ evolute 
        Ex1:curvature(plot(x^2),point(1,1))
        Ex2:curvature([5*cos(t),5*sin(t)],t)
        Ex3:curvature([t,t^2],t)
        Ex4:curvature([t,t^2],t,1)
        Ex5:curvature([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t)
        Ex6:curvature([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t,7)
        Ex7: trigcos(curvature([2*cos(t),2*sin(t),3*t],t))
        
        '''

     def curve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for curve:
        curve(Expr)
        Reserved word.
        See also: 1/  
        
        '''

     def cyan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cyan:
        cyan(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def cycle2perm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cycle2perm:
        cycle2perm(Cycle)
        Converts the cycle c to a permutation.
        See also: 1/ cycles2permu 2/ permu2cycles 
        Ex1:cycle2perm([1,3,5])
        
        '''

     def cycle_basis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cycle_basis:
        cycle_basis(Graph(G))
        Returns the list of fundamental cycles in an undirected graph G.
        See also: 1/ find_cycles 2/ fundamental_cycle 
        Ex1:cycle_basis(graph("octahedron"))
        
        '''

     def cycle_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cycle_graph:
        cycle_graph(Intg(n)||Lst(V))
        Returns a cyclic graph on n vertices (or with vertices from list V).
        See also: 1/ graph 2/ path_graph 
        Ex1:cycle_graph(4)
        Ex2:cycle_graph(["one","two","three","four","five"])
        
        '''

     def cycleinv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cycleinv:
        cycleinv(Cycle(c))
        Returns the inverse cycle of the cycle c.
        See also: 1/ perminv 
        Ex1:cycleinv([1,3,5])
        
        '''

     def cycles2permu(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cycles2permu:
        cycles2permu(Lst(Cycle))
        Converts a product of cycles into a permutation.
        See also: 1/ permu2cycles 2/ cycle2perm 
        Ex1:cycles2permu([[1,3,5],[3,4]])
        
        '''

     def cyclotomic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cyclotomic:
        cyclotomic(Expr)
        N-th cyclotomic polynomial.
        See also: 1/ none 
        Ex1:cyclotomic(20)
        
        '''

     def cylinder(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for cylinder:
        cylinder(Pnt(A),Vect(v),Real(r),[Real(h)])
        Draws a cylinder with axis (A,v), with radius r [and with altitude h].
        See also: 1/ half_cone 2/ cone 
        Ex1:cylinder([0,0,0],[0,1,0],2)
        Ex2:cylinder([0,0,0],[0,1,0],2,-3)
        
        '''

     def dash_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dash_line:
        dash_line(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def dashdot_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dashdot_line:
        dashdot_line(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def dashdotdot_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dashdotdot_line:
        dashdotdot_line(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def dayofweek(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dayofweek:
        dayofweek(Int,Int,Int)
        dayofweek(d,m,y) returns the day of the given date (day,month,year) : 0 for sunday, 1 for monday ...6 for saturday.
        Ex1:dayofweek(21,4,2014)
        Ex2:dayofweek(15,10,1582)
        
        '''

     def deSolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for deSolve:
        deSolve(Eq,[TimeVar],FncVar)
        Solves a differential equation or a differential linear system with constant coefficients.
        See also: 1/ integrate 2/ diff 3/ odesolve 4/ plotode 5/ plotfiefd 
        Ex1:deSolve(y'+x*y=0)
        Ex2:deSolve(y'+x*y=0,y)
        Ex3:deSolve(y'+x*y=0,[0,1])
        Ex4:deSolve([y'+x*y=0,y(0)=1],y)
        Ex5:deSolve([y'=[[1,2],[2,1]]*y+[x,x+1],y(0)=[1,2]]) 
        Ex6:deSolve(y''+y=0,y)
        Ex7:deSolve([y''+y=sin(x),y(0)=1,y'(0)=2],y)
        Ex8:deSolve([y''+y=sin(x),y(0)=1,y'(0)=2],x,y)
        Ex9:deSolve([y''+y=sin(x),y(0)=1,y'(0)=2],[x,y])
        Ex10:deSolve(diff(y(t),t)+t*y(t)=0,t,y)
        Ex11:deSolve(diff(y(t),t)+t*y(t)=0,[t,y])
        Ex12:deSolve((y''+y=sin(x)) and (y(0)=1) and (y'(0)=2),y)
        Ex13:deSolve([z''+2*z'+z,z(0)=1,z'(0)=0],u,z)
        Ex14:deSolve([z''+2*z'+z,z(0)=1,z'(0)=0],z(u))
        Ex15:deSolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],t,z)
        Ex16:deSolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],z(t))
        
        '''

     def debut_enregistrement(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for debut_enregistrement:
        debut_enregistrement(Var(nom_du_dessin))
        Begins recording the commands making up the drawing; the name of the resulting procedure is the argument.
        See also: 1/ fin_enregistrement 
        Ex1:debut_enregistrement(maison)
        Ex2:debut_enregistrement(arbre)
        
        '''

     def degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for degree:
        degree(Poly(P),Var(Var))
        Degree of the polynomial P with respect to the second argument.
        See also: 1/ valuation 2/ size 3/ total_degree 
        Ex1:degree(x^3+x)
        Ex2:degree([1,0,1,0])
        Ex3:degree(x^3+x*y,y)
        
        '''

     def degree_centrality(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for degree_centrality:
        degree_centrality(Graph(G),[Vrtx(v)])
        Returns the degree centrality of a vertex v in a graph G or the list of degree centralities of vertices in G.
        See also: 1/ betweenness_centrality 2/ closeness_centrality 3/ harmonic_centrality 4/ information_centrality 5/ katz_centrality 
        Ex1:degree_centrality(graph(6,%{[0,2],[0,5],[1,3],[1,5],[2,5],[3,4],[3,5],[4,5]%}))
        
        '''

     def degree_sequence(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for degree_sequence:
        degree_sequence(Graph(G))
        Returns the list of degrees of the vertices of G (arc directions are ignored).
        See also: 1/ is_graphic_sequence 2/ is_regular 2/ sequence_graph 3/ vertex_degree 
        Ex1:degree_sequence(graph(trail(1,2,3,4,2)))
        
        '''

     def degrees(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for degrees:
        degrees(Real(rad))
        Converts radians to degrees (inexact).
        See also: 1/ radians 
        
        '''

     def delcols(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for delcols:
        delcols(Mtrx(A),Interval(n1..n2)||n1)
        Returns the matrix where the columns n1..n2 (or n1) of the matrix A are deleted.
        See also: 1/ delrows 
        Ex1:delcols([[1,2,3],[4,5,6],[7,8,9]],1..1)
        Ex2:delcols([[1,2,3],[4,5,6],[7,8,9]],0..1)
        Ex3:delcols([[1,2,3],[4,5,6],[7,8,9]],1)
        
        '''

     def delete_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for delete_arc:
        delete_arc(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Returns a modified copy of a digraph G with the arc e (or trail T or list of arcs E) removed from G.
        See also: 1/ add_arc 2/ delete_edge 3/ digraph 4/ edges 5/ has_arc 6/ trail 
        Ex1:delete_arc(digraph(trail(1,2,3,4,5,1)),[5,1])
        
        '''

     def delete_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for delete_edge:
        delete_edge(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Returns a modified copy of an undirected graph G with the edge e (or trail T or list of edges E) removed from G.
        See also: 1/ add_edge 2/ delete_arc 3/ edges 4/ graph 5/ has_edge 6/ trail 
        Ex1:delete_edge(cycle_graph(4),[1,2])
        
        '''

     def delete_vertex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for delete_vertex:
        delete_vertex(Graph(G),Vrtx(v)||Lst(V))
        Returns a modified copy of G with the vertex v (or vertices from V) removed.
        See also: 1/ add_vertex 2/ induced_subgraph 
        Ex1:delete_vertex(cycle_graph(5),[1,4])
        
        '''

     def delrows(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for delrows:
        delrows(Mtrx(A),Interval(n1..n2)||n1)
        Returns the matrix where the rows n1..n2 (or n1) of the matrix A are deleted.
        See also: 1/ delcols 
        Ex1:delrows([[1,2,3],[4,5,6],[7,8,9]],1..1)
        Ex2:delrows([[1,2,3],[4,5,6],[7,8,9]],0..1)
        Ex3:delrows([[1,2,3],[4,5,6],[7,8,9]],1)
        
        '''

     def deltalist(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for deltalist:
        deltalist(Lst)
        Returns the list of the differences of two terms in succession.
        See also: 1/  
        Ex1:deltalist([1,4,8,9])
        Ex2:deltalist([1,8,4,9])
        
        '''

     def denom(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for denom:
        denom(Frac(a/b) or RatFrac)
        Returns the denominator of the simplified fraction.
        See also: 1/ getDenom 2/ getNum 3/ numer 4/ f2nd 
        Ex1:denom(25/15)
        Ex2:denom((x^3-1)/(x^2-1))
        Ex3:denom(1+(x^3-1)/x^2)
        
        '''

     def densityplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for densityplot:
        densityplot(Expr,[x=xrange,y=yrange],[z],[xstep],[ystep])
        Shows in the plane with colors the graph of an expression of 2 variables.
        See also: 1/ plotfunc 2/ plotcontour 
        Ex1:densityplot(x^2-y^2,[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1)
        Ex2:densityplot(x^2-y^2,[x=-2..2,y=-2..2],z=-2..2,xstep=0.1,ystep=0.1)
        
        '''

     def departures(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for departures:
        departures(Graph(G),[Vrtx(v)])
        Returns the list of vertices of digraph G which are connected to v with arcs pointing away from v. If v is omitted, a list of departures is computed for every vertex in G.
        See also: 1/ out_degree 
        Ex1:departures(digraph(%{[1,2],[1,3],[2,3]%}),1)
        
        '''

     def derive(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for derive:
        derive(Expr or Fnc,[SeqVar or LstVar],[n])
        Returns the derivative with respect to the 2nd argument.
        See also: 1/ ' 2/ function_diff 3/ integrate 4/ taux_accroissement 5/ implicitdiff 
        Ex1:derive(x^3-x)
        Ex2:derive(x^3-x,x,3)
        Ex3:derive(x^3-x,quote(x)$3)
        Ex4:derive((diff@@3)('x^3-x'))
        Ex5:derive(x*y+z*y,y)
        Ex6:derive(x*y+z*y,y,z)
        Ex7:derive(x*y+z*y,[y,z])
        Ex8: f(x):=sin(2x);g:=diff(f);h:=diff(diff(f))
        
        '''

     def deriver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for deriver:
        deriver(Expr or Fnc,[SeqVar or LstVar],[n])
        Returns the derivative with respect to the 2nd argument.
        See also: 1/ ' 2/ function_diff 3/ integrate 4/ taux_accroissement 5/ implicitdiff 
        Ex1:deriver(x^3-x)
        Ex2:deriver(x^3-x,x,3)
        Ex3:deriver(x^3-x,quote(x)$3)
        Ex4:deriver((diff@@3)('x^3-x'))
        Ex5:deriver(x*y+z*y,y)
        Ex6:deriver(x*y+z*y,y,z)
        Ex7:deriver(x*y+z*y,[y,z])
        Ex8: f(x):=sin(2x);g:=diff(f);h:=diff(diff(f))
        
        '''

     def desolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for desolve:
        desolve(Eq,[TimeVar],FncVar)
        Solves a differential equation or a differential linear system with constant coefficients.
        See also: 1/ integrate 2/ diff 3/ odesolve 4/ plotode 5/ plotfiefd 
        Ex1:desolve(y'+x*y=0)
        Ex2:desolve(y'+x*y=0,y)
        Ex3:desolve(y'+x*y=0,[0,1])
        Ex4:desolve([y'+x*y=0,y(0)=1],y)
        Ex5:desolve([y'=[[1,2],[2,1]]*y+[x,x+1],y(0)=[1,2]]) 
        Ex6:desolve(y''+y=0,y)
        Ex7:desolve([y''+y=sin(x),y(0)=1,y'(0)=2],y)
        Ex8:desolve([y''+y=sin(x),y(0)=1,y'(0)=2],x,y)
        Ex9:desolve([y''+y=sin(x),y(0)=1,y'(0)=2],[x,y])
        Ex10:desolve(diff(y(t),t)+t*y(t)=0,t,y)
        Ex11:desolve(diff(y(t),t)+t*y(t)=0,[t,y])
        Ex12:desolve((y''+y=sin(x)) and (y(0)=1) and (y'(0)=2),y)
        Ex13:desolve([z''+2*z'+z,z(0)=1,z'(0)=0],u,z)
        Ex14:desolve([z''+2*z'+z,z(0)=1,z'(0)=0],z(u))
        Ex15:desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],t,z)
        Ex16:desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],z(t))
        
        '''

     def dessine_tortue(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dessine_tortue:
        dessine_tortue([Intg(n)])
        Draws the full (or not full if n=1) triangle representing the turtle.
        See also: 1/ crayon 
        Ex1:dessine_tortue()
        Ex2:dessine_tortue(0)
        Ex3:dessine_tortue(1)
        
        '''

     def det(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for det:
        det(Mtrx)
        Determinant of a square matrix M.
        See also: 1/ rref 2/ det_minor 3/ Det 
        Ex1:det([[1,2],[3,4]])
        Ex2:det([[1,2,3],[1,3,6],[2,5,7]])
        
        '''

     def det_minor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for det_minor:
        det_minor(Mtrx(A))
        Returns the determinant calculated with the calculus of minors.
        See also: 1/ det 
        Ex1:det_minor([[1,2],[3,4]])
        
        '''

     def developper(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for developper:
        developper(Expr)
        Full distribution of * and / over + and -.
        See also: 1/ texpand 2/ normal 3/ simplify 4/ ratnormal 
        Ex1:developper((x+y)*(z+1))
        Ex2:developper((a+b+c)/d)
        Ex3:developper((y+x)*(z+y)*(x+z))
        Ex4:developper((x+3)^4)
        Ex5:developper((2*x-2*1)*(x^2-3*x+2)+(x^2-2*x+3)*(2*x-3*1))
        
        '''

     def developper_transcendant(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for developper_transcendant:
        developper_transcendant(Expr)
        Expands transcendental expressions.
        See also: 1/ tcollect 2/ tlin 3/ lin 4/ trigexpand 
        Ex1:developper_transcendant(sin(2*x)+exp(x+y))
        Ex2:developper_transcendant(cos(x+y))
        Ex3:developper_transcendant(cos(3*x))
        
        '''

     def dfc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dfc:
        dfc(Real(x0),Int(n)||Real(eps))
        Returns the continued fraction development at x0 of order n or with precision eps.
        See also: 1/ dfc2f 2/ convert 
        Ex1:dfc(sqrt(2),5)
        Ex2:dfc(pi,4)
        Ex3:dfc(evalf(pi),1e-09)
        Ex4: convert(sqrt(2),confrac,'dev');dev
        Ex5: convert(9976/6961,confrac,'l');l
        
        '''

     def dfc2f(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dfc2f:
        dfc2f(LstFrac_Cont))
        Converts a continued fraction into a real.
        See also: 1/ dfc 2/ convert 
        Ex1:dfc2f([1,1,1])
        Ex2:dfc2f([1,2,[2]])
        
        '''

     def diag(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for diag:
        diag(Lst(l)||(Mtrx(A),[left||right||lu])||Lst(l),Lst(d),Lst(u))
        With 1 argument returns either the diagonal matrix with diagonal l or the diagonal of A, with 2 arguments returns the large left (lower) triangular part of A or the large right (upper) triangular part of A or factors A into 3 parts : strict left (lower) triangular, diagonal, strict right (upper) triangular and with 3 arguments returns the tridiagonal matrix with diagonals l,d,u.
        See also: 1/ identity 2/ lu 3/ BlockDiagonal 4/ upper 5/ lower 
        Ex1:diag([[1,2],[3,4]])
        Ex2:diag([1,2,3])
        Ex3:diag([[1,2],[3,4]],left)
        Ex4:diag([[1,2],[3,4]],right)
        Ex5:diag([[1,2],[3,4]],lu)
        Ex6:diag([1,2],[3,4,5],[6,7])
        
        '''

     def diff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for diff:
        diff(Expr or Fnc,[SeqVar or LstVar],[n])
        Returns the derivative with respect to the 2nd argument.
        See also: 1/ ' 2/ function_diff 3/ integrate 4/ taux_accroissement 5/ implicitdiff 
        Ex1:diff(x^3-x)
        Ex2:diff(x^3-x,x,3)
        Ex3:diff(x^3-x,quote(x)$3)
        Ex4:diff((diff@@3)('x^3-x'))
        Ex5:diff(x*y+z*y,y)
        Ex6:diff(x*y+z*y,y,z)
        Ex7:diff(x*y+z*y,[y,z])
        Ex8: f(x):=sin(2x);g:=diff(f);h:=diff(diff(f))
        
        '''

     def digraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for digraph:
        digraph([Lst(V)],[Set(E)],[Mtrx(A)],[options])
        Create a directed (un)weighted graph from vertices V, edges E and/or adjacency or weight matrix A. All parameters are optional.
        See also: 1/ graph 2/ trail 
        Ex1:digraph(%{[1,2],[2,3],[3,4],[4,1]%})
        Ex2:digraph([a,b,c,d],%{[[a,b],1.0],[[a,c],2.3],[[b,d],3.1],[[c,d],4]%})
        
        '''

     def dijkstra(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dijkstra:
        dijkstra(Graph(G),Vrtx(v),[Vrtx(w)||Lst(W)])
        Returns the cheapest weighted path from the vertex v to w (or to vertices from W) in an undirected graph G. The output is a list [[v1,v2,...,vk],d] (or a list of such lists) where v1,v2,...,vk are vertices along the path and d is the path weight.
        See also: 1/ allpairs_distance 2/ shortest_path 
        Ex1:dijkstra(graph(%{[[1,2],1],[[2,3],3],[[3,4],7],[[4,5],3],[[5,6],3],[[1,6],3]%}),1,4)
        
        '''

     def dim(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dim:
        dim(Mtrx)
        Returns the list which gives the dimension of the matrix specified as argument.
        See also: 1/ rowdim 2/ coldim 3/ sizes 4/ size 
        Ex1:dim([[1,2,3],[4,5,6]])
        
        '''

     def directed(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for directed:
        directed(Opt)
        Option for graph and digraph commands.
        See also: 1/ weighted 2/ graph 3/ digraph 
        
        '''

     def discard_edge_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for discard_edge_attribute:
        discard_edge_attribute(Graph(G),Edge(e),Seq(tag1=value1,tag2=value2,..))
        Discards the attributes with tags tag1, tag2, ... assigned to the edge e in G and returns a modified copy of G.
        See also: 1/ get_edge_attribute 2/ set_edge_attribute 3/ list_edge_attributes 
        Ex1:discard_edge_attribute(cycle_graph(3),[1,2],"cost")
        
        '''

     def discard_graph_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for discard_graph_attribute:
        discard_graph_attribute(Graph(G),Seq(tag1=value1,tag2=value2,..))
        Discards the graph attributes with tags tag1, tag2, ... and returns a modified copy of G.
        See also: 1/ get_graph_attribute 2/ set_graph_attribute 3/ list_graph_attributes 
        Ex1:discard_graph_attribute(cycle_graph(3),"name")
        
        '''

     def discard_vertex_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for discard_vertex_attribute:
        discard_vertex_attribute(Graph(G),Vrtx(v),Seq(tag1=value1,tag2=value2,..))
        Discards the attributes with tags tag1, tag2, ... assigned to the vertex v in G and returns a modified copy of G.
        See also: 1/ get_vertex_attribute 2/ set_vertex_attribute 3/ list_vertex_attributes 
        Ex1:discard_vertex_attribute(cycle_graph(3),1,"supply")
        
        '''

     def disjoint_union(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for disjoint_union:
        disjoint_union(Seq(G1,G2,...))
        Returns the disjoint union of graphs G1, G2, ... Vertices in the resulting graph are labelled with "k:v", where k is index of the corresponding k-th graph Gk and v is vertex in Gk.
        See also: 1/ graph_join 2/ graph_union 
        Ex1:disjoint_union(is_connected(disjoint_union(cycle_graph(5),path_graph(4))))
        
        '''

     def display(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for display:
        display([GeoObj or legende],Intg)
        Draws a geometrical object with colors black=0 red=1 green=2 yellow=3 blue=4, filled with the color in the interior of a closed curve,line_width_n (0<n<8) is for the width of the line and dash_line is for dotted line.
        See also: 1/ -< 2/ legende 
        Ex1:display(A,1)
        Ex2:display(F:=point(2+1.5*i),2)
        Ex3:display(point(2+1.5*i),2)
        Ex4:display(legende(1+i,"abc"),4)
        Ex5:display(square(0,1),filled+red)
        Ex6:display(carre(0,1),rempli+rouge)
        Ex7:display(circle(0,1),filled)
        Ex8:display(line(y=x),green+dash_line+line_width_2)
        Ex9:display(red);square(0,1);
        Ex10:display(red+filled);square(0,1);
        
        '''

     def disque(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for disque:
        disque(Real(r),[Real(a)],[Real(b)])
        Draws a disk with radius r (resp a sector with angle (0,a) or (a,b)), tangent at the turtle position.
        See also: 1/ rond 
        Ex1: disque 30
        Ex2:disque(40)
        Ex3:disque(40,90)
        Ex4:disque(40,10,100)
        
        '''

     def disque_centre(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for disque_centre:
        disque_centre(Real(r),[Real(a)],[Real(b)])
        Draws a disk with radius r (resp a sector with angle (0,a) or (a,b)) with center at the turtle position.
        See also: 1/ rond 
        Ex1: disque_centre 30
        Ex2:disque_centre(40)
        Ex3:disque_centre(40,90)
        Ex4:disque_centre(40,10,100)
        
        '''

     def distance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for distance:
        distance((Pnt or Cplx),(Pnt or Cplx or Curve))
        Calculates the distance between 2 points or a point and a curve.
        See also: 1/ distance2 2/ distanceat 3/ distanceatraw 
        Ex1:distance(point(0),point(1+i))
        Ex2:distance(1+i,segment(1-i,i))
        Ex3:distance(0,1+i)
        
        '''

     def distance2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for distance2:
        distance2((Pnt or Cplx),(Pnt or Cplx or Curve))
        Calculates the square of the distance between 2 points or a point and a curve.
        See also: 1/ distance 
        Ex1:distance2(point(0),point(1+i))
        Ex2:distance2(1+i,segment(1-i,i))
        Ex3:distance2(0,1+i)
        
        '''

     def distanceat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for distanceat:
        distanceat(GeoObj(A),GeoObj(B),(Pnt or Cplx))
        distanceat(A,B,z0) displays at point(z0), with a legend, the distance between 2 geometrical objects
        See also: 1/ distance 2/ distanceatraw 
        Ex1: A:=point(0);B:=point(1+i);distanceat(A,B,(1+i)/2)
        Ex2: A:=point(0);s:=segment(1-i,i);distanceat(A,s,1)
        
        '''

     def distanceatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for distanceatraw:
        distanceatraw(GeoObj(A),GeoObj(B),(Pnt or Cplx(z0)))
        distanceatraw(A,B,z0) displays at the point(z0), the distance between 2 geometrical objects.
        See also: 1/ distance 2/ distanceat 
        Ex1: A:=point(0);B:=point(1+i);distanceatraw(A,B,(1+i)/2)
        Ex2: A:=point(0);s:=segment(1-i,i);distanceatraw(A,s,1)
        
        '''

     def divergence(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for divergence:
        divergence(Lst(A,B,C),Lst(x,y,z))
        divergence([A,B,C],[x,y,z])=dA/dx+dB/dy+dC/dz.
        See also: 1/ derive 2/ curl 
        Ex1:divergence([x^2+y,x+z+y,z^3+x^2],[x,y,z])
        
        '''

     def divide(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for divide:
        divide((Vect or Poly),(Vect or Poly),[Var])
        Euclidean quotient and remainder of 2 polynomials.
        See also: 1/ rem 2/ quo 3/ iquorem 
        Ex1:divide([1,2,3,4],[-1,2])
        Ex2:divide(x^3+2x^2+3x+4,-x+2)
        Ex3:divide(t^3+2t^2+3t+4,-t+2,t)
        Ex4:divide(t^4-1,(t+1)^2,t)
        
        '''

     def divis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for divis:
        divis(Poly(P) or LstPoly)
        Returns the list of divisors of a polynomial.
        See also: 1/ idivis 2/ factors 3/ poly2symb 
        Ex1:divis(x^2-1)
        Ex2:divis(x^4-1)
        Ex3:divis(t^4-1)
        Ex4:divis([x^4-1,x^2-1])
        Ex5:divis([x^4-1,t^2-1])
        Ex6:divis(poly2symb([1,0,0,0,-1],x))
        
        '''

     def division_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for division_point:
        division_point(Pnt or Cplx(a),Pnt or Cplx(b),Cplx(k))
        Returns the point M such that (z-a)=k*(z-b) and z=affix of M (MA=k*MB).
        See also: 1/ harmonic_conjugate 2/ is_conjugate 
        Ex1:division_point(i,2+i,3+i)
        Ex2:division_point(i,2+i,3)
        
        '''

     def divisors(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for divisors:
        divisors(Intg(a) or LstIntg)
        Returns the list of divisors of an integer.
        See also: 1/ divis 2/ ifactors 
        Ex1:divisors(36)
        Ex2:divisors([36,49])
        
        '''

     def divmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for divmod:
        divmod(Intg(a),Intg(b))
        Euclidean quotient and remainder of 2 integers.
        See also: 1/ irem 2/ iquo 3/ quorem 
        Ex1:divmod(125,15)
        Ex2:divmod(125,41)
        Ex3:divmod(25+12*i,5+7*i)
        
        '''

     def divpc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for divpc:
        divpc(Poly,Poly,Intg(n))
        nth-degree Taylor-poly for the quotient of 2 polynomials.
        See also: 1/ series 2/ quorem 
        Ex1:divpc(x^4+x+2,x^2+1,5)
        
        '''

     def dnewton_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dnewton_solver:
        dnewton_solver(Opt)
        Argument for fsolve giving the method for solving a system of numerical equations.
        See also: 1/ fsolve 
        Ex1: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver)
        Ex2: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver)
        Ex3: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver)
        Ex4: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver)
        Ex5: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver)
        Ex6: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)
        
        '''

     def dodecahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dodecahedron:
        dodecahedron(Pnt(A),Pnt(B),Pnt(C))
        Draws a dodecahedron with center A, vertex B and such that the plane ABC contains an axis of symmetry of the dodecahedron.
        See also: 1/ icosahedron 2/ octahedron 3/ cube 4/ tetrahedron 
        Ex1:dodecahedron([0,0,0],[0,2,sqrt(5)/2+3/2],[0,0,1])
        Ex2:dodecahedron(evalf([0,0,0],[3,2,4],[1,1,0]))
        
        '''

     def domain(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for domain:
        domain(Expr)
        Returns the definition domain of an expression.
        Ex1:domain(log(x+1))
        Ex2:domain(log(x)+asin(x))
        
        '''

     def dot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dot:
        dot(Vect(v1),Vect(v2))
        Scalar product.
        See also: 1/ * 2/ cross 3/ .* 4/ hadamard 
        Ex1:dot([1,2],[3,4])
        Ex2:dot([3,2,4],[3,2,4])
        Ex3:dot([[1,2],[3,4]],[[3,2],[4,5]])
        
        '''

     def dotP(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dotP:
        dotP(Vect(v1),Vect(v2))
        Scalar product.
        See also: 1/ * 2/ cross 3/ .* 4/ hadamard 
        Ex1:dotP([1,2],[3,4])
        Ex2:dotP([3,2,4],[3,2,4])
        Ex3:dotP([[1,2],[3,4]],[[3,2],[4,5]])
        
        '''

     def dot_paper(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dot_paper:
        dot_paper(Real(ux),Real(uy),Real(t))
        Draws in the rectangle [xmin..xmax]*[ymin..ymax], the vertices of the grid formed by the lines y=n*uy and the lines x=u*ux at an angle of t!=0 with the horizontal.
        Ex1:dot_paper(1,pi/3,sqrt(3)/2)
        Ex2:dot_paper(1,pi/3,sqrt(3)/2,x=-1..4,y=-2..2)
        Ex3:dot_paper(0.5,3*pi/4,0.5)
        
        '''

     def dotprod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dotprod:
        dotprod(Vect(v1),Vect(v2))
        Scalar product.
        See also: 1/ * 2/ cross 3/ .* 4/ hadamard 
        Ex1:dotprod([1,2],[3,4])
        Ex2:dotprod([3,2,4],[3,2,4])
        Ex3:dotprod([[1,2],[3,4]],[[3,2],[4,5]])
        
        '''

     def draw_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_arc:
        draw_arc(Intg(x),Intg(y),Intg(rx),Intg(ry),Real(theta1),Real(theta2),Intg(col))
        Pixelised ellipsis arc.
        See also: 1/ draw_pixel 2/ draw_circle 
        Ex1: clear(); draw_arc(100,80,40,20,0,pi,blue); show_pixels();
        
        '''

     def draw_circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_circle:
        draw_circle(Intg(x),Intg(y),Intg(r),Intg(col))
        Pixelised circle, add filled to the color to fill the circle.
        See also: 1/ draw_pixel 2/ draw_arc 
        Ex1: clear(); draw_circle(100,60,20,blue); show_pixels();
        Ex2: clear(); draw_circle(100,60,20,blue+filled); show_pixels();
        
        '''

     def draw_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_graph:
        draw_graph(Graph(G),[opts])
        Returns the graphic representation of G obtained by using various algorithms (which can optionally be fine tuned by appending a sequence of options after the first argument).
        See also: 1/ highlight_edges 2/ highlight_subgraph 3/ highlight_trail 4/ highlight_vertex 5/ set_vertex_positions 6/ get_vertex_positions 
        Ex1:draw_graph(graph("petersen"))
        Ex2:draw_graph(graph("petersen"),spring)
        Ex3:draw_graph(random_tree(30))
        Ex4:draw_graph(sierpinski_graph(5,3,at_triangle))
        Ex5:draw_graph(graph("soccerball"))
        
        '''

     def draw_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_line:
        draw_line(Intg(x1),Intg(y1),Intg(x2),Intg(y2),Intg(col))
        Pixelised segment.
        See also: 1/ draw_pixel 2/ draw_rectangle 3/ draw_polygon 
        Ex1: clear(); draw_line(10,10,60,60,blue); show_pixels();
        
        '''

     def draw_pixel(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_pixel:
        draw_pixel(Intg(x),Intg(y),Intg(col))
        Pixel on and adds to the list of pixels. Run set_pixel() or show_pixels() to display, set_pixel(n) to zoom.
        See also: 1/ clear 2/ show_pixels 3/ draw_line 4/ draw_rectangle 5/ draw_polygon 
        Ex1: clear(); set_pixel(4); draw_pixel(1,2,red); show_pixels();
        
        '''

     def draw_polygon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_polygon:
        draw_polygon(Lst(l),Intg(col))
        Pixelised polygon, add filled to the color to fill the rectangle.
        See also: 1/ draw_pixel 2/ draw_line 3/ draw_rectangle 
        Ex1: clear(); draw_polygon([[50,30],[100,10],[20,70]],red); show_pixels();
        Ex2: clear(); draw_polygon([[50,30],[100,10],[20,70]],red+filled); show_pixels();
        
        '''

     def draw_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for draw_rectangle:
        draw_rectangle(Intg(x),Intg(y),Intg(w),Intg(h),Intg(col))
        Pixelised rectangle, add filled to the color to fill the rectangle.
        See also: 1/ draw_pixel 2/ draw_line 3/ draw_polygon 
        Ex1: clear(); draw_rectangle(10,20,30,40,red); show_pixels();
        Ex2: clear(); draw_rectangle(10,20,30,40,red+filled); show_pixels();
        
        '''

     def droit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for droit:
        droit(Equal(a=b) or Interval(a..b) or Str,Intg)
        Returns the right part of an equality, of an interval, of a list or of a string.
        See also: 1/ left 2/ mid 3/ tail 4/ head 
        Ex1:droit(a=b)
        Ex2:droit(x^2+1=5)
        Ex3:droit(1..5)
        Ex4:droit("abcdefg",3)
        
        '''

     def droite_tangente(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for droite_tangente:
        droite_tangente(Expr(f(x)),[Var],Expr(a))
        Draws the tangent to y=f(x) at x=a.
        See also: 1/ tangent 2/ LineTan 
        Ex1:droite_tangente(sin(x),pi/4)
        Ex2:droite_tangente(sin(t),t=pi/4)
        Ex3:droite_tangente(sin(t),t,pi/4)
        Ex4:droite_tangente(x^2-x,1)
        
        '''

     def dsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dsolve:
        dsolve(Eq,[TimeVar],FncVar)
        Solves a differential equation or a differential linear system with constant coefficients.
        See also: 1/ integrate 2/ diff 3/ odesolve 4/ plotode 5/ plotfiefd 
        Ex1:dsolve(y'+x*y=0)
        Ex2:dsolve(y'+x*y=0,y)
        Ex3:dsolve(y'+x*y=0,[0,1])
        Ex4:dsolve([y'+x*y=0,y(0)=1],y)
        Ex5:dsolve([y'=[[1,2],[2,1]]*y+[x,x+1],y(0)=[1,2]]) 
        Ex6:dsolve(y''+y=0,y)
        Ex7:dsolve([y''+y=sin(x),y(0)=1,y'(0)=2],y)
        Ex8:dsolve([y''+y=sin(x),y(0)=1,y'(0)=2],x,y)
        Ex9:dsolve([y''+y=sin(x),y(0)=1,y'(0)=2],[x,y])
        Ex10:dsolve(diff(y(t),t)+t*y(t)=0,t,y)
        Ex11:dsolve(diff(y(t),t)+t*y(t)=0,[t,y])
        Ex12:dsolve((y''+y=sin(x)) and (y(0)=1) and (y'(0)=2),y)
        Ex13:dsolve([z''+2*z'+z,z(0)=1,z'(0)=0],u,z)
        Ex14:dsolve([z''+2*z'+z,z(0)=1,z'(0)=0],z(u))
        Ex15:dsolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],t,z)
        Ex16:dsolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],z(t))
        
        '''

     def duration(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for duration:
        duration(Audio(clip))
        Returns the duration of an audio clip, in seconds.
        See also: 1/ bit_depth 2/ channels 3/ channel_data 4/ samplerate 
        Ex1:duration(readwav("/some/file"))
        
        '''

     def dwt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for dwt:
        dwt((Lst||Mtrx)(data),[opts])
        Returns the discrete wavelet transform of data (either 1D or 2D), optionally with a sequence of options.
        See also: 1/ idwt 2/ fft 3/ ifft 
        Ex1:dwt([0.0,0.5,0.25,1.0,0.75,-0.25,-0.5,0.0])
        Ex2:dwt([[15,25,5,70],[21,33,12,7],[64,18,50,10],[5,17,35,28]])
        
        '''

     def e(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for e:
        e()
        exp(1).
        See also: 1/ i 2/ pi 
        Ex1: evalf(e)
        
        '''

     def e2r(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for e2r:
        e2r(Expr, LstVar or [Var])
        Returns the coefficients of a polynomial with respect to the 2nd argument or if the second argument is a list the internal format of the polynomial.
        See also: 1/ poly2symb 2/ r2e 
        Ex1:e2r(x*3+2.1)
        Ex2:e2r(3*x*y+2*y+1,y)
        Ex3:e2r(3*x*y+2*y+1,x,y)
        Ex4:e2r(3*x*y+2*y+1,[x,y])
        Ex5:e2r(-x^4+x*3*y+2+y^2*z,[x,y,z])
        Ex6:e2r(-x^4+x*3*y+2+y^2*z,[x,y,z])
        
        '''

     def ecart_type(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ecart_type:
        ecart_type(Lst||Mtrx,[Lst])
        Returns the standard deviation of the elements of its argument with an optional second argument as weight or the list of standard deviations of the columns of a matrix.
        See also: 1/ mean 2/ variance 3/ stddevp 
        Ex1:ecart_type([1,2,3])
        Ex2:ecart_type([1,2,3],[1,2,1])
        Ex3:ecart_type([[1,2,3],[5,6,7]])
        
        '''

     def ecart_type_population(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ecart_type_population:
        ecart_type_population(Lst||Mtrx,[Lst])
        Returns an unbiased estimate of the population standard deviation of the sample (first argument) with an optional list of weight as second argument.
        See also: 1/ mean 2/ stddev 
        Ex1:ecart_type_population([1,2,3])
        Ex2:ecart_type_population([1,2,3],[1,2,1])
        Ex3:ecart_type_population([[1,2,3],[5,6,7]])
        
        '''

     def ecef2geodetic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ecef2geodetic:
        ecef2geodetic(Real(x),Real(y),Real(z))
        Converts ECEF coordinates to geodetic LLA (WGS84 standard).
        See also: 1/ geodetic2ecef 
        Ex1:ecef2geodetic(4293457.10728,1360697.85689,4501106.55299)
        
        '''

     def ecm_factor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ecm_factor:
        ecm_factor(Intg(a),[Intg(B1)])
        Factorization of integer n by the Elliptic Curve Method algorithm, B1 smoothness optional parameter.
        Ex1:ecm_factor(1000000000000000003000000000000000000000000000000000031000000000000000093)
        
        '''

     def edge_connectivity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for edge_connectivity:
        edge_connectivity(graph(G))
        Returns the largest integer k such that an undirected connected graph G remains connected after fewer than k edges are removed.
        See also: 1/ is_two_edge_connected 2/ is_edge_cut 3/ vertex_connectivity 
        Ex1:edge_connectivity(graph("petersen"))
        Ex2:edge_connectivity(graph("clebsch"))
        Ex3:edge_connectivity(complete_graph(5))
        
        '''

     def edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for edges:
        edges(Graph(G),[weights])
        Return the list of edges in G [including weights].
        See also: 1/ add_edge 2/ incident_edges 3/ set_edge_weight 4/ get_edge_weight 
        Ex1:edges(complete_graph(4))
        
        '''

     def egcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for egcd:
        egcd((Poly or Lst),(Poly or Lst),[Var])
        Extended greatest common divisor of 2 polynomials.
        See also: 1/ gcd 2/ iegcd 
        Ex1:egcd((x-1)^2,x^3-1)
        Ex2:egcd((X-1)^2,X^3-1,X)
        Ex3:egcd([1,-2,1],[1,0,0,-1])
        Ex4:egcd([1,-2,1],[1,-1,2])
        
        '''

     def egv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for egv:
        egv(Mtrx)
        Computes the eigenvectors of a diagonalizable matrix.
        See also: 1/ egvl 2/ jordan 
        Ex1:egv([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex2:egv([[1,1,3],[1,3,1],[3,1,1]])
        
        '''

     def egvl(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for egvl:
        egvl(Mtrx(A))
        Returns the Jordan matrix associated to A when the eigenvalues are calculable.
        See also: 1/ egv 2/ jordan 
        Ex1:egvl([[4,1],[-4,0]])
        Ex2:egvl([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex3:egvl([[1,1,3],[1,3,1],[3,1,1]])
        
        '''

     def eigVc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eigVc:
        eigVc(Mtrx)
        Computes the eigenvectors of a diagonalizable matrix.
        See also: 1/ egvl 2/ jordan 
        Ex1:eigVc([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex2:eigVc([[1,1,3],[1,3,1],[3,1,1]])
        
        '''

     def eigVl(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eigVl:
        eigVl(Mtrx(A))
        Returns the Jordan matrix associated to A when the eigenvalues are calculable.
        See also: 1/ egv 2/ jordan 
        Ex1:eigVl([[4,1],[-4,0]])
        Ex2:eigVl([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex3:eigVl([[1,1,3],[1,3,1],[3,1,1]])
        
        '''

     def eigenvals(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eigenvals:
        eigenvals(Mtrx)
        Returns the sequence of the (calculable) eigenvalues of a matrix.
        See also: 1/ egv 2/ jordan 
        Ex1:eigenvals([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex2:eigenvals([[1,1,3],[1,3,1],[3,1,1]])
        Ex3:eigenvals([[4,1],[-4,0]])
        
        '''

     def eigenvalues(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eigenvalues:
        eigenvalues(Mtrx)
        Returns the sequence of the (calculable) eigenvalues of a matrix.
        See also: 1/ egv 2/ jordan 
        Ex1:eigenvalues([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex2:eigenvalues([[1,1,3],[1,3,1],[3,1,1]])
        Ex3:eigenvalues([[4,1],[-4,0]])
        
        '''

     def eigenvectors(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eigenvectors:
        eigenvectors(Mtrx)
        Computes the eigenvectors of a diagonalizable matrix.
        See also: 1/ egvl 2/ jordan 
        Ex1:eigenvectors([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex2:eigenvectors([[1,1,3],[1,3,1],[3,1,1]])
        
        '''

     def eigenvects(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eigenvects:
        eigenvects(Mtrx)
        Computes the eigenvectors of a diagonalizable matrix.
        See also: 1/ egvl 2/ jordan 
        Ex1:eigenvects([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex2:eigenvects([[1,1,3],[1,3,1],[3,1,1]])
        
        '''

     def element(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for element:
        element((Curve or Real_interval),[Val])
        Shows a point chosen on a curve or a real chosen in an interval
        See also: 1/ is_element 
        Ex1: t:=element(0..1)
        Ex2: t:=element(0..1,0.3)
        Ex3: t:=element(0..1,0.3,0.02)
        Ex4: P:=element(circle(i,1),t)
        Ex5: M:=element(circle(i,1))
        Ex6: N:=element(circle(i,1),pi/2)
        
        '''

     def eliminate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eliminate:
        eliminate(LstEq(eqs),LstVar(vars))
        Eliminates the variables vars in a list of algebraic equations.
        Ex1:eliminate([x=v0*t,y=y0-g*t^2],t)
        Ex2:eliminate([x+y+z+t-2,x*y*t=1,x^2+t^2=z^2],[x,z])
        
        '''

     def ellipse(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ellipse:
        ellipse(Pnt(F1),Pnt(F2),(Pnt(M) or Real(a)))
        ellipse(F1,F2,M)=ellipse with foci F1,F2 through M or such that MF1+MF2=2*a (geo2d) and ellipse(p(x,y)) draws the conic if deg(p)=2.
        See also: 1/ hyperbola 2/ parabola 
        Ex1:ellipse(-1,1,point(1+i))
        Ex2:ellipse(-1,1,1+sqrt(5))
        Ex3:ellipse(2x^2+3y^2-x*y-10)
        Ex4:ellipse(point(-1,0,0),point(1,0,0),point(1,1,1))
        Ex5:ellipse(x^2+2y^2-y-2)
        
        '''

     def emd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for emd:
        emd(Lst(data),[opts])
        Empirical mode decomposition of a discrete real signal.
        See also: 1/ imfplot 2/ hht 
        Ex1:emd(apply(x->cos(10*x^2*pi),linspace(-pi,pi)))
        
        '''

     def entry(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for entry:
        entry(Intg(n))
        Returns the (n+1)th question of the command history if n>=0 or, the (-n)th previous question if n<0 (by default n=-1 for the previous question).
        See also: 1/ ans 
        Ex1:entry()
        Ex2:entry(2)
        Ex3:entry(-2)
        
        '''

     def envelope(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for envelope:
        envelope(Expr(Xpr),Var(t)||[x,y,t])
        Returns the envelope of the curves with equation Xpr=0 as t varies.
        See also: 1/ tangent 2/ locus 
        Ex1:envelope(y+x*tan(t)-2*sin(t),t)
        Ex2:envelope(v+u*tan(t)-3*sin(t),[u,v,t])
        
        '''

     def epsilon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for epsilon:
        epsilon(NULL)
        Returns the value of epsilon of the CAS configuration.
        See also: 1/  epsilon2zero 
        Ex1:epsilon()
        
        '''

     def epsilon2zero(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for epsilon2zero:
        epsilon2zero(Expr)
        Values < epsilon are replaced by zero.
        See also: 1/ evalf 
        Ex1:epsilon2zero(1e-13+x+5)
        
        '''

     def equal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for equal:
        equal(Expr,Expr)
        Prefixed version of =.
        See also: 1/ = 2/ equal2diff 3/ equal2list 4/ left 5/ right 
        Ex1: 2*x=4
        Ex2:equal(2*x,4)
        Ex3:equal(x^2-3x+2,0)
        
        '''

     def equal2diff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for equal2diff:
        equal2diff(Equal)
        A=B or equal(A,B) is converted into the difference A-B.
        See also: 1/ left 2/ right 3/ equal2list 4/ equal 5/ = 
        Ex1:equal2diff(x=2)
        Ex2:equal2diff(equal(x,2))
        
        '''

     def equal2list(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for equal2list:
        equal2list(Equal)
        A=B or equal(A,B) is converted into the list [A,B].
        See also: 1/ left 2/ right 3/ equal2diff 4/ equal 5/ = 
        Ex1:equal2list(x=2)
        Ex2:equal2list(equal(x,2))
        
        '''

     def equation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for equation:
        equation(GeoObj, VectParam)
        equation returns the cartesian equation of a curve.
        See also: 1/ parameq 
        Ex1:equation(line(1-i,i),[x,y])
        
        '''

     def equilateral_triangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for equilateral_triangle:
        equilateral_triangle((Pnt(A) or Cplx),(Pnt(B) or Cplx),[Pnt(P)],[Var(C)])
        equilateral_triangle(A,B) (resp equilateral_triangle(A,B,P)) draws the direct equilateral triangle ABC with side AB (resp in the half-plane ABP).
        See also: 1/ triangle 
        Ex1:equilateral_triangle(point(1+i),0)
        Ex2:equilateral_triangle(0,1+i,C)
        Ex3:equilateral_triangle(point(0,0,0),point(3,3,3),point(0,0,3))
        Ex4:equilateral_triangle(point(0,0,0),point(3,3,3),point(0,0,3),C)
        
        '''

     def erf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for erf:
        erf(Real(x0))
        Returns the approximate value of 2/sqrt(pi)*int(exp(-t^2),t,0,x0).
        See also: 1/ erfc 
        Ex1:erf(1)
        Ex2:erf(1/(sqrt(2)))*1/2
        
        '''

     def erfc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for erfc:
        erfc(Real(x0))
        Returns the approximate value of 2/sqrt(pi)*int(exp(-t^2),t,x0,+infinity).
        See also: 1/ erf 
        Ex1:erfc(1)
        Ex2:erfc(1/(sqrt(2)))*1/2
        
        '''

     def error(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for error:
        error(Str)
        Generates the display of an error in a program.
        See also: 1/ try 2/ catch 
        Ex1:error("Argument should be integer")
        Ex2:error("je provoque une erreur")
        
        '''

     def est_permu(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for est_permu:
        est_permu(Lst)
        Returns 1 if the argument is a permutation and 0 otherwise.
        See also: 1/ is_cycle 2/ permu2cycles 
        Ex1:est_permu([4,2,3,1])
        Ex2:est_permu([4,2,3,1,0])
        
        '''

     def euler(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for euler:
        euler(Intg(n))
        Euler's function (euler(n)=card({p<n,gcd(n,p)=1})).
        See also: 1/ gcd 
        Ex1:euler(11)
        Ex2:euler(6)
        
        '''

     def euler_gamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for euler_gamma:
        euler_gamma()
        Euler's constant=euler_gamma=limit(sum(1/k,k,1,n)-ln(n),n,+infinity).
        Ex1: evalf(euler_gamma)
        
        '''

     def euler_lagrange(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for euler_lagrange:
        euler_lagrange(Expr(f),[(Var(x),[Var||Lst(y)]) || y(x) || Lst(y(x))])
        Returns the (system of) Euler-Lagrange equation(s) for the functional F=int(f,x=a..b).
        See also: 1/ dsolve 2/ bvpsolve 3/ convex 4/ jacobi_equation 5/ conjugate_equation 
        Ex1:euler_lagrange(x^2*y'^2+y^2)
        Ex2:euler_lagrange(sqrt(x'^2+y'^2),[x(t),y(t)])
        Ex3: assume(y>=0):; euler_lagrange(sqrt((1+y'^2)/y),t,y)
        
        '''

     def eval_level(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for eval_level:
        eval_level([Intg(n)])
        Evaluation level in interactive mode.
        Ex1:eval_level()
        Ex2:eval_level(1)
        Ex3: purge(a,b,c);eval_level(1);a:=b+1; b:=c+1;c:=3;
        Ex4: purge(a,b,c);eval_level(2);a:=b+1; b:=c+1;c:=3;
        Ex5: purge(a,b,c);eval_level(3);a:=b+1; b:=c+1;c:=3;
        
        '''

     def evala(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for evala:
        evala(Expr)
        Simplifies the expression.
        See also: 1/ simplify 
        Ex1:evala(2*x+y=1)
        Ex2:evala(2*x*2)
        Ex3:evala((2*x+1)^2)
        
        '''

     def evalb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for evalb:
        evalb(Expr)
        Boolean evaluation of the argument.
        See also: 1/ evalf 2/ eval 
        Ex1:evalb(a==2)
        Ex2:evalb(sqrt(2)+pi>a)
        
        '''

     def evalc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for evalc:
        evalc(Expr)
        Returns a complex expression simplified to the format real+i*imag.
        See also: 1/ normal 
        Ex1:evalc(-3+4*i+exp(i))
        Ex2:evalc(1/(x+y*i))
        
        '''

     def evalf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for evalf:
        evalf(Expr,[Int])
        Numerical evaluation of the first argument (we can give the number of digits as second argument).
        See also: 1/ evalb 2/ eval 
        Ex1:evalf(2/3)
        Ex2:evalf(2/3,2)
        Ex3:evalf(2*sin(1))
        Ex4:evalf(2*sin(1),40)
        Ex5:evalf(sqrt(2)+pi)
        Ex6:evalf(sqrt(2)+pi,30)
        
        '''

     def evalm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for evalm:
        evalm(Expr)
        Evaluates its argument.
        See also: 1/ evalf 
        Ex1:evalm(2*sin(pi))
        
        '''

     def even(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for even:
        even(Intg(n))
        Returns 1 if the integer is even, else returns 0.
        See also: 1/ odd 
        Ex1:even(6)
        Ex2:even(1251)
        
        '''

     def evolute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for evolute:
        evolute(Curve)
        Evolute of a curve C.
        See also: 1/ curvature 2/ osculating_circle 
        Ex1:evolute(plot(x^2))
        Ex2:evolute([t,t^2],t)
        Ex3:evolute([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t)
        
        '''

     def exact(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exact:
        exact(Expr)
        Converts the expression to a rational or real expression.
        See also: 1/  
        Ex1:exact(-2)
        Ex2:exact(1.5)
        Ex3:exact(1.4141)
        Ex4:exact(0.156381102937)
        
        '''

     def exbisector(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exbisector:
        exbisector((Pnt(A) or Cplx),(Pnt(B) or Cplx),(Pnt(C) or Cplx))
        Draws the exterior bisector of the angle (AB,AC) given by 3 points A,B,C.
        See also: 1/ angle 2/ bisector 
        Ex1:exbisector(0,1,i)
        
        '''

     def excircle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for excircle:
        excircle((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        excircle(A,B,C) draws the A-excircle of the triangle ABC.
        See also: 1/ incircle 2/ circumcircle 
        Ex1:excircle(0,1,1+i)
        
        '''

     def execute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for execute:
        execute(Str)
        Instruction transforming a string into a command or into a number.
        See also: 1/ string 
        Ex1:execute("ifactor(54)")
        Ex2:execute("123")
        Ex3:execute("0123")
        Ex4:execute(sin,x)
        
        '''

     def exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exp:
        exp(Expr or Opt)
        Exponential or option of the convert or convertir command (id trig2exp).
        See also: 1/ ln 2/ convert 3/ trig2exp 
        Ex1:exp(0)
        Ex2: convert(cos(x),exp)
        
        '''

     def exp2list(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exp2list:
        exp2list(Expr)
        Returns the list made with the righthand member of (var=expr0 or var=expr1), to be used after solve in TI mode.
        See also: 1/ list2exp 
        Ex1:exp2list((x=2) or (x=0))
        Ex2:exp2list((x=3 and y=9) or (x=-1 and y=1) )
        
        '''

     def exp2pow(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exp2pow:
        exp2pow(Expr)
        Transforms exp(n*ln(x)) to x^n.
        See also: 1/ pow2exp 
        Ex1:exp2pow(exp(3*ln(x)))
        Ex2:exp2pow(exp(x*ln(x)))
        
        '''

     def exp2trig(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exp2trig:
        exp2trig(Expr)
        Transforms the complex exponential into sine and cosine.
        See also: 1/ trig2exp 2/ atrig2ln 
        Ex1:exp2trig(exp(i*x))
        Ex2:exp2trig(exp(-i*x))
        
        '''

     def expand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for expand:
        expand(Expr)
        Full distribution of * and / over + and -.
        See also: 1/ texpand 2/ normal 3/ simplify 4/ ratnormal 
        Ex1:expand((x+y)*(z+1))
        Ex2:expand((a+b+c)/d)
        Ex3:expand((y+x)*(z+y)*(x+z))
        Ex4:expand((x+3)^4)
        Ex5:expand((2*x-2*1)*(x^2-3*x+2)+(x^2-2*x+3)*(2*x-3*1))
        
        '''

     def expexpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for expexpand:
        expexpand(Expr)
        Expands exponentials.
        See also: 1/ texpand 2/ lnexpand 3/ trigexpand 
        Ex1:expexpand(exp(3*x))
        
        '''

     def expln(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for expln:
        expln(Opt)
        Option of the convert or convertir command (id trig2exp).
        See also: 1/ exp 2/ ln 3/ convert 4/ trig2exp 
        Ex1: convert(cos(x),expln)
        
        '''

     def exponential(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponential:
        exponential(Real(lambda),Real(x))
        Returns the probability density at x of the exponential law of parameter lambda.
        See also: 1/ exponential_cdf 2/ exponential_icdf 3/ randvector 4/ ranm 
        Ex1:exponential(2.1,3.5)
        Ex2:exponential(2.1,0.5)
        Ex3: randvector(3,exponential,1.2)
        Ex4: ranm(4,3,exponential,1.2)
        
        '''

     def exponential_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponential_cdf:
        exponential_cdf(Real(lambda),Real(x0),[Real(y0)])
        Returns the probability that a exponential random variable of parameter lambda is less than x0 (or between x0 and y0).
        See also: 1/ exponentiald 2/ exponential_icdf 
        Ex1:exponential_cdf(4.2,2.1)
        Ex2:exponential_cdf(4.2,2.1,3.2)
        
        '''

     def exponential_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponential_icdf:
        exponential_icdf(Real(lambda),Real(x0),Real(p))
        Returns h such that the probability that a exponential random variable of parameter lambda is less than h is p (0<=p<=1).
        See also: 1/ exponential_cdf 2/ exponentiald 
        Ex1:exponential_icdf(4.2,0.95)
        Ex2:exponential_icdf(4.2,0.6)
        
        '''

     def exponential_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponential_regression:
        exponential_regression(Lst||Mtrx(A),[Lst])
        Returns the coefficients (a,b) of y=b*a^x : it is the best exponential which approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ logarithmic_regression 
        Ex1:exponential_regression([[1.0,2.0],[0.0,1.0],[4.0,7.0]])
        Ex2:exponential_regression([1.0,0.0,4.0],[2.0,1.0,7.0])
        
        '''

     def exponential_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponential_regression_plot:
        exponential_regression_plot(Lst||Mtrx(A),[Lst])
        Returns the plot of y=b*a^x : it is the best exponential which approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ logarithmic_regression_plot 
        Ex1:exponential_regression_plot([[1.0,2.0],[0.0,1.0],[4.0,7.0]])
        Ex2:exponential_regression_plot([1.0,0.0,4.0],[2.0,1.0,7.0])
        
        '''

     def exponentiald(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponentiald:
        exponentiald(Real(lambda),Real(x))
        Returns the probability density at x of the exponential law of parameter lambda.
        See also: 1/ exponential_cdf 2/ exponential_icdf 3/ randvector 4/ ranm 
        Ex1:exponentiald(2.1,3.5)
        Ex2:exponentiald(2.1,0.5)
        Ex3: randvector(3,exponential,1.2)
        Ex4: ranm(4,3,exponential,1.2)
        
        '''

     def exponentiald_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponentiald_cdf:
        exponentiald_cdf(Real(lambda),Real(x0),[Real(y0)])
        Returns the probability that a exponential random variable of parameter lambda is less than x0 (or between x0 and y0).
        See also: 1/ exponentiald 2/ exponential_icdf 
        Ex1:exponentiald_cdf(4.2,2.1)
        Ex2:exponentiald_cdf(4.2,2.1,3.2)
        
        '''

     def exponentiald_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for exponentiald_icdf:
        exponentiald_icdf(Real(lambda),Real(x0),Real(p))
        Returns h such that the probability that a exponential random variable of parameter lambda is less than h is p (0<=p<=1).
        See also: 1/ exponential_cdf 2/ exponentiald 
        Ex1:exponentiald_icdf(4.2,0.95)
        Ex2:exponentiald_icdf(4.2,0.6)
        
        '''

     def export_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for export_graph:
        export_graph(Graph(G),Str("filename"),[opts])
        Writes G to the file 'filename' in dot/lst/LaTeX format, returns 1 on success and 0 on failure.
        See also: 1/ import_graph 
        Ex1:export_graph(complete_graph(5),"K5.dot")
        
        '''

     def export_mathml(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for export_mathml:
        export_mathml(Expr,[display||content])
        Converts an expression to presentation or content MathML block.
        See also: 1/ mathml 2/ latex 
        Ex1:export_mathml(a+2*b)
        Ex2:export_mathml(a+2*b,display)
        Ex3:export_mathml(a+2*b,content)
        
        '''

     def expovariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for expovariate:
        expovariate(Real(a))
        Returns a random real according to the exponential distribution with parameter a>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:expovariate(1)
        Ex2:expovariate(2)
        
        '''

     def expr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for expr:
        expr(Str)
        Instruction transforming a string into a command or into a number.
        See also: 1/ string 
        Ex1:expr("ifactor(54)")
        Ex2:expr("123")
        Ex3:expr("0123")
        Ex4:expr(sin,x)
        
        '''

     def extend(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for extend:
        extend(Lst,Lst||Seq,Seq||Str,Str||Mtrx,Mtrx)
        Concatenates two lists or two strings or two sequences or 2 matrices; L:=concat(L,L1) or L.concat(L1).
        See also: 1/ append 2/ cat 3/ semi_augment 4/ border 5/ + 
        Ex1:extend([1,2],[3,4,5])
        Ex2:extend("bon","jour")
        Ex3:extend([[1,2],[3,4]],[[4,5,6],[6,7,8]])
        Ex4: L:=[1,2];L.concat([3,4,5])
        Ex5: S:="abcd";S.concat("efghi")
        
        '''

     def extract_measure(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for extract_measure:
        extract_measure(Var)
        extract_measure gives as answer the value calculated by the argument.
        See also: 1/ angleatraw 2/ distanceatraw 3/ angleat 4/ distanceat 5/ slopeatraw 6/ areaatraw 7/ perimeteratraw 8/ slopeat 5/ areaat 10/ perimeterat 
        Ex1:extract_measure(distanceatraw(0,1+i,(1+i)/2))
        Ex2:extract_measure(angleatraw(0,1,1+i,1))
        Ex3: A:=point(0);B:=point(1+i);a:=distanceatraw(A,B,(1+i)/2);extract_measure(a)
        
        '''

     def extrema(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for extrema:
        extrema(Expr,[Var])
        Search extrema of an expression.
        Ex1:extrema(-2*cos(x)-cos(x)^2,x)
        Ex2:extrema((x^3-1)^4/(2x^3+1)^4,x=0..inf)
        Ex3:extrema(exp(x^2-2x)*ln(x)*ln(1-x),x=0.5)
        Ex4:extrema(x^2+y^2,x*y=1,[x=0..inf,y=0..inf])
        Ex5: assume(a>0):;extrema(x/a^2+a*y^2,x+y=a,[x,y])
        Ex6:extrema(x*y*z,x+y+z=1,[x,y,z])
        Ex7:extrema(x2^4-x1^4-x2^8+x1^10,[x1,x2],order=1)
        
        '''

     def ezgcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ezgcd:
        ezgcd(Poly,Poly)
        GCD of 2 polynomials with at least 2 variables, with the ezgcd algorithm.
        See also: 1/ gcd 2/ modgcd 3/ heugcd 4/ psrgcd 
        Ex1:ezgcd(x^2-2*xy+y^2-1,x-y)
        Ex2:ezgcd((x+1)^4-y^4,(x+1-y)^2)
        Ex3:ezgcd((x+y-1)*(x+y+1),(x+y+1)^2)
        
        '''

     def f2nd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for f2nd:
        f2nd(Frac or RatFrac)
        Returns the list built with the numerator and the denominator of the simplified fraction.
        See also: 1/ simp2 2/ numer 3/ denom 4/ getNum 5/ getDenom 
        Ex1:f2nd(42/12)
        Ex2:f2nd((x^2+2*x+1)/(x^2-1))
        
        '''

     def fMax(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fMax:
        fMax(Expr,[Var])
        Returns the abscissa of the maximum of the expression.
        See also: 1/ fMin 
        Ex1:fMax(-x^2+2*x+1,x)
        Ex2:fMax(-x^2+2*x+1,x=1..2)
        
        '''

     def fMin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fMin:
        fMin(Expr,[Var])
        Returns the abscissa of the minimum of the expression.
        See also: 1/ fMax 
        Ex1:fMin(x^2-2*x+1,x)
        Ex2:fMin(x^2-2*x+1,x=1..2)
        Ex3:fMin((x-3)^2+(y-5)^2+1,[],[x,y],[1,1])
        Ex4:fMin((x-3)^2+(y-5)^2+1,[x+y^2=1],[x,y],[1,1])
        
        '''

     def fPart(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fPart:
        fPart(Real||LstReal)
        Returns the fractional part (if x<0 then frac(x)+floor(x)+1=x else frac(x)+floor(x)=x).
        See also: 1/ floor 2/ iPart 3/ trunc 
        Ex1:fPart(1/2)
        Ex2:fPart(-1/2)
        Ex3:fPart(1.2)
        Ex4:fPart(-1.2)
        Ex5:fPart([3.4,sqrt(2)])
        
        '''

     def faces(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for faces:
        faces(Polygon or Polyedr(P))
        Returns the list of the faces (1 face=matrix(n,3) where the n rows are the n vertices of the face) of the polyhedron P.
        See also: 1/ polyhedron 
        Ex1:faces(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))
        Ex2:faces(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))[2]
        
        '''

     def facteurs_premiers(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for facteurs_premiers:
        facteurs_premiers(Intg(a) or LstIntg)
        Returns the list of prime factors of an integer (each factor is followed by its multiplicity).
        See also: 1/ ifactor 2/ factors 
        Ex1:facteurs_premiers(36)
        Ex2:facteurs_premiers([36,52])
        
        '''

     def factor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factor:
        factor(Expr)
        Factors a polynomial.
        See also: 1/ ifactor 2/ cfactor 3/ partfrac 4/ normal 
        Ex1:factor(x^4-1)
        Ex2:factor(x^4-4,sqrt(2))
        Ex3:factor(x^4+12*x^3+54*x^2+108*x+81)
        
        '''

     def factor_xn(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factor_xn:
        factor_xn(Poly(P))
        Factors x^n in P (n=degree of polynomial P).
        See also: 1/ ifactor 2/ partfrac 3/ normal 
        Ex1:factor_xn(x^4-1)
        Ex2:factor_xn(x^4+12*x^3+54*x^2+108*x+81)
        
        '''

     def factorial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factorial:
        factorial(Intg(n)|| Real(a))
        factorial(n)=n!. For non-integers, factorial(a)=a! = G(a + 1). This calculates the Gamma function.
        See also: 1/ comb 2/ perm 
        Ex1:factorial(4)
        Ex2:factorial(1.2)
        
        '''

     def factoriser(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factoriser:
        factoriser(Expr)
        Factors a polynomial.
        See also: 1/ ifactor 2/ cfactor 3/ partfrac 4/ normal 
        Ex1:factoriser(x^4-1)
        Ex2:factoriser(x^4-4,sqrt(2))
        Ex3:factoriser(x^4+12*x^3+54*x^2+108*x+81)
        
        '''

     def factoriser_entier(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factoriser_entier:
        factoriser_entier(Intg(a))
        Factorization of an integer into prime factors.
        See also: 1/ factor 2/ ecm_factor 
        Ex1:factoriser_entier(50)
        Ex2:factoriser_entier(123456789)
        
        '''

     def factoriser_sur_C(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factoriser_sur_C:
        factoriser_sur_C(Expr)
        Factorization of the expression in ℂ (on the Gaussian integers if there are more than 2 variables).
        See also: 1/ factor 
        Ex1:factoriser_sur_C(x^2*y+y)
        Ex2:factoriser_sur_C(x^2*y^2+y^2+4*x^2+4)
        Ex3:factoriser_sur_C(x^2*y^2+y^2+2*x^2+2)
        
        '''

     def factors(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for factors:
        factors(Poly or LstPoly)
        Returns the list of prime factors of a polynomial (each factor is followed by its multiplicity).
        See also: 1/ factor 2/ ifactors 
        Ex1:factors(x^4-1)
        Ex2:factors([x^2,x^2-1])
        
        '''

     def fadeev(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fadeev:
        fadeev(Opt)
        Option of the pcar or charpoly command to specify the algorithm.
        See also: 1/ pcar 
        Ex1: pcar([[4,1,-2],[1,2,-1],[2,1,0]],fadeev)
        
        '''

     def false(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for false:
        false()
        Boolean equal to false or 0.
        See also: 1/ true 
        Ex1: a:=false
        
        '''

     def falsepos_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for falsepos_solver:
        falsepos_solver(Opt)
        Argument for fsolve giving the method for solving a numerical equation.
        See also: 1/ fsolve 
        Ex1: fsolve(cos(x)=x,x,0..1,bisection_solver)
        Ex2: fsolve(cos(x)=x,x,0..1,brent_solver)
        Ex3: fsolve(cos(x)=x,x,0..1,falsepos_solver)
        Ex4: fsolve(cos(x)=x,x,0,newton_solver)
        Ex5: fsolve(cos(x)=x,x,0,secant_solver)
        Ex6: fsolve(cos(x)=x,x,0,steffenson_solver)
        
        '''

     def fclose(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fclose:
        fclose(File(f))
        Closes the file f.
        See also: 1/ fprint 2/ fopen 
        Ex1:fclose(f)
        
        '''

     def fcoeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fcoeff:
        fcoeff(Lst(root||pole,order))
        Returns the polynomial described by the list (root or pole, order).
        See also: 1/ pcoeff 2/ froot 3/ proot 
        Ex1:fcoeff([1,2,0,1,3,-1])
        
        '''

     def fdistrib(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fdistrib:
        fdistrib(Expr)
        Full distribution of * and / over + and -.
        See also: 1/ texpand 2/ normal 3/ simplify 4/ ratnormal 
        Ex1:fdistrib((x+y)*(z+1))
        Ex2:fdistrib((a+b+c)/d)
        Ex3:fdistrib((y+x)*(z+y)*(x+z))
        Ex4:fdistrib((x+3)^4)
        Ex5:fdistrib((2*x-2*1)*(x^2-3*x+2)+(x^2-2*x+3)*(2*x-3*1))
        
        '''

     def fft(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fft:
        fft(Vect or (Vect(L),Intg(a),Intg(p))
        Fast Fourier Transform in ℝ or in the field ℤ/pℤ, with a as primitive n-th root of 1 (n=size(L)).
        See also: 1/ ifft 
        Ex1:fft([1,2,3,4,0,0,0,0])
        Ex2:fft(ranm(128),22798,35969)
        
        '''

     def fieldplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fieldplot:
        fieldplot(Expr,VectVar,[Opt])
        plotfield(f(t,y),[t,y]) draws the plotfield of the diff equation y'=f(t,y).
        See also: 1/ interactive_plotode 2/ odeplot 3/ odesolve 4/ desolve 
        Ex1:fieldplot(sin(t*y),[t=-5..5,y=-3..3],xstep=0.5,ystep=0.5)
        Ex2:fieldplot(-t*y,[t,y])
        Ex3:fieldplot(-t*y,[t,y],normalize)
        Ex4:fieldplot(-t*y,[t,y],normalize,xstep=0.5,ystep=0.5)
        Ex5:fieldplot(-t*y,[t=-6.868..6.868,y=-6.868..6.868],normalize)
        
        '''

     def find(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for find:
        find(Expr,Vect)
        List of positions of an object in a list, a string or a set.
        See also: 1/ index 2/ member 
        Ex1:find(1,[3,x,1,2,1,3])
        Ex2:find(2,[0,1,3,2,4,2,5])[0]
        Ex3:find("a","abracadabrant")
        Ex4:find("ab","abracadabrant")
        Ex5:find(1,%{4,3,1,2%})
        
        '''

     def find_cliques(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for find_cliques:
        find_cliques(Graph(G),[Intg(k)||Intrv(m..n)])
        Returns the list of numbers of maximal cliques of size s in an undirected graph G for each s. If parameter k is given, the number of k-cliques is returned. If an interval m..n is given, only cliques with size between m and n (inclusive) are counted (m also may be +infinity).
        See also: 1/ maximum_clique 2/ clique_cover 
        Ex1:find_cliques(random_graph(50,0.5))
        Ex2:find_cliques(random_graph(50,0.5),5)
        Ex3:find_cliques(random_graph(50,0.5),3..5)
        
        '''

     def find_cycles(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for find_cycles:
        find_cycles(Graph(G,[length=k||l..u]))
        Returns the list of elementary cycles of the digraph G. If option "length" is specified, only cycles of length k resp. of length between l and u are returned.
        See also: 1/ is_acyclic 2/ cycle_basis 
        Ex1:find_cycles(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}))
        Ex2:find_cycles(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}),length=3)
        Ex3:find_cycles(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}),length=3..4)
        
        '''

     def find_minimum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for find_minimum:
        find_minimum((Expr||Func)(f),Real(a),Real(b),[Real(eps),Intg(maxiter)])
        Returns the point of global minimum of continuous univariate function or expression f within segment [a,b].
        See also: 1/ fMin 2/ minimize 3/ nlpsolve 
        Ex1:find_minimum(cosh(x),-1,1)
        Ex2:find_minimum(cosh(x),-1,1,1e-5,20)
        Ex3:find_minimum(Airy_Ai(x+sin(x))+cos(x^2),-5,5)
        Ex4:find_minimum(besselJ(x,2)/Gamma(x+1)+(x+1)^sin(x),0,10)
        
        '''

     def find_vertex_cover(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for find_vertex_cover:
        find_vertex_cover(Graph(G),[Intg(k)])
        Returns a list of (k) vertices which comprise a vertex cover in an undirected graph G.
        See also: 1/ minimum_vertex_cover 2/ vertex_cover_number 
        Ex1:find_vertex_cover(complete_graph(3,4))
        Ex2:find_vertex_cover(complete_graph(3,4),4)
        
        '''

     def findhelp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for findhelp:
        findhelp(Cmd)
        Returns help about the command (if ? is infixed see when) .
        See also: 1/ ifte 2/ when 
        Ex1:findhelp(ifactor)
        
        '''

     def fisher(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fisher:
        fisher(Intg(n),Intg(m),Real(x0))
        Returns the probability density of the Fisher-Snedecor law (n and m are the numbers of degrees of freedom).
        See also: 1/ fisher_cdf 2/ fisher_icdf 3/ randvector 4/ ranm 
        Ex1:fisher(4,10,2.1)
        Ex2:fisher(4,4,2.1)
        Ex3: randvector(5,fisher,4,6)
        Ex4: ranm(2,3,fisher,4,6)
        
        '''

     def fisher_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fisher_cdf:
        fisher_cdf(Intg(n),Intg(m),Real(x0))
        Returns the probability that a Fisher-Snedecor random variable is less than x0 (n and m are the numbers of degrees of freedom).
        See also: 1/ UTPF 2/ fisher_icdf 3/ fisherd 
        Ex1:fisher_cdf(4,4,2.1)
        Ex2:fisher_cdf(4,10,3.5)
        
        '''

     def fisher_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fisher_icdf:
        fisher_icdf(Intg(n),Intg(m),Real(p))
        Returns h such as the probability that a Fisher-Snedecor random variable is less than h is p (n and m are the numbers of degrees of freedom and 0<=p<=1).
        See also: 1/ fisher_cdf 2/ fisherd 
        Ex1:fisher_icdf(4,10,0.95)
        Ex2:fisher_icdf(4,10,0.05)
        
        '''

     def fisherd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fisherd:
        fisherd(Intg(n),Intg(m),Real(x0))
        Returns the probability density of the Fisher-Snedecor law (n and m are the numbers of degrees of freedom).
        See also: 1/ fisher_cdf 2/ fisher_icdf 3/ randvector 4/ ranm 
        Ex1:fisherd(4,10,2.1)
        Ex2:fisherd(4,4,2.1)
        Ex3: randvector(5,fisher,4,6)
        Ex4: ranm(2,3,fisher,4,6)
        
        '''

     def fisherd_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fisherd_cdf:
        fisherd_cdf(Intg(n),Intg(m),Real(x0))
        Returns the probability that a Fisher-Snedecor random variable is less than x0 (n and m are the numbers of degrees of freedom).
        See also: 1/ UTPF 2/ fisher_icdf 3/ fisherd 
        Ex1:fisherd_cdf(4,4,2.1)
        Ex2:fisherd_cdf(4,10,3.5)
        
        '''

     def fisherd_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fisherd_icdf:
        fisherd_icdf(Intg(n),Intg(m),Real(p))
        Returns h such as the probability that a Fisher-Snedecor random variable is less than h is p (n and m are the numbers of degrees of freedom and 0<=p<=1).
        See also: 1/ fisher_cdf 2/ fisherd 
        Ex1:fisherd_icdf(4,10,0.95)
        Ex2:fisherd_icdf(4,10,0.05)
        
        '''

     def fitdistr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fitdistr:
        fitdistr(Lst(L),Fnc(D))
        Returns the distribution of type D which fits most closely to the i.i.d. samples in the list L.
        See also: 1/ normald 2/ poisson 3/ exponentiald 4/ geometric 5/ gammad 6/ betad 7/ cauchyd 8/ weibulld 9/ sample 10/ randvector 11/ randvar 
        Ex1:fitdistr(randvector(1000,weibulld,1/2,1),weibull)
        Ex2: X:=randvar(normal,stddev=9.5):;Y:=randvar(normal,stddev=1.5):;S:=sample(eval(X/Y,0),1000):;Z:=fitdistr(S,cauchy)
        Ex3: X:=randvar(normal,mean=5,variance=2):;S:=sample(exp(X),1000):;fitdistr(log(S),normal)
        
        '''

     def fitpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fitpoly:
        fitpoly(Expr||Mtrx||Seq(Lst(x),Lst(y)),[Var[=Real(a)..Real(b)]],[Options])
        Returns the polynomial of suitable degree which best fits the data or function in the sense of least squares.
        See also: 1/ polynomial_regression 2/ minimax 
        Ex1:fitpoly(x*cos(x),x=0..pi/2)
        Ex2: x:=[(k*0.1)$(k=0..10)]:;y:=[0.25,1.12,1.89,2.63,3.19,3.47,3.53,3.18,2.64,1.71,0.09]:;fitpoly(x,y)
        
        '''

     def fitspline(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fitspline:
        fitspline(Mtrx(data),(Var||Lst)(x),[opts])
        Returns the B-spline which fits data most closely in the least-squares sense.
        See also: 1/ bspline 2/ fitpoly 
        Ex1: t:=linspace(0,10,50):;x:=apply(u->(u^2*sin(u)+u-1)/(1+u*sqrt(u)),t):;y:=apply(u->(u^2*cos(u)-u+1)/(1+u*sqrt(u)),t):;listplot(fitspline(tran([t,x,y]),linspace(0,10,500))),scatterplot(x,y,color=blue)
        
        '''

     def flatten(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for flatten:
        flatten(Lst||Image)
        Recursively flatten a list containing lists or an image object.
        See also: 1/ mat2list 
        Ex1:flatten([[1,[2,3],4],[5,6]])
        
        '''

     def float2rational(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for float2rational:
        float2rational(Expr)
        Converts the expression to a rational or real expression.
        See also: 1/  
        Ex1:float2rational(-2)
        Ex2:float2rational(1.5)
        Ex3:float2rational(1.4141)
        Ex4:float2rational(0.156381102937)
        
        '''

     def floor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for floor:
        floor(Real or Cplx)
        Returns the greatest integer <= to the argument.
        See also: 1/ round 2/ ceil 3/ iPart 4/ trunc 
        Ex1:floor(-2.5)
        Ex2:floor(2.5-4.2*i)
        
        '''

     def flow_polynomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for flow_polynomial:
        flow_polynomial(Graph(G),[Var(x)])
        Returns the flow polynomial [or its value at point x] of an undirected unweighted graph G.
        See also: 1/ chromatic_polynomial 2/ reliability_polynomial 3/ tutte_polynomial 
        Ex1:flow_polynomial(graph("tetrahedron"))
        Ex2:flow_polynomial(graph("tetrahedron"),5)
        
        '''

     def flower_snark(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for flower_snark:
        flower_snark(Intg(n))
        Returns the n-th flower snark, where n>2 is odd.
        See also: 1/ goldberg_snark 
        Ex1:flower_snark(5)
        
        '''

     def fmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fmod:
        fmod(Real(a),Real(b))
        Returns a mod b for a and b floats.
        See also: 1/ mod 
        Ex1:fmod(10.0,pi)
        
        '''

     def foldl(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for foldl:
        foldl(op,id,Seq(r1,r2,...))
        Returns the composition of the binary operator or function op, with an identity or initial value id onto its arguments r1, r2, ..., associating from the left.
        See also: 1/ apply 2/ foldr 3/ map 
        Ex1:foldl(F,init,a,b,c)
        
        '''

     def foldr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for foldr:
        foldr(op,id,Seq(r1,r2,...))
        Returns the composition of the binary operator or function op, with an identity or initial value id onto its arguments r1, r2, ..., associating from the right.
        See also: 1/ apply 2/ foldl 3/ map 
        Ex1:foldr(F,init,a,b,c)
        
        '''

     def fonction_derivee(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fonction_derivee:
        fonction_derivee(Fnc(f))
        Returns the derivative function of the function f.
        See also: 1/ diff 2/ ' 3/ @ 
        Ex1:fonction_derivee(sin+id)
        Ex2:fonction_derivee(sq@sin+id)
        Ex3:fonction_derivee(ln)(x,y)
        Ex4:fonction_derivee(ln)([x,y])
        Ex5: (function_diff @@3)(ln)('x') 
        
        '''

     def forward(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for forward:
        forward(NULL or Real(n))
        The turtle takes n steps forward (by default n=10).
        See also: 1/ recule 2/ saute 
        Ex1: avance 30
        Ex2:forward(30)
        
        '''

     def fourier(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fourier:
        fourier(Expr(f(x)),[Var(x),[Var(s)]])
        Returns the Fourier transform F(s) of f(x).
        See also: 1/ ifourier 2/ Fourier 3/ fourier_cn 4/ fft 
        Ex1:fourier(x/(x^3-19x+30),x,s)
        Ex2:fourier(atan(t-4))
        Ex3:fourier(BesselJ(3,x),x,s)
        Ex4:fourier(sin(x)*sign(x),x,s)
        Ex5:fourier(log(abs(x)),x,s)
        Ex6:fourier(rect(x),x,s)
        Ex7:fourier(piecewise(t<=-1,exp(t+1),t<=1,1,exp(2-2t)))
        
        '''

     def fourier_an(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fourier_an:
        fourier_an(Expr(f(x)),Var(x),Period(T),Intg(n),Real(a))
        Returns the n-th Fourier coefficient an=2/T*integrate(f(x)*cos(2*pi*n*x/T),a,a+T).
        See also: 1/ fourier_cn 2/ fourier_bn 3/ assume 
        Ex1:fourier_an(x^2,x,2,0,-1)
        Ex2:fourier_an(x^2,x,2,n,-1)
        
        '''

     def fourier_bn(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fourier_bn:
        fourier_bn(Expr(f(x)),Var(x),Period(T),Intg(n),Real(a))
        Returns the n-th Fourier coefficient bn=2/T*integrate(f(x)*sin(2*pi*n*x/T),a,a+T).
        See also: 1/ fourier_cn 2/ fourier_an 3/ assume 
        Ex1:fourier_bn(x^2,x,2,0,-1)
        Ex2:fourier_bn(x^2,x,2,n,-1)
        
        '''

     def fourier_cn(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fourier_cn:
        fourier_cn(Expr(f(x)),Var(x),Period(T),Intg(n),Real(a))
        Returns the n-th Fourier coefficient cn=1/T*integrate(f(x)*exp(-2*i*pi*n*x/T),a,a+T).
        See also: 1/ fourier_an 2/ fourier_bn 3/ assume 
        Ex1:fourier_cn(x^2,x,2,0,-1)
        Ex2:fourier_cn(x^2,x,2,n,-1)
        
        '''

     def fprint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fprint:
        fprint(File(f),Var,[Var,Var...])
        Writes in the file f some data.
        See also: 1/ fopen 2/ fclose 
        Ex1:fprint(f,x+1,"2")
        Ex2:fprint(f,"blabla")
        Ex3:fprint(f,Unquoted,"blabla")
        
        '''

     def frac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for frac:
        frac(Real||LstReal)
        Returns the fractional part (if x<0 then frac(x)+floor(x)+1=x else frac(x)+floor(x)=x).
        See also: 1/ floor 2/ iPart 3/ trunc 
        Ex1:frac(1/2)
        Ex2:frac(-1/2)
        Ex3:frac(1.2)
        Ex4:frac(-1.2)
        Ex5:frac([3.4,sqrt(2)])
        
        '''

     def fracmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fracmod:
        fracmod(Expr(Xpr),Intg(n))
        Returns the fraction a/b such as b*Xpr=a mod n, -sqrt(n)/2<a<=sqrt(n)/2 and 0<=b<sqrt(n)/2.
        See also: 1/ mod 2/ smod 
        Ex1:fracmod(41,121)
        
        '''

     def frame_2d(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for frame_2d:
        frame_2d(NULL)
        frame_2d() draws the axes of the 2-d graphic-screen.
        See also: 1/ frame_3d 2/ Ox_2d_unit_vector 3/ Oy_2d_unit_vector 
        Ex1:frame_2d()
        
        '''

     def frank_wolfe(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for frank_wolfe:
        frank_wolfe(Expr(f),Mtrx(A),[opts])
        Returns a point in conv(A) which minimizes f, where A is a list of points.
        See also: 1/ find_minimum 2/ nlpsolve 3/ fMin 
        Ex1:frank_wolfe((x1-2/3)^2/3+(x2-2/3)^2/5,[[1,0],[0,1],[-1,0],[0,-1]])
        
        '''

     def frequencies(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for frequencies:
        frequencies(Lst)
        Returns the frequencies of a list of values.
        See also: 1/ histogram 2/ cumulated_frequencies 3/ bar_plot 4/ classes 
        Ex1:frequencies([1,2,1,1,2,1,2,4,3,3])
        Ex2:frequencies([(rand(6)+1)$(k=1..100)])
        
        '''

     def frobenius_norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for frobenius_norm:
        frobenius_norm(Mtrx)
        Frobenius norm of a matrix A (=sqrt(sum |aij|^2)).
        See also: 1/ l1norm 2/ l2 norm 3/ linfnorm 4/ matrix_norm 
        Ex1:frobenius_norm([[1,2,3],[3,-9,6],[4,5,6]])
        
        '''

     def froot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for froot:
        froot(RatPoly(F))
        Returns the list of roots and poles of F with their multiplicity.
        See also: 1/ proot 2/ fcoeff 3/ pcoeff 4/ realroot 5/ complexroot 6/ rationalroot 7/ crationalroot 
        Ex1:froot((x^5-2*x^4+x^3)/(x-3))
        Ex2:froot((x^5-2*x^4+x^3)/(x-1))
        
        '''

     def fsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fsolve:
        fsolve(Expr,Var,[Guess or Interval],[Method])
        Numerical solution of an equation or a system of equations.
        See also: 1/ cfsolve 2/ nSolve 3/ solve 4/ csolve 5/ lpsolve 6/ nlpsolve 
        Ex1:fsolve(cos(x)=x,x,-1..1,bisection_solver)
        Ex2:fsolve(cos(x)=x,x,0,newton_solver)
        Ex3:fsolve([x^2+y-2,x+y^2-2],[x,y],[0,0],newtonj_solver)
        Ex4:fsolve([x^2+y-2,x+y^2-2],[x,y])
        
        '''

     def fullparfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fullparfrac:
        fullparfrac(Opt)
        Option of the convert or convertir command (id at the option partfrac).
        See also: 1/ convert 
        Ex1: convert(1/(x^2-1),parfrac)
        Ex2: convert(1/(x^2-1),fullparfrac)
        
        '''

     def funcplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for funcplot:
        funcplot(Expr,[Var(x) or VectVar] ,[Intg(color)])
        Plots a 1 variable or 2 variables expression with superposition.
        See also: 1/ plot 2/ plot3d 3/ plotparam 4/ animate 5/ animate3d 6/ plotdensity 
        Ex1:funcplot(-2*x+1,x=1..2,color=red)
        Ex2:funcplot([-2*x+1,x^2-2],x=-2..2,color=[red,yellow],xstep=0.2)
        Ex3:funcplot(x^2-y^2,[x,y],xstep=0.5,ystep=0.3)
        Ex4:funcplot(x^2+y^2,[x=-1..1,y=-2..2],nstep=900)
        Ex5:funcplot((x+i*y)^2,[x=-1..1,y=-2..2],nstep=900,affichage=rempli)
        
        '''

     def function_diff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for function_diff:
        function_diff(Fnc(f))
        Returns the derivative function of the function f.
        See also: 1/ diff 2/ ' 3/ @ 
        Ex1:function_diff(sin+id)
        Ex2:function_diff(sq@sin+id)
        Ex3:function_diff(ln)(x,y)
        Ex4:function_diff(ln)([x,y])
        Ex5: (function_diff @@3)(ln)('x') 
        
        '''

     def fundamental_cycle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fundamental_cycle:
        fundamental_cycle(Graph(G))
        Returns the fundamental cycle of an unicyclic undirected connected graph G.
        See also: 1/ cycle_basis 2/ find_cycles 
        Ex1:fundamental_cycle(graph(trail(1,2,3,4,5,2,6)))
        
        '''

     def fxnd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for fxnd:
        fxnd(Frac or RatFrac)
        Returns the list built with the numerator and the denominator of the simplified fraction.
        See also: 1/ simp2 2/ numer 3/ denom 4/ getNum 5/ getDenom 
        Ex1:fxnd(42/12)
        Ex2:fxnd((x^2+2*x+1)/(x^2-1))
        
        '''

     def gammad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gammad:
        gammad(Real(a>0),Real(b>0),Real(x>=0))
        Returns the probability density of the Gamma law (=x^(a-1)*exp(-b*x)*b^a/Gamma(a)).
        See also: 1/ gammad_cdf; 2/ gammad_icdf 
        Ex1:gammad(2.2,1.5,0.8)
        
        '''

     def gammad_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gammad_cdf:
        gammad_cdf(Real(a>0),Real(b>0),Real(x0>=0),[Real(y0>=0)])
        Returns the probability that a Gamma random variable (with a and b as parameters) is less than x0 or between x0 and y0.
        See also: 1/ gammad 2/ gammad_icdf 
        Ex1:gammad_cdf(2,1,2.96)
        Ex2:gammad_cdf(2,1,1.4,2.96)
        
        '''

     def gammad_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gammad_icdf:
        gammad_icdf(Real(a>0),Real(b>0),Real(0<=p<=1))
        Returns h such that the probability that a Gamma random variable is less than h is p (0<=p<=1).
        See also: 1/ gammad_cdf 2/ gammad 
        Ex1:gammad_icdf(2,1,0.95)
        Ex2:gammad_icdf(2,1,0.5)
        
        '''

     def gammavariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gammavariate:
        gammavariate(Real(a),Real(b))
        Returns a random real according to the Gamma distribution with parameters a>0 and b>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:gammavariate(1,2)
        Ex2:gammavariate(1.5,4)
        
        '''

     def gauss(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gauss:
        gauss(Expr,VectVar)
        Splits a quadratic form as a sum/difference of squares.
        See also: 1/ cholesky 
        Ex1:gauss(x^2+2*a*x*y,[x,y])
        
        '''

     def gauss15(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gauss15:
        gauss15(Opt)
        Option of the area command.
        See also: 1/ area 
        Ex1: area(x^2,x=0..1,5,simpson)
        Ex2: area(x^2,x=0..1,5,rombergt)
        Ex3: area(x^2,x=0..1,5,rombergm)
        Ex4:gauss15(area(x^2,x=0..1,5,gauss15))
        
        '''

     def gauss_seidel_linsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gauss_seidel_linsolve:
        gauss_seidel_linsolve([Real(omega)],Mtrx(A),Vect(b),Real(eps),[Int(maxiter)])
        Resolution of a linear system A*X=b by the iterative Gauss-Seidel method (by defaut omega=1) or by relaxation method, with eps as error margin and a number of iterations less than maxiter.
        See also: 1/ jacobi_linsolve 2/ linsolve 
        Ex1: a:=[[100,2],[2,100]];gauss_seidel_linsolve(a,[0,1],1e-12);
        Ex2: a:=[[100,2],[2,100]];gauss_seidel_linsolve(table(a),[0,1],1e-12); 
        Ex3: a:=[[100,2],[2,100]];gauss_seidel_linsolve(1.5,a,[0,1],1e-12);
        Ex4: a:=[[100,2],[2,100]];gauss_seidel_linsolve(1.5,table(a),[0,1],1e-12); 
        
        '''

     def gaussian_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gaussian_window:
        gaussian_window(Lst,[Real(a)],[Interval(n1..n2)])
        Applies the Gaussian windowing function with parameter 0<a<=0.5 (by default a=0.1) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ bartlett_hann_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(gaussian_window(randvector(1000,0..1),0.4))
        
        '''

     def gaussjord(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gaussjord:
        gaussjord(Mtrx(M),[Intg(k)]||Opt)
        Row reduction to echelon form of AX=b (M=A|(-b)) [Reduction on columns 0..k-1].
        See also: 1/ ker 2/ image 3/ det 4/ Rref 5/ pivot 6/ ref 7/ keep_pivot 
        Ex1:gaussjord([[3,1,-2],[3,2,2]])
        Ex2:gaussjord([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]])
        Ex3:gaussjord([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]],2)
        Ex4:gaussjord([[1,1,0,0,-a1],[0,1,1,0,-a2],[0,0,1,1,-a3],[1,0,0,1,-a4]],keep_pivot)
        
        '''

     def gaussquad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gaussquad:
        gaussquad(Expr(f(x)),Var(x),Real(a),Real(b))
        Returns the approximate value of integrate(f(x),x,a,b) by adaptive Gaussian quadratures with 15 points.
        See also: 1/ integrate 2/ romberg 
        Ex1:gaussquad(exp(x^2),x,0,1)
        Ex2:gaussquad(x^2,x,0,1)
        Ex3:gaussquad(exp(-x^2),x,-1,1)
        
        '''

     def gbasis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gbasis:
        gbasis(LstPoly,LstVar,[order])
        Groebner basis of the ideal spanned by the list of polynomials. The optional rur argument may be used to compute a rational univariate representation.
        See also: 1/ greduce 2/ gbasis_max_pairs 3/ gbasis_simult_primes 
        Ex1:gbasis([x^2-y^3,x+y^2],[x,y])
        Ex2:gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3])
        Ex3:gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],tdeg)
        Ex4:gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],plex)
        Ex5:gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1] mod 29,[x1,x2,x3])
        Ex6:gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],rur)
        
        '''

     def gbasis_max_pairs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gbasis_max_pairs:
        gbasis_max_pairs(Intg)
        Gbasis fine-tuning: maximal number of S-pairs to be reduced simultaneously inside F4 algorithm (default 32768, 0 means no limit). Set it to a smaller value if short in memory.
        See also: 1/ gbasis 2/ gbasis_simult_primes 3/ gbasis_reinject 
        Ex1:gbasis_max_pairs(4096)
        Ex2:gbasis_max_pairs(0)
        
        '''

     def gbasis_reinject(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gbasis_reinject:
        gbasis_reinject(Real(a),[Real(b)])
        Gbasis fine-tuning: in the modular algorithm of a gbasis over Q, adds a partial reconstruction of the basis if the ratio of new elements is greater than a and the speed ratio of the 2nd run/1st run is >= b (default a=0.2 and b=1/6.)
        See also: 1/ gbasis 2/ gbasis_max_pairs 3/ gbasis_reinject  
        Ex1:gbasis_reinject(0.1)
        Ex2:gbasis_reinject(0.1,0.05)
        
        '''

     def gbasis_simult_primes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gbasis_simult_primes:
        gbasis_simult_primes(Intg)
        Gbasis fine-tuning: maximal number of Groebner basis modulo a prime that are computed simultaneously to rebuild a Groebner basis over Q (default 16). Set it to a smaller value if short in memory.
        See also: 1/ gbasis 2/ gbasis_max_pairs 3/ gbasis_reinject  
        Ex1:gbasis_simult_primes(3)
        
        '''

     def gcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gcd:
        gcd((Intg(a) or Poly),(Intg(b) or Poly))
        Returns the greatest common divisor of 2 polynomials of several variables or of 2 integers or of 2 rationals.
        See also: 1/ lcm 2/ euler 2/ modgcd 3/ ezgcd 4/ psrgcd 5/ heugcd 6/ Gcd 
        Ex1:gcd(45,75)
        Ex2:gcd(15/7,50/9)
        Ex3:gcd(x^2-2*x+1,x^3-1)
        Ex4:gcd(t^2-2*t+1,t^2+t-2)
        Ex5:gcd((x^2-1)*(y^2-1)*z^2,x^3*y^3*z+(-(y^3))*z+x^3*z-z)
        
        '''

     def gcdex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gcdex:
        gcdex((Poly or Lst),(Poly or Lst),[Var])
        Extended greatest common divisor of 2 polynomials.
        See also: 1/ gcd 2/ iegcd 
        Ex1:gcdex((x-1)^2,x^3-1)
        Ex2:gcdex((X-1)^2,X^3-1,X)
        Ex3:gcdex([1,-2,1],[1,0,0,-1])
        Ex4:gcdex([1,-2,1],[1,-1,2])
        
        '''

     def genpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for genpoly:
        genpoly(Poly(P),Intg(b),Var)
        Returns the reconstruction of a n-variables polynomial Q(-b/2<=coef<=b/2) from an (n-1)-variable polynomial P and a base b (subst(Q,var=b)=P).
        See also: 1/  
        Ex1:genpoly(15,4,x)
        Ex2:genpoly(7*y+5,6,x)
        Ex3:genpoly(7*y-5*z,10,x)
        
        '''

     def geodetic2ecef(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for geodetic2ecef:
        geodetic2ecef(Real(latitude),Real(longitude),Real(height))
        Converts geodetic LLA coordinates to ECEF (WGS84 standard).
        See also: 1/ ecef2geodetic 
        Ex1:geodetic2ecef(45.174536,17.584637,89.462)
        
        '''

     def geometric(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for geometric:
        geometric(Real(p),Intg(k))
        Returns the value at k of the geometric law with parameter p (0<p<1).
        See also: 1/ geometric_cdf 2/ geometric_icdf 3/ randvector 4/ ranm 
        Ex1:geometric(0.3,4)
        Ex2:geometric(0.5,5)
        Ex3: randvector(3,geometric,0.3)
        Ex4: ranm(4,3,geometric,0.3)
        
        '''

     def geometric_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for geometric_cdf:
        geometric_cdf(Real(p),Intg(k),[Intg(m)])
        Returns the probability that a geometric random variable of parameter p (0<p<1) is less than k (or between k and m).
        See also: 1/ geometric 2/ geometric_icdf 
        Ex1:geometric_cdf(0.3,4)
        Ex2:geometric_cdf(0.3,4,5)
        
        '''

     def geometric_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for geometric_icdf:
        geometric_icdf(Real(p),Real(x))
        Returns h such that the probability that a geometric random variable with parameter p (0<p<1) is less than h is x (0<=x<=1).
        See also: 1/ geometric_cdf 2/ geometric 
        Ex1:geometric_icdf(0.3,0.95)
        
        '''

     def getDenom(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for getDenom:
        getDenom(Expr)
        Returns the denominator of the unsimplified expression (except for rational number).
        See also: 1/ denom 2/ getNum 3/ numer 4/ f2nd 
        Ex1:getDenom(25/15)
        Ex2:getDenom((x^3-1)/(x^2-1))
        Ex3:getDenom(1+(x^3-1)/x^2)
        
        '''

     def getKey(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for getKey:
        getKey(NULL)
        Instruction in a program, returns 0 if no key is pressed and otherwise returns the ascii code of the pressed key.
        See also: 1/ getType 
        Ex1:getKey()
        
        '''

     def getNum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for getNum:
        getNum(Expr)
        Returns the numerator of the unsimplified expression (except for rational number).
        See also: 1/ numer 2/ denom 3/ getDenom 4/ f2nd 
        Ex1:getNum(25/15)
        Ex2:getNum((x^3-1)/(x^2-1))
        Ex3:getNum(1+(x^3-1)/x^2)
        
        '''

     def getType(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for getType:
        getType(Expr)
        Returns the type of the argument (STR,EXPR,FUNC,NUM,LIST,MAT,VAR,NONE,PIC...).
        See also: 1/ getKey 
        Ex1:getType("aze")
        Ex2:getType(2+i)
        Ex3:getType(x->cos(2*x))
        Ex4:getType(1.414)
        
        '''

     def get_edge_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for get_edge_attribute:
        get_edge_attribute(Graph(G),Edge(e),Seq(tag1=value1,tag2=value2,..))
        Returns the attributes tag1, tag2, ... assigned to edge e in G as a sequence of the corresponding values.
        See also: 1/ discard_edge_attribute 2/ set_edge_attribute 3/ list_edge_attributes 
        Ex1:get_edge_attribute(cycle_graph(3),[1,2],"cost")
        
        '''

     def get_edge_weight(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for get_edge_weight:
        get_edge_weight(Graph(G),Edge(e))
        Returns the weight of the edge e in a weighted graph G.
        See also: 1/ is_weighted 2/ make_weighted 3/ set_edge_weight 4/ weight_matrix 
        Ex1:get_edge_weight(graph(%{[[1,2],5],[[2,3],6]%}),[1,2])
        
        '''

     def get_graph_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for get_graph_attribute:
        get_graph_attribute(Graph(G),Seq(tag1=value1,tag2=value2,..))
        Return the graph attributes tag1, tag2, ..., as a sequence of the corresponding values.
        See also: 1/ discard_graph_attribute 2/ set_graph_attribute 3/ list_graph_attributes 
        Ex1:get_graph_attribute(cycle_graph(3),"name")
        
        '''

     def get_vertex_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for get_vertex_attribute:
        get_vertex_attribute(Graph(G),Vrtx(v),Seq(tag1=value1,tag2=value2,..))
        Returns the attributes tag1, tag2, ... assigned to the vertex v in G as a sequence of the corresponding values.
        See also: 1/ discard_vertex_attribute 2/ set_vertex_attribute 3/ list_vertex_attributes 
        Ex1:get_vertex_attribute(cycle_graph(3),1,"supply")
        
        '''

     def girth(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for girth:
        girth(Graph(G))
        Returns the length of a shortest cycle in an undirected unweighted graph G.
        See also: 1/ odd_girth 
        Ex1:girth(graph("petersen"))
        Ex2:girth(hypercube_graph(3))
        
        '''

     def gl_showaxes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gl_showaxes:
        gl_showaxes(Opt=Boolean)
        Option that shows or hides axes.
        See also: 1/ switch_axes 2/ axes 
        Ex1: gl_showaxes=true;plot(sin(x))
        Ex2: gl_showaxes=false;plot(sin(x)) 
        
        '''

     def gold(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gold:
        gold(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def goldberg_snark(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for goldberg_snark:
        goldberg_snark(Intg(n))
        Returns the Goldberg snark on 8n vertices, where n>2 is odd.
        See also: 1/ flower_snark 
        Ex1:goldberg_snark(5)
        
        '''

     def grad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for grad:
        grad(Expr(Xpr),LstVar)
        Returns the gradient of the expression Xpr.
        See also: 1/ hessian 
        Ex1:grad(2*x^2*y-x*z^3,[x,y,z])
        
        '''

     def gramschmidt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for gramschmidt:
        gramschmidt(Basis(B),ScalarProd(Sp))
        Returns an orthonormal basis of E with basis B for the scalar product Sp.
        See also: 1/  
        Ex1:gramschmidt(-2)
        Ex2:gramschmidt([1,1+x],(p,q)->integrate(p*q,x,-1,1))
        
        '''

     def graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph:
        graph([Lst(V)],[Set(E)],[Mtrx(A)],[options])
        Create an (un)directed (un)weighted graph from vertices V, edges E, and/or adjacency or weight matrix A. All parameters are optional.
        See also: 1/ digraph 2/ trail 
        Ex1:graph(5)
        Ex2:graph([a,b,c])
        Ex3:graph([1,2,3],%{[1,2],[2,3],[3,1]%})
        Ex4:graph(trail(1,2,3,4,1),directed=true)
        Ex5:graph([a,b,c],[[0,2,0],[2,0,3],[0,3,0]])
        Ex6:graph("petersen")
        Ex7:graph([[0,1,1,0],[1,0,0,1],[1,0,0,0],[0,1,0,0]])
        
        '''

     def graph_automorphisms(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_automorphisms:
        graph_automorphisms(Graph(G))
        Returns the sequence of generators of Aut(G), the automorphism group of G. Each element is a permutation in the form of a list of disjoint cycles.
        See also: 1/ cycles2permu 2/ isomorphic_copy 3/ permute_vertices 
        Ex1:graph_automorphisms(graph("petersen"))
        
        '''

     def graph_charpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_charpoly:
        graph_charpoly(Graph(G),[Var(x)])
        Returns the value p(x) of the characteristic polynomial p of G. If x is omitted, the list of coefficients of p is returned.
        See also: 1/ graph_spectrum 2/ charpoly 
        Ex1:graph_charpoly(graph(%{[1,2],[2,3]%}))
        Ex2:graph_charpoly(graph("shrikhande"))
        
        '''

     def graph_complement(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_complement:
        graph_complement(Graph(G))
        Return the graph with the same vertex set as in G, but whose edge (arc) set consists of the edges (arcs) not present in G.
        See also: 1/ edges 
        Ex1:graph_complement(cycle_graph(5))
        
        '''

     def graph_diameter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_diameter:
        graph_diameter(Graph(G))
        Returns the maximum distance between a pair of vertices in G or +infinity if G is disconnected.
        See also: 1/ allpairs_distance 2/ dijkstra 3/ shortest_path 4/ vertex_distance 
        Ex1:graph_diameter(graph("petersen"))
        
        '''

     def graph_equal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_equal:
        graph_equal(Graph(G1),Graph(G2))
        Returns true iff input graphs G1 and G2 are equal, that is when the sets of vertices and edges of G1 and G2, as well as the orderings of vertices in both graphs, coincide. If the graphs are weighted (they must both be (un)weighted and (un)directed), weights given to the same edge in two graphs must be equal.
        See also: 1/ edges 2/ graph_vertices 
        Ex1:graph_equal(graph([1,2,3],%{[1,2],[2,3],[3,1]%}),graph(trail(1,2,3,1)))
        
        '''

     def graph_join(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_join:
        graph_join(Graph(G),Graph(H))
        Returns the graph obtained by connecting every vertex in G to every vertex in H. The vertex labels in the resulting graph are strings in the form "1:u" resp. "2:v", where u and v are vertices from G and H, respectively.
        See also: 1/ disjoint_union 2/ graph_union 
        Ex1:graph_join(edges(graph_join(cycle_graph(3),graph(2))))
        
        '''

     def graph_power(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_power:
        graph_power(Graph(G),Intg(k))
        Returns the k-th power of G, where two vertices are connected iff there exists a path of length at most k in the original graph.
        See also: 1/ adjacency matrix 2/ graph_diameter 3/ shortest_path 
        Ex1:graph_power(edges(graph_power(path_graph(5),3)))
        
        '''

     def graph_rank(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_rank:
        graph_rank(Graph(G),[Lst(E)])
        Returns the graph rank of G. If an optional set E of edges is given, the rank of the spanning subgraph of G with edge set E is returned.
        See also: 1/ connected_components 2/ number_of_vertices 
        Ex1:graph_rank(graph(%{[1,2],[3,4],[4,5]%}))
        Ex2:graph_rank(graph(%{[1,2],[3,4],[4,5]%}),[[1,2],[3,4])
        
        '''

     def graph_spectrum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_spectrum:
        graph_spectrum(Graph(G))
        Returns the graph spectrum of G as a list of lists with two elements, each containing an eigenvalue and its multiplicity.
        See also: 1/ graph_charpoly 2/ seidel_spectrum 3/ is_integer_graph 
        Ex1:graph_spectrum(cycle_graph(5))
        
        '''

     def graph_union(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_union:
        graph_union(Seq(G1,G2,...))
        Returns the union of graphs G1, G2, ... The set of vertices of the resulting graph is the union of the sets of vertices of the input graphs and the set of edges of the resulting graph is the union of sets of edges of the input graphs. If the input graphs are weighted, the weight of any common edge is the sum of the weights of that edge in G1, G2, ...
        See also: 1/ disjoint_union 2/ graph_join 
        Ex1:graph_union(edges(graph_union(cycle_graph(4),path_graph(5))))
        
        '''

     def graph_vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for graph_vertices:
        graph_vertices(Graph(G))
        Return the list of vertices in G.
        See also: 1/ add_vertex 2/ graph 3/ neighbors 4/ permute_vertices 5/ relabel_vertices 
        Ex1:graph_vertices(graph(%{[a,c],[b,c],[a,b]%}))
        
        '''

     def greduce(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for greduce:
        greduce(Poly,LstPoly,LstVar,[order])
        Returns the remainder of the division of a polynomial by a Groebner basis. Add quo as last argument to get the quotients also.
        See also: 1/ gbasis 
        Ex1:greduce(x*y-1,[x^2-y^2,2*x*y-y^2,y^3],[x,y])
        Ex2:greduce(x*y-1,[x^2-y^2,2*x*y-y^2,y^3],[x,y],quo)
        Ex3:greduce(x1^2*x3^2,[x3^3-1,-x2^2-x2*x3-x3^2,x1+x2+x3],[x1,x2,x3],tdeg)
        Ex4:greduce(x1^2*x3^2-x2,[x3^3-1,-x2^2-x2*x3-x3^2,x1+x2+x3],[x1,x2,x3])
        
        '''

     def greedy_clique(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for greedy_clique:
        greedy_clique(Graph(G),[Intg(n)])
        Returns a large clique in an undirected graph G using the GRASP algorithm with n iterations (default 5).
        See also: 1/ maximum_clique 
        Ex1:greedy_clique(random_regular_graph(100,30))
        
        '''

     def greedy_color(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for greedy_color:
        greedy_color(Graph(G),[Permu(p)])
        Returns the list of vertex colors (positive integers) obtained by coloring vertices one at a time [in the order given by permutation p], assigning to it the smallest available color.
        See also: 1/ is_vertex_colorable 2/ chromatic_number 
        Ex1:greedy_color(graph("petersen"))
        
        '''

     def greedy_independent_set(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for greedy_independent_set:
        greedy_independent_set(Graph(G),[Intg(n)])
        Returns a large independent set in an undirected graph G using the GRASP algorithm with n iterations (default 5).
        See also: 1/ maximum_independent_set 
        Ex1:greedy_independent_set(random_regular_graph(100,30))
        
        '''

     def grey(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for grey:
        grey(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def grid_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for grid_graph:
        grid_graph(Intg(m),Intg(n),[triangle])
        Returns a [triangular] grid graph on m*n vertices, where m,n>=2.
        See also: 1/ torus_grid_graph 
        Ex1:grid_graph(5,8)
        
        '''

     def groupermu(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for groupermu:
        groupermu(Permut(a),Permut(b))
        Returns the group of permutations generated by a and b.
        See also: 1/  
        Ex1:groupermu([1,2,0],[3,1,2,0])
        
        '''

     def haar_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for haar_graph:
        haar_graph(Intg(n))
        Returns the Haar graph with index n.
        See also: 1/ graph 2/ is_bipartite 
        Ex1:haar_graph(7)
        Ex2: is_isomorphic(haar_graph(133),graph("moebius-kantor"))
        
        '''

     def hadamard(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hadamard:
        hadamard(Mtrx,Mtrx)
        Hadamard bound of a matrix or element by element multiplication of 2 matrices.
        See also: 1/ .* 2/ * 
        Ex1:hadamard([[1,2],[3,4]])
        Ex2:hadamard([[1,2],[3,4]],[[3,4],[5,6]])
        
        '''

     def half_cone(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for half_cone:
        half_cone(Pnt(A),Vect(v),Real(t),[Real(h)])
        Draws a half-cone with vertex A, direction v and with half_angle=t [and with altitude h].
        See also: 1/ cone 2/ cylinder 
        Ex1:half_cone([0,0,0],[0,0,1],pi/6)
        Ex2:half_cone([0,0,0],[0,1,1],pi/6,-4)
        
        '''

     def half_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for half_line:
        half_line((Pnt or Cplx),(Pnt or Cplx))
        half_line(A,B) draws the half-line AB with A as origin.
        See also: 1/ line 
        Ex1:half_line(i,1+i)
        Ex2:half_line(point(i),point(1+i))
        
        '''

     def halftan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for halftan:
        halftan(Expr)
        Transforms sin(x),cos(x) and tan(x) to functions of tan(x/2).
        Ex1:halftan(sin(x))
        Ex2:halftan(cos(x))
        Ex3:halftan(tan(x))
        
        '''

     def halftan_hyp2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for halftan_hyp2exp:
        halftan_hyp2exp(ExprTrig)
        Transforms the trigonometric functions in tan(x/2) and hyperbolic functions to exp.
        See also: 1/ hyp2exp 2/ halftan 
        Ex1:halftan_hyp2exp(sin(x)+sinh(x))
        
        '''

     def halt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for halt:
        halt(NULL)
        Puts a program in step-by-step debug mode.
        See also: 1/  
        Ex1:halt()
        
        '''

     def hamdist(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hamdist:
        hamdist(Intg,Intg)
        Bitwise Hamming distance.
        Ex1:hamdist(0x12,0x38)
        
        '''

     def hamming(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hamming:
        hamming(Str(s1)||Lst(s1),Str(s2)||Lst(s2))
        Hamming distance between two vectors or strings of equal lengths.
        See also: 1/ hamdist 2/ levenshtein 
        Ex1:hamming("cats","dogs")
        
        '''

     def hamming_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hamming_window:
        hamming_window(Lst,[Interval(n1..n2)])
        Applies the Hamming windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ bartlett_hann_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(hamming_window(randvector(1000,0..1)))
        
        '''

     def hann_poisson_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hann_poisson_window:
        hann_poisson_window(Lst,[Interval(n1..n2)])
        Applies the Hann-Poisson windowing function with parameter a (by default a=1) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ bartlett_hann_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(hann_poisson_window(randvector(1000,0..1),2))
        
        '''

     def hann_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hann_window:
        hann_window(Lst,[Interval(n1..n2)])
        Applies the Hann windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ bartlett_hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(hann_window(randvector(1000,0..1)))
        
        '''

     def harmonic_centrality(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for harmonic_centrality:
        harmonic_centrality(Graph(G),[Vrtx(v)])
        Returns the harmonic centrality of a vertex v in a graph G or the list of harmonic centralities of vertices in G.
        See also: 1/ degree_centrality 2/ betweenness_centrality 3/ closeness_centrality 4/ information_centrality 5/ katz_centrality 
        Ex1:harmonic_centrality(graph(6,%{[0,2],[0,5],[1,3],[1,5],[2,5],[3,4],[3,5],[4,5]%}))
        
        '''

     def harmonic_conjugate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for harmonic_conjugate:
        harmonic_conjugate(Line or Pnt(A),Line or Pnt(B),Line or Pnt(C))
        Returns the harmonic conjugate C with respect to A and B of 3 points or of 3 parallel or concurrent lines or the line of conjugates of a point with respect to 2 lines.
        See also: 1/ is_harmonic 2/ harmonic_division 
        Ex1:harmonic_conjugate(0,2,3/2)
        Ex2:harmonic_conjugate(0,1+i,2+2*i)
        Ex3:harmonic_conjugate(line(0,1+i),line(0,3+i),line(0,i))
        Ex4:harmonic_conjugate(line(0,1+i),line(0,3+i),point(3/2+i))
        
        '''

     def harmonic_division(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for harmonic_division:
        harmonic_division(Pnt or Line,Pnt or Line,Pnt or Line,Var)
        Returns 4 points (resp lines) and affects the last argument, such that the 4 points (resp lines) are in a harmonic division and assigns the fourth point to the variable name.
        See also: 1/ harmonic_conjugate 2/ is_harmonic 
        Ex1:harmonic_division(0,2,3/2,D)
        Ex2:harmonic_division(0,1+i,2+2*i,D)
        Ex3:harmonic_division(line(i,0),line(i,1+i),line(i,3+2*i),D)
        Ex4:harmonic_division(line(0,1+i),line(0,3+i),line(0,i),D)
        
        '''

     def has(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for has:
        has(Expr,Var)
        Checks if a variable is in an expression.
        See also: 1/ lname 2/ lvar 
        Ex1:has(x+y,x)
        Ex2:has(x+y,n)
        
        '''

     def has_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for has_arc:
        has_arc(Graph(G),Edge(e))
        Returns true iff the arc e=[i,j] is contained in a digraph G or, if e={i,j} is a set, iff G has both edges [i,j] and [j,i].
        See also: 1/ edges 2/ has_edge 
        Ex1:has_arc(digraph(trail(1,2,3,4,1)),[4,2])
        Ex2:has_arc(digraph(trail(1,2,3,4,1)),%{4,2%})
        
        '''

     def has_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for has_edge:
        has_edge(Graph(G),Edge(e))
        Returns true iff the edge e=[i,j] is contained in an undirected graph G.
        See also: 1/ edges 2/ has_arc 
        Ex1:has_edge(graph(trail(1,2,3,4,1)),[2,4])
        
        '''

     def hasard(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hasard:
        hasard(Intg(n) or Interval(p..n) or NULL,[Intg(b1) or Lst(L)],[Intg(b2)])
        (hasard n)=a random integer (resp (hasard p,n)=a real or hasard(p..n)=a real function) with uniform distribution in 0..n-1 (resp in [p;n])(hasard= (hasard 0,1)=a random real in [0,1[) or hasard(n,b1,b2)=n integers between b1 and b2 or hasard(n,L)=n elements of L. If hasard has only one argument, () are not necessary (compatibility with turtle language).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ srand 
        Ex1: hasard 4
        Ex2: hasard(4)
        Ex3:hasard(0,2)
        Ex4: hasard 0..2
        Ex5: f:=hasard 0..2
        Ex6:hasard(3,1,10)
        Ex7:hasard(3,["r","r","r","b","n"])
        
        '''

     def head(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for head:
        head(Vect or Seq or Str)
        Shows the first element of a vector or a sequence or a string.
        See also: 1/ back 2/ tail 3/ mid 4/ left 5/ right 
        Ex1:head(1,2,3)
        Ex2:head([1,2,3])
        Ex3:head("bonjour")
        
        '''

     def heading(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for heading:
        heading(NULL or Real)
        Returns the turtle cap in degrees or turns the turtle in the direction given by the argument.
        See also: 1/ position 2/ initialise 
        Ex1: cap
        Ex2:heading()
        Ex3:heading(cap 90)
        
        '''

     def heapify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for heapify:
        heapify(List)
        Partial ordering of a list as a heap.
        See also: 1/ heappush 2/ heappop 
        
        '''

     def heappop(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for heappop:
        heappop(List)
        Removes and returns the root node of a heap.
        See also: 1/ heapify 2/ heappush 
        
        '''

     def heappush(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for heappush:
        heappush(List,Object)
        Adds an object in a heap.
        See also: 1/ heapify 2/ heappop 
        
        '''

     def hermite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hermite:
        hermite(Intg(n)||Matr(A))
        Returns the Hermite polynomial of degree n or the Hermite normal form for a matrix with polynomial coefficients (I,U such that I*A=U).
        See also: 1/ legendre 2/ laguerre 3/ smith 4/ ihermite 5/ ismith 
        Ex1:hermite(3)
        Ex2: n:=5; a:=ranm(n,n) % 17; l,u:=hermite(x-a);normal(l*(x-a)-u);
        
        '''

     def hessenberg(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hessenberg:
        hessenberg(Mtrx(A),[Intg(n)])
        Matrix reduction to Hessenberg form. Returns [P,B] such that B=inv(P)*A*P, by default n=0 the result is exact else the result is numeric. For n=-1 B is triangular, n=-2 P is orthogonal and if n is prime the result is mod n.
        See also: 1/ SCHUR 
        Ex1:hessenberg([[1,2,3],[4,5,6],[7,8,1]])
        Ex2:hessenberg([[1,2,3,4],[4,5,6,7],[7,8,9,0],[0,1,2,3]])
        Ex3:hessenberg([[1,2,3],[4,5,6],[7,8,1]],-1)
        Ex4:hessenberg([[1,2,3],[4,5,6],[7,8,1]],-2)
        Ex5:hessenberg([[1,2,3],[4,5,6],[7,8,1]],3)
        
        '''

     def hessian(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hessian:
        hessian(Expr(Xpr),LstVar)
        Returns the hessian of the expression Xpr.
        See also: 1/ grad 
        Ex1:hessian(2*x^2*y-x*z,[x,y,z])
        
        '''

     def heugcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for heugcd:
        heugcd(Poly,Poly)
        GCD of 2 polynomials, with the algorithm called heuristic pgcd.
        See also: 1/ gcd 2/ modgcd 3/ ezgcd 4/ psrgcd 
        Ex1:heugcd(x^4-1,(x-1)^2)
        
        '''

     def hexagon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hexagon:
        hexagon(Pnt(A)||Cplx,Pnt(B)||Cplx,[Pnt(P)],[Var(C)],[Var(D)],[Var(E)],[Var(F)])
        Returns and draws the hexagon of side AB (ABCDEF is direct) (in the plane ABP).
        See also: 1/ isopolygon 2/ polygon 
        Ex1:hexagon(i,1+i)
        Ex2:hexagon(i,1+i,C,D,E,F)
        Ex3:hexagon(point(0,0,0),point(3,3,3),point(0,0,3))
        Ex4:hexagon(point(0,0,0),point(3,3,3),point(0,0,3),C,D,E,F)
        
        '''

     def hht(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hht:
        hht(Lst(data)||Mtrx(imf),[opts])
        Hilbert-Huang transform.
        See also: 1/ emd 2/ colormap 
        Ex1:hht(apply(x->cos(10*x^2*pi),linspace(-pi,pi,500)),color=false,frequencies=0.1..2.5,output=plot)
        
        '''

     def highlight_edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for highlight_edges:
        highlight_edges(Graph(G),Edge(e)||Lst(E),[Color(c)||Lst(C)])
        Changes color of edge e resp. colors of edges in E of the input graph G to c resp. C (by default red) and returns a modified copy of G.
        See also: 1/ highlight_vertex 2/ highlight_subgraph 3/ highlight_trail 
        Ex1: draw_graph(highlight_edges(cycle_graph(3),[1,2]))
        
        '''

     def highlight_subgraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for highlight_subgraph:
        highlight_subgraph(Graph(G),Graph(S)||Lst(S1,S2,..),Seq(c1,c2))
        Changes the colors of edges and vertices from a sugbraph S or subgraphs S1, S2, ... of G to c1 and c2, respectively (red and green by default), and returns a modified copy of G.
        See also: 1/ highlight_edges 2/ highlight_vertex 3/ highlight_trail 
        Ex1: draw_graph(highlight_subgraph(cycle_graph(5),path_graph(3)))
        
        '''

     def highlight_trail(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for highlight_trail:
        highlight_trail(Graph(G),Trail(t)||Lst(T),[Color(c)||Lst(C)])
        Changes the colors of edges in G which lie along a trail t resp. trails in T to c resp. C (by default red) and returns a modified copy of G.
        See also: 1/ highlight_edges 2/ highlight_subgraph 3/ highlight_vertex 
        Ex1: draw_graph(highlight_trail(cycle_graph(5),trail(1,2,3),green)
        
        '''

     def highlight_vertex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for highlight_vertex:
        highlight_vertex(Graph(G),Vrtx(v)||Lst(V),[Color(c)||Lst(C)])
        Changes the color of vertex v resp. colors of vertices from V in G to c resp. C (green by default) and returns a modified copy of G.
        See also: 1/ highlight_edges 2/ highlight_subgraph 3/ highlight_trail 
        Ex1: draw_graph(highlight_vertex(cycle_graph(3),1))
        
        '''

     def highpass(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for highpass:
        highpass(Lst(s),Real(c),[Intg(samplerate)])
        Returns the result of applying a simple first-order highpass RC filter with cutoff frequency c (the default samplerate is 44100) to the given signal s.
        See also: 1/ lowpass 2/ moving_average 
        Ex1: f:=unapply(periodic(sign(x),x,-1/880,1/880),x):;s:=createwav(apply(f,soundsec(1))):;playsnd(highpass(s,5000))
        
        '''

     def hilbert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hilbert:
        hilbert(Intg(n)||(Expr(f),[Var(x)])||Lst(u))
        Returns the order n Hilbert matrix Hjk=1/(j+k+1), j,k=1..n, or the Hilbert transform of an expression f(x) or the analytic representation of a discrete real signal u.
        See also: 1/ Hilbert 2/ fft 3/ fourier 
        Ex1:hilbert(4)
        Ex2:hilbert(1/(1+t^2),t)
        Ex3:hilbert(sinc(x))
        Ex4:hilbert([0.7,0.2,-0.5,-0.6,-0.2,0.3,0.5,-0.1,-0.3])
        
        '''

     def histogram(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for histogram:
        histogram(Lst(data),[Lst(eff) || Intg(nc) || Real(classmin)],[Real(classsize)])
        Draws the histogram of data, optional arguments are eff (number of data for each data element) or nc the number of classes or the classes minimum and size.
        See also: 1/ cumulated_frequencies 2/ classes 3/ bar_plot 4/ frequencies 
        Ex1:histogram([1,2,1,1,2,1,2,4,3,3])
        Ex2:histogram([1,2,1,1,2,1,2,4,3,3],0.5,1)
        Ex3:histogram(seq(rand(1000),k,0,100),0,100)
        Ex4:histogram(binomial,10,.5)
        Ex5:histogram([[0,1],[1,4],[2,3],[3,2],[4,1]])
        Ex6:histogram([[1.5..1.65,50],[1.65..1.7,20],[1.7..1.8,30]])
        Ex7:histogram(seq(rand(1000),k,0,100),0,100)
        Ex8:histogram(seq(rand(1000),k,0,100),10)
        
        '''

     def hold(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hold:
        hold(Expr)
        Returns its argument unevaluated (and also a:=quote(a) purges a).
        See also: 1/  
        Ex1:hold(1+2)
        Ex2:hold(1/x+1/(x-1))
        Ex3:hold((x+1)*(x-1))
        
        '''

     def homogeneize(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for homogeneize:
        homogeneize(Expr(P),[Var(t)])
        Make P homogeneous by adding a variable (by default t)
        Ex1:homogeneize(x^2-1)
        Ex2:homogeneize(x^2-y,z)
        
        '''

     def homothety(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for homothety:
        homothety(Pnt(C),Real(k),Pnt(A))
        homothety(C,k,A)=point A1 such as vect(C,A1)=k*vect(C,A) i.e in 2d it is the similarity with center C, coeff abs(k) and angle arg(k).
        See also: 1/ similarity 2/ inversion 
        Ex1:homothety(1+i,1/3,i)
        Ex2:homothety(point(1,1,1),1/3,point(0,1,0))
        Ex3: h:=homothety(1+i,1/3);h(i)
        Ex4: h:=homothety(point(1,1,1),1/3);h(point(0,1,0))
        
        '''

     def horner(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for horner:
        horner(Poly(P),Real(a))
        Returns the value of P(a) calculated with Horner's method. With horner(list_alpha_i,list_x_i,x), evals an interpolation polynomial from the divided differences of x.
        See also: 1/ convert 2/ base 3/ revlist 
        Ex1:horner(x^2+1,2)
        Ex2:horner([1,0,1],2)
        Ex3:horner(x^2+y*x+y^3-1,2,y)
        Ex4: X:=[0.0,1.0,2.0]; A:=lagrange(X,exp,lagrange); horner(A,X,1.5);
        
        '''

     def hsv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hsv:
        hsv(Lst(h,s,v)||Color(c))
        Convert a HSV specification [h,s,v] to xcas color or return the HSV specification of a xcas color c.
        See also: 1/ rgb 2/ hsv2rgb 3/ rgb2hsv 
        Ex1:hsv(220,90,100)
        Ex2:hsv([0.3,0.7,0.5])
        Ex3:hsv(teal)
        
        '''

     def hsv2rgb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hsv2rgb:
        hsv2rgb(Lst(h,s,v))
        Convert HSV to RGB.
        See also: 1/ rgb2hsv 2/ rgb 3/ hsv 
        Ex1:hsv2rgb(220,75,49)
        Ex2:hsv2rgb([0.0833,0.67,0.3])
        Ex3:hsv2rgb(0.0833,0.67,0.3)
        
        '''

     def hybrid_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hybrid_solver:
        hybrid_solver(Opt)
        Argument for fsolve giving the method for solving a system of numerical equations.
        See also: 1/ fsolve 
        Ex1: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver)
        Ex2: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver)
        Ex3: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver)
        Ex4: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver)
        Ex5: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver)
        Ex6: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)
        
        '''

     def hybridj_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hybridj_solver:
        hybridj_solver(Opt)
        Argument for fsolve giving the method for solving a system of numerical equations.
        See also: 1/ fsolve 
        Ex1: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver)
        Ex2: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver)
        Ex3: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver)
        Ex4: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver)
        Ex5: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver)
        Ex6: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)
        
        '''

     def hybrids_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hybrids_solver:
        hybrids_solver(Opt)
        Argument for fsolve giving the method for solving a system of numerical equations.
        See also: 1/ fsolve 
        Ex1: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver)
        Ex2: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver)
        Ex3: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver)
        Ex4: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver)
        Ex5: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver)
        Ex6: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)
        
        '''

     def hybridsj_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hybridsj_solver:
        hybridsj_solver(Opt)
        Argument for fsolve giving the method for solving a system of numerical equations.
        See also: 1/ fsolve 
        Ex1: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver)
        Ex2: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver)
        Ex3: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver)
        Ex4: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver)
        Ex5: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver)
        Ex6: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)
        
        '''

     def hyp2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hyp2exp:
        hyp2exp(ExprHyperb)
        Transforms the hyperbolic functions to the exponential function.
        See also: 1/ halftan_hyp2exp 
        Ex1:hyp2exp(cosh(x))
        
        '''

     def hyperbola(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hyperbola:
        hyperbola(Focus(F1),Focus(F2),(Pnt(M) or Real(a)))
        hyperbola(F1,F2,M)=hyperbola with foci F1,F2 through M or (|MF1-MF2|=2*a geo2d) and hyperbola(p(x,y)) draws the conic if deg(p)=2.
        See also: 1/ ellipse 2/ parabola 
        Ex1:hyperbola(-1,1,point(1+i))
        Ex2:hyperbola(-1,1,sqrt(5)-1)
        Ex3:hyperbola(point(-1,0,0),point(1,0,0),point(1,1,1))
        Ex4:hyperbola(x^2-y^2+y+2)
        
        '''

     def hypercube_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for hypercube_graph:
        hypercube_graph(Intg(n))
        Constructs and returns a hypercube graph in dimension n (with 2^n vertices).
        See also: 1/ graph 
        Ex1:hypercube_graph(3)
        
        '''

     def iPart(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for iPart:
        iPart(Real||LstReal)
        Returns the argument without its fractional part (type=DOM_FLOAT).
        See also: 1/ fPart 2/ floor 3/ trunc 
        Ex1:iPart(4.3)
        Ex2:iPart(sqrt(2))
        Ex3:iPart(4.3,sqrt(2))
        
        '''

     def iabcuv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for iabcuv:
        iabcuv(Intg(a),Intg(b),Intg(c))
        Returns [u,v] such that au+bv=c for 3 integers a,b,c.
        See also: 1/ iegcd 2/ abcuv 
        Ex1:iabcuv(21,28,7)
        Ex2:iabcuv(21,28,14)
        Ex3:iabcuv(21,28,1)
        
        '''

     def ibasis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ibasis:
        ibasis(Lst(Vect,..,Vect),Lst(Vect,..,Vect))
        Basis of the intersection of two vector spaces.
        See also: 1/ basis 
        Ex1:ibasis([[1,0,0],[0,1,0]],[[1,1,1],[0,0,1]])
        
        '''

     def ibpdv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ibpdv:
        ibpdv(Expr(f(x)),Expr(v(x)),[Var(x)],[Real(a)],[Real(b)])
        Integration by parts of f(x)=u(x)*v'(x) with f(x) as 1st argument and v(x) (or 0) as 2nd argument. You can specify a variable of integration and also calculate the integral (bounds a and b).
        See also: 1/ ibpu 2/ int 
        Ex1:ibpdv(ln(x),x)
        Ex2:ibpdv(ln(x),x,x,1,3)
        Ex3:ibpdv(x*ln(x),x^2/2)
        Ex4:ibpdv([x*ln(x),-1],0)
        Ex5:ibpdv(ibpdv(ln(x),x,x,2,3),0,x,2,3)
        
        '''

     def ibpu(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ibpu:
        ibpu(Expr(f(x)),Expr(u(x)),[Var(x)],[Real(a)],[Real(b)])
        Integration by parts of f(x)=u(x)*v'(x) with f(x) as 1st argument and u(x) (or 0) as 2nd argument. You can specify a variable of integration and also calculate the integral (bounds a and b).
        See also: 1/ ibpdv 2/ int 
        Ex1:ibpu(ln(x),ln(x))
        Ex2:ibpu(ln(x),ln(x),x,1,3)
        Ex3:ibpu(x*ln(x),ln(x))
        Ex4:ibpu([x*ln(x),-1],0)
        Ex5:ibpu(ibpu(ln(x),ln(x),x,2,3),0,x,2,3)
        
        '''

     def icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for icdf:
        icdf(Func,FuncParams)
        Inverse cumulative distribution function.
        See also: 1/ cdf 2/ binomial_icdf 3/ normald_icdf 
        Ex1:icdf(binomial,10,0.5,0.6)
        Ex2:icdf(normald,0.0,1.0,0.975)
        
        '''

     def ichinrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ichinrem:
        ichinrem(LstIntg(a,p),LstIntg(b,q))
        Chinese remainders for integers.
        See also: 1/ gcd 2/ fracmod 3/ chinrem 4/ chrem 
        Ex1:ichinrem([2,7],[3,5])
        Ex2:ichinrem([2%7,3%5])
        Ex3:ichinrem([2%7,3%5,1%9])
        Ex4:ichinrem([(x+1)%2,(x+2)%3,(3*x-1)%5])
        
        '''

     def ichrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ichrem:
        ichrem(LstIntg(a,p),LstIntg(b,q))
        Chinese remainders for integers.
        See also: 1/ gcd 2/ fracmod 3/ chinrem 4/ chrem 
        Ex1:ichrem([2,7],[3,5])
        Ex2:ichrem([2%7,3%5])
        Ex3:ichrem([2%7,3%5,1%9])
        Ex4:ichrem([(x+1)%2,(x+2)%3,(3*x-1)%5])
        
        '''

     def icomp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for icomp:
        icomp(Intg(n),Intg(k),[zeros=true||false])
        Returns the list of compositions of n into k parts.
        See also: 1/ sum 
        Ex1:icomp(4,2)
        Ex2:icomp(6,3,zeros=false)
        
        '''

     def icontent(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for icontent:
        icontent(Poly,[Var])
        GCD of the integer coefficients of a polynomial.
        See also: 1/  
        Ex1:icontent(24x^3+6x^2-12x+18)
        Ex2:icontent(24t^3+6t^2-12t+18,t)
        
        '''

     def icosahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for icosahedron:
        icosahedron(Pnt(A),Pnt(B),Pnt(C))
        Draws an icosahedron with center A, vertex B and such that the plane ABC contains one vertex among the 5 nearest vertices from B.
        See also: 1/ octahedron 2/ dodecahedron 3/ cube 4/ tetrahedron 
        Ex1:icosahedron([0,0,0],[sqrt(5),0,0],[1,2,0])
        Ex2:icosahedron(evalf([0,0,0],[3,2,4],[1,1,0]))
        
        '''

     def id(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for id:
        id(Seq)
        The name of the identity function (ℝ^n -> ℝ^n).
        See also: 1/ sq 2/ sqrt 
        Ex1:id(1,2,3)
        
        '''

     def identify_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for identify_graph:
        identify_graph(Graph(G))
        Returns the list of named graphs known to Giac which are isomorphic to G.
        See also: 1/ is_isomorphic 2/ graph 
        Ex1:identify_graph(graph("petersen"))
        
        '''

     def identity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for identity:
        identity(Intg(n))
        Returns the identity matrix of specified dimension n.
        See also: 1/ ranm 
        Ex1:identity(3)
        Ex2:identity(5)
        
        '''

     def idivis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for idivis:
        idivis(Intg(a) or LstIntg)
        Returns the list of divisors of an integer.
        See also: 1/ divis 2/ ifactors 
        Ex1:idivis(36)
        Ex2:idivis([36,49])
        
        '''

     def idn(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for idn:
        idn(Intg(n))
        Returns the identity matrix of specified dimension n.
        See also: 1/ ranm 
        Ex1:idn(3)
        Ex2:idn(5)
        
        '''

     def idwt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for idwt:
        idwt((Lst||Mtrx)(T),[opts])
        Returns the original data from its discrete wavelet transform if called with the same options.
        See also: 1/ dwt 2/ fft 3/ ifft 
        Ex1: t:=dwt([0.0,0.5,0.25,1.0,0.75,-0.25,-0.5,0.0]):;idwt(t)
        Ex2: t:=dwt([[15,25,5,70],[21,33,12,7],[64,18,50,10],[5,17,35,28]]):;idwt(t)
        
        '''

     def iegcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for iegcd:
        iegcd(Intg,Intg)
        Extended greatest common divisor of 2 integers.
        See also: 1/ gcd 2/ iabcuv 3/ egcd 
        Ex1:iegcd(45,75)
        Ex2:iegcd(21,28)
        Ex3:iegcd(30,49)
        
        '''

     def ifactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ifactor:
        ifactor(Intg(a))
        Factorization of an integer into prime factors.
        See also: 1/ factor 2/ ecm_factor 
        Ex1:ifactor(50)
        Ex2:ifactor(123456789)
        
        '''

     def ifactors(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ifactors:
        ifactors(Intg(a) or LstIntg)
        Returns the list of prime factors of an integer (each factor is followed by its multiplicity).
        See also: 1/ ifactor 2/ factors 
        Ex1:ifactors(36)
        Ex2:ifactors([36,52])
        
        '''

     def ifourier(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ifourier:
        ifourier(Expr(F(s)),[Var(s),[Var(x)]])
        Returns the inverse Fourier transform f(x) of F(s).
        See also: 1/ fourier 2/ fourier_cn 3/ ifft 
        Ex1:ifourier(2*pi*(Dirac(s)-sign(s)*sin(s)),s,x)
        Ex2:ifourier(-2/(s^2-1),s,x)
        Ex3:ifourier(pi/(exp(pi*s/4)+exp(-pi*s/4)),s,x)
        Ex4:ifourier(6*pi*exp(-exp(-3*s)-3*s),s,x)
        Ex5:ifourier(pi*ugamma(0,4*abs(s)),s,x)
        Ex6:ifourier(fourier(exp(-abs(x)),x,s)^2,s,x)
        Ex7:ifourier(sinc(s),s,x)
        
        '''

     def igamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for igamma:
        igamma(Real(a),Real(x),[1])
        Calculates of gamma at a point (a,x). If a and x>0, igamma(a,x)=int(e^{-t}*t^{a-1},t=0..x), (igamma(a,x,1)=igamma(a,x)/Gamma(a)).
        See also: 1/ Psi 2/ Beta 3/ Gamma 3/ ugamma 
        Ex1:igamma(5.0,2.0)
        Ex2:igamma(-5.1,2.1)
        Ex3:igamma(5.0,2.0,1)
        
        '''

     def igcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for igcd:
        igcd((Intg(a) or Poly),(Intg(b) or Poly))
        Returns the greatest common divisor of 2 polynomials of several variables or of 2 integers or of 2 rationals.
        See also: 1/ lcm 2/ euler 2/ modgcd 3/ ezgcd 4/ psrgcd 5/ heugcd 6/ Gcd 
        Ex1:igcd(45,75)
        Ex2:igcd(15/7,50/9)
        Ex3:igcd(x^2-2*x+1,x^3-1)
        Ex4:igcd(t^2-2*t+1,t^2+t-2)
        Ex5:igcd((x^2-1)*(y^2-1)*z^2,x^3*y^3*z+(-(y^3))*z+x^3*z-z)
        
        '''

     def igcdex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for igcdex:
        igcdex(Intg,Intg)
        Extended greatest common divisor of 2 integers.
        See also: 1/ gcd 2/ iabcuv 3/ egcd 
        Ex1:igcdex(45,75)
        Ex2:igcdex(21,28)
        Ex3:igcdex(30,49)
        
        '''

     def ihermite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ihermite:
        ihermite(Mtrx(A))
        Hermite normal form of a matrix with coefficients in ℤ : returns L,U such that L is invertible in ℤ, U is upper triangular and U=L*A.
        See also: 1/ ismith 
        Ex1:ihermite([[9,-36,30], [-36,192,-180], [30,-180,180]])
        Ex2:ihermite([[1,2,3],[4,5,6],[7,8,9]])
        
        '''

     def ilaplace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ilaplace:
        ilaplace(Expr,[Var],[IlapVar])
        Inverse Laplace transform of a rational fraction.
        See also: 1/ laplace 2/ ztrans 3/ invztrans 4/ Heaviside 
        Ex1:ilaplace(1/(x^2+1)^2)
        Ex2:ilaplace(s/(s^4-1),s,x)
        Ex3:ilaplace(exp(-s)/s,s,x)
        
        '''

     def im(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for im:
        im(Cplx)
        Returns the imaginary part of a complex number.
        See also: 1/ re 2/ conj 
        Ex1:im(1+2*i)
        Ex2:im((1+2*i)^2)
        Ex3:im([1+2*i,(1+2*i)^2])
        
        '''

     def imag(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for imag:
        imag(Cplx)
        Returns the imaginary part of a complex number.
        See also: 1/ re 2/ conj 
        Ex1:imag(1+2*i)
        Ex2:imag((1+2*i)^2)
        Ex3:imag([1+2*i,(1+2*i)^2])
        
        '''

     def image(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for image:
        image(Mtrx(M)||Strng(imgfname))
        Returns the image of a linear map with matrix M or an image object loaded from file imgfname.
        See also: 1/ ker 2/ rref 
        Ex1:image([[1,2],[3,6]])
        Ex2:image([[1,2,3],[1,3,6],[2,5,9]])
        
        '''

     def imfplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for imfplot:
        imfplot(Lst(imf),[opts])
        Displays selected intrinsic mode functions in a stacked layout.
        See also: 1/ emd 
        Ex1:imfplot(emd(apply(x->cos(10*x^2*pi),linspace(-pi,pi)),residue=false))
        
        '''

     def implicitdiff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for implicitdiff:
        implicitdiff(constr,[depvars],y,diffvars)
        Implicit differentiation.
        See also: 1/ diff 
        Ex1:implicitdiff(x^2*y+y^2=1,y,x)
        Ex2:implicitdiff(R=P*V/T,P,T)
        Ex3:implicitdiff([x^2+y=z,x+y*z=1],[y(x),z(x)],[y,z],x)
        Ex4:implicitdiff(x*y,-2x^3+15x^2*y+11y^3-24y=0,y(x),x$2)
        Ex5:implicitdiff((x-u)^2+(y-v)^2,[x^2/4+y^2/9=1,(u-3)^2+(v+5)^2=1],[v(u,x),y(u,x)],u,x)
        Ex6:implicitdiff(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,z,y],order=1)
        Ex7:implicitdiff(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,z,y],order=2,[1,-1,0])
        Ex8: pd:=implicitdiff(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,z,y],order=4,[0,z,0]);pd[4,0,0]
        
        '''

     def implicitplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for implicitplot:
        implicitplot(Expr,Var1,Var2)
        plotimplicit(f(x,y),x,y) or plotimplicit(f(x,y),[x,y]) draws graph of f(x,y)=0.
        See also: 1/ plotcontour 2/ unfactored 3/ plotinequation 
        Ex1:implicitplot(x^2+y^2-1,x,y)
        Ex2:implicitplot(x^4+y^4=x^2-y^2)
        Ex3:implicitplot(x^2+y^2-1,x,y,unfactored)
        Ex4:implicitplot(x^2+4*y^3-1)
        Ex5:implicitplot(x^2+4*y^3-k)$(k=-5..5)
        Ex6:implicitplot(y^3=x^3-x^2,x,y,xstep=0.1,ystep=0.1)
        Ex7:implicitplot(y^3=x^3-x^2,[x,y],xstep=0.1,ystep=0.1)
        Ex8:implicitplot((x+5)^2+(y+4)^2-1,x=-6..-4,y=-5..-3)
        Ex9:implicitplot((x+5)^2+(y+4)^2-1,[x=-6..-4,y=-5..-3])
        
        '''

     def import_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for import_graph:
        import_graph(Str("filename"),[opts])
        Returns the graph constructed from instructions in the file 'filename' in dot/lst format, or "undef" on failure.
        Ex1:import_graph("K5.dot")
        
        '''

     def inString(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inString:
        inString(Str(l),Elem(e))
        Tests if e is in the string l (returns -1 or k if l[k]=e).
        See also: 1/ contains 
        Ex1:inString("abcd","b")
        Ex2:inString("abcd","e")
        
        '''

     def in_ideal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for in_ideal:
        in_ideal(Poly,Lst,LstVar,[order])
        Checks whether a polynomial or list of polynomials belongs to an ideal given by a Grobner basis (2nd argument) with respect to a variable list.
        See also: 1/ gbasis 2/ greduce 
        Ex1:in_ideal((x+y)^2,[y^2,x^2+2*x*y],[x,y])
        Ex2:in_ideal(x+y,[y^2,x^2+2*x*y],[x,y])
        
        '''

     def incidence_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for incidence_matrix:
        incidence_matrix(Graph(G))
        Returns the incidence matrix of G whose rows are indexed by the vertices and columns by the edges (in order defined by the commands 'vertices' and 'edges', respectively).
        See also: 1/ incident_edges 
        Ex1:incidence_matrix(graph("tetrahedron"))
        
        '''

     def incident_edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for incident_edges:
        incident_edges(Graph(G),Vrtx(v))
        Returns the list of all edges incident to the vertex v in G (or to the vertices in the list v).
        See also: 1/ adjacency_matrix 2/ vertex_degree 3/ incidence_matrix 4/ neighbors 
        Ex1:incident_edges(cycle_graph(8),[1,5,7])
        
        '''

     def incircle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for incircle:
        incircle((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        incircle(A,B,C) draws the incircle of the triangle ABC.
        See also: 1/ excircle 2/ circumcircle 
        Ex1:incircle(0,1,1+i)
        
        '''

     def increasing_power(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for increasing_power:
        increasing_power(:=Intg(0 or 1))
        Pseudo-variable to control the display of polynomials.
        See also: 1/ cas_setup 
        Ex1: increasing_power:=1
        Ex2: increasing_power:=0
        
        '''

     def independence_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for independence_number:
        independence_number(Graph(G))
        Returns the independence number of G.
        See also: 1/ clique_number 2/ graph_complement 3/ maximum_clique 4/ maximum_independent_set 
        Ex1:independence_number(complete_graph(3,4))
        
        '''

     def indets(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for indets:
        indets(Expr)
        List of variables in the expression.
        See also: 1/ has 2/ lvar 
        Ex1:indets(exp(x)*2*sin(y))
        
        '''

     def index(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for index:
        index(Vect,Expr)
        Index of the first position of an object in a list, a string or a set or returns an error message.
        See also: 1/ find 2/ member 
        Ex1:index([3,x,1,2,1,3],1)
        Ex2:index([0,1,3,2,4,2,5],2)
        Ex3:index(%{4,3,1,2%},1)
        Ex4:index("abracadabrant","c")
        
        '''

     def induced_subgraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for induced_subgraph:
        induced_subgraph(Graph(G),Lst(V))
        Returns the subgraph of G induced by the vertices in list V.
        See also: 1/ subgraph 
        Ex1:induced_subgraph(cycle_graph(6),[1,2,6])
        
        '''

     def inequationplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inequationplot:
        inequationplot(Expr,[x=xrange,y=yrange],[xstep],[ystep])
        Shows the graph of the solutions of inequalities with 2 variables.
        See also: 1/ plotfunc 2/ plotcontour 3/ plotdensity 4/ plotimplicit 
        Ex1:inequationplot(x^2-y^2<3)
        Ex2:inequationplot(x^2-y^2<3,[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1)
        Ex3:inequationplot(3-(x^2-y^2),[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1)
        Ex4:inequationplot([x+y>3,x^2<y],[x,y],xstep=0.2,ystep=0.2)
        
        '''

     def inertia(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inertia:
        inertia(Mtrx(A),[B,[p0]])
        Returns the triplet [p,n,z] of nonnegative integers indicating the number of
        See also: 1/ ldl 
        Ex1:inertia(positive, negative, and zero eigenvalues of the real symmetric matrix A,)
        Ex2:inertia(optionally alongside the solution to X*tran(A)=B if z=0 (and p=p0).)
        Ex3:inertia([[1,-1,2],[-1,4,3],[2,3,-5]])
        Ex4:inertia([[1,-1,2],[-1,4,3],[2,3,-5]],[[1,2,3],[4,5,6]])
        Ex5:inertia([[1,-1,2],[-1,4,3],[2,3,-5]],[[1,2,3],[4,5,6]],2)
        
        '''

     def inf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inf:
        inf()
        Plus infinity.
        See also: 1/ infinity 2/ -infinity 3/ isinf 
        
        '''

     def infinity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for infinity:
        infinity()
        Unsigned infinity.
        See also: 1/ +infinity 2/ -infinity 3/ isinf 
        
        '''

     def information_centrality(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for information_centrality:
        information_centrality(Graph(G),[Vrtx(v)],[approx])
        Returns the information centrality of a vertex v in a graph G or the list of information centralities of vertices in G.
        See also: 1/ degree_centrality 2/ betweenness_centrality 3/ closeness_centrality 4/ harmonic_centrality 5/ katz_centrality 
        Ex1:information_centrality(graph(6,%{[0,2],[0,5],[1,3],[1,5],[2,5],[3,4],[3,5],[4,5]%}))
        
        '''

     def insert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for insert:
        insert(Vect(l)||Str(l),Intg(n),Val(b))
        Returns l where the element b is of index n.
        See also: 1/ tail 2/ mid 3/ remove 4/ suppress 
        Ex1:insert([0,1,2,3],2,5)
        Ex2:insert("0123",2,"5")
        
        '''

     def insmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for insmod:
        insmod(Str(pwd))
        Installs a dynamic module (by entering the pwd of this file), creates the commands that are, for example, in the file libprogfr
        See also: 1/ rmmod 2/ lsmod 
        Ex1:insmod("/home/parisse/giac/src/libprogfr.so")
        
        '''

     def instfreq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for instfreq:
        instfreq(Vect(u)||Expr(u),[Var(x)])
        Returns the instantaneous angular frequency of an analytic signal u.
        See also: 1/ hilbert 2/ instphase 
        Ex1:instfreq(hilbert([0.7,0.2,-0.5,-0.6,-0.2,0.3,0.5,-0.1,-0.3]))
        Ex2: u:=(t-3+(t-2)^2)/(1+(t-2)^4):;instfreq(u+i*hilbert(u,t),t)
        
        '''

     def instphase(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for instphase:
        instphase(Vect(u)||Expr(u),[Var(x)])
        Returns the instantaneous phase of an analytic signal u.
        See also: 1/ hilbert 2/ instfreq 
        Ex1:instphase(hilbert([0.7,0.2,-0.5,-0.6,-0.2,0.3,0.5,-0.1,-0.3]))
        Ex2: u:=(t-3+(t-2)^2)/(1+(t-2)^4):;instphase(u+i*hilbert(u,t),t)
        
        '''

     def int(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for int:
        int(Expr,[Var(x)],[Real(a)],[Real(b)])
        Indefinite integral, you can specify a variable of integration or calculate the integral (bounds a and b).
        See also: 1/ Int 2/ diff 3/ plotarea 4/ romberg 5/ gaussquad 
        Ex1:int(1/x)
        Ex2:int(1/(4+t^2),t)
        Ex3:int(1/(1-x^4),x,2,3)
        
        '''

     def intDiv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for intDiv:
        intDiv(Intg(a),Intg(b))
        Euclidean quotient of 2 integers.
        See also: 1/ irem 2/ smod 3/ quo 
        Ex1:intDiv(125,15)
        Ex2:intDiv(125,41)
        Ex3:intDiv(-7,3)
        Ex4:intDiv(25+12*i,5+7*i)
        
        '''

     def integer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for integer:
        integer(Opt)
        DOM_INT or integer or DOM_int is an integer which is the type of an integer variable, it is the value of the type command. DOM_INT is used for integers < 2^31. It is also an option of the assume command.
        See also: 1/ type 2/ assume 3/ DOM_FLOAT 4/ DOM_SYMBOLIC 
        Ex1: type(2^31)
        Ex2: DOM_INT+0
        Ex3: assume(a,DOM_INT)
        Ex4: assume(a,integer)
        Ex5: a:=2;type(a)
        
        '''

     def integrate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for integrate:
        integrate(Expr,[Var(x)],[Real(a)],[Real(b)])
        Indefinite integral, you can specify a variable of integration or calculate the integral (bounds a and b).
        See also: 1/ Int 2/ diff 3/ plotarea 4/ romberg 5/ gaussquad 
        Ex1:integrate(1/x)
        Ex2:integrate(1/(4+t^2),t)
        Ex3:integrate(1/(1-x^4),x,2,3)
        
        '''

     def integrer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for integrer:
        integrer(Expr,[Var(x)],[Real(a)],[Real(b)])
        Indefinite integral, you can specify a variable of integration or calculate the integral (bounds a and b).
        See also: 1/ Int 2/ diff 3/ plotarea 4/ romberg 5/ gaussquad 
        Ex1:integrer(1/x)
        Ex2:integrer(1/(4+t^2),t)
        Ex3:integrer(1/(1-x^4),x,2,3)
        
        '''

     def inter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inter:
        inter(Curve,Curve,[Pnt])
        With 2 arguments (resp 3 arguments) gives the intersection of 2 curves or surfaces as a vector (resp a point close to the point given as third argument).
        See also: 1/ intersect 2/ head 
        Ex1:inter(line(i,1-i),circle(0,1))
        Ex2:inter(line(i,1-i),circle(0,1),point(-i))
        Ex3:inter(plane(x=y+3),cone([0,0,0],[0,0,1],pi/6))
        Ex4:inter(plane(x=y+3),cone([0,0,0],[0,0,1],pi/6))
        Ex5:inter(line(i,1-i),circle(0,1))[0]
        
        '''

     def interactive_odeplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for interactive_odeplot:
        interactive_odeplot(Expr,VectVar)
        Draws (in DispG) a solution for each point t0+i*y0 clicked with the mouse (Esc=halt).
        See also: 1/ odeplot 2/ plotfield 3/ odesolve 4/ desolve 
        Ex1:interactive_odeplot(sin(t*y),[t,y])
        Ex2:interactive_odeplot(-t*y,[t,y])
        
        '''

     def interactive_plotode(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for interactive_plotode:
        interactive_plotode(Expr,VectVar)
        Draws (in DispG) a solution for each point t0+i*y0 clicked with the mouse (Esc=halt).
        See also: 1/ odeplot 2/ plotfield 3/ odesolve 4/ desolve 
        Ex1:interactive_plotode(sin(t*y),[t,y])
        Ex2:interactive_plotode(-t*y,[t,y])
        
        '''

     def interp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for interp:
        interp(Lst(colors)||Seq(Image(A),Image(B)||Color(c))||Seq(Lst(x0),Lst(y0),Lst(x))||Seq(Lst(x),Lst(y)))
        Interpolates between colors or two images or image and color, or computes numerical spline interpolation, or computes the Lagrange polynomial.
        See also: 1/ lagrange 
        Ex1:interp([blue,red,yellow],20)
        Ex2:interp(red,blue,0.5)
        Ex3: listplot(interp([0,1.2,3.7,4.5,6.2,8.1],[-0.1,0.2,0.5,0.3,0.1,0.0],[1,2,3,4,5,6,7,8]))
        
        '''

     def interval(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for interval:
        interval(Opt)
        Option of the convert or convertir command.
        See also: 1/ interval 
        Ex1: convert(sqrt(2),interval)
        Ex2: convert(sqrt(2),interval,20)
        Ex3: convert(sqrt(2)*sin(2)+sqrt(2)*cos(2),interval,20)
        
        '''

     def interval2center(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for interval2center:
        interval2center(Interval or Real)
        Returns the center of the interval or the object.
        See also: 1/ center2interval 
        Ex1:interval2center(2..5)
        Ex2:interval2center(3)
        
        '''

     def interval_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for interval_graph:
        interval_graph(Seq||Lst(a..b,c..d,...))
        Returns an interval graph with respect to the intervals a..b, c..d, ... on the real line. It has one vertex per interval and two vertices are connected iff the corresponding intervals intersect.
        See also: 1/ graph 2/ kneser_graph 
        Ex1:interval_graph([0..8,1..pi,exp(1)..20,7..18,11..14,17..24,23..25])
        
        '''

     def inv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inv:
        inv(Expr||Mtrx||Image||Audio)
        Returns the inverse of an expression or matrix or returns a negative of an image object or inverts channels in an audio clip.
        See also: 1/ Inv 
        Ex1:inv(9/5)
        Ex2:inv([[1,2],[3,4]])
        
        '''

     def inverse(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inverse:
        inverse(Expr||Mtrx||Image||Audio)
        Returns the inverse of an expression or matrix or returns a negative of an image object or inverts channels in an audio clip.
        See also: 1/ Inv 
        Ex1:inverse(9/5)
        Ex2:inverse([[1,2],[3,4]])
        
        '''

     def inversion(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for inversion:
        inversion(Pnt(C),Real(k),Pnt(A))
        inversion(C,k,A)=point A1 such that A1 is on line(C,A) and algebraic mesure of (CA1*CA)=k.
        See also: 1/ homothety 
        Ex1:inversion(i,1/2,1+i)
        Ex2:inversion([1,1,1],-1/2,point(-1,-1,-1))
        Ex3: inver:=inversion(i,1/2);inver(i)
        Ex4: inver:=inversion([1,1,1],-1/2);inver(point(-1,-1,-1))
        
        '''

     def invisible_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for invisible_point:
        invisible_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def invlaplace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for invlaplace:
        invlaplace(Expr,[Var],[IlapVar])
        Inverse Laplace transform of a rational fraction.
        See also: 1/ laplace 2/ ztrans 3/ invztrans 4/ Heaviside 
        Ex1:invlaplace(1/(x^2+1)^2)
        Ex2:invlaplace(s/(s^4-1),s,x)
        Ex3:invlaplace(exp(-s)/s,s,x)
        
        '''

     def invztrans(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for invztrans:
        invztrans(Expr,[Var],[InvZtransVar])
        Inverse z transform of a rational fraction.
        See also: 1/ ztrans 2/ laplace 3/ invlaplace 
        Ex1:invztrans(1/(x^2+1)^2)
        Ex2:invztrans(z/(z^4-1),z,n)
        
        '''

     def iquo(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for iquo:
        iquo(Intg(a),Intg(b))
        Euclidean quotient of 2 integers.
        See also: 1/ irem 2/ smod 3/ quo 
        Ex1:iquo(125,15)
        Ex2:iquo(125,41)
        Ex3:iquo(-7,3)
        Ex4:iquo(25+12*i,5+7*i)
        
        '''

     def iquorem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for iquorem:
        iquorem(Intg(a),Intg(b))
        Euclidean quotient and remainder of 2 integers.
        See also: 1/ irem 2/ iquo 3/ quorem 
        Ex1:iquorem(125,15)
        Ex2:iquorem(125,41)
        Ex3:iquorem(25+12*i,5+7*i)
        
        '''

     def iratrecon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for iratrecon:
        iratrecon(Expr(Xpr),Intg(n))
        Returns the fraction a/b such as b*Xpr=a mod n, -sqrt(n)/2<a<=sqrt(n)/2 and 0<=b<sqrt(n)/2.
        See also: 1/ mod 2/ smod 
        Ex1:iratrecon(41,121)
        
        '''

     def irem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for irem:
        irem(Intg(a),Intg(b))
        Euclidean remainder of 2 integers.
        See also: 1/ iquo 2/ smod 3/ rem 4/ mod 
        Ex1:irem(125,15)
        Ex2:irem(125,41)
        Ex3:irem(-7,3)
        Ex4:irem(25+12*i,5+7*i)
        
        '''

     def isPrime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isPrime:
        isPrime(Intg(a))
        Primality testing (=true or false).
        See also: 1/ prevprime 2/ nextprime 3/ is_prime 4/ is_pseudoprime 
        Ex1:isPrime(1999)
        Ex2:isPrime(9856989898997)
        Ex3:isPrime(9856989898997789789)
        
        '''

     def is_acyclic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_acyclic:
        is_acyclic(Graph(G))
        Returns true iff a digraph G contains no directed cycles.
        See also: 1/ topologic_sort 2/ topological_sort 
        Ex1:is_acyclic(digraph(%{[c,a],[c,b],[c,d],[a,d],[b,d],[a,b]%}))
        
        '''

     def is_arborescence(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_arborescence:
        is_arborescence(Graph(G))
        Returns true iff a directed graph G is an arborescence.
        See also: 1/ is_acyclic 2/ is_forest 3/ is_tree 
        Ex1:is_arborescence(digraph(%{[1,2],[1,3]%}))
        Ex2:is_arborescence(digraph(%{[1,2],[2,3],[3,1]%}))
        
        '''

     def is_biconnected(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_biconnected:
        is_biconnected(Graph(G))
        Returns true iff G is biconnected.
        See also: 1/ biconnected_components 2/ is_connected 3/ is_triconnected 
        Ex1:is_biconnected(path_graph(5))
        Ex2:is_biconnected(cycle_graph(5))
        Ex3:is_biconnected(graph("petersen"))
        
        '''

     def is_bipartite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_bipartite:
        is_bipartite(Graph(G),[Var(P)])
        Returns true iff G is a bipartite graph [and assigns to P the corresponding vertex partition].
        See also: 1/ random_bipartite_graph 2/ draw_graph 
        Ex1:is_bipartite(graph("desargues"))
        
        '''

     def is_clique(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_clique:
        is_clique(Graph(G))
        Returns true iff an undirected graph G is complete.
        See also: 1/ clique_number 2/ induced_subgraph 3/ maximum_clique 
        Ex1:is_clique(complete_graph(3))
        
        '''

     def is_collinear(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_collinear:
        is_collinear(LstPnt)
        Returns 1 if the points are aligned, 2 if the points are the same and 0 otherwise.
        See also: 1/ is_concyclic 
        Ex1:is_collinear(0,i,1+i,2*i)
        Ex2:is_collinear(point(0),point(1+i),point(2,2),point(-1-i))
        Ex3:is_collinear(point(0,0,0),point(1,1,0),point(2,2,0),point(-1,-1,1))
        
        '''

     def is_concyclic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_concyclic:
        is_concyclic(LstPnt)
        Returns 1 if the points are on a circle and 0 otherwise.
        See also: 1/ is_collinear 
        Ex1:is_concyclic(0,i,1+i,1,1/2+i*(1/2+sqrt(2)/2))
        Ex2:is_concyclic(1,-1,i,-i,1+i,-1-i)
        
        '''

     def is_conjugate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_conjugate:
        is_conjugate(Crcle||Line,Pnt||Line,Pnt||Line,[Pnt||Line])
        Returns 1 if the 3 (resp 4) arguments are conjugate with repect to the circle (resp 2 lines) and 0 otherwise.
        See also: 1/ harmonic_conjugate 2/ pole 3/ polar 
        Ex1:is_conjugate(circle(0,1+i),point(1-i),point(3+i))
        Ex2:is_conjugate(circle(0,1),point((1+i)/2),line(1+i,2))
        Ex3:is_conjugate(circle(0,1),line(1+i,2),point((1+i)/2))
        Ex4:is_conjugate(circle(0,1),line(1+i,2),line((1+i)/2,0))
        Ex5:is_conjugate(point(1+i),point(3+i),point(i),point(3/2+i))
        Ex6:is_conjugate(line(0,1+i),line(2,3+i),line(3,4+i),line(3/2,5/2+i))
        Ex7:is_conjugate(line(0,1+i),line(0,3+i),line(0,i),line(0,3/2+i))
        Ex8:is_conjugate(line(0,1+i),line(0,3+i),line(0,i),point(3/2+i))
        Ex9:is_conjugate(line(0,1+i),line(0,3+i),point(3/2+i),line(0,i))
        Ex10:is_conjugate(line(0,1+i),line(0,3+i),point(i),point(3/2+i))
        
        '''

     def is_connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_connected:
        is_connected(Graph(G))
        Returns true iff G is connected.
        See also: 1/ connected_components 2/ is_biconnected 3/ is_triconnected 
        Ex1:is_connected(path_graph(5))
        Ex2:is_connected(cycle_graph(5))
        Ex3:is_connected(graph_complement(complete_graph(3,4)))
        
        '''

     def is_coplanar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_coplanar:
        is_coplanar(Pnt,Pnt,Pnt,Pnt)
        Test if 4 points are in the same plane.
        Ex1:is_coplanar([0,0,0],[1,2,-3],[1,1,-2],[2,1,-3])
        
        '''

     def is_cospherical(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_cospherical:
        is_cospherical(Pnt,Pnt,Pnt,Pnt)
        Test if 5 points are on the same sphere.
        Ex1:is_cospherical([-1,0,0],[1,0,0],[0,1,0],[0,-1,0],[0,0,1])
        
        '''

     def is_cut_set(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_cut_set:
        is_cut_set(Graph(G),Lst(E))
        Returns true iff removing edges in the list E from G increases the number of connected components of G.
        See also: 1/ connected_components 2/ delete_edge 
        Ex1:is_cut_set(graph(trail(1,2,3,4,5,6,4,1,3)),[[1,4],[3,4]])
        
        '''

     def is_cycle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_cycle:
        is_cycle(Lst)
        Returns 1 if the argument is a cycle and 0 otherwise.
        See also: 1/ is_permu 2/ cycle2perm 3/ cycles2permu 
        Ex1:is_cycle([1,0,5])
        Ex2:is_cycle([1,0,5,1])
        
        '''

     def is_directed(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_directed:
        is_directed(Graph(G))
        Returns true iff G is a digraph.
        See also: 1/ is_weighted 2/ digraph 3/ make_directed 
        Ex1:is_directed(digraph(3))
        
        '''

     def is_element(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_element:
        is_element(Pnt,GeoObj)
        Returns 1 if the point is on the geometric object and 0 otherwise.
        See also: 1/ element 2/ member 3/ contains 
        Ex1:is_element(point(i),square(0,1))
        Ex2:is_element(point(i),circle(point(0),point(2)))
        
        '''

     def is_equilateral(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_equilateral:
        is_equilateral(Pnt||Cplx,Pnt||Cplx,Pnt||Cplx)
        Returns 1 if the 3 points (or the object) form an equilateral triangle and 0 otherwise.
        See also: 1/ is_isosceles 2/ is_rectangle 
        Ex1:is_equilateral(0,2,1+i*sqrt(3))
        Ex2:is_equilateral(point(0),point(1+i),point(2,2))
        Ex3:is_equilateral(triangle(0,2,1+i*sqrt(3)))
        
        '''

     def is_eulerian(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_eulerian:
        is_eulerian(Graph(G),[Var(T)])
        Returns true iff G is Eulerian [and writes the corresponding Eulerian trail to T].
        See also: 1/ path_graph 2/ trail 
        Ex1:is_eulerian(complete_graph(4))
        Ex2:is_eulerian(complete_graph(5))
        Ex3:is_eulerian(graph(trail(1,2,3,1,4,3,5,4)),T)
        Ex4:is_eulerian(digraph(%{[1,4],[1,3],[2,1],[3,2],[4,5],[5,1]%}))
        
        '''

     def is_forest(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_forest:
        is_forest(Graph(G))
        Returns true iff G is a forest (disjoint union of trees).
        See also: 1/ is_tree 
        Ex1:is_forest(graph(trail(1,2,3,4),trail(5,2,6,7),trail(8,9,10)))
        
        '''

     def is_graphic_sequence(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_graphic_sequence:
        is_graphic_sequence(Lst(L))
        Returns true iff there exists a graph with degree sequence equal to L.
        See also: 1/ degree_sequence 2/ sequence_graph 
        Ex1:is_graphic_sequence([3,2,4,2,3,4,5,7])
        
        '''

     def is_hamiltonian(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_hamiltonian:
        is_hamiltonian(Graph(G),[Var(hc)])
        Returns true iff G is a Hamiltonian graph [and assigns a Hamiltonian circuit to an unassigned identifier hc].
        See also: 1/ traveling_salesman 
        Ex1:is_hamiltonian(graph("petersen"))
        Ex2:is_hamiltonian(hypercube_graph(5),C)
        Ex3:is_hamiltonian(digraph(%{[1,2],[1,3],[2,3],[2,4],[3,2],[3,4],[4,1]%}))
        
        '''

     def is_harmonic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_harmonic:
        is_harmonic(Pnt or Cplx,Pnt or Cplx,Pnt or Cplx,Pnt or Cplx)
        Returns 1 if the 4 points are in a harmonic division and 0 otherwise.
        See also: 1/ is_conjugate 
        Ex1:is_harmonic(0,2,3/2,3)
        Ex2:is_harmonic(0,1+i,1,i)
        
        '''

     def is_harmonic_circle_bundle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_harmonic_circle_bundle:
        is_harmonic_circle_bundle(Lst(Crcle))
        Returns 1 if the circles have a common point, 2 if they have the same center, 3 if they are the same and 0 otherwise.
        See also: 1/ is_harmonic_line_bundle 
        Ex1:is_harmonic_circle_bundle([circle(0,i),circle(4,i),circle(0,point(1/2))])
        Ex2:is_harmonic_circle_bundle([circle(0,1+i),circle(2,1+i),circle(1+i,point(1-i))])
        
        '''

     def is_harmonic_line_bundle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_harmonic_line_bundle:
        is_harmonic_line_bundle(Lst(Line))
        Returns 1 if the lines have a common point, 2 if they are parallels, 3 if they are the same and 0 otherwise.
        See also: 1/ is_harmonic_circle_bundle 
        Ex1:is_harmonic_line_bundle([line(0,1+i),line(0,2+i),line(0,1),line(0,3+i)])
        Ex2:is_harmonic_line_bundle([line(0,1+i),line(2,3+i),line(3,4+i),line(-1,i)])
        
        '''

     def is_inside(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_inside:
        is_inside(Pnt,Polygon or Circle)
        Checks whether a point is inside a polygon or a circle.
        See also: 1/ is_element 
        Ex1:is_inside(point(0),circle(-1,1))
        Ex2:is_inside(point(1-i),triangle([1,2-i,3+i]))
        
        '''

     def is_integer_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_integer_graph:
        is_integer_graph(Graph(G))
        Returns true iff the spectrum of G consists only of integers.
        See also: 1/ graph_spectrum 
        Ex1:is_integer_graph(graph("levi"))
        
        '''

     def is_irreducible(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_irreducible:
        is_irreducible(Polynomial)
        Polynomial irreducibility test
        See also: 1/ factor 2/ factors 
        Ex1:is_irreducible(x^2+1)
        Ex2:is_irreducible(x^3+x+1 mod 7)
        Ex3:is_irreducible(x^3+3x+1 mod 7)
        
        '''

     def is_isomorphic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_isomorphic:
        is_isomorphic(Graph(G1),Graph(G2),[Var(I)])
        Returns true iff G1 and G2 are isomorphic graphs. If an unassigned identifier 'I' is given, the isomorphism is assigned to it as a permutation.
        See also: 1/ isomorphic_copy 2/ permute_vertices 
        Ex1: G1:=graph("petersen"); G2:=kneser_graph(5,2); is_isomorphic(G1,G2,I)
        
        '''

     def is_isosceles(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_isosceles:
        is_isosceles(Pnt or Cplx,Pnt or Cplx,Pnt or Cplx)
        Returns 1, 2 or 3 if the 3 points (or the object) form an isosceles triangle with equal sides at vertex 1, 2, or 3, returns 4 if the 3 points (or the object) form an equilateral triangle and 0 otherwise.
        See also: 1/ is_equilateral 2/ is_right_triangle 
        Ex1:is_isosceles(0,i,1+i)
        Ex2:is_isosceles(point(0),point(1+i),point(2,2))
        Ex3:is_isosceles(triangle(0,i,1+i))
        
        '''

     def is_network(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_network:
        is_network(Graph(G),[Vrtx(s),Vrtx(t)])
        Returns true iff G is a network with the source s and sink t. If s and t are not provided, the output is a sequence of two sets of vertices: sources and sinks.
        See also: 1/ random_network 2/ maxflow 
        Ex1:is_network(digraph(trail(1,2,3,4,5,6,4,7)))
        Ex2:is_network(digraph(trail(1,2,3,4,5,6,4,7)),1,7)
        Ex3:is_network(digraph(trail(1,2,3,4,5,6,4,1)))
        
        '''

     def is_orthogonal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_orthogonal:
        is_orthogonal(Line||Crcle,Line||Crcle)
        Returns 1 if the 2 circles are orthogonal (orthogonal tangents at a point of intersection) or if the 2 lines are orthogonal and 0 otherwise.
        See also: 1/ is_parallel 2/ is_perpendicular 
        Ex1:is_orthogonal(line(0,1+i),line(1,i))
        Ex2:is_orthogonal(circle(0,1+i),circle(2,1+i))
        Ex3:is_orthogonal(line([2,3,-2],[-1,-1,-1]),line([1,0,0],[1,2,8]))
        
        '''

     def is_parallel(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_parallel:
        is_parallel(Line or Plan ,Line or Plan)
        Returns 1 if 2 lines are parallel and 0 otherwise.
        See also: 1/ is_perpendicular 
        Ex1:is_parallel(line(0,i),line(1,1+i))
        Ex2:is_parallel(line([2,3,-2],[-1,-1,-1]),plane([-1,-1,-1],[1,2,-3],[0,0,0]))
        Ex3:is_parallel(line([0,0,0],[-1,-1,-1]),line([2,3,-2],[-1,-1,-1]))
        
        '''

     def is_parallelogram(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_parallelogram:
        is_parallelogram(Pnt or Cplx,Pnt or Cplx,Pnt or Cplx,Pnt or Cplx)
        Returns 1,2,3 or 4 if the 4 points (or the object) form a parallelogram, (2 for a rhombus, 3 for a rectangle, 4 for a square) and 0 otherwise.
        See also: 1/ est_rectangle 2/ is_square 3/ is_rhombus 
        Ex1:is_parallelogram(0,i,1+i,1)
        Ex2:is_parallelogram(1,-1,i,-i)
        Ex3:is_parallelogram(sommets(parallelogram(1,-1,-i,C)))
        
        '''

     def is_permu(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_permu:
        is_permu(Lst)
        Returns 1 if the argument is a permutation and 0 otherwise.
        See also: 1/ is_cycle 2/ permu2cycles 
        Ex1:is_permu([4,2,3,1])
        Ex2:is_permu([4,2,3,1,0])
        
        '''

     def is_perpendicular(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_perpendicular:
        is_perpendicular(Line or Plan,Line or Plan)
        Returns 1 if 2 lines are perpendicular.
        See also: 1/ is_parallel 2/ is_orthogonal 
        Ex1:is_perpendicular(line(0,i),line(1,1+i))
        Ex2:is_perpendicular(line([2,3,-2],[-1,-1,-1]),line([1,0,0],[1,2,8]))
        Ex3:is_perpendicular(plane([0,0,0],[1,2,-3],[1,1,-2]),plane([-1,-1,-1],[1,2,-3],[0,0,0]))
        Ex4:is_perpendicular(line([2,3,-2],[-1,-1,-1]),plane([0,0,0],[1,2,-3],[1,1,-2]))
        
        '''

     def is_planar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_planar:
        is_planar(Graph(G))
        Returns true iff G is planar.
        See also: 1/ draw_graph 2/ random_planar 
        Ex1:is_planar(complete_graph(4))
        Ex2:is_planar(complete_graph(5))
        
        '''

     def is_prime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_prime:
        is_prime(Intg,[1 || 2])
        Mixed or "p-1" Pocklington [1] or APRCL test [2] (returns the coefficients for a proof of primality, 1 or 0).
        See also: 1/ prevprime 2/ nextprime 3/ is_pseudoprime 4/ isprime 
        Ex1:is_prime(1999)
        Ex2:is_prime(9856989898997)
        Ex3:is_prime(9856989898997789789)
        Ex4:is_prime(9856989898997789789,1)
        
        '''

     def is_pseudoprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_pseudoprime:
        is_pseudoprime(Intg)
        Pseudo-prime test (0 not prime, 1 probably prime, 2 prime).
        See also: 1/ prevprime 2/ nextprime 3/ is_prime 
        Ex1:is_pseudoprime(1999)
        Ex2:is_pseudoprime(9856989898997)
        Ex3:is_pseudoprime(9856989898997789789)
        
        '''

     def is_reachable(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_reachable:
        is_reachable(Graph(G),Vrtx(u),Vrtx(v))
        Returns true iff there exists a path from u to v in a (di)graph G.
        See also: 1/ reachable 2/ shortest_path 
        Ex1: G:=graph_complement(complete_graph(3,4)):;is_reachable(G,3,2)
        Ex2: G:=graph_complement(complete_graph(3,4)):;is_reachable(G,3,5)
        
        '''

     def is_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_rectangle:
        is_rectangle(Pnt||Cplx,Pnt||Cplx,Pnt||Cplx,[Pnt||Cplx])
        Returns 1, 2 or 3 if the 3 points (or the object) form a right triangle with right angle at vertex 1, 2 or 3 and 0 otherwise [or 1 if the 4 points (or the object) form a rectangle, 2 if the 4 points (or the object) form a square and 0 otherwise].
        See also: 1/ is_equilateral 2/ is_isosceles 3/ is_parallelogram 4/ is_rhombus 5/ is_square 
        Ex1:is_rectangle(0,i,1+i)
        Ex2:is_rectangle(point(0),point(1+i),point(2,2))
        Ex3:is_rectangle(triangle(0,i,1+i))
        Ex4:is_rectangle(point(0),point(2,2),point(1,3),point(-1,1))
        Ex5:is_rectangle(rectangle(point(0),point(2,2),1/2))
        Ex6:is_rectangle(sommets(rectangle(point(0),point(2,2),1/2)))
        
        '''

     def is_regular(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_regular:
        is_regular(Graph(G))
        Returns true iff the max and min degrees of G are equal (if G is directed then out- and in-degrees must be pairwise equal for each vertex of G).
        See also: 1/ degree_sequence 2/ maximum_degree 3/ minimum_degree 4/ random_regular_graph 5/ vertex_degree 
        Ex1:is_regular(complete_graph(5))
        
        '''

     def is_rhombus(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_rhombus:
        is_rhombus(Pnt or Cplx,Pnt or Cplx,Pnt or Cplx,Pnt or Cplx)
        Returns 1 or 2 if the 4 points (or the object) form a rhombus (2 for a square) and 0 otherwise.
        See also: 1/ est_rectangle 2/ is_parallelogram 3/ is_square 
        Ex1:is_rhombus(0,i,1+i,1)
        Ex2:is_rhombus(1,-1,i,-i)
        Ex3:is_rhombus(sommets(rhombus(1,-1,pi/4,C,D)))
        
        '''

     def is_split_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_split_graph:
        is_split_graph(Graph(G),[part])
        Returns true iff the vertex set of G can be partitioned into a clique and an independent set. These are also returned if the keyword 'part' is provided.
        See also: 1/ degree_sequence 2/ maximum_clique 3/ maximum_independent_set 
        Ex1:is_split_graph(graph(5,%{[0,1],[0,2],[1,2],[1,3],[2,3],[3,4]%}),part)
        
        '''

     def is_square(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_square:
        is_square(Pnt,Pnt,Pnt,Pnt)
        Returns 1 if the 4 points form a square and 0 otherwise.
        See also: 1/ est_rectangle 2/ is_parallelogram 3/ is_rhombus 
        Ex1:is_square(0,i,1+i,1)
        Ex2:is_square(1,-1,i,-i)
        Ex3:is_square(sommets(square(0,i,C,D)))
        
        '''

     def is_strongly_connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_strongly_connected:
        is_strongly_connected(Graph(G))
        Returns true iff a digraph G is strongly connected.
        See also: 1/ connected_components 2/ is_connected 3/ strongly_connected_components 
        Ex1:is_strongly_connected(digraph([1,2,3],%{[1,2],[1,3],[2,3],[3,2]%}))
        
        '''

     def is_strongly_regular(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_strongly_regular:
        is_strongly_regular(Graph(G),[Var(srg)])
        Returns true iff G is strongly regular and optionally outputs srg=[k,l,m] where k is the vertex degree and l resp. m is the number of common neighbors for adjacent resp. non-adjacent vertices.
        See also: 1/ is_regular 2/ adjacency_matrix 3/ seidel_spectrum 
        Ex1:is_strongly_regular(graph("clebsch"))
        Ex2:is_strongly_regular(graph("shrikhande"),s); s
        
        '''

     def is_subgraph_isomorphic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_subgraph_isomorphic:
        is_subgraph_isomorphic(Graph(G1),Graph(G2),[opts])
        Returns true iff G1 is isomorphic to a subgraph of G2.
        See also: 1/ is_isomorphic 2/ subgraph 
        Ex1:is_subgraph_isomorphic(cycle_graph(5),flower_snark(5))
        
        '''

     def is_tournament(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_tournament:
        is_tournament(Graph(G))
        Returns true iff G is a tournament.
        See also: 1/ has_edge 2/ random_tournament 
        Ex1:is_tournament(digraph(%{[1,2],[2,3],[3,1]%}))
        
        '''

     def is_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_tree:
        is_tree(Graph(G))
        Returns true iff G is a tree.
        See also: 1/ is_forest 2/ random_tree 3/ tree_height 
        Ex1:is_tree(random_tree(15))
        Ex2:is_tree(path_graph(4))
        Ex3:is_tree(cycle_graph(5))
        
        '''

     def is_triconnected(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_triconnected:
        is_triconnected(Graph(G))
        Returns true iff G is triconnected.
        See also: 1/ is_connected 2/ is_biconnected 
        Ex1:is_triconnected(graph("soccerball"))
        Ex2:is_triconnected(graph("petersen"))
        Ex3:is_triconnected(cycle_graph(5))
        
        '''

     def is_two_edge_connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_two_edge_connected:
        is_two_edge_connected(Graph(G))
        Returns true iff an undirected graph G contains no bridges.
        See also: 1/ two_edge_connected_components 2/ edge_connectivity 
        Ex1:is_two_edge_connected(cycle_graph(4))
        Ex2:is_two_edge_connected(path_graph(4))
        
        '''

     def is_vertex_colorable(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_vertex_colorable:
        is_vertex_colorable(Graph(G),Intg(k),[Var(col)])
        Returns true iff the vertices of G can be colored by using at most k colors. If true is returned and an identifier col is given, the colors of the vertices are stored there.
        See also: 1/ greedy_color 2/ chromatic_number 
        Ex1:is_vertex_colorable(graph("petersen"),2)
        Ex2:is_vertex_colorable(graph("petersen"),3,cols)
        
        '''

     def is_weighted(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for is_weighted:
        is_weighted(Graph(G))
        Returns true iff G is weighted.
        See also: 1/ get_edge_weight 2/ make_weighted 3/ set_edge_weight 4/ weight_matrix 
        Ex1:is_weighted(graph(%{[a,b],[b,c]%})
        Ex2:is_weighted(graph(%{[[a,b],2],[[b,c],3]%})
        
        '''

     def isinf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isinf:
        isinf(Expr)
        Return true if the argument is an infinity, else return false.
        See also: 1/ infinity 2/ inf 
        
        '''

     def ismith(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ismith:
        ismith(Mtrx(A))
        Smith normal form of a matrix with coefficients in ℤ : returns U,B,V such that U and V are invertible in ℤ, B is diagonal, B[j,j] divides B[j+1,j+1] and B=U*A*V.
        See also: 1/ ihermite 2/ smith 
        Ex1:ismith([[9,-36,30],[-36,192,-180],[30,-180,180]])
        Ex2:ismith([[1,2,3],[4,5,6],[7,8,9]])
        
        '''

     def isnan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isnan:
        isnan(Expr)
        Return true if the argument is undefined, else return false.
        See also: 1/ undef 
        
        '''

     def isobarycenter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isobarycenter:
        isobarycenter((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        isobarycenter(A,B,C,...) draws the isobarycenter of the n points A,B,C,...
        See also: 1/ barycenter 2/ midpoint 
        Ex1:isobarycenter(-1,1-i,i)
        
        '''

     def isolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isolve:
        isolve(Eqn||List(Eqn),[Intg(n)||(Idnt(Z1),Idnt(Z2),...)])
        Solve diophantine equation.
        See also: 1/ solve 2/ rsolve 
        Ex1:isolve(4x-3y=7)
        Ex2:isolve([x+y-z=4,x-2y+3z=3],m)
        Ex3:isolve(x^2-23y^2=1,n)
        Ex4:isolve(x^2-23y^2=1,seq=false)
        Ex5:isolve(x^2+11y^2-3z^2=0,A,B,C)
        Ex6:isolve(x^2-3x*y+y^2-x=2,n)
        
        '''

     def isom(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isom:
        isom(Mtrx)
        Finds elements of a 2-d or 3-d isometry.
        See also: 1/ mkisom 
        Ex1:isom([[0,1],[1,0]])
        
        '''

     def isomorphic_copy(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isomorphic_copy:
        isomorphic_copy(Graph(G),Permu(sigma))
        Returns a copy of G with the neighborhood structure of each vertex reordered according to sigma.
        See also: 1/ graph_vertices 2/ permute_vertices 3/ relabel_vertices 
        Ex1:isomorphic_copy(cycle_graph(5),randperm(5))
        
        '''

     def isopolygon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isopolygon:
        isopolygon(Pnt,Pnt,[Pnt],Intg(n))
        Draws a regular polygon having abs(n) vertices, given by 2 vertices (or 2 vertices and 1 point of the plane) if n<0 by its center and 1 vertex (or its center, 1 vertex and 1 point of the plane) if n<0.
        See also: 1/ polygon 2/ hexagon 
        Ex1:isopolygon(0,1,5)
        Ex2:isopolygon(0,1,-5)
        Ex3:isopolygon(point(0,0,0),point(3,3,3),point(0,0,3),5)
        Ex4:isopolygon(point(0,0,0),point(3,3,3),point(0,0,3),-5)
        
        '''

     def isosceles_triangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isosceles_triangle:
        isosceles_triangle((Pnt(A) or Cplx),(Pnt(B) or Cplx),(Angle(t) or Pnt(P) or Lst(P,t)),[Var(C)])
        Draws the isosceles triangle ABC AB=AC and angle(AB,AC)=t (or in the plane ABP angle(AB,AC)=angle(AB,AP) or angle(AB,AC)=t).
        See also: 1/ triangle 
        Ex1:isosceles_triangle(i,1,pi/4)
        Ex2:isosceles_triangle(1,i,pi/4,C)
        Ex3:isosceles_triangle(point(0,0,0),point(3,3,3),point(0,0,3))
        Ex4:isosceles_triangle(point(0,0,0),point(3,3,3),[point(0,0,3),pi/4],C)
        
        '''

     def isposdef(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isposdef:
        isposdef(Mtrx(A))
        Returns 1 if symmetric matrix A is positive definite and 0 otherwise.
        See also: 1/ cholesky 2/ ldl 
        Ex1:isposdef([[1,-1,2],[-1,4,3],[2,3,-5]])
        
        '''

     def isprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for isprime:
        isprime(Intg(a))
        Primality testing (=true or false).
        See also: 1/ prevprime 2/ nextprime 3/ is_prime 4/ is_pseudoprime 
        Ex1:isprime(1999)
        Ex2:isprime(9856989898997)
        Ex3:isprime(9856989898997789789)
        
        '''

     def istft(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for istft:
        istft(Mtrx(data))
        Inverse short-time Fourier transform.
        See also: 1/ stft 2/ ifft 
        Ex1: data:=ranv(2^15,normald(0,0.1)):;t:=stft(data):;d:=istft(t):;correlation(data,d)
        
        '''

     def ithprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ithprime:
        ithprime(Intg(n))
        Returns the n-th prime number less than 2*10^8.
        See also: 1/ nextprime 2/ prevprime 
        Ex1:ithprime(1229)
        Ex2:ithprime(1000)
        
        '''

     def jacobi_equation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for jacobi_equation:
        jacobi_equation(Expr(f),Var(x),Var(y),Expr(y0),Var(h),Real(a))
        Returns the Jacobi equation for stationary function y0(x) in a problem of minimizing the functional int(f(x,y,y'),x=a..b).
        See also: 1/ conjugate_equation 2/ euler_lagrange 
        Ex1:jacobi_equation(-1/2*y'(t)^2+y(t)^2/2,t,y,sin(t),h,0)
        
        '''

     def jacobi_linsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for jacobi_linsolve:
        jacobi_linsolve(Mtrx(A),Vect(b),Real(eps),[Int(maxiter)])
        Resolution of a linear system A*X=b by the iterative Jacobi method with eps as error margin and a number of iterations less than maxiter.
        See also: 1/ gauss_seidel_linsolve 2/ linsolve 
        Ex1: a:=[[100,2],[2,100]];jacobi_linsolve(a,[0,1],1e-12);
        Ex2: a:=[[100,2],[2,100]];jacobi_linsolve(table(a),[0,1],1e-12); 
        
        '''

     def jacobi_symbol(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for jacobi_symbol:
        jacobi_symbol(Intg,Intg)
        Jacobi symbol.
        See also: 1/ legendre_symbol 
        Ex1:jacobi_symbol(132,5)
        Ex2:jacobi_symbol(132,25)
        
        '''

     def johnson_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for johnson_graph:
        johnson_graph(Intg(n),Intg(k))
        Returns the Johnson graph J(n,k) with comb(n,k) vertices (n<=20).
        See also: 1/ kneser_graph 
        Ex1:johnson_graph(5,2)
        
        '''

     def join(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for join:
        join(Str(sep),Lst(strlst))
        Returns the string obtained by concatenating strings from a list after inserting a separator string between adjacent elements.
        See also: 1/ split 2/ concat 
        Ex1:join(" ",["This","is","a","phrase"])
        
        '''

     def jordan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for jordan:
        jordan(Mtrx)
        Returns the list made by the transition matrix and the Jordan form of a matrix.
        See also: 1/ egv 2/ egvl 3/ rat_jordan 
        Ex1:jordan([[0,2],[1,0]])
        Ex2:jordan([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex3:jordan([[1,1,-1,2,-1],[2,0,1,-4,-1],[0,1,1,1,1],[0,1,2,0,1],[0,0,-3,3,-1]])
        
        '''

     def katz_centrality(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for katz_centrality:
        katz_centrality(Graph(G),Real(alpha),[Vrtx(v)])
        Returns the Katz centrality of a vertex v in a graph G or the list of Katz centralities of vertices in G, where alpha is the attenuation factor.
        See also: 1/ degree_centrality 2/ betweenness_centrality 3/ closeness_centrality 4/ harmonic_centrality 5/ information_centrality 
        Ex1:katz_centrality(graph(6,%{[0,2],[0,5],[1,3],[1,5],[2,5],[3,4],[3,5],[4,5]%}),0.1)
        
        '''

     def kde(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kde:
        kde(Lst(L),[options])
        Estimates the probability density function from which the (presumably independent) samples in list L are drawn.
        See also: 1/ random_variable 2/ sample 
        Ex1:kde([1,2,3,2],bandwidth=1/4,exact)
        Ex2: X:=randvar(gammad,mean=5,stddev=2):;kernel_density(sample(X,500),bins=50)
        Ex3: Y:=randvar(normal,mean=5,stddev=1.5):;plot(kernel_density(sample(Y,1000),bins=50,piecewise),x=0..10)
        
        '''

     def keep_pivot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for keep_pivot:
        keep_pivot(Opt)
        Option of the rref command.
        See also: 1/ rref 
        Ex1: rref([[1,1,0,0,-a1],[0,1,1,0,-a2],[0,0,1,1,-a3],[1,0,0,1,-a4]],keep_pivot)
        
        '''

     def ker(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ker:
        ker(Mtrx)
        Kernel of a linear map with matrix M.
        See also: 1/ image 2/ rref 3/ Nullspace 
        Ex1:ker([[1,2],[3,6]])
        Ex2:ker([[1,2,3],[1,3,6],[2,5,9]])
        
        '''

     def kernel(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kernel:
        kernel(Mtrx)
        Kernel of a linear map with matrix M.
        See also: 1/ image 2/ rref 3/ Nullspace 
        Ex1:kernel([[1,2],[3,6]])
        Ex2:kernel([[1,2,3],[1,3,6],[2,5,9]])
        
        '''

     def kernel_density(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kernel_density:
        kernel_density(Lst(L),[options])
        Estimates the probability density function from which the (presumably independent) samples in list L are drawn.
        See also: 1/ random_variable 2/ sample 
        Ex1:kernel_density([1,2,3,2],bandwidth=1/4,exact)
        Ex2: X:=randvar(gammad,mean=5,stddev=2):;kernel_density(sample(X,500),bins=50)
        Ex3: Y:=randvar(normal,mean=5,stddev=1.5):;plot(kernel_density(sample(Y,1000),bins=50,piecewise),x=0..10)
        
        '''

     def kmeans(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kmeans:
        kmeans(Mtrx||Lst(data),[opts])
        Cluster the given Euclidean data by using k-means algorithm.
        See also: 1/ cluster 
        Ex1:kmeans([[1.1,1.5],[3.2,2.5],[1.5,0.9],[3.5,2.7],[0.8,1.1],[3.1,2.2]])
        
        '''

     def kneser_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kneser_graph:
        kneser_graph(Intg(n),Intg(k))
        Returns the Kneser graph K(n,k) with comb(n,k) vertices (n<=20).
        See also: 1/ odd_graph 2/ johnson_graph 
        Ex1:kneser_graph(5,2)
        
        '''

     def kolmogorovd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kolmogorovd:
        kolmogorovd(Real(x))
        Kolmogorov-Smirnov distribution, 1-2*sum((-1)^(k-1)*exp(-k^2*x^2),k,1,inf).
        Ex1:kolmogorovd(1.36)
        
        '''

     def kolmogorovt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kolmogorovt:
        kolmogorovt(Lst(l1),Lst(l2) || DistribLaw(s))
        Kolmogorov-Smirnov fitness test to a continuous distribution law, between 2 samples l1 l2 (unknown law) or between a sample l1 and a distribution law s.
        See also: 1/ chisquaret 2/ normalt 3/ studentt 
        Ex1:kolmogorovt(randvector(100,normald,0,1),randvector(100,normald,0,1))
        Ex2:kolmogorovt(randvector(100,normald,0,1),randvector(100,normald,3,1))
        Ex3:kolmogorovt(randvector(100,normald,0,1),normald(0,1))
        Ex4:kolmogorovt(randvector(100,normald,0,1),student(2))
        
        '''

     def kovacicsols(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kovacicsols:
        kovacicsols(Expr||Lst(eq),[Var(x),[Var(y)]])
        Solves a linear homogeneous second-order ODE eq for y(x) with rational coefficients in variable x.
        See also: 1/ desolve 
        Ex1:kovacicsols(y''=y*(1/x-3/16/x^2))
        Ex2:kovacicsols(y''-y*27/(36*(x-1)^2),x,y)
        Ex3:kovacicsols(x''+3*(t^2-t+1)/(16*(t-1)^2*t^2)*x,t,x)
        Ex4:kovacicsols(y''+y'=6y/x^2)
        Ex5:kovacicsols(y''+(19-x^2)*y=0,x,y)
        Ex6:kovacicsols((1+x^2)^2*y''+3y=0,x,y)
        Ex7:kovacicsols([48t*(t+1)*(5t-4),8*(25t+16)*(t-2),-(5t+68)],t)
        
        '''

     def kspaths(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for kspaths:
        kspaths(Graph(G),Vrtx(s),Vrtx(t),Intg(k))
        Returns a list of k shortest paths from s to t in the (weighted) (di)graph G.
        See also: 1/ dijkstra 2/ shortest_path 
        Ex1:kspaths(digraph(%{[["C","D"],3],[["C","E"],2],[["D","F"],4],[["E","D"],1],[["E","F"],2],[["E","G"],3],[["F","G"],2],[["F","H"],1],[["G","H"],2]%}),"C","H",5)
        Ex2:kspaths(graph("soccerball"),3,33,4)
        
        '''

     def l1norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for l1norm:
        l1norm(Vect)
        Returns the l1 norm of the vector=sum of the absolute values of its coordinates or matrix norm according to l1.
        See also: 1/ l2norm 2/ maxnorm 3/ matrix_norm 
        Ex1:l1norm(ou triple norme d'une matrice selon l1.)
        Ex2:l1norm([3,-4,2])
        Ex3:l1norm([[1,2,3],[3,-9,6],[4,5,6]])
        
        '''

     def l2norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for l2norm:
        l2norm(Vect or Mtrx)
        Returns the l2 norm of a vector = sqrt(x1^2+x2^2+...xn^2) or matrix norm induced by l2 norm.
        See also: 1/ maxnorm 2/ l1norm 
        Ex1:l2norm([1,2])
        Ex2:l2norm([1,2,3,-4])
        Ex3:l2norm([[1,2],[3,-4]])
        Ex4:l2norm([[1,2,3],[3,-9,6],[4,5,6]])
        
        '''

     def lagrange(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lagrange:
        lagrange((Lst_xk,Lst_yk)||Mtrx_2*n||(Lst_xk,Fnc(f)),[Var||[]||lagrange])
        Returns the polynomial of degree n-1 such that P(xk)=yk=f(x_k) k=0..n-1 or the list of divided differences if the last argument is lagrange.
        See also: 1/ spline 2/ interp 
        Ex1:lagrange([1,3,4],[0,1,2])
        Ex2:lagrange([1,3,4],[0,1,2],t)
        Ex3: f(x):=exp(-x); lagrange([1,3,4],f)
        Ex4:lagrange([[1,3,4],[0,1,2]])
        Ex5:lagrange([1,3,4],[0,1,2],[])
        Ex6: X:=[1,3,4]; divdiff:=lagrange(X,[0,1,2],lagrange); horner(divdiff,X,5);
        Ex7:lagrange([[1,3,4],[0,1,2]],y)
        Ex8:lagrange([-1,0,1],[1/e-1,0,e-1])
        Ex9: f(x):=exp(x)-1;lagrange([-1,0,1],f)
        Ex10:lagrange([0,1,2],[1,exp(1),exp(2)],lagrange)
        Ex11:lagrange([0,1,2],exp,lagrange)
        
        '''

     def laguerre(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for laguerre:
        laguerre(Intg(n))
        Returns the n-th Laguerre polynomial.
        See also: 1/ legendre 2/ hermite 
        Ex1:laguerre(4)
        
        '''

     def laplace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for laplace:
        laplace(Expr,[Var],[LapVar])
        Laplace transform.
        See also: 1/ invlaplace 2/ ztrans 3/ invztrans 4/ Heaviside 
        Ex1:laplace(exp(x)*sin(x))
        Ex2:laplace(sin(x)^2,x,s)
        Ex3:laplace(Heaviside(x-1),x,s)
        
        '''

     def laplacian(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for laplacian:
        laplacian(Expr(Xpr),LstVar)
        Returns the Laplacian of the expression Xpr with respect to the list of variables and laplacian(n) for integer n returns the matrix of size n of the discrete laplacian in dimension 1.
        See also: 1/  
        Ex1:laplacian(-2)
        Ex2:laplacian(exp(z)*cos(x*y),[x,y,z])
        Ex3:laplacian(3)
        Ex4:laplacian(3.0)
        
        '''

     def laplacian_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for laplacian_matrix:
        laplacian_matrix(Graph(G),[normal])
        Returns the Laplacian matrix L=D-A of an undirected graph G where D resp. A is the degree matrix resp. the adjacency matrix of G.
        See also: 1/ adjacency_matrix 2/ degree_sequence 3/ number_of_spanning_trees 
        Ex1:laplacian_matrix(graph(trail(1,2,3,4,5,2)))
        Ex2:laplacian_matrix(graph(trail(1,2,3,4,5,2)),normal)
        
        '''

     def latex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for latex:
        latex(Expr)
        Returns the evaluated expression written in latex.
        See also: 1/ mathml 
        Ex1:latex(1/2)
        Ex2:latex((x^4-1)/(x^2+3))
        
        '''

     def lcf_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lcf_graph:
        lcf_graph(Lst(J),[Intg(k)])
        Returns a graph constructed from the LCF notation J[^k] given the list of integers J [and a positive integer k, by default 1].
        See also: 1/ graph 
        Ex1:lcf_graph([-3,3],4)
        
        '''

     def lcm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lcm:
        lcm((Intg or Poly),(Intg or Poly))
        Returns the lowest common multiple of 2 polynomials of several variables or of 2 integers or of 2 rationals.
        See also: 1/ gcd 
        Ex1:lcm(6,4)
        Ex2:lcm(1251,123)
        Ex3:lcm(5/7,50/9)
        Ex4:lcm(x^2-2*x+1,x^3-1)
        Ex5:lcm(t^2-2*t+1,t^2+t-2)
        Ex6:lcm((x^2-1)*(y^2-1)*z^2,x^3*y^3*z+(-(y^3))*z+x^3*z-z)
        
        '''

     def lcoeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lcoeff:
        lcoeff(Poly||Lst)
        Returns the coefficient of the term of highest degree of a polynomial (l=leading).
        See also: 1/ tcoeff 
        Ex1:lcoeff(-2*x^3+x^2+7*x)
        Ex2:lcoeff([-2,1,7,0])
        
        '''

     def ldegree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ldegree:
        ldegree(Poly(P))
        Returns the valuation (degree of the term of lowest degree) of the polynomial P.
        See also: 1/ degree 2/ tcoeff 
        Ex1:ldegree(x^4+x^3)
        Ex2:ldegree([1,1,0,0,0])
        Ex3:ldegree(130,5)
        Ex4:ldegree(x^5+3*x^2)
        Ex5:ldegree([5,0,0,3,0,0])
        
        '''

     def ldl(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ldl:
        ldl(Mtrx(A),[opts])
        Returns the sequence p,L,D such that P*A*tran(P) = L*D*tran(L), where A is symmetric
        See also: 1/ lu 2/ inertia 
        Ex1:ldl(or Hermitian matrix.)
        Ex2:ldl([[1,-1,2],[-1,4,3],[2,3,-5]])
        Ex3:ldl([[1,-i,2],[i,4,3],[2,3,-5]],hermite)
        
        '''

     def learning_rate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for learning_rate:
        learning_rate(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def left(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for left:
        left(Equal(a=b) or Interval(a..b) or Str,Intg)
        Returns the left part of an equality, of an interval, of a list or of a string.
        See also: 1/ right 2/ mid 3/ tail 4/ head 
        Ex1:left(a=b)
        Ex2:left(x^2+1=5)
        Ex3:left(1..5)
        Ex4:left("abcdefg",3)
        
        '''

     def left_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for left_rectangle:
        left_rectangle(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def legend(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for legend:
        legend(Cplx or Lst,Str)
        legend(za,"here") (or legend([20,60],"here")) "here" is written at the point of affix za (or at the pixel position [20,60]) and legend=["m","s"] writes "m","s" as units on the axis.
        See also: 1/ labels 2/ angle 
        Ex1:legend(1+i,"Hello")
        Ex2:legend(point([0,2,3],"Hello")
        Ex3:legend(point(0,1),"Hello",vert)
        Ex4:legend(point(0,1,0),"Hello",vert)
        Ex5:legend(1+i,"Hello",quadrant4,red)
        Ex6:legend([30,20],"bonjour")
        Ex7: r:=evalf(sqrt(2));legend([30,20],string(r))
        Ex8: r:=evalf(sqrt(2));legend([30,20],r)
        Ex9: legende=["m","s"];point(1,1);
        Ex10: display(legend(1+i,"A"),red)
        Ex11: point(2+i,legend="2+i",display=quadrant2+red)
        Ex12: point([2,2*i],legend="1+i",display=quadrant2+red)
        Ex13: polygon(2,1,i,2*i,legend="1+i",display=quadrant2+red)
        
        '''

     def legendre(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for legendre:
        legendre(Intg(n))
        Returns the n-th Legendre polynomial.
        See also: 1/  
        Ex1:legendre(4)
        
        '''

     def legendre_symbol(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for legendre_symbol:
        legendre_symbol(Intg,Intg)
        Legendre symbol.
        See also: 1/ jacobi_symbol 
        Ex1:legendre_symbol(132,5)
        Ex2:legendre_symbol(132,25)
        
        '''

     def length(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for length:
        length(Lst||Str||Seq||Image||Audio)
        Returns the size of a list, a string, a sequence, an image object or an audio clip.
        See also: 1/ sizes 2/ dim 3/ degree 
        Ex1:length([1,2,3])
        Ex2:length("bonjour")
        Ex3:length(1,2,3)
        
        '''

     def levenshtein(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for levenshtein:
        levenshtein(Str(s1)||Lst(s1),Str(s2)||Lst(s2))
        Levenshtein distance between two vectors or strings.
        See also: 1/ hamming 
        Ex1:levenshtein("kitten","sitting")
        
        '''

     def lgcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lgcd:
        lgcd(Seq or Lst)
        Returns the greatest common divisor of a list of polynomials or of integers.
        See also: 1/ gcd 2/ lcm 3/ euler 4/ content 
        Ex1:lgcd([45,75,20,15])
        Ex2:lgcd([x^2-2*x+1,x^3-1,x-1])
        Ex3:lgcd(x^2-2*x+1,x^3-1,x-1)
        
        '''

     def lhs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lhs:
        lhs(Equal(a=b) or Interval(a..b) or Str,Intg)
        Returns the left part of an equality, of an interval, of a list or of a string.
        See also: 1/ right 2/ mid 3/ tail 4/ head 
        Ex1:lhs(a=b)
        Ex2:lhs(x^2+1=5)
        Ex3:lhs(1..5)
        Ex4:lhs("abcdefg",3)
        
        '''

     def ligne_chapeau_carre(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_chapeau_carre:
        ligne_chapeau_carre(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def ligne_chapeau_plat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_chapeau_plat:
        ligne_chapeau_plat(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def ligne_chapeau_rond(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_chapeau_rond:
        ligne_chapeau_rond(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def ligne_polygonale(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_polygonale:
        ligne_polygonale(Mtrx)
        Draws the polygons joining for j fixed and for k=0..nrows, the points (xk,yk) where xk=element row k column 0 and yk=element row k column j, after the xk are sorted (we obtain ncols-1 polygons).
        See also: 1/ scatterplot 2/ listplot 3/ polygonscatterplot 
        Ex1:ligne_polygonale([[1,2,3],[2,0,1],[-1,2,3]])
        
        '''

     def ligne_polygonale_pointee(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_polygonale_pointee:
        ligne_polygonale_pointee(Mtrx)
        Draws the points (xk,yk) and the polygons joining for j fixed and for k=0..nrows, the points (xk,yk) where xk=element row k column 0 et yk=element row k column j, after the xk are sorted (we obtain ncols-1 polygons).
        See also: 1/ scatterplot 2/ polygonplot 3/ listplot 
        Ex1:ligne_polygonale_pointee([[1,2,3],[2,0,1],[-1,2,3]])
        
        '''

     def ligne_tiret(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_tiret:
        ligne_tiret(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def ligne_tiret_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_tiret_point:
        ligne_tiret_point(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def ligne_tiret_pointpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_tiret_pointpoint:
        ligne_tiret_pointpoint(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def ligne_trait_plein(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ligne_trait_plein:
        ligne_trait_plein(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def limit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for limit:
        limit(Expr,Var,Val,[Dir(d)])
        Limit of an expression at a limit point (a or +/-infinity) (d=-1 for limit from below and +1 for limit from above).
        See also: 1/ series 2/ taylor 3/ taux_accroissement 
        Ex1:limit((n*tan(x)-tan(n*x))/(sin(n*x)-n*sin(x)),x,0)
        Ex2:limit(sin(x)/(x^2-3*x),x,0)
        Ex3:limit((2*x-1)/exp(1/(x-1)),x,+infinity)
        Ex4:limit(exp(1/x),x,0,1)
        Ex5:limit(exp(1/x),x,0,-1)
        Ex6:limit(taux_accroissement(x^n,1,1+h),h,0)
        
        '''

     def limite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for limite:
        limite(Expr,Var,Val,[Dir(d)])
        Limit of an expression at a limit point (a or +/-infinity) (d=-1 for limit from below and +1 for limit from above).
        See also: 1/ series 2/ taylor 3/ taux_accroissement 
        Ex1:limite((n*tan(x)-tan(n*x))/(sin(n*x)-n*sin(x)),x,0)
        Ex2:limite(sin(x)/(x^2-3*x),x,0)
        Ex3:limite((2*x-1)/exp(1/(x-1)),x,+infinity)
        Ex4:limite(exp(1/x),x,0,1)
        Ex5:limite(exp(1/x),x,0,-1)
        Ex6:limite(taux_accroissement(x^n,1,1+h),h,0)
        
        '''

     def lin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lin:
        lin(Expr)
        Linearization of exponentials.
        See also: 1/ tlin 2/ texpand 
        Ex1:lin(exp(x)^n)
        Ex2:lin((exp(x)^3+exp(x))^2)
        
        '''

     def linabs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linabs:
        linabs(Expr,[Var])
        Rewrites signum/Heaviside/piecewise subexpressions by using absolute values.
        See also: 1/ Heaviside 2/ sign 3/ piecewise 
        Ex1:linabs(x*sign(x))
        Ex2:linabs(sin(x)*Heaviside(x)-sin(x)*Heaviside(-x))
        Ex3:linabs(abs(abs(x-2)+x*abs(x+1)+1))
        
        '''

     def line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for line:
        line(Pnt||Cplx||Eq,[Pnt||slope||Var])
        line(A,B) (resp line(A,slope=m) or line(A,[1,m]) or line(a*x+b*y+c=0) or line(a*x+b*y+c*z+d=0,aa*x+bb*y+cc*z+dd=0) or line(A,u)) draws the line AB (resp the line going through A with slope m or with direction vector u or of equation the argument) in the plane or in the 3D space.
        See also: 1/ point 2/ plane 3/ slope 
        Ex1:line(i,1+i)
        Ex2:line(point(-i),point(1+i))
        Ex3:line(1+i,slope=2)
        Ex4:line([0,0,0],[1,1,1])
        Ex5:line(x+y=1)
        Ex6:line(x+y+z=0,x+y=0)
        Ex7:line([1+t,-1+t],t)
        Ex8:line([1+t,2-t,-1+3*t],t)
        Ex9:line(1-i,slope=slope(line(1,2i)))
        
        '''

     def line_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for line_graph:
        line_graph(Graph(G))
        Returns the line graph of an undirected graph G.
        See also: 1/ plane_dual 
        Ex1:line_graph(hypercube_graph(3))
        
        '''

     def line_inter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for line_inter:
        line_inter(Curve,Curve,[Pnt(A)||LstPnt(L)])
        Gives one of the points of intersection of 2 curves or surfaces (or the intersection near A or not in L).
        See also: 1/ intersect 2/ head 
        Ex1:line_inter(line(i,1-i),line(0,1))
        Ex2:line_inter(line(i,1-i),circle(0,1))
        Ex3:line_inter(line(i,1+2*i),circle(0,1),[point(i)])
        Ex4:line_inter(line(-1-i,1+2*i),circle(0,1),point(-1))
        Ex5:line_inter(circle(1,sqrt(2)),circle(0,1))
        Ex6:line_inter(plane(x=y),plane(y=z))
        Ex7:line_inter(line(x=y+1,y=2*z),plane(y=z))
        
        '''

     def line_paper(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for line_paper:
        line_paper(Real(ux),Real(t),[x=xmin..xmax,y=ymin..ymax])
        Draws in the rectangle [xmin..xmax]*[ymin..ymax], the lines x=n*ux at an angle of t!=0 from the horizontal.
        Ex1:line_paper(0.4,pi/3)
        Ex2:line_paper(0.4,pi/3,x=-1..4,y=-2..2)
        Ex3:line_paper(0.5,3*pi/4)
        
        '''

     def line_segments(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for line_segments:
        line_segments(Polygon or Polyedr(P))
        Returns the list of the line_segments (1 line=segment) of the polyhedron P.
        See also: 1/ polyhedron 
        Ex1:line_segments(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))
        Ex2:line_segments(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))[2]
        
        '''

     def linear_interpolate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linear_interpolate:
        linear_interpolate(Mtrx,xmin,xmax,xstep)
        Makes a regular sample from a polygonal line defined by a 2 row matrix.
        See also: 1/ polygonplot 
        Ex1:linear_interpolate([[1,2,6,9],[3,4,6,7]],1,9,1)
        
        '''

     def linear_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linear_regression:
        linear_regression(Lst||Mtrx(A),[Lst])
        Returns the coefficients a and b of y=a*x+b ; it is the best line approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ polynomial_regression 2/ power_regression 3/ logistic_regression 
        Ex1:linear_regression([[0.0,0.0],[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex2:linear_regression([0.0,1.0,2.0,3.0,4.0],[0.0,1.0,4.0,9.0,16.0])
        
        '''

     def linear_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linear_regression_plot:
        linear_regression_plot(Lst||Mtrx(A),[Lst])
        Returns the plot of y=a*x+b ;it is the best line approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ polynomial_regression_plot 2/ power_regression_plot 
        Ex1:linear_regression_plot([[0.0,0.0],[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex2:linear_regression_plot([0.0,1.0,2.0,3.0,4.0],[0.0,1.0,4.0,9.0,16.0])
        
        '''

     def lineariser(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lineariser:
        lineariser(Expr)
        Linearization of exponentials.
        See also: 1/ tlin 2/ texpand 
        Ex1:lineariser(exp(x)^n)
        Ex2:lineariser((exp(x)^3+exp(x))^2)
        
        '''

     def lineariser_trigo(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lineariser_trigo:
        lineariser_trigo(ExprTrig)
        Trigonometric linearization.
        See also: 1/ texpand 2/ lin 
        Ex1:lineariser_trigo(sin(x)^3)
        Ex2:lineariser_trigo(cos(x)*cos(y))
        
        '''

     def linfnorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linfnorm:
        linfnorm(Mtrx)
        Matrix norm induced by linfinity norm.
        See also: 1/ l1norm 2/ l2norm 3/ matrix_norm 4/ frobenius_norm 
        Ex1:linfnorm([[1,2,3],[3,-9,6],[4,5,6]])
        
        '''

     def linsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linsolve:
        linsolve(LstLinEq,LstVar)
        Linear equations system solver.
        See also: 1/ solve 2/ proot 3/ simult 4/ gaussjord 5/ pivot 6/ ref 7/ conjugate_gradient 
        Ex1:linsolve([x+y+z=1,x-y=2,2*x-z=3],[x,y,z])
        Ex2:linsolve([m*x+y=a,x+m*y=b],[x,y])
        Ex3:linsolve([x+y-z-1,x-y+1,x-y-z-1]%2,[x,y,z])
        Ex4:linsolve([[3,4],[1,2]],[0,1])
        Ex5: p,l,u:=lu([[3,4],[1,2]]); linsolve(p,l,u,[0,1]) 
        Ex6:linsolve([2*x+y+z=1,x+y+2*z=1,x+2*y+z=4],[x,y,z])
        Ex7:linsolve([[2,1,1],[1,1,2],[1,2,1]],[1,1,4])
        Ex8: p,l,u:=lu([[2,1,1],[1,1,2],[1,2,1]]);linsolve(p,l,u,[1,1,4])
        Ex9: a:=[[100,2],[2,100]];linsolve(evalf(a),[0,1]);
        
        '''

     def linspace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linspace:
        linspace(Real(a),Real(b),[Int(n)])
        linspace(a,b,n) creates a list of n elements at regular intervals between a and b, by default n=100 (compatibility with scilab).
        Ex1:linspace(0,1,11)
        
        '''

     def linstep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for linstep:
        linstep(Expr,[Var])
        Rewrites expressions as linear combinations of Heaviside functions.
        See also: 1/ Heaviside 
        Ex1:linstep(Heaviside(x-2)*Heaviside(3-x),x)
        Ex2:linstep(piecewise(x<-1,0,x<1,x+1,2-(x-1)^2),x)
        Ex3:linstep(abs(abs(x)-abs(x-1)))
        
        '''

     def lis_phrase(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lis_phrase:
        lis_phrase([Str],Var(Var))
        Instruction in a program so that a string expression can be input and stored in var.
        See also: 1/ input 
        Ex1:lis_phrase("nom?",N)
        
        '''

     def list2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for list2exp:
        list2exp(List)
        Inverse of exp2list.
        See also: 1/ exp2list 
        Ex1:list2exp([[3,9],[- 1,1]],[x, y])
        Ex2:list2exp(solve(x^2-1=0),x)
        
        '''

     def list2mat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for list2mat:
        list2mat(Lst(l),Intg(n))
        Returns the matrix with n columns and where terms are the list l completed eventually by 0.
        See also: 1/ mat2list 
        Ex1:list2mat([1,8,4,9],1)
        Ex2:list2mat([1,8,4,9],2)
        
        '''

     def list_edge_attributes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for list_edge_attributes:
        list_edge_attributes(Graph(G),Edge(e))
        Returns the list of attributes assigned to the edge e in G. Each attribute has the form tag=value.
        See also: 1/ set_edge_attribute 2/ get_edge_attribute 3/ discard_edge_attribute 
        
        '''

     def list_graph_attributes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for list_graph_attributes:
        list_graph_attributes(Graph(G))
        Returns the list of graph attributes of G. Each attribute has the form tag=value.
        See also: 1/ set_graph_attribute 2/ get_graph_attribute 3/ discard_graph_attribute 
        
        '''

     def list_vertex_attributes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for list_vertex_attributes:
        list_vertex_attributes(Graph(G),Vrtx(v))
        Returns the list of attributes assigned to the vertex v in G. Each attribute has the form tag=value.
        See also: 1/ set_vertex_attribute 2/ get_vertex_attribute 3/ discard_vertex_attribute 
        
        '''

     def listplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for listplot:
        listplot(Lst(l)||Mtrx(M))
        Draws the polygonal line through the points with abscissas 0,...,n and ordinates l=[y0,...,yn] or the line through the points with abscissas the first column of M and ordinates the second column.
        See also: 1/ polygonplot 2/ scatterplot 3/ polygonscatterplot 
        Ex1:listplot([13,10,15,16])
        Ex2:listplot([1,13],[2,10],[3,15],[4,16])
        Ex3:listplot([[0,13],[2,10],[4,15]])
        
        '''

     def lll(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lll:
        lll(Mtrx)
        (S,A,L,O):=lll(M), short basis of a lattice (L*O=A*M=S).
        Ex1:lll([[1234,3452,4521],[3425,2241,1543],[5643,3425,8721]])
        
        '''

     def ln(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ln:
        ln(Expr or Opt)
        Natural logarithm or option of the convert or convertir command (id trig2exp).
        See also: 1/ exp 2/ convert 3/ trig2exp 4/ log10 
        Ex1:ln(1)
        Ex2:ln(e)
        Ex3: convert(cos(x),ln)
        
        '''

     def lname(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lname:
        lname(Expr)
        List of variables in the expression.
        See also: 1/ has 2/ lvar 
        Ex1:lname(exp(x)*2*sin(y))
        
        '''

     def lncollect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lncollect:
        lncollect(Expr)
        Collects logarithms. Applies ln(a)+n*ln(b)->ln(a*b^n) for integers n.
        See also: 1/ texpand 
        Ex1:lncollect(ln(x)+2*ln(y))
        
        '''

     def lnexpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lnexpand:
        lnexpand(Expr)
        Expands logarithms.
        See also: 1/ texpand 2/ expexpand 3/ trigexpand 
        Ex1:lnexpand(ln(3*x))
        
        '''

     def locus(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for locus:
        locus(Pnt,Elem)
        locus(M,A) draws the locus of M (or locus(d,A) draws the envelope of d) when A:=element(C) (C is a curve). The example instructions below must be written in a geometric level on different lines.
        See also: 1/ envelope 2/ trace 
        Ex1: A:=element(circle(i,1+i));M:=homothety(0,2,A);locus(M,A)
        Ex2: A:=element(line(x=0));d:=perpen_bisector(1,A);locus(d,A)
        
        '''

     def log(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for log:
        log(Expr or Opt)
        Natural logarithm or option of the convert or convertir command (id trig2exp).
        See also: 1/ exp 2/ convert 3/ trig2exp 4/ log10 
        Ex1:log(1)
        Ex2:log(e)
        Ex3: convert(cos(x),ln)
        
        '''

     def log10(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for log10:
        log10(Expr)
        Common logarithm (base 10).
        See also: 1/ alog10 2/ ln 
        Ex1:log10(10)
        
        '''

     def log2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for log2:
        log2(Expr)
        Binary logarithm (base 2).
        See also: 1/ log 2/ logb 3/ log10 
        Ex1:log2(8)
        
        '''

     def log_loss(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for log_loss:
        log_loss(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def logarithmic_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for logarithmic_regression:
        logarithmic_regression(Lst||Mtrx(A),[Lst])
        Returns the coefficients a and b of y=a*ln(x)+b : it is the best logarithm which approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ exponential_regression 
        Ex1:logarithmic_regression([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex2:logarithmic_regression([1.0,2.0,3.0,4.0],[1.0,4.0,9.0,16.0])
        
        '''

     def logarithmic_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for logarithmic_regression_plot:
        logarithmic_regression_plot(Lst||Mtrx(A),[Lst])
        Returns the plot of y=a*ln(x)+b : it is the best logarithm which approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ exponential_regression_plot 
        Ex1:logarithmic_regression_plot([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex2:logarithmic_regression_plot([1.0,2.0,3.0,4.0],[1.0,4.0,9.0,16.0])
        
        '''

     def logb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for logb:
        logb(Real)
        Logarithm with base b.
        See also: 1/ log 2/ log10 
        Ex1:logb(5,2)
        Ex2:logb(7,10)
        
        '''

     def logistic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for logistic:
        logistic(Real(x),[Real(x0),[Real(L),[Real(k)]]])
        Returns the logistic function value L/(1+exp(-k*(x-x0))) at point x, where L=k=1 and x0=0 by default.
        See also: 1/ atan 2/ tanh 
        Ex1:logistic(1.8)
        Ex2:logistic(0.0,0.5,10,2)
        
        '''

     def logistic_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for logistic_regression:
        logistic_regression(Lst(L),Real(x0),Real(y0))
        Returns y,y',C,y'max,xmax,R : y is a logistic function (sol of y'/y=a*y+b), such that y(x0)=y0 and where [y'(x0),y'(x0+1)...] is the best approximation of L.
        See also: 1/ polynomial_regression 2/ power_regression 3/ linear_regression 
        Ex1:logistic_regression(evalf([1,2,4,6,8,7,5]),1,2)
        Ex2:logistic_regression([0.0,1.0,2.0,3.0,4.0],0.0,1.0)
        
        '''

     def logistic_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for logistic_regression_plot:
        logistic_regression_plot(Lst(L),Real(x0),Real(y0))
        Returns the plot of a logistic function y such that y(x0)=y0 and where [y'(x0),y'(x0+1)...] is the best approximation of L.
        See also: 1/ polynomial_regression_plot 2/ power_regression_plot 3/ linear_regression_plot 
        Ex1:logistic_regression_plot(evalf([1,2,4,6,8,7,5]),1,2)
        Ex2:logistic_regression_plot([0.0,1.0,2.0,3.0,4.0],0.0,1.0)
        
        '''

     def lower(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lower:
        lower(Mtrx||Strng)
        Returns the lower triangular matrix (under the diagonal, included) or writes a string in lowercase.
        See also: 1/ diag 2/ upper 
        Ex1:lower([[1,2,3],[4,5,6],[7,8,9]])
        Ex2:lower("HELLO")
        
        '''

     def lowest_common_ancestor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lowest_common_ancestor:
        lowest_common_ancestor(Graph(T),Vrtx(r),Seq(u,v)||Lst([u1,v1],[u2,v2],...))
        Returns the lowest common ancestor of nodes u and v in a tree graph T with root r, or the list of lowest common ancestors of all pairs [uk,vk].
        See also: 1/ is_tree 2/ tree_height 
        Ex1: T:=random_tree(30); lowest_common_ancestor(T,15,10,20)
        Ex2: T:=random_tree(30); lowest_common_ancestor(T,15,[[10,20],[11,19]])
        
        '''

     def lowpass(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lowpass:
        lowpass(Lst(s),Real(c),[Intg(samplerate)])
        Returns the result of applying a simple first-order lowpass RC filter with cutoff frequency c (the default samplerate is 44100) to the given signal s.
        See also: 1/ highpass 2/ moving_average 
        Ex1: f:=unapply(periodic(sign(x),x,-1/880,1/880),x):;s:=createwav(apply(f,soundsec(1))):;playsnd(lowpass(s,1000))
        
        '''

     def lp_assume(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_assume:
        lp_assume(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_bestlocalbound(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_bestlocalbound:
        lp_bestlocalbound(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_bestprojection(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_bestprojection:
        lp_bestprojection(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_binary(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_binary:
        lp_binary(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_binaryvariables(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_binaryvariables:
        lp_binaryvariables(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_breadthfirst(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_breadthfirst:
        lp_breadthfirst(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_depthfirst(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_depthfirst:
        lp_depthfirst(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_depthlimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_depthlimit:
        lp_depthlimit(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_firstfractional(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_firstfractional:
        lp_firstfractional(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_gaptolerance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_gaptolerance:
        lp_gaptolerance(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_heuristic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_heuristic:
        lp_heuristic(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_hybrid(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_hybrid:
        lp_hybrid(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_integer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_integer:
        lp_integer(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_integervariables(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_integervariables:
        lp_integervariables(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_interiorpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_interiorpoint:
        lp_interiorpoint(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_iterationlimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_iterationlimit:
        lp_iterationlimit(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_lastfractional(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_lastfractional:
        lp_lastfractional(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_maxcuts(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_maxcuts:
        lp_maxcuts(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_maximize(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_maximize:
        lp_maximize(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_method(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_method:
        lp_method(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_mostfractional(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_mostfractional:
        lp_mostfractional(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_nodelimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_nodelimit:
        lp_nodelimit(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_nodeselect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_nodeselect:
        lp_nodeselect(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_nonnegative(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_nonnegative:
        lp_nonnegative(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_nonnegint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_nonnegint:
        lp_nonnegint(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_presolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_presolve:
        lp_presolve(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_pseudocost(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_pseudocost:
        lp_pseudocost(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_simplex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_simplex:
        lp_simplex(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_timelimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_timelimit:
        lp_timelimit(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_varselect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_varselect:
        lp_varselect(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lp_verbose(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lp_verbose:
        lp_verbose(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def lpsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lpsolve:
        lpsolve(Expr(o),[List(c)],[bounds],[options])
        Solves a (mixed integer/binary) LP problem in general form.
        See also: 1/ nlpsolve 2/ fsolve 3/ minimize 4/ maximize 5/ box_constraints 
        Ex1:lpsolve(2x+y-z+4,[x<=1,y>=2,x+3y-z=2,2x-y+z<=8,-x+y<=5])
        Ex2:lpsolve(-7x+2y,[4x-12y<=20,-x+3y<=3],x=-5..5,y=0..inf,maximize)
        Ex3:lpsolve(-x-y,[y<=3x+1/2,y<=-5x+2],assume=lp_nonnegative)
        Ex4:lpsolve(-6x+4y+z,[5x-10y<=20,2z-3y=6,-x+3y<=3],x=1..20,y=0..inf)
        Ex5:lpsolve(-5x-7y,[7x+y<=35,-x+3y<=6],assume=integer)
        Ex6:lpsolve(8x1+11x2+6x3+4x4,[5x1+7x2+4x3+3x4<=14],assume=lp_binary,maximize)
        Ex7:lpsolve(x1+x2,[1867x1+1913x2=3618894],assume=nonnegint,lp_verbose=true)
        
        '''

     def lsmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lsmod:
        lsmod(NULL)
        Displays the installed dynamic libraries.
        See also: 1/ insmod 2/ rmmod 
        Ex1:lsmod()
        
        '''

     def lsq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lsq:
        lsq(Mtrx(A),(Mtrx || Vect)(B))
        Returns the vector (resp matrix) X which is the minimum of the euclidean (resp Frobenius) norm of A*X-B corresponding to the linear system A*X=B when B is a vector (resp matrix).
        See also: 1/ lu 2/ QR 
        Ex1:lsq([[1,2],[3,4]],[5,11])
        Ex2:lsq([[1,2],[3,4]],[[5,-1],[11,-1]])
        
        '''

     def lu(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lu:
        lu(Mtrx)
        For a numerical matrix A, returns p permutation, L and U such that PA=LU (P=permu2mat(p)).
        See also: 1/ qr 2/ cholesky 3/ LU 
        Ex1:lu([[1,2],[3,4]])
        Ex2:lu([[6,12,18],[5,14,31],[3,8,18]])
        
        '''

     def lvar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for lvar:
        lvar(Expr)
        List of variables of an object (with rational dependence).
        See also: 1/ lname 2/ has 
        Ex1:lvar(exp(x)*2*sin(y))
        Ex2:lvar(exp(x)*2*sin(y)+ln(x))
        
        '''

     def mRow(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mRow:
        mRow(Expr(Xpr),Mtrx(A),Intg(n1))
        Multiplies row n1 of the matrix A by Xpr.
        See also: 1/ rowAdd 2/ mRowAdd 
        Ex1:mRow(12,[[1,2],[3,4],[5,6]],0)
        
        '''

     def mRowAdd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mRowAdd:
        mRowAdd(Expr(Xpr),Mtrx(A),Intg(n1),Intg(n2))
        Multiplies row n1 of the matrix A by Xpr, then adds it to the row n2.
        See also: 1/ rowAdd 2/ mRow 
        Ex1:mRowAdd(12,[[1,2],[3,4],[5,6]],0,2)
        
        '''

     def magenta(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for magenta:
        magenta(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def make_directed(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for make_directed:
        make_directed(Graph(G),[Mrtx(A)])
        Returns a copy of an undirected graph G in which every edge is converted to a pair of arcs [with weights specified by matrix A].
        See also: 1/ is_directed 2/ make_weighted 3/ underlying_graph 
        Ex1:make_directed(cycle_graph(4),[[0,0,0,1],[2,0,1,3],[0,1,0,4],[5,0,4,0]])
        
        '''

     def make_symbol(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for make_symbol:
        make_symbol(Strng(str))
        Returns a symbol with name str.
        See also: 1/ symbol_array 
        Ex1:make_symbol("abc")
        
        '''

     def make_weighted(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for make_weighted:
        make_weighted(Graph(G),[Mrtx(M)])
        Returns a copy of G with edge/arc weights set as specified by matrix M. If M is omitted, then a square matrix of ones is used. If G is undirected, then M is assumed to be symmetric.
        See also: 1/ get_edge_weight 2/ is_weighted 3/ make_directed 4/ set_edge_weight 5/ underlying_graph 6/ weight_matrix 
        Ex1:make_weighted(cycle_graph(3),[[0,2,3],[2,0,1],[3,1,0]])
        
        '''

     def makelist(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for makelist:
        makelist(Fnc,InitVal,FinalVal,StepVal)
        Returns a list made with a function or with a constant.
        See also: 1/ seq 2/ range 3/ makemat 4/ $ 
        Ex1:makelist(x->x^2,1,10,2)
        Ex2:makelist(4,1,10)
        Ex3:makelist(4,5,10)
        Ex4:makelist(x->ifte(x<5,"A","B"),1,10)
        
        '''

     def makemat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for makemat:
        makemat(Fnct(f),RowsNumb,ColsNumb)
        Creates a matrix.
        See also: 1/ matrix 
        Ex1:makemat((j,k)->j+k,3,2)
        Ex2:makemat((j,k)->1/(j+k+1),2,3)
        Ex3:makemat(sqrt(2),2,3)
        
        '''

     def makesuite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for makesuite:
        makesuite(Vect||Lst)
        Returns a sequence made with a vector.
        See also: 1/ makevector 2/ op 
        Ex1:makesuite([1,2,3])
        
        '''

     def makevector(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for makevector:
        makevector(Seq)
        Returns a vector made with a sequence.
        See also: 1/ makesuite 
        Ex1:makevector(1,2,3)
        
        '''

     def map(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for map:
        map(Lst(l),Fnc(f))
        Applies the function f at the elements of the list l or at a polynomial of internal format.
        See also: 1/ apply 2/ set 3/ unapply 
        Ex1:map([1,2,3],x->x^3)
        Ex2:map([1,2,3],unapply(x^3,x))
        Ex3:map(%%%{1,[2,0]%%%}+%%%{2,[1,1]%%%},(a,b,c)->a*(b+2*c))
        
        '''

     def maple2mupad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maple2mupad:
        maple2mupad(Str("Name_Maplefile"),Str("Name_Mupadfile"))
        maple2mupad("file1","file2") translates file1(Maple) to file2(MuPAD).
        See also: 1/ maple2xcas 
        
        '''

     def maple2xcas(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maple2xcas:
        maple2xcas(Str("NameMapleFile"),Str("NameXcasFile"))
        maple2xcas("file1","file2") translates file1(Maple) to file2(Xcas).
        See also: 1/ maple2mupad 
        
        '''

     def maple_ifactors(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maple_ifactors:
        maple_ifactors(Intg(n))
        Returns 1 or -1 for the sign and the prime factors with their multiplicity of n in a matrix, such as ifactors in Maple.
        See also: 1/ ifactors 
        Ex1:maple_ifactors(120)
        
        '''

     def maple_mode(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maple_mode:
        maple_mode(Intg(0) or 1 or 2 or 3)
        Switches to mode Xcas (0), Maple (1), Mupad (2), TI89 (3).
        See also: 1/ python_compat 
        Ex1:maple_mode(1)
        Ex2:maple_mode(0)
        
        '''

     def markov(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for markov:
        markov(Mtrx(M),[Real(eps)])
        Computation of the proper elements of a Markov chain transition matrix M, returns the list of sequence of positive recurrent states, the list of corresponding invariant probabilities, the list of other strongly connected components, the list of probabilities to end up in the sequence of recurrent states.
        See also: 1/ randmarkov 2/ plotproba 
        Ex1:markov([[0,0,1/2,0,1/2],[0,0,1,0,0],[1/4,1/4,0,1/4,1/4],[0,0,1/2,0,1/2],[0,0,0,0,1]])
        
        '''

     def mat2list(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mat2list:
        mat2list(Mtrx)
        Returns the list of the terms of the matrix.
        See also: 1/ list2mat 2/ flatten 
        Ex1:mat2list([[1,8],[4,9]])
        
        '''

     def mathml(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mathml:
        mathml(Expr)
        Converts the expression into a string to display maths for the web.
        See also: 1/ export_mathml 2/ latex 
        Ex1:mathml(1/2)
        
        '''

     def matpow(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for matpow:
        matpow(Mtrx,Intg(n))
        Calculates the nth power of a matrix by jordanization.
        See also: 1/ &^ 2/ ^ 
        Ex1:matpow([[1,2],[3,4]],n)
        
        '''

     def matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for matrix:
        matrix(Intg(p),Intg(q),(Fnc(f) or Val(a)))
        Makes a matrix m(j,k) with p rows and q cols, m(j,k)=f(j,k) or m(j,k)=a : the index start at 0 or 1 according to the mode (Xcas or Maple) (or option of apply) or make a matrix with a table.
        See also: 1/ makemat 2/ makelist 3/ apply 
        Ex1:matrix(2,3,(j,k)->1/(j+k+1))
        Ex2:matrix(3,2,(j,k)->j+k)
        Ex3:matrix(2,3,4)
        Ex4:  A[0..2,0..2]:=1;A[0..1,1..2]:=2;a:=matrix(A) 
        
        '''

     def matrix_norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for matrix_norm:
        matrix_norm(Mtrx,[2]||[inf])
        Matrix norm induced by l1norm or by l2norm or by linfinty norm.
        See also: 1/ l1norm 2/ l2 norm 3/ linfnorm 4/ frobenius_norm 
        Ex1:matrix_norm([[1,2,3],[3,-9,6],[4,5,6]])
        Ex2:matrix_norm([[1,2,3],[3,-9,6],[4,5,6]],1)
        Ex3:matrix_norm([[1,2,3],[3,-9,6],[4,5,6]],2)
        Ex4:matrix_norm([[1,2,3],[3,-9,6],[4,5,6]],inf)
        
        '''

     def max(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for max:
        max(Seq||Lst)
        Maximum of elements of a sequence or a list of reals.
        See also: 1/ min 
        Ex1:max(25,35)
        
        '''

     def maxflow(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maxflow:
        maxflow(Graph(G),Vrtx(s),Vrtx(t))
        Returns the optimal value for a max flow problem in a network G with source s and sink t along with an optimal flow (as a matrix).
        See also: 1/ minimum_cut 
        Ex1:maxflow(digraph(%{[[1,2],2],[[2,3],4],[[3,4],3],[[1,5],3],[[5,2],1],[[5,4],2]%}),1,4)
        
        '''

     def maximal_independent_set(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maximal_independent_set:
        maximal_independent_set(Graph(G))
        Returns a maximal set of mutually independent (non-adjacent) vertices in G.
        See also: 1/ maximum_independent_set 
        Ex1:maximal_independent_set(graph("petersen"))
        
        '''

     def maximize(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maximize:
        maximize(Expr,[Constr],Vars,[Options])
        Finds the global maximum of a function.
        See also: 1/ minimize 
        Ex1:maximize(sin(x),[x=0..4])
        Ex2:maximize(x^4-x^2,x=-3..3,coordinates)
        Ex3:maximize(piecewise(x<=-2,x+6,x<=1,x^2,3/2-x/2),x=-3..2)
        Ex4:maximize(x^2-3x+y^2+3y+3,[x=2..4,y=-4..-2],point)
        Ex5:maximize(2x^2-y^2+6y,x^2+y^2<=16,[x,y])
        Ex6:maximize(sqrt(x^2+y^2)-z,[x^2+y^2<=16,x+y+z=10],[x,y,z])
        Ex7:maximize((1+x^2+3y+5x-4*x*y)/(1+x^2+y^2),x^2/4+y^2/3=9,[x,y])
        
        '''

     def maximum_clique(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maximum_clique:
        maximum_clique(Graph(G))
        Returns the maximum clique in an undirected graph G as a list of vertices.
        See also: 1/ clique_number 2/ is_clique 3/ maximum_independent_set 
        Ex1:maximum_clique(graph_complement(complete_graph(3,4)))
        
        '''

     def maximum_degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maximum_degree:
        maximum_degree(Graph(G))
        Returns the largest degree of a vertex in G.
        See also: 1/ minimum_degree 2/ vertex_degree 
        Ex1:maximum_degree(digraph(trail(1,2,3,4,5,6,4,7,8,2)))
        
        '''

     def maximum_independent_set(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maximum_independent_set:
        maximum_independent_set(Graph(G))
        Returns a maximum independent vertex set in G.
        See also: 1/ clique_number 2/ graph_complement 3/ independence_number 4/ maximum_clique 
        Ex1:maximum_independent_set(complete_graph(3,4))
        
        '''

     def maximum_matching(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maximum_matching:
        maximum_matching(Graph(G))
        Returns the list of edges representing a maximum matching in G.
        See also: 1/ maximum_independent_set 
        Ex1: G:=graph("soccerball"); draw_graph(highlight_edges(G,maximum_matching(G)))
        
        '''

     def maxnorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for maxnorm:
        maxnorm(Vect or Mtrx)
        Norm with the max of a vector (or of a matrix): maxnorm([x1,x2,..,xn])=max(|x1|,..,|xn|).
        See also: 1/ l2norm 2/ l1norm 
        Ex1:maxnorm([1,2])
        Ex2:maxnorm([1,2,3,-4])
        Ex3:maxnorm([[1,2],[3,-4]])
        
        '''

     def mean(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mean:
        mean(Lst||Mtrx,[Lst])
        Mean of a list with the second argument as weight or of the columns of a matrix.
        See also: 1/ stddev 
        Ex1:mean([1,2,3])
        Ex2:mean([1,2,3],[1,2,3])
        Ex3:mean([[1,2,3],[1,2,3]])
        
        '''

     def median(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for median:
        median(Lst||Mtrx,[Lst])
        Returns the median of a list with the second argument as weight or of the columns of a matrix.
        See also: 1/ quartiles 
        Ex1:median([1,2,3,5,10,4])
        Ex2:median([1,2,3,5,10,4],[1,2,3,1,2,3])
        
        '''

     def median_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for median_line:
        median_line((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        median_line(A,B,C) draws the median-line through A of the triangle ABC.
        See also: 1/ midpoint 2/ perpen_bisector 
        Ex1:median_line(-1,1-i,i)
        
        '''

     def member(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for member:
        member(Elem(e),(Lst(l) or Set(l)))
        Tests if e is in the list or set l (=0, or k+1 with l[k]=e).
        See also: 1/ contains 2/ est_element 3/ find 4/ index 
        Ex1:member(1,[4,3,1,2])
        Ex2:member(1,%{4,3,1,2%})
        
        '''

     def mgf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mgf:
        mgf(Func,[Real(Param_1),Real(Param_2)])
        Returns the moment generating function of a probability distribution from normal, binomial, Poisson, beta, gamma distribution
        Ex1:mgf(normald,1,0)
        Ex2:mgf(poisson,5)
        Ex3:mgf(binomial,n,p)
        
        '''

     def mid(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mid:
        mid(Lst(l) or Str(l),Intg(d),Intg(n))
        Returns the extracted list of l with n elements (by default n=size(l)-d) and beginning at index d.
        See also: 1/ head 2/ tail 3/ left 4/ right 5/ subMat 
        Ex1:mid([0,1,2,3,4,5,6],2,3)
        Ex2:mid([0,1,2,3,4,5,6],2)
        Ex3:mid("azertyuiop",2,4)
        Ex4:mid("azertyuiop",2)
        Ex5:mid([[1,2],[3,4],[5,6]],1)
        
        '''

     def middle_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for middle_point:
        middle_point(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def midpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for midpoint:
        midpoint((Pnt or Cplx),(Pnt or Cplx))
        midpoint(A,B) draws the midpoint of the segment AB.
        See also: 1/ median_line 2/ perpen_bisector 
        Ex1:midpoint(-2,2i)
        
        '''

     def min(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for min:
        min(Seq||Lst)
        Minimum of elements of a sequence or a list of reals.
        See also: 1/ max 
        Ex1:min(25,35)
        
        '''

     def minimal_edge_coloring(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimal_edge_coloring:
        minimal_edge_coloring(Graph(G),[sto])
        Finds a minimal edge coloring of G and returns the sequence n,L where n is the class of G (1 for D colors and 2 for D+1 colors) and L is the list of colors of edges of G as returned by the edges command, or a copy of G with colored edges if the option 'sto' is specified.
        See also: 1/ chromatic_index 2/ minimal_vertex_coloring 3/ edges 
        Ex1:minimal_edge_coloring(graph("petersen"))
        Ex2: G:=minimal_edge_coloring(graph("dodecahedron"),sto); draw_graph(G)
        
        '''

     def minimal_spanning_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimal_spanning_tree:
        minimal_spanning_tree(Graph(G))
        Returns a minimal spanning tree in an undirected graph G.
        See also: 1/ spanning_tree 
        Ex1:minimal_spanning_tree(graph([[0,1,0,4,0,0],[1,0,1,0,4,0],[0,1,0,3,0,1],[4,0,3,0,1,0],[0,4,0,1,0,4],[0,0,1,0,4,0]]))
        
        '''

     def minimal_vertex_coloring(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimal_vertex_coloring:
        minimal_vertex_coloring(Graph(G),[sto])
        Computes the minimal vertex coloring for G and returns the colors in the order of vertices. If optional parameter "sto" is given, the colors are assigned to vertices and a modified copy of G is returned.
        See also: 1/ chromatic_number 2/ is_vertex_colorable 
        Ex1:minimal_vertex_coloring(graph("petersen"))
        Ex2: draw_graph(minimal_vertex_coloring(graph("petersen"),sto))
        
        '''

     def minimax(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimax:
        minimax(Expr,Var=Real(a)..Real(b),Intg(n)||Lst(Intg(n),Intg(m)),[opts])
        Returns rational approximation of degree n[,m] of a continuous bounded function on a..b using Remez algorithm.
        See also: 1/ fitpoly 
        Ex1:minimax(abs(x)*sqrt(abs(x)),x=-2..2,15)
        Ex2:minimax(min(1/cosh(3*sin(x)),sin(9x/10)),x=-3..4,30)
        Ex3:minimax(x*exp(-x),x=0..10,[5,3],rand=30)
        
        '''

     def minimize(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimize:
        minimize(Expr,[Constr],Vars,[Options])
        Finds the global minimum of a function.
        See also: 1/ maximize 
        Ex1:minimize(sin(x),[x=0..4])
        Ex2:minimize(x^4-x^2,x=-3..3,coordinates)
        Ex3:minimize(piecewise(x<=-2,x+6,x<=1,x^2,3/2-x/2),x=-3..2)
        Ex4:minimize(x^2-3x+y^2+3y+3,[x=2..4,y=-4..-2],point)
        Ex5:minimize(2x^2-y^2+6y,x^2+y^2<=16,[x,y])
        Ex6:minimize(sqrt(x^2+y^2)-z,[x^2+y^2<=16,x+y+z=10],[x,y,z])
        Ex7:minimize((1+x^2+3y+5x-4*x*y)/(1+x^2+y^2),x^2/4+y^2/3=9,[x,y])
        
        '''

     def minimum_cut(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimum_cut:
        minimum_cut(Graph(G),Vrtx(s),Vrtx(t))
        Returns the list of edges forming a minimum cut in a directed graph G with source s and sink t.
        See also: 1/ maxflow 
        Ex1:minimum_cut(digraph(%{[[1,2],2],[[2,3],4],[[3,4],3],[[1,5],3],[[5,2],1],[[5,4],2]%}),1,4)
        
        '''

     def minimum_degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimum_degree:
        minimum_degree(Graph(G))
        Returns the smallest degree of a vertex in G.
        See also: 1/ maximum_degree 2/ vertex_degree 
        Ex1:minimum_degree(digraph(trail(1,2,3,4,5,6,4,7,8,2)))
        
        '''

     def minimum_vertex_cover(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for minimum_vertex_cover:
        minimum_vertex_cover(Graph(G),[approx])
        Returns a list of vertices which comprise a minimum vertex cover in an undirected graph G.
        See also: 1/ vertex_cover_number 2/ find_vertex_cover 
        Ex1:minimum_vertex_cover(graph_complement(complete_graph(3,4)))
        
        '''

     def mixdown(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mixdown:
        mixdown(Audio(clip1),(Real||Lst)(parm1),Audio(clip2),(Real||Lst)(parm2),...)
        Returns audio clips clip1,clip2,... mixed down to a single clip according to the given parameters.
        See also: 2/ + 1/ splice 
        
        '''

     def mkisom(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mkisom:
        mkisom(Vect,(Sign(1) or -1))
        Matrix of an isometry given by its proper elements.
        See also: 1/ isom 
        Ex1:mkisom([1,2],1)
        Ex2:mkisom([[1,0,0],pi/3],-1)
        Ex3:mkisom(pi,1)
        
        '''

     def mksa(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mksa:
        mksa(Unit)
        Converts units to the MKSA international unit system.
        See also: 1/ convert 2/ ufactor 
        Ex1:mksa(1_N)
        
        '''

     def modf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for modf:
        modf(Real(a))
        Returns (a-trunc(a),trunc(a)).
        See also: 1/ frac 2/ floor 
        Ex1:modf(2.3)
        Ex2:modf(-2.3)
        
        '''

     def modgcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for modgcd:
        modgcd(Poly,Poly)
        GCD of 2 polynomials, with the modular algorithm.
        See also: 1/ gcd 2/ heugcd 3/ ezgcd 4/ psrgcd 
        Ex1:modgcd(x^4-1,(x-1)^2)
        
        '''

     def mods(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mods:
        mods(Intg,Intg)
        Returns the Euclidean symmetric remainder of two integers.
        See also: 1/ irem 2/ iquo 3/ mod 4/ fracmod 
        Ex1:mods(8,3)
        Ex2:mods(10,4)
        Ex3:mods(11,7)
        
        '''

     def momentum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for momentum:
        momentum(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def monotonic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for monotonic:
        monotonic()
        Returns a real that increases as time passes
        Ex1:monotonic()
        
        '''

     def montre_tortue(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for montre_tortue:
        montre_tortue(NULL)
        Shows the turtle.
        See also: 1/ cache_tortue 
        Ex1:montre_tortue()
        
        '''

     def moustache(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for moustache:
        moustache(Lst,[Lst],[x=a..b||y=a..b])
        Box and Whisker plot for a statistical series.
        See also: 1/ quartiles 
        Ex1:moustache([-1,1,2,2.2,3,4,-2,5])
        Ex2:moustache([1,2,3,5,10,4],x=1..2)
        Ex3:moustache([1,2,3,5,10,4],[1,2,3,1,2,3])
        Ex4:moustache([[6,0,1,3,4,2,5],[0,1,3,4,2,5,6],[1,3,4,2,5,6,0],[3,4,2,5,6,0,1],[4,2,5,6,0,1,3],[2,5,6,0,1,3,4]])
        
        '''

     def moving_average(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for moving_average:
        moving_average(Lst(A),Intg(n))
        Applies a moving average filter of length n to a signal sample A, and returns its result as an array of length nops(A)-n+1.
        See also: 1/ lowpass 
        Ex1: snd:=soundsec(2):;data:=0.5*threshold(3*sin(2*pi*220*snd),[-1.0,1.0])+randvector(length(snd),normald,0,0.05):;moving_average(data,25)
        
        '''

     def moyal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for moyal:
        moyal(Expr,Expr,VectVar)
        Moyal product of 2 symbols.
        See also: 1/  
        Ex1:moyal(x^2+y^4,x^4-y^2,[x,y],5)
        
        '''

     def moyenne(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for moyenne:
        moyenne(Lst||Mtrx,[Lst])
        Mean of a list with the second argument as weight or of the columns of a matrix.
        See also: 1/ stddev 
        Ex1:moyenne([1,2,3])
        Ex2:moyenne([1,2,3],[1,2,3])
        Ex3:moyenne([[1,2,3],[1,2,3]])
        
        '''

     def mul(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mul:
        mul(Expr||Lst,[Var||Lst],[Intg(a)],[Intg(b)],[Intg(p)])
        Multiplies the values of the expression when the variable go from a to b with a step p (product(expression,var,begin,end,step) by default p=1) or product of the elements of a list or product element by element of 2 lists or matrices.
        See also: 1/ sum 
        Ex1:mul(n,n,1,10,2)
        Ex2:mul(1/n,n,1,10)
        Ex3:mul(1/n,n,11,1)
        Ex4:mul(1/n,n,10,1,1)
        Ex5:mul([2,3,4,5])
        Ex6:mul([2,3,4],[5,6,7])
        Ex7:mul([[2,3,4],[5,6,7]],[[2,3,4],[5,6,7]])
        
        '''

     def mult_c_conjugate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mult_c_conjugate:
        mult_c_conjugate(Expr)
        Returns the expression after multiplication by the complex conjugate of the denominator (or of the numerator if no denominator).
        See also: 1/ mult_conjugate 
        Ex1:mult_c_conjugate(1/(3+i*2))
        Ex2:mult_c_conjugate(3+i*2)
        
        '''

     def mult_conjugate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mult_conjugate:
        mult_conjugate(Expr)
        Returns the expression after multiplication by the conjugate of the denominator (or of the numerator if no denominator).
        See also: 1/ mult_c_conjugate 
        Ex1:mult_conjugate(sqrt(3)-sqrt(2))
        Ex2:mult_conjugate(1/(sqrt(3)-sqrt(2)))
        
        '''

     def multinomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for multinomial:
        multinomial(Intg(n),Vect(p),Vect(k))
        Returns n!/(k0!*k1!*..;kj!)*(p0^k0*p1^k1..*pj^kj) (sum(p)=1 and sum(k)=n).
        See also: 1/ binomial 2/ randvector 3/ ranm 
        Ex1:multinomial(10,[0.5,0.5],[3,7])
        Ex2:multinomial(10,[0.2,0.3,0.5],[1,3,6])
        Ex3: randvector(3,multinomial,[1/2,1/3,1/6])
        Ex4: ranm(4,3,multinomial,[1/2,1/3,1/6])
        
        '''

     def multiplier_conjugue(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for multiplier_conjugue:
        multiplier_conjugue(Expr)
        Returns the expression after multiplication by the conjugate of the denominator (or of the numerator if no denominator).
        See also: 1/ mult_c_conjugate 
        Ex1:multiplier_conjugue(sqrt(3)-sqrt(2))
        Ex2:multiplier_conjugue(1/(sqrt(3)-sqrt(2)))
        
        '''

     def multiplier_conjugue_complexe(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for multiplier_conjugue_complexe:
        multiplier_conjugue_complexe(Expr)
        Returns the expression after multiplication by the complex conjugate of the denominator (or of the numerator if no denominator).
        See also: 1/ mult_conjugate 
        Ex1:multiplier_conjugue_complexe(1/(3+i*2))
        Ex2:multiplier_conjugue_complexe(3+i*2)
        
        '''

     def multiply(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for multiply:
        multiply(Intg or Lst, Intg or Lst)
        Returns the product of the 2 arguments.
        See also: 1/ * 
        Ex1:multiply(41,-4)
        Ex2:multiply([4,1],[-4,2])
        Ex3:multiply([[4,1],[-4,1]],[[4,1],[-4,1]])
        
        '''

     def mupad2maple(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mupad2maple:
        mupad2maple(Str("NameMupadFile"),Str("NameMapleFile"))
        mupad2maple("file1","file2") translates file1(MuPAD) to file2(Maple).
        See also: 1/ mupad2xcas 
        
        '''

     def mupad2xcas(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mupad2xcas:
        mupad2xcas(Str("NameMupadFile"),Str("NameXcasFile"))
        mupad2xcas("file1","file2") translates file1(MuPAD) to file2(Xcas).
        See also: 1/ mupad2maple 
        
        '''

     def mycielski(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for mycielski:
        mycielski(Graph(G))
        Returns the Mycielskian of an undirected graph G.
        See also: 1/ chromatic_number 2/ number_of_triangles 
        Ex1:mycielski(graph("petersen"))
        Ex2: is_isomorphic(mycielski(mycielski(path_graph(2))),graph("grotzsch"))
        
        '''

     def nCr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nCr:
        nCr(Intg(n),Intg(r))
        comb(n,r)=number of combinations of r objects taken among n : n!/(r!(n-r)!) (If n<0 comb(n,r)=n(n-1)..(n-r+1)/r!).
        See also: 1/ factorial 2/ perm 
        Ex1:nCr(4,2)
        
        '''

     def nDeriv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nDeriv:
        nDeriv(Expr(Xpr),Var(Var),[Real(h)])
        Returns an approximation of the derivative number at a point: (Xpr(var+h)-Xpr(var-h))/(2*h) (by default h=0.001).
        See also: 1/ avgRC 
        Ex1:nDeriv(f(x),x,h)
        Ex2:nDeriv(x^2,x,0.1)
        Ex3:nDeriv(x^2,x)
        
        '''

     def nInt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nInt:
        nInt(Expr(f(x)),Var(x),Real(a),Real(b))
        Returns the approximate value of integrate(f(x),x,a,b) by Romberg's method.
        See also: 1/ integrate 2/ gaussquad 
        Ex1:nInt(exp(x^2),x,0,1)
        Ex2:nInt(x^2,x,0,1)
        Ex3:nInt(exp(-x^2),x,-1,1)
        
        '''

     def nPr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nPr:
        nPr(Intg(n),Intg(p))
        perm(n,p)=number of arrangements of p objects taken among n : n!/(n-p)!
        See also: 1/ comb 2/ factorial 
        Ex1:nPr(4,2)
        
        '''

     def nSolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nSolve:
        nSolve(Expr,Var,[Guess or Interval],[Method])
        Numerical solution of an equation or a system of equations.
        See also: 1/ solve 2/ fsolve 3/ csolve 
        Ex1:nSolve(cos(x)=x,x)
        Ex2:nSolve(cos(x)=x,x=1.3)
        
        '''

     def navy(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for navy:
        navy(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def ncols(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ncols:
        ncols(Mtrx)
        Number of columns of a matrix.
        See also: 1/ rowdim 
        Ex1:ncols([[1,2,3],[4,5,6]])
        Ex2:ncols([[1,2],[3,4],[5,6]])
        
        '''

     def negbinomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for negbinomial:
        negbinomial(Intg(n),Intg(k),Real(p in 0..1))
        Returns comb(n+k-1,k)*p^k*(1-p)^n.
        See also: 1/ negbinomial_cdf 2/ negbinomial_icdf 3/ binomial 
        Ex1:negbinomial(4,0,0.5)
        Ex2:negbinomial(4,2,0.6)
        Ex3:negbinomial(4,6,0.3)
        
        '''

     def negbinomial_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for negbinomial_cdf:
        negbinomial_cdf(Intg(n),Real(p),Real(x),[Real(y)])
        Returns Proba(X<=x) or Proba(x<=X<=y) when X follows the negbinomial(n,p) law.
        See also: 1/ negbinomial 2/ negbinomial_icdf 
        Ex1:negbinomial_cdf(4,0.5,2)
        Ex2:negbinomial_cdf(4,0.1,2)
        Ex3:negbinomial_cdf(4,0.5,2,3)
        
        '''

     def negbinomial_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for negbinomial_icdf:
        negbinomial_icdf(Intg(n),Real(p),Real(t))
        Returns h such as Proba(X<=h)=t when X follows the negbinomial(n,p) law.
        See also: 1/ negbinomial 2/ negbinomial_cdf 
        Ex1:negbinomial_icdf(4,0.5,0.68)
        Ex2:negbinomial_icdf(4,0.1,0.95)
        
        '''

     def neighbors(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for neighbors:
        neighbors(Graph(G),[Vrtx(v)])
        Returns the list of vertices adjacent to vertex v of G. If v is omitted, a list of adjacency lists of all vertices in G is returned.
        See also: 1/ adjacency_matrix 2/ vertex_degree 3/ in_degree 3/ out_degree 
        Ex1:neighbors(digraph(trail(1,2,3,4,5,6,4,7,8,2)),4)
        
        '''

     def network_transitivity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for network_transitivity:
        network_transitivity(Graph(G))
        Returns the transitivity (also called triangle density or global clustering coefficient) of a network G.
        See also: 1/ clustering_coefficient 2/ number_of_triangles 
        Ex1:network_transitivity(graph(%{[1,2],[2,3],[2,4],[3,4],[4,1]%}))
        
        '''

     def neural_network(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for neural_network:
        neural_network(Vect(topology)||NeuralNet(net),[opts])
        Creates a feed-forward neural network with given parameters or creates a copy of the given network with parameter modifications.
        See also: 1/ train 
        Ex1:neural_network([2,3,1])
        Ex2:neural_network([2,3,1],func=logistic)
        
        '''

     def newList(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for newList:
        newList(Intg(n))
        Returns the list made with n zeros.
        See also: 1/ newMat 2/ makelist 
        Ex1:newList(4)
        
        '''

     def newMat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for newMat:
        newMat(Intg(n),Intg(p))
        Returns the list with n rows and p columns, made with zeros.
        See also: 1/ newList 2/ makemat 
        Ex1:newMat(2,3)
        
        '''

     def newton(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for newton:
        newton(Expr(f(x)),Var(x),[ApproxVal(a),NumIter(p)])
        newton(f(x),x,a,p)=one root of f(x) by Newton method beginning with a and p iterations (by default p=20).
        See also: 1/ rootof 
        Ex1:newton(x^2-2,x)
        Ex2:newton(x^2-2,x,2)
        Ex3:newton(x^2-2,x,-2)
        Ex4:newton(x^2-2,x,2,5,1e-7)
        
        '''

     def newton_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for newton_solver:
        newton_solver(Opt)
        Argument for fsolve giving the method for solving a numerical equation.
        See also: 1/ fsolve 
        Ex1: fsolve(cos(x)=x,x,0..1,bisection_solver)
        Ex2: fsolve(cos(x)=x,x,0..1,brent_solver)
        Ex3: fsolve(cos(x)=x,x,0..1,falsepos_solver)
        Ex4: fsolve(cos(x)=x,x,0,newton_solver)
        Ex5: fsolve(cos(x)=x,x,0,secant_solver)
        Ex6: fsolve(cos(x)=x,x,0,steffenson_solver)
        
        '''

     def newtonj_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for newtonj_solver:
        newtonj_solver(Opt)
        Argument for fsolve giving the method for solving a system of numerical equations.
        See also: 1/ fsolve 
        Ex1: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver)
        Ex2: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver)
        Ex3: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver)
        Ex4: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver)
        Ex5: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver)
        Ex6: fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)
        
        '''

     def nextperm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nextperm:
        nextperm(Intg(n))
        Returns the next permutation with the lexicographic order.
        See also: 1/ prevperm 2/ is_permu 
        Ex1:nextperm([0,2,1,3])
        Ex2:nextperm([0,3,2,1])
        
        '''

     def nextprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nextprime:
        nextprime(Intg(a))
        Next prime or pseudo-prime after a given integer.
        See also: 1/ prevprime 2/ is_prime 3/ ithprime 
        Ex1:nextprime(9856989898990)
        Ex2:nextprime(97160249868928888261606009)
        
        '''

     def nlp_binary(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_binary:
        nlp_binary(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_binaryvariables(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_binaryvariables:
        nlp_binaryvariables(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_initialpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_initialpoint:
        nlp_initialpoint(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_integer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_integer:
        nlp_integer(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_integervariables(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_integervariables:
        nlp_integervariables(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_iterationlimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_iterationlimit:
        nlp_iterationlimit(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_maximize(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_maximize:
        nlp_maximize(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_method(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_method:
        nlp_method(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_nonnegative(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_nonnegative:
        nlp_nonnegative(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_nonnegint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_nonnegint:
        nlp_nonnegint(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_precision(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_precision:
        nlp_precision(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_presolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_presolve:
        nlp_presolve(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_tolerance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_tolerance:
        nlp_tolerance(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlp_verbose(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlp_verbose:
        nlp_verbose(Opt)
        Options for nlpsolve command.
        See also: 1/ nlpsolve 
        
        '''

     def nlpsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nlpsolve:
        nlpsolve(Expr(objective),[Lst(constr)],[Seq(bd)],[Seq(opts)])
        Solves a nonlinear programming problem of optimizing the objective under constraints constr (list of equations and/or inequations) and within bounds bd (sequence of x=a..b) with optional options (for example setting an initial point or integrality constraints).
        See also: 1/ minimize 2/ maximize 3/ fMin 4/ fMax 5/ box_constraints 6/ lpsolve 7/ fsolve 
        Ex1:nlpsolve((x1-10)^3+(x2-20)^3,[(x1-5)^2+(x2-5)^2>=100,(x2-5)^2+(x1-6)^2<=82.81],nlp_initialpoint=[x1=20.1,x2=5.84])
        Ex2:nlpsolve(sin(x1+x2)+(x1-x2)^2-1.5x1+2.5x2+1,x1=-1.5..4,x2=-3..3)
        Ex3:nlpsolve(2-1/120*x1*x2*x3*x4*x5,[x1<=1,x2<=2,x3<=3,x4<=4,x5<=5],assume=nlp_nonnegative)
        Ex4:nlpsolve(x1^2/2+5x1+6x2,[6x1+x2^2<=23],[x1,x2]=1..5,assume=integer,maximize)
        Ex5:nlpsolve(4x1*x2*x3-x1*x2-x1*x3-x2*x3,assume=nlp_binary)
        
        '''

     def nodisp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nodisp:
        nodisp(Expr)
        Displays Done in place of a value.
        Ex1:nodisp(A:=ranm(50,50))
        
        '''

     def non_recursive_normal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for non_recursive_normal:
        non_recursive_normal(Expr)
        Simplifies the expressions, but without simplification inside of non-rational expressions.
        See also: 1/ normal 
        Ex1:non_recursive_normal(sin(x+x)+sin(2*x)+x+x)
        Ex2:non_recursive_normal(sin(2*x)+sin(2*x)+x+x)
        
        '''

     def nonnegint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nonnegint:
        nonnegint(Opt)
        Options for lpsolve command.
        See also: 1/ lpsolve 
        
        '''

     def nop(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nop:
        nop(NULL)
        No OPeration instruction.
        See also: 1/  
        Ex1:nop()
        
        '''

     def nops(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nops:
        nops(Lst||Str||Seq||Image||Audio)
        Returns the size of a list, a string, a sequence, an image object or an audio clip.
        See also: 1/ sizes 2/ dim 3/ degree 
        Ex1:nops([1,2,3])
        Ex2:nops("bonjour")
        Ex3:nops(1,2,3)
        
        '''

     def norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for norm:
        norm(Vect or Mtrx)
        Returns the l2 norm of a vector = sqrt(x1^2+x2^2+...xn^2) or matrix norm induced by l2 norm.
        See also: 1/ maxnorm 2/ l1norm 
        Ex1:norm([1,2])
        Ex2:norm([1,2,3,-4])
        Ex3:norm([[1,2],[3,-4]])
        Ex4:norm([[1,2,3],[3,-9,6],[4,5,6]])
        
        '''

     def normal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normal:
        normal(Expr)
        Simplifies the expression.
        See also: 1/ simplify 
        Ex1:normal(2*x+y=1)
        Ex2:normal(2*x*2)
        Ex3:normal((2*x+1)^2)
        
        '''

     def normal_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normal_cdf:
        normal_cdf(Real(mu),Real(sigma),Real(x0),[Real(y0)])
        Returns the probability that a Normal random variable is less than x0 or between x0 and y0 (mu is the mean and sigma the standard deviation).
        See also: 1/ UTPN 2/ normal_icdf 3/ normald 
        Ex1:normal_cdf(1.96)
        Ex2:normal_cdf(1,2,2.96*sqrt(2))
        Ex3:normal_cdf(1,2,1.4*sqrt(2),2.96*sqrt(2))
        
        '''

     def normal_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normal_icdf:
        normal_icdf(Real(mu),Real(sigma),Real(p))
        Returns h such as the probability that a Normal random variable is less than h is p (mu is the mean and sigma the standard deviation and 0<=p<=1).
        See also: 1/ normal_cdf 2/ normald 
        Ex1:normal_icdf(0.95)
        Ex2:normal_icdf(1,2,0.95)
        
        '''

     def normald(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normald:
        normald(Real(mu),Real(sigma),Real(x0))
        Returns the probability density of the Normal law (mu is the mean and sigma the standard deviation).
        See also: 1/ normal_cdf 2/ normal_icdf 3/ randvector 4/ ranm 
        Ex1:normald(1)
        Ex2:normald(1,2,3.5)
        Ex3: randvector(3,normald,1,0.5)
        Ex4: ranm(4,3,normald,1,0.5)
        
        '''

     def normald_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normald_cdf:
        normald_cdf(Real(mu),Real(sigma),Real(x0),[Real(y0)])
        Returns the probability that a Normal random variable is less than x0 or between x0 and y0 (mu is the mean and sigma the standard deviation).
        See also: 1/ UTPN 2/ normal_icdf 3/ normald 
        Ex1:normald_cdf(1.96)
        Ex2:normald_cdf(1,2,2.96*sqrt(2))
        Ex3:normald_cdf(1,2,1.4*sqrt(2),2.96*sqrt(2))
        
        '''

     def normald_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normald_icdf:
        normald_icdf(Real(mu),Real(sigma),Real(p))
        Returns h such as the probability that a Normal random variable is less than h is p (mu is the mean and sigma the standard deviation and 0<=p<=1).
        See also: 1/ normal_cdf 2/ normald 
        Ex1:normald_icdf(0.95)
        Ex2:normald_icdf(1,2,0.95)
        
        '''

     def normalize(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normalize:
        normalize(Lst||Cplx||Audio)
        Returns the vector divided by its l2norm or normalizes an audio clip. It is also an option for plotfield.
        See also: 1/ l2norm 
        Ex1:normalize(3+4*i)
        Ex2:normalize([3,4])
        Ex3: fieldplot(-t*y,[t,y],normalize)
        Ex4: fieldplot(-t*y,[t,y],normalize,xstep=0.5,ystep=0.5)
        
        '''

     def normalt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normalt:
        normalt(Lst,Real,[Real],Fnc,[Real])
        Z-Test/normal law: arg1=[success,trial] or [mean,sample size] or data, arg2=proportion or data, arg3 optional if data=sigma, arg4 alternative '!=' or '>' or '<', arg5 optional alpha confidence level.
        See also: 1/ studentt 2/ chisquaret 3/ kolmogorovt 
        Ex1:normalt([10,30],.5,.02,'!=',0.1)
        Ex2:normalt([0.48,50],0.5,0.1,'<')
        
        '''

     def normalvariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for normalvariate:
        normalvariate(Real(mu),Real(sigma))
        Returns a random real with normal distribution N(mu,sigma).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randpoisson 8/ randgeometric 9/ randmultinomial 
        Ex1:normalvariate(0,1)
        Ex2:normalvariate(2,1)
        
        '''

     def nprimes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nprimes:
        nprimes(Intg(n))
        Counts the number of primes less than n.
        See also: 1/ ithprime 2/ prevprime 3/ nextprime 4/ isprime 
        Ex1:nprimes(20)
        
        '''

     def nrows(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nrows:
        nrows(Mtrx)
        Number of rows of a matrix.
        See also: 1/ ncols 
        Ex1:nrows([[1,2,3],[4,5,6]])
        Ex2:nrows([[1,2],[3,4],[5,6]])
        
        '''

     def nstep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nstep:
        nstep(Opt)
        Option for plotting commands.
        
        '''

     def nuage_points(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nuage_points:
        nuage_points(Mtrx)
        Draws for k=0..nrows, the points (xk,yk) where xk=element row k column 0 and yk=element row k column j (j=1..ncols).
        See also: 1/ polygonplot 2/ polygonscatterplot 3/ listplot 
        Ex1:nuage_points([[1,2,3],[2,0,1],[-1,2,3]])
        
        '''

     def nullspace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for nullspace:
        nullspace(Mtrx)
        Kernel of a linear map with matrix M.
        See also: 1/ image 2/ rref 3/ Nullspace 
        Ex1:nullspace([[1,2],[3,6]])
        Ex2:nullspace([[1,2,3],[1,3,6],[2,5,9]])
        
        '''

     def number_of_edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for number_of_edges:
        number_of_edges(Graph(G))
        Returns the number of edges/arcs in G.
        See also: 1/ edges 2/ number_of_vertices 
        Ex1:number_of_edges(complete_graph(5))
        
        '''

     def number_of_spanning_trees(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for number_of_spanning_trees:
        number_of_spanning_trees(Graph(G))
        Returns the number of spanning trees in an undirected graph G.
        See also: 1/ spanning_tree 
        Ex1:number_of_spanning_trees(complete_graph(4))
        Ex2:number_of_spanning_trees(graph(trail(1,2,3,4,1,3)))
        
        '''

     def number_of_triangles(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for number_of_triangles:
        number_of_triangles(Graph(G))
        Returns the number of 3-cliques if G is undirected resp. the number of directed cycles on 3 vertices if G is directed.
        See also: 1/ is_clique 2/ maximal_clique 
        Ex1:number_of_triangles(graph("tetrahedron"))
        
        '''

     def number_of_vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for number_of_vertices:
        number_of_vertices(Graph(G))
        Returns the number of vertices in G.
        See also: 1/ graph_vertices 2/ number_of_edges 
        Ex1:number_of_vertices(graph("petersen"))
        
        '''

     def numdiff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for numdiff:
        numdiff(Lst(X),Lst(Y),Real(x0),[Intg(n)])
        Returns an approximation of the n-th derivative (n>=0, by default n=1) of the function f given by f(X_i)=Y_i at point x0.
        See also: 1/ nDeriv 2/ diff 
        Ex1:numdiff([1,3,4],[3,0,1],2)
        Ex2: f:=unapply(sin(x)*exp(-x),x):;X:=[0,0.1,0.2,0.4,0.5,0.7,0.8,1]:;Y:=apply(f,X):;abs(numdiff(X,Y,1/pi,2)-f''(1/pi))
        
        '''

     def numer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for numer:
        numer(Frac(a/b) or RatFrac)
        Returns the numerator of the simplified fraction.
        See also: 1/ getNum 2/ getDenom 3/ denom 4/ f2nd 
        Ex1:numer(25/15)
        Ex2:numer((x^3-1)/(x^2-1))
        Ex3:numer(1+(x^3-1)/x^2)
        
        '''

     def octahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for octahedron:
        octahedron(Pnt(A),Pnt(B),Pnt(C))
        Draws an octahedron with center A, vertex B and such that the plane ABC contains 4 vertices.
        See also: 1/ icosahedron 2/ dodecahedron 3/ cube 4/ tetrahedron 
        Ex1:octahedron([0,0,0],[0,0,5],[0,5,0])
        Ex2:octahedron(evalf([0,0,0],[3,2,4],[1,1,0]))
        
        '''

     def odd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for odd:
        odd(Intg(n))
        Returns 1 if the integer is odd, else returns 0.
        See also: 1/ even 
        Ex1:odd(6)
        Ex2:odd(1251)
        
        '''

     def odd_girth(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for odd_girth:
        odd_girth(Graph(G))
        Returns the length of a shortest odd cycle in an undirected unweighted graph G.
        See also: 1/ girth 
        Ex1:odd_girth(graph("petersen"))
        Ex2:odd_girth(hypercube_graph(3))
        
        '''

     def odd_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for odd_graph:
        odd_graph(Intg(n))
        Returns the odd graph of order n as Kneser graph K(2n-1,n-1), where n<=8.
        See also: 1/ kneser_graph 
        Ex1:odd_graph(3)
        
        '''

     def odeplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for odeplot:
        odeplot(Expr,VectVar,VectInitCond)
        plotode(f(t,y),[t,y],[t0,y0]) draws the solution of y'=f(t,y) and y(t0)=y0 or of the system [x'=g(t,x,y),y'=h(t,x,y)] with x(t0)=x0 and y(t0)=y0.
        See also: 1/ interactive_plotode 2/ fieldplot 3/ odesolve 4/ desolve 
        Ex1:odeplot(sin(t*y),[t,y],[0,1])
        Ex2:odeplot(sin(t*y),[t=-10..10,y],[0,1])
        Ex3:odeplot(sin(t*y),[t=-3..3,y],[0,1],tstep=0.1,color=vert)
        Ex4:odeplot([x-0.3*x*y, 0.3*x*y-y], [t,x,y],[0,0.3,0.7])
        Ex5:odeplot([x-0.3*x*y, 0.3*x*y-y], [t,x,y],[0,0.3,0.7],plan)
        Ex6:odeplot([-y+b,-1+(x-a)^2+(y-b)^2],[t=-3..3,x,y],[0,a+1,b+0.5],plan)
        Ex7:odeplot(5*[-y,x],[t=0..1,x,y],[0,0.3,0.7],tstep=0.05,plan)
        
        '''

     def odesolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for odesolve:
        odesolve(Expr,VectVar,VectInitCond,FinalVal,[tstep=Val,curve])
        odesolve(f(t,y),[t,y],[t0,y0],t1)=odesolve(t0..t1,f,y0)=y(t1) for y approx sol of y'=f(t,y) and y(t0)=y0 with y=vector for systems.
        See also: 1/ plotode 2/ plotfield 3/ interactive_plotode 4/ desolve 
        Ex1:odesolve(sin(t*y),[t,y],[0,1],2)
        Ex2:odesolve(0..2,(t,y)->sin(t*y),1)
        Ex3:odesolve(0..pi,(t,v)->{[-v[1],v[0]]},[0,1])
        Ex4:odesolve(sin(t*y),t=0..2,y,1,tstep=0.5)
        Ex5:odesolve(sin(t*y),t=0..2,y,1,tstep=0.5,curve)
        
        '''

     def olive(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for olive:
        olive(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def op(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for op:
        op(Op or Fnc)
        Returns the arguments of an operator as a sequence.
        See also: 1/ sommet 2/ quote 3/ makesuite 
        Ex1:op(quote(gcd(45,126)))
        Ex2:op('gcd(45,126)')
        Ex3:op('1+2')[1]
        Ex4:op([1,2,3])
        Ex5:op(set[1,2,3])
        
        '''

     def open_polygon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for open_polygon:
        open_polygon(LstPnt||LstCplx)
        Returns and draws the polygonal line where its vertices are the element of l.
        See also: 1/ isopolygon 2/ quadrilateral 
        Ex1:open_polygon(i,1+i,2-i,-1,-1+i/2)
        Ex2:open_polygon(point(0,0,0),point(3,3,3),point(0,0,3),point(3,0,0))
        
        '''

     def orange(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for orange:
        orange(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def ord(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ord:
        ord(Char||LstChar)
        Returns the ASCII code of a character or of the first character of a string.
        See also: 1/ asc 2/ char 
        Ex1:ord("A")
        Ex2:ord("ABC")
        Ex3:ord(["a","b","c"])
        
        '''

     def order(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for order:
        order(g)
        Returns element order of g in (Z/nZ)^* or in a finite field.
        Ex1:order(3 % 7)
        Ex2: GF(3,5,g); order(g^2+g+1);
        
        '''

     def order_size(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for order_size:
        order_size(Expr)
        Remainder (O term) of a series expansion: limit(x^a*order_size(x),x=0)=0 if a>0.
        See also: 1/ series 
        Ex1:order_size(x)
        Ex2: limit(sqrt(x)*order_size(x),x=0)
        
        '''

     def ordinate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ordinate:
        ordinate(Pnt or Vect)
        Returns the ordinate of a point or a vector.
        See also: 1/ abscissa 2/ affix 3/ cote 4/ coordinates 
        Ex1:ordinate(point(1+2*i))
        Ex2:ordinate(point(i)-point(1+2*i))
        Ex3:ordinate(-1-i)
        Ex4:ordinate(point(1,2,3))
        
        '''

     def orthocenter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for orthocenter:
        orthocenter((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        Shows the orthocenter of a triangle or of the triangle made with 3 points.
        See also: 1/ altitude 2/ triangle 
        Ex1:orthocenter(1+i,2,i)
        Ex2:orthocenter(point(1+i),point(2),point(i))
        Ex3:orthocenter(triangle(0,1,1+i))
        
        '''

     def orthogonal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for orthogonal:
        orthogonal((Pnt),(Line or Plan))
        orthogonal(A,line(B,C)) draws the orthogonal plane of line BC through A and orthogonal(A,plane(B,C,D)) draws the orthogonal line of plane(B,C,D) through A.
        See also: 1/ altitude 2/ perpendicular 
        Ex1:orthogonal(point(0,0,0),line(point(1,0,0),point(0,1,0)))
        Ex2:orthogonal(point(0,0,0),plane(point(1,0,0),point(0,1,0),point(0,0,1)))
        
        '''

     def osculating_circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for osculating_circle:
        osculating_circle(Curve,Point)
        Osculating circle at point M to the curve C.
        See also: 1/ curvature 2/ evolute 
        Ex1:osculating_circle(plot(x^2),point(1,1))
        Ex2:osculating_circle([5*cos(t),5*sin(t)],t,0)
        Ex3:osculating_circle([t,t^2],t)
        Ex4:osculating_circle([t,t^2],t,1)
        Ex5:osculating_circle([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t)
        Ex6:osculating_circle([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t,7)
        
        '''

     def p1oc2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for p1oc2:
        p1oc2(Permut,Cycle)
        Returns the permutation product of p1 and c2.
        See also: 1/ c1op2 2/ p1op2 
        Ex1:p1oc2([0,2,1],[2,1,3])
        
        '''

     def p1op2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for p1op2:
        p1op2(Permut,Permut)
        Returns the permutation product of p1 and p2.
        See also: 1/ c1op2 2/ p1oc2 
        Ex1:p1op2([0,2,1],[1,0,3,2])
        
        '''

     def pa2b2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pa2b2:
        pa2b2(Intg(n))
        Returns [a,b] such that a^2+b^2=n (for n prime and n=1 (mod 4)).
        Ex1:pa2b2(17)
        Ex2:pa2b2(209)
        Ex3:pa2b2(229)
        
        '''

     def pade(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pade:
        pade(Expr(Xpr), Var(x), (Intg(n) || Poly(N)), Intg(p))
        Pade approximation P/Q=Xpr mod x^(n+1) or mod N with degree(P)<p.
        See also: 1/ taylor 2/ series 
        Ex1:pade(exp(x),x,10,6)
        
        '''

     def paley_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for paley_graph:
        paley_graph(Intg(p),[Intg(k)])
        Returns the Paley (di)graph on p^k vertices, where p>2 is prime and k>0.
        See also: 1/ graph 
        Ex1:paley_graph(3,2)
        Ex2:paley_graph(3,3)
        
        '''

     def parabola(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parabola:
        parabola(Pnt(F)||Pnt(xA+i*yA),Pnt(A)||Real(c),[Pnt(P)])
        parabola(F,A)=focus F, top A (in the plane ABP) or (parabola(A,c) of equa. y=yA+c*(x-xA)^2 c=1/(2*p) and FA=p/2 geo2d) and parabola(P(x,y)) draws the conic if deg(P)=2.
        See also: 1/ ellipse 2/ hyperbola 
        Ex1:parabola(point(0),point(2))
        Ex2:parabola(0,2)
        Ex3:parabola(point(0,0,0),point(1,0,0),point(1,1,1))
        Ex4:parabola(x-y^2+y-2)
        
        '''

     def parallel(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parallel:
        parallel(Pnt or Line,Line or Plan,[Line])
        parallel(A,D) (resp parallel(A,P) or parallel(A,D,DD)) draws the line (resp plane) through A parallel to the line D (resp parallel to the plane P or to the lines D,DD) and parallel(d,D) draws the plane through d parallel to the line D.
        See also: 1/  
        Ex1:parallel(1+i,line(1-i,i))
        Ex2:parallel(1+i,segment(1-i,i))
        Ex3:parallel(point([1,1,1]),line(x=0,y=0))
        Ex4:parallel([1,1,1],line(x=0,y=0))
        Ex5:parallel([1,1,1],plane(x=0))
        Ex6:parallel([1,0,0],line(x=0,y=0),line(x=y,y=z))
        Ex7:parallel(line(x=y,y=z),line(x=0,y=0))
        
        '''

     def parallelepiped(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parallelepiped:
        parallelepiped(Pnt(A),Pnt(B),Pnt(C),Pnt(D))
        Draws a parallelepiped with sides AB,AC,AD (the faces are parallelograms).
        See also: 1/ cube 2/ polyhedron 
        Ex1:parallelepiped([0,0,0],[2,0,0],[0,1,0],[0,0,3])
        Ex2: p:=parallelepiped([0,0,0],[5,0,0],[0,3,0],[0,0,2]);c1,c2,c3,c4,c5,c6,c7,c8:=sommets(p);
        
        '''

     def parallelogram(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parallelogram:
        parallelogram(Pnt(A)||Cplx,Pnt(B)||Cplx,Pnt(C)||Cplx,[Var(D)])
        Returns and draws the parallelogram ABCD such that vector(AB)+vector(AD)=vector(AC).
        See also: 1/ quadrilateral 2/ rhombus 
        Ex1:parallelogram(0,1,2+i)
        Ex2:parallelogram(1,0,2+i,D)
        Ex3:parallelogram(point(0,0,0),point(3,3,3),point(0,0,3))
        Ex4:parallelogram(point(0,0,0),point(3,3,3),point(0,0,3),D)
        
        '''

     def parameq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parameq:
        parameq(GeoObj)
        parameq(C) returns the complex number=parametric equation of the curve C.
        See also: 1/ equation 
        Ex1:parameq(circle(0,1))
        Ex2:parameq(line(i,1-i))
        
        '''

     def parameter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parameter:
        parameter()
        Reserved word.
        See also: 1/  
        
        '''

     def paramplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for paramplot:
        paramplot(Cplx||Lst,Var||Lst(Var))
        plotparam(a(x)+i*b(x),x=x0..x1) draws the curve X=a(x),Y=b(x) x=x0..x1 or plotparam([a(u,v),b(u,v),c(u,v)],[u=u0..u1,v=v0..v1]) draws the surface X=a(u,v),Y=b(u,v),Z=c(u,v) u=u0..u1 and v=v0..v1.
        See also: 1/ plotfunc 2/ plotpolar 3/ arc 
        Ex1:paramplot(sin(t)+i*cos(t),t)
        Ex2:paramplot(exp(i*t),t=0..pi/2,affichage=1)
        Ex3:paramplot(exp(i*t),t=0..pi/2,affichage=1+rempli)
        Ex4:paramplot([sin(x),cos(x)],x=0..1)
        Ex5:paramplot([sin(x),cos(x)],x=0..1,affichage=rouge)
        Ex6:paramplot(sin(x)+i*cos(x),x=0..1,tstep=0.01)
        Ex7:paramplot([v*cos(u),v*sin(u),v],[u,v])
        Ex8:paramplot([v*cos(u),v*sin(u),v],[u=0..pi,v=0..3],ustep=0.1,vstep=0.2)
        
        '''

     def parfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parfrac:
        parfrac(Opt)
        Option of the convert or convertir command (id at the option partfrac).
        See also: 1/ convert 
        Ex1: convert(1/(x^2-1),parfrac)
        Ex2: convert(1/(x^2-1),fullparfrac)
        
        '''

     def pari(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pari:
        pari(Str,arguments)
        Executes a PARI/GP command or exports all PARI/GP commands.
        See also: 1/ gcd 2/ lgcd 3/ is_prime 
        Ex1:pari()
        Ex2:pari("gcd",15,50)
        Ex3:pari("gcd",5/7,50/9)
        Ex4:pari("gcd", 3,[25,15,50,75])
        Ex5:pari("gcd", [2,3],[25,15,50,75])
        Ex6:pari("content",[25,15,50,75])
        Ex7:pari("isprime",9856989898997789789,1)
        Ex8:pari("isprime",9856989898997789789,2)
        
        '''

     def part(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for part:
        part(Expr, Intg(n))
        Returns the n-th subexpression of the expression.
        See also: 1/  
        Ex1:part(sin(x)+cos(x),1)
        Ex2:part(sin(x)+cos(x),2)
        Ex3:part(exp(x)*sin(x),1)
        Ex4:part(part(exp(x)*sin(x)+cos(x),1),1)
        
        '''

     def partfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for partfrac:
        partfrac(RatFrac or Opt)
        Performs partial fraction decomposition on a fraction or option of the convert or convertir command (id at the option parfrac).
        See also: 1/ factor 2/ normal 3/ convert 4/ propfrac 
        Ex1:partfrac(x/(4-x^2))
        Ex2:partfrac((x^2-2*x+3)/(x^2-3*x+2))
        Ex3:partfrac(a/(z*(z-b)),z)
        Ex4: convert(x/(4-x^2),partfrac)
        
        '''

     def parzen_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for parzen_window:
        parzen_window(Lst,[Interval(n1..n2)])
        Applies the Parzen windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ bartlett_hann_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(parzen_window(randvector(1000,0..1)))
        
        '''

     def pas_de_cote(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pas_de_cote:
        pas_de_cote(NULL or Real(n))
        The turtle does n side-steps to the left (-n steps to the right if n negative) without trace (by default n=10).
        See also: 1/ saute 2/ tourne_droite 3/ tourne_gauche 
        Ex1: pas_de_cote 30
        Ex2:pas_de_cote(30)
        
        '''

     def path_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for path_graph:
        path_graph(Intg(n)||Lst(V))
        Returns a path graph on n vertices [with labels from V].
        See also: 1/ cycle_graph 2/ graph 3/ trail 
        Ex1:path_graph(5)
        
        '''

     def pcar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pcar:
        pcar(Mtrx,[Var])
        List of the coefficients of the characteristic polynomial of a matrix or characteristic polynomial of a matrix with the second argument as variable.
        See also: 1/ jordan 2/ egv 3/ egvl 4/ companion 5/ rat_jordan 6/ pmin 7/ adjoint_matrix  
        Ex1:pcar([[1,2],[3,4]])
        Ex2:pcar([[1,2],[3,4]],x)
        Ex3:pcar([[1,2,3],[1,3,6],[2,5,7]])
        Ex4:pcar([[1,2,3],[1,3,6],[2,5,7]],z)
        
        '''

     def pcar_hessenberg(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pcar_hessenberg:
        pcar_hessenberg(Mtrx,[Var])
        Characteristic polynomial of a matrix by the Hessenberg method (if the coefficients are in a finite field).
        See also: 1/ jordan 2/ pcar 3/ egvl 
        Ex1:pcar_hessenberg([[1,2],[3,4]])
        Ex2:pcar_hessenberg([[1,2],[3,4]],x)
        Ex3:pcar_hessenberg([[1,2,3],[1,3,6],[2,5,7]])
        
        '''

     def pcoef(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pcoef:
        pcoef(Vect)
        Returns the polynomial coefficients having the roots specified as argument.
        See also: 1/ proot 2/ peval 
        Ex1:pcoef([1,0,0,0,1])
        Ex2:pcoef([1,0,-2])
        
        '''

     def pcoeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pcoeff:
        pcoeff(Vect)
        Returns the polynomial coefficients having the roots specified as argument.
        See also: 1/ proot 2/ peval 
        Ex1:pcoeff([1,0,0,0,1])
        Ex2:pcoeff([1,0,-2])
        
        '''

     def pencolor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pencolor:
        pencolor(Color)
        Changes the color of the pencil (without parameter, returns the current color).
        See also: 1/ leve_crayon 2/ baisse_crayon 
        Ex1: crayon vert
        Ex2:pencolor(rouge)
        Ex3:pencolor(5)
        Ex4:pencolor(gomme)
        
        '''

     def pendown(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pendown:
        pendown(NULL)
        Presses the pencil down so that the turtle move with traces.
        See also: 1/ leve_crayon 2/ crayon 
        Ex1:pendown()
        
        '''

     def penup(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for penup:
        penup(NULL)
        Lifts the pencil up so that the turtle moves without traces.
        See also: 1/ baisse_crayon 2/ crayon 
        Ex1:penup()
        
        '''

     def perimeter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perimeter:
        perimeter(Polygone)
        Perimeter of a polygon (e.g. triangle, square, ...)
        See also: 1/ polygon 2/ area 3/ perimeteratraw 4/ perimeterat 
        Ex1:perimeter(triangle(0,1,i))
        Ex2:perimeter(square(0,2))
        Ex3:perimeter(circle(0,2))
        Ex4:perimeter(0,1,i)
        
        '''

     def perimeterat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perimeterat:
        perimeterat(Polygone, Pnt||Cplx(z0))
        Displays at point(z0), with a legend, the perimeter of a circle or of a polygon (e.g. triangle, square, ...)
        See also: 1/ perimeter 2/ perimeteratraw 2/ polygon 3/ areaatraw 
        Ex1: t:=triangle(0,1,i);perimeterat(t,1+i)
        Ex2: c:=square(0,2);perimeterat(c,1+i)
        Ex3: c2:=circle(0,2);perimeterat(c2,1+i)
        Ex4: p:=polygon(0,1,i);perimeterat(p,1+i)
        Ex5: A:=point(0);B:=point(1+i);c:=carre(A,B);perimeterat(c,i)
        
        '''

     def perimeteratraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perimeteratraw:
        perimeteratraw(Polygone, Pnt||Cplx(z0))
        Displays at point(z0), the perimeter of a circle or of a polygon (e.g. triangle, square, ...)
        See also: 1/ perimeter 2/ perimeterat 3/ polygon 4/ areaatraw 
        Ex1:perimeteratraw(triangle(0,1,i),1+i)
        Ex2:perimeteratraw(square(0,2),1+i)
        Ex3:perimeteratraw(circle(0,2),1+i)
        Ex4:perimeteratraw(polygon(0,1,i),1+i)
        Ex5: A:=point(0);B:=point(1+i);c:=carre(A,B);perimeteratraw(c,i)
        
        '''

     def period(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for period:
        period(Expr,[Var])
        Returns a period of a given periodic expression with respect to a single real variable (by default x).
        See also: 1/ periodic 
        Ex1:period(sin(x*pi/2)/(2+cos(x*pi/3+pi/4)))
        Ex2:period(sin(x)+sin(sqrt(2)*x),x)
        Ex3: f:=periodic(x^2,x,0,3):;g:=periodic(x^3,x,-1,1):;period(f*g/(1+f^2+g^2),x)
        
        '''

     def periodic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for periodic:
        periodic(Expr,Var,Real(a),Real(b)||Expr,Var=a..b)
        Returns the periodic expression equal to Expr on a..b, period b-a.
        See also: 1/ period 
        Ex1:periodic(x^2,x=-1..1)
        Ex2: plot(periodic(x^2,x,-1,1),x=-5..5)
        
        '''

     def perm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perm:
        perm(Intg(n),Intg(p))
        perm(n,p)=number of arrangements of p objects taken among n : n!/(n-p)!
        See also: 1/ comb 2/ factorial 
        Ex1:perm(4,2)
        
        '''

     def perminv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perminv:
        perminv(Permut(a))
        Returns the inverse permutation of the permutation a.
        See also: 1/ cycleinv 
        Ex1:perminv([1,3,2,4,0])
        
        '''

     def permu2cycles(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for permu2cycles:
        permu2cycles(Permut)
        Converts a permutation to a product of disjoint cycles.
        See also: 1/  cycles2permu 2/ cycle2perm 
        Ex1:permu2cycles([0,2,1,3,5,4])
        Ex2:permu2cycles([0,2,1,4,3,5])
        
        '''

     def permu2mat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for permu2mat:
        permu2mat(Permut(p))
        Returns the matrix where the lines of the identity matrix are permuted with the permutation p.
        See also: 1/  
        Ex1:permu2mat([1,3,2,4,0])
        
        '''

     def permuorder(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for permuorder:
        permuorder(Permut(a))
        Returns the order of the permutation a.
        See also: 1/ cycles2permu 
        Ex1:permuorder([1,3,2,4,0])
        
        '''

     def permute_vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for permute_vertices:
        permute_vertices(Graph(G),Lst(V))
        Returns a copy of G with vertices reordered according to the order in V.
        See also: 1/ graph_vertices 2/ isomorphic_copy 3/ relabel_vertices 
        Ex1:permute_vertices(graph([a,b,c]),[a,c,b])
        
        '''

     def perpen_bisector(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perpen_bisector:
        perpen_bisector((Pnt or Cplx),(Pnt or Cplx))
        perpen_bisector(A,B) draws the bisector (line or plane) of the segment AB.
        See also: 1/ midpoint 2/ median_line 
        Ex1:perpen_bisector(1-i,i)
        Ex2:perpen_bisector([0,0,0],[5,5,0])
        
        '''

     def perpendicular(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for perpendicular:
        perpendicular((Pnt or Line),(Line or Plan))
        perpendicular(A,line(B,C)) or perpendicular(A,B,C) draws the orthogonal line of line BC through A and perpendicular(d,plane(B,C,D)) draws the orthogonal plane of plane(B,C,D) through the line d.
        See also: 1/ altitude 2/ orthogonal 
        Ex1:perpendicular(1,line(1,i))
        Ex2:perpendicular(1,0,1+i)
        Ex3:perpendicular([0,0,0],line(x=y,y=z))
        Ex4:perpendicular(line([0,0,0],[1,1,0]),plane(x+y+z=1))
        
        '''

     def petersen_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for petersen_graph:
        petersen_graph(Intg(n),[Intg(k)])
        Returns the generalized Petersen graph G(n,k), where n and k are positive integers (k defaults to 2).
        See also: 1/ graph 
        Ex1:petersen_graph(5,2)
        Ex2:petersen_graph(6,3)
        Ex3:petersen_graph(10,2)
        
        '''

     def peval(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for peval:
        peval(Vect,Real(x0))
        Evaluates at a point x0, a polynomial given by its coefficients.
        See also: 1/ proot 2/ pcoeff 
        Ex1:peval([1,0,-2],1)
        Ex2:peval([1,2,-25,-26,120],8)
        
        '''

     def pi(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pi:
        pi()
        pi.
        See also: 1/ e 2/ i 
        Ex1: pi/4
        Ex2: Pi/4
        Ex3: evalf(pi)
        Ex4: evalf(Pi)
        
        '''

     def pie(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pie:
        pie(Mtrx)
        Draws pie chart of a one variable statistical series.
        See also: 1/ bar_plot 
        Ex1:pie([["France",6],["Allemagne",12],["Suisse",5]])
        Ex2:pie([3/2,2/3,5/4,4/5,7/6,6/7,9/8,8/9,11/10])
        Ex3:pie([[2,"xyz","abc"],["A",2,5],["B",5,6],["C",7,7]])
        
        '''

     def piecewise(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for piecewise:
        piecewise(Cond1,Expr1,..,Cond2p,Expr2p,[Expr2p+1])
        If condition1 returns expr1 else...if condition2p returns expr2p else returns expr2p+1.
        See also: 1/ if 2/ then 3/ else 4/ ifte 5/ switch 
        Ex1:piecewise(x<=-pi,x+2*pi,x<=pi,x,x+2*pi)
        Ex2:piecewise(x<-2,-2,x<-1,3x+4,x<0,1,x+1)
        
        '''

     def pink(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pink:
        pink(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def pivot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pivot:
        pivot(Mtrx(A),Intg(nl),Intg(nc))
        Returns the matrix obtained from A by creating zeros in the column nc, by the method of Gauss-Jordan with the element A[nl,nc] as pivot.
        See also: 1/ gaussjord 2/ linsolve 
        Ex1:pivot([[1,2],[3,4],[5,6]],0,1)
        Ex2:pivot([[1,2],[3,4],[5,6]],1,1)
        
        '''

     def pixoff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pixoff:
        pixoff(Real(x),Real(y))
        Pixel off.
        See also: 1/ set_pixel 2/ pixon 
        Ex1:pixoff(1,2)
        
        '''

     def pixon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pixon:
        pixon(Real(x),Real(y))
        Pixel on.
        See also: 1/ set_pixel 2/ pixoff 
        Ex1:pixon(1,2)
        
        '''

     def planar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for planar:
        planar(Opt)
        Option for the draw_graph command.
        See also: 1/ spring 2/ tree 3/ draw_graph 
        
        '''

     def plane(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plane:
        plane(Pnt or Eq, [Pnt or Line],[Pnt])
        plane(A,B,C) or plane(A,line(B,C)) (resp plane(a*x+b*y+c*z+d=0)) draws the plane ABC (resp of equation a*x+b*y+c*z+d=0) in 3D space.
        See also: 1/ line 
        Ex1:plane([0,0,0],[1,1,1],[1,0,0])
        Ex2:plane([0,0,0],line([1,0,0],[1,1,1]))
        Ex3:plane(x+y+z=0)
        Ex4:plane(2*x+y-2*z-1)
        
        '''

     def plane_dual(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plane_dual:
        plane_dual(Graph(G)||Lst(F))
        Returns the plane dual of a biconnected planar graph G or constructs it from the list F of its faces.
        See also: 1/ is_planar 
        Ex1:plane_dual(hypercube_graph(3))
        
        '''

     def playsnd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for playsnd:
        playsnd(Vect)
        Plays a sound data.
        See also: 1/ readwav 2/ writewav 3/ soundsec 
        Ex1:playsnd(2^14*(sin(2*pi*440*soundsec(1)))
        
        '''

     def plex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plex:
        plex(Opt)
        Option of the gbasis or greduce command to specify an order for monomials (=default order=pure lexicographic).
        See also: 1/ gbasis 2/ greduce 
        
        '''

     def plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plot:
        plot((Expr or LstExpr),Var[=VarMin..VarMax],[color=LstColor])
        Plots a one-variable expression (or list of expressions).
        See also: 1/ plotfunc 2/ plotparam 3/ animate 4/ animate3d 5/ plotarea 
        Ex1:plot(x-1/6*x^3,x)
        Ex2:plot([2*x-1,sin(x)],x=1..2)
        Ex3:plot(sin(x),x=-2..2,color=green,xstep=0.1)
        Ex4:plot([2*x-2,2*sin(x)],x=1..2,color=[green,red],legende=["2x-2","sin"])
        Ex5:plot(exponentiald(2))
        Ex6:plot(normald)
        Ex7:plot(normald(-1,2))
        
        '''

     def plot3d(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plot3d:
        plot3d(Expr||Lst(3*Expr),Var,Var)
        Erases and plots a 2 variable expression or of a surface defined with a list of the 3 functions or of 3 expression of 2 variables.
        See also: 1/ plotfunc 2/ animate3d 
        Ex1:plot3d(x^2+y^2+1,x,y)
        Ex2:plot3d(x^2+y^2,x=-1..1,y=-2..2)
        Ex3:plot3d([u+1,2*v,u^2+v^2],u=-1..1,v=-2..2)
        Ex4:plot3d(f,-1..1,-2..2)
        Ex5:plot3d([f,g,h],-1..1,-2..2)
        
        '''

     def plotarea(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotarea:
        plotarea(Expr,x=a..b,[n],[Method])
        Displays the area below a curve, optionally with a quadrature method (trapezoid,left_rectangle,right_rectangle,middle_point).
        See also: 1/ integrate 2/ plot 3/ area 4/ areaat 5/ areaatraw 
        Ex1:plotarea(sin(x),x=0..pi)
        Ex2:plotarea(x^2,x=0..1,5,trapezoid)
        Ex3:plotarea(x^2,x=0..1,5,middle_point)
        
        '''

     def plotcdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotcdf:
        plotcdf(Func,FuncParams)
        Graphic representation of a cumulative distribution function.
        See also: 1/ icdf 2/ binomial_cdf 3/ normald_cdf 4/ cdf 
        Ex1:plotcdf(binomial,10,0.5)
        Ex2:plotcdf(normald,0.0,1.0)
        Ex3:plotcdf([1,3,4,3,5,6])
        
        '''

     def plotcontour(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotcontour:
        plotcontour(Expr(Xpr),[LstVar],[LstVal])
        Draws 11 equirepartited contour-lines z=z_min,,...z=z_max of the surface z=Xpr, or the contour-lines defined by the 3-rd argument.
        See also: 1/ plotdensity 2/ plotimplicit 
        Ex1:plotcontour(x^2+y^2)
        Ex2:plotcontour(x^2+y^2,[x,y])
        Ex3:plotcontour(x^2+2*y^2-2,[x,y],[1.0,2.0,3.0])
        Ex4:plotcontour(x^2-y^2,[x=-4..4,y=-4..4],seq(k,k,-11,11,3),xstep=0.1,ystep=0.1)
        
        '''

     def plotdensity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotdensity:
        plotdensity(Expr,[x=xrange,y=yrange],[z],[xstep],[ystep])
        Shows in the plane with colors the graph of an expression of 2 variables.
        See also: 1/ plotfunc 2/ plotcontour 
        Ex1:plotdensity(x^2-y^2,[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1)
        Ex2:plotdensity(x^2-y^2,[x=-2..2,y=-2..2],z=-2..2,xstep=0.1,ystep=0.1)
        
        '''

     def plotfield(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotfield:
        plotfield(Expr,VectVar,[Opt])
        plotfield(f(t,y),[t,y]) draws the plotfield of the diff equation y'=f(t,y).
        See also: 1/ interactive_plotode 2/ odeplot 3/ odesolve 4/ desolve 
        Ex1:plotfield(sin(t*y),[t=-5..5,y=-3..3],xstep=0.5,ystep=0.5)
        Ex2:plotfield(-t*y,[t,y])
        Ex3:plotfield(-t*y,[t,y],normalize)
        Ex4:plotfield(-t*y,[t,y],normalize,xstep=0.5,ystep=0.5)
        Ex5:plotfield(-t*y,[t=-6.868..6.868,y=-6.868..6.868],normalize)
        
        '''

     def plotfunc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotfunc:
        plotfunc(Expr,[Var(x) or VectVar] ,[Intg(color)])
        Plots a 1 variable or 2 variables expression with superposition.
        See also: 1/ plot 2/ plot3d 3/ plotparam 4/ animate 5/ animate3d 6/ plotdensity 
        Ex1:plotfunc(-2*x+1,x=1..2,color=red)
        Ex2:plotfunc([-2*x+1,x^2-2],x=-2..2,color=[red,yellow],xstep=0.2)
        Ex3:plotfunc(x^2-y^2,[x,y],xstep=0.5,ystep=0.3)
        Ex4:plotfunc(x^2+y^2,[x=-1..1,y=-2..2],nstep=900)
        Ex5:plotfunc((x+i*y)^2,[x=-1..1,y=-2..2],nstep=900,affichage=rempli)
        
        '''

     def plotimf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotimf:
        plotimf(Lst(imf),[opts])
        Displays selected intrinsic mode functions in a stacked layout.
        See also: 1/ emd 
        Ex1:plotimf(emd(apply(x->cos(10*x^2*pi),linspace(-pi,pi)),residue=false))
        
        '''

     def plotimplicit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotimplicit:
        plotimplicit(Expr,Var1,Var2)
        plotimplicit(f(x,y),x,y) or plotimplicit(f(x,y),[x,y]) draws graph of f(x,y)=0.
        See also: 1/ plotcontour 2/ unfactored 3/ plotinequation 
        Ex1:plotimplicit(x^2+y^2-1,x,y)
        Ex2:plotimplicit(x^4+y^4=x^2-y^2)
        Ex3:plotimplicit(x^2+y^2-1,x,y,unfactored)
        Ex4:plotimplicit(x^2+4*y^3-1)
        Ex5:plotimplicit(x^2+4*y^3-k)$(k=-5..5)
        Ex6:plotimplicit(y^3=x^3-x^2,x,y,xstep=0.1,ystep=0.1)
        Ex7:plotimplicit(y^3=x^3-x^2,[x,y],xstep=0.1,ystep=0.1)
        Ex8:plotimplicit((x+5)^2+(y+4)^2-1,x=-6..-4,y=-5..-3)
        Ex9:plotimplicit((x+5)^2+(y+4)^2-1,[x=-6..-4,y=-5..-3])
        
        '''

     def plotinequation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotinequation:
        plotinequation(Expr,[x=xrange,y=yrange],[xstep],[ystep])
        Shows the graph of the solutions of inequalities with 2 variables.
        See also: 1/ plotfunc 2/ plotcontour 3/ plotdensity 4/ plotimplicit 
        Ex1:plotinequation(x^2-y^2<3)
        Ex2:plotinequation(x^2-y^2<3,[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1)
        Ex3:plotinequation(3-(x^2-y^2),[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1)
        Ex4:plotinequation([x+y>3,x^2<y],[x,y],xstep=0.2,ystep=0.2)
        
        '''

     def plotlist(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotlist:
        plotlist(Lst(l)||Mtrx(M))
        Draws the polygonal line through the points with abscissas 0,...,n and ordinates l=[y0,...,yn] or the line through the points with abscissas the first column of M and ordinates the second column.
        See also: 1/ polygonplot 2/ scatterplot 3/ polygonscatterplot 
        Ex1:plotlist([13,10,15,16])
        Ex2:plotlist([1,13],[2,10],[3,15],[4,16])
        Ex3:plotlist([[0,13],[2,10],[4,15]])
        
        '''

     def plotode(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotode:
        plotode(Expr,VectVar,VectInitCond)
        plotode(f(t,y),[t,y],[t0,y0]) draws the solution of y'=f(t,y) and y(t0)=y0 or of the system [x'=g(t,x,y),y'=h(t,x,y)] with x(t0)=x0 and y(t0)=y0.
        See also: 1/ interactive_plotode 2/ fieldplot 3/ odesolve 4/ desolve 
        Ex1:plotode(sin(t*y),[t,y],[0,1])
        Ex2:plotode(sin(t*y),[t=-10..10,y],[0,1])
        Ex3:plotode(sin(t*y),[t=-3..3,y],[0,1],tstep=0.1,color=vert)
        Ex4:plotode([x-0.3*x*y, 0.3*x*y-y], [t,x,y],[0,0.3,0.7])
        Ex5:plotode([x-0.3*x*y, 0.3*x*y-y], [t,x,y],[0,0.3,0.7],plan)
        Ex6:plotode([-y+b,-1+(x-a)^2+(y-b)^2],[t=-3..3,x,y],[0,a+1,b+0.5],plan)
        Ex7:plotode(5*[-y,x],[t=0..1,x,y],[0,0.3,0.7],tstep=0.05,plan)
        
        '''

     def plotparam(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotparam:
        plotparam(Cplx||Lst,Var||Lst(Var))
        plotparam(a(x)+i*b(x),x=x0..x1) draws the curve X=a(x),Y=b(x) x=x0..x1 or plotparam([a(u,v),b(u,v),c(u,v)],[u=u0..u1,v=v0..v1]) draws the surface X=a(u,v),Y=b(u,v),Z=c(u,v) u=u0..u1 and v=v0..v1.
        See also: 1/ plotfunc 2/ plotpolar 3/ arc 
        Ex1:plotparam(sin(t)+i*cos(t),t)
        Ex2:plotparam(exp(i*t),t=0..pi/2,affichage=1)
        Ex3:plotparam(exp(i*t),t=0..pi/2,affichage=1+rempli)
        Ex4:plotparam([sin(x),cos(x)],x=0..1)
        Ex5:plotparam([sin(x),cos(x)],x=0..1,affichage=rouge)
        Ex6:plotparam(sin(x)+i*cos(x),x=0..1,tstep=0.01)
        Ex7:plotparam([v*cos(u),v*sin(u),v],[u,v])
        Ex8:plotparam([v*cos(u),v*sin(u),v],[u=0..pi,v=0..3],ustep=0.1,vstep=0.2)
        
        '''

     def plotpolar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotpolar:
        plotpolar(Expr,Var,VarMin,VarMax)
        plotpolar(f(x),x,a,b) draws the polar curve r=f(x) for x in [a,b].
        See also: 1/ plotparam 2/ plotfunc 3/ plotpolar 
        Ex1:plotpolar(sin(2*x),x,0,pi)
        Ex2:plotpolar(sin(2*x),x,0,pi,tstep=0.1)
        
        '''

     def plotproba(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotproba:
        plotproba(Matrix,[Vector])
        Graph of a transition matrix with at most 7x7 entries (optionally with list of vertex positions).
        See also: 1/ markov 2/ randmarkov 
        Ex1:plotproba([[1/2,1/3,1/12,1/12],[1/3,1/2,1/6,0],[0,0,1/2,1/2],[1/4,1/4,1/4,1/4],["xy",b,"state",d]])
        Ex2:plotproba([[1/2,1/3,1/12,1/12],[1/3,1/2,1/6,0],[0,0,1/2,1/2],[1/4,1/4,1/4,1/4]],[0,1,i,1/3+2/3*i])
        Ex3: L:=point(1):;C:=point(0.5+0.3*i):;G:=point(0.5+0.8*i):;plotproba([[1/2,1/3,1/12],[1/3,1/2,1/6],[0,0,1/2]],[L,C,G])
        
        '''

     def plotseq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotseq:
        plotseq(Expr(f(Var)),Var=[a,xm,xM],Intg(p))
        For seeing the pth terms of the sequence u(0)=a,u(n)=f(u(n-1)).
        See also: 1/ seqsolve 2/ rsolve 
        Ex1:plotseq(sqrt(2+x),6,5)
        Ex2:plotseq(sqrt(2+t),t=6,5)
        Ex3:plotseq(sqrt(2+x),x=[6,1,7],5,affichage=epaisseur_ligne_2)
        
        '''

     def plotspectrum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotspectrum:
        plotspectrum(Audio(clip),[range=a..b])
        Plots the power spectrum of an audio clip (on the specified frequency range).
        See also: 1/ plotwav 
        Ex1:plotspectrum(readwav("/some/file"))
        Ex2:plotspectrum(readwav("/some/file"),range=100..1000)
        
        '''

     def plotwav(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plotwav:
        plotwav(Audio(clip),[range=a..b])
        Plots the waveform of an audio clip (optionally at the specified range).
        See also: 1/ plotspectrum 
        Ex1:plotwav(readwav("/some/file"))
        Ex2:plotwav(readwav("/some/file"),range=1.0..2.5) // range in seconds
        Ex3:plotwav(readwav("/some/file"),range=[10000,22000]) // range in samples
        
        '''

     def plus_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for plus_point:
        plus_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def pmin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pmin:
        pmin(Mtrx(A)||Real(a),[Var])
        Returns the minimal polynomial of the matrix A or the minimal polynomial of the algebraic number a.
        See also: 1/ pcar 2/ jordan 
        Ex1:pmin((αλγεβρική αριθμού).)
        Ex2:pmin([[1,0],[0,1]])
        Ex3:pmin([[1,0],[0,1]],x)
        Ex4:pmin(sqrt(2)+sqrt(3))
        Ex5:pmin(sqrt(2)+sqrt(3),x)
        
        '''

     def point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for point:
        point(Cplx(za)||Vect)
        A:=point(za) or A:=point(a,b) (resp A:=point([a,b,c])) draws a point with affix za=a+ib (resp of coordinates (a,b,c)) with the legend A.
        See also: 1/ pixon 2/ line 3/ point2d 4/ point3d 5/ polar_point 
        Ex1:point(1+2i)
        Ex2:point(1,2)
        Ex3:point(1,2,3)
        Ex4:point([1,2,3])
        Ex5: B:=point(1-i)
        Ex6: B:=point(1,-1)
        Ex7: B:=point(1,0,0)
        Ex8: B:=point([1,0,0])
        
        '''

     def point2d(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for point2d:
        point2d(SeqVar(A,B,C...))
        Defines at random, the coordinates (between -5 and +5) of the 2d points given as argument.
        See also: 1/ point3d 2/ point 
        Ex1:point2d(A,B,C,D)
        
        '''

     def point3d(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for point3d:
        point3d(SeqVar(A,B,C...))
        Defines at random, the coordinates (between -5 and +5) of the 3d points given as argument.
        See also: 1/ point2d 2/ point 
        Ex1:point3d(A,B,C,D)
        
        '''

     def poisson(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for poisson:
        poisson(Real(mu),Intg(k))
        Returns exp(-mu)*mu^k/k!
        See also: 1/ poisson_cdf 2/ poisson_icdf 3/ randvector 4/ ranm 
        Ex1:poisson(0.5,2)
        Ex2:poisson(4.0,2)
        Ex3: randvector(3,poisson,0.5)
        Ex4: ranm(4,3,poisson,0.5)
        
        '''

     def poisson_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for poisson_cdf:
        poisson_cdf(Real(mu),Real(x))
        Returns Proba(X<=x) when X follows the Poisson law with mu as mean.
        See also: 1/ poisson 2/ poisson_icdf 
        Ex1:poisson_cdf(4.0,7)
        Ex2:poisson_cdf(poisson_cpdf(2.5,4))
        
        '''

     def poisson_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for poisson_icdf:
        poisson_icdf(Real(mu),Real(p))
        Returns h such as Proba(X<=h)=p when X follows the Poisson law with mu as parameter.
        See also: 1/ poisson 2/ poisson_cdf 
        Ex1:poisson_icdf(4.0,0.95)
        Ex2:poisson_icdf(2.5,0.9)
        
        '''

     def poisson_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for poisson_window:
        poisson_window(Lst,[Real(a)],[Interval(n1..n2)])
        Applies the Poisson windowing function with parameter a>0 (by default a=1) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ bartlett_hann_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(poisson_window(randvector(1000,0..1),0.5))
        
        '''

     def polar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polar:
        polar(Crcle,Pnt or Cplxe(A))
        Returns the line of the conjugated points of A with respect to the circle.
        See also: 1/ pole 2/ is_conjugate 
        Ex1:polar(circle(0,1),point(1+i)/2)
        Ex2:polar(circle(0,1),point(1+i))
        
        '''

     def polar_coordinates(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polar_coordinates:
        polar_coordinates(Pnt or Cplx or LstRectCoord)
        Returns the list of the norm and of the argument of the affix of a point (for 2D) or of a complex number or of the the list of rectangular coordinates.
        See also: 1/ abscissapoint 2/ ordinate 3/ rectangular_coordinates 4/ polar_point 
        Ex1:polar_coordinates(point(1+2*i))
        Ex2:polar_coordinates(-1-i)
        Ex3:polar_coordinates([-1,2])
        Ex4:polar_coordinates(point(1+2*i)-point(-1+i))
        
        '''

     def polar_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polar_point:
        polar_point(Real(r),Real(t))
        Returns the point (for 2D) with the arguments r and t as polar coordinates (i.e. with r*exp(i*t) as affix).
        See also: 1/ abscissa 2/ ordinate 3/ polar_coordinates 4/ rectangular_coordinates 5/ point 
        Ex1:polar_point(1,pi/4)
        Ex2:polar_point(2,-pi/3)
        
        '''

     def polarplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polarplot:
        polarplot(Expr,Var,VarMin,VarMax)
        plotpolar(f(x),x,a,b) draws the polar curve r=f(x) for x in [a,b].
        See also: 1/ plotparam 2/ plotfunc 3/ plotpolar 
        Ex1:polarplot(sin(2*x),x,0,pi)
        Ex2:polarplot(sin(2*x),x,0,pi,tstep=0.1)
        
        '''

     def pole(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pole:
        pole(Crcle,Line)
        Returns the point having the line as polar with respect to the circle .
        See also: 1/ polar 2/ is_conjugate 
        Ex1:pole(circle(0,1),line(i,1))
        Ex2:pole(circle(0,1),line((1+i),2))
        
        '''

     def poly2symb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for poly2symb:
        poly2symb(Lst,Var)
        Gives the polynomial (or its value) : the first argument is the vector of coefficients and the second argument is the variable (by default x).
        See also: 1/ e2r 2/ symb2poly 
        Ex1:poly2symb([1,2,3])
        Ex2:poly2symb([1,2,3],x)
        Ex3:poly2symb([1,2,3],-1)
        Ex4:poly2symb([1,2,-1],y)
        
        '''

     def polyEval(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polyEval:
        polyEval(Vect,Real(x0))
        Evaluates at a point x0, a polynomial given by its coefficients.
        See also: 1/ proot 2/ pcoeff 
        Ex1:polyEval([1,0,-2],1)
        Ex2:polyEval([1,2,-25,-26,120],8)
        
        '''

     def polygon(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polygon:
        polygon(LstPnt||LstCplx)
        Returns and draws the polygon where its vertices are the elements of l.
        See also: 1/ isopolygon 2/ quadrilateral 3/ convexhull 4/ hexagon 
        Ex1:polygon(i,1+i,2-i,-1,-1+i/2)
        Ex2:polygon(point(0,0,0),point(3,3,3),point(0,0,3),point(3,0,0))
        
        '''

     def polygone_rempli(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polygone_rempli:
        polygone_rempli(Intg(n))
        The argument is an integer <-1 which gives the number of previous turtle positions drawing a polygon and created this full polygon.
        See also: 1/  
        Ex1: repete(4,avance 40,tourne_droite);polygone_rempli -8
        Ex2: repete(3,avance 40,tourne_droite 120);polygone_rempli -6
        Ex3: repete(3,avance 40,avance 40,tourne_droite 120);polygone_rempli -9
        
        '''

     def polygonplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polygonplot:
        polygonplot(Mtrx)
        Draws the polygons joining for j fixed and for k=0..nrows, the points (xk,yk) where xk=element row k column 0 and yk=element row k column j, after the xk are sorted (we obtain ncols-1 polygons).
        See also: 1/ scatterplot 2/ listplot 3/ polygonscatterplot 
        Ex1:polygonplot([[1,2,3],[2,0,1],[-1,2,3]])
        
        '''

     def polygonscatterplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polygonscatterplot:
        polygonscatterplot(Mtrx)
        Draws the points (xk,yk) and the polygons joining for j fixed and for k=0..nrows, the points (xk,yk) where xk=element row k column 0 et yk=element row k column j, after the xk are sorted (we obtain ncols-1 polygons).
        See also: 1/ scatterplot 2/ polygonplot 3/ listplot 
        Ex1:polygonscatterplot([[1,2,3],[2,0,1],[-1,2,3]])
        
        '''

     def polyhedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polyhedron:
        polyhedron(SeqPnt(A,B,C...))
        Draws a convex polyhedron with vertices among the arguments.
        See also: 1/ cube 2/ parallelepiped 
        Ex1:polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6])
        
        '''

     def polynom(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polynom:
        polynom(Opt)
        Option of the convert or convertir command and of the taylor and series commands (list=>n-poly or series=>poly).
        See also: 1/ poly2symb 2/ taylor 3/ series 4/ convert 
        Ex1: convert([[10,[3,1]],[12,[2,2]]],polynom)
        Ex2: convert(taylor(sin(x)),polynom)
        Ex3: convert(series(sin(x),x=0,6),polynom)
        Ex4: taylor(sin(x),x=0,5,polynom)
        Ex5: series(sin(x),x=0,6,,polynom)
        
        '''

     def polynomial_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polynomial_regression:
        polynomial_regression(Lst||Mtrx(A),[Lst],Intg(n))
        Returns the coefficients (an,...a1,a0) of y=an*x^n+..a1x+a0 : it is the best polynomial which approx the points where the coordinates are the rows of A (or the 2 lists) (n is the 2nd argument).
        See also: 1/ linear_regression 2/ power_regression 
        Ex1:polynomial_regression([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]],3)
        Ex2:polynomial_regression([[0.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]],3)
        Ex3:polynomial_regression([0.0,2.0,3.0,4.0],[1.0,4.0,9.0,16.0],3)
        
        '''

     def polynomial_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for polynomial_regression_plot:
        polynomial_regression_plot(Lst||Mtrx(A),[Lst],Intg(n))
        Returns the plot of y=an*x^n+..a1x+a0 : it is the best polynomial which approx the points where the coordinates are the rows of A (or the 2 lists) (n is the 2nd argument).
        See also: 1/ linear_regression_plot 2/ power_regression_plot 
        Ex1:polynomial_regression_plot([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]],3)
        Ex2:polynomial_regression_plot([[0.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]],3)
        Ex3:polynomial_regression_plot([0.0,2.0,3.0,4.0],[1.0,4.0,9.0,16.0],3)
        
        '''

     def position(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for position:
        position(NULL or LstCoord)
        Returns the turtle position in pixels or puts the turtle at the position given by the argument with the same direction.
        See also: 1/ cap 2/ initialise 
        Ex1:position()
        Ex2:position(50,70)
        Ex3:position([50,70])
        
        '''

     def poslbdLMQ(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for poslbdLMQ:
        poslbdLMQ(Poly(P))
        Returns a lower bound on the values of the positive roots of P. Akritas-Strzebonski-Vigklas' Local Max Quadratic (LMQ) method is used.
        See also: 1/ posubLMQ 2/ VAS_positive 3/ realroot 
        Ex1:poslbdLMQ(x^3-7*x+7)
        
        '''

     def posubLMQ(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for posubLMQ:
        posubLMQ(Poly(P))
        Returns an upper bound on the values of the positive roots of P. Akritas-Strzebonski-Vigklas' Local Max Quadratic (LMQ) method is used.
        See also: 1/ poslbdLMQ 2/ VAS_positive 3/ realroot 
        Ex1:posubLMQ(x^3-7*x+7)
        
        '''

     def potential(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for potential:
        potential(Vect(V),VectVar)
        Returns U such that derive(U,Vector_of_variable)=V.
        See also: 1/ derive 2/ vpotential 
        Ex1:potential([2*x*y+3,x^2-4*z,-4*y],[x,y,z])
        
        '''

     def pow2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pow2exp:
        pow2exp(Expr)
        Converts powers to exponentials.
        See also: 1/ exp2pow 
        Ex1:pow2exp(a^b)
        
        '''

     def power_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for power_regression:
        power_regression(Lst|Mtrx(A),[Lst])
        Returns the coefficients (m,b) of y=b*x^m : it is the best monomial which approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ polynomial_regression 2/ linear_regressiont 
        Ex1:power_regression([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex2:power_regression([[1.0,2.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex3:power_regression([1.0,2.0,3.0,4.0],[2.0,4.0,9.0,16.0])
        
        '''

     def power_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for power_regression_plot:
        power_regression_plot(Lst||Mtrx(A),[Lst])
        Returns the plot of y=b*x^m : it is the best monomial which approx the points where the coordinates are the rows of A (or the 2 lists).
        See also: 1/ polynomial_regression_plot 2/ linear_regression_plot 
        Ex1:power_regression_plot([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex2:power_regression_plot([[1.0,2.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]])
        Ex3:power_regression_plot([1.0,2.0,3.0,4.0],[2.0,4.0,9.0,16.0])
        
        '''

     def powermod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for powermod:
        powermod(Intg(a),Intg(n),Intg(p),[Expr(P(x))],[Var])
        Computes a^n modulo p or modulo p,P(x) (fast algorithm).
        See also: 1/ pow 2/ ^ 
        Ex1:powermod(17,452,19)
        Ex2:powermod(x+1,452,19,x^4+x+1,x)
        
        '''

     def powerpc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for powerpc:
        powerpc(Cercle,Pnt or Cplx)
        Returns the real number d^2-R^2 (d=distance between point and center, R=radius).
        See also: 1/ radical_axis 
        Ex1:powerpc(circle(0,1+i),3+i)
        Ex2:powerpc(circle(0,point(1+i)),3+i)
        
        '''

     def powexpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for powexpand:
        powexpand(Expr)
        Expands the expression as a function of the exponent.
        See also: 1/  
        Ex1:powexpand(2^(x+y))
        Ex2:powexpand(3^(2*x))
        
        '''

     def powmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for powmod:
        powmod(Intg(a),Intg(n),Intg(p),[Expr(P(x))],[Var])
        Computes a^n modulo p or modulo p,P(x) (fast algorithm).
        See also: 1/ pow 2/ ^ 
        Ex1:powmod(17,452,19)
        Ex2:powmod(x+1,452,19,x^4+x+1,x)
        
        '''

     def prepend(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for prepend:
        prepend(Lst||Set||Str(L),Elem(n))
        Adds an element to a set or at the beginning of a list or of a string (L:=prepend(L,a) or L.prepend(a)).
        See also: 1/ append 2/ concat 
        Ex1:prepend([1,2],3)
        Ex2:prepend(set[1,2],3)
        Ex3: L:=[1,2];L:=prepend(L,3)
        Ex4: L:=[1,2];L.prepend(L,3) 
        Ex5: S:=set[1,2];S:=prepend(L,3)
        Ex6: S:=set[1,2];S.prepend(L,3)
        
        '''

     def preval(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for preval:
        preval(Expr(F(Var)),Real(a),Real(b),[Var])
        Returns F(b)-F(a).
        See also: 1/ subst 2/ int 
        Ex1:preval(x^2-2,2,3)
        Ex2:preval(y^2-2,2,3,y)
        Ex3:preval(int(x),0,1)
        Ex4:preval(int(y,y),0,1,y)
        
        '''

     def prevperm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for prevperm:
        prevperm(Intg(n))
        Returns the previous permutation with the lexicographic order.
        See also: 1/ nextperm 2/ is_permu 
        Ex1:prevperm([0,1,3,2])
        Ex2:prevperm([0,1,2,3])
        
        '''

     def prevprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for prevprime:
        prevprime(Intg(a))
        Previous prime or pseudo-prime before a given integer a.
        See also: 1/ nextprime 2/ is_prime 3/ ithprime 
        Ex1:prevprime(9856989898999)
        Ex2:prevprime(97160249868928888261606009)
        
        '''

     def primpart(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for primpart:
        primpart(Poly(P),[Var])
        Returns the polynomial P divided by the gcd of its coefficients.
        See also: 1/ content 
        Ex1:primpart(2x^2+10x+6)
        Ex2:primpart(2t^2+10t+6,t)
        
        '''

     def printf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for printf:
        printf(Expr)
        2d printing.
        See also: 1/ print 
        Ex1:printf(sqrt(2))
        Ex2:printf("%gen+%gen=%gen",a,b,a+b)
        
        '''

     def prism(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for prism:
        prism(LstPnt([A,B,C,D]),Pnt(A1))
        Draws a prism with plane base ABCD...and with edges parallel to AA1 (the faces are parallelograms).
        See also: 1/ cube 2/ polyhedron 
        Ex1:prism([[0,0,0],[5,0,0],[0,5,0],[-5,5,0]],[0,0,5])
        
        '''

     def prism_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for prism_graph:
        prism_graph(Intg(n))
        Returns the generalized Petersen graph GP(n,1).
        See also: 1/ antiprism_graph 2/ web_graph 
        Ex1:prism_graph(5)
        
        '''

     def product(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for product:
        product(Expr||Lst,[Var||Lst],[Intg(a)],[Intg(b)],[Intg(p)])
        Multiplies the values of the expression when the variable go from a to b with a step p (product(expression,var,begin,end,step) by default p=1) or product of the elements of a list or product element by element of 2 lists or matrices.
        See also: 1/ sum 
        Ex1:product(n,n,1,10,2)
        Ex2:product(1/n,n,1,10)
        Ex3:product(1/n,n,11,1)
        Ex4:product(1/n,n,10,1,1)
        Ex5:product([2,3,4,5])
        Ex6:product([2,3,4],[5,6,7])
        Ex7:product([[2,3,4],[5,6,7]],[[2,3,4],[5,6,7]])
        
        '''

     def projection(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for projection:
        projection(Curve,Pnt)
        projection(C,A) is the orthogonal projection of A on the curve C.
        See also: 1/ perpendicular 
        Ex1: H:=projection(line(i,1-i),1+i)
        Ex2: K:=projection(circle(0,1),1+i)
        Ex3: J:=projection(circle(0,1),point(1+2*i))
        
        '''

     def proot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for proot:
        proot(Vect||Poly,[Intg(n)])
        Returns all computed roots of a polynomial given by its coefficients (may not work if roots are not simple).
        See also: 1/ pcoeff 2/ peval 3/ realroot 4/ complexroot 5/ rationalroot 6/ crationalroot 
        Ex1:proot([1,0,-2])
        Ex2:proot(x^2-2)
        Ex3:proot([1,2,-25,-26,120])
        Ex4:proot(x^4+5x-3,30)
        
        '''

     def propFrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for propFrac:
        propFrac(Frac or RatFrac)
        Simplifies and writes the fraction (or rational fraction) A/B as Q+R/B with R<B (or deg(R)<deg(B)).
        See also: 1/ partfrac 
        Ex1:propFrac(28/12)
        Ex2:propFrac((x^2+2*x-1)/(x+1))
        
        '''

     def propfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for propfrac:
        propfrac(Frac or RatFrac)
        Simplifies and writes the fraction (or rational fraction) A/B as Q+R/B with R<B (or deg(R)<deg(B)).
        See also: 1/ partfrac 
        Ex1:propfrac(28/12)
        Ex2:propfrac((x^2+2*x-1)/(x+1))
        
        '''

     def pruefer_code(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pruefer_code:
        pruefer_code(Vect(S)|Graph(T))
        Returns the Pruefer code for a tree graph T or converts a Pruefer sequence S into the corresponding tree.
        See also: 1/ is_tree 
        Ex1:pruefer_code([5,6,0,4,1,2,10,3,8,11]) // xcas mode
        Ex2:pruefer_code(graph(%{[1,8],[2,3],[2,7],[4,6],[5,6],[6,7],[6,8],[7,9],[8,10]%}))
        
        '''

     def psrgcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for psrgcd:
        psrgcd(Poly,Poly)
        GCD of 2 polynomials, with the sub resultant algorithm.
        See also: 1/ gcd 2/ modgcd 3/ ezgcd 4/ heugcd 
        Ex1:psrgcd(x^4-1,(x-1)^2)
        
        '''

     def ptayl(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ptayl:
        ptayl(Expr||Poly(P(Var)),Var=Real || Real(a),[Order || Var])
        Returns the Taylor polynomial of the expression at the given point and order or a polynomial Q such that P(x)=Q(x-a).
        See also: 1/ series 2/ taylor 
        Ex1:ptayl(sin(x),x=0,5)
        Ex2:ptayl(x^2+2*x+1,1)
        Ex3:ptayl(x^2+2*x+1,-1)
        Ex4:ptayl(y^2+2*y+1,1.1,y)
        Ex5:ptayl(y^3+y^2+2*y+1,2,y)
        Ex6: subst(ptayl(y^3+y^2+2*y+1,2,y),y,y-2)
        
        '''

     def purge(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for purge:
        purge(Var)
        purge(varname) unassigns the variable varname.
        See also: 1/ sto 2/ restart 3/ assume 4/ about 
        Ex1:purge(t)
        Ex2:purge(C)
        
        '''

     def purple(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for purple:
        purple(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def pwd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pwd:
        pwd(NULL)
        Current working directory.
        See also: 1/ cd 
        Ex1:pwd()
        
        '''

     def pyramid(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for pyramid:
        pyramid(Pnt(A),Pnt(B),Pnt(C),[Pnt(D)])
        Draws the regular direct pyramid ABCD with vertices A,B and a face in the plane (A,B,C) when there is 3 arguments and the pyramid ABCD when there are 4 arguments.
        See also: 1/ cube 2/ cylinder 3/ icosahedron 4/ dodecahedron 5/ octahedron 
        Ex1:pyramid([0,0,0],[3,0,0],[0,1,0])
        Ex2:pyramid([0,0,0],[3,0,0],[0,3,0],[0,0,4])
        
        '''

     def python_compat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for python_compat:
        python_compat(Intg(0) or 1)
        Sets Python-syntax compatibility (1) or not (0).
        See also: 1/ xcas_mode 
        Ex1:python_compat()
        Ex2:python_compat(1)
        
        '''

     def q2a(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for q2a:
        q2a(QuadraForm, VectVar)
        q2a(q(x,y),[x,y])=the symmetric matrix associated to the quadratic form q.
        See also: 1/ a2q 
        Ex1:q2a(x^2+2*x*y+2*y^2,[x,y])
        
        '''

     def qr(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for qr:
        qr(Mtrx)
        For a numerical matrix A, returns R (right) such that A=QR and Q orthogonal.
        See also: 1/ lu 
        Ex1:qr([[1,2],[3,4]])
        
        '''

     def quadric(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quadric:
        quadric(Expr,[Lst(Var)])
        Defines a quadric by its cartesian equation with x,y,z as default variables and draws it.
        See also: 1/ reduced_quadric 
        Ex1:quadric(4*x^2+y^2+z^2-4*x*y+4*x*z-2*y*z+8*x-4*y+4*z+2)
        Ex2:quadric(x^2+3*y^2-3*z^2-8*y*z+2*z*x-4*x*y-1,x,y,z,affichage=vert+rempli)
        Ex3:quadric((u+v)*(v-w)+3*u-5*v,[u,v,w],affichage=cyan)
        Ex4:quadric(7*x^2+4*y^2+4*z^2+4*x*y-4*x*z-2*y*z-4*x+5*y+4*z-18,[x,y,z])
        
        '''

     def quadrilateral(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quadrilateral:
        quadrilateral(Pnt(A)||Cplx,Pnt(B)||Cplx,Pnt(C)||Cplx,Pnt(D)||Cplx)
        Returns and draws the quadrilateral ABCD.
        See also: 1/ polygon 2/ square 
        Ex1:quadrilateral(i,1+i,2-i,-1)
        Ex2:quadrilateral(point(0,0,0),point(3,3,3),point(0,0,3),point(3,0,0))
        
        '''

     def quantile(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quantile:
        quantile(Lst(l),Real(p))
        Returns the quantile of the elements of l corresponding to p (0<p<1).
        See also: 1/ quartile1 2/ median 3/ quartile3 
        Ex1:quantile([0,1,3,4,2,5,6],0.25)
        Ex2:quantile([0,1,3,4,2,5,6],0.75)
        
        '''

     def quartile1(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quartile1:
        quartile1(Lst||Mtrx,[Lst])
        Returns the 1st quartile of the elements (or of the columns) of its argument.
        See also: 1/ quantile 2/ quartiles 
        Ex1:quartile1([1,2,3,5,10,4])
        Ex2:quartile1([1,2,3,5,10,4],[1,2,3,1,2,3])
        Ex3:quartile1([[1,2],[5,4],[3,6],[7,8]])
        
        '''

     def quartile3(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quartile3:
        quartile3(Lst||Mtrx,[Lst])
        Returns the 3rd quartile of the elements (or of the columns) of its argument.
        See also: 1/ quartiles 2/ quantile 
        Ex1:quartile3([1,2,3,5,10,4])
        Ex2:quartile3([[1,2,3,5,10,4],[2,3,4,4,5,6],[7,6,5,8,9,1]])
        Ex3:quartile3([[1,2],[5,4],[3,6],[7,8]])
        
        '''

     def quartiles(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quartiles:
        quartiles(Lst||Mtrx,[Lst])
        Min,1st quartile,the median,3rd quartile, max of the elements (or of the columns) of its argument.
        See also: 1/ boxwhisker 2/ quantile 3/ mean 
        Ex1:quartiles([1,2,3,5,10,4])
        Ex2:quartiles([1,2,3,5,10,4],[1,2,3,5,10,4])
        Ex3:quartiles([[1,2],[5,4],[3,6],[7,8]])
        
        '''

     def quest(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quest:
        quest(Intg(n))
        Returns the (n+1)th question of the command history if n>=0 or, the (-n)th previous question if n<0 (by default n=-1 for the previous question).
        See also: 1/ ans 
        Ex1:quest()
        Ex2:quest(2)
        Ex3:quest(-2)
        
        '''

     def quo(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quo:
        quo((Vect or Poly),(Vect or Poly),[Var])
        Euclidean quotient of 2 polynomials.
        See also: 1/ rem 2/ quorem 3/ Quo 4/ iquo 
        Ex1:quo([1,2,3,4],[-1,2])
        Ex2:quo(x^3+2x^2+3x+4,-x+2)
        Ex3:quo(t^3+2t^2+3t+4,-t+2,t)
        
        '''

     def quorem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quorem:
        quorem((Vect or Poly),(Vect or Poly),[Var])
        Euclidean quotient and remainder of 2 polynomials.
        See also: 1/ rem 2/ quo 3/ iquorem 
        Ex1:quorem([1,2,3,4],[-1,2])
        Ex2:quorem(x^3+2x^2+3x+4,-x+2)
        Ex3:quorem(t^3+2t^2+3t+4,-t+2,t)
        Ex4:quorem(t^4-1,(t+1)^2,t)
        
        '''

     def quote(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for quote:
        quote(Expr)
        Returns its argument unevaluated (and also a:=quote(a) purges a).
        See also: 1/  
        Ex1:quote(1+2)
        Ex2:quote(1/x+1/(x-1))
        Ex3:quote((x+1)*(x-1))
        
        '''

     def r2e(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for r2e:
        r2e(Lst,Var)
        Gives the polynomial (or its value) : the first argument is the vector of coefficients and the second argument is the variable (by default x).
        See also: 1/ e2r 2/ symb2poly 
        Ex1:r2e([1,2,3])
        Ex2:r2e([1,2,3],x)
        Ex3:r2e([1,2,3],-1)
        Ex4:r2e([1,2,-1],y)
        
        '''

     def radians(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for radians:
        radians(Real(deg))
        Converts degrees to radians (inexact).
        See also: 1/ degrees 
        
        '''

     def radical_axis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for radical_axis:
        radical_axis(Crcle,Crcle)
        Returns the line of points with same powerpc with respect to the 2 circles.
        See also: 1/ powerpc 
        Ex1:radical_axis(circle(0,1+i),circle(1,1+i))
        Ex2:radical_axis(circle(0,point(1+i)),circle(1,point(1+i)))
        
        '''

     def radius(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for radius:
        radius(Crcle)
        radius(C) gives the radius of the circle C.
        See also: 1/ center 2/ circle 
        Ex1:radius(incircle(-1,1-i,i))
        
        '''

     def ramene(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ramene:
        ramene(Str(fich_name))
        Reads variables and their values from the file fich_name.
        See also: 1/ write 2/ readrgb 3/ readwav 4/ csv2gen 
        Ex1:ramene("toto")
        
        '''

     def rand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rand:
        rand(Intg(n) or Interval(p..n) or NULL,[Intg(b1) or Lst(L)],[Intg(b2)])
        rand(n)=a random integer (resp rand(p,n)=a real or rand(p..n)=a real function) with uniform distribution in 0..n-1 (resp in [p;n])(rand()=rand(0,1)=a real in [0,1[) or rand(n,b1,b2)=n integers between b1 and b2 or rand(n,L)=list of n elements of L.
        See also: 1/ srand 2/ randpoly 3/ ranm 4/ randvector 5/ hasard 
        Ex1:rand(4)
        Ex2:rand()
        Ex3:rand(0,2)
        Ex4:rand(0..2)()
        Ex5: f:=rand(0..2)
        Ex6:rand(3,1,10)
        Ex7:rand(3,["r","r","r","b","n"])
        Ex8: L:=["r","r","r","b","n"];L3:=rand(L,3)
        Ex9: L:=["r","r","r","b","n"];L3:=L.rand(3)
        Ex10: L:=["r","r","r","b","n"];a:=rand(L)
        Ex11: L:=["r","r","r","b","n"];a:=L.rand()
        
        '''

     def randMat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randMat:
        randMat(Intg(n), [Intg(m)],[Interval or quote(DistribLaw)])
        Returns a list of size n or an n*m matrix that contains random integers in the range -99 through 99 with uniform distribution or contains random numbers according to the law put between quotes.
        See also: 1/ idn 2/ randPoly 3/ rand 4/ randvector 
        Ex1:randMat(3)
        Ex2:randMat(3,2)
        Ex3:randMat(3,2,6)
        Ex4:randMat(3,2,binomial,10,0.3)
        Ex5:randMat(3,2,multinomial,[1/2,1/3,1/6])
        Ex6:randMat(3,2,poisson,5.2)
        Ex7:randMat(3,2,normald,0,1)
        Ex8:randMat(3,2,exp,7/2)
        Ex9:randMat(3,2,poisson,1.2)
        Ex10:randMat(3,2,'rand(3)')
        Ex11:randMat(3,2,1..2)
        Ex12:randMat(3,5,multinomial,[1/2,1/3,1/6],["R","V","B"])
        Ex13: GF(2,8,g);ranm(3,3,g)
        
        '''

     def randNorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randNorm:
        randNorm(Real(mu),Real(sigma))
        Returns a random real with normal distribution N(mu,sigma).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randpoisson 8/ randgeometric 9/ randmultinomial 
        Ex1:randNorm(0,1)
        Ex2:randNorm(2,1)
        
        '''

     def randPoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randPoly:
        randPoly([Var(Var)],Intg(n),[law])
        Returns a polynomial with variable var (or x), of degree n and where the coefficients are random integers in the range -99 through 99 with uniform distribution or according to a law.
        See also: 1/ ranm 2/ randvector 
        Ex1:randPoly(5)
        Ex2:randPoly(t,8)
        Ex3:randPoly(t,8,-1..1)
        Ex4:randPoly([x,y],[10,3])
        Ex5:randPoly([x,y],[10,3],1 mod 7)
        Ex6: GF(2,8,g);randpoly(t,8,g);randpoly([x,y],[2,3],g)
        
        '''

     def randbetad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randbetad:
        randbetad(Real(a),Real(b))
        Returns a random real according to the Beta distribution with parameters a>0 and b>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:randbetad(1,2)
        Ex2:randbetad(1.5,4)
        
        '''

     def randbinomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randbinomial:
        randbinomial(Intg(n),Real(p))
        Returns a random integer with binomial distribution B(n,p) i.e. the number of successes in n independant tests where for each test, the success of probability is p.
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randnorm 7/ randpoisson 8/ randgeometric 9/ randmultinomial 
        Ex1:randbinomial(10,0.4)
        Ex2:randbinomial(100,0.8)
        
        '''

     def randchisquare(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randchisquare:
        randchisquare(Intg(n))
        Returns a random integer with chi^2 distribution, χ^2(n).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randnorm 8/ randgeometric 9/ randmultinomial 
        Ex1:randchisquare(5)
        Ex2:randchisquare(2)
        
        '''

     def randexp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randexp:
        randexp(Real(a))
        Returns a random real according to the exponential distribution with parameter a>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:randexp(1)
        Ex2:randexp(2)
        
        '''

     def randfisher(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randfisher:
        randfisher(Intg(n),Intg(m))
        Returns a random integer with Fisher-Snedecor distribution F(n,m).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randnorm 8/ randgeometric 9/ randmultinomial 
        Ex1:randfisher(5,2)
        Ex2:randfisher(2,4)
        
        '''

     def randgammad(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randgammad:
        randgammad(Real(a),Real(b))
        Returns a random real according to the Gamma distribution with parameters a>0 and b>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:randgammad(1,2)
        Ex2:randgammad(1.5,4)
        
        '''

     def randgeometric(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randgeometric:
        randgeometric(Real(p))
        Returns a random integer following the geometric distribution with parameter p.
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randnorm 7/ randpoisson 8/ randbinomial 9/ randmultinomial 
        Ex1:randgeometric(0.4)
        
        '''

     def randint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randint:
        randint(Intg(n1),Intg(n2))
        randint(n1,n2)=an integer in [n1, n2] or [n2,n1].
        See also: 1/ rand  
        Ex1:randint(1,10)
        Ex2:randint(-1,-10)
        
        '''

     def randmarkov(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randmarkov:
        randmarkov(Mtrx(M) || Vctr(v),Intg(i0),[Intg(n)])
        Returns a random sequence of n states (Markov chain) starting from i0, with probability transition matrix M, or returns a stochastic matrix with p recurrent loops v=[n1,..,np] and i0 transient states.
        See also: 1/ markov 2/ plotproba 
        Ex1:randmarkov([[0,0,1/2,0,1/2],[0,0,1,0,0],[1/4,1/4,0,1/4,1/4],[0,0,1/2,0,1/2],[0,0,0,0,1]],2,20)
        Ex2:randmarkov([1,2,1,3],4)
        
        '''

     def randmatrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randmatrix:
        randmatrix(Intg(n), [Intg(m)],[Interval or quote(DistribLaw)])
        Returns a list of size n or an n*m matrix that contains random integers in the range -99 through 99 with uniform distribution or contains random numbers according to the law put between quotes.
        See also: 1/ idn 2/ randPoly 3/ rand 4/ randvector 
        Ex1:randmatrix(3)
        Ex2:randmatrix(3,2)
        Ex3:randmatrix(3,2,6)
        Ex4:randmatrix(3,2,binomial,10,0.3)
        Ex5:randmatrix(3,2,multinomial,[1/2,1/3,1/6])
        Ex6:randmatrix(3,2,poisson,5.2)
        Ex7:randmatrix(3,2,normald,0,1)
        Ex8:randmatrix(3,2,exp,7/2)
        Ex9:randmatrix(3,2,poisson,1.2)
        Ex10:randmatrix(3,2,'rand(3)')
        Ex11:randmatrix(3,2,1..2)
        Ex12:randmatrix(3,5,multinomial,[1/2,1/3,1/6],["R","V","B"])
        Ex13: GF(2,8,g);ranm(3,3,g)
        
        '''

     def randmultinomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randmultinomial:
        randmultinomial(List(P),[List(K)])
        Returns a random index or list element according to a multinomial distribution probability list P.
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randnorm 7/ randpoisson 8/ randgeometric 9/ randbinomial 
        Ex1:randmultinomial([1/2,1/3,1/6])
        Ex2:randmultinomial([1/2,1/3,1/6],["R","V","B"])
        
        '''

     def randnorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randnorm:
        randnorm(Real(mu),Real(sigma))
        Returns a random real with normal distribution N(mu,sigma).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randpoisson 8/ randgeometric 9/ randmultinomial 
        Ex1:randnorm(0,1)
        Ex2:randnorm(2,1)
        
        '''

     def random(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random:
        random(Intg(n) or Interval(p..n) or NULL,[Intg(b1) or Lst(L)],[Intg(b2)])
        rand(n)=a random integer (resp rand(p,n)=a real or rand(p..n)=a real function) with uniform distribution in 0..n-1 (resp in [p;n])(rand()=rand(0,1)=a real in [0,1[) or rand(n,b1,b2)=n integers between b1 and b2 or rand(n,L)=list of n elements of L.
        See also: 1/ srand 2/ randpoly 3/ ranm 4/ randvector 5/ hasard 
        Ex1:random(4)
        Ex2:random()
        Ex3:random(0,2)
        Ex4:random(0..2)()
        Ex5: f:=rand(0..2)
        Ex6:random(3,1,10)
        Ex7:random(3,["r","r","r","b","n"])
        Ex8: L:=["r","r","r","b","n"];L3:=rand(L,3)
        Ex9: L:=["r","r","r","b","n"];L3:=L.rand(3)
        Ex10: L:=["r","r","r","b","n"];a:=rand(L)
        Ex11: L:=["r","r","r","b","n"];a:=L.rand()
        
        '''

     def random_bipartite_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_bipartite_graph:
        random_bipartite_graph(Intg(n)||Lst(a,b),Real(p)||Intg(m))
        Returns a random undirected unweighted bipartite graph on n vertices where each possible edge is present with probability p or where m edges are created at random. When the first argument is list [a,b] of integers, two groups of vertices with sizes a and b are created.
        See also: 1/ random_digraph 2/ random_graph 3/ random_planar_graph 4/ random_regular_graph 5/ random_sequence_graph 6/ random_tournament 7/ random_tree 
        Ex1:random_bipartite_graph(10,0.5)
        Ex2:random_bipartite_graph([2,3],1.0)
        
        '''

     def random_digraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_digraph:
        random_digraph(Intg(n)||Lst(V),Real(p)||Intg(m))
        Returns a random directed unweighted graph on n vertices (list V of labels may me specified) where two vertices are connected with probability p or where m edges are created at random.
        See also: 1/ random_bipartite_graph 2/ random_graph 3/ random_planar_graph 4/ random_regular_graph 5/ random_sequence_graph 6/ random_tournament 7/ random_tree 
        Ex1:random_digraph(8,0.5)
        Ex2:random_digraph(8,10)
        
        '''

     def random_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_graph:
        random_graph(Intg(n)||Lst(V),Real(p)||Intg(m))
        Returns a random undirected unweighted graph on n vertices (list V of labels may be specified) where two vertices are connected with probability p or where m edges are created at random.
        See also: 1/ random_bipartite_graph 2/ random_digraph 3/ random_planar_graph 4/ random_regular_graph 5/ random_sequence_graph 6/ random_tournament 7/ random_tree 
        Ex1:random_graph(8,0.5)
        Ex2:random_graph(8,10)
        
        '''

     def random_network(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_network:
        random_network(Intg(a),Intg(b),[Real(p)],[opts])
        Returns a random network composed of b frames of size a*a in which every edge appears with the probability p (by default 0.5).
        See also: 1/ is_network 2/ maxflow 
        Ex1:random_network(3,3)
        Ex2:random_network(3,3,acyclic)
        Ex3:random_network(3,4,0.75)
        
        '''

     def random_planar_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_planar_graph:
        random_planar_graph(Intg(n)||Lst(V),Real(p),[Intg(c)])
        Returns a random planar graph with n vertices, which can also be specified as a list V of their labels, obtained by trying to remove each edge of a random triangulated graph with probability 0<=p<1 [c is connectivity level : 0 - any, 1 - connected, 2 - biconnected, 3 - triconnected (by default, c=1)].
        See also: 1/ random_bipartite_graph 2/ random_digraph 3/ random_graph 4/ random_regular_graph 5/ random_sequence_graph 6/ random_tournament 7/ random_tree 
        
        '''

     def random_regular_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_regular_graph:
        random_regular_graph(Intg(n)||Lst(V),Intg(d),[connected])
        Returns a random d-regular graph with n vertices, which may be specified as list V of their labels.
        See also: 1/ random_bipartite_graph 2/ random_digraph 3/ random_graph 4/ random_planar_graph 5/ random_sequence_graph 6/ random_tournament 7/ random_tree 
        Ex1:random_regular_graph(100,80,connected)
        
        '''

     def random_sequence_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_sequence_graph:
        random_sequence_graph(Lst(L))
        Returns a random undirected graph with degree sequence L.
        See also: 1/ random_bipartite_graph 2/ random_digraph 3/ random_graph 4/ random_planar_graph 5/ random_sequence_graph 6/ random_tournament 7/ random_tree 
        Ex1:random_sequence_graph([1,3,3,2,1,2,2,2,3,3])
        
        '''

     def random_tournament(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_tournament:
        random_tournament(Intg(n)||Lst(V))
        Returns a random tournament graph on n vertices, which may be specified as list V of their labels.
        See also: 1/ random_bipartite_graph 2/ random_digraph 3/ random_graph 4/ random_planar_graph 5/ random_regular_graph 6/ random_sequence_graph 7/ random_tree 
        Ex1:random_tournament(5)
        
        '''

     def random_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_tree:
        random_tree(Intg(n)||Lst(V),[Intg(d)||root[=Vrtx(v)]])
        Returns a random tree graph on n vertices, which may be specified as list V of their labels [with the upper bound d (positive integer) for the degree of graph or 'root' for rooted trees].
        See also: 1/ random_bipartite_graph 2/ random_digraph 3/ random_graph 4/ random_planar_graph 5/ random_regular_graph 6/ random_sequence_graph 7/ random_tournament 
        
        '''

     def random_variable(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for random_variable:
        random_variable(Lst(W)||Mtrx(M)||Fnc(f),[params])
        Returns a random variable from a probability density function f or from list of weights (discrete variable).
        See also: 1/ randvector 2/ randmatrix 3/ rand 
        Ex1:random_variable(fisher,2,3)
        Ex2:random_variable([["apple",1/3],["orange",1/4],["pear",1/5],["plum",13/60]])
        Ex3:random_variable(k->1-(k/10)^2,range=-10..10)
        Ex4:random_variable([3,1,2,5],[alpha,beta,gamma,delta])
        Ex5:random_variable(gammad,mean=12,variance=4)
        Ex6:random_variable(binomial,mean=18,stddev=4)
        Ex7:random_variable(multinomial,[1/2,1/3,1/6],[a,b,c])
        Ex8:random_variable(weibull,mean=12.5,variance=1)
        Ex9:random_variable(uniform,mean=10,stddev=2)
        Ex10:random_variable(uniform,e..pi)
        
        '''

     def randperm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randperm:
        randperm(Intg(n)||Lst(L))
        Returns a random permutation of [0,1,2,..,n-1] or of the list L.
        See also: 1/ permu2cycles 2/ is_permu 3/ permu2mat 
        Ex1:randperm(4)
        Ex2:randperm(7)
        Ex3:randperm([1,3,5,7,9])
        Ex4: L:=[1,3,5,7,9];L:=randperm(L)
        Ex5: L:=[1,3,5,7,9];L.randperm()
        
        '''

     def randpoisson(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randpoisson:
        randpoisson(Real(λ))
        Returns a random integer with poisson distribution P(λ).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randnorm 8/ randgeometric 9/ randmultinomial 
        Ex1:randpoisson(5.4)
        Ex2:randpoisson(2.8)
        
        '''

     def randpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randpoly:
        randpoly([Var(Var)],Intg(n),[law])
        Returns a polynomial with variable var (or x), of degree n and where the coefficients are random integers in the range -99 through 99 with uniform distribution or according to a law.
        See also: 1/ ranm 2/ randvector 
        Ex1:randpoly(5)
        Ex2:randpoly(t,8)
        Ex3:randpoly(t,8,-1..1)
        Ex4:randpoly([x,y],[10,3])
        Ex5:randpoly([x,y],[10,3],1 mod 7)
        Ex6: GF(2,8,g);randpoly(t,8,g);randpoly([x,y],[2,3],g)
        
        '''

     def randseed(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randseed:
        randseed()
        srand returns an integer and initializes the sequence of random numbers.
        See also: 1/ RandSeed 
        Ex1:randseed(12)
        Ex2: srand
        
        '''

     def randstudent(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randstudent:
        randstudent(Intg(n))
        Returns a random integer with Student distribution S(n).
        See also: 1/ rand 2/ randpoly 3/ ranm 4/ randvector 5/ randexp 6/ randbinomial 7/ randnorm 8/ randgeometric 9/ randmultinomial 
        Ex1:randstudent(5)
        Ex2:randstudent(2)
        
        '''

     def randvar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randvar:
        randvar(Lst(W)||Mtrx(M)||Fnc(f),[params])
        Returns a random variable from a probability density function f or from list of weights (discrete variable).
        See also: 1/ randvector 2/ randmatrix 3/ rand 
        Ex1:randvar(fisher,2,3)
        Ex2:randvar([["apple",1/3],["orange",1/4],["pear",1/5],["plum",13/60]])
        Ex3:randvar(k->1-(k/10)^2,range=-10..10)
        Ex4:randvar([3,1,2,5],[alpha,beta,gamma,delta])
        Ex5:randvar(gammad,mean=12,variance=4)
        Ex6:randvar(binomial,mean=18,stddev=4)
        Ex7:randvar(multinomial,[1/2,1/3,1/6],[a,b,c])
        Ex8:randvar(weibull,mean=12.5,variance=1)
        Ex9:randvar(uniform,mean=10,stddev=2)
        Ex10:randvar(uniform,e..pi)
        
        '''

     def randvector(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randvector:
        randvector(Intg(n), [Intg(m)],[Interval or quote(DistribLaw)])
        Returns a list of size n that contains random integers in the range -99 through 99 (or in 0..m-1) with uniform distribution or contains random numbers according to the law put between quotes.
        See also: 1/ idn 2/ randPoly 3/ rand 4/ ranm 
        Ex1:randvector(3)
        Ex2:randvector(3,6)
        Ex3:randvector(3,normald,0,1)
        Ex4:randvector(3,poisson,1.2)
        Ex5:randvector(3,exponentiald,1.2)
        Ex6:randvector(3,multinomial,[1/2,1/3,1/6])
        Ex7:randvector(3,multinomial,[1/2,1/3,1/6],[a,b,c])
        Ex8:randvector(3,'rand(3)')
        Ex9:randvector(3,1..2)
        Ex10: GF(2,8,g);randvector(3,g)
        
        '''

     def randweibulld(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for randweibulld:
        randweibulld(Real(a),Real(b))
        Returns a random real according to the Weibull distribution with parameters a>0 and b>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:randweibulld(1,2)
        Ex2:randweibulld(1.5,4)
        
        '''

     def rank(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rank:
        rank(Mtrx)
        Returns the rank of the matrix.
        See also: 1/ det 2/ image 
        Ex1:rank([[1,1,2],[2,1,3],[3,1,4]])
        Ex2:rank([[1,1,2],[2,1,3],[3,1,5]])
        
        '''

     def ranm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ranm:
        ranm(Intg(n), [Intg(m)],[Interval or quote(DistribLaw)])
        Returns a list of size n or an n*m matrix that contains random integers in the range -99 through 99 with uniform distribution or contains random numbers according to the law put between quotes.
        See also: 1/ idn 2/ randPoly 3/ rand 4/ randvector 
        Ex1:ranm(3)
        Ex2:ranm(3,2)
        Ex3:ranm(3,2,6)
        Ex4:ranm(3,2,binomial,10,0.3)
        Ex5:ranm(3,2,multinomial,[1/2,1/3,1/6])
        Ex6:ranm(3,2,poisson,5.2)
        Ex7:ranm(3,2,normald,0,1)
        Ex8:ranm(3,2,exp,7/2)
        Ex9:ranm(3,2,poisson,1.2)
        Ex10:ranm(3,2,'rand(3)')
        Ex11:ranm(3,2,1..2)
        Ex12:ranm(3,5,multinomial,[1/2,1/3,1/6],["R","V","B"])
        Ex13: GF(2,8,g);ranm(3,3,g)
        
        '''

     def ranv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ranv:
        ranv(Intg(n), [Intg(m)],[Interval or quote(DistribLaw)])
        Returns a list of size n that contains random integers in the range -99 through 99 (or in 0..m-1) with uniform distribution or contains random numbers according to the law put between quotes.
        See also: 1/ idn 2/ randPoly 3/ rand 4/ ranm 
        Ex1:ranv(3)
        Ex2:ranv(3,6)
        Ex3:ranv(3,normald,0,1)
        Ex4:ranv(3,poisson,1.2)
        Ex5:ranv(3,exponentiald,1.2)
        Ex6:ranv(3,multinomial,[1/2,1/3,1/6])
        Ex7:ranv(3,multinomial,[1/2,1/3,1/6],[a,b,c])
        Ex8:ranv(3,'rand(3)')
        Ex9:ranv(3,1..2)
        Ex10: GF(2,8,g);randvector(3,g)
        
        '''

     def rassembler_trigo(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rassembler_trigo:
        rassembler_trigo(Expr)
        Collects trigonometric expressions.
        See also: 1/ texpand 2/ tlin 
        Ex1:rassembler_trigo(sin(x)+cos(x))
        
        '''

     def rat_jordan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rat_jordan:
        rat_jordan(Mtrx)
        Returns the list made by the transition matrix and the rational Jordan form of a matrix.
        See also: 1/ egv 2/ egvl 3/ jordan 4/ companion 
        Ex1:rat_jordan([[0,2],[1,0]])
        Ex2:rat_jordan([[-2,-2,1],[-2,1,-2],[1,-2,-2]])
        Ex3:rat_jordan([[1,1,-1,2,-1],[2,0,1,-4,-1],[0,1,1,1,1],[0,1,2,0,1],[0,0,-3,3,-1]])
        
        '''

     def ratinterp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ratinterp:
        ratinterp([Mtrx(P) || List(X)],[List(Y)],[Var(x)],[Intg(d)]))
        Computes rational interpolations without poles of the given points.
        See also: 1/ thiele 2/ lagrange 3/ triginterp 
        Ex1:ratinterp([1,3,5,8],[2,-1,3,4],x)
        
        '''

     def rational(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rational:
        rational(Opt)
        DOM_RAT or rational is the type of a rational, as returned by the type command. It is also an option of the assume command.
        See also: 1/ type 2/ assume 3/ DOM_INT 4/ DOM_FLOAT 
        Ex1: assume(a,rational)
        Ex2: assume(a,DOM_RAT)
        Ex3: a:=1/2;type(a)
        
        '''

     def rationalroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rationalroot:
        rationalroot(Poly(P))
        Returns the list of rational roots of P without indicating the multiplicity.
        See also: 1/ proot 2/ froot 3/ complexroot 4/ realroot 5/ crationalroot 
        Ex1:rationalroot(2*x^3-9*x^2+13*x-6)
        
        '''

     def ratnormal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ratnormal:
        ratnormal(Expr)
        Rewrites as an irreducible rational fraction.
        See also: 1/ normal 2/ simplify 3/ factor 4/ expand 
        Ex1:ratnormal((x^2-1)/(x^3-1))
        Ex2:ratnormal(c/d+b/d+a/d)
        Ex3:ratnormal((x^2-1)/(x^3-1)+(x-1)/(x^3-1)+1)
        
        '''

     def rdiv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rdiv:
        rdiv(Expr(a),Expr(b))
        Division of a by b (prefixed version of /).
        See also: 1/ / 
        Ex1:rdiv(3,5)
        Ex2:rdiv(3.2,5.4)
        
        '''

     def re(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for re:
        re(Cplx or LstCplx)
        Returns the real part of a complex number.
        See also: 1/ im 2/ conj 
        Ex1:re(1+2*i)
        Ex2:re((1+2*i)^2)
        Ex3:re([1+2*i,(1+2*i)^2])
        
        '''

     def reachable(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reachable:
        reachable(Graph(G),Vrtx(u))
        Returns the list of vertices in G which are reachable from u.
        See also: 1/ is_reachable 2/ shortest_path 
        Ex1: G:=graph_complement(complete_graph(3,4)):;reachable(G,3)
        
        '''

     def read(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for read:
        read(Str(fich_name))
        Reads variables and their values from the file fich_name.
        See also: 1/ write 2/ readrgb 3/ readwav 4/ csv2gen 
        Ex1:read("toto")
        
        '''

     def readrgb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for readrgb:
        readrgb(Str(s),[Intg(w)],[Intg(h)])
        Reads a picture file, using it's natural dimensions, or using specified dimensions.
        See also: 1/ writergb 2/ readwav 
        Ex1:readrgb("image.png")
        Ex2:readrgb("image.png",50,50)
        
        '''

     def readwav(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for readwav:
        readwav(Str(s))
        Reads a WAV sound file.
        See also: 1/ writewav 2/ readrgb 
        Ex1:readwav("pop.wav")
        
        '''

     def real(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for real:
        real(Cplx or LstCplx)
        Returns the real part of a complex number.
        See also: 1/ im 2/ conj 
        Ex1:real(1+2*i)
        Ex2:real((1+2*i)^2)
        Ex3:real([1+2*i,(1+2*i)^2])
        
        '''

     def realroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for realroot:
        realroot([sturm],Poly(P),[Real(l)],[Cplx(a)],[Cplx(b)])
        Returns the list of intervals of length <=l containing the real roots of P inside a..b with their multiplicity. By default the Vincent-Akritas-Strzebonski (VAS) method is used. realroot(sturm,P) uses Sturm's method.
        See also: 1/ proot 2/ froot 3/ complexroot 4/ rationalroot 5/ crationalroot 6/ sturmab 7/ VAS 
        Ex1:realroot(x^3+7,0.1)
        Ex2:realroot(x^3-7*x+7)
        Ex3:realroot(sturm,x^3-7*x+7)
        Ex4:realroot(x^5-2*x^4+x^3+1)
        Ex5:realroot(x^5-2*x^4+x^3+1,0.1)
        Ex6:realroot(x^3+x+8,1e-5,-4,4)
        
        '''

     def reciprocation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reciprocation:
        reciprocation(Crcle,Lst(Pnt,Line))
        Returns the list where the points (resp lines) are replaced with their polars (resp poles) with respect to the circle C.
        See also: 1/ pole 2/ polar 
        Ex1:reciprocation(circle(0,1),[point((1+i)/2), line(1,-1+i)])
        Ex2:reciprocation(circle(0,1),[line(1+i,2),point(1+i*2)])
        
        '''

     def rect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rect:
        rect(Expr(x))
        Returns the value of the rectangle function at x.
        See also: 1/ boxcar 2/ tri 3/ Heaviside 
        Ex1:rect(x/2)
        
        '''

     def rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rectangle:
        rectangle(Pnt(A)||Cplx,Pnt(B)||Cplx,Real(k)||Pnt(P)||Lst(P,k),[Var(D)],[Var(C)])
        Returns and draws the rectangle ABCD, AD=k*AB; if k>0 ABCD is direct else indirect (in the plane ABP AD=AP or AD=k*AB).
        See also: 1/ quadrilateral 2/ square 
        Ex1:rectangle(-i,1,2)
        Ex2:rectangle(-i,1,-2,D,C)
        Ex3:rectangle(point(0,0,0),point(3,3,3),point(0,0,3),D,C)
        Ex4:rectangle(point(0,0,0),point(3,3,3),2,D,C)
        
        '''

     def rectangle_droit(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rectangle_droit:
        rectangle_droit(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def rectangle_gauche(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rectangle_gauche:
        rectangle_gauche(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def rectangle_plein(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rectangle_plein:
        rectangle_plein(Real(a),[Real(b)])
        Draws a full direct rectangle (resp square) with sides a,b (resp a) from the turtle position and on the left (by default b=a).
        See also: 1/ triangle_plein 
        Ex1: rectangle_plein 20
        Ex2:rectangle_plein(20)
        Ex3:rectangle_plein(20,40)
        
        '''

     def rectangular_coordinates(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rectangular_coordinates:
        rectangular_coordinates(LstPolCoord)
        Returns the list of the abscissa and of the ordinate of a point given by the list of its polar coordinates.
        See also: 1/ abscissa 2/ ordinate 3/ rectangular_coordinates 4/ polar_point 
        Ex1:rectangular_coordinates([1,pi/4])
        Ex2:rectangular_coordinates(polar_point(1,pi/4))
        
        '''

     def recule(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for recule:
        recule(NULL or Real(n))
        The turtle takes n steps back (by default n=10).
        See also: 1/ avance 2/ saute 
        Ex1: recule 30
        Ex2:recule(30)
        
        '''

     def red(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for red:
        red(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def reduced_conic(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reduced_conic:
        reduced_conic(Expr,[LstVar])
        Returns the origin and the matrix of a base in which the conic given by its equation is reduced, 0 or 1 (0 if the conic is degenerate) and the equation of the conic in this base and also its parametric equation.
        See also: 1/ gauss 2/ conic 
        Ex1:reduced_conic(x^2+2*x-2*y+1)
        Ex2:reduced_conic(a*x^2-2*x*y+a*y^2-2*x+2*y+3,[x,y])
        Ex3:reduced_conic(2*u^2+2*u*v+2*v^2+5*u+3,[u,v])
        Ex4:reduced_conic((x+y)^2-2*x+1,x,y)
        
        '''

     def reduced_quadric(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reduced_quadric:
        reduced_quadric(Expr, [LstVar])
        Returns the origin and the matrix of a basis in which the quadric (given by its equation) is reduced, the list of its eigenvalues, the equation of the quadric in this basis and its parametric equation.
        See also: 1/ gauss 2/ quadric 
        Ex1:reduced_quadric(4*x^2+y^2+z^2-4*x*y+4*x*z-2*y*z+8*x-4*y+4*z+2)
        Ex2:reduced_quadric(x^2+3*y^2-3*z^2-8*y*z+2*z*x-4*x*y-1,x,y,z)
        Ex3:reduced_quadric((u+v)*(v-w)+3*u-5*v,[u,v,w])
        Ex4:reduced_quadric(7*x^2+4*y^2+4*z^2+4*x*y-4*x*z-2*y*z-4*x+5*y+4*z-18,[x,y,z])
        
        '''

     def ref(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ref:
        ref(Mtrx(M))
        Gaussian reduction of AX=b (M=A|(-b)).
        See also: 1/ rref 2/ det 
        Ex1:ref([[3,1,-2],[3,2,2]])
        Ex2:ref([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]])
        
        '''

     def reflection(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reflection:
        reflection((Pnt(A) or Line(D)),(Pnt(C) or Curve(C)))
        reflection(D,C) (or reflection(A,C))=symmetry of C with the symmetry-line D (or sym-point A).
        See also: 1/ rotation 2/ translation 
        Ex1:reflection(line(0,1+i),A)
        Ex2:reflection(B,A)
        Ex3:reflection(line(0,1+i),circle(i,1+i))
        
        '''

     def regroup(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for regroup:
        regroup(Expr)
        Collects terms in an expression.
        See also: 1/ simplify 2/ normal 
        Ex1:regroup(x+3*x+5*4/x)
        
        '''

     def relabel_vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for relabel_vertices:
        relabel_vertices(Graph(G),Lst(L))
        Returns a copy of G with vertex labels changed to those in L.
        See also: 1/ graph_vertices 2/ isomorphic_copy 3/ permute_vertices 
        Ex1:relabel_vertices(graph([a,b,c]),["first","second","third"])
        
        '''

     def reliability_polynomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reliability_polynomial:
        reliability_polynomial(Graph(G),[Var(p)])
        Returns the reliability polynomial [or its value at point p] of an undirected graph G. If G is weighted, then all weights must be positive integers which are interpreted as edge multiplicities.
        See also: 1/ chromatic_polynomial 2/ flow_polynomial 3/ tutte_polynomial 
        Ex1:reliability_polynomial(graph("petersen"))
        Ex2:reliability_polynomial(graph("petersen"),0.5)
        
        '''

     def rem(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rem:
        rem((Vect or Poly),(Vect or Poly),[Var])
        Euclidean remainder of 2 polynomials.
        See also: 1/ quo 2/ quorem 3/ Rem 4/ irem 
        Ex1:rem([1,2,3,4],[-1,2])
        Ex2:rem(x^3+2x^2+3x+4,-x+2)
        Ex3:rem(t^3+2t^2+3t+4,-t+2,t)
        
        '''

     def remain(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for remain:
        remain(Intg(a),Intg(b))
        Euclidean remainder of 2 integers.
        See also: 1/ iquo 2/ smod 3/ rem 4/ mod 
        Ex1:remain(125,15)
        Ex2:remain(125,41)
        Ex3:remain(-7,3)
        Ex4:remain(25+12*i,5+7*i)
        
        '''

     def remove(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for remove:
        remove(FncBool(f)||a,Lst(l))
        Remove the occurrences a of l or the elements a such that f(a)=true.
        See also: 1/ select 2/ suppress 
        Ex1:remove(x->x>=5,[1,2,6,7])
        Ex2:remove(5,[1,2,5,6,7,5])
        
        '''

     def reorder(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reorder:
        reorder(Expr, LstVar)
        Reorders the variables in E according to the order of the 2nd argument.
        See also: 1/  
        Ex1:reorder(-2)
        Ex2:reorder(x^2+2*x+y^2,[y,x])
        
        '''

     def resample(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for resample:
        resample(Audio(clip),[Intg(s),[Intg(q)]])
        Returns a copy of an audio clip resampled to the rate s (by default 44100), optionally with quality level q (from 0 to 4, by default 2).
        See also: 1/ samplerate 2/ playsnd 3/ readwav 4/ writewav 
        Ex1:resample(readwav("/some/file"),48000)
        Ex2:resample(readwav("/some/file"),48000,3)
        
        '''

     def residue(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for residue:
        residue(Expr,Var(v),Cplx(a))
        Returns the residue in a of the expression with v as variable.
        See also: 1/ series 
        Ex1:residue(1/z,z,0)
        Ex2:residue(5/z,z=0)
        Ex3:residue(cos(z)/(z*(z-b)),z,0)
        Ex4:residue(c/(z*(z-b)),z=b)
        
        '''

     def resoudre(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for resoudre:
        resoudre(Expr,[Var])
        Solves a (or a set of) polynomial equation.
        See also: 1/ linsolve 2/ proot 3/ fsolve 4/ csolve 5/ nSolve 
        Ex1:resoudre(x^2-3=1)
        Ex2:resoudre(x^3-3*y,y)
        Ex3:resoudre([y-z=0,z-x=0,x-y=0,x-1+y+z=0],[x,y,z])
        Ex4:resoudre([x^2-y^2=0,x^2-z^2=0],[x,y,z])
        
        '''

     def resoudre_dans_C(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for resoudre_dans_C:
        resoudre_dans_C(LstEq,LstVar)
        Returns the list of complex solutions of an equation or a matrix where the rows are ℂ-solutions of a system of polynomial equations.
        See also: 1/ cZeros 2/ solve 3/ fslove 
        Ex1:resoudre_dans_C(x^4-1,x)
        Ex2:resoudre_dans_C(x^4-y^4 and x+y=2,[x,y])
        Ex3:resoudre_dans_C(x^4-y^4 and x+y=0 and x^2=2*x,[x,y])
        Ex4:resoudre_dans_C(u*v-u=v and v^2=u,[u,v])
        
        '''

     def resoudre_systeme_lineaire(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for resoudre_systeme_lineaire:
        resoudre_systeme_lineaire(LstLinEq,LstVar)
        Linear equations system solver.
        See also: 1/ solve 2/ proot 3/ simult 4/ gaussjord 5/ pivot 6/ ref 7/ conjugate_gradient 
        Ex1:resoudre_systeme_lineaire([x+y+z=1,x-y=2,2*x-z=3],[x,y,z])
        Ex2:resoudre_systeme_lineaire([m*x+y=a,x+m*y=b],[x,y])
        Ex3:resoudre_systeme_lineaire([x+y-z-1,x-y+1,x-y-z-1]%2,[x,y,z])
        Ex4:resoudre_systeme_lineaire([[3,4],[1,2]],[0,1])
        Ex5: p,l,u:=lu([[3,4],[1,2]]); linsolve(p,l,u,[0,1]) 
        Ex6:resoudre_systeme_lineaire([2*x+y+z=1,x+y+2*z=1,x+2*y+z=4],[x,y,z])
        Ex7:resoudre_systeme_lineaire([[2,1,1],[1,1,2],[1,2,1]],[1,1,4])
        Ex8: p,l,u:=lu([[2,1,1],[1,1,2],[1,2,1]]);linsolve(p,l,u,[1,1,4])
        Ex9: a:=[[100,2],[2,100]];linsolve(evalf(a),[0,1]);
        
        '''

     def resultant(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for resultant:
        resultant(Poly,Poly,Var)
        Resultant of two polynomials.
        See also: 1/ sylvester 2/ gcd 
        Ex1:resultant(x^2-1,x^3-1,x)
        Ex2:resultant(x^3-p*x+q,3*x^2-p,x)
        
        '''

     def reverse(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reverse:
        reverse(Lst(L)||Audio)
        Returns the list L in reverse order; L:=revlist(L) or L.revlist(). Also reverses audio clips.
        Ex1:reverse([1,2,3,4])
        Ex2: L:=[1,2,3,4];L:=revlist(L)
        Ex3: L:=[1,2,3,4];L.revlist()
        Ex4: L:=[1,2,3,4];L.reverse()
        
        '''

     def reverse_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reverse_graph:
        reverse_graph(Graph(G))
        Returns a copy of G in which the directions of all edges are reversed.
        See also: 1/ digraph 
        Ex1:reverse_graph(digraph(%{[1,2],[1,3],[2,3]%}))
        
        '''

     def reverse_rsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for reverse_rsolve:
        reverse_rsolve(Vect(v))
        If v=[v_0 ... v_(2n-1)], returns [b_n,...,b_0] such that b_n*v_{n+k}+...+b_0*v_k=0 for k=0..n-1.
        See also: 1/ rsolve 
        Ex1:reverse_rsolve([1,-1,3,3])
        
        '''

     def revert(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for revert:
        revert(Expr)
        Returns the inverse expansion of a series expansion at 0.
        See also: 1/ series 
        Ex1:revert(x+x^2+x^4)
        
        '''

     def revlex(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for revlex:
        revlex(Opt)
        Option of the gbasis or greduce command to specify an order for monomials (complete degree then inverse lexicographic order).
        See also: 1/ gbasis 2/ greduce 
        
        '''

     def revlist(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for revlist:
        revlist(Lst(L)||Audio)
        Returns the list L in reverse order; L:=revlist(L) or L.revlist(). Also reverses audio clips.
        Ex1:revlist([1,2,3,4])
        Ex2: L:=[1,2,3,4];L:=revlist(L)
        Ex3: L:=[1,2,3,4];L.revlist()
        Ex4: L:=[1,2,3,4];L.reverse()
        
        '''

     def rgb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rgb:
        rgb(Lst(r,g,b)||Intg(rrggbb)||Str(rrggbb)||Color(c))
        Convert a RGB triple [r,g,b] or a hexadecimal integer or string rrggbb into xcas color or return RGB specification of xcas color c.
        See also: 1/ hsv 2/ rgb2hsv 3/ hsv2rgb 
        Ex1:rgb(0x00ff00)
        Ex2:rgb(red)
        Ex3:rgb(255,0,255)
        Ex4: redcolor:=rgb(0.99,0,0);display(square(0,2+i),filled+redcolor)
        Ex5: greencolor:=rgb(0,0.99,0);display(square(0,2+i),filled+greencolor)
        Ex6: bluecolor:=rgb(0,0,0.99);display(square(0,2+i),filled+bluecolor)
        Ex7: greycolor:=rgb(0.5,0.5,0.5);display(square(0,2+i),filled+greycolor)
        Ex8: F:=display(square(0,2+i),filled+rgb(rand(),rand(),rand()))
        Ex9: L:=rand(),rand(),rand();affichage(square(0,2+i),rgb(L)+rempli);legend(0.2,[L])
        
        '''

     def rgb2hsv(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rgb2hsv:
        rgb2hsv(Lst(r,g,b))
        Convert RGB to HSV.
        See also: 1/ hsv2rgb 2/ rgb 3/ hsv 
        Ex1:rgb2hsv(32,64,126)
        Ex2:rgb2hsv([0.3,0.2,0.1])
        Ex3:rgb2hsv(0.3,0.2,0.1)
        
        '''

     def rgb2xyz(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rgb2xyz:
        rgb2xyz(Lst(r,g,b)||Color(c))
        Convert RGB to XYZ.
        See also: 1/ xyz2rgb 2/ rgb 3/ interp 
        Ex1:rgb2xyz(teal)
        Ex2:rgb2xyz([0,255,255])
        Ex3:rgb2xyz(0.7,0.8,0.9)
        
        '''

     def rhombus(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rhombus:
        rhombus(Pnt(A)||Cplx,Pnt(B)||Cplx,Angle(a)||Pnt(P)||Lst(P,a)),[Var(C)],[Var(D)])
        Returns and draws the rhombus ABCD such that the angle (AB,AD)=a (or in the plane ABP angle(AB,AD)=angle(AB,AP) or such that angle(AB,AD)=a).
        See also: 1/ square 2/ quadrilateral 
        Ex1:rhombus(i,1+i,pi/4)
        Ex2:rhombus(i,1+i,pi/4,C,D)
        Ex3:rhombus(point(0,0,0),point(3,3,3),[point(0,0,3),pi/4])
        Ex4:rhombus(point(0,0,0),point(3,3,3),point(0,0,3),C,D)
        Ex5:rhombus(point(0,0,0),point(3,3,3),[point(0,0,3),pi/4],C,D)
        
        '''

     def rhombus_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rhombus_point:
        rhombus_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def rhs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rhs:
        rhs(Equal(a=b) or Interval(a..b) or Str,Intg)
        Returns the right part of an equality, of an interval, of a list or of a string.
        See also: 1/ left 2/ mid 3/ tail 4/ head 
        Ex1:rhs(a=b)
        Ex2:rhs(x^2+1=5)
        Ex3:rhs(1..5)
        Ex4:rhs("abcdefg",3)
        
        '''

     def riemann_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for riemann_window:
        riemann_window(Lst,[Interval(n1..n2)])
        Applies the Riemann windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ bartlett_hann_window 12/ triangle_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(riemann_window(randvector(1000,0..1)))
        
        '''

     def right(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for right:
        right(Equal(a=b) or Interval(a..b) or Str,Intg)
        Returns the right part of an equality, of an interval, of a list or of a string.
        See also: 1/ left 2/ mid 3/ tail 4/ head 
        Ex1:right(a=b)
        Ex2:right(x^2+1=5)
        Ex3:right(1..5)
        Ex4:right("abcdefg",3)
        
        '''

     def right_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for right_rectangle:
        right_rectangle(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def right_triangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for right_triangle:
        right_triangle((Pnt(A) or Cplx),(Pnt(B) or Cplx),(Real(k) or Pnt(P) or Lst(P,k)),[Var(C)])
        Draws the A_rectangular triangle ABC with AC=k*AB (or in the plane ABP AC=AP or AC=k*AB).
        See also: 1/ triangle 
        Ex1:right_triangle(1,i,tan(pi/3))
        Ex2:right_triangle(1,i,1/2,C)
        Ex3:right_triangle(point(0,0,0),point(3,3,3),point(0,0,3))
        Ex4:right_triangle(point(0,0,0),point(3,3,3),[point(0,0,3),1/2],C)
        Ex5:right_triangle(point(0,0,0),point(3,3,3),[point(0,0,3),1/2],C)
        
        '''

     def risch(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for risch:
        risch(Expr,[Var])
        Returns a primitive of the expression calculated with the Risch algorithm.
        See also: 1/ int 
        Ex1:risch(ln(x),x)
        Ex2:risch(ln(x))
        Ex3:risch(exp(x^2),x)
        
        '''

     def rm_a_z(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rm_a_z:
        rm_a_z(NULL)
        Erases all the variable name made up of only one lowercase a..z character.
        See also: 1/ rm_all_vars 
        Ex1:rm_a_z()
        
        '''

     def rm_all_vars(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rm_all_vars:
        rm_all_vars(NULL)
        Erases all the variable names.
        See also: 1/ rm_a_z 
        Ex1:rm_all_vars()
        
        '''

     def rmbreakpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rmbreakpoint:
        rmbreakpoint(Intg)
        Removes a breakpoint.
        See also: 1/ breakpoint 
        Ex1:rmbreakpoint(1)
        
        '''

     def rmmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rmmod:
        rmmod(Str(pwd))
        Removes the installed dynamic libraries.
        See also: 1/ lsmod 2/ insmod 
        Ex1:rmmod("/home/parisse/giac/src/libprogfr.so")
        
        '''

     def rms(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rms:
        rms(Lst(X))
        Returns the root mean square of X.
        See also: 1/ mean 
        Ex1:rms([1,2,5,8,3,6,4])
        
        '''

     def rmwatch(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rmwatch:
        rmwatch(Var)
        Clears a variables from the table of displayed variables in step/step.
        See also: 1/ watch 
        Ex1:rmwatch(a)
        
        '''

     def romberg(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for romberg:
        romberg(Expr(f(x)),Var(x),Real(a),Real(b))
        Returns the approximate value of integrate(f(x),x,a,b) by Romberg's method.
        See also: 1/ integrate 2/ gaussquad 
        Ex1:romberg(exp(x^2),x,0,1)
        Ex2:romberg(x^2,x,0,1)
        Ex3:romberg(exp(-x^2),x,-1,1)
        
        '''

     def rombergm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rombergm:
        rombergm(Opt)
        Option of the area command.
        See also: 1/ area 
        Ex1: area(x^2,x=0..1,5,simpson)
        Ex2: area(x^2,x=0..1,5,rombergt)
        Ex3: area(x^2,x=0..1,5,rombergm)
        Ex4:rombergm(area(x^2,x=0..1,5,gauss15))
        
        '''

     def rombergt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rombergt:
        rombergt(Opt)
        Option of the area command.
        See also: 1/ area 
        Ex1: area(x^2,x=0..1,5,simpson)
        Ex2: area(x^2,x=0..1,5,rombergt)
        Ex3: area(x^2,x=0..1,5,rombergm)
        Ex4:rombergt(area(x^2,x=0..1,5,gauss15))
        
        '''

     def rond(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rond:
        rond(Real(r),[Real(a)],[Real(b)])
        Draws a circle (resp a arc) with radius r (resp and with angle (0,a) or (a,b)), tangent at the turtle position.
        See also: 1/ disque 
        Ex1: rond 30
        Ex2:rond(40)
        Ex3:rond(40,90)
        Ex4:rond(40,10,100)
        
        '''

     def root(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for root:
        root(Expr(a),Expr(b))
        Returns b^(1/a) (root(2,3)=sqrt(3)).
        See also: 1/  
        Ex1:root(3,2)
        Ex2:root(1/3,2)
        Ex3:root(3,1.2)
        Ex4:root(3.2,1.2)
        
        '''

     def rootof(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rootof:
        rootof(LstPoly(P),LstPoly(Q))
        Polynomial in terms of a root of an irreducible polynomial on Q. Returns P(a) with a the greatest root of Q.
        See also: 1/  
        Ex1: normal(1/rootof([1,0],[1,0,10,0,1]))
        Ex2: normal(1/rootof([1,0,0],[1,1,0,-1]))
        Ex3: rootof(x^4+x+1):='j'; normal(j^5); 
        
        '''

     def roots(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for roots:
        roots(Poly,[Var])
        Returns a matrix having 2 columns and where the rows are the roots of the polynomial with their multiplicity (for 1 variable).
        See also: 1/ proot 2/ cZeros 
        Ex1:roots(t^3-1,t)
        Ex2:roots(x^5-2*x^4+x^3)
        
        '''

     def rotate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rotate:
        rotate(Lst||Str(L),[Intg(n)])
        Returns the list where the last element [or the tail beginning with the n-th element] is moved to the first element (by default n=-1);L:=rotate(L,n) or L.rotate(n).
        See also: 1/ tail 2/ mid 3/ shift 
        Ex1:rotate([0,1,2,3],2)
        Ex2:rotate([[1,2,3],[4,5,6],[7,8,9]])
        Ex3:rotate([0,1,2,3,4])
        Ex4:rotate([0,1,2,3,4],-1)
        Ex5: L:=[0,1,2,3,4];L:=rotate([0,1,2,3,4])
        Ex6: L:=[0,1,2,3,4];L.rotate()
        Ex7: L:=[0,1,2,3];L:=rotate([0,1,2,3],2)
        Ex8: L:=[0,1,2,3];L.rotate(2)
        
        '''

     def rotation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rotation:
        rotation((Pnt(B) or Cplx or Dr3),Angle(a1),(Pnt(A) or Curve))
        rotation(B,a1,A) (resp rotation(d,a1,A)) is the transformation of A by rotation with center B (resp of axis d) and angle a1.
        See also: 1/ translation 2/ reflection 
        Ex1:rotation(point(1+i),pi/2,point(i))
        Ex2:rotation(1+i,pi/3,line(i,1))
        Ex3:rotation(line(x=y,y=z),pi/2,point(1,-1,2))
        Ex4: r:=rotation(1+i,pi/2);r(i)
        Ex5: r:=rotation(line(x=y,y=z),pi/2);r(point(1,-1,2))
        
        '''

     def round(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for round:
        round(Real or Cplx,[Intg(n)])
        Rounds the real or complex to the nearest integer (resp the nearest decimal number) or to the nearest element of ℤ[i], (resp with n decimals).
        See also: 1/ floor 2/ ceil 
        Ex1:round(2.5)
        Ex2:round(-2.4)
        Ex3:round(-2.5+i*2.4)
        Ex4:round(1.237,2)
        Ex5:round(sqrt(2)+i*sqrt(5),4)
        
        '''

     def row(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for row:
        row(Mtrx(A),Intg(n)||Interval(n1..n2))
        Returns row n or the sequence of the rows n1..n2 of the matrix A, or optional argument of count,count_eq,count_inf,count_sup.
        See also: 1/ col 2/ count 3/ count_eq 4/ count_inf 5/ count_sup 
        Ex1:row([[1,2,3],[4,5,6],[7,8,9]],1)
        Ex2:row([[1,2,3],[4,5,6],[7,8,9]],0..1)
        Ex3: count_eq(3,[[1,2,3],[4,3,2],[3,2,1]],row)
        
        '''

     def rowAdd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowAdd:
        rowAdd(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by replacing the n2-th row by the sum of the n1-th and n2-th rows.
        See also: 1/ rowSwap 
        Ex1:rowAdd([[1,2],[3,4],[5,6]],1,2)
        
        '''

     def rowDim(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowDim:
        rowDim(Mtrx)
        Number of rows of a matrix.
        See also: 1/ ncols 
        Ex1:rowDim([[1,2,3],[4,5,6]])
        Ex2:rowDim([[1,2],[3,4],[5,6]])
        
        '''

     def rowNorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowNorm:
        rowNorm(Vect or Mtrx)
        Returns the max of the l1_norm of the rows of a matrix: rowNorm(a_{j,k})=max_j(sum_k(|a_{j,k}|)).
        See also: 1/ norm 
        Ex1:rowNorm([[1,2],[3,-4]])
        Ex2:rowNorm([[1,2,3,-4],[-5,3,2,1]])
        
        '''

     def rowSwap(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowSwap:
        rowSwap(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by swapping the n1-th row and the n2-th row.
        See also: 1/ rowAdd 2/ colSwap 
        Ex1:rowSwap([[1,2],[3,4],[5,6]],1,2)
        
        '''

     def rowdim(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowdim:
        rowdim(Mtrx)
        Number of rows of a matrix.
        See also: 1/ ncols 
        Ex1:rowdim([[1,2,3],[4,5,6]])
        Ex2:rowdim([[1,2],[3,4],[5,6]])
        
        '''

     def rownorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rownorm:
        rownorm(Vect or Mtrx)
        Returns the max of the l1_norm of the rows of a matrix: rowNorm(a_{j,k})=max_j(sum_k(|a_{j,k}|)).
        See also: 1/ norm 
        Ex1:rownorm([[1,2],[3,-4]])
        Ex2:rownorm([[1,2,3,-4],[-5,3,2,1]])
        
        '''

     def rowspace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowspace:
        rowspace(Mtrx(A), [Var(d)])
        Returns a matrix where the rows are a basis of the vector space generated by the rows of the matrix A [d is the dimension of this space].
        See also: 1/ colspace 
        Ex1:rowspace([[1,2,3],[1,2,3],[1,2,4],[1,2,5]])
        Ex2:rowspace([[1,2,3],[1,3,6],[2,5,9]],d)
        
        '''

     def rowswap(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rowswap:
        rowswap(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by swapping the n1-th row and the n2-th row.
        See also: 1/ rowAdd 2/ colSwap 
        Ex1:rowswap([[1,2],[3,4],[5,6]],1,2)
        
        '''

     def rref(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rref:
        rref(Mtrx(M),[Intg(k)]||Opt)
        Row reduction to echelon form of AX=b (M=A|(-b)) [Reduction on columns 0..k-1].
        See also: 1/ ker 2/ image 3/ det 4/ Rref 5/ pivot 6/ ref 7/ keep_pivot 
        Ex1:rref([[3,1,-2],[3,2,2]])
        Ex2:rref([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]])
        Ex3:rref([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]],2)
        Ex4:rref([[1,1,0,0,-a1],[0,1,1,0,-a2],[0,0,1,1,-a3],[1,0,0,1,-a4]],keep_pivot)
        
        '''

     def rsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rsolve:
        rsolve((Expr or LstExpr),(Var or LstVar),(InitVal or LstInitVal))
        Gives the value of a recurrent sequence or of a system of recurrent sequences.
        See also: 1/ seqsolve 2/ plotseq 3/ tableseq 4/ reverse_rsolve 
        Ex1:rsolve(u(n+1)=2*u(n)+n,u(n),u(0)=1)
        Ex2:rsolve(u(n+1)=2*u(n)+n,u(n),u(1)^2=1)
        Ex3:rsolve(u(n+1)=(u(n)-1)/(u(n)-2),u(n),u(0)=4)
        Ex4:rsolve(u(n+2)=u(n)+2*u(n+1)+n+1,u(n),[u(0)=0,u(1)=1])
        Ex5:rsolve([u(n+1)=3*v(n)+u(n),v(n+1)=v(n)+u(n)],[u(n),v(n)],[u(0)=1,v(0)=2])
        
        '''

     def rur(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rur:
        rur(rur)
        Optional parameter of gbasis, will return a rational univariate representation instead of a Groebner basis for a 0 dimensional ideal
        See also: 1/ gbasis 
        Ex1: gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],rur)
        Ex2:  
        
        '''

     def rur_certify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rur_certify:
        rur_certify(Intg(n))
        Rur certification if argument n is 1, of equations of degree <= n if n>1 or no certification if n=0. If n<0, set maximal number of threads for certification to -n.
        See also: 1/ gbasis 2/ rur_gbasis 
        Ex1: rur_certify(2); gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],rur)
        
        '''

     def rur_gbasis(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for rur_gbasis:
        rur_gbasis(Intg(n))
        Gbasis fine-tuning; in the modular algorithm of a rur over Q, reconstruct a gbasis over Q if n=1, or if the number of monomials of the gbasis is <n if n>1. If n=0 no gbasis reconstruction over Q. If n==-1 and if one computes a rational univariate representation for a non 0 dimensional ideal, returns fast [rur]. If n==-2 returns a Groebner basis instead.
        See also: 1/ gbasis 2/ rur_certify 
        Ex1: rur_gbasis(0); gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],rur)
        
        '''

     def same(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for same:
        same(Expr,Expr)
        Equality test.
        See also: 1/  
        Ex1:same(a,b)
        Ex2:same((2-1)^2,2^2-2*2+1)
        
        '''

     def sample(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sample:
        sample(Lst(L),Intg(n))
        sample(L,n)= rand(n,L)=list of the n extracted elements of L without replacement.
        See also: 1/ rand  
        Ex1:sample([1,2,3,4,5,6],6)
        Ex2:sample([1,2,3,4,5,6],3)
        Ex3:sample(["r","r","r","b","n"],3)
        Ex4: L:=[1,2,3,4,5,6];L:=sample(L,3)
        Ex5: L:=[1,2,3,4,5,6];L.sample(3)
        Ex6: 
        
        '''

     def samplerate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for samplerate:
        samplerate(Audio(clip))
        Returns the sampling rate of an audio clip, in Hertz.
        See also: 1/ bit_depth 2/ channels 3/ channel_data 4/ duration 
        Ex1:samplerate(readwav("/some/file"))
        
        '''

     def sans_factoriser(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sans_factoriser:
        sans_factoriser(Opt.)
        Option of the plotimplicit command.
        See also: 1/ plotimplicit 
        Ex1: plotimplicit(x^2+y^2-1,x,y,unfactored)
        Ex2: plotimplicit(x^2+y^2-1,[x,y],unfactored)
        Ex3: plotimplicit(x^2+y^2+z^2-1,x,y,z,xstep=0.2,ystep=0.2,zstep=0.2,unfactored)
        Ex4: plotimplicit(x^2+y^2+z^2-1,[x,y,z],xstep=0.2,ystep=0.2,zstep=0.2,unfactored)
        Ex5: plotimplicit(x^2+y^2+z^2-1,x=0..1,y=0..1,z=0..1,xstep=0.2,ystep=0.2,zstep=0.2,unfactored)
        
        '''

     def saute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for saute:
        saute(NULL or Real(n))
        The turtle takes n steps forward without traces (by default n=10).
        See also: 1/ avance 2/ recule 
        Ex1: saute 30
        Ex2:saute(30)
        
        '''

     def scalarProduct(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for scalarProduct:
        scalarProduct(Vect(v1),Vect(v2))
        Scalar product.
        See also: 1/ * 2/ cross 3/ .* 4/ hadamard 
        Ex1:scalarProduct([1,2],[3,4])
        Ex2:scalarProduct([3,2,4],[3,2,4])
        Ex3:scalarProduct([[1,2],[3,4]],[[3,2],[4,5]])
        
        '''

     def scalar_product(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for scalar_product:
        scalar_product(Vect(v1),Vect(v2))
        Scalar product.
        See also: 1/ * 2/ cross 3/ .* 4/ hadamard 
        Ex1:scalar_product([1,2],[3,4])
        Ex2:scalar_product([3,2,4],[3,2,4])
        Ex3:scalar_product([[1,2],[3,4]],[[3,2],[4,5]])
        
        '''

     def scatterplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for scatterplot:
        scatterplot(Mtrx)
        Draws for k=0..nrows, the points (xk,yk) where xk=element row k column 0 and yk=element row k column j (j=1..ncols).
        See also: 1/ polygonplot 2/ polygonscatterplot 3/ listplot 
        Ex1:scatterplot([[1,2,3],[2,0,1],[-1,2,3]])
        
        '''

     def schur(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for schur:
        schur(Mtrx(A))
        Matrix reduction to Hessenberg form. Returns [P,B] such that B=inv(P)*A*P:SCHUR(A)=hessenberg(A,-1).
        See also: 1/ hessenberg 
        Ex1:schur([[1,2,3],[4,5,6],[7,8,1]])
        Ex2:schur([[1,2,3,4],[4,5,6,7],[7,8,9,0],[0,1,2,3]])
        
        '''

     def sec(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sec:
        sec(Expr)
        Secant: sec(x)=1/cos(x).
        See also: 1/ cos 2/ asec 
        Ex1:sec(pi/3)
        
        '''

     def secant_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for secant_solver:
        secant_solver(Opt)
        Argument for fsolve giving the method for solving a numerical equation.
        See also: 1/ fsolve 
        Ex1: fsolve(cos(x)=x,x,0..1,bisection_solver)
        Ex2: fsolve(cos(x)=x,x,0..1,brent_solver)
        Ex3: fsolve(cos(x)=x,x,0..1,falsepos_solver)
        Ex4: fsolve(cos(x)=x,x,0,newton_solver)
        Ex5: fsolve(cos(x)=x,x,0,secant_solver)
        Ex6: fsolve(cos(x)=x,x,0,steffenson_solver)
        
        '''

     def segment(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for segment:
        segment((Pnt or Cplx or Lst([xM,yM])),(Pnt or Cplx or Lst([xN,yN]),[Var],[Var] or Opt)
        segment(A,B) draws the segment AB and segment([xM,yM],[xN,yN]) draws the vector as origin [xM,yM], of coordinates [xN,yN] (i.e draws segment(M,point(M+N)) or Option of the arc command.
        See also: 1/ line 2/ arc 
        Ex1:segment(i,1+i)
        Ex2:segment(point(i),point(1+i))
        Ex3:segment(point(i),point(1+i),A,B)
        Ex4:segment([-1,0],[2,1])
        Ex5:segment([-1,0],point([-1,0]+[2,1]))
        Ex6: arc(i,1,pi/4,segment)
        Ex7: affichage( arc(i,1,pi/4,segment),1+rempli)
        
        '''

     def seidel_spectrum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for seidel_spectrum:
        seidel_spectrum(Graph(G))
        Returns the Seidel spectrum of G as a list of lists with two elements, each containing an eigenvalue and its multiplicity.
        See also: 1/ graph_spectrum 
        Ex1:seidel_spectrum(graph("clebsch"))
        
        '''

     def seidel_switch(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for seidel_switch:
        seidel_switch(Graph(G),Lst(V))
        Returns a copy of G in which the edges between vertices in list V and vertices not in V are inverted (replaced with a set of edges from V to other vertices which are not present in G).
        See also: 1/ neighbors 2/ graph_complement 
        Ex1:seidel_switch(cycle_graph(5),[1,2])
        
        '''

     def select(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for select:
        select(FncBool(f),Lst(l))
        Selects the elements e of l such that f(e)=true.
        See also: 1/ remove 2/ range 
        Ex1:select(x->x>=5,[1,2,6,7])
        Ex2:select(x->isprime(x),range(20)).^2
        
        '''

     def semi_augment(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for semi_augment:
        semi_augment(Mtrx(A),Mtrx(B))
        Returns a matrix made with A and B, with n1+n2 rows and p columns if dim(A)=[n1,p] and dim(B)=[n2,p].
        See also: 1/ augment 
        Ex1:semi_augment([[68,-21],[56,59],[1,2]],[[68,-21],[56,59]])
        
        '''

     def seq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for seq:
        seq(Expr(Xpr),Var(Var)=Int(a..b),[Real(p)]||Expr(Xpr),Var(Var),Real(a),Real(b),[Real(p)])
        Returns the sequence (2 or 3 arg) or the list (4 or 5 arg) obtained when var goes from a to b (step p) in Xpr (or the Xpr is repeated n times or returns the sequence of reals from a to b (step p)).  And also seq(expression,variable,list) is equivalent to map(list,unapply(expression,variable)) 
        See also: 1/ $ 2/ makelist 3/ range 4/ map 5/ unapply 
        Ex1:seq(0.3,4)
        Ex2:seq(t,4)
        Ex3:seq(0,0)
        Ex4:seq(2^k,k=0..8)
        Ex5:seq(2^k,k=0..8,2)
        Ex6:seq(0.3..2,0.2)
        Ex7:seq(2^k,k,0,8)
        Ex8:seq(2^k,k,0,8,2)
        Ex9:seq(x^3,x,[1,2,3])
        Ex10: [seq(0.3..2,0.2)] 
        Ex11: a:=(1,2,3);eval(seq(a,4))
        
        '''

     def seqplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for seqplot:
        seqplot(Expr(f(Var)),Var=[a,xm,xM],Intg(p))
        For seeing the pth terms of the sequence u(0)=a,u(n)=f(u(n-1)).
        See also: 1/ seqsolve 2/ rsolve 
        Ex1:seqplot(sqrt(2+x),6,5)
        Ex2:seqplot(sqrt(2+t),t=6,5)
        Ex3:seqplot(sqrt(2+x),x=[6,1,7],5,affichage=epaisseur_ligne_2)
        
        '''

     def seqsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for seqsolve:
        seqsolve((Expr or LstExpr),(Var or LstVar),(InitVal or LstInitVal))
        Gives the value of a recurrent sequence (u_{n+1}=f(u_n) or u_{n+k}=f(u_n,u_{n+1}...u_{n+k-1})) or of a system of recurrent sequences.
        See also: 1/ rsolve 2/ plotseq 3/ tableseq 
        Ex1:seqsolve(2x+n,[x,n],1)
        Ex2:seqsolve(2x+n*3^n,[x,n],1)
        Ex3:seqsolve(x+y,[x,y,n],[1,1])
        Ex4:seqsolve(x+2*y+n+1,[x,y,n],[0,1])
        Ex5:seqsolve([x+2*y,n+1+x],[x,y,n],[0,1])
        Ex6:seqsolve([x+2*y+n+1,x],[x,y,n],[0,1])
        
        '''

     def sequence_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sequence_graph:
        sequence_graph(Lst(L))
        Returns an undirected graph with degree sequence equal to L.
        See also: 1/ degree_sequence 2/ is_graphic_sequence 
        Ex1:sequence_graph(degree_sequence(sequence_graph([3,2,4,2,3,4,5,7])))
        
        '''

     def series(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for series:
        series(Expr,Equal(var=limit_point),[Order],[Dir(1,0,-1)])
        Series expansion at finite or infinite points.
        See also: 1/ limit 2/ taylor 3/ pad 4/ polynom 5/ truncate 
        Ex1:series(sin(x)/x,x=0)
        Ex2:series(sin(x),x=0,6,polynom)
        Ex3:series(ln(x+x^2)-ln(x),x=0,1)
        Ex4:series((x^4+x+2)/(x^2+1),x=0,5)
        Ex5: series("h",8); ln(1+h);
        Ex6:series(1/(1+x+y),[x,y],[0,0],5) 
        Ex7:series(sin(x*y),[x,y],[1,pi/2],3)
        Ex8:series(sin((1+h*t)*(pi/2+k*t)),t=0,3,polynom)(t=1)
        Ex9:series(y^2/x^3,[x,y],[1,-1],3)
        Ex10:series((-1+k*t)^2/(1+h*t)^3,t=0,3,polynom)(t=1)
        Ex11:series(subst(sin(x+y)+cos(y*x),[x,y],h*[x,y]),h=0,6,polynom)
        Ex12:series(subst(sin(x+y)+cos(y*x),[x,y],h*[x,y]),h=0,6,polynom)(h=1)
        Ex13: truncate(series(sin(x),x=0,6),6)
        
        '''

     def set_channel_data(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_channel_data:
        set_channel_data(Audio(clip),Lst||Mtrx(data),[Intg(offset),Intg(chn)]||Image(img),Intg(chn),Intg(x),Intg(y),Mtrx(data))
        Returns a copy of an audio clip/image object with the sample/pixel data (in channel chn starting at offset/(x,y)) set to the values in data.
        See also: 1/ channel_data 2/ channels 
        Ex1: clip:=readwav("sample.wav");set_channel_data(clip,0$20000,40000,left)
        Ex2: logo:=image("xcas-logo.png");set_channel_data(logo,blue,0,0,(-logo)[red])
        
        '''

     def set_edge_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_edge_attribute:
        set_edge_attribute(Graph(G),Edge(e),Seq(tag1=value1,tag2=value2,..))
        Stores the attributes to the edge e and returns a modified copy of G.
        See also: 1/ discard_edge_attribute 2/ get_edge_attribute 3/ list_edge_attributes 
        Ex1:set_edge_attribute(cycle_graph(3),[1,2],"cost"=12.4)
        
        '''

     def set_edge_weight(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_edge_weight:
        set_edge_weight(Graph(G),Edge(e),Real(w))
        Sets the weight of the edge e in the weighted graph G to w and returns a modified copy of G.
        See also: 1/ is_weighted 2/ get_edge_weight 3/ make_weighted 4/ weight_matrix 
        Ex1:set_edge_weight(graph(%{[1,2],[2,3]%}),[1,2],5)
        
        '''

     def set_graph_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_graph_attribute:
        set_graph_attribute(Graph(G),Seq(tag1=value1,tag2=value2,..))
        Stores the attributes where each tag is a string, and returns a modified copy of G.
        See also: 1/ discard_graph_attribute 2/ get_graph_attribute 3/ list_graph_attributes 
        Ex1:set_graph_attribute(cycle_graph(3),"name"="cycle graph")
        
        '''

     def set_pixel(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_pixel:
        set_pixel(Intg(x),Intg(y),Intg(col))
        Pixel on and adds to the list of pixels. Run set_pixel() or show_pixels() to display, set_pixel(n) to zoom.
        See also: 1/ clear 2/ show_pixels 3/ draw_line 4/ draw_rectangle 5/ draw_polygon 
        Ex1: clear(); set_pixel(4); draw_pixel(1,2,red); show_pixels();
        
        '''

     def set_screen(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_screen:
        set_screen(Intg(x),Intg(y))
        Defines the virtual screen sizes for get_key()
        See also: 1/ set_pixel 
        
        '''

     def set_vertex_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_vertex_attribute:
        set_vertex_attribute(Graph(G),Vrtx(v),Seq(tag1=value1,tag2=value2,..))
        Stores the attributes to the vertex v and returns a modified copy of G.
        See also: 1/ discard_vertex_attribute 2/ get_vertex_attribute 3/ list_vertex_attributes 
        Ex1:set_vertex_attribute(cycle_graph(3),1,"supply"=27)
        
        '''

     def set_vertex_positions(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for set_vertex_positions:
        set_vertex_positions(Graph(G),Lst(vp))
        Sets the coordinates, given in the list vp, to the vertices of G and returns a modified copy of G.
        See also: 1/ draw_graph 
        Ex1: G:=graph([1,2,3,4,5,6],%{[1,2],[1,4],[4,5],[2,5],[2,3],[3,6],[5,6]%}); G:=set_vertex_positions(G,[[0,0],[0.5,0],[1,0],[0,0.5],[0.5,0.5],[1,0.5]])
        
        '''

     def shift(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for shift:
        shift(Lst,[Intg(n)])
        Returns the list where the last element [or the tail beginning with the n-th element] is moved to the first element and then completed with 0s (by default n=-1);L:=shift(L,2) o L.shift(2).
        See also: 1/ rotate 2/ tail 
        Ex1:shift([0,1,2,3],2)
        Ex2:shift([0,1,2,3])
        Ex3:shift([0,1,2,3,4])
        Ex4: L:=[0,1,2,3];L:=shift(L,2)
        Ex5: L:=[0,1,2,3];L.shift(2)
        
        '''

     def shift_phase(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for shift_phase:
        shift_phase(Expr)
        shift_phase returns the expressions where the phase of the evaluated trigonometric expressions is increased by pi/2.
        See also: 1/ series 
        Ex1:shift_phase(sin(x))
        Ex2:shift_phase('sin(x+pi/2)')
        Ex3:shift_phase(x+sin(x))
        Ex4:shift_phase(x+sin(x))
        Ex5:shift_phase(cos(t))
        Ex6:shift_phase(tan(u))
        
        '''

     def shortest_path(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for shortest_path:
        shortest_path(Graph(G),Vrtx(s),Vrtx(t)||Lst(T))
        Returns the shortest path from vertex s to vertex t in G, or an empty list if there is no such path. If vector T of vertices from G is given, then the list of shortest paths from s to each t int T is returned.
        See also: 1/ dijkstra 2/ vertex_distance 
        Ex1:shortest_path(cycle_graph(6),1,5)
        
        '''

     def show_pixels(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for show_pixels:
        show_pixels(NULL)
        Displays the list of pixels.
        See also: 1/ set_pixel 2/ clear 
        Ex1:show_pixels()
        
        '''

     def shuffle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for shuffle:
        shuffle(Intg(n)||Lst(L))
        Returns a random permutation of [0,1,2,..,n-1] or of the list L.
        See also: 1/ permu2cycles 2/ is_permu 3/ permu2mat 
        Ex1:shuffle(4)
        Ex2:shuffle(7)
        Ex3:shuffle([1,3,5,7,9])
        Ex4: L:=[1,3,5,7,9];L:=randperm(L)
        Ex5: L:=[1,3,5,7,9];L.randperm()
        
        '''

     def sierpinski_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sierpinski_graph:
        sierpinski_graph(Intg(n),Intg(k),[triangle])
        Returns the Sierpiński (triangle) graph S(n,k) (resp. ST(n,k)).
        See also: 1/ graph 
        Ex1:sierpinski_graph(2,4)
        Ex2:sierpinski_graph(4,3)
        Ex3:sierpinski_graph(3,4)
        Ex4:sierpinski_graph(3,2)
        Ex5:sierpinski_graph(3,3,at_triangle)
        
        '''

     def sign(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sign:
        sign(Expr)
        Returns the sign (-1,0,+1) of its argument.
        See also: 1/ abs 
        Ex1:sign(-4)
        Ex2:sign(4-5)
        
        '''

     def sign2Heaviside(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sign2Heaviside:
        sign2Heaviside(Expr)
        Replaces sign function by Heaviside function in an expression.
        See also: 1/ Heaviside 2/ sign 3/ Heaviside2sign 4/ simpd 
        Ex1:sign2Heaviside(sign(x))
        
        '''

     def signature(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for signature:
        signature(Permut)
        Returns the signature of a permutation.
        See also: 1/ permu2cycles 2/ is_permu 
        Ex1:signature([1,0,3,4,2])
        
        '''

     def signe(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for signe:
        signe(Str(s))
        Writes the string s with the font 20 at the point [10,10].
        See also: 1/ ecris 
        Ex1:signe("Thomas")
        Ex2:signe(Thomas)
        
        '''

     def similarity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for similarity:
        similarity(Pnt or Dr3,Real,Angle,Pnt)
        similarity(B,k,a1,A)=transformation of A in the similarity (center B or axis d, coeff k,angle a1) (or also homothety(B,k*exp(i*a1),A)).
        See also: 1/ homothety 
        Ex1:similarity(1+i,2,pi/3,i)
        Ex2:similarity(line(x=y,y=z),2,pi/3,point(-1,2,1))
        Ex3: s:=similarity(1+i,2,pi/3);s(i)
        Ex4: s:=similarity(line(x=y,y=z),2,pi/3),s(point(-1,2,1))
        
        '''

     def simp2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simp2:
        simp2(Intg(A) or Poly(A),Intg(B) or Poly(B))
        Returns the list [A/gcd(A,B),B/gcd(A,B)].
        See also: 1/ gcd 
        Ex1:simp2(12,18)
        Ex2:simp2(x^3-1,x^2-1)
        
        '''

     def simplex_reduce(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simplex_reduce:
        simplex_reduce(Mtrx(A), Vect(b), Vect(c))
        Reduction by simplex algorithm to find max(c.x) under A.x<=b and x>=0, b>=0. Returns the maximum, the augmented solution x and the reduced matrix. Accepts also [[A|I|b],[-c|*|0]] as argument.
        Ex1:simplex_reduce([[3,2,2],[1,1,1]],[3,4],[1,2,3])
        Ex2:simplex_reduce([[3,2,2,1,0,3],[1,1,1,0,1,4],[-1,-2,-3,0,0,0]])
        Ex3:simplex_reduce([[-3,2],[1,1]],[3,4],[1,2])
        Ex4:simplex_reduce([[-3,2,1,0,3],[1,1,0,1,4],[-1,-2,0,0,0]])
        Ex5:simplex_reduce([[2,1,1,1,0,0,2],[1,2,3,0,1,0,5],[2,2,1,0,0,1,6],[-3,-1,-3,1,-1,2,0]])
        
        '''

     def simplicial_vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simplicial_vertices:
        simplicial_vertices(Graph(G))
        Returns the list of simplicial vertices in an undirected graph G.
        See also: 1/ is_clique 2/ neighbors 
        Ex1:simplicial_vertices(graph("goldner-harary"))
        
        '''

     def simplifier(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simplifier:
        simplifier(Expr)
        Simplifies an expression.
        See also: 1/ normal 
        Ex1:simplifier(4*atan(1/5)-atan(1/239))
        Ex2:simplifier(texpand((sin(3*x)+sin(7*x))/sin(5*x)))
        Ex3:simplifier(texpand((cos(3*x)+cos(7*x))/cos(5*x)))
        
        '''

     def simplify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simplify:
        simplify(Expr)
        Simplifies an expression.
        See also: 1/ normal 
        Ex1:simplify(4*atan(1/5)-atan(1/239))
        Ex2:simplify(texpand((sin(3*x)+sin(7*x))/sin(5*x)))
        Ex3:simplify(texpand((cos(3*x)+cos(7*x))/cos(5*x)))
        
        '''

     def simplifyDirac(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simplifyDirac:
        simplifyDirac(Expr,[Seq(vars)])
        Simplifies expressions involving Dirac delta distribution.
        See also: 1/ simplify 2/ Dirac 
        Ex1:simplifyDirac(Dirac(a*x),x)
        Ex2:simplifyDirac(Dirac(x,1)*x)
        Ex3:simplifyDirac(Dirac(x^2-x-6))
        
        '''

     def simpson(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simpson:
        simpson(Opt)
        Option of the area command.
        See also: 1/ area 
        Ex1: area(x^2,x=0..1,5,simpson)
        Ex2: area(x^2,x=0..1,5,rombergt)
        Ex3: area(x^2,x=0..1,5,rombergm)
        Ex4:simpson(area(x^2,x=0..1,5,gauss15))
        
        '''

     def simulated_annealing(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simulated_annealing:
        simulated_annealing(x0,Func(cost),Func(dist),Func(step),Lst(csparam),[Lst(iterparam),[Real(maxstep)]])
        Returns the point in a search space which minimizes the cost function using the method of simulated annealing, starting from an initial configuration x0.
        See also: 1/ nlpsolve 2/ fMin 3/ find_minimum 
        Ex1:simulated_annealing(2,x->x^2+sin(20x)/5,(x,y)->abs(x-y),(x,m)->rand(x-m,x+m),[1,0.1,1.002,1e-6],[5,20],1)
        
        '''

     def simult(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for simult:
        simult(Mtrx(A),Mtrx(B))
        Returns the matrix where the column of index k is solution of A*X=column of index k of B (=B[0..nr-1,k..k] with nr=number of rows of B).
        See also: 1/ rref 2/ linsolve 
        Ex1:simult([[3,1],[3,2]],[[-2],[2]])
        Ex2:simult([[3,1],[3,2]],[[-2,1],[2,-1]])
        
        '''

     def sin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sin:
        sin(Expr or Opt)
        Sine or option of the convert or convertir command (id trigsin).
        See also: 1/ asin 2/ convert 3/ trigsin 
        Ex1:sin(0)
        Ex2: convert(cos(x)^4+sin(x)^2,sin)
        
        '''

     def sin2costan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sin2costan:
        sin2costan(Expr)
        Replaces sin(x) by cos(x)*tan(x) in the argument.
        See also: 1/ tan2sincos 2/ cos2sintan 3/ tan2sincos2 4/ tan2cossin2 
        Ex1:sin2costan(sin(x))
        
        '''

     def sinc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sinc:
        sinc(Expr(x))
        Returns the value of the cardinal sine function at x.
        See also: 1/ sin 
        Ex1:sinc(pi*x)
        
        '''

     def sincos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sincos:
        sincos(Expr or Opt)
        Transforms the complex exponential into sine and cosine (id exp2trig) or option of the convert or convertir command (id sincos).
        See also: 1/ trig2trig 2/ trig2exp 3/ atrig2ln 4/ convert 
        Ex1:sincos(exp(i*x))
        Ex2:sincos(exp(-i*x))
        Ex3: convert(exp(i*x),sincos)
        
        '''

     def single_inter(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for single_inter:
        single_inter(Curve,Curve,[Pnt(A)||LstPnt(L)])
        Gives one of the points of intersection of 2 curves or surfaces (or the intersection near A or not in L).
        See also: 1/ intersect 2/ head 
        Ex1:single_inter(line(i,1-i),line(0,1))
        Ex2:single_inter(line(i,1-i),circle(0,1))
        Ex3:single_inter(line(i,1+2*i),circle(0,1),[point(i)])
        Ex4:single_inter(line(-1-i,1+2*i),circle(0,1),point(-1))
        Ex5:single_inter(circle(1,sqrt(2)),circle(0,1))
        Ex6:single_inter(plane(x=y),plane(y=z))
        Ex7:single_inter(line(x=y+1,y=2*z),plane(y=z))
        
        '''

     def sinh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sinh:
        sinh(Expr)
        Hyperbolic sine.
        See also: 1/ asinh 
        Ex1:sinh(0)
        
        '''

     def sizes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sizes:
        sizes(Lst or Str or Seq)
        Returns the list of sizes of a list of lists.
        See also: 1/ size 2/ dim 
        Ex1:sizes([[1,2,3],[1,2],[1]])
        
        '''

     def slope(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for slope:
        slope(Line||Pnt||Cplx,[Pnt||Cplx])
        Returns the slope of the line defined in the argument or is an attribute of line.
        See also: 1/ line 2/ tangent 3/ LinTan 4/ slopeatraw 5/ slopeat 
        Ex1:slope(line(1,2i))
        Ex2:slope(segment(1,2i))
        Ex3:slope(1,2i)
        Ex4:slope(line(y+2x=2))
        Ex5:slope(point(1),point(2i))
        Ex6:slope(tangent(plotfunc(sin(x)),pi/4))
        Ex7:slope(LineTan(sin(x),pi/4))
        Ex8: line(point(1,2),slope=-1)
        
        '''

     def slopeat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for slopeat:
        slopeat(Line, Pnt||Cplx(z0))
        slopeat(d,z0) displays at the point(z0), with a legend, the value of the slope of the line or segment d.
        See also: 1/ slope 2/ slopeatraw 
        Ex1: A:=point(0);B:=point(1+i);slopeat(droite(A,B),(1+i)/2)
        Ex2: s:=segment(1-i,i);slopeat(s,point(0.4))
        Ex3: t:=tangent(plotfunc(sin(x)),pi/4);slopeat(t,0)
        
        '''

     def slopeatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for slopeatraw:
        slopeatraw(Line, Pnt||Cplx(z0))
        slopeatraw(d,z0) displays at point(z0), the value of the slope of the line or segment d.
        See also: 1/ slope 2/ slopeat 
        Ex1: A:=point(0);B:=point(1+i);slopeatraw(droite(A,B),(1+i)/2)
        Ex2: s:=segment(1-i,i);slopeatraw(s,point(0.4))
        Ex3:slopeatraw(tangent(plotfunc(sin(x)),pi/4),0)
        Ex4:slopeatraw((LineTan sin(x),pi/4),i)
        
        '''

     def smith(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for smith:
        smith(Matr(A))
        Returns the Smith normal form of a matrix with polynomial coefficients (U,D,V tels que U*A*V=D)
        See also: 1/ hermite 2/ ismith 3/ ihermite 
        Ex1: n:=10; a:=ranm(n,n) % 17; u,b,v:=smith(x-a);normal(u*(x-a)*v-b); diag(b);
        Ex2: GF(3,5,g); n:=3; a:=ranm(n,n,g); u,b,v:=smith(x-a);normal(u*(x-a)*v-b); diag(b);
        
        '''

     def smod(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for smod:
        smod(Intg,Intg)
        Returns the Euclidean symmetric remainder of two integers.
        See also: 1/ irem 2/ iquo 3/ mod 4/ fracmod 
        Ex1:smod(8,3)
        Ex2:smod(10,4)
        Ex3:smod(11,7)
        
        '''

     def snedecor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for snedecor:
        snedecor(Intg(n),Intg(m),Real(x0))
        Returns the probability density of the Fisher-Snedecor law (n and m are the numbers of degrees of freedom).
        See also: 1/ fisher_cdf 2/ fisher_icdf 3/ randvector 4/ ranm 
        Ex1:snedecor(4,10,2.1)
        Ex2:snedecor(4,4,2.1)
        Ex3: randvector(5,fisher,4,6)
        Ex4: ranm(2,3,fisher,4,6)
        
        '''

     def snedecor_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for snedecor_cdf:
        snedecor_cdf(Intg(n),Intg(m),Real(x0))
        Returns the probability that a Fisher-Snedecor random variable is less than x0 (n and m are the numbers of degrees of freedom).
        See also: 1/ UTPF 2/ fisher_icdf 3/ fisherd 
        Ex1:snedecor_cdf(4,4,2.1)
        Ex2:snedecor_cdf(4,10,3.5)
        
        '''

     def snedecor_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for snedecor_icdf:
        snedecor_icdf(Intg(n),Intg(m),Real(p))
        Returns h such as the probability that a Fisher-Snedecor random variable is less than h is p (n and m are the numbers of degrees of freedom and 0<=p<=1).
        See also: 1/ fisher_cdf 2/ fisherd 
        Ex1:snedecor_icdf(4,10,0.95)
        Ex2:snedecor_icdf(4,10,0.05)
        
        '''

     def snedecord(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for snedecord:
        snedecord(Intg(n),Intg(m),Real(x0))
        Returns the probability density of the Fisher-Snedecor law (n and m are the numbers of degrees of freedom).
        See also: 1/ fisher_cdf 2/ fisher_icdf 3/ randvector 4/ ranm 
        Ex1:snedecord(4,10,2.1)
        Ex2:snedecord(4,4,2.1)
        Ex3: randvector(5,fisher,4,6)
        Ex4: ranm(2,3,fisher,4,6)
        
        '''

     def snedecord_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for snedecord_cdf:
        snedecord_cdf(Intg(n),Intg(m),Real(x0))
        Returns the probability that a Fisher-Snedecor random variable is less than x0 (n and m are the numbers of degrees of freedom).
        See also: 1/ UTPF 2/ fisher_icdf 3/ fisherd 
        Ex1:snedecord_cdf(4,4,2.1)
        Ex2:snedecord_cdf(4,10,3.5)
        
        '''

     def snedecord_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for snedecord_icdf:
        snedecord_icdf(Intg(n),Intg(m),Real(p))
        Returns h such as the probability that a Fisher-Snedecor random variable is less than h is p (n and m are the numbers of degrees of freedom and 0<=p<=1).
        See also: 1/ fisher_cdf 2/ fisherd 
        Ex1:snedecord_icdf(4,10,0.95)
        Ex2:snedecord_icdf(4,10,0.05)
        
        '''

     def solid_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for solid_line:
        solid_line(Opt)
        Option of the display command for a line.
        See also: 1/ display 
        Ex1: display(line(y=x),green+dash_line+line_width_2)
        Ex2: d:=display(line(2+i,1),cap_round_line)
        
        '''

     def solve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for solve:
        solve(Expr,[Var])
        Solves a (or a set of) polynomial equation.
        See also: 1/ linsolve 2/ proot 3/ fsolve 4/ csolve 5/ nSolve 
        Ex1:solve(x^2-3=1)
        Ex2:solve(x^3-3*y,y)
        Ex3:solve([y-z=0,z-x=0,x-y=0,x-1+y+z=0],[x,y,z])
        Ex4:solve([x^2-y^2=0,x^2-z^2=0],[x,y,z])
        
        '''

     def somme(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for somme:
        somme(Expr,Var,VarMin(a),VarMax(b),[VarStep(p)])
        Discrete sum (with 2 or 4 arguments return then sum from a to b if a<=b or of the opposite of the sum from b+1 to a-1 if a>b+1 or 0 if a=b+1) or the discrete primitive or sum of the elements of a list or a sequence.
        See also: 1/ + 
        Ex1:somme(1/n^2,n,1,17)
        Ex2:somme(1/n^2,n=1..17)
        Ex3:somme(1/n^2,n,17,1)
        Ex4:somme(1/n^2,n=17..1)
        Ex5:somme(1/n^2,n,17,1,1)
        Ex6:somme(1/n^2,n,1,17,2)
        Ex7:somme([1,2,3,4])
        Ex8:somme([[1,2,3,4,5,6,7,8,9],[1,2,3,4,5,6,7,8,9]])
        Ex9:somme(1/(x*(x+1)),x)
        Ex10:somme(cos(n*x),n)
        
        '''

     def sommet(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sommet:
        sommet(Op or Fnct)
        Returns the top of an operator.
        See also: 1/ feuille 2/ quote 
        Ex1:sommet(quote(gcd(45,123)))
        Ex2:sommet('gcd(45,123)')
        
        '''

     def sort(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sort:
        sort(LstReal or Seq [Fnc])
        Returns the sorted list (or sequence) with increasing order according to the second argument which defines a weak strict ordering or sorts and collects equal terms in sums and products.
        See also: 1/ SortA 2/ SortD 
        Ex1:sort([3,2,2,4,1,0])
        Ex2:sort(3,2.1,2,4,1,0)
        Ex3:sort([3,4,2],(x,y)->x>y)
        Ex4:sort([[1,2],[2,3],[4,3]],(x,y)->when(x[1]==y[1],x[0]>y[0],x[1]>y[1]))
        Ex5:sort(y*x*2+x*y)
        
        '''

     def sorta(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sorta:
        sorta(LstReal||Seq×||Mtrx)
        Sorts the list in increasing order or sorts the columns of the matrix so the first row is in increasing order.
        See also: 1/ SortA 2/ sortd 3/ sort 
        Ex1:sorta(3,4,2)
        Ex2:sorta([3,4,2])
        Ex3:sorta([[3,4,2],[6,4,5]])
        
        '''

     def sortd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sortd:
        sortd(LstReal||Seq||Mtrx)
        Sorts the list in decreasing order or sorts the columns of the matrix so the first row is in decreasing order.
        See also: 1/ SortD 2/ sorta 3/ sort 
        Ex1:sortd(3,4,2)
        Ex2:sortd([3,4,2])
        Ex3:sortd([[3,4,2],[6,4,5]])
        
        '''

     def sorted(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sorted:
        sorted(LstReal or Seq [Fnc])
        Returns the sorted list (or sequence) with increasing order according to the second argument which defines a weak strict ordering or sorts and collects equal terms in sums and products.
        See also: 1/ SortA 2/ SortD 
        Ex1:sorted([3,2,2,4,1,0])
        Ex2:sorted(3,2.1,2,4,1,0)
        Ex3:sorted([3,4,2],(x,y)->x>y)
        Ex4:sorted([[1,2],[2,3],[4,3]],(x,y)->when(x[1]==y[1],x[0]>y[0],x[1]>y[1]))
        Ex5:sorted(y*x*2+x*y)
        
        '''

     def sortperm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sortperm:
        sortperm(Lst(V),[Permu(P)])
        Sorts the list V according to the permutation P or outputs the permutation which sorts V in ascending order.
        See also: 1/ sort 2/ sortA 
        Ex1:sortperm([30,25,40,10,20])
        Ex2:sortperm(["ab","cd","ad","bc","de"],[3,4,1,0,2])
        
        '''

     def soundsec(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for soundsec:
        soundsec(Intg(n),[Intg(N)])
        Generates a vector coding n seconds of time/N (default N=44100).
        See also: 1/ readwav 2/ writewav 3/ playsnd 
        Ex1:soundsec(1)
        Ex2:soundsec(1,22100)
        
        '''

     def spanning_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for spanning_tree:
        spanning_tree(Graph(G),[Vrtx(r)])
        Returns a spanning tree of an undirected graph G [with r as the root node].
        See also: 1/ number_of_spanning_trees 2/ minimal_spanning_tree 
        Ex1:spanning_tree(graph("petersen"))
        Ex2:spanning_tree(graph("petersen"),5)
        
        '''

     def sphere(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sphere:
        sphere((Pnt or Vect),(Pnt or Real))
        sphere(A,B) (resp sphere(A,r)) draws the sphere with diameter AB (resp center A and radius r) in 3D space.
        See also: 1/ circle 
        Ex1:sphere([0,0,0],[2,2,2])
        Ex2:sphere([1,1,1],1)
        
        '''

     def splice(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for splice:
        splice(Audio(clip1),Audio(clip2),[Intg(len),Real(p)])
        Joins clip1 and clip2 with overlap of length len and crossfade determined by p>0.
        See also: 1/ + 2/ mixdown 
        Ex1: t:=soundsec(2):;clip:=splice(createwav(sin(2*pi*440*t)),createwav(sin(2*pi*220*t)),1000,0.75):;playsnd(clip)
        
        '''

     def spline(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for spline:
        spline(Lst(lx),Lst(ly),Var(x),Intg(d))
        Natural spline through the points given by the lx and ly lists, variable x, degree d.
        See also: 1/ lagrange 
        Ex1:spline([0,1,2],[1,3,0],x,3)
        
        '''

     def split(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for split:
        split((Expr(Xpr),Lst(var1,var2))||(Str(s),Str(sep)))
        Splits the two variables var1,var2 of the expression Xpr (without denominator) or returns [0], or splits a string into a list of substrings with respect to a given separator.
        See also: 1/ factor 2/ join 
        Ex1:split(x^3*y^2-y^2+x^3-1,[x,y])
        Ex2:split(x^3*y^2-y^2+x^3+1,[x,y])
        Ex3:split("This is a phrase"," ")
        
        '''

     def spring(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for spring:
        spring(Opt)
        Option for the draw_graph command.
        See also: 1/ planar 2/ tree 3/ draw_graph 
        
        '''

     def sq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sq:
        sq(Seq)
        Is the name of the function (ℝ^n -> ℝ)=sum of the squares of the arguments.
        See also: 1/ sqrt 
        Ex1:sq(5)
        Ex2:sq(1,2,3)
        
        '''

     def sqrfree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sqrfree:
        sqrfree(Expr)
        Factorization of the its argument gathering the terms with the same exponent.
        See also: 1/ factor 
        Ex1:sqrfree(x^4-2*x^2+1)
        Ex2:sqrfree((x-2)^7*(x+2)^7*(x^4-2*x^2+1))
        
        '''

     def sqrt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sqrt:
        sqrt(Expr)
        Square root.
        See also: 1/ surd 2/ ^ 
        Ex1:sqrt(50)
        Ex2:sqrt(x^2)
        
        '''

     def square(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for square:
        square((Pnt(A) or Cplx),(Pnt(B) or Cplx),[Pnt(P),Var(C),Var(D)])
        Returns and draws the square of side AB (ABCD is direct) (in the plane ABP).
        See also: 1/ rhombus 2/ quadrilateral 
        Ex1:square(i,1+i)
        Ex2:square(i,1+i,C,D)
        Ex3:square(point(0,0,0),point(3,3,3),point(0,0,3))
        Ex4:square(point(0,0,0),point(3,3,3),point(0,0,3),C,D)
        
        '''

     def square_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for square_point:
        square_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def srand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for srand:
        srand()
        srand returns an integer and initializes the sequence of random numbers.
        See also: 1/ RandSeed 
        Ex1:srand(12)
        Ex2: srand
        
        '''

     def sst(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sst:
        sst(NULL)
        Steps 1 instruction.
        See also: 1/  
        Ex1:sst()
        
        '''

     def sst_in(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sst_in:
        sst_in(NULL)
        Enters into a function in step-by-step mode.
        See also: 1/  
        Ex1:sst_in()
        
        '''

     def st_ordering(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for st_ordering:
        st_ordering(Graph(G),Vrtx(s),Vrtx(t))
        Returns ST numbering for a biconnected graph G with source s and sink (target) t.
        See also: 1/ is_biconnected 
        Ex1:st_ordering(graph("petersen"),1,2)
        
        '''

     def star_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for star_graph:
        star_graph(Intg(n))
        Returns a complete bipartite graph complete_graph(1,n).
        See also: 1/ complete_graph 2/ wheel_graph 
        Ex1:star_graph(5)
        
        '''

     def star_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for star_point:
        star_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def stdDev(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for stdDev:
        stdDev(Lst||Mtrx,[Lst])
        Returns an unbiased estimate of the population standard deviation of the sample (first argument) with an optional list of weight as second argument.
        See also: 1/ mean 2/ stddev 
        Ex1:stdDev([1,2,3])
        Ex2:stdDev([1,2,3],[1,2,1])
        Ex3:stdDev([[1,2,3],[5,6,7]])
        
        '''

     def stddev(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for stddev:
        stddev(Lst||Mtrx,[Lst])
        Returns the standard deviation of the elements of its argument with an optional second argument as weight or the list of standard deviations of the columns of a matrix.
        See also: 1/ mean 2/ variance 3/ stddevp 
        Ex1:stddev([1,2,3])
        Ex2:stddev([1,2,3],[1,2,1])
        Ex3:stddev([[1,2,3],[5,6,7]])
        
        '''

     def stddevp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for stddevp:
        stddevp(Lst||Mtrx,[Lst])
        Returns an unbiased estimate of the population standard deviation of the sample (first argument) with an optional list of weight as second argument.
        See also: 1/ mean 2/ stddev 
        Ex1:stddevp([1,2,3])
        Ex2:stddevp([1,2,3],[1,2,1])
        Ex3:stddevp([[1,2,3],[5,6,7]])
        
        '''

     def steffenson_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for steffenson_solver:
        steffenson_solver(Opt)
        Argument for fsolve giving the method for solving a numerical equation.
        See also: 1/ fsolve 
        Ex1: fsolve(cos(x)=x,x,0..1,bisection_solver)
        Ex2: fsolve(cos(x)=x,x,0..1,brent_solver)
        Ex3: fsolve(cos(x)=x,x,0..1,falsepos_solver)
        Ex4: fsolve(cos(x)=x,x,0,newton_solver)
        Ex5: fsolve(cos(x)=x,x,0,secant_solver)
        Ex6: fsolve(cos(x)=x,x,0,steffenson_solver)
        
        '''

     def stereo2mono(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for stereo2mono:
        stereo2mono(Audio(clip))
        Returns an audio clip with all channels in the input clip averaged to a single one.
        See also: 1/ channel_data 2/ mean 3/ createwav 
        Ex1:stereo2mono(readwav("/some/file"))
        
        '''

     def stft(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for stft:
        stft(Lst(data))
        Short-time Fourier transform.
        See also: 1/ istft 2/ fft 
        Ex1:stft([0.2,-0.8,0.4,0.6,0.1,-0.2,0.5,-0.3],2)
        Ex2:stft(randvector(1024,randvar(normal,0,0.1)))
        
        '''

     def str(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for str:
        str(Expr or Opt)
        Returns the evaluated expression as a string or is an option of the convert or convertir command (id string).
        See also: 1/ expr 2/ format 3/ convert 
        Ex1:str(1.23)
        Ex2:str(a:=12)
        Ex3:str(quote(a:=12))
        Ex4: convert(quote(a:=12),string)
        
        '''

     def strip(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for strip:
        strip(Str(s))
        Removes space characters from the beginning and end of a string.
        See also: 1/ trim 
        Ex1:strip("  an apple     ")
        
        '''

     def strongly_connected_components(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for strongly_connected_components:
        strongly_connected_components(Graph(G))
        Returns the list of strongly connected components in a digraph G.
        See also: 1/ connected_components 2/ is_connected 3/ is_strongly_connected 
        Ex1:strongly_connected_components(digraph([1,2,3],%{[1,2],[1,3],[2,3],[3,2]%}))
        
        '''

     def student(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for student:
        student(Intg(n),Real(x0))
        Returns the probability density of the Student law (n is the number of degrees of freedom).
        See also: 1/ student_cdf 2/ student_icdf 
        Ex1:student(3,5.2)
        Ex2:student(1,5.2)
        
        '''

     def student_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for student_cdf:
        student_cdf(Intg(n),Real(x0))
        Returns the probability that a Student random variable is less than x0 (n is the number of degrees of freedom).
        See also: 1/ UTPT 2/ student_icdf 3/ studentd 
        Ex1:student_cdf(3,2.35)
        Ex2:student_cdf(3,-3.2)
        
        '''

     def student_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for student_icdf:
        student_icdf(Intg(n),Real(p))
        Returns h such as the probability that a Student random variable is less than h is p (n is the number of degrees of freedom and 0<=p<=1).
        See also: 1/ student_cdf 2/ studentd 
        Ex1:student_icdf(3,0.95)
        Ex2:student_icdf(3,0.05)
        
        '''

     def studentd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for studentd:
        studentd(Intg(n),Real(x0))
        Returns the probability density of the Student law (n is the number of degrees of freedom).
        See also: 1/ student_cdf 2/ student_icdf 
        Ex1:studentd(3,5.2)
        Ex2:studentd(1,5.2)
        
        '''

     def studentt(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for studentt:
        studentt(Lst,Real,[Real],Fnc,[Real])
        T-Test/Student law: arg1=[success,trial] or [mean,sample size] or data, arg2=proportion or data, arg3 optional if data=sigma, arg4 alternative '!=' or '>' or '<', arg5 optional alpha confidence level.
        See also: 1/ normalt 2/ chisquaret 3/ kolmogorovt 
        Ex1:studentt([10,20],.5,.02,'!=',0.1)
        Ex2:studentt([0.48,20],0.5,0.1,'<')
        
        '''

     def sturm(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sturm:
        sturm(Poly,[Var],[Cplx(a)],[Cplx(b)])
        Sturm sequence corresponding to a polynomial or number of sign changes of this polynomial in ]a;b].
        See also: 1/ sturmseq 2/ sturmab 
        Ex1:sturm(x^3-1,x)
        Ex2:sturm(x^5-x^3,x)
        Ex3:sturm((x^5-x^3)/(x+2),x)
        Ex4:sturm(x^5-x^3,x,-2,5)
        Ex5:sturm(x^3-1,x,-2-i,5+3i)
        
        '''

     def sturmab(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sturmab:
        sturmab(Poly,Var,Cplx(a),Cplx(b))
        Number of sign changes of a polynomial in ]a;b] or of complex roots in a..b if a or b is non-real.
        See also: 1/ sturm 2/ sturmseq 3/ realroot 
        Ex1:sturmab(x^3-1,x,-2,5)
        Ex2:sturmab(x^3-1,x,-2-i,5+3i)
        
        '''

     def sturmseq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sturmseq:
        sturmseq(Poly,[Var])
        Sturm sequence corresponding to a polynomial or to a rational fraction.
        See also: 1/ sturm 2/ sturmab 
        Ex1:sturmseq(x^3-1,x)
        Ex2:sturmseq(x^5-x^3,x)
        Ex3:sturmseq((x^5-x^3)/(x+2),x)
        
        '''

     def style(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for style:
        style(Opt)
        Local option (Maple compatibility) of a graphic command to plot a line with dots with style=point.
        See also: 1/ line_width 
        Ex1: segment(0,point(1,1),style=point)
        Ex2: line(y=x,style=point,display=green+line_width_2)
        
        '''

     def subMat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subMat:
        subMat(Mtrx(A),Intg(n1),Intg(n2),Intg(n3),Intg(n4).)
        Extracts a sub matrix with first element=A[n1,n2] and last element=A[n3,n4].
        See also: 1/ mid 
        Ex1:subMat([[1,2],[3,4],[5,6]],1,0,2,1)
        
        '''

     def subdivide_edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subdivide_edges:
        subdivide_edges(Graph(G),Lst(E),[Intg(r)])
        Inserts r (by default 1) new vertices to each edge/arc in G contained in the list E (which may be a single edge/arc) and returns a modified copy of G. New vertices are labeled by the smallest available integers.
        See also: 1/ edges 
        Ex1:subdivide_edges(complete_graph(2,3),[[1,3],[1,4]],2)
        
        '''

     def subgraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subgraph:
        subgraph(Graph(G),Lst(E))
        Returns the subgraph of G defined by the edges in list E.
        See also: 1/ induced_subgraph 2/ highlight_subgraph 
        Ex1:subgraph(complete_graph(5),[[1,2],[2,3],[3,4],[4,1]])
        
        '''

     def subs(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subs:
        subs(Expr or Var=value,Var=value or Expr)
        Equivalent of subst except in maple_mode where the arguments are switched over, in maple_mode choose the second example.
        See also: 1/ subst 2/ maple_mode 3/ algsubs 4/ () 
        Ex1:subs(1/(4+x^2),x=2)
        Ex2:subs(x=2,1/(4+x^2))
        Ex3: f:=1/(4+x^2);f(x=2)
        
        '''

     def subsop(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subsop:
        subsop(Lst||Mtrx,Intg(n)=Expr)
        Replaces in the list (or the matrix) the element of index n with the expression (with Maple the arguments are switched over)(NULL remove this element).
        Ex1:subsop([0,1,2,3,4],2=sqrt(2)+1)
        Ex2:subsop([[1,2],[3,4]],[1,1]=5)
        Ex3:subsop([[1,2],[3,4]],1=[10,8])
        Ex4:subsop([0,1,2,3],'1=NULL')
        
        '''

     def subst(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subst:
        subst(Expr,Var(v)=value(a))
        Substitutes a value for a variable in an expression.
        See also: 1/ eval 2/ algsubs 3/ subs 4/ () 
        Ex1:subst(1/(4+x^2),x=2)
        Ex2:subst(1/(x^2+y^2),x=2,y=3)
        Ex3:subst(1/(x^2+y^2+z^2),[x=2,y=3,z=1])
        Ex4:subst(x-2/(4+x^2),x=1)
        Ex5:subst('integrate(sin(x^2)*x,x)',x=sqrt(t))
        Ex6:subst('sum(x^(n+1)/((n+p+1)*(n+1)),n,0,inf)',n=k-1)
        Ex7: f:=1/(x^2+y^2;f(x=2,y=3)
        
        '''

     def substituer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for substituer:
        substituer(Expr,Var(v)=value(a))
        Substitutes a value for a variable in an expression.
        See also: 1/ eval 2/ algsubs 3/ subs 4/ () 
        Ex1:substituer(1/(4+x^2),x=2)
        Ex2:substituer(1/(x^2+y^2),x=2,y=3)
        Ex3:substituer(1/(x^2+y^2+z^2),[x=2,y=3,z=1])
        Ex4:substituer(x-2/(4+x^2),x=1)
        Ex5:substituer('integrate(sin(x^2)*x,x)',x=sqrt(t))
        Ex6:substituer('sum(x^(n+1)/((n+p+1)*(n+1)),n,0,inf)',n=k-1)
        Ex7: f:=1/(x^2+y^2;f(x=2,y=3)
        
        '''

     def subtype(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for subtype:
        subtype(Expr)
        Returns 1 for a sequence,2 for a set, 10 for a polynomial and 0 otherwise.
        See also: 1/ DOM_LIST 2/ type 
        Ex1:subtype(1,2,3)
        Ex2:subtype(set[1,2,3])
        Ex3:subtype(poly1[1,2,3])
        Ex4:subtype([1,2,3])
        
        '''

     def sum(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sum:
        sum(Expr,Var,VarMin(a),VarMax(b),[VarStep(p)])
        Discrete sum (with 2 or 4 arguments return then sum from a to b if a<=b or of the opposite of the sum from b+1 to a-1 if a>b+1 or 0 if a=b+1) or the discrete primitive or sum of the elements of a list or a sequence.
        See also: 1/ + 
        Ex1:sum(1/n^2,n,1,17)
        Ex2:sum(1/n^2,n=1..17)
        Ex3:sum(1/n^2,n,17,1)
        Ex4:sum(1/n^2,n=17..1)
        Ex5:sum(1/n^2,n,17,1,1)
        Ex6:sum(1/n^2,n,1,17,2)
        Ex7:sum([1,2,3,4])
        Ex8:sum([[1,2,3,4,5,6,7,8,9],[1,2,3,4,5,6,7,8,9]])
        Ex9:sum(1/(x*(x+1)),x)
        Ex10:sum(cos(n*x),n)
        
        '''

     def sum_riemann(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sum_riemann:
        sum_riemann(Expr(Xpr),Lst(var1,var2))
        Returns an equivalent when var1=+infinity of the sum of Xpr(var1,var2) for var2 from 1 to var1 when the sum is a Riemann sum.
        See also: 1/  
        Ex1:sum_riemann(1/(n+k),[n,k])
        Ex2:sum_riemann(n/(n^2+k),[n,k])
        Ex3:sum_riemann(n/(n^2+k^2),[n,k])
        
        '''

     def suppress(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for suppress:
        suppress(Vect(L)||Str(l),Intg(n))
        Returns L without the element of index n; L:=suppress(L,n) or L.suppress(n).
        See also: 1/ tail 2/ mid 3/ remove 4/ insert 
        Ex1:suppress([0,1,2,3],2)
        Ex2:suppress("0123",2)
        Ex3: L:=[0,1,2,3];L:=suppress(L,2)
        Ex4: L:=[0,1,2,3];L.suppress(2)
        
        '''

     def surd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for surd:
        surd(Expr,Intg(n))
        Power 1/n.
        See also: 1/ sqrt 2/ ^ 
        Ex1:surd(8,3)
        Ex2:surd(-8,3)
        
        '''

     def svd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for svd:
        svd(Mtrx(A))
        For a square numerical real matrix A, returns U orthogonal, S vector of singular values, Q orthogonal such that A=U*diag(S)*tran(Q).
        Ex1:svd([[1,2],[3,4]])
        
        '''

     def swapcol(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for swapcol:
        swapcol(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by swapping the n1-th column and the n2-th column.
        See also: 1/ rowSwap 
        Ex1:swapcol([[1,2],[3,4],[5,6]],0,1)
        
        '''

     def swaprow(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for swaprow:
        swaprow(Mtrx(A),Intg(n1),Intg(n2))
        Returns the matrix obtained from A by swapping the n1-th row and the n2-th row.
        See also: 1/ rowAdd 2/ colSwap 
        Ex1:swaprow([[1,2],[3,4],[5,6]],1,2)
        
        '''

     def switch_axes(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for switch_axes:
        switch_axes([Intg(0 or 1)])
        switch_axes() puts or erases the axes of the graphic-screen.
        See also: 1/ gl_showaxes 2/ axes 
        Ex1:switch_axes()
        Ex2:switch_axes(0)
        Ex3:switch_axes(1)
        
        '''

     def sylvester(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for sylvester:
        sylvester(Poly,Poly,Var)
        Sylvester matrix of two polynomials.
        See also: 1/ resultant 
        Ex1:sylvester(x^2-1,x^3-1,x)
        Ex2:sylvester(x^3-p*x+q,3*x^2-p,x)
        
        '''

     def symb2poly(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for symb2poly:
        symb2poly(Expr, LstVar or [Var])
        Returns the coefficients of a polynomial with respect to the 2nd argument or if the second argument is a list the internal format of the polynomial.
        See also: 1/ poly2symb 2/ r2e 
        Ex1:symb2poly(x*3+2.1)
        Ex2:symb2poly(3*x*y+2*y+1,y)
        Ex3:symb2poly(3*x*y+2*y+1,x,y)
        Ex4:symb2poly(3*x*y+2*y+1,[x,y])
        Ex5:symb2poly(-x^4+x*3*y+2+y^2*z,[x,y,z])
        Ex6:symb2poly(-x^4+x*3*y+2+y^2*z,[x,y,z])
        
        '''

     def symbol(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for symbol:
        symbol(Opt)
        DOM_SYMBOLIC or symbol is the type of a symbolic variable, as returned by the type command. It is also an option of the assume command.
        See also: 1/ type 2/ assume 3/ DOM_INT 4/ DOM_FLOAT 
        Ex1: assume(a,symbol)
        Ex2: assume(a,DOM_SYMBOLIC)
        Ex3: a:=sqrt(2);type(a)
        Ex4: type(2x+1)
        
        '''

     def symbol_array(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for symbol_array:
        symbol_array(Strng(str),Seq(dim))
        Returns an array of symbols with base name str (which may contain index placeholders %) and specified dimensions dim=(d1,d2,...,dn).
        See also: 1/ make_symbol 
        Ex1:symbol_array("x",5)
        Ex2:symbol_array("a",2,3)
        Ex3:symbol_array("a%%",2,3)
        
        '''

     def syst2mat(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for syst2mat:
        syst2mat(LstLinEq,LstVar)
        Returns the matrix M=A|(-b) associate to the system Y=AX+b.
        See also: 1/ linsolve 2/ rref 
        Ex1:syst2mat([x-y=1,x+2*y],[x,y])
        
        '''

     def tCollect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tCollect:
        tCollect(Expr)
        Collects trigonometric expressions.
        See also: 1/ texpand 2/ tlin 
        Ex1:tCollect(sin(x)+cos(x))
        
        '''

     def tExpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tExpand:
        tExpand(Expr)
        Expands transcendental expressions.
        See also: 1/ tcollect 2/ tlin 3/ lin 4/ trigexpand 
        Ex1:tExpand(sin(2*x)+exp(x+y))
        Ex2:tExpand(cos(x+y))
        Ex3:tExpand(cos(3*x))
        
        '''

     def table(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for table:
        table(SeqEqual(index=value))
        Defines an array where the indices are strings or real numbers or defines a table with a matrix.
        See also: 1/ matrix 2/ convert 3/ array 
        Ex1:table(3=-10,"a"=10,"b"=20,"c"=30,"d"=40)
        Ex2: A:=[[0,1],[2,3]];table(A)  
        Ex3: B:=table([1,2]=12,[2,5]=25);matrix(B)
        
        '''

     def tablefunc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tablefunc:
        tablefunc(Expr,Var)
        Table of values of a function : you must be in a spreadsheet.
        See also: 1/ tabvar 2/ tableseq 
        Ex1:tablefunc(sin(x),x)
        Ex2:tablefunc(x^2-x-2,x)
        
        '''

     def tableseq(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tableseq:
        tableseq(Expr,(Var or LstVar),(InitVal or LstInitVal))
        Table of values of a sequence (in a spreadsheet.)
        See also: 1/ tablefunc 
        Ex1:tableseq(cos(x),x,0.0)
        Ex2:tableseq(x+y,[x,y],[1,1])
        
        '''

     def tabsign(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tabsign:
        tabsign(Expr,Var)
        Table of signs of a function.
        See also: 1/ tablefunc 2/ tabvar 
        Ex1:tabsign(x^2-x,x)
        Ex2:tabsign(x^2,x,-3,5)
        Ex3:tabsign(sin(x),x)
        
        '''

     def tabvar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tabvar:
        tabvar(Expr,Var)
        Table of variations of a function with its graph on DispG.
        See also: 1/ tablefunc 2/ tabsign 
        Ex1:tabvar(sin(x),x)
        Ex2:tabvar(1/ln(x^2-1),x,diff=1)
        Ex3:tabvar(x^2+x+1,x)
        Ex4:tabvar(x^2,x,-3,5)
        Ex5:tabvar([sin(2t),cos(3t)])
        
        '''

     def tail(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tail:
        tail(Lst or Seq or Str)
        Returns the list (or sequence or string) without its first element.
        See also: 1/ head 2/ mid 3/ left 4/ right 5/ back 
        Ex1:tail([3,2,4,1,0])
        Ex2:tail(3,2,4,1,0)
        Ex3:tail("bonjour")
        
        '''

     def tan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tan:
        tan(Expr)
        Tangent or option of the convert or convertir command (id halftan).
        See also: 1/ atan or Opt 2/ convert 3/ halftan 
        Ex1:tan(0)
        Ex2:tan(pi/4)
        Ex3: convert(tan(x),tan)
        
        '''

     def tan2cossin2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tan2cossin2:
        tan2cossin2(Expr)
        Replaces tan(x) by (1-cos(2*x))/sin(2*x) in the argument.
        See also: 1/ tan2sincos2 2/ tan2sincos 3/ sin2costan 4/ cos2sintan 
        Ex1:tan2cossin2(tan(x))
        
        '''

     def tan2sincos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tan2sincos:
        tan2sincos(Expr)
        Replaces tan(x) by sin(x)/cos(x) in the argument.
        See also: 1/ sin2costan 2/ cos2sintan 3/ tan2sincos2 4/ tan2cossin2 
        Ex1:tan2sincos(tan(x))
        
        '''

     def tan2sincos2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tan2sincos2:
        tan2sincos2(Expr)
        Replaces tan(x) by sin(2*x)/(1+cos(2*x)) in the argument.
        See also: 1/ tan2cossin2 2/ tan2sincos 3/ sin2costan 4/ cos2sintan 
        Ex1:tan2sincos2(tan(x))
        
        '''

     def tangent(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tangent:
        tangent(Curve(C),Pnt(A))
        tangent(C,A) draws the tangents (line or plane) to C through A.
        See also: 1/ LineTan 2/ droite_tangente 
        Ex1:tangent(circle(i,1+i),A)
        Ex2:tangent(plotfunc(sin(x)),3*pi/4)
        Ex3:tangent(plotfunc(sin(x)),point(3*pi/4+i*sqrt(2)/2))
        Ex4:tangent(plotfunc(x^2+y^2,[x,y]),[2,2])
        Ex5:tangent(plotfunc(x^2+y^2,[x,y]),point([2,2,8]))
        Ex6:tangent(plotparam(3*exp(t/2)*exp(i*t),t),7)
        Ex7:tangent(plotpolar(3*exp(t/2),t),7)
        Ex8: equation(tangente([2*cos(t),2*sin(t),3*t],t))
        
        '''

     def tangente(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tangente:
        tangente(Curve(C),Pnt(A))
        tangent(C,A) draws the tangents (line or plane) to C through A.
        See also: 1/ LineTan 2/ droite_tangente 
        Ex1:tangente(circle(i,1+i),A)
        Ex2:tangente(plotfunc(sin(x)),3*pi/4)
        Ex3:tangente(plotfunc(sin(x)),point(3*pi/4+i*sqrt(2)/2))
        Ex4:tangente(plotfunc(x^2+y^2,[x,y]),[2,2])
        Ex5:tangente(plotfunc(x^2+y^2,[x,y]),point([2,2,8]))
        Ex6:tangente(plotparam(3*exp(t/2)*exp(i*t),t),7)
        Ex7:tangente(plotpolar(3*exp(t/2),t),7)
        Ex8: equation(tangente([2*cos(t),2*sin(t),3*t],t))
        
        '''

     def tanh(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tanh:
        tanh(Expr)
        Hyperbolic tangent.
        See also: 1/ atanh 2/ hyp2exp 
        Ex1:tanh(0)
        Ex2:tanh(hyp2exp(tanh(1)))
        
        '''

     def tar(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tar:
        tar(String || Buffer || Buffer,String || Buffer,Int,String)
        Tar archive handling. buf:=tar("src.tar") create a buffer, tar(buf) display list of files, tar(buf,"target.tar") save buffer, tar(buf,0,"filename") remove file from buffer, tar(buf,1,"filename") add file, tar(buf,2,"filename") save file, purge(buf) free buffer
        Ex1: buf:=tar("test.tar");
        Ex2:tar(buf);
        Ex3:tar(buf,1,"123456");
        Ex4:tar(buf,2,"456");
        Ex5:tar(buf,0,"456");
        Ex6:tar(buf,"file.tar");
        Ex7: purge(buf);
        
        '''

     def taux_accroissement(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for taux_accroissement:
        taux_accroissement(Expr,Var,Val1,(Val1+Var or Val2))
        Returns the rate of change of an expression when the variable goes from Val1 to Val2 (by default Var=x).
        See also: 1/ diff 2/ limit 
        Ex1:taux_accroissement(x^2,1,1+h)
        Ex2:taux_accroissement(x^2,1,2)
        Ex3:taux_accroissement(a^2,a,1,1+h)
        
        '''

     def taylor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for taylor:
        taylor(Expr,[Var=limit_point],[Order])
        Series expansion at finite or infinite points (by default x=0, and relative order=5).
        See also: 1/ series 2/ limit 3/ pade 4/ polynom 
        Ex1:taylor(sin(x)/x,x,0)
        Ex2:taylor(sin(x),x=0,5,polynom)
        Ex3:taylor(ln(y+y^2)-ln(y),y)
        Ex4:taylor(ln(x+x^2)-ln(x),x,2)
        Ex5:taylor(ln(x+x^2)-ln(x),x=0,2)
        Ex6:taylor(ln(x+x^2)-ln(x),x=1,2)
        Ex7:taylor((x^4+x+2)/(x^2+1),x,5)
        Ex8:taylor(sin(t*x+t*y)+cos(t*x*t*y),t=0,6,polynom)(h=1) 
        Ex9:taylor(sin((1+h*t)*(pi/2+k*t)),t=0,3,polynom)(t=1)
        Ex10:taylor((-1+k*t)^2/(1+h*t)^3,t=0,3,polynom)(t=1)
        
        '''

     def tchebyshev1(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tchebyshev1:
        tchebyshev1(Intg(n))
        Returns the n-th Tchebyshev polynomial of first kind.
        See also: 1/ tchebyshev2 2/ hermite 
        Ex1:tchebyshev1(3)
        
        '''

     def tchebyshev2(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tchebyshev2:
        tchebyshev2(Intg(n))
        Returns the nt-h Tchebyshev polynomial of second kind.
        See also: 1/ tchebyshev1 2/ hermite 
        Ex1:tchebyshev2(3)
        
        '''

     def tcoeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tcoeff:
        tcoeff(Poly||Lst)
        Returns the coefficient of the term of lowest degree of a polynomial (t=trailing).
        See also: 1/ lcoeff 
        Ex1:tcoeff(-2*x^3+x^2+7*x)
        Ex2:tcoeff([-2,1,7,0])
        
        '''

     def tcollect(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tcollect:
        tcollect(Expr)
        Collects trigonometric expressions.
        See also: 1/ texpand 2/ tlin 
        Ex1:tcollect(sin(x)+cos(x))
        
        '''

     def tdeg(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tdeg:
        tdeg(Opt)
        Option of the gbasis or greduce command to specify an order for monomials (complete degree then lexicographic order).
        See also: 1/ gbasis 2/ greduce 
        
        '''

     def teal(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for teal:
        teal(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def tensor_product(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tensor_product:
        tensor_product(Seq(G1,G2,..))
        Returns the tensor product of the input graphs G1, G2, ... with vertices labeled as "u:v:..." where u, v, ... are vertices from G1, G2, ..., respectively.
        See also: 1/ cartesian_product 
        Ex1:tensor_product(graph(trail(1,2,3,4,5,2)),star_graph(3))
        
        '''

     def tetrahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tetrahedron:
        tetrahedron(Pnt(A),Pnt(B),Pnt(C),[Pnt(D)])
        Draws the regular direct pyramid ABCD with vertices A,B and a face in the plane (A,B,C) when there is 3 arguments and the pyramid ABCD when there are 4 arguments.
        See also: 1/ cube 2/ cylinder 3/ icosahedron 4/ dodecahedron 5/ octahedron 
        Ex1:tetrahedron([0,0,0],[3,0,0],[0,1,0])
        Ex2:tetrahedron([0,0,0],[3,0,0],[0,3,0],[0,0,4])
        
        '''

     def texpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for texpand:
        texpand(Expr)
        Expands transcendental expressions.
        See also: 1/ tcollect 2/ tlin 3/ lin 4/ trigexpand 
        Ex1:texpand(sin(2*x)+exp(x+y))
        Ex2:texpand(cos(x+y))
        Ex3:texpand(cos(3*x))
        
        '''

     def thickness(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for thickness:
        thickness(Opt)
        Option (Maple compatibility) of a graphic command to define the thickness of lines.
        See also: 1/ line_width 
        Ex1: segment(0,point(1,1),thickness=5)
        Ex2: segment(0,point(1,1),epaisseur=5)
        
        '''

     def threshold(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for threshold:
        threshold(Lst,Real(bound)[=Expr(repl)] or Lst[Real(lower)[=Expr(rl)],Real(upper)[=Expr(ru)]],[Fnc(compare)],[abs[=true or false]])
        Performs thresholding operations on a list of real or complex numbers.
        See also: 1/ max 2/ min 
        Ex1:threshold([1,3,2,4,5,4,3,2,3,1],3,'>=')
        Ex2:threshold([-10,-5,0,5,10],7=a,abs=true)
        
        '''

     def throw(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for throw:
        throw(Str)
        Generates the display of an error in a program.
        See also: 1/ try 2/ catch 
        Ex1:throw("Argument should be integer")
        Ex2:throw("je provoque une erreur")
        
        '''

     def title(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for title:
        title(Opt)
        Global option of a graphic command to put a title in a graphic.
        See also: 1/ line_width 
        Ex1: title="segment";segment(0,point(1,1),epaisseur=5)
        Ex2: titre="segment";segment(0,point(1,1),epaisseur=5)
        
        '''

     def titre(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for titre:
        titre(Opt)
        Global option of a graphic command to put a title in a graphic.
        See also: 1/ line_width 
        Ex1: title="segment";segment(0,point(1,1),epaisseur=5)
        Ex2: titre="segment";segment(0,point(1,1),epaisseur=5)
        
        '''

     def tlin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tlin:
        tlin(ExprTrig)
        Trigonometric linearization.
        See also: 1/ texpand 2/ lin 
        Ex1:tlin(sin(x)^3)
        Ex2:tlin(cos(x)*cos(y))
        
        '''

     def tonnetz(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tonnetz:
        tonnetz(Intg(a),Intg(b),Intg(c),[Intg(d)])
        Returns the graph corresponding to the [a,b,c] resp. [a,b,c,d] tone network (tonnetz) used in neo-Riemannian music theory.
        See also: 1/ is_regular 2/ find_cliques 
        Ex1:tonnetz(3,4,5)
        Ex2:tonnetz(2,3,3,4)
        
        '''

     def topologic_sort(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for topologic_sort:
        topologic_sort(Graph(G))
        Returns the list of vertices sorted according to the topological ordering in a directed acyclic graph G.
        See also: 1/ digraph 2/ is_acyclic 
        Ex1:topologic_sort(digraph(%{[c,a],[c,b],[c,d],[a,d],[b,d],[a,b]%}))
        
        '''

     def topological_sort(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for topological_sort:
        topological_sort(Graph(G))
        Returns the list of vertices sorted according to the topological ordering in a directed acyclic graph G.
        See also: 1/ digraph 2/ is_acyclic 
        Ex1:topological_sort(digraph(%{[c,a],[c,b],[c,d],[a,d],[b,d],[a,b]%}))
        
        '''

     def topology(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for topology:
        topology(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def torus_grid_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for torus_grid_graph:
        torus_grid_graph(Intg(m),Intg(n))
        Returns a torus grid graph on m*n vertices, where m,n>=3.
        See also: 1/ grid_graph 
        Ex1:torus_grid_graph(6,12)
        
        '''

     def total_degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for total_degree:
        total_degree(Poly(P),Lst(Vars))
        Total degree of the polynomial P with respect to the second argument.
        See also: 1/ valuation 2/ size 3/ degree 
        Ex1:total_degree(x^3*y+x*y,[x,y])
        
        '''

     def tourne_droite(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tourne_droite:
        tourne_droite(NULL or Real(n))
        The turtle turns right by n degrees (by default n=90).
        See also: 1/ tourne_gauche 2/ pas_de_cote 
        Ex1: tourne_droite 60
        Ex2:tourne_droite(60)
        
        '''

     def tourne_gauche(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tourne_gauche:
        tourne_gauche(NULL or Real(n))
        The turtle turns left by n degrees (by defaults n=90).
        See also: 1/ tourne_droite 
        Ex1: tourne_gauche 60
        Ex2:tourne_gauche(60)
        
        '''

     def tpsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tpsolve:
        tpsolve(List(supply),List(demand),Mtrx(cost_matrix))
        Solves a transportation problem using MODI method.
        Ex1:tpsolve([12,17,11],[10,10,10,10],[[500,750,300,450],[650,800,400,600],[400,700,500,550]])
        Ex2:tpsolve([95,70,165,165],[195,150,30,45,75],[[15,M,45,M,0],[12,40,M,M,0],[0,15,25,25,0],[M,0,M,12,0]])
        Ex3:tpsolve([1,1,1,1],[1,1,1,1],[[10,12,9,11],[5,10,7,8],[12,14,13,11],[8,15,11,9]])
        
        '''

     def trace(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trace:
        trace(Mtrx or GeoObj)
        Returns the trace of a square matrix or draws the trace of a geometric object when the parameter changes (see Trace in Menu button of a geometric level and write only one instruction on each line).
        See also: 1/ det 2/ lieu 
        Ex1:trace([[1,2,3],[1,3,6],[2,5,7]])
        Ex2:trace([[1+i,2,3],[1,3,6],[2,5,9-i]])
        Ex3: assume(a=[0.7,-5,5,0.1]);trace(point(a-i*a))
        Ex4: assume(a=[0.7,-5,5,0.1]);trace(inter_unique(droite(y=a*x+a),droite(y=2*a*x+1)))
        
        '''

     def trail(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trail:
        trail(Seq(V))
        Returns a trail of vertices from V (inert command).
        See also: 1/ graph 2/ digraph 
        Ex1:trail(1,2,3,4,1)
        
        '''

     def trail2edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trail2edges:
        trail2edges(Trail(T))
        Converts a trail T to the list of its edges.
        See also: 1/ subgraph 2/ trail 
        Ex1:trail2edges(trail(1,2,3,4,1,3))
        Ex2:trail2edges([1,2,3,4,1,3])
        
        '''

     def train(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for train:
        train(NeuralNet(net),Mtrx(input),Mtrx||Vect(expected_output),[Intg(batchsize)]))
        Performs neural network training and returns the trained network.
        See also: 1/ neural_network 
        Ex1: X:=ranm(10000,2,uniformd(-1,1)):;f(x):=2*x[0]-x[1]+10:;net:=train(neural_network([2,3,1]),X,apply(f,X),1):;x0:=ranv(2,uniformd(-1,1)):;net(x0);f(x0)
        
        '''

     def trames(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trames:
        trames(Opt)
        Option of animate and animate3d commands to give the number of pictures.
        See also: 1/ animate 2/ animate3d 
        Ex1: animate(sin(x*t),x=-pi..pi,t=-3..3,frames=30)
        Ex2: animate3d(x^2+t*y^2,[x=-2..2,y=-2..2],t=-3..3,frames=10)
        
        '''

     def tran(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tran:
        tran(Mtrx)
        Transposes a matrix (without conjugation).
        See also: 1/ conj 2/ trn 
        Ex1:tran([[1,2,3],[1,3,6],[2,5,7]])
        Ex2:tran([[1+i,2,3],[1,3,6],[2,5,9-i]])
        Ex3:tran(conj([[1+i,2,3],[1,3,6],[2,5,9-i]]))
        
        '''

     def transitive_closure(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for transitive_closure:
        transitive_closure(Graph(G),[weighted[=true||false]])
        Returns the [weighted (by default false)] transitive closure of G.
        See also: 1/ allpairs_distance 2/ is_connected 3/ shortest_path 4/ vertex_distance 
        Ex1:transitive_closure(digraph([1,2,3,4,5,6],%{[1,2],[2,3],[2,4],[4,5],[3,5]%}),weighted)
        
        '''

     def translation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for translation:
        translation(Vect, Pnt(C))
        translation(B-A,C) (resp translation([a,b,c],C)) is the translation of C in the translation of vector AB (resp [a,b,c]).
        See also: 1/ rotation 2/ reflection 
        Ex1:translation(1+i,i)
        Ex2:translation([1,1,1],point([1,2,3]))
        Ex3: t:=translation(1+i);t(i)
        Ex4: t:=translation([1,1,1]);t(point([1,2,3]))
        
        '''

     def transpose(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for transpose:
        transpose(Mtrx)
        Transposes a matrix (without conjugation).
        See also: 1/ conj 2/ trn 
        Ex1:transpose([[1,2,3],[1,3,6],[2,5,7]])
        Ex2:transpose([[1+i,2,3],[1,3,6],[2,5,9-i]])
        Ex3:transpose(conj([[1+i,2,3],[1,3,6],[2,5,9-i]]))
        
        '''

     def trapeze(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trapeze:
        trapeze(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def trapezoid(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trapezoid:
        trapezoid(Opt)
        Option of the plotarea command and of the area command.
        See also: 1/ plotarea 2/ area 
        Ex1: plotarea(x^2,x=0..1,5,trapezoid)
        Ex2: plotarea(x^2,x=0..1,5,middle_point)
        Ex3: plotarea(x^2,x=0..1,5,right_rectangle)
        Ex4: plotarea(x^2,x=0..1,5,left_rectangle)
        Ex5: area(x^2,x=0..1,5,middle_point)
        Ex6: area(x^2,x=0..1,5,trapezoid)
        
        '''

     def traveling_salesman(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for traveling_salesman:
        traveling_salesman(Graph(G),[Mtrx(M)],[opts])
        Returns a Hamiltonian cycle in an unweighted graph G or solves a traveling salesman problem if G is weighted (matrix M can be used for edge weights), returning a sequence containing the minimal cost and the corresponding Hamiltonian cycle.
        See also: 1/ is_hamiltonian 
        Ex1:traveling_salesman(hypercube_graph(5))
        Ex2:traveling_salesman(digraph(%{[[1,2],1],[[1,3],2],[[2,3],2],[[2,4],3],[[3,2],3],[[3,4],2],[[4,1],1]%}))
        Ex3: M:=randmatrix(4,4,99); traveling_salesman(graph("tetrahedron"),M)
        Ex4: G:=set_vertex_positions(complete_graph(42),[randvector(2,1000)$(k=1..42)]); traveling_salesman(G,vertex_distance)
        Ex5: G:=set_vertex_positions(complete_graph(120),[randvector(2,1000)$(k=1..120)]); c,T:=traveling_salesman(G,vertex_distance,approx)
        
        '''

     def tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tree:
        tree(Opt)
        Option for the draw_graph command.
        See also: 1/ planar 2/ spring 3/ draw_graph 
        
        '''

     def tree_height(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tree_height:
        tree_height(Graph(T),[Vrtx(r)])
        Returns the height of a tree graph T with r as the root node, or the minimal height and the corresponding root node if r is omitted.
        See also: 1/ is_tree 2/ random_tree 
        Ex1:tree_height(graph(%{[1,2],[2,3],[2,4],[4,5]%}),1)
        
        '''

     def tri(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tri:
        tri(Expr(x))
        Returns the value of the triangle function at x.
        See also: 1/ rect 2/ Heaviside 
        Ex1:tri(x-1)
        
        '''

     def triangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for triangle:
        triangle((Pnt or Cplx),(Pnt or Cplx),(Pnt or Cplx))
        triangle(A,B,C) draws the triangle ABC.
        See also: 1/ equilateral_triangle 2/ isosceles_triangle 3/ right_triangle 
        Ex1:triangle(point(1+i),1,0)
        Ex2:triangle(0,1,1+i)
        Ex3:triangle(point(0,0,0),point(3,3,3),point(0,3,3))
        
        '''

     def triangle_paper(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for triangle_paper:
        triangle_paper(Real(ux),Real(t),Real(uy),[x=xmin..xmax,y=ymin..ymax])
        Draws in the rectangle [xmin..xmax]*[ymin..ymax], the lines of the grid formed by the lines y=n*uy, the lines, the lines x=n*ux at an angle of t!=0, and the lines ux*y+uy*x=n*ux*uy.
        Ex1:triangle_paper(1,pi/3,sqrt(3)/2)
        Ex2:triangle_paper(1,pi/3,sqrt(3)/2,x=-1..4,y=-2..2)
        Ex3:triangle_paper(papier_triangule(1,pi/3,sqrt(3)/2,x=-2..6,y=-4*sqrt(3)..4*sqrt(3)))
        Ex4:triangle_paper(0.5,3*pi/4,0.5)
        
        '''

     def triangle_plein(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for triangle_plein:
        triangle_plein(Real(a),[Real(b)],[Real(t)])
        Draws a full direct triangle with sides a,b and with angle t, from the turtle position (by default t=90 or (b=a and t=60)).
        See also: 1/ rectangle_plein 
        Ex1: triangle_plein 30
        Ex2:triangle_plein(30)
        Ex3:triangle_plein(30,40)
        Ex4:triangle_plein(30,40,60)
        
        '''

     def triangle_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for triangle_point:
        triangle_point(Opt)
        Option of the display command for a point.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),point_point)
        Ex2: F:=display(point(2+1.5*i),rhombus_point)
        
        '''

     def triangle_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for triangle_window:
        triangle_window(Lst,[Intg(d)],[Interval(n1..n2)])
        Applies the triangular windowing function with parameter d in {-1,0,1} (by default L=0) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ bartlett_hann_window 13/ tukey_window 14/ welch_window 
        Ex1: scatterplot(triangle_window(randvector(1000,0..1),1))
        
        '''

     def trig2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trig2exp:
        trig2exp(Expr)
        Replaces in the argument the trigonometric functions by complex exponentials without linearisation.
        See also: 1/ exp2trig 2/ atrig2ln 
        Ex1:trig2exp(sin(x))
        
        '''

     def trigcos(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trigcos:
        trigcos(Expr)
        Simplifies the argument with the formulas sin(x)^2+cos(x)^2=1 and tan(x)=sin(x)/cos(x) privileging cosine.
        See also: 1/ trigsin 2/ trigtan 
        Ex1:trigcos(sin(x)^4+sin(x)^2)
        
        '''

     def trigexpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trigexpand:
        trigexpand(Expr)
        Expands trigonometric functions.
        See also: 1/ texpand 2/ lnexpand 3/ expexpand 
        Ex1:trigexpand(sin(3*x))
        
        '''

     def triginterp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for triginterp:
        triginterp(List,Var=xmin..xmax)
        Returns a trigonometric polynomial interpolation (with respect to variable x) of the points with ordinate given in list y and the abscissa equally spaced between a and b.
        See also: 1/ lagrange 2/ thiele 
        Ex1:triginterp([11,10,17,24,32,26,23,19],x=0..21)
        Ex2:triginterp([11,10,17,24,32,26,23,19],0,21,x)
        
        '''

     def trigsimplify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trigsimplify:
        trigsimplify(Expr)
        Simplifies a trigonometric expression.
        See also: 1/ simplify 
        Ex1:trigsimplify(3*sin(x)-4*sin(x)^3)
        
        '''

     def trigsin(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trigsin:
        trigsin(Expr)
        Simplifies the argument with the formulas sin(x)^2+cos(x)^2=1 and tan(x)=sin(x)/cos(x) privileging sine.
        See also: 1/ trigcos 2/ trigtan 
        Ex1:trigsin(cos(x)^4+sin(x)^2)
        
        '''

     def trigtan(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trigtan:
        trigtan(Expr)
        Simplifies the argument with the formulas sin(x)^2+cos(x)^2=1 and tan(x)=sin(x)/cos(x) privileging tangent.
        See also: 1/ trigsin 2/ trigcos 
        Ex1:trigtan(cos(x)^4+sin(x)^2)
        
        '''

     def trim(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trim:
        trim((Str||Vect||Audio||Image)(s),[opts],[left|right],[index])
        Removes leading/trailing whitespace from strings, zeros from vectors, zero-pixel margins from images, and silence from audio clips, or returns positions specifying that portions.
        See also: 1/ strip 
        Ex1:trim("   an apple     ")
        Ex2:trim([0,0,1,2,3,0,1e-16,0],right)
        Ex3:trim([0.01,0.023,0.005,0.12,0.27,0.82,0.53,0.21,0.05,0.001],0.1)
        
        '''

     def trn(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trn:
        trn(Mtrx)
        Returns the adjoint matrix of A =tran(conj(A)).
        See also: 1/ tran 2/ conj 
        Ex1:trn([[1,2+i],[3,4]])
        
        '''

     def true(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for true:
        true()
        Boolean equal to true or 1.
        See also: 1/ false 
        Ex1: a:=true
        
        '''

     def trunc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for trunc:
        trunc(Real||LstReal,Int(n))
        Truncates value to n decimal places (by default n=0). Accepts complex numbers.(type=DOM_COMPLEX or DOM_FLOAT).
        See also: 1/ fPart 2/ floor 3/ iPart 
        Ex1:trunc(4.3)
        Ex2:trunc(sqrt(2),3)
        Ex3:trunc([4.3333,sqrt(2)])
        Ex4:trunc([4.3333,sqrt(2)],2)
        Ex5:trunc(sqrt(2)+i*sqrt(5),4)
        
        '''

     def truncate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for truncate:
        truncate(Poly(P),Intg(n))
        Truncates the polynomial P at order n.
        See also: 1/ series 
        Ex1:truncate((x^2+x)^2,3)
        
        '''

     def truncate_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for truncate_graph:
        truncate_graph(Graph(G))
        Returns the graph obtained by truncating the biconnected planar graph G.
        See also: 1/ is_biconnected 2/ is_planar 3/ plane_dual 
        Ex1:truncate_graph(graph("tetrahedron"))
        
        '''

     def tsimplify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tsimplify:
        tsimplify(Expr)
        Lowers the number of non rational variables.
        See also: 1/ simplify 
        Ex1:tsimplify(exp(2*x)+exp(x))
        
        '''

     def tstep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tstep:
        tstep(Opt)
        Option for plotting commands.
        
        '''

     def tuer(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tuer:
        tuer(NULL)
        Stop step-by-step execution of a program (with debug).
        See also: 1/  
        Ex1:tuer()
        
        '''

     def tukey_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tukey_window:
        tukey_window(Lst,[Real(a)],[Interval(n1..n2)])
        Applies the Tukey windowing function with parameter a in [0,1] (by default a=0.5) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ bartlett_hann_window 14/ welch_window 
        Ex1: scatterplot(tukey_window(randvector(1000,0..1),0.4))
        
        '''

     def tutte_polynomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for tutte_polynomial:
        tutte_polynomial(Graph(G),[Var(x),Var(y)])
        Returns the Tutte polynomial [or its value at point (x,y)] of an undirected graph G. If G is weighted, then all weights must be positive integers which are interpreted as edge multiplicities.
        See also: 1/ chromatic_polynomial 2/ flow_polynomial 3/ reliability_polynomial 4/ delete_edge 5/ contract_edge 
        Ex1:tutte_polynomial(graph("tetrahedron"))
        Ex2:tutte_polynomial(graph("tetrahedron"),1,1)
        
        '''

     def two_edge_connected_components(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for two_edge_connected_components:
        two_edge_connected_components(Graph(G))
        Returns the list of two-edge-connected components of an undirected graph G, each of them represented by the list of its vertices.
        See also: 1/ is_two_edge_connected 2/ connected_components 
        Ex1:two_edge_connected_components(graph(trail(1,2,3,4,5,3,1),trail(5,6,7,8,6)))
        
        '''

     def ufactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ufactor:
        ufactor(Unit,Unit)
        Factors a unit in a unit object.
        See also: 1/ convert 2/ mksa 3/ usimplify 
        Ex1:ufactor(100_C,1_A)
        
        '''

     def ugamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ugamma:
        ugamma(Real(a),Real(x),[1])
        Calculates ugamma function at a point (a,x):if a and x>=0 ugamma(a,x)=int(e^{-t}*t^{a-1},t=x..inf),(ugamma(a,x)+igamma(a,x)=Gamma(a)).
        See also: 1/ Psi 2/ Beta 3/ Gamma 4/ igamma 
        Ex1:ugamma(5.0,2.0)
        Ex2:ugamma(-5.1,2.1)
        
        '''

     def unapply(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for unapply:
        unapply(Expr,Var)
        Returns a function defined by an expression.
        See also: 1/ apply 
        Ex1:unapply(2*x^2,x)
        Ex2: f(x):=x*exp(x);g:=unapply(diff(f(x),x),x)
        
        '''

     def unarchive(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for unarchive:
        unarchive(Str(namefich),Seq(Var))
        Reads the value of a variable or of a list of variables which are in the file given as argument (file created with archive).
        See also: 1/ archive 2/ Archive 3/ Unarchiv 
        Ex1:unarchive("toto")
        Ex2:unarchive("aa.txt")
        
        '''

     def undef(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for undef:
        undef(Expr)
        Udefined value (NaN).
        See also: 1/ isnan 2/ infinity 
        Ex1:undef(0)
        
        '''

     def underlying_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for underlying_graph:
        underlying_graph(Graph(G))
        Returns the graph obtained by stripping directions and weights from arcs in G (pairs of arcs connecting the same vertices are merged to a single edge).
        See also: 1/ is_directed 2/ is_weighted 3/ make_directed 4/ make_weighted 
        Ex1:underlying_graph(digraph(trail(1,2,3,4,1)))
        
        '''

     def unfactored(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for unfactored:
        unfactored(Opt.)
        Option of the plotimplicit command.
        See also: 1/ plotimplicit 
        Ex1: plotimplicit(x^2+y^2-1,x,y,unfactored)
        Ex2: plotimplicit(x^2+y^2-1,[x,y],unfactored)
        Ex3: plotimplicit(x^2+y^2+z^2-1,x,y,z,xstep=0.2,ystep=0.2,zstep=0.2,unfactored)
        Ex4: plotimplicit(x^2+y^2+z^2-1,[x,y,z],xstep=0.2,ystep=0.2,zstep=0.2,unfactored)
        Ex5: plotimplicit(x^2+y^2+z^2-1,x=0..1,y=0..1,z=0..1,xstep=0.2,ystep=0.2,zstep=0.2,unfactored)
        
        '''

     def uniform(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for uniform:
        uniform(Real(a),Real(b),Real(x))
        Returns the probability density at x of the uniform law on [a,b].
        See also: 1/ uniform_cdf 2/ uniform_icdf 3/ randvector 4/ ranm 
        Ex1:uniform(2,5,4)
        Ex2:uniform(1.2,3.5,3)
        Ex3: randvector(3,uniform,1.2,3.5)
        Ex4: ranm(4,3,uniform,1.2,3.5)
        
        '''

     def uniform_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for uniform_cdf:
        uniform_cdf(Real(a),Real(b),Real(x0),[Real(y0)])
        Returns the probability that a uniform random variable on [a,b] is less than x0 (or between x0 and y0).
        See also: 1/ uniformd 2/ uniform_icdf 
        Ex1:uniform_cdf(3.2,5.7,4.4)
        Ex2:uniform_cdf(3.2,5.7,4.4,5.4)
        
        '''

     def uniform_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for uniform_icdf:
        uniform_icdf(Real(a),Real(b),Real(p))
        Returns h such that the probability that a uniform random variable on [a,b] is less than h is p (0<=p<=1).
        See also: 1/ uniform_cdf 2/ uniformd 
        Ex1:uniform_icdf(4.2,10.3,0.95)
        Ex2:uniform_icdf(3.2,5.7,0.48)
        
        '''

     def uniformd(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for uniformd:
        uniformd(Real(a),Real(b),Real(x))
        Returns the probability density at x of the uniform law on [a,b].
        See also: 1/ uniform_cdf 2/ uniform_icdf 3/ randvector 4/ ranm 
        Ex1:uniformd(2,5,4)
        Ex2:uniformd(1.2,3.5,3)
        Ex3: randvector(3,uniform,1.2,3.5)
        Ex4: ranm(4,3,uniform,1.2,3.5)
        
        '''

     def uniformd_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for uniformd_cdf:
        uniformd_cdf(Real(a),Real(b),Real(x0),[Real(y0)])
        Returns the probability that a uniform random variable on [a,b] is less than x0 (or between x0 and y0).
        See also: 1/ uniformd 2/ uniform_icdf 
        Ex1:uniformd_cdf(3.2,5.7,4.4)
        Ex2:uniformd_cdf(3.2,5.7,4.4,5.4)
        
        '''

     def uniformd_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for uniformd_icdf:
        uniformd_icdf(Real(a),Real(b),Real(p))
        Returns h such that the probability that a uniform random variable on [a,b] is less than h is p (0<=p<=1).
        See also: 1/ uniform_cdf 2/ uniformd 
        Ex1:uniformd_icdf(4.2,10.3,0.95)
        Ex2:uniformd_icdf(3.2,5.7,0.48)
        
        '''

     def unitV(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for unitV:
        unitV(Lst||Cplx||Audio)
        Returns the vector divided by its l2norm or normalizes an audio clip. It is also an option for plotfield.
        See also: 1/ l2norm 
        Ex1:unitV(3+4*i)
        Ex2:unitV([3,4])
        Ex3: fieldplot(-t*y,[t,y],normalize)
        Ex4: fieldplot(-t*y,[t,y],normalize,xstep=0.5,ystep=0.5)
        
        '''

     def unquote(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for unquote:
        unquote(Expr)
        Evaluates a quoted expression (for example purge(c);a:=c;unquote(a):=3; put 3 in the variables a and c).
        See also: 1/ quote 
        Ex1:unquote(a)
        
        '''

     def upper(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for upper:
        upper(Mtrx||Strng)
        Returns the upper triangular matrix (over the diagonal, included) or writes a string in uppercase.
        See also: 1/ diag 2/ lower 
        Ex1:upper([[1,2,3],[4,5,6],[7,8,9]])
        Ex2:upper("hello")
        
        '''

     def user_operator(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for user_operator:
        user_operator(Str(R),Fnc(f),Opt(Binary||Unary||Delete))
        Defines a binary operator and returns 0 (failure) or 1(success).
        See also: 1/  
        Ex1:user_operator("R",(x,y)->x*y+x+y,Binary)
        Ex2:user_operator("R",(x,y)->x*y+x+y,Delete)
        
        '''

     def usimplify(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for usimplify:
        usimplify(Unit)
        Simplifies a unit in a unit object.
        See also: 1/ convert 2/ mksa 3/ ufactor 
        Ex1:usimplify(100_(W*s))
        
        '''

     def ustep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ustep:
        ustep(Opt)
        Option for plotting commands.
        
        '''

     def valuation(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for valuation:
        valuation(Poly(P))
        Returns the valuation (degree of the term of lowest degree) of the polynomial P.
        See also: 1/ degree 2/ tcoeff 
        Ex1:valuation(x^4+x^3)
        Ex2:valuation([1,1,0,0,0])
        Ex3:valuation(130,5)
        Ex4:valuation(x^5+3*x^2)
        Ex5:valuation([5,0,0,3,0,0])
        
        '''

     def vandermonde(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vandermonde:
        vandermonde(Vect(V))
        Returns the Vandermonde matrix=[V^0,V^1,..].
        See also: 1/ det 
        Ex1:vandermonde([1,2,a])
        
        '''

     def variables_are_files(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for variables_are_files:
        variables_are_files(:=Intg(0 or 1))
        Pseudo-variable to specify if you want to save the variables as file "nameofthevariable.cas".
        See also: 1/ cas_setup 
        Ex1: variables_are_files:=1
        Ex2: variables_are_files:=0
        
        '''

     def variance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for variance:
        variance(Lst||Mtrx,[Lst])
        Returns the variance of a list with the second argument as weights or the list of variances of the columns of a matrix.
        See also: 1/ stddev 2/ mean 
        Ex1:variance([3,4,2])
        Ex2:variance([1,2,3],[1,2,1])
        Ex3:variance([[1,2,3],[5,6,7]])
        
        '''

     def version(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for version:
        version(NULL)
        Returns the giac version number; for example, you are using : giac 0.4.0
        See also: 1/  
        Ex1:version()
        
        '''

     def vertex_connectivity(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertex_connectivity:
        vertex_connectivity(Graph(G))
        Returns the largest integer k such that an undirected connected graph G remains connected when fewer than k vertices are removed.
        See also: 1/ edge_connectivity 2/ is_connected 
        Ex1:vertex_connectivity(graph("petersen"))
        Ex2:vertex_connectivity(graph("clebsch"))
        Ex3:vertex_connectivity(complete_graph(5))
        
        '''

     def vertex_cover_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertex_cover_number:
        vertex_cover_number(Graph(G))
        Returns the size of a minimum vertex cover in an undirected graph G.
        See also: 1/ minimum_vertex_cover 
        Ex1:vertex_cover_number(graph_complement(complete_graph(3,4)))
        
        '''

     def vertex_degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertex_degree:
        vertex_degree(Graph(G),Vrtx(v))
        Returns the degree of the vertex v in G (i.e. the number of edges incident to v).
        See also: 1/ degree_sequence 2/ is_regular 3/ maximum_degree 4/ minimum_degree 5/ vertex_in_degree 6/ vertex_out_degree 
        Ex1:vertex_degree(digraph(trail(1,2,3,4,2)),2)
        
        '''

     def vertex_distance(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertex_distance:
        vertex_distance(Graph(G),Vrtx(s),Vrtx(t)||Lst(T))
        Returns the number of edges in the shortest path from vertex s to vertex t in G, or +infinity if there is no such path. For a vector T of vertices from G returns the list of distances from s to each vertex t in T.
        See also: 1/ allpairs_distance 2/ graph_diameter 3/ dijkstra 4/ shortest_path 
        Ex1:vertex_distance(graph("petersen"),1,4)
        Ex2:vertex_distance(graph("petersen"),1,[2,4])
        
        '''

     def vertex_in_degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertex_in_degree:
        vertex_in_degree(Graph(G),Vrtx(v))
        Returns the number of arcs in G entering the vertex v.
        See also: 1/ degree_sequence 2/ is_regular 3/ maximum_degree 4/ minimum_degree 5/ vertex_degree 6/ vertex_out_degree 
        Ex1:vertex_in_degree(digraph(trail(1,2,3,4,2)),2)
        
        '''

     def vertex_out_degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertex_out_degree:
        vertex_out_degree(Graph(G),Vrtx(v))
        Returns the number of arcs in G emanating from the vertex v.
        See also: 1/ degree_sequence 2/ is_regular 3/ maximum_degree 4/ minimum_degree 5/ vertex_degree 6/ vertex_in_degree 
        Ex1:vertex_out_degree(digraph(trail(1,2,3,4,2)),2)
        
        '''

     def vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertices:
        vertices(Polygon or Polyedr(P))
        Returns the list of the vertices of the polygon or polyhedron P.
        See also: 1/ isosceles_triangle 2/ polyhedron 
        Ex1:vertices(isosceles_triangle(0,1,pi/4))
        Ex2:vertices(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))
        Ex3:vertices(isosceles_triangle(0,1,pi/4))[2]
        
        '''

     def vertices_abc(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertices_abc:
        vertices_abc(Polygon or Polyedr(P))
        Returns the list of the vertices of the polygon or polyhedron P.
        See also: 1/ isosceles_triangle 2/ polyhedron 
        Ex1:vertices_abc(isosceles_triangle(0,1,pi/4))
        Ex2:vertices_abc(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))
        Ex3:vertices_abc(isosceles_triangle(0,1,pi/4))[2]
        
        '''

     def vertices_abca(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vertices_abca:
        vertices_abca(Polygon or Polyedr(P))
        Returns the closed list [A,B,...A] of the vertices of the polygon or polyhedron P.
        See also: 1/ isosceles_triangle 2/ polyhedron 
        Ex1:vertices_abca(isosceles_triangle(0,1,pi/4))
        Ex2:vertices_abca(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))
        Ex3:vertices_abca(isosceles_triangle(0,1,pi/4))[2]
        
        '''

     def violet(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for violet:
        violet(Opt)
        Option of the display command to display with color.
        See also: 1/ display 
        Ex1: F:=display(point(2+1.5*i),red)
        Ex2: F:=display(point(2+1.5*i),point_point+green)
        
        '''

     def vpotential(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vpotential:
        vpotential(Vect(V),LstVar)
        Returns U such that curl(U)=V.
        See also: 1/ curl 2/ potential 
        Ex1:vpotential([2*x*y+3,x^2-4*z,-2*y*z],[x,y,z])
        
        '''

     def vstep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for vstep:
        vstep(Opt)
        Option for plotting commands.
        
        '''

     def web_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for web_graph:
        web_graph(Intg(a),Intg(b))
        Returns a web graph on a*b vertices, where a>=3 and b>=2.
        See also: 1/ prism_graph 2/ wheel_graph 
        Ex1:web_graph(5,3)
        
        '''

     def weibull(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibull:
        weibull(Real(k),Real(lambda),Real(theta),Real(x))
        Returns the density of probability at x of the Weibull law with parameters k, lambda, theta (by default theta=0).
        See also: 1/ weibull_cdf 2/ weibull_icdf 
        Ex1:weibull(2.1,1.2,1.3)
        Ex2:weibull(2.1,1.2,0.0,1.3)
        Ex3:weibull(2.1,1.2,0.5,1.8)
        
        '''

     def weibull_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibull_cdf:
        weibull_cdf(Real(k),Real(lambda),Real(theta),Real(x0))
        Returns the probability that a Weibull random variable of parameters k, lambda, theta is less than x0.
        See also: 1/ weibulld 2/ weibull_icdf 
        Ex1:weibull_cdf(2.1,1.2,1.9)
        Ex2:weibull_cdf(2.1,1.2,0.0,1.9)
        Ex3:weibull_cdf(2.2,1.5,0.4,1.9)
        Ex4:weibull_cdf(2.2,1.5,0.4,1.2)
        Ex5:weibull_cdf(2.2,1.5,0.4,1.2,1.9)
        
        '''

     def weibull_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibull_icdf:
        weibull_icdf(Real(k),Real(lambda),Real(theta),Real(p))
        Returns h such that the probability that a Weibull random variable of parameters k, lambda, theta is less than h is p (0<=p<=1).
        See also: 1/ weibull_cdf 2/ weibull 
        Ex1:weibull_icdf(4.2,1.3,0.0,0.95)
        Ex2:weibull_icdf(2.2,1.5,0.4,0.632)
        
        '''

     def weibulld(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibulld:
        weibulld(Real(k),Real(lambda),Real(theta),Real(x))
        Returns the density of probability at x of the Weibull law with parameters k, lambda, theta (by default theta=0).
        See also: 1/ weibull_cdf 2/ weibull_icdf 
        Ex1:weibulld(2.1,1.2,1.3)
        Ex2:weibulld(2.1,1.2,0.0,1.3)
        Ex3:weibulld(2.1,1.2,0.5,1.8)
        
        '''

     def weibulld_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibulld_cdf:
        weibulld_cdf(Real(k),Real(lambda),Real(theta),Real(x0))
        Returns the probability that a Weibull random variable of parameters k, lambda, theta is less than x0.
        See also: 1/ weibulld 2/ weibull_icdf 
        Ex1:weibulld_cdf(2.1,1.2,1.9)
        Ex2:weibulld_cdf(2.1,1.2,0.0,1.9)
        Ex3:weibulld_cdf(2.2,1.5,0.4,1.9)
        Ex4:weibulld_cdf(2.2,1.5,0.4,1.2)
        Ex5:weibulld_cdf(2.2,1.5,0.4,1.2,1.9)
        
        '''

     def weibulld_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibulld_icdf:
        weibulld_icdf(Real(k),Real(lambda),Real(theta),Real(p))
        Returns h such that the probability that a Weibull random variable of parameters k, lambda, theta is less than h is p (0<=p<=1).
        See also: 1/ weibull_cdf 2/ weibull 
        Ex1:weibulld_icdf(4.2,1.3,0.0,0.95)
        Ex2:weibulld_icdf(2.2,1.5,0.4,0.632)
        
        '''

     def weibullvariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weibullvariate:
        weibullvariate(Real(a),Real(b))
        Returns a random real according to the Weibull distribution with parameters a>0 and b>0.
        See also: 1/ rand 2/ randpoly 3/ randnorm 4/ randvector 
        Ex1:weibullvariate(1,2)
        Ex2:weibullvariate(1.5,4)
        
        '''

     def weight_decay(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weight_decay:
        weight_decay(Opt)
        Option for the neural_network command.
        See also: 1/ neural_network 
        
        '''

     def weight_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weight_matrix:
        weight_matrix(Graph(G))
        Returns the weight matrix of G.
        See also: 1/ set_edge_weight 2/ get_edge_weights 3/ is_weighted 4/ make_weighted 5/ assign_edge_weights 
        Ex1:weight_matrix(graph(%{[[1,2],2],[[2,3],1]%})
        
        '''

     def weighted(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weighted:
        weighted(Opt)
        Option for graph and digraph commands.
        See also: 1/ directed 2/ graph 3/ digraph 
        
        '''

     def weights(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for weights:
        weights(Opt)
        Option for the edges command.
        See also: 1/ edges 
        
        '''

     def welch_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for welch_window:
        welch_window(Lst,[Interval(n1..n2)])
        Applies the Welch windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        See also: 1/ blackman_harris_window 2/ blackman_window 3/ bohman_window 4/ cosine_window 5/ gaussian_window 6/ hamming_window 7/ hann_poisson_window 8/ hann_window 9/ parzen_window 10/ poisson_window 11/ riemann_window 12/ triangle_window 13/ tukey_window 14/ bartlett_hann_window 
        Ex1: scatterplot(welch_window(randvector(1000,0..1)))
        
        '''

     def wheel_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for wheel_graph:
        wheel_graph(Intg(n))
        Returns a wheel graph with n+1 vertices.
        See also: 1/ star_graph 2/ web_graph 
        Ex1:wheel_graph(5)
        
        '''

     def widget_size(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for widget_size:
        widget_size(Intg(n))
        Changes the character sizes of the display on the xcas screen (size=n) and with more parameters define the general configuration.
        See also: 1/ cas_setup 
        Ex1:widget_size(20)
        Ex2:widget_size(8)
        Ex3:widget_size(20,58,49,697,563,1,1,0)
        
        '''

     def wilcoxonp(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for wilcoxonp:
        wilcoxonp(Intg,[Intg])
        Distribution of the Wilcoxon or Mann-Whitney test for one or two samples.
        See also: 1/ wilcoxont 2/ wilcoxons 
        Ex1:wilcoxonp(4)
        Ex2:wilcoxonp(7,5)
        
        '''

     def wilcoxons(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for wilcoxons:
        wilcoxons(List,List || Real)
        Rank statistic of Wilcoxon or Mann-Whitney for 1 sample and one median or 2 samples.
        See also: 1/ wilcoxont 2/ wilcoxonp 
        Ex1:wilcoxons([1, 3, 4, 5, 7, 8, 8, 12, 15, 17] , [2, 6, 10, 11, 13, 14, 15, 18, 19, 20])
        Ex2:wilcoxons([1, 3, 4, 5, 7, 8, 8, 12, 15, 17] , 10)
        
        '''

     def wilcoxont(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for wilcoxont:
        wilcoxont(List,List || Real,[Func],[Real])
        Wilcoxon or Mann-Whitney test for one sample and a median or 2 samples.
        See also: 1/ wilcoxonp 2/ wilcoxons 3/ studentt 4/ normalt 
        Ex1:wilcoxont([1, 3, 4, 5, 7, 8, 8, 12, 15, 17] , [2, 6, 10, 11, 13, 14, 15, 18, 19, 20])
        Ex2:wilcoxont([1, 3, 4, 5, 7, 8, 8, 12, 15, 17] , [2, 6, 10, 11, 13, 14, 15, 18, 19, 20],0.01)
        Ex3:wilcoxont([1, 3, 4, 5, 7, 8, 8, 12, 15, 17] , 10,'>')
        Ex4:wilcoxont([1, 3, 4, 5, 7, 8, 8, 12, 15, 17] , 10,'>',0.05)
        
        '''

     def writergb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for writergb:
        writergb(Str(s),Lst)
        Write a PNG picture file named s either from a list [[number_channels,width,height],red,green,alpha,blue] where red,green,alpha,blue are matrices of pixels color or from a matrix of grey pixels or from 3 matrices of RGB colored pixels.
        See also: 1/ readrgb 
        Ex1:writergb("image.png",[[255,0],[0,255]])
        Ex2:writergb("image.png",[[255,0],[0,0]],[[0,255],[0,0]],[[0,0],[255,0]])
        Ex3: a:=readrgb("rgb_image.png");writergb("brg_image.png",[a[0],a[4],a[1],a[3],a[2]])
        
        '''

     def writewav(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for writewav:
        writewav(Str(s),Lst(l))
        Writes a WAV sound file.
        See also: 1/ readwav 
        Ex1:writewav("la.wav",2^14*(sin(2*pi*440*soundsec(1))))
        Ex2:writewav("beep.wav",[[1,16,44100,80000],[65000$10000,0$10000,65000$10000,0$10000]])
        
        '''

     def xcas_mode(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for xcas_mode:
        xcas_mode(Intg(0) or 1 or 2 or 3)
        Switches to mode Xcas (0), Maple (1), Mupad (2), TI89 (3).
        See also: 1/ python_compat 
        Ex1:xcas_mode(1)
        Ex2:xcas_mode(0)
        
        '''

     def xml_print(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for xml_print:
        xml_print(Str)
        Indents a XML code given in a string (pretty print).
        See also: 1/ export_mathml 
        Ex1:xml_print(export_mathml(a+2*b))
        
        '''

     def xstep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for xstep:
        xstep(Opt)
        Option for plotting commands.
        
        '''

     def xyz2rgb(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for xyz2rgb:
        xyz2rgb(Lst(x,y,z))
        Convert XYZ to RGB.
        See also: 1/ rgb2xyz 2/ interp 
        Ex1:xyz2rgb(0.1,0.2,0.3)
        
        '''

     def xyztrange(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for xyztrange:
        xyztrange(SeqReal)
        xyztrange puts or erases the axes on the graphic-screen (cf button Cfg).
        Ex1:xyztrange(-5.0,5.0,-5.0,2.0,-10.0,10.0,-1.0,6.0,-5.0,5.0,-1.2384,2.0,1,0.0,1.0)
        
        '''

     def ystep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ystep:
        ystep(Opt)
        Option for plotting commands.
        
        '''

     def zeros(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for zeros:
        zeros(Expr,[Var])
        Returns the zeros (real or complex according to the mode) of the expression (or the matrix where the lines are the solutions of the system : expression1=0,expression2=0...).
        See also: 1/  
        Ex1:zeros(x^2+4)
        Ex2:zeros(ln(x)^2-4)
        Ex3:zeros(ln(y)^2-2,y)
        Ex4:zeros([x^2-1,x^2-y^2],[x,y])
        
        '''

     def znorder(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for znorder:
        znorder(Intg)
        Returns 0 or the order of k in (Z/nZ^*,*)
        See also: 1/ znprimroot 2/ pari 
        Ex1:znorder(17,23)
        Ex2:znorder(5,1234)
        Ex3:znorder(17 mod 23)
        
        '''

     def znprimroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for znprimroot:
        znprimroot(Intg)
        Returns a generator of (Z/pZ^*,*)
        See also: 1/ znorder 2/ pari 
        Ex1:znprimroot(23)
        
        '''

     def zstep(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for zstep:
        zstep(Opt)
        Option for plotting commands.
        
        '''

     def ztrans(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for ztrans:
        ztrans(Expr,[Var],[ZtransVar])
        z transform of a sequence.
        See also: 1/ invztrans 2/ laplace 3/ invlaplace 
        Ex1:ztrans(a^x)
        Ex2:ztrans(a^n,n,z)
        
        '''

     def type(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for type:
        type(Expr)
        Returns n in [1..12] that defines the type of the argument.
        See also: 1/ DOM_FLOAT 2/ DOM_INT 3/ DOM_COMPLEX 4/ DOM_IDENT 5/ DOM_LIST 6/ DOM_SYMBOLIC 7/ DOM_RAT 8/ DOM_STRING 9/ DOM_FUNC 10/ subtype 
        Ex1:type("abc")
        Ex2:type([1,2,3])
        
        '''

     def zip(self,*args)->Pygen:
        r'''From Giac's documentation:
        Help for zip:
        zip(Fnc2d(f),Lst(l1),Lst(l2),[Val(default)])
        Returns a list whose j-th entry is f(l1[j],l2[j]): without default value its length is the minimum of the lengths of the two input lists and otherwise the shorter list is padded with the default value.
        See also: 1/  
        Ex1:zip('+',[a,b,c,d], [1,2,3,4])
        Ex2:zip('+',[a,b,c,d], [1,2,3])
        Ex3:zip('+',[a,b,c,d], [1,2,3],5)
        Ex4:zip(sum,[a,b,c,d], [1,2,3,4])
        
        '''

####################################################
#### giac  functions ##############################
####################################################

def giac(self,*args)->Pygen:
        r'''
            This function evaluate a python object with the giac library.
        
            * It creates in python a Pygen element and evaluate it with giac. For instance to compute a trigonometric expansion of cos(x+2y) where x and y are just formal symbols  we can do:
        
             >>> from giacpy import giac,pi
             >>> x,y=giac('x,y')
             >>> (x+2*y).cos().texpand()
             cos(x)*(2*cos(y)**2-1)-sin(x)*2*cos(y)*sin(y)
        
        
           Coercion, Pygen and internal giac variables:
           --------------------------------------------
        
           * The most usefull objects will be the Python object of type Pygen. In the following example, we start by defining symbols x,y,z and do some formal computations
        
            >>> from giacpy import *
            >>> x,y,z=giac('x,y,z')
            >>> ((x+2*y/z)*(y+1)**2).diff(y)  # compute the partial derivative with respect to y
            2/z*(y+1)**2+(x+2*y/z)*2*(y+1)
        
            In the next example x was previously defined as a symbol so x[i] is just another symbol. So we can use the symbols x[i] to work with polynomial in several variables as we do with theother symbols x,y,z.
        
            For instance to compute the coefficient of x[0]^12 in (x[0]+x[1]+x[2]+x[3]+x[4])^15/(y+z) we just do the following
            >>> f=sum([x[i] for i in range(5)])**15/(y+z);f.coeff(x[0],12)
            (455*(x[1])**3+1365*(x[1])**2*x[2]+1365*(x[1])**2*x[3]+1365*(x[1])**2*x[4]+1365*x[1]*(x[2])**2+2730*x[1]*x[2]*x[3]+2730*x[1]*x[2]*x[4]+1365*x[1]*(x[3])**2+2730*x[1]*x[3]*x[4]+1365*x[1]*(x[4])**2+455*(x[2])**3+1365*(x[2])**2*x[3]+1365*(x[2])**2*x[4]+1365*x[2]*(x[3])**2+2730*x[2]*x[3]*x[4]+1365*x[2]*(x[4])**2+455*(x[3])**3+1365*(x[3])**2*x[4]+1365*x[3]*(x[4])**2+455*(x[4])**3)/(y+z)
        
              Warning: The complex number sqrt(-1) is exported in python as I. (But it may appears as i)
        
            >>> ((1+I*sqrt(3))**3).normal(); 1+I
            -8
            1+i
        
           * Python integers and reals can be directly converted to giac.
        
            >>> a=giac(2**1024);a.nextprime();(giac(1.234567)).erf().approx(10)
            179769313486231590772930519078902473361797697894230657273430081157732675805500963132708477322407536021120113879871393357658789768814416622492847430639474124377767893424865485276302219601246094119453082952085005768838150682342462881473913110540827237163350510684586298239947245938479716304835356329624224137859
            0.9191788641
        
        
           * There are some natural coercion to Pygen elements:
        
            >>> pi>3.14 ; pi >3.15 ; giac(3)==3
            True
            False
            True
        
           But sometimes you need to prevent Python from doing a computation before the conversion. For example if 1/3 is done in Python2 you will obtain 0 while in Python3 0.33333 so to create: x+1/3:
           >>> x+'1/3'
           x+1/3
           >>> x+giac(1)/3
           x+1/3
        
           while to create x/(1+x) or x+x/3 you don't need quotes because at each step one of the two object is a Pygen.
           >>> x/(1+x)
           x/(1+x)
           >>> (x+x/3).factor()
           4*x/3
        
        
           * The Python object y defined above is of type Pygen. It is not an internal giac variable. (Most of the time you won't need to use internal giac variables).
        
            >>> yyyy=2;giac('yyyy:=1');yyyy
            1
            2
        
        
           Linear Algebra:
           ---------------
        
           * In Giac/Xcas vectors are just lists and matrices are lists of list.
        
            >>> x,y=giac('x,y')
            >>> A=giac([[1,2],[3,4]])  # we create a giac matrix from it lines
            >>> v=giac([x,y]); v   # a giac vector
            [x,y]
            >>> A*v # matrix product with a vector outputs a vector
            [x+2*y,3*x+4*y]
            >>> v*v  # dot product
            x*x+y*y
        
            Remark that w=giac([[x],[y]]) is a matrix of 1 column and 2 rows. It is not a vector    so w*w doesn't make sense.
            >>> w=giac([[x],[y]])
            >>> w.transpose()*w   # this matrix product makes sense and output a 1x1 matrix.
            matrix[[x*x+y*y]]
        
           * In Python affectation doesn't create a new matrix. (cf. pointers) see also  the doc of  'giacpy.Pygen.__setitem__'
        
            >>> B1=A;
            >>> B1[0,0]=43; B1 # in place affectation changes both B1 and A
            [[43,2],[3,4]]
            >>> A
            [[43,2],[3,4]]
            >>> A[0][0]=A[0][0]+1; A  # similar as A[0,0]=A[0,0]+1
            [[44,2],[3,4]]
            >>> A.pcar(x)  # compute the characteristic polynomial of A
            x**2-48*x+170
            >>> B2=A.copy() # use copy to create another object
            >>> B2[0,0]=55; B2  # here A is not modified
            [[55,2],[3,4]]
            >>> A
            [[44,2],[3,4]]
        
        
        
           * Sparse Matrices are avaible via the table function.
            >>> import giacpy
            >>> A=giacpy.table(()); A  # create an empty giac table
            table(
            )
            >>> A[2,3]=33; A[0,2]='2/7' # set non zero entries of the sparse matrix
            >>> A*A  # basic matrix operation are supported with sparse matrices
            table(
            (0,3) = 66/7
            )
            >>> D=giacpy.diag([22,3,'1/7']); D  # some diagonal matrix
            [[22,0,0],[0,3,0],[0,0,1/7]]
            >>> giacpy.table(D)    # to create a sparse matrix from an ordinary one
            table(
            (0,0) = 22,
            (1,1) = 3,
            (2,2) = 1/7
            )
        
        
             But many matrix functions apply only with ordinary matrices so need conversions
        
            >>> B1=A.matrix(); B1 # convert the sparse matrix to a matrix, but the size is minimal
            [[0,0,2/7,0],[0,0,0,0],[0,0,0,33]]
            >>> B2=B1.redim(4,4); B2.pmin(x)  # so we may need to resize B1
            x**3
        
        
           Lists of Pygen and Giac lists:
           ------------------------------
        
           * Here l1 is a giac list and l2 is a python list of Pygen type objects.
        
            >>> l1=giac(range(10)); l2=[1/(i**2+1) for i in l1]
            >>> sum(l2)
            33054527/16762850
        
            So l1+l1 is done in giac and means a vector addition. But l2+l2 is done in Python so it is the list concatenation.
        
            >>> l1+l1
            [0,2,4,6,8,10,12,14,16,18]
        
            >>> l2+l2
            [1, 1/2, 1/5, 1/10, 1/17, 1/26, 1/37, 1/50, 1/65, 1/82, 1, 1/2, 1/5, 1/10, 1/17, 1/26, 1/37, 1/50, 1/65, 1/82]
        
        
           * Here V is not a Pygen element. We need to push it to giac to use a giac method like dim, or we need to use an imported function.
        
            >>> V=[ [x[i]**j for i in range(8)] for j in range(8)]
        
            >>> giac(V).dim()
            [8,8]
        
            >>> dt=det_minor(V).factor(); dt.nops()  # 28 factors
            28
        
            >>> sort(list(dt.op()))
            [x[1]-(x[2]),x[1]-(x[3]),x[1]-(x[4]),x[1]-(x[5]),x[1]-(x[6]),x[1]-(x[7]),x[2]-(x[3]),x[2]-(x[4]),x[2]-(x[5]),x[2]-(x[6]),x[2]-(x[7]),x[3]-(x[4]),x[3]-(x[5]),x[3]-(x[6]),x[3]-(x[7]),x[4]-(x[5]),x[4]-(x[6]),x[4]-(x[7]),x[5]-(x[6]),x[5]-(x[7]),x[6]-(x[7]),x[0]-(x[1]),x[0]-(x[2]),x[0]-(x[3]),x[0]-(x[4]),x[0]-(x[5]),x[0]-(x[6]),x[0]-(x[7])]
        
        
           * Modular objects with %
        
            >>> V=ranm(5,6) % 2;
        
            >>> ker(V).rowdim()+V.rank()
            6
        
            >>> a=giac(7)%3;a;a%0;7%3
            1 % 3
            1
            1
        
           Do not confuse with the  python integers:
        
            >>> type(7%3)==type(a);type(a)==type(7%3)
            False
            False
        
           Syntaxes with reserved or unknown Python symbols:
           -------------------------------------------------
        
           * In general equations needs symbols such as = < > or that have another meaning in Python. So those objects must be quoted.
        
         ::
        
            >>> from giacpy import *
        
            >>> x=giac('x')
        
            >>> (1+2*sin(3*x)).solve(x).simplify()
            list[-pi/18,7*pi/18]
        
            >>> solve('sin(3*x)>2*sin(x)',x)
            "Unable to find numeric values solving equation. For trigonometric equations this may be solved using assumptions, e.g. assume(x>-pi && x<pi) Error: Bad Argument Value"
        
        
           * You can also add some hypothesis to a giac symbol:
        
            >>> assume('x>-pi && x<pi')
            x
            >>> solve('sin(3*x)>2*sin(x)',x)
            list[((x>(-5*pi/6)) and (x<(-pi/6))),((x>0) and (x<(pi/6))),((x>(5*pi/6)) and (x<pi))]
        
           * To remove those hypothesis use the giac function: purge
        
            >>> purge('x')
            assume[[],[line[-pi,pi]],[-pi,pi]]
            >>> solve('x>0')
            list[x>0]
        
         ::
        
           * Same problems with the ..
        
            >>> from giacpy import *
        
            >>> x=giac('x')
        
            >>> f=1/(5+cos(4*x));f.int(x)
            1/2/(2*sqrt(6))*(atan((-sqrt(6)*sin(4*x)+2*sin(4*x))/(sqrt(6)*cos(4*x)+sqrt(6)-2*cos(4*x)+2))+4*x/2)
            >>> fMax(f,'x=-0..pi').simplify()
            pi/4,3*pi/4
            >>> fMax.help()    # doctest: +SKIP
            "Returns the abscissa of the maximum of the expression.
            Expr,[Var]
            fMax(-x^2+2*x+1,x)
            fMin"
            >>> sum(1/(1+x**2),'x=0..infinity').simplify()
            (pi*exp(pi)**2+pi+exp(pi)**2-1)/(2*exp(pi)**2-2)
        
        
           MEMENTO of usual GIAC functions:
           ===============================
        
           * Expand with simplification
        
                 - ``ratnormal``, ``normal``, ``simplify``   (from the fastest to the most sophisticated)
        
                 -  NB: ``expand`` function doesn't regroup nor cancel terms, so it could be slow. (pedagogical purpose only?)
        
           * Factor/Regroup
        
                 - ``factor``, ``factors``, ``regroup``, ``cfactor``, ``ifactor``
        
           * Misc
        
                 - ``unapply``, ``op``, ``subst``
        
           * Polynomials/Fractions
        
                 - ``coeff``,  ``gbasis``, ``greduce``, ``lcoeff``, ``pcoeff``, ``canonical_form``,
        
                 - ``proot``,  ``poly2symb``,  ``symb2poly``, ``posubLMQ``, ``poslbdLMQ``, ``VAS``, ``tcoeff``,  ``valuation``
        
                 - ``gcd``, ``egcd``, ``lcm``, ``quo``, ``rem``, ``quorem``, ``abcuv``, ``chinrem``,
        
                 - ``peval``, ``horner``, ``lagrange``, ``ptayl``, ``spline``,  ``sturm``,  ``sturmab``
        
                 - ``partfrac``, ``cpartfrac``
        
           * Memory/Variables
        
                 * ``assume``, ``about``, ``purge``, ``ans``
        
           * Calculus/Exact
        
                 - ``linsolve``,  ``solve``,  ``csolve``,  ``desolve``,  ``seqsolve``, ``reverse_rsolve``, ``matpow``
        
                 - ``limit``, ``series``, ``sum``, ``diff``, ``fMax``, ``fMin``,
        
                 - ``integrate``, ``subst``, ``ibpdv``, ``ibpu``, ``preval``
        
           * Calculus/Exp, Log, powers
        
                 - ``exp2pow``, ``hyp2exp``, ``expexpand``, ``lin``, ``lncollect``, ``lnexpand``, ``powexpand``, ``pow2exp``
        
           * Trigo
        
                 - ``trigexpand``, ``tsimplify``, ``tlin``, ``tcollect``,
        
                 - ``halftan``, ``cos2sintan``, ``sin2costan``, ``tan2sincos``, ``tan2cossin2``, ``tan2sincos2``, ``trigcos``, ``trigsin``, ``trigtan``, ``shift_phase``
        
                 - ``exp2trig``, ``trig2exp``
        
                 - ``atrig2ln``, ``acos2asin``, ``acos2atan``, ``asin2acos``, ``asin2atan``, ``atan2acos``, ``atan2asin``
        
           * Linear Algebra
        
                 - ``identity``, ``matrix``, ``makemat``, ``syst2mat``, ``matpow``, ``table``,  ``redim``
        
                 - ``det``,  ``det_minor``, ``rank``, ``ker``, ``image``, ``rref``, ``simplex_reduce``,
        
                 - ``egv``, ``egvl``,  ``eigenvalues``, ``pcar``, ``pcar_hessenberg``, ``pmin``,
        
                 - ``jordan``, ``adjoint_matrix``, ``companion``, ``hessenberg``, ``transpose``,
        
                 - ``cholesky``, ``lll``,  ``lu``, ``qr``, ``svd``, ``a2q``, ``gauss``, ``gramschmidt``,
                   ``q2a``, ``isom``, ``mkisom``
        
        
           * Finite Fieds
        
                 - ``%``, ``% 0``, ``mod``, ``GF``, ``powmod``
        
        
           * Integers
        
                 - ``gcd``, ``iabcuv``, ``ichinrem``, ``idivis``, ``iegcd``,
        
                 - ``ifactor``, ``ifactors``, ``iquo``, ``iquorem``, ``irem``,
        
                 - ``is_prime, is_pseudoprime``, ``lcm``, ``mod``, ``nextprime``, ``pa2b2``, ``prevprime``,
                   ``smod``, ``euler``, ``fracmod``
        
           * List
        
                 - ``append``, ``accumulate_head_tail``, ``concat``, ``head``, ``makelist``, ``member``, ``mid``, ``revlist``, ``rotate``, ``shift``, ``size``, ``sizes``, ``sort``, ``suppress``, ``tail``
        
           * Set
        
                 - ``intersect``, ``minus``, ``union``, ``is_element``, ``is_included``
        
        
          
        '''
def giacsettings(self,*args)->Pygen:
        r'''
             A class to customise the Computer Algebra  System settings
        
             * property threads:
        
                 Maximal number of allowed theads in giac
        
             * property digits:
        
                 Default digits number used for approximations:
        
                 ::
        
                     >>> from giacpy import giacsettings,giac
                     >>> giacsettings.digits=20;giacsettings.digits
                     20
                     >>> giac('1/7').approx()
                     0.14285714285714285714
                     >>> giacsettings.digits=12;
        
             * property sqrtflag:
        
                 Flag to allow sqrt extractions during solve and factorizations:
        
                 ::
        
                     >>> from giacpy import giac,giacsettings
                     >>> giacsettings.sqrtflag=False;giacsettings.sqrtflag
                     False
                     >>> giac('x**2-2').factor()
                     x**2-2
                     >>> giacsettings.sqrtflag=True;
                     >>> giac('x**2-2').factor()
                     (x-sqrt(2))*(x+sqrt(2))
        
             * property complexflag:
        
                 Flag to allow complex number in solving equations or factorizations:
        
                 ::
        
                    >>> from giacpy import giac,giacsettings
                    >>> giacsettings.complexflag=False;giacsettings.complexflag
                    False
                    >>> giac('x**2+4').factor()
                    x**2+4
                    >>> giacsettings.complexflag=True;
                    >>> giac('x**2+4').factor()
                    (x+2*i)*(x-2*i)
        
        
             * property eval_level:
        
                 Recursive level of substitution of variables during an evaluation:
        
                 ::
        
                     >>> from giacpy import giacsettings,giac
                     >>> giacsettings.eval_level=1
                     >>> giac("purge(a):;b:=a;a:=1;b")
                     "Done",a,1,a
                     >>> giacsettings.eval_level=25; giacsettings.eval_level
                     25
                     >>> giac("purge(a):;b:=a;a:=1;b")
                     "Done",a,1,1
        
             * property proba_epsilon:
        
                 Maximum probability of a wrong answer with a probabilist algorithm.
                 Set this number to 0 to disable probabilist algorithms (slower):
        
                 ::
        
                     >>> from giacpy import giacsettings,giac
                     >>> giacsettings.proba_epsilon=0;giac('proba_epsilon')
                     0.0
                     >>> giacsettings.proba_epsilon=10^(-13)
                     >>> giac('proba_epsilon')<10^(-14)
                     False
        
             * property epsilon:
        
                 Value used by the epsilon2zero function:
        
                 ::
        
                     >>> from giacpy import giacsettings,giac
                     >>> giacsettings.epsilon=1e-10
                     >>> x=giac('x')
                     >>> P=giac('1e-11+x+5')
                     >>> P==x+5
                     False
                     >>> (P.epsilon2zero()).simplify()
                     x+5
        
             
        '''
def htmlhelp(self,*args)->Pygen:
        r'''From Giac's documentation:
        
           Open the giac html detailled help in an external  browser
        
           There are currently 3 supported lanquages: 'en', 'fr', 'el'
            >>> htmlhelp('fr')         # doctest: +SKIP
            >>> htmlhelp()             # doctest: +SKIP
        
           
        '''
def qcas(self,*args)->Pygen:
        r'''
           * EXPERIMENTAL: Send a giac command to an  interactive 2D geometry display in qcas.
             Current state: Geometric objects will be displayed, but only geometric objects STORED in a giac variable can be used for interactive geometric constructions in qcas.
        
            >>> d1='A:=point(1+i);t:=element(10..100,1,10);C:=circle(A,t*0.05);M:=element(C);'
            >>> qcas(d1)    # doctest: +SKIP
        
           
        '''
def loadgiacgen(self,*args)->Pygen:
        r'''
                  Open a file in giac compressed format to create a Pygen element.
        
                  Use the save method from Pygen elements to create such files.
        
                  In C++ these files can be opened with giac::unarchive and created with
                  giac::archive
        
                    >>> from giacpy import *
                    >>> g=texpand('tan(10*a+3*b)')
                    >>> g.save("fichiertest")           #  doctest: +SKIP
                    >>> a=loadgiacgen("fichiertest")    #  doctest: +SKIP
        
                
        '''
def Airy_Ai(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value of Ai the Airy function solution of w''-xw=0. Ai(x)=Ai(0)f(z)+Ai'(0)g(z)(f et g are taylor's series sol of w''-xw=0).
        Related: Airy_Bi
        Examples:
        Airy_Ai(0);Airy_Ai(1.5)"
        '''
def Airy_Bi(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value of Ai the Airy function solution of w''-xw=0. Bi(x)=sqrt(3)(Bi(0)f(z)-Bi'(0)g(z))(f et g are taylor's series sol of w''-xw=0).
        Related: Airy_Ai
        Examples:
        Airy_Bi(1.5);Airy_Bi(0)"
        '''
def Archive(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Protects the variables given as argument in an archive file.
        Related: Unarchiv, archive, unarchive
        Examples:
        Archive(a,b)"
        '''
def BesselJ(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: BesselJ(p,x) returns the Bessel function of first kind Jp(x).
        Related: besselJ, BesselY, besselY
        Examples:
        BesselJ(2,sqrt(2));BesselJ(-2,sqrt(2))"
        '''
def BesselY(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: BesselY(p,x) returns the Bessel function of second kind Yp(x).
        Related: besselY, BesselJ, besselJ
        Examples:
        BesselJ(2,sqrt(2));BesselJ(-2,sqrt(2))"
        '''
def Beta(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Beta(a,b)=int(t^(a-1)*(1-t)^(b-1),t=0..1), Beta(a,b,p)=int(t^(a-1)*(1-t)^(b-1),t=0..p), Beta(a,b,p,1)=Beta(a,b,p)/Beta(a,b).(Beta(x,y) returns Gamma(x)*Gamma(y)/Gamma(x+y)).
        Related: Gamma, igamma
        Examples:
        Beta(x,y);Beta(3,2);Beta(3,2,0.5);Beta(3,2,0.5,1)"
        '''
def BlockDiagonal(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns either the diagonal matrix with diagonal l or the diagonal of A.
        Related: identity, diag 
        Examples:
        BlockDiagonal([[1,2],[3,4]]);BlockDiagonal([1,2,3])"
        '''
def Ci(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Cosine integral int(cos(t)/t,t=-inf..x)
        Related: Ei, Si, Li
        Examples:
        Ci(1.0)"
        '''
def Circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the circle with center (xc,yc) and radius r (by default option=1 and option=0 is to remove this circle).
        Related: circle
        Examples:
        Circle(0,1,1);Circle(0,1,1,0);Circle(0,1,1,1)"
        '''
def Col(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the index of the column of the lightened cell in the matrixwriter.
        Related: Row
        Examples:
        Col()"
        '''
def CopyVar(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Copy the storage without evaluation of var1 into var2.
        Examples:
        CopyVar(A,B)"
        '''
def Dirac(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Function derivative of Heaviside.
        Related: Heaviside
        Examples:
        Dirac(1);Dirac(-1); int(Dirac(x)*(x-1)^2,x,-1,2)"
        '''
def Ei(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Exponential integral int(exp(t)/t,t=-inf..x)
        Related: Si, Ci, Li
        Examples:
        Ei(1.0)"
        '''
def Factor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorizes a polynomial without evaluation.
        Related: factor, ifactor, normal
        Examples:
        Factor(x^4-1);Factor(x^4+12*x^3+54*x^2+108*x+81)"
        '''
def GF(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Create a Galois Field of characteristic p with p^n elements. The minimal polynomial is primitive except if given or if 0 is passed as last argument.
        Examples:
        GF(2,8);GF(5,9,a);GF(2,128,0);GF(2,w^8+w^7+w^5+w+1);GF(2,8,['a','G']); G:=GF(2,a^8+a^6+a^3+a^2+1,['a','G'],undef)"
        '''
def Gamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Calculus of Gamma at a point a (Gamma(n+1)=n! for n integer) if a>0, Gamma(a)=int(e^{-t}*t^{a-1},t=0..inf)) and Gamma(a)=Gamma(a+1)/a and Gamma(a,b)=ugamma(a,b).
        Related: Psi, Beta, ugamma, igamma
        Examples:
        Gamma(5);Gamma(1/2);gamma(-5.1);Gamma(-5.1,2.1)"
        '''
def Heaviside(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Function equal to 0 if x<0 and 1 if x>=0.
        Related: Dirac, laplace
        Examples:
        Heaviside(1);Heaviside(-1);Heaviside(0)"
        '''
def JordanBlock(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a matrix n*n with a on the diagonal ,1 above and 0 everywhere else.
        Related: jordan
        Examples:
        JordanBlock(7,3)"
        '''
def LU(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: For a numerical matrix A, store in L a lower matrix, in U a upper matrix and in P a permutation matrix such that P*A=L*U.
        Related: lu, QR
        Examples:
        LU([[1,2],[3,4]],L,U,P);LU([[6,12,18],[5,14,31],[3,8,18]],L,U,P)"
        '''
def LambertW(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a solution in t of t*exp(t)=x
        Usage: LambertW(Real(x),[Intg(n)])
        Examples:
        LambertW(1.0);LambertW(ln(4));LambertW(-0.1,-1)"
        '''
def Li(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Logarithm integral Li(x)=Ei(ln(x)) primitive de 1/ln(x) 
        Related: Si, Ci, Ei
        Examples:
        Li(2.0)"
        '''
def Line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the segment [a+i*b,c+i*d].
        Related: segment
        Examples:
        Line(-1,-2,1,2)"
        '''
def LineHorz(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the horizontal line y=a.
        Related: Line, LineVert
        Examples:
        LineHorz(-1)"
        '''
def LineTan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the tangent to y=f(x) at x=a. Do not put parenthesis or put the parenthesis around.
        Related: tangent, droite_tangente
        Examples:
         LineTan sin(x),pi/4; LineTan sin(t),t=pi/4); LineTan sin(t),t,pi/4; LineTan x^2-x,1; (LineTan sin(t),t,pi/4)"
        '''
def LineVert(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the vertical line x=a.
        Related: Line, LineHorz
        Examples:
        LineVert(2)"
        '''
def Phi(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euler's function (euler(n)=card({p<n,gcd(n,p)=1})).
        Usage: Phi(Intg(n))
        Related: gcd
        Examples:
        euler(11);euler(6)"
        '''
def Pi(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: pi
        Related: e, i
        Examples:
         pi/4; Pi/4; evalf(pi); evalf(Pi)"
        '''
def Psi(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Psi(a,n)=n-th derivative of the function DiGamma (=ln@Gamma) at point a (Psi(a,0)=Psi(a)).
        Related: Gamma
        Examples:
        Psi(3,1)"
        '''
def QR(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: For a numerical matrix A, store in Q a orthogonal matrix and in U a lower matrix such that A=Q*R [exchanging by 0 the elements such that abs(el)<eps].
        Related: qr, LU
        Examples:
        QR([[1,2],[3,4]],Q,R)"
        '''
def RandSeed(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Initializes random numbers.
        Related: srand
        Examples:
        RandSeed(321)"
        '''
def Row(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the index of the row of the lightened cell in the matrixwriter.
        Related: Col
        Examples:
        Row()"
        '''
def SortA(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Sorts the lists with increasing order (like TI).
        Related: SortD, sorta, sort
        Examples:
        SortA [3,4,2];SortA 3,4,2;SortA [3,4,2],[6,4,5];SortA [[3,4,2],[6,4,5]]"
        '''
def SortD(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Sorts the lists with decreasing order (like TI).
        Related: SortA, sortd, sort
        Examples:
        SortD [3,4,2];SortD 3,4,2;SortD [[3,4,2],[6,4,5]];SortD [3,4,2],[6,4,5]"
        '''
def UTPC(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Chisquare random variable is greater than x0 (n is the number of degrees of freedom).
        Related: chisquare_cdf, chisquare_icdf
        Examples:
        UTPC(2,6.1);UTPC(4,6.1)"
        '''
def UTPF(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Fisher-Snedecor random variable is greater than x0 (n and d are the numbers of degrees of freedom).
        Related: fisher_cdf, fisher_icdf
        Examples:
        UTPF(4,10,3.5);UTPF(4,4,2.1)"
        '''
def UTPN(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Normal random variable is greater than x0 (mu is the mean and v the variance).
        Related: normal_cdf, normal_icdf
        Examples:
        UTPN(1.96);UTPN(1,4,2.96)+normal_cdf(1,2,2.96)"
        '''
def UTPT(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Student random variable is greater than x0 (n is the number of degrees of freedom).
        Related: student_cdf, student_icdf
        Examples:
        UTPT(3,2.35);UTPT(3,-2.35)"
        '''
def VARS(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of the variables and folders of the current directory.
        Related: lvar
        Examples:
        VARS()"
        '''
def VAS(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a list of intervals containing the real roots of P. Vincent-Akritas-Strzebonski's method (VAS) is used.
        Related: VAS_positive, sturmab, realroot
        Examples:
        VAS(x^3-7*x+7)"
        '''
def VAS_positive(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a list of intervals containing the positive roots of P. Vincent-Akritas-Strzebonski's method (VAS) is used.
        Related: poslbdLMQ, posubLMQ, VAS, realroot
        Examples:
        VAS_positive(x^3-7*x+7)"
        '''
def Zeta(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns if a>1 sum(1/n^a,n,1,+infinity).
        Related: sum
        Examples:
        Zeta(2)"
        '''
def a2q(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: a2q(A,X)=the quadratic form q associated to A, X=vector of variables.
        Related: q2a
        Examples:
        a2q([[1,2],[4,4]],[x,y]);a2q([[1,3],[3,4]],[x,y])"
        '''
def abcuv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns [u,v] such as au+bv=c for 3 polynomials a,b,c.
        Related: egcd, iabcuv
        Examples:
        abcuv(x^2+2*x+1,x^2-1,x+1);abcuv(X^2+2*X+1,X^2-1,X+1,X);abcuv(x^2+2*x+1,x^2-1,x^3+1);abcuv(X^2+2*X+1,X^2-1,X^3+1,X);abcuv([1,2,1],[1,0,-1],[1,0,0,1])"
        '''
def about(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the hypothesis made with assume on the variable a.
        Related: assume, purge
        Examples:
        about(a);about(n)"
        '''
def abs(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the absolute value or the norm of its argument.
        Related: arg
        Examples:
        abs(-4);abs(1+2*i);abs((1+2*i)^2);abs([-2,1+i,-4])"
        '''
def abscissa(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the abscissa of a point or a vector.
        Related: ordinate, affix, cote, coordinates
        Examples:
        abscissa(point(1+2*i));abscissa(point(i)-point(1+2*i));abscissa(-1-i);abscissa(point(1,2,3))"
        '''
def accumulate_head_tail(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list where the first p and the last q elements of l are replaced by their sum.
        Examples:
        accumulate_head_tail([0,1,2,3,4,5,6,7,8,9],3,2)"
        '''
def acos(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arccosine
        Related: cos, acosh
        Examples:
        acos(0)"
        '''
def acos2asin(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces arccos(x) by pi/2-arcsin(x) in the argument.
        Related: acos2atan
        Examples:
        acos2asin(acos(x)+asin(x));acos2asin(2*acos(x))"
        '''
def acos2atan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces arccos(x) by pi/2-arctan(x/sqrt(1-x^2)) in the argument.
        Related: acos2asin
        Examples:
        acos2atan(2*acos(x));acos2atan(acos(sqrt(1-x^2))+acos(x))"
        '''
def acosh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic arccosine.
        Related: cosh, acos
        Examples:
        acosh(1)"
        '''
def acot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arccotangent.
        Related: atan, arccos
        Examples:
        acot(0)"
        '''
def acsc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arccosecant: acsc(x)=asin(1/x).
        Related: asin, csc
        Examples:
        acsc(1);acsc(2)"
        '''
def acyclic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for the random_network command.
        Usage: cycli(Opt)
        Related: random_network
        "
        '''
def add(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Python (linalg): add 2 matrices. Xcas: Discrete sum (with 2 or 4 arguments return then sum from a to b if a<=b or of the opposite of the sum from b+1 to a-1 if a>b+1 or 0 if a=b+1) or the discrete primitive or sum of the elements of a list or a sequence.
        Usage: add(Expr,Var,VarMin(a),VarMax(b),[VarStep(p)])
        Related: +
        Examples:
        add([1,2],[3,4]);add([[1,2],[3,4]],[[5,6],[7,8]])"
        '''
def add_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of digraph G with added arc e (or trail T or list of arcs E).
        Usage: add_arc(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Related: add_edge, delete_arc, digraph, edges, has_arc, trail
        Examples:
        add_arc(digraph(trail(1,2,3,4,5,1)),[[1,3],[2,4]])"
        '''
def add_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of undirected graph G with added edge e (or trail T or list of edges E).
        Usage: add_edge(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Related: add_arc, delete_edge, edges, graph, has_edge, trail
        Examples:
        add_edge(graph(trail(1,2,3,4)),[4,1])"
        '''
def add_vertex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of G with added vertex v [or vertices from list V].
        Usage: add_vertex(Graph(G),Vrtx(v)||Lst(V))
        Related: add_arc, add_edge, delete_vertex
        Examples:
        add_vertex(cycle_graph(5),[""a"",""b""])"
        '''
def additionally(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Make an additionally assumption on a variable.
        Related: purge, about, assume
        Examples:
         assume(n,integer);additionally(n>5); assume(n,integer);assume(n>=2,additionally)"
        '''
def adjacency_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the adjacency matrix of G (rows and columns are indexed by the vertices).
        Usage: adjacency_matrix(Graph(G))
        Related: neighbors
        Examples:
        adjacency_matrix(graph(trail(1,2,3,4,2,5,1,3)))"
        '''
def adjoint_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the characteristic polynomial of A and the comatrix of A-xI.
        Related: pcar
        Examples:
        adjoint_matrix([[1,i],[2,3]])"
        '''
def affix(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Complex number equal to the affix of a point or of a vector.
        Related: point, vector
        Examples:
        affix(point(i));affix(point(i)-point(1+2*i));affix([1,2])"
        '''
def algsubs(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Substitutes in the expression Xpr, the algebraic expression Xpr1 by the algebraic expression Xpr2.
        Related: subst, subs
        Examples:
        algsubs(x^2=u,1+x^2+x^4);algsubs(a*b/c=d, 2*a*b^2/c);algsubs(2a=p^2-q^2,algsubs(2c=p^2+q^2,c^2-a^2))"
        '''
def algvar(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of the variables by ascending algebraic extension order.
        Related: lvar, lname
        Examples:
        algvar(sqrt(x)+y)"
        '''
def all_trig_solutions(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pseudo-variable to return the general solution (all_trig_solutions:=1) or principal solution (all_trig_solutions:=0).
        Usage: all_trig_solutions(:=Intg(0 or 1))
        Related: cas_setup
        Examples:
         all_trig_solutions:=1; all_trig_solutions:=0"
        '''
def allpairs_distance(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a square matrix D of order equal to the number of vertices in G such that D(i,j) is the distance between i-th and j-th vertex of the (weighted) graph G.
        Usage: allpairs_distance(Graph(G))
        Related: dijkstra, graph_diameter, vertex_distance
        Examples:
        allpairs_distance(graph(%{[1,2],[1,3],[1,4],[1,5],[2,3],[3,4],[4,5],[5,2]%}))"
        '''
def alog10(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Function x->10^x.
        Related: log10
        Examples:
        alog10(3)"
        '''
def altitude(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: altitude(A,B,C) draws the altitude through A of the triangle ABC
        Related: perpendicular, orthogonal, orthocenter, common_perpendicular
        Examples:
        altitude(-1,1-i,i)"
        '''
def angle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: angle(A,B,C) is the value of the measure of the angle (AB,AC).
        Related: triangle, bissector, legend, labels, angleat, angleatraw
        Examples:
        angle(point(0),point(i),point(1));angle(0,1,i);angle(0,1,i,"""");angle(0,1,i,""a"");angle(i,1,1+i,""b"")"
        '''
def angle_radian(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pseudo-variable to work with radian (angle_radian:=1) or degree (angle_radian:=0).
        Related: cas_setup
        Examples:
         angle_radian:=1; angle_radian:=0"
        '''
def angleat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: angleat(A,B,C,z0) displays at point(z0) with a legend, the value of the measure of the angle (AB,AC).
        Related: angle, angleatraw, legend
        Examples:
         A:=point(0);B:=point(1);C:=point(i);angleat(A,B,C,-2-i)"
        '''
def angleatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: angleatraw(A,B,C,z0) displays at point(z0), the value of the measure of the angle (AB,AC).
        Related: angle, angleat
        Examples:
         A:=point(0);B:=point(1);C:=point(i);angleatraw(A,B,C,-2-i)"
        '''
def ans(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n+1-th answer of the command history if n>=0 or, the (-n)th previous answer if n<0 (by defaults n=-1 for the previous answer).
        Related: quest
        Examples:
        ans();ans(2);ans(-2)"
        '''
def antiprism_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the antiprism graph of order n.
        Usage: antiprism_graph(Intg(n))
        Related: prism_graph
        Examples:
        antiprism_graph(5)"
        '''
def apply(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Apply the function f at the elements of the list l (option matrix for a matrix). linalg module command in Python
        Related: map, unapply, matrix
        Examples:
        apply(lambda x:x**2,[1,2,3]);apply(lambda x:return x+1,[[1,2,3],[1,2,3]],matrix)"
        '''
def approx(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Numerical evaluation of the first argument (we can give the number of digits as second argument)
        Usage: approx(Expr,[Int])
        Related: evalb, eval
        Examples:
        evalf(2/3);evalf(2/3,2);evalf(2*sin(1));evalf(2*sin(1),40);evalf(sqrt(2)+pi);evalf(sqrt(2)+pi,30)"
        '''
def arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a circle arc given by 2 vertices and the angle at center [Xcas will put the center in C and the radius in r].
        Related: circle, segment, plotparam
        Examples:
        arc(0,1,pi/4);arc(i,1,pi/4,C,r);arc(i,1,pi/4,segment);arc(i,1,pi/4,segment,affichage=1+rempli)"
        '''
def arcLen(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the length of the arc of the curve defined by y=Xpr(or by x=Xpr1,y=Xpr2) when the parameter values are between a and b.
        Related: int
        Examples:
        arcLen(t^2,t,1,2);arcLen([t,t^2],t,1,2);arcLen([cos(t),sin(t)],t,1,2)"
        '''
def arccos(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arccosine
        Related: cos, acosh
        Examples:
        acos(0)"
        '''
def arccosh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic arccosine.
        Related: cosh, acos
        Examples:
        acosh(1)"
        '''
def arclen(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the length of the arc of the curve defined by y=Xpr(or by x=Xpr1,y=Xpr2) when the parameter values are between a and b.
        Usage: arclen(Expr(Xpr) or Lst([Xpr1,Xpr2]),Var,Real(a),Real(b))
        Related: int
        Examples:
        arcLen(t^2,t,1,2);arcLen([t,t^2],t,1,2);arcLen([cos(t),sin(t)],t,1,2)"
        '''
def arcsin(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arcsine.
        Related: sin
        Examples:
        asin(0)"
        '''
def arcsinh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic arcsine.
        Related: sinh, asin
        Examples:
        asinh(0)"
        '''
def arctan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arctangent.
        Related: tan, atanh
        Examples:
        atan(0)"
        '''
def arctanh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic arctangent.
        Related: atan, tanh
        Examples:
        atanh(0)"
        '''
def area(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Algebraic area of a circle, a circle arc or of a (star) polygon (e.g. triangle, square, ...)or of the area below a curve, optionally with a quadrature method (trapezoid,left_rectangle,right_rectangle,middle_point,simpson,rombergt,rombergm).
        Related: trapezoid, perimeter, areaatraw, areaat, areaplot
        Examples:
        area(triangle(0,1,i));area(square(0,2));area(circle(0,2));area(0,1,i);area(x^2,x=0..1,5,trapezoid);area(x^2,x=0..1,5,simpson);area(x^2,x=0..1,5,rombergm)"
        '''
def areaat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Displays at point(z0), with a legend, algebraic area of a circle or of a (star) polygon (e.g. triangle, square, ...)
        Related: area, areaatraw, polygon, perimeteratraw, areaplot
        Examples:
         t:=triangle(0,1,i);areaat(t,(1+i)/2); c:=square(0,2);areaat(c,1+i); c2:=circle(0,2);areaat(c2,1+i); p:=polygon(0,1,i);areaat(p,1+i); A:=point(0);B:=point(1+i);c:=carre(A,B);areaat(c,i)"
        '''
def areaatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Displays at point(z0), algebraic area of a circle or of a (star-)polygon (e.g. triangle, square, ...)
        Related: area, areaat, polygon, perimeteratraw, areaplot
        Examples:
        areaatraw(triangle(0,1,i),(1+i)/2);areaatraw(square(0,2),1+i);areaatraw(circle(0,2),1+i);areaatraw(polygon(0,1,i),1+i); A:=point(0);B:=point(1+i);c:=carre(A,B);areaatraw(c,i)"
        '''
def areaplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Displays the area below a curve, optionally with a quadrature method (trapezoid,left_rectangle,right_rectangle,middle_point).
        Usage: areaplot(Expr,x=a..b,[n],[Method])
        Related: integrate, plot, area, areaat, areaatraw
        Examples:
        plotarea(sin(x),x=0..pi);plotarea(x^2,x=0..1,5,trapezoid);plotarea(x^2,x=0..1,5,middle_point)"
        '''
def arg(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the argument of a complex number.
        Related: abs
        Examples:
        arg(1+i);arg(1+2*i);arg((1+2*i)^2)"
        '''
def array(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Python: vector/matrices class (numpy). Xcas: convert option to define a sparse matrix
        Related: convert, table
        Examples:
        m=array([[1,2],[3,4]]); A[0..2,0..2]:=1 ;A[0..1,1..2]:=2 ;convert(A,array);"
        '''
def arrivals(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of vertices in digraph G which are connected by v with arcs such that heads are in v. If v is omitted, a list of arrivals is computed for every vertex in G.
        Usage: arrivals(Graph(G),[Vrtx(v)])
        Related: in_degree
        Examples:
        arrivals(digraph(%{[1,2],[1,3],[2,3]%}),1)"
        '''
def articulation_points(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of articulation points (cut vertices) of G.
        Usage: articulation_points(Graph(G))
        Related: biconnected_components, is_biconnected, is_connected, is_triconnected
        Examples:
        articulation_points(path_graph(5));articulation_points(cycle_graph(5))"
        '''
def asin(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arcsine.
        Related: sin
        Examples:
        asin(0)"
        '''
def asin2acos(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces arcsin(x) by pi/2-arccos(x) in the argument.
        Related: asin2atan
        Examples:
        asin2acos(acos(x)+asin(x));asin2acos(2*asin(x))"
        '''
def asin2atan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces arcsin(x) by arctan(x/sqrt(1-x^2)) in the argument.
        Related: asin2acos
        Examples:
        asin2atan(2*asin(x));asin2atan(asin(sqrt(1-x^2))+asin(x))"
        '''
def asinh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic arcsine.
        Related: sinh, asin
        Examples:
        asinh(0)"
        '''
def assign_edge_weights(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Assigns random edge weights to the edges of G and returns a modified copy of G. If integers n and m such that n>=m are specified, weights are integers randomly chosen in [m,n]. If an interval a..b is specified, weights are uniformly distributed in the interval [a,b).
        Usage: assign_edge_weights(Graph(G),Seq(m,n)||Intrv(a..b))
        Related: set_edge_weight, get_edge_weight, weight_matrix, random_digraph, random_tournament
        Examples:
        assign_edge_weights(digraph(trail(1,2,3,4,1)),1,9);assign_edge_weights(digraph(trail(1,2,3,4,1)),0..1)"
        '''
def assume(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Make an assumption on a variable.
        Related: purge, about, additionally
        Examples:
        assume(a>0);assume(a=0.3);assume(a:=[pi/4,0,pi/2]);assume(a:=[pi/4,0,pi/2,0.1]);assume(n,integer);;assume(n,integer);additionally(n>6);assume(a>-10 and a<10);assume((a>=2 and a<4) or a>6);assume(a>=2);additionally(a<6);assume(a)"
        '''
def at(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: at(l,j) (or at(m,[j,k])) is the element of the list l (or matrix m) for index=j (or for index j,k).
        Related: of
        Examples:
        at([10,11,12],1);at([[1,2],[3,4]],[1,0])"
        '''
def atan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Arctangent.
        Related: tan, atanh
        Examples:
        atan(0)"
        '''
def atan2acos(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces arctan(x) by pi/2-arccos(x/sqrt(1+x^2)) in the argument.
        Related: atan2acos(atan(x))
        "
        '''
def atan2asin(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces arctan(x) by arcsin(x/sqrt(1+x^2))in the argument.
        Related: atan2asin(atan(x))
        "
        '''
def atanh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic arctangent.
        Related: atan, tanh
        Examples:
        atanh(0)"
        '''
def atrig2ln(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Rewrites the expression containing inverse trigonometric functions with logarithmic functions.
        Related: trig2exp, exp2trig
        Examples:
        atrig2ln(atan(x));atrig2ln(asin(x));atrig2ln(acos(x))"
        '''
def augment(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Concatenates two lists or two strings or two sequences or 2 matrix; L:=concat(L,L1) or L.concat(L1).
        Usage: augment(Lst,Lst||Seq,Seq||Str,Str||Mtrx,Mtrx)
        Related: append, cat, semi_augment, border, +
        Examples:
        concat([1,2],[3,4,5]);concat(""bon"",""jour"");concat([[1,2],[3,4]],[[4,5,6],[6,7,8]]); L:=[1,2];L.concat([3,4,5]); S:=""abcd"";S.concat(""efghi"")"
        '''
def auto_correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the cross-correlation of the given signal with itself.
        Usage: auto_correlation(Lst)
        Related: cross_correlation, correlation
        Examples:
        auto_correlation([1,-1,0,2,1])"
        '''
def autosimplify(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: The argument is a command that Xcas will use to rewrite answers (initial value is regroup and for no simplification it is nop or 0).
        Related: simplify, factor, regroup
        Examples:
        autosimplify(nop);autosimplify(0);autosimplify(regroup);autosimplify(1);autosimplify(factor);autosimplify(simplify)"
        '''
def avance(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: The turtle takes n steps forward (by default n=10).
        Related: recule, saute
        Examples:
        forward(30);avance(30)"
        '''
def avgRC(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns (Xpr(var+h)-Xpr(Var))/h (by default h=0.001).
        Related: nDeriv
        Examples:
        avgRC(f(x),x,h);avgRC(x^2,x,0.1);avgRC(x^2,x)"
        '''
def axes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Global option (Maple compatibility) of a graphic command to put or not the axes.
        Related: line_width, gl_showaxes, switch_axes
        Examples:
         axes=0;segment(0,point(1,1)); axes=1;segment(0,point(1,1),epaisseur=5)"
        '''
def back(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the last element of a vector or a sequence or a string.
        Related: inter, head, mid, left, right
        Examples:
        back(1,2,3);back([1,2,3]);back(""bonjour"")"
        '''
def backward(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: The turtle takes n steps back (by default n=10).
        Usage: backward(NULL or Real(n))
        Related: avance, saute
        Examples:
        backward(30);recule(30)"
        '''
def baisse_crayon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Puts the pencil down so that the turtle move with traces.
        Related: leve_crayon, crayon
        Examples:
        baisse_crayon()"
        '''
def bandwidth(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for the kernel_density command.
        Usage: andwidt(Opt)
        Related: kernel_density, bins
        "
        '''
def bar_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"bar_plot(Mtrx)
        See also: 1/ camembert 2/ histogram 3/ frequencies 
        Ex1:bar_plot([[""France"",6],[""Allemagne"",12],[""Suisse"",5]])
        Ex2:bar_plot([3/2,2/3,5/4,4/5,7/6,6/7,9/8,8/9,11/10])
        Ex3:bar_plot([[2,""xyz"",""abc""],[""A"",2,5],[""B"",5,6],[""C"",7,7]])
        "
        '''
def bartlett_hann_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Bartlett-Hann windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: bartlett_hann_window(Lst,[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bohman_window, cosine_window, gaussian_window, hamming_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(bartlett_hann_window(randvector(1000,0..1)))"
        '''
def barycenter(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: barycenter([point1,coeff1],...) draws the barycenter of point1 with weight coeff1...
        Related: isobarycenter, midpoint
        Examples:
        barycenter([point(-1),1],[point(1+i),2],[point(1-i),1]);barycenter([[point(-1),1],[point(1+i),2],[point(1-i),1]]);barycenter([point(-1),point(1+i),point(1-i)],[1,2,1])"
        '''
def base(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for convert : convert(p,base,b)= [a0,a1,..an] or convert([a0,a1,..an],base,b)=p with p=a0+a1*b+....an*b^(n-1).
        Related: convert, horner, revlist
        Examples:
         convert(123,base,8); convert([3,7,1],base,8); horner(revlist([3,7,1]),8)"
        '''
def basis(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extract a basis from a spanning set of vectors.
        Related: ker, ibasis
        Examples:
        basis([[1,2,3],[4,5,6],[7,8,9],[10,11,12]])"
        '''
def batons(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws for k=0..nrows, the segments (xk,0)-(xk,yk) where xk=element row k column 0 and yk=element row k column j (j=1..ncols).
        Related: polygonplot, scatterplot, listplot
        Examples:
        batons([1,3],[2,5],[3,2]);batons([[1,3],[2,5],[3,2]]);batons([1,2,3],[3,5,2])"
        '''
def bellman_ford(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the length of the shortest path resp. paths from s to vertex t resp. vertices in T in weighted graph G.
        Usage: bellman_ford(Graph(G),Vrtx(s),Vrtx(t)||Lst(T))
        Related: dijkstra, shortest_path
        Examples:
        bellman_ford(graph(%{[[1,2],-1],[[2,3],-3],[[3,4],-7],[[4,5],-3],[[5,6],-3],[[1,6],-3]%}),1,4)"
        '''
def bernoulli(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: bernoulli(n) is the n-th number of Bernoulli and bernoulli(n,x) is the n-th polynomial of Bernoulli and the second argument is the variable.
        Examples:
        bernoulli(6);bernoulli(6,x)"
        '''
def besselJ(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: besselJ(x,p) returns the Bessel function of first kind Jp(x).
        Related: BesselJ, BesselY, besselY
        Examples:
        besselJ(sqrt(2),2);besselJ(sqrt(2),-2)"
        '''
def besselY(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: besselY(x,p) returns the Bessel function of second kind Yp(x).
        Related: BesselY, BesselJ, besselJ
        Examples:
        besselY(sqrt(2),2);besselY(sqrt(2),-2)"
        '''
def betad(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability of the Beta law (=Gamma(a+b)*x^(a-1)*(1-x)^(b-1)/(Gamma(a)*Gamma(b))).
        Related: betad_cdf, betad_icdf
        Examples:
        betad(2.2,1.5,0.8)"
        '''
def betad_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Beta random variable (with a and b as parameters) is lower than x0 or between x0 and y0.
        Related: betad, betad_icdf
        Examples:
        betad_cdf(2,1,0.2);betad_cdf(2,1,0.1,0.3)"
        '''
def betad_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a Beta random variable is lower than h is p (0<=p<=1).
        Related: betad_cdf, betad
        Examples:
        betad_icdf(2,1,0.95);betad_icdf(2,1,0.5)"
        '''
def betavariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a random real according to the Beta distribution of parameter a>0 and b>0
        Usage: betavariate(Real(a),Real(b))
        Related: rand, randpoly, randnorm, randvector
        Examples:
        randbetad(1,2);randbetad(1.5,4)"
        '''
def bezier(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Bezier curve defined by control points.
        Related: parameq
        Examples:
        bezier(1,1+i,2+i,3-i,plot);bezier(point([0,0,0]),point([1,1,0]),point([0,1,1]),plot); parameq(bezier(1,1+i,2+i,3-i)); parameq(bezier(point([0,0,0]),point([1,1,0]),point([0,1,1])))"
        '''
def bezout_entiers(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extended greatest common divisor of 2 integers.
        Usage: bezout_entiers(Intg,Intg)
        Related: gcd, iabcuv, egcd
        Examples:
        iegcd(45,75);iegcd(21,28);iegcd(30,49)"
        '''
def biconnected_components(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the biconnected components of G as a list of lists of vertices.
        Usage: biconnected_components(Graph(G))
        Related: articulation_points, is_biconnected, is_connected, trail
        Examples:
        biconnected_components(graph(trail(1,2,3,4,2),trail(4,5,6,7,5)))"
        '''
def binomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns comb(n,k)*p^k*(1-p)^(n-k) or comb(n,k) if no 3rd argument.
        Related: binomial_cdf, binomial_icdf, multinomial, randvector, ranm
        Examples:
        binomial(4,2);binomial(4,0,0.5);binomial(4,2,0.5); assume(p>=0 and p<=1);binomial(4,2,p); assume(p>=0 and p<=1);binomial(4,p,2); randvector(6,binomial,4,0.2); ranm(4,6,binomial,4,0.7)"
        '''
def binomial_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns Proba(X<=x) or Proba(x<=X<=y) when X follows the B(n,p) law.
        Related: binomial, binomial_icdf
        Examples:
        binomial_cdf(4,0.5,2);binomial_cdf(4,0.1,2);binomial_cdf(4,0.5,2,3)"
        '''
def binomial_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such as Proba(X<=h)=t when X follows the B(n,p) law.
        Related: binomial, binomial_cdf
        Examples:
        binomial_icdf(4,0.5,0.68);binomial_icdf(4,0.1,0.95)"
        '''
def bins(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for the kernel_density command.
        Usage: in(Opt)
        Related: kernel_density, bandwidth
        "
        '''
def bipartite(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for the draw_graph command
        Usage: ipartit(Opt)
        Related: draw_graph
        "
        '''
def bipartite_matching(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of edges in a maximum matching of the undirected unweighted bipartite graph G.
        Usage: bipartite_matching(Graph(G))
        Related: is_bipartite, maximum_matching
        Examples:
        bipartite_matching(graph(""desargues""))"
        '''
def bisection_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving an numerical equation.
        Related: fsolve
        Examples:
         fsolve(cos(x)=x,x,0..1,bisection_solver); fsolve(cos(x)=x,x,0..1,brent_solver); fsolve(cos(x)=x,x,0..1,falsepos_solver); fsolve(cos(x)=x,x,0,newton_solver); fsolve(cos(x)=x,x,0,secant_solver); fsolve(cos(x)=x,x,0,steffenson_solver)"
        '''
def bisector(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the bisector of the angle (AB,AC) given by 3 points A,B,C.
        Related: angle, exbisector
        Examples:
        bisector(0,1,i)"
        '''
def bit_depth(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the bit depth of an audio clip.
        Usage: bit_depth(Lst(clip))
        Related: channels, channel_data, duration, samplerate
        Examples:
        bit_depth(readwav(""/some/file""))"
        '''
def bitand(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Logical bit and.
        Related: bitxor, bitor
        Examples:
        bitand(0x12,0x38)"
        '''
def bitor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Inclusive logical bit or.
        Related: bitxor, bitand
        Examples:
        bitor(0x12,0x38)"
        '''
def bitxor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Exclusive logical bit or.
        Related: bitor, bitand
        Examples:
        bitxor(0x12,0x38)"
        '''
def blackman_harris_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Blackman-Harris windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: blackman_harris_window(Lst,[Interval(n1..n2)])
        Related: bartlett_hann_window, blackman_window, bohman_window, cosine_window, gaussian_window, hamming_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(blackman_harris_window(randvector(1000,0..1)))"
        '''
def blackman_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Blackman windowing function with parameter a (by default a=0.16) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: blackman_window(Lst,[Real(a)],[Interval(n1..n2)])
        Related: blackman_harris_window, bartlett_harris_window, bohman_window, cosine_window, gaussian_window, hamming_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(blackman_window(randvector(1000,0..1)))"
        '''
def blockmatrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix get from the list divided into n lists of dimension m.
        Related: list2mat
        Examples:
        blockmatrix(2,3,[idn(2),idn(2),idn(2),idn(2),idn(2),idn(2)]);blockmatrix(2,2,[idn(2),newMat(2,3),newMat(3,2),idn(3)])"
        '''
def bohman_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Bohman windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: bohman_window(Lst,[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bartlett_hann_window, cosine_window, gaussian_window, hamming_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(bohman_window(randvector(1000,0..1)))"
        '''
def border(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix obtained by bording A with b as latest column, if nrows(A)=size(b), border(A,b)=tran(append(tran(A),b)).
        Related: tran, append, augment
        Examples:
        border([[1,2,3,4],[4,5,6,8],[7,8,9,10]],[1,3,5]);border([[1,2,3],[4,5,6],[7,8,9]],[1,0,1])"
        '''
def boxwhisker(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Box and Whisker plot for a statistical series.
        Related: quartiles
        Examples:
        boxwhisker([-1,1,2,2.2,3,4,-2,5]);boxwhisker([1,2,3,5,10,4],x=1..2);boxwhisker([1,2,3,5,10,4],[1,2,3,1,2,3]);boxwhisker([[6,0,1,3,4,2,5],[0,1,3,4,2,5,6],[1,3,4,2,5,6,0],[3,4,2,5,6,0,1],[4,2,5,6,0,1,3],[2,5,6,0,1,3,4]])"
        '''
def brent_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving an numerical equation.
        Usage: rent_solve(Opt)
        Related: fsolve
        Examples:
         fsolve(cos(x)=x,x,0..1,bisection_solver); fsolve(cos(x)=x,x,0..1,brent_solver); fsolve(cos(x)=x,x,0..1,falsepos_solver); fsolve(cos(x)=x,x,0,newton_solver); fsolve(cos(x)=x,x,0,secant_solver); fsolve(cos(x)=x,x,0,steffenson_solver)"
        '''
def bvpsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns an approximation of the function y (and optionally of y') on the interval a..b.
        Usage: bvpsolve(Expr(f(x,y,y')),Lst(x=a..b,y),Lst(y(a),y(b),[y'(1)]),[options])
        Related: odesolve
        Examples:
        bvpsolve((32+2x^3-y*diff(y(x),x))/8,[x=1..3,y],[17,43/3],20);bvpsolve((x^2*diff(y(x),x)^2-9y^2+4x^6)/x^5,[x=1..2,y],[0,ln(256),1],10,output=spline)"
        '''
def cFactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorization of the expression in ℂ (on the Gauss integers if there are more than 2 variables).
        Related: factor
        Examples:
        cFactor(x^2*y+y);cFactor(x^2*y^2+y^2+4*x^2+4);cFactor(x^2*y^2+y^2+2*x^2+2)"
        '''
def cSolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of complex solutions of an equation or a matrix where the rows are ℂ-solutions of a system of polynomial equations.
        Usage: cSolve(LstEq,LstVar)
        Related: cZeros, solve, fslove
        Examples:
        csolve(x^4-1,x);csolve(x^4-y^4 and x+y=2,[x,y]);csolve(x^4-y^4 and x+y=0 and x^2=2*x,[x,y]);csolve(u*v-u=v and v^2=u,[u,v])"
        '''
def cZeros(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of complex elements solution of Xpr=0 or the matrix where the lines are the solutions of the system : Xpr1=0,Xpr2=0...
        Related: solve
        Examples:
        cZeros(x^2-1);cZeros([x^2-1,x^2-y^2],[x,y])"
        '''
def camembert(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws pie chart of a one variable statistical serie.
        Related: bar_plot
        Examples:
        camembert([[""France"",6],[""Allemagne"",12],[""Suisse"",5]]);camembert([3/2,2/3,5/4,4/5,7/6,6/7,9/8,8/9,11/10]);camembert([[2,""xyz"",""abc""],[""A"",2,5],[""B"",5,6],[""C"",7,7]])"
        '''
def canonical_form(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Canonical_form of a 2 degree polynomial.
        Examples:
        canonical_form(2*x^2-12*x+1);canonical_form(2*a^2-12*a+1,a)"
        '''
def canonical_labeling(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the permutation representing the canonical labeling of G.
        Usage: canonical_labeling(Graph(G))
        Related: isomorphic_copy, relabel_vertices
        Examples:
        canonical_labeling(graph(""petersen""))"
        '''
def cartesian_product(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Cartesian product of graphs G1, G2, ... with vertices labelled as ""u:v:..."" where u, v, ... are vertices from G1, G2, ..., respectively.
        Usage: cartesian_product(Seq(G1,G2,..))
        Related: tensor_product
        Examples:
        cartesian_product(graph(trail(1,2,3,4,5,2)),star_graph(3))"
        '''
def cauchy(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability at x of the Cauchy law of parameters x0 and a (by default  x0=0 and a=1).
        Related: cauchy_cdf, cauchy_icdf
        Examples:
        cauchy(0.0,2.0,1.0)"
        '''
def cauchy_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Cauchy random variable is lower than x.
        Related: cauchyd, cauchy_icdf
        Examples:
        cauchy_cdf(0.0,2.0,2.1);cauchy_cdf(2,3,-1.9,1.4)"
        '''
def cauchy_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a Cauchy random variable is lower than h is p (0<=p<=1).
        Related: cauchy_cdf, cauchy
        Examples:
        cauchy_icdf(0.0,2.0,0.95)"
        '''
def cauchyd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability at x of the Cauchy law of parameters x0 and a (by default  x0=0 and a=1).
        Usage: cauchyd(Real(x0),Real(a),Real(x))
        Related: cauchy_cdf, cauchy_icdf
        Examples:
        cauchy(0.0,2.0,1.0)"
        '''
def cauchyd_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Cauchy random variable is lower than x.
        Usage: cauchyd_cdf(Real(x0),Real(a),Real(x),[Real(y)])
        Related: cauchyd, cauchy_icdf
        Examples:
        cauchy_cdf(0.0,2.0,2.1);cauchy_cdf(2,3,-1.9,1.4)"
        '''
def cauchyd_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a Cauchy random variable is lower than h is p (0<=p<=1).
        Usage: cauchyd_icdf(Real(x0),Real(a),Real(p))
        Related: cauchy_cdf, cauchy
        Examples:
        cauchy_icdf(0.0,2.0,0.95)"
        '''
def cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Cumulated distribution function.
        Related: icdf, binomial_cdf, normald_cdf, plotcdf
        Examples:
        cdf(binomial,10,0.5,4);cdf(normald,0.0,1.0,2.0);cdf([1,3,4,3,5,6],4);cdf([1,3,4,3,5,6],plot)"
        '''
def ceil(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the smallest integer >= to the argument.
        Related: floor, round
        Examples:
        ceil(-4.2);ceil(4.3+2.4*i)"
        '''
def ceiling(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the smallest integer >= to the argument.
        Usage: ceiling(Real or Cplx)
        Related: floor, round
        Examples:
        ceil(-4.2);ceil(4.3+2.4*i)"
        '''
def center(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Shows the center of a circle.
        Related: circle, radius
        Examples:
        center(circle(1+i,2));center(circumcircle(0,1,1+i))"
        '''
def center2interval(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of intervals beginning with a0 and with l as centers.
        Related: interval2center
        Examples:
        center2interval([2,5,9],1);center2interval([2,5,8])"
        '''
def centered_cube(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the direct cube with center A, vertex B and such that the plane ABC contains a symmetry axis of the cube.
        Related: parallelepiped, cube, icosahedron, dodecahedron, octahedron, centered_tetrahedron
        Examples:
        centered_cube([0,0,0],[3,0,0],[0,0,1]);centered_cube(evalf([0,0,0],[3,2,4],[1,1,0]))"
        '''
def centered_tetrahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the regular direct pyramid with center A, vertex B and a vertex in the plan (A,B,C).
        Related: cube, tetrahedron, icosahedron, dodecahedron, octahedron
        Examples:
        centered_tetrahedron([0,0,0],[3,0,0],[0,1,0]);centered_tetrahedron(evalf([0,0,0],[3,2,4],[1,1,0]))"
        '''
def cfactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorization of the expression in ℂ (on the Gauss integers if there are more than 2 variables).
        Usage: cfactor(Expr)
        Related: factor
        Examples:
        cFactor(x^2*y+y);cFactor(x^2*y^2+y^2+4*x^2+4);cFactor(x^2*y^2+y^2+2*x^2+2)"
        '''
def cfsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Numerical solution of an equation or a system of equation on ℂ.
        Related: fsolve, nSolve, csolve, solve
        Examples:
        cfsolve(cos(x)=2);cfsolve([x^2+y+2,x+y^2+2],[x,y])"
        '''
def changebase(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix B=inv(P)*A*P.
        Examples:
        changebase([[1,2],[1,3]],[[1,1],[0,1]]);changebase([[1,2],[1,3]],[[1,0],[1,1]])"
        '''
def channel_data(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extracts the data from an audio clip (optionally specifying the channel and range).
        Usage: channel_data(Lst(clip),[Intg(chn) or matrix],[range=a..b])
        Related: bit_depth, channels, duration, samplerate
        Examples:
        channel_data(readwav(""/some/file""));channel_data(readwav(""/some/file""),matrix);channel_data(readwav(""/some/file""),2);channel_data(readwav(""/some/file""),matrix,range=1.0..2.5)"
        '''
def channels(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the number of channels in audio clip.
        Usage: channels(Lst(clip))
        Related: bit_depth, channel_data, duration, samplerate
        Examples:
        channels(readwav(""/some/file""))"
        '''
def char(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the string corresponding to the character code of the argument.
        Related: asc, ord
        Examples:
        char(65);char([65,66,67])"
        '''
def charpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of the coefficients of the characteristic polynomial of a matrix or characteristic polynomial of a matrix with the second argument as variable.
        Usage: charpoly(Mtrx,[Var])
        Related: jordan, egv, egvl, companion, rat_jordan, pmin, adjoint_matrix 
        Examples:
        pcar([[1,2],[3,4]]);pcar([[1,2],[3,4]],x);pcar([[1,2,3],[1,3,6],[2,5,7]]);pcar([[1,2,3],[1,3,6],[2,5,7]],z)"
        '''
def chinrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Chinese remainder for polynomials written as lists or no.
        Related: ichinrem
        Examples:
        chinrem([x+2,x^2+1],[x+1,x^2+x+1]);chinrem([[1,2],[1,0,1]],[[1,1],[1,1,1]])"
        '''
def chisquare(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability of the Chi^2 law at x0 (n is the number of degrees of freedom).
        Related: chisquare_cdf, chisquare_icdf, randvector, ranm
        Examples:
        chisquare(2,3.2);chisquare(4,10.5); randvector(3,chisquare,2); ranm(4,3,chisquare,2)"
        '''
def chisquare_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Chi^2 random variable is lower than x0 (n is the number of degrees of freedom).
        Related: UTPC, chisquare_icdf, chisquared
        Examples:
        chisquare_cdf(2,6.1);chisquare_cdf(4,6.1)"
        '''
def chisquare_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such as the probability that a Chi^2 random variable is lower than h is p (n is the number of degrees of freedom and 0<=p<=1).
        Related: chisquare_cdf, chisquared
        Examples:
        chisquare_icdf(2,0.95);chisquare_icdf(4,0.05)"
        '''
def chisquared(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability of the Chi^2 law at x0 (n is the number of degrees of freedom).
        Usage: chisquared(Intg(n),Real(x0))
        Related: chisquare_cdf, chisquare_icdf, randvector, ranm
        Examples:
        chisquare(2,3.2);chisquare(4,10.5); randvector(3,chisquare,2); ranm(4,3,chisquare,2)"
        '''
def chisquared_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Chi^2 random variable is lower than x0 (n is the number of degrees of freedom).
        Usage: chisquared_cdf(Intg(n),Real(x0))
        Related: UTPC, chisquare_icdf, chisquared
        Examples:
        chisquare_cdf(2,6.1);chisquare_cdf(4,6.1)"
        '''
def chisquared_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such as the probability that a Chi^2 random variable is lower than h is p (n is the number of degrees of freedom and 0<=p<=1).
        Usage: chisquared_icdf(Intg(n),Real(p))
        Related: chisquare_cdf, chisquared
        Examples:
        chisquare_icdf(2,0.95);chisquare_icdf(4,0.05)"
        '''
def chisquaret(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Chi^2 test : adequation between 2 (or n) samples or between 1 sample and a distribution law (multinomial or given by a law).
        Related: normalt, studentt, kolmogorovt
        Examples:
        chisquaret([57,54]);chisquaret([1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,1,0,1,1,0,0,0,0],[.4,.6]);chisquaret([57,30],[.6,.4]);chisquaret([17,15,12,15],[15,13,13,14]);chisquaret(ranv(1000,binomial,10,.5),binomial);chisquaret(ranv(1000,binomial,10,.5),binomial,11,.5);chisquaret(ranv(1000,normald,0,.2),normald);chisquaret([11,16,17,22,14,10],[1/6,1/6,1/6,1/6,1/6,1/6]);chisquaret([11,16,17,22,14,10],[(1/6)$6])"
        '''
def choice(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: choice(L)=rand(L)=one extracted element of L.
        Usage: choice(Lst(L))
        Related: rand , sample
        Examples:
        choice([1,2,3,4,5,6]);choice([""r"",""r"",""r"",""b"",""n""]); L:=[1,2,3,4,5,6];L:=choice(L); L:=[1,2,3,4,5,6];L.choice()"
        '''
def cholesky(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: For a numerical symmetric matrix A, returns L matrix such that A=L*tran(L).
        Related: lu, qr, gauss
        Examples:
        cholesky([[3,1],[1,4]])"
        '''
def chr(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the string corresponding to the character code of the argument.
        Usage: chr(Intg or Lst(Intg))
        Related: asc, ord
        Examples:
        char(65);char([65,66,67])"
        '''
def chrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Chinese remainders for integers or for polynomials.
        Related: gcd, fracmod, chinrem, ichinrem
        Examples:
        symbolique.;chrem([2,3],[7,5]);chrem([2,4,6],[3,5,7]);chrem([2,4,6,7],[3,5,7,11]);chrem([2*x+1,4*x+2,6*x-1,x+1],[3,5,7,11])"
        '''
def chromatic_index(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the number of colors in the minimal edge coloring of G. If an unassigned identifier cols is given, the coloring is stored to it.
        Usage: chromatic_index(Graph(G),[Lst(cols)])
        Related: minimal_edge_coloring, chromatic_number
        Examples:
        chromatic_index(graph(""petersen""));chromatic_index(graph(""dodecahedron""),colors)"
        '''
def chromatic_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the chromatic number of G.
        Usage: chromatic_number(Graph(G))
        Examples:
        chromatic_number(graph(""petersen""))"
        '''
def chromatic_polynomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the chromatic polynomial [or its value at point t] of undirected unweighted graph G.
        Usage: chromatic_polynomial(Graph(G),[Var(t)])
        Related: flow_polynomial, reliability_polynomial, tutte_polynomial
        Examples:
        chromatic_polynomial(graph(""petersen""));chromatic_polynomial(graph(""petersen""),3)"
        '''
def circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: With one argument r, asks the turtle to draw a circle of radius r. Otherwise, define a 2-d circle with a diameter MN (arg1=M ou zM,arg2=N) or  with center and radius (arg1=M ou zM,arg2=zN) et (center=M et radius=abs(zN)) [or the arc AB, A angle a, B angle b, (MN=angle 0) or M(M+zN)=angle 0] or by its equation and for 3-d with a diameter and a third point.
        Related: circumcircle, incircle, excircle, center, radius, sphere, Circle
        Examples:
        circle(30);circle(0,point(2*i));circle(i,i);circle(i,1);circle(0,i,pi/4,pi/2);circle(0,i,pi/4,pi/2,A,B);circle(x^2+y^2-x-y);cercle(point([-1,0,0]),point([1,0,0]),point([0,2,0]));cercle([-1,0,0],point([1,0,0]),[0,2,0])"
        '''
def circumcircle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: circumcircle(A,B,C)=circumcircle of the triangle ABC.
        Related: circle, incircle, excircle
        Examples:
        circumcircle(0,1,1+i)"
        '''
def classes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix [[class,number],...] get with class_min and class_size: see init of geo or argument 2 and 3 or with the list of centers.
        Related: histogram, cumulated_frequencies, bar_plot, frequencies
        Examples:
        classes([1,1.2,1.4,1.6,1.8,2,2.5]);classes([1,1.2,1.4,1.6,1.8,2,2.5],1.2,0.5);classes([1,1.2,1.4,1.6,1.8,2,2.5],1,[1.2,1.6,2,2.4]);classes([1,1.2,1.4,1.6,1.8,2,2.5],1,[1.2,1.6,2.2]);classes([0,0.5,1,1.5,2,2.5,3,3.5,4],[0..2,2..4,4..6])"
        '''
def clear(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Clear the list of pixels
        Usage: clear(NULL)
        Related: set_pixel, show_pixels
        Examples:
        clear()"
        '''
def clique_cover(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a clique vertex cover of G [containing at most k cliques].
        Usage: clique_cover(Graph(G),[Intg(k)])
        Related: clique_cover_number, maximal_cliques
        Examples:
        clique_cover(graph(""petersen""));clique_cover(cycle_graph(5));clique_cover(graph_complement(complete_graph(3,4)))"
        '''
def clique_cover_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the clique cover number of G.
        Usage: clique_cover_number(Graph(G))
        Related: clique_cover, maximal_cliques
        Examples:
        clique_cover_number(graph(""petersen""));clique_cover_number(cycle_graph(5));clique_cover_number(graph_complement(complete_graph(3,4)))"
        '''
def clique_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the clique number of G, which is equal to the size of a maximum clique in G.
        Usage: clique_number(Graph(G))
        Related: maximum_clique
        Examples:
        clique_number(graph_complement(complete_graph(3,4)))"
        '''
def clique_stats(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of numbers of maximal cliques of size s in G for each s. If parameter k is given, the number of k-cliques is returned. If an interval m..n is given, only cliques with size between m and n (inclusive) are counted (m also may be +infinity).
        Usage: lique_stat(Graph(G),[Intg(k)||Intrv(m..n)])
        Related: maximum_clique, clique_cover
        Examples:
        clique_stats(random_graph(50,0.5));clique_stats(random_graph(50,0.5),5);clique_stats(random_graph(50,0.5),3..5)"
        '''
def clustering_coefficient(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the average clustering coefficient of undirected graph G, or the local clustering coefficient of the vertex v in G.
        Usage: clustering_coefficient(Graph(G),[Vrtx(v)])
        Related: network_transitivity, number_of_triangles
        Examples:
        clustering_coefficient(graph(%{[1,2],[2,3],[2,4],[3,4],[4,1]%}));clustering_coefficient(graph(%{[1,2],[2,3],[2,4],[3,4],[4,1]%}),2)"
        '''
def coeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of coefficients of a polynomial with respect to the 2nd argument or the coefficient of degree the 3rd argument.
        Related: pcoeff, fcoeff
        Examples:
        coeff(x*3+2);coeff(5*y^2-3,y);coeff(5*y^2-3,y,2)"
        '''
def coeffs(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of coefficients of a polynomial with respect to the 2nd argument or the coefficient of degree the 3rd argument.
        Usage: coeffs(Expr(P),[Var])
        Related: pcoeff, fcoeff
        Examples:
        coeff(x*3+2);coeff(5*y^2-3,y);coeff(5*y^2-3,y,2)"
        '''
def col(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the column n or the sequence of the columns n1..n2 of the matrix A, or optional argument of count,count_eq,count_inf,count_sup.
        Related: row, count, count_eq, count_inf, count_sup
        Examples:
        col([[1,2,3],[4,5,6],[7,8,9]],1);col([[1,2,3],[4,5,6],[7,8,9]],0..1); count_eq(3,[[3,2,3],[4,3,2],[3,2,1]],col)"
        '''
def colDim(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Number of columns of a matrix.
        Usage: colDim(Mtrx)
        Related: rowdim
        Examples:
        coldim([[1,2,3],[4,5,6]]);coldim([[1,2],[3,4],[5,6]])"
        '''
def colNorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the max of the l1_norm fo the columns of a matrix: colNorm(a_{j,k})=max_k(sum_j(|a_{j,k}|)).
        Related: norm
        Examples:
        colNorm([[1,2],[3,-4]]);colNorm([[1,2,3,-4],[-5,3,2,1]])"
        '''
def colSwap(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix get from A by swapping the n1-th column and the n2-th column.
        Related: rowSwap
        Examples:
        colSwap([[1,2],[3,4],[5,6]],0,1)"
        '''
def coldim(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Number of columns of a matrix.
        Related: rowdim
        Examples:
        coldim([[1,2,3],[4,5,6]]);coldim([[1,2],[3,4],[5,6]])"
        '''
def collect(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Integer factorization of a polynomial (or of a list of poly).
        Related: factor, factors
        Examples:
        collect(x^2-4);collect(x^2-2);collect([x^2-2,x^2-4])"
        '''
def colnorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the max of the l1_norm fo the columns of a matrix: colNorm(a_{j,k})=max_k(sum_j(|a_{j,k}|)).
        Usage: colnorm(Vect or Mtrx)
        Related: norm
        Examples:
        colNorm([[1,2],[3,-4]]);colNorm([[1,2,3,-4],[-5,3,2,1]])"
        '''
def color(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws an geometrical object with colors black=0 red=1 green=2 yellow=3 blue=4, filled put the color in the interior of a closed curve,line_width_n (0<n<8) is for the width of the line and dash_line is for dotted line.
        Usage: color([GeoObj or legende],Intg)
        Related: -<, legende
        Examples:
        display(A,1);display(F:=point(2+1.5*i),2);display(point(2+1.5*i),2);display(legende(1+i,""abc""),4);display(square(0,1),filled+red);display(carre(0,1),rempli+rouge);display(circle(0,1),filled);display(line(y=x),green+dash_line+line_width_2);display(red);square(0,1);;display(red+filled);square(0,1);"
        '''
def colspace(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a matrix where the columns are a basis of the vector space generated by the columns of the matrix A [d is the dimension of this space].
        Related: rowspace
        Examples:
        colspace([[1,2,3],[1,2,3],[1,2,4],[1,2,5]]);colspace([[1,2,3],[1,3,6],[2,5,9]],d)"
        '''
def colswap(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix get from A by swapping the n1-th column and the n2-th column.
        Usage: colswap(Mtrx(A),Intg(n1),Intg(n2))
        Related: rowSwap
        Examples:
        colSwap([[1,2],[3,4],[5,6]],0,1)"
        '''
def comDenom(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the expression after reduction at the same denominator : the numerator and the denominator are developed [according to the powers of the variable var].
        Related: normal
        Examples:
        comDenom(1/x+1/y^2+1);comDenom(1/x+1/y^2+1,y);comDenom(1/x+1/y^2+1,x)"
        '''
def comb(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: comb(n,r)=number of combinations of r objects taken among n : n!/(r!(n-r)!) (If n<0 comb(n,r)=n(n-1)..(n-r+1)/r!).
        Related: factorial, perm
        Examples:
        comb(4,2)"
        '''
def combine(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Combines terms in Xpr according to a [class of] function f (2nd argument).
        Related: lncollect, lin, tlin, tcollect
        Examples:
        combine(exp(x)*exp(y),exp);combine(sin(x)*cos(x),trig);combine(ln(x)+ln(y),ln)"
        '''
def comment(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Comment in a program.
        Examples:
        comment(""my_comment"")"
        '''
def common_perpendicular(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the common perpendicular of the lines D1 and D2.
        Related: altitude, perpendicular
        Examples:
        common_perpendicular(line([0,0,0],[0,5,5]),line([5,0,0],[0,0,5]))"
        '''
def companion(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Companion matrix of a polynomial (an=1).
        Related: pcar, rat_jordan
        Examples:
        companion(x^2+5x-7,x);companion(-pcar([[1,0,1],[0,2,-1],[1,-1,1]],x),x)"
        '''
def compare(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if type(arg1)<type(arg2) or if type(arg1)=type(arg2) and arg1<arg2, else returns 0.
        Related: type
        Examples:
        compare(1,2);compare(1.0,2);compare(""ab"",""cd"")"
        '''
def complete_binary_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the complete binary tree with depth n.
        Usage: complete_binary_tree(Intg(n))
        Related: complete_kary_tree, is_tree, random_tree
        Examples:
        complete_binary_tree(3)"
        '''
def complete_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a complete graph with vertices from list V or enumerated with first n integers or, when two or more positive integers n1,n2,...,nk are given, a complete k-partite graph with partition sizes n1,n2,...,nk.
        Usage: complete_graph(Intg(n)||Lst(V)||Seq(n1,n2,...,nk))
        Related: edges
        Examples:
        complete_graph(4);complete_graph([""one"",""two"",""three""]);complete_graph(2,3,4)"
        '''
def complete_kary_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the complete k-ary tree with depth n.
        Usage: complete_kary_tree(Intg(n))
        Related: complete_binary_tree, is_tree, random_tree
        Examples:
        complete_kary_tree(3,3)"
        '''
def complex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: DOM_COMPLEX or complex is the type of a complex or of a complex variable, as returned by the type command. It is also an option of the assume command.
        Usage: complex(Opt)
        Related: type, assume, DOM_INT, DOM_FLOAT
        Examples:
         assume(a,complex); assume(a,DOM_COMPLEX); a:=1+i;type(a)"
        '''
def complex_variables(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pseudo-variable to work with complex variables (complex_variables:=1) or with real variables (complex_variables:=0).
        Related: cas_setup
        Examples:
         complex_variables:=1; complex_variables:=0"
        '''
def complexroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of complex intervals of size<=l containing roots of P (for example i[1.1,1.2]+i[2,2.4]*i pour [1.1,1.2]x[2,2.4] with optionally a=1+2*i,b=2+3*i) with multiplicities.
        Related: proot, froot, realroot, rationalroot, crationalroot
        Examples:
        complexroot(x^4+1,1e-50,0.7+i*0.7,0.8+i*0.8);complexroot(x^5-2*x^4+x^3+i,0.1);complexroot(x^3+8,1e-5,0,2+2*i);complexroot(x^5-2*x^4+x^3+i,0.1,1+0.5*i,1.1+0.7*i)"
        '''
def concat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Concatenates two lists or two strings or two sequences or 2 matrix; L:=concat(L,L1) or L.concat(L1).
        Related: append, cat, semi_augment, border, +
        Examples:
        concat([1,2],[3,4,5]);concat(""bon"",""jour"");concat([[1,2],[3,4]],[[4,5,6],[6,7,8]]); L:=[1,2];L.concat([3,4,5]); S:=""abcd"";S.concat(""efghi"")"
        '''
def cond(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Condition number of a matrix, use COND(.,1) for l1, COND(.,2) for l2 norm and COND(.,inf) for linf (1 by default).
        Usage: cond(Mtrx,[2]||[inf])
        Related: SVL
        Examples:
        COND([[1,2],[1,4]]);COND([[1,2],[1,4]],1);COND([[1,2],[1,4]],2);COND([[1,2],[1,4]],inf)"
        '''
def condensation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graph obtained by contracting strongly connected components of the digraph G to single vertices.
        Usage: condensation(Graph(G))
        Related: strongly_connected_components
        Examples:
        condensation(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}))"
        '''
def cone(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a cone with vertex A, direction v, and with half_angle t [and with altitude h and -h].
        Related: half_cone, cylinder
        Examples:
        cone([0,0,0],[0,0,1],pi/6);cone([0,0,0],[0,1,1],pi/6,4)"
        '''
def confrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the convert or convertir command (ex id L:=dfc(sqrt(2),1e-10)).
        Related: convert
        Examples:
         convert(sqrt(2),confrac,'L'),L"
        '''
def conic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Defines a conic by its equation with x,y as default variables and draws it.
        Related: circle, ellipse, hyperbola, parabola, reduced_conic
        Examples:
        conic(x^2+y^2-x*y-3);conic(x^2+2*y^2-x*y-3,x,y);conic(u^2-2*v^2-2*u*v-1,[u,v]);conic(y^2-x*y+3,[x,y])"
        '''
def conj(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the conjugate of a complex number.
        Related: re, im, tran
        Examples:
        conj(1+i);conj(1+2*i);conj((1+2*i)^2);conj([[1+i,2,3],[1,3,6],[2,5,9-i]])"
        '''
def conjugate_equation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the expression which is zero for a point x1 conjugate to x (a is the left or the right bound for x) with respect to the function y0 depending on two parameters in P with values in V.
        Usage: conjugate_equation(Expr(y0),Lst(P),Lst(V),Var(x),Real(a))
        Related: jacobi_equation, euler_lagrange
        Examples:
        conjugate_equation(A*sin(t)+B*cos(t),[A,B],[1,0],t,0)"
        '''
def conjugate_gradient(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Conjuagte gradient algorithm to solve A*x=y approximately (precision eps) where A is a symmetric positive definite matrix, x0 an optional initial guess.
        Related: linsolve
        Examples:
        conjugate_gradient([[2,1],[1,5]],[1,0]);conjugate_gradient([[4,1+i],[1-i,5]],[1,0]);conjugate_gradient([[2,1],[1,5]],[1,0],[0.55,-0.11],1e-2);conjugate_gradient([[2,1],[1,5]],[1,0],[0.55,-0.11],1e-10)"
        '''
def connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for the random_regular_graph command.
        Usage: onnecte(Opt)
        Related: directed, weighted, random_regular_graph
        "
        '''
def connected_components(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a list of lists of vertices, each sublist representing a connected component of G.
        Usage: connected_components(Graph(G))
        Related: articulation_points, is_biconnected, is_strongly_connected, strongly_connected_components, underlying_graph
        Examples:
        connected_components(graph_complement(cycle_graph(4)))"
        '''
def cont(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Continues execution of a stopped program.
        Related: continue
        Examples:
        cont()"
        '''
def contains(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Tests if a set contains an expression (returns the index+1 or 1 for intervals or 0).
        Related: inString, member, est_element
        Examples:
        contains(%{0,1,2,3%},2);contains([0,1,2,3],4);contains([1..2],1.5)"
        '''
def content(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the gcd of the coefficients of the polynomial P given as argument.
        Related: primpart, lgcd
        Examples:
        content(2*x^2+10*x+6);content([2,10,6]);content(2*t^2+10*t+6,t)"
        '''
def contourplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws whether 11 equirepartited contour-lines z=z_min,,...z=z_max of the surface z=Xpr, whether the contour-lines defined by the 3-rd argument.
        Usage: contourplot(Expr(Xpr),[LstVar],[LstVal])
        Related: plotdensity, plotimplicit
        Examples:
        plotcontour(x^2+y^2);plotcontour(x^2+y^2,[x,y]);plotcontour(x^2+2*y^2-2,[x,y],[1.0,2.0,3.0]);plotcontour(x^2-y^2,[x=-4..4,y=-4..4],seq(k,k,-11,11,3),xstep=0.1,ystep=0.1)"
        '''
def contract_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of undirected graph G with edge e contracted (to contract more edges apply the foldl command).
        Usage: contract_edge(Graph(G),Edge(e))
        Related: delete_edge, delete_vertex, foldl
        Examples:
        contract_edge(complete_graph(4),[1,3])"
        '''
def convert(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value of cmd(Xpr) cmd is the name of a command specified by the 2nd argument (for ex option sin=command trigsin).
        Related: mksa, list, polynom, table
        Examples:
        convert(cos(x)^2,sin);convert(exp(i*x),sincos);convert(1/(x^4-1),parfrac);convert(series(sin(x),x=0,6),polynom);convert([[1,[2,0]],[2,[1,1]],[1,[0,2]]],polynom);convert(%%%{1,[2,0]%%%}+%%%{2,[1,1]%%%}+%%%{1,[0,2]%%%},list);convert(cos(x)^2+1,sin);convert(3e10 _m,_au);convert(pi _rad,_deg);convert(9976/6961,confrac,'l');l;convert(sqrt(2),confrac,'dev');dev;convert(123,base,8);convert([3,7,1],base,8);convert([1,2,3],set[]);convert(pi,interval,20); A[2,1]:=1;convert(A,array); B[0..1,1..2]:=1;B[2,2]:=2;convert(B,array)"
        '''
def convertir(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value of cmd(Xpr) cmd is the name of a command specified by the 2nd argument (for ex option sin=command trigsin).
        Usage: convertir(Expr(Xpr),Cmd(cmd))
        Related: mksa, list, polynom, table
        Examples:
        convert(cos(x)^2,sin);convert(exp(i*x),sincos);convert(1/(x^4-1),parfrac);convert(series(sin(x),x=0,6),polynom);convert([[1,[2,0]],[2,[1,1]],[1,[0,2]]],polynom);convert(%%%{1,[2,0]%%%}+%%%{2,[1,1]%%%}+%%%{1,[0,2]%%%},list);convert(cos(x)^2+1,sin);convert(3e10 _m,_au);convert(pi _rad,_deg);convert(9976/6961,confrac,'l');l;convert(sqrt(2),confrac,'dev');dev;convert(123,base,8);convert([3,7,1],base,8);convert([1,2,3],set[]);convert(pi,interval,20); A[2,1]:=1;convert(A,array); B[0..1,1..2]:=1;B[2,2]:=2;convert(B,array)"
        '''
def convex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a list of conditions under which f(x,y,..) is convex.
        Usage: convex(Expr(f),Lst(x,y,..))
        Related: hessian
        Examples:
        convex(-2x+y+x^2-2x*y+y^2,[x,y]);convex(3*exp(x)+5x^4-ln(x),x);convex(x+y-exp(x)-exp(x+y),[x,y]);convex(x^2+y^2+3z^2-x*y+2x*z+y*z,[x,y,z]);convex(x1^3+2x1^2+2*x1*x2+x2^2/2-8x1-2x2-8,[x1,x2]);convex(x1^2+2x2^2+a*x3^2-2x1*x2+2x1*x3-6x2*x3,[x1,x2,x3]);convex(exp(x1)+exp(x2)+x1*x2,[x1,x2]);convex(sqrt((1+cos(x)^2)/sin(x)),x);convex(sqrt((1+(u')^2)/(2*g*u)),u(t))"
        '''
def convexhull(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Convex hull of a list of 2-d points.
        Related: polygon
        Examples:
        convexhull(0,1,1+i,1+2i,-1-i,1-3i,-2+i);convexhull([0,1,1+i,1+2i,-1-i,1-3i,-2+i]); polygon(convexhull(0,1,1+i,1+2i,-1-i,1-3i,-2+i))"
        '''
def convolution(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the convolution of two signals u and v.
        Usage: convolution(Lst(u),Lst(v))
        Related: fft, cross_correlation
        Examples:
        convolution([1,2,3],[1,-1,1,-1])"
        '''
def coordinates(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list (resp matrix) of the abscissa and of the ordinate of a point or a vector (resp of points or vectors).
        Related: abscissa, ordinate, cote, vecteur
        Examples:
        coordinates(point(1+2*i));coordinates(1+2*i);coordinates(point(i),point(1+2*i));coordinates(vecteur(point(i),point(1+2*i)));coordinates(point(1+2*i)-point(i));coordinates(-1-i);coordinates(point(1,2,3));coordinates(vecteur([1,2,3],[4,5,6]))"
        '''
def copy(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: A:=copy(B) clones the list or matrix B in A.
        Related: =<
        Examples:
         A:=copy(B)"
        '''
def correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the correlation of the elements of its argument.
        Related: covariance, covariance_correlation
        Examples:
        correlation([[1,2],[1,1],[4,7]])"
        '''
def cos(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Cosine or Option of the convert or convertir command (id trigcos).
        Related: acos, convert, trigsin
        Examples:
        cos(0); convert(cos(x)^4+sin(x)^2,cos)"
        '''
def cos2sintan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Replaces cos(x) by sin(x)/tan(x) in the argument.
        Related: tan2sincos, sin2costan, tan2sincos2, tan2cossin2
        Examples:
        cos2sintan(cos(x))"
        '''
def cosh(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hyperbolic cosine.
        Related: acosh
        Examples:
        cosh(0)"
        '''
def cosine_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the cosine windowing function with parameter a>0 (by default a=1 for sine window) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: cosine_window(Lst,[Real(a)],[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bohman_window, bartlett_hann_window, gaussian_window, hamming_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(cosine_window(randvector(1000,0..1),1.5))"
        '''
def cot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Cotangent.
        Related: acot, tan
        Examples:
        cot(pi/2)"
        '''
def cote(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Third coordinate (z) of a 3-d point.
        Related: abscissa, ordinate, coordinates
        Examples:
        cote(point[1,2,3]);cote(point(1,2,3))"
        '''
def count(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns f(l[0])+f(l[1])+...+f(l[size(l)-1]) or count number of occurrences if the argument is a vector of integers.
        Related: count_eq, count_inf, count_sup
        Examples:
        count(id,[-2/5,-1,0,1,2,3/5]);count(1,[-2,-1,0,1,2,3]);count([1,3,1,1,2,10,3]);count((x)->x>2,[3/2,5/2,8/3]);count((x)->x==1,[-2,1,0,1,2,3]);count((x)->x>2,[[3,5/2],[4,1]]);count((x)->x>2,[[3,5/2],[4,1]],row);count((x)->x>2,[[3,5/2],[4,1]],col);count((x)->x>2 && x<4,[[3,9/2],[4,1]]);count((x)->x<2 || x>4,[[3,9/2],[4,1]])"
        '''
def count_eq(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the number of elements of L equal to a.
        Related: count, count_inf, count_sup
        Examples:
        count_eq(1,[-2,1,0,1,2,-3]);count_eq(4,[[3,4],[4,1]]);count_eq(4,[[3,4],[4,1]],row);count_eq(4,[[3,4],[4,1]],col)"
        '''
def count_inf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the number of elements of L strictly lower than a.
        Related: count, count_eq, count_sup
        Examples:
        count_inf(1,[-2,-1,0,1,2,3]);count_inf(4,[[3,5],[4,1]]);count_inf(4,[[3,5],[4,1]],row);count_inf(4,[[3,5],[4,1]],col)"
        '''
def count_sup(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the number of elements of L strictly greater than a.
        Related: count, count_inf, count_eq
        Examples:
        count_sup(1,[-2,-1,0,1,2,3]);count_sup(3,[[3,5],[4,1]]);count_sup(3,[[3,5],[4,1]],row);count_sup(3,[[3,5],[4,1]],col)"
        '''
def courbe_parametrique(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: plotparam(a(x)+i*b(x),x=x0..x1) draws the curve X=a(x),Y=b(x) x=x0..x1 or plotparam([a(u,v),b(u,v),c(u,v)],[u=u0..u1,v=v0..v1]) draws the surface X=a(u,v),Y=b(u,v),Z=c(u,v) u=u0..u1 and v=v0..v1.
        Usage: courbe_parametrique(Cplx||Lst,Var||Lst(Var))
        Related: plotfunc, plotpolar, arc
        Examples:
        plotparam(sin(t)+i*cos(t),t);plotparam(exp(i*t),t=0..pi/2,affichage=1);plotparam(exp(i*t),t=0..pi/2,affichage=1+rempli);plotparam([sin(x),cos(x)],x=0..1);plotparam([sin(x),cos(x)],x=0..1,affichage=rouge);plotparam(sin(x)+i*cos(x),x=0..1,tstep=0.01);plotparam([v*cos(u),v*sin(u),v],[u,v]);plotparam([v*cos(u),v*sin(u),v],[u=0..pi,v=0..3],ustep=0.1,vstep=0.2)"
        '''
def courbe_polaire(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: plotpolar(f(x),x,a,b) draws the polar curve r=fx) for x in [a,b].
        Usage: courbe_polaire(Expr,Var,VarMin,VarMax)
        Related: plotparam, plotfunc, plotpolar
        Examples:
        plotpolar(sin(2*x),x,0,pi);plotpolar(sin(2*x),x,0,pi,tstep=0.1)"
        '''
def covariance(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the covariance of the elements of its argument
        Related: correlation, covariance_correlation
        Examples:
        covariance([[1,2],[1,1],[4,7]])"
        '''
def covariance_correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of the covariance and the correlation of the elements of its argument.
        Related: covariance, correlation
        Examples:
        covariance_correlation([[1,2],[1,1],[4,7]])"
        '''
def cpartfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Performs partial fraction decomposition in ℂ of a fraction.
        Related: factor, normal
        Examples:
        cpartfrac((x)/(4-x^2));cpartfrac((x^2-2*x+3)/(x^2-3*x+2));cpartfrac(a/(z*(z-b)),z)"
        '''
def crationalroot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of complex rational roots of P without indicating the multiplicity.
        Related: proot, froot, complexroot, rationalroot, realroot
        Examples:
        crationalroot(2*x^3+(-5-7*i)*x^2+(-4+14*i)*x+8-4*i)"
        '''
def crayon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Changes the color of the pencil (without parameter,returns the current color).
        Related: leve_crayon, baisse_crayon
        Examples:
         crayon vert;crayon(rouge);crayon(5);crayon(gomme)"
        '''
def createwav(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns an audio clip from data, optionally setting channel count, bit depth, sample rate, duration and normalization level.
        Usage: createwav(Lst(data),[opts])
        Related: readwav, writewav, playsnd
        Examples:
        createwav(duration=3.5);createwav(sin(2*pi*440*soundsec(2)),samplerate=48000);createwav(sin(2*pi*440*soundsec(2)),bit_depth=8);createwav(10*sin(2*pi*440*soundsec(2)),normalize=-3); t:=soundsec(3):;L,R:=sin(2*pi*440*t),sin(2*pi*445*t):;createwav([L,R])"
        '''
def cross(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Wedge product.
        Related: dot
        Examples:
        cross([1,2],[3,4]);cross([1,2,3],[4,5,6])"
        '''
def crossP(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Wedge product.
        Usage: crossP(Vect(v1),Vect(v2))
        Related: dot
        Examples:
        cross([1,2],[3,4]);cross([1,2,3],[4,5,6])"
        '''
def cross_correlation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the cross_correlation of two signals u and v.
        Usage: cross_correlation(cross_correlation(Lst(u),Lst(v)))
        Related: auto_correlation, correlation
        Examples:
        cross_correlation([1,2],[3,4,5])"
        '''
def cross_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command to display with color.
        Usage: lac(Opt)
        Related: display
        Examples:
         F:=display(point(2+1.5*i),red); F:=display(point(2+1.5*i),point_point+green)"
        '''
def cross_ratio(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the complex number equal to ((c-a)/(c-b))/((d-a)/(d-b)).
        Related: harmonic_conjugate, is_conjugate
        Examples:
        cross_ratio(i,2+i,3/2+i,3+i);cross_ratio(0,1+i,1,i);cross_ratio(0,1,2,3)"
        '''
def crossproduct(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Wedge product.
        Usage: crossproduct(Vect(v1),Vect(v2))
        Related: dot
        Examples:
        cross([1,2],[3,4]);cross([1,2,3],[4,5,6])"
        '''
def csc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Cosecant: csc(x)=1/sin(x).
        Related: sin, acsc
        Examples:
        csc(pi/2)"
        '''
def csolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of complex solutions of an equation or a matrix where the rows are ℂ-solutions of a system of polynomial equations.
        Related: cZeros, solve, fslove
        Examples:
        csolve(x^4-1,x);csolve(x^4-y^4 and x+y=2,[x,y]);csolve(x^4-y^4 and x+y=0 and x^2=2*x,[x,y]);csolve(u*v-u=v and v^2=u,[u,v])"
        '''
def csv2gen(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Reads a file (or string) in CSV format
        Usage: csv2gen(Strng(filename),Strng(sep),Strng(nl),Strng(decsep),Strng(eof),[string])
        Related: read
        Examples:
        csv2gen(""mat.txt"","","",char(10),""."")"
        '''
def cube(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the direct cube with vertices A,B with a face in the plan (A,B,C).
        Related: parallelepiped, cylinder, icosahedron, dodecahedron, octahedron, tetrahedron, centered_cube
        Examples:
        cube([0,0,0],[1,0,0],[0,1,0]); c:=cube([0,0,0],[1,0,0],[0,1,0]);A,B,C,D,E,F,G,H:=sommets(c); ; A,B,K:=point(1,0,0),point(1,1,0),point(0,2,0);c:=cube(A,B,C);A,B,C,D,E,F,G,H:=sommets(c); ; c:=cube([0,0,0],[1,0,0],[0,1,0]);c1,c2,c4,c3,c5,c6,c7,c8:=sommets(c); ; c:=cube([0,0,0],[0,2,0],[0,0,1]);c1,c2,c4,c3,c5,c6,c7,c8:=sommets(c); "
        '''
def cumSum(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list (or the sequence or the string) lr where the elements are the cumulative sum of the list l: lr[k]=sum(l[j],j=0..k) (or lr=sum(l[j],j=0..k)$(k=0..size(l)-1)).
        Related: sum
        Examples:
        cumSum([0,1,2,3,4]);cumSum(1.2,3,4.5,6);cumSum(""a"",""b"",""c"",""d"")"
        '''
def cumsum(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list (or the sequence or the string) lr where the elements are the cumulative sum of the list l: lr[k]=sum(l[j],j=0..k) (or lr=sum(l[j],j=0..k)$(k=0..size(l)-1)).
        Usage: cumsum(Lst(l)||Seq||Str)
        Related: sum
        Examples:
        cumSum([0,1,2,3,4]);cumSum(1.2,3,4.5,6);cumSum(""a"",""b"",""c"",""d"")"
        '''
def cumulated_frequencies(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the diagram of the cumulated frequencies (rows=[value,frequencies])
        Related: histogram, classes, bar_plot
        Examples:
        cumulated_frequencies([1,2,1,1,2,1,2,4,3,3]);cumulated_frequencies([(rand(6)+1)$(k=1..100)]);cumulated_frequencies([[1,0.3],[2,0.5],[3,0.2]]);cumulated_frequencies([[1..2,0.3],[2..3,0.5],[3..4,0.2]]);cumulated_frequencies([[1..2,0.3,0.5],[2..3,0.5,0.2],[3..4,0.2,0.3]])"
        '''
def curl(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: curl([A,B,C],[x,y,z])=[dC/dy-dB/dz,dA/dz-dC/dx,dB/dx-dA/dy].
        Related: derive, divergence
        Examples:
        curl([2*x*y,x*z,y*z],[x,y,z])"
        '''
def current_sheet(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Content of the matrix editor or spreadsheet.
        Examples:
        current_sheet(1,2);current_sheet(A1..A5,B,G)"
        '''
def curvature(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Curvature of curve C at point M.
        Related: osculating_circle, evolute
        Examples:
        curvature(plot(x^2),point(1,1));curvature([5*cos(t),5*sin(t)],t);curvature([t,t^2],t);curvature([t,t^2],t,1);curvature([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t);curvature([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t,7); trigcos(curvature([2*cos(t),2*sin(t),3*t],t))"
        '''
def curve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Reserved word.
        "
        '''
def cyan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command to display with color.
        Usage: ya(Opt)
        Related: display
        Examples:
         F:=display(point(2+1.5*i),red); F:=display(point(2+1.5*i),point_point+green)"
        '''
def cycle2perm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Converts the cycle c to a permutation.
        Related: cycles2permu, permu2cycles
        Examples:
        cycle2perm([1,3,5])"
        '''
def cycle_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a cyclic graph with n vertices (or with vertices from list V).
        Usage: cycle_graph(Intg(n)||Lst(V))
        Related: graph, path_graph
        Examples:
        cycle_graph(4);cycle_graph([""one"",""two"",""three"",""four"",""five""])"
        '''
def cycleinv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the inverse cycle of the cycle c.
        Related: perminv
        Examples:
        cycleinv([1,3,5])"
        '''
def cycles2permu(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Converts a product of cycles into a permutation.
        Related: permu2cycles, cycle2perm
        Examples:
        cycles2permu([[1,3,5],[3,4]])"
        '''
def cyclotomic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: N-th cyclotomic polynomial.
        Related: none
        Examples:
        cyclotomic(20)"
        '''
def cylinder(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a cylinder with axis (A,v), with radius r [and with altitude h].
        Related: half_cone, cone
        Examples:
        cylinder([0,0,0],[0,1,0],2);cylinder([0,0,0],[0,1,0],2,-3)"
        '''
def dash_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def dashdot_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ashdot_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def dashdotdot_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ashdotdot_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def dayofweek(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: dayofweek(d,m,y) returns the day of the given date (day,month,year) : 0 for sunday, 1 for monday ...6 for saturday.
        Usage: dayofweek(Int,Int,Int)
        Examples:
        dayofweek(21,4,2014);dayofweek(15,10,1582)"
        '''
def deSolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Solves a differential equation or a differential linear system with constant coefficients.
        Usage: eSolv(Eq,[TimeVar],FncVar)
        Related: integrate, diff, odesolve, plotode, plotfiefd
        Examples:
        desolve(y'+x*y=0);desolve(y'+x*y=0,y);desolve(y'+x*y=0,[0,1]);desolve([y'+x*y=0,y(0)=1],y);desolve([y'=[[1,2],[2,1]]*y+[x,x+1],y(0)=[1,2]]) ;desolve(y''+y=0,y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],x,y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],[x,y]);desolve(diff(y(t),t)+t*y(t)=0,t,y);desolve(diff(y(t),t)+t*y(t)=0,[t,y]);desolve((y''+y=sin(x)) and (y(0)=1) and (y'(0)=2),y);desolve([z''+2*z'+z,z(0)=1,z'(0)=0],u,z);desolve([z''+2*z'+z,z(0)=1,z'(0)=0],z(u));desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],t,z);desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],z(t))"
        '''
def debut_enregistrement(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Marks the beginning of the recording of the commands making up the drawing whose name is the argument.
        Related: fin_enregistrement
        Examples:
        debut_enregistrement(maison);debut_enregistrement(arbre)"
        '''
def degree(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Degree of the polynomial P with respect to the second argument.
        Related: valuation, size, total_degree
        Examples:
        degree(x^3+x);degree([1,0,1,0]);degree(x^3+x*y,y)"
        '''
def degree_sequence(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of degrees of vertices of G (arc directions are ignored).
        Usage: degree_sequence(Graph(G))
        Related: is_graphic_sequence, is_regular, sequence_graph, vertex_degree
        Examples:
        degree_sequence(graph(trail(1,2,3,4,2)))"
        '''
def delcols(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix where the columns n1..n2 (or n1) of the matrix A are deleted.
        Related: delrows
        Examples:
        delcols([[1,2,3],[4,5,6],[7,8,9]],1..1);delcols([[1,2,3],[4,5,6],[7,8,9]],0..1);delcols([[1,2,3],[4,5,6],[7,8,9]],1)"
        '''
def delete_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of digraph G with arc e (or trail T or list of arcs E). removed.
        Usage: delete_arc(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Related: add_arc, delete_edge, digraph, edges, has_arc, trail
        Examples:
        delete_arc(digraph(trail(1,2,3,4,5,1)),[5,1])"
        '''
def delete_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of undirected graph G with edge e (or trail T or list of edges E) removed.
        Usage: delete_edge(Graph(G),Edge(e)||Trail(T)||Lst(E))
        Related: add_edge, delete_arc, edges, graph, has_edge, trail
        Examples:
        delete_edge(cycle_graph(4),[1,2])"
        '''
def delete_vertex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a modified copy of G with vertex v (or vertices from V) removed.
        Usage: delete_vertex(Graph(G),Vrtx(v)||Lst(V))
        Related: add_vertex, induced_subgraph
        Examples:
        delete_vertex(cycle_graph(5),[1,4])"
        '''
def delrows(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix where the rows n1..n2 (or n1) of the matrix A are deleted.
        Related: delcols
        Examples:
        delrows([[1,2,3],[4,5,6],[7,8,9]],1..1);delrows([[1,2,3],[4,5,6],[7,8,9]],0..1);delrows([[1,2,3],[4,5,6],[7,8,9]],1)"
        '''
def deltalist(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of the difference of two terms in succession.
        Examples:
        deltalist([1,4,8,9]);deltalist([1,8,4,9])"
        '''
def denom(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the denominator of the simplified fraction.
        Related: getDenom, getNum, numer, f2nd
        Examples:
        denom(25/15);denom((x^3-1)/(x^2-1));denom(1+(x^3-1)/x^2)"
        '''
def densityplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Shows in the plan with colors the graph of a expression of 2 variables.
        Usage: densityplot(Expr,[x=xrange,y=yrange],[z],[xstep],[ystep])
        Related: plotfunc, plotcontour
        Examples:
        plotdensity(x^2-y^2,[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1);plotdensity(x^2-y^2,[x=-2..2,y=-2..2],z=-2..2,xstep=0.1,ystep=0.1)"
        '''
def departures(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of vertices of digraph G which are connected by v with arcs such that tails are in v. If v is omitted, list of departures is computed for every vertex in G.
        Usage: departures(Graph(G),[Vrtx(v)])
        Related: out_degree
        Examples:
        departures(digraph(%{[1,2],[1,3],[2,3]%}),1)"
        '''
def derive(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the derivative with respect to the 2nd argument.
        Related: ', function_diff, integrate, taux_accroissement, implicitdiff
        Examples:
        diff(x^3-x);diff(x^3-x,x,3);diff(x^3-x,quote(x)$3);(diff@@3)('x^3-x');diff(x*y+z*y,y);diff(x*y+z*y,y,z);diff(x*y+z*y,[y,z]); f(x):=sin(2x);g:=diff(f);h:=diff(diff(f))"
        '''
def deriver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the derivative with respect to the 2nd argument.
        Usage: deriver(Expr or Fnc,[SeqVar or LstVar])
        Related: ', function_diff, integrate, taux_accroissement, implicitdiff
        Examples:
        diff(x^3-x);diff(x^3-x,x,3);diff(x^3-x,quote(x)$3);(diff@@3)('x^3-x');diff(x*y+z*y,y);diff(x*y+z*y,y,z);diff(x*y+z*y,[y,z]); f(x):=sin(2x);g:=diff(f);h:=diff(diff(f))"
        '''
def desolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Solves a differential equation or a differential linear system with constant coefficients.
        Related: integrate, diff, odesolve, plotode, plotfiefd
        Examples:
        desolve(y'+x*y=0);desolve(y'+x*y=0,y);desolve(y'+x*y=0,[0,1]);desolve([y'+x*y=0,y(0)=1],y);desolve([y'=[[1,2],[2,1]]*y+[x,x+1],y(0)=[1,2]]) ;desolve(y''+y=0,y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],x,y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],[x,y]);desolve(diff(y(t),t)+t*y(t)=0,t,y);desolve(diff(y(t),t)+t*y(t)=0,[t,y]);desolve((y''+y=sin(x)) and (y(0)=1) and (y'(0)=2),y);desolve([z''+2*z'+z,z(0)=1,z'(0)=0],u,z);desolve([z''+2*z'+z,z(0)=1,z'(0)=0],z(u));desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],t,z);desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],z(t))"
        '''
def dessine_tortue(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the full (or not full if n=1) triangle representing the turtle.
        Related: crayon
        Examples:
        dessine_tortue();dessine_tortue(0);dessine_tortue(1)"
        '''
def det(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Determinant of a square matrix M.
        Related: rref, det_minor, Det
        Examples:
        det([[1,2],[3,4]]);det([[1,2,3],[1,3,6],[2,5,7]])"
        '''
def det_minor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the determinant calculated with the calculus of minors.
        Related: det
        Examples:
        det_minor([[1,2],[3,4]])"
        '''
def developper(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Full distribution of * and / over + and -
        Usage: developper(Expr)
        Related: texpand, normal, simplify, ratnormal
        Examples:
        expand((x+y)*(z+1));expand((a+b+c)/d);expand((y+x)*(z+y)*(x+z));expand((x+3)^4);expand((2*x-2*1)*(x^2-3*x+2)+(x^2-2*x+3)*(2*x-3*1))"
        '''
def developper_transcendant(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Expand transcendental expressions.
        Usage: developper_transcendant(Expr)
        Related: tcollect, tlin, lin, trigexpand
        Examples:
        texpand(sin(2*x)+exp(x+y));texpand(cos(x+y));texpand(cos(3*x))"
        '''
def dfc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the continue fraction development of x0 of order n or with precision eps.
        Related: dfc2f, convert
        Examples:
        dfc(sqrt(2),5);dfc(pi,4);dfc(evalf(pi),1e-09); convert(sqrt(2),confrac,'dev');dev; convert(9976/6961,confrac,'l');l"
        '''
def dfc2f(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Converts a continue fraction into a real.
        Related: dfc, convert
        Examples:
        dfc2f([1,1,1]);dfc2f([1,2,[2]])"
        '''
def diag(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: With 1 argument returns either the diagonal matrix with diagonal l or the diagonal of A, with 2 arguments returns the large left part of A or the large right part of A or cuts A into 3 parts : strict left,diagonal,strict right  and with 3 arguments returns the tridiagonale matrix with diagonals l,d,u.
        Related: identity, lu, BlockDiagonal, upper, lower
        Examples:
        diag([[1,2],[3,4]]);diag([1,2,3]);diag([[1,2],[3,4]],left);diag([[1,2],[3,4]],right);diag([[1,2],[3,4]],lu);diag([1,2],[3,4,5],[6,7])"
        '''
def diff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the derivative with respect to the 2nd argument.
        Related: ', function_diff, integrate, taux_accroissement, implicitdiff
        Examples:
        diff(x^3-x);diff(x^3-x,x,3);diff(x^3-x,quote(x)$3);(diff@@3)('x^3-x');diff(x*y+z*y,y);diff(x*y+z*y,y,z);diff(x*y+z*y,[y,z]); f(x):=sin(2x);g:=diff(f);h:=diff(diff(f))"
        '''
def digraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Create a directed (un)weighted graph from vertices V, edges E and/or adjacency or weight matrix A. All parameters are optional.
        Usage: digraph([Lst(V)],[Set(E)],[Mtrx(A)],[options])
        Related: graph, trail
        Examples:
        digraph(%{[1,2],[2,3],[3,4],[4,1]%});digraph([a,b,c,d],%{[[a,b],1.0],[[a,c],2.3],[[b,d],3.1],[[c,d],4]%})"
        '''
def dijkstra(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the cheapest weighted path from vertex v to w (or to vertices from W) in undirected graph G. Output is in form [[v1,v2,...,vk],d] (or list of these) where v1,v2,...,vk are vertices along each path and d is the weight of the path.
        Usage: dijkstra(Graph(G),Vrtx(v),[Vrtx(w)||Lst(W)])
        Related: allpairs_distance, shortest_path
        Examples:
        dijkstra(graph(%{[[1,2],1],[[2,3],3],[[3,4],7],[[4,5],3],[[5,6],3],[[1,6],3]%}),1,4)"
        '''
def dim(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list which gives the dimension of the matrix specified as argument.
        Related: rowdim, coldim, sizes, size
        Examples:
        dim([[1,2,3],[4,5,6]])"
        '''
def directed(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option for graph and digraph commands.
        Usage: irecte(Opt)
        Related: weighted, graph, digraph
        "
        '''
def discard_edge_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Discards the attributes with tags tag1, tag2, ... assigned to edge e in G and returns the modified copy of G.
        Usage: discard_edge_attribute(Graph(G),Edge(e),Seq(tag1=value1,tag2=value2,..))
        Related: get_edge_attribute, set_edge_attribute, list_edge_attributes
        Examples:
        discard_edge_attribute(cycle_graph(3),[1,2],""cost"")"
        '''
def discard_graph_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Discards the graph attributes with tags tag1, tag2, ... and returns the modified copy of G.
        Usage: discard_graph_attribute(Graph(G),Seq(tag1=value1,tag2=value2,..))
        Related: get_graph_attribute, set_graph_attribute, list_graph_attributes
        Examples:
        discard_graph_attribute(cycle_graph(3),""name"")"
        '''
def discard_vertex_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Discards the attributes with tags tag1, tag2, ... assigned to vertex v in G and returns the modified copy of G.
        Usage: discard_vertex_attribute(Graph(G),Vrtx(v),Seq(tag1=value1,tag2=value2,..))
        Related: get_vertex_attribute, set_vertex_attribute, list_vertex_attributes
        Examples:
        discard_vertex_attribute(cycle_graph(3),1,""supply"")"
        '''
def disjoint_union(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the disjoint union of the graphs G1, G2, ... Vertices in the resulting graph are labelled with ""k:v"", where k is index of the corresponding k-th graph Gk and v is vertex in Gk.
        Usage: disjoint_union(Seq(G1,G2,...))
        Related: graph_join, graph_union
        Examples:
        is_connected(disjoint_union(cycle_graph(5),path_graph(4)))"
        '''
def display(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws an geometrical object with colors black=0 red=1 green=2 yellow=3 blue=4, filled put the color in the interior of a closed curve,line_width_n (0<n<8) is for the width of the line and dash_line is for dotted line.
        Related: -<, legende
        Examples:
        display(A,1);display(F:=point(2+1.5*i),2);display(point(2+1.5*i),2);display(legende(1+i,""abc""),4);display(square(0,1),filled+red);display(carre(0,1),rempli+rouge);display(circle(0,1),filled);display(line(y=x),green+dash_line+line_width_2);display(red);square(0,1);;display(red+filled);square(0,1);"
        '''
def disque(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a disk with radius r (resp a sector of angle (0,a) or (a,b)), tangent at the turtle position.
        Related: rond
        Examples:
         disque 30;disque(40);disque(40,90);disque(40,10,100)"
        '''
def disque_centre(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a disk with radius r (resp a sector of angle (0,a) or (a,b)) with center the turtle position.
        Related: rond
        Examples:
         disque_centre 30;disque_centre(40);disque_centre(40,90);disque_centre(40,10,100)"
        '''
def distance(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Calculates the distance between 2 points or a point and a curve.
        Related: distance2, distanceat, distanceatraw
        Examples:
        distance(point(0),point(1+i));distance(1+i,segment(1-i,i));distance(0,1+i)"
        '''
def distance2(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Calculates the square of the distance between 2 points or a point and a curve.
        Related: distance
        Examples:
        distance2(point(0),point(1+i));distance2(1+i,segment(1-i,i));distance2(0,1+i)"
        '''
def distanceat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: distanceat(A,B,z0) displays at point(z0), with a legend, the distance between 2 geometrical objects
        Related: distance, distanceatraw
        Examples:
         A:=point(0);B:=point(1+i);distanceat(A,B,(1+i)/2); A:=point(0);s:=segment(1-i,i);distanceat(A,s,1)"
        '''
def distanceatraw(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: distanceatraw(A,B,z0) displays at the point(z0), the distance between 2 geometrical objects.
        Related: distance, distanceat
        Examples:
         A:=point(0);B:=point(1+i);distanceatraw(A,B,(1+i)/2); A:=point(0);s:=segment(1-i,i);distanceatraw(A,s,1)"
        '''
def divergence(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: divergence([A,B,C],[x,y,z])=dA/dx+dB/dy+dC/dz.
        Related: derive, curl
        Examples:
        divergence([x^2+y,x+z+y,z^3+x^2],[x,y,z])"
        '''
def divide(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euclidean quotient and remainder of 2 polynomials.
        Usage: divide((Vect or Poly),(Vect or Poly),[Var])
        Related: rem, quo, iquorem
        Examples:
        quorem([1,2,3,4],[-1,2]);quorem(x^3+2x^2+3x+4,-x+2);quorem(t^3+2t^2+3t+4,-t+2,t);quorem(t^4-1,(t+1)^2,t)"
        '''
def divis(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of divisors of a polynomial.
        Related: idivis, factors, poly2symb
        Examples:
        divis(x^2-1);divis(x^4-1);divis(t^4-1);divis([x^4-1,x^2-1]);divis([x^4-1,t^2-1]);divis(poly2symb([1,0,0,0,-1],x))"
        '''
def division_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the point M such that (z-a)=k*(z-b) and z=affix of M (MA=k*MB).
        Related: harmonic_conjugate, is_conjugate
        Examples:
        division_point(i,2+i,3+i);division_point(i,2+i,3)"
        '''
def divisors(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of divisors of an integer.
        Usage: divisors(Intg(a) or LstIntg)
        Related: divis, ifactors
        Examples:
        idivis(36);idivis([36,49])"
        '''
def divmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euclidean quotient and remainder of 2 integers.
        Usage: divmod(Intg(a),Intg(b))
        Related: irem, iquo, quorem
        Examples:
        iquorem(125,15);iquorem(125,41);iquorem(25+12*i,5+7*i)"
        '''
def divpc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: n-degree Taylor-poly for the quotient of 2 polynomials.
        Related: series, quorem
        Examples:
        divpc(x^4+x+2,x^2+1,5)"
        '''
def dnewton_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving a system of numerical equations.
        Related: fsolve
        Examples:
         fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)"
        '''
def dodecahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a dodecahedron with center A, vertex B and such that the plane ABC contains a symmetry axis of the dodecahedron.
        Related: icosahedron, octahedron, cube, tetrahedron
        Examples:
        dodecahedron([0,0,0],[0,2,sqrt(5)/2+3/2],[0,0,1]);dodecahedron(evalf([0,0,0],[3,2,4],[1,1,0]))"
        '''
def domain(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the definition domain of an expression.
        Usage: domain(Expr)
        Examples:
        domain(log(x+1));domain(log(x)+asin(x))"
        '''
def dot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Scalar product.
        Related: *, cross, .*, hadamard
        Examples:
        dot([1,2],[3,4]);dot([3,2,4],[3,2,4]);dot([[1,2],[3,4]],[[3,2],[4,5]])"
        '''
def dotP(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Scalar product.
        Usage: dotP(Vect(v1),Vect(v2))
        Related: *, cross, .*, hadamard
        Examples:
        dot([1,2],[3,4]);dot([3,2,4],[3,2,4]);dot([[1,2],[3,4]],[[3,2],[4,5]])"
        '''
def dot_paper(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws in the rectangle [xmin..xmax]*[ymin..ymax], the apex of the network built with the lines y=n*uy and in the axes OxY of angle t!=0 with the lines x=n*ux.
        Examples:
        dot_paper(1,pi/3,sqrt(3)/2);dot_paper(1,pi/3,sqrt(3)/2,x=-1..4,y=-2..2);dot_paper(0.5,3*pi/4,0.5)"
        '''
def dotprod(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Scalar product.
        Usage: dotprod(Vect(v1),Vect(v2))
        Related: *, cross, .*, hadamard
        Examples:
        dot([1,2],[3,4]);dot([3,2,4],[3,2,4]);dot([[1,2],[3,4]],[[3,2],[4,5]])"
        '''
def draw_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pixelised ellipsis arc
        Usage: draw_arc(Intg(x),Intg(y),Intg(rx),Intg(ry),Real(theta1),Real(theta2),Intg(col))
        Related: draw_pixel, draw_circle
        Examples:
         clear(); draw_arc(100,80,40,20,0,pi,blue); show_pixels();"
        '''
def draw_circle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pixelised circle, add filled to the color to fill the circle
        Usage: draw_circle(Intg(x),Intg(y),Intg(r),Intg(col))
        Related: draw_pixel, draw_arc
        Examples:
        draw_circle(100,60,20,blue);; clear(); draw_circle(100,60,20,blue+filled); show_pixels();"
        '''
def draw_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graphic representation of G obtained by using various algorithms (which can optionally be fine tuned by appending a sequence of options after the first argument).
        Usage: draw_graph(Graph(G),[opts])
        Related: highlight_edges, highlight_subgraph, highlight_trail, highlight_vertex, set_vertex_positions, get_vertex_positions
        Examples:
        draw_graph(graph(""petersen""));draw_graph(graph(""petersen""),spring);draw_graph(random_tree(30));draw_graph(sierpinski_graph(5,3,at_triangle));draw_graph(graph(""soccerball""))"
        '''
def draw_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pixelised segment
        Usage: draw_line(Intg(x1),Intg(y1),Intg(x2),Intg(y2),Intg(col))
        Related: draw_pixel, draw_rectangle, draw_polygon
        Examples:
        draw_line(10,10,60,60,blue);"
        '''
def draw_pixel(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pixel on and adds to the list of pixel. Run show_pixels() to display
        Usage: draw_pixel(Intg(x),Intg(y),Intg(col))
        Related: clear, show_pixels, draw_line, draw_rectangle, draw_polygon
        Examples:
         clear(); draw_pixel(1,2,red); show_pixels();"
        '''
def draw_polygon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pixelised polygon, add filled to the color to fill the rectangle
        Usage: draw_polygon(Lst(l),Intg(col))
        Related: draw_pixel, draw_line, draw_rectangle
        Examples:
        draw_polygon([[50,30],[100,10],[20,70]],red); show_pixels();; clear(); draw_polygon([[50,30],[100,10],[20,70]],red+filled); show_pixels();"
        '''
def draw_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pixelised rectangle, add filled to the color to fill the rectangle
        Usage: draw_rectangle(Intg(x),Intg(y),Intg(w),Intg(h),Intg(col))
        Related: draw_pixel, draw_line, draw_polygon
        Examples:
        draw_rectangle(10,20,30,40,red);; clear(); draw_rectangle(10,20,30,40,red+filled); show_pixels();"
        '''
def droit(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the right part of an equality, of an interval, of a list or of a string.
        Usage: droit(Equal(a=b) or Interval(a..b) or Str,Intg)
        Related: left, mid, tail, head
        Examples:
        right(a=b);right(x^2+1=5);right(1..5);right(""abcdefg"",3)"
        '''
def droite_tangente(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the tangent to y=f(x) at x=a.
        Related: tangent, LineTan
        Examples:
        droite_tangente(sin(x),pi/4);droite_tangente(sin(t),t=pi/4);droite_tangente(sin(t),t,pi/4);droite_tangente(x^2-x,1)"
        '''
def dsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Solves a differential equation or a differential linear system with constant coefficients.
        Usage: dsolve(Eq,[TimeVar],FncVar)
        Related: integrate, diff, odesolve, plotode, plotfiefd
        Examples:
        desolve(y'+x*y=0);desolve(y'+x*y=0,y);desolve(y'+x*y=0,[0,1]);desolve([y'+x*y=0,y(0)=1],y);desolve([y'=[[1,2],[2,1]]*y+[x,x+1],y(0)=[1,2]]) ;desolve(y''+y=0,y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],x,y);desolve([y''+y=sin(x),y(0)=1,y'(0)=2],[x,y]);desolve(diff(y(t),t)+t*y(t)=0,t,y);desolve(diff(y(t),t)+t*y(t)=0,[t,y]);desolve((y''+y=sin(x)) and (y(0)=1) and (y'(0)=2),y);desolve([z''+2*z'+z,z(0)=1,z'(0)=0],u,z);desolve([z''+2*z'+z,z(0)=1,z'(0)=0],z(u));desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],t,z);desolve([z'=[[1,2],[2,1]]*z+[t,t+1],z(0)=[1,2]],z(t))"
        '''
def duration(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the duration of an audio clip, in seconds.
        Usage: duration(Lst(clip))
        Related: bit_depth, channels, channel_data, samplerate
        Examples:
        duration(readwav(""/some/file""))"
        '''
def e2r(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the coefficients of a polynomial with respect to the 2nd argument or if the second argument is a list the internal format of the polynomial.
        Usage: e2r(Expr, LstVar or [Var])
        Related: poly2symb, r2e
        Examples:
        symb2poly(x*3+2.1);symb2poly(3*x*y+2*y+1,y);symb2poly(3*x*y+2*y+1,x,y);symb2poly(3*x*y+2*y+1,[x,y]);symb2poly(-x^4+x*3*y+2+y^2*z,[x,y,z]);symb2poly(-x^4+x*3*y+2+y^2*z,[x,y,z])"
        '''
def ecart_type(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the standard deviation of the elements of its argument with an optional second argument as pound or the list of standard deviation of the columns of a matrix.
        Usage: ecart_type(Lst||Mtrx,[Lst])
        Related: mean, variance, stddevp
        Examples:
        stddev([1,2,3]);stddev([1,2,3],[1,2,1]);stddev([[1,2,3],[5,6,7]])"
        '''
def ecart_type_population(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns an unbiaised estimate of the population standard deviation of the sample (first argument) with an optional list of pounds as second argument.
        Usage: ecart_type_population(Lst||Mtrx,[Lst])
        Related: mean, stddev
        Examples:
        stddevp([1,2,3]);stddevp([1,2,3],[1,2,1]);stddevp([[1,2,3],[5,6,7]])"
        '''
def ecm_factor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorization of integer n by the Elliptic Curve Method algorithm, B1 smoothness optional parameter
        Usage: ecm_factor(Intg(a),[Intg(B1)])
        Examples:
        ecm_factor(1000000000000000003000000000000000000000000000000000031000000000000000093)"
        '''
def edge_connectivity(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the largest integer k for which G is k-edge connected, meaning that G remains connected after fewer than k edges are removed.
        Usage: edge_connectivity(graph(G))
        Related: is_two_edge_connected, is_edge_cut, vertex_connectivity
        Examples:
        edge_connectivity(graph(""petersen""));edge_connectivity(graph(""clebsch""));edge_connectivity(complete_graph(5))"
        '''
def edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return the list of edges in G [including weights].
        Usage: edges(Graph(G),[weights])
        Related: add_edge, incident_edges, set_edge_weight, get_edge_weight
        Examples:
        edges(complete_graph(4))"
        '''
def egcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extended greatest common divisor of 2 polynomials.
        Related: gcd, iegcd
        Examples:
        egcd((x-1)^2,x^3-1);egcd((X-1)^2,X^3-1,X);egcd([1,-2,1],[1,0,0,-1]);egcd([1,-2,1],[1,-1,2])"
        '''
def egv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Computes the eigenvectors of a diagonalizable matrix.
        Related: egvl, jordan
        Examples:
        egv([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);egv([[1,1,3],[1,3,1],[3,1,1]])"
        '''
def egvl(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Jordan matrix associated to A when the eigenvalues are calculable.
        Related: egv, jordan
        Examples:
        egvl([[4,1],[-4,0]]);egvl([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);egvl([[1,1,3],[1,3,1],[3,1,1]])"
        '''
def eigVc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Computes the eigenvectors of a diagonalizable matrix.
        Usage: eigVc(Mtrx)
        Related: egvl, jordan
        Examples:
        egv([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);egv([[1,1,3],[1,3,1],[3,1,1]])"
        '''
def eigVl(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Jordan matrix associated to A when the eigenvalues are calculable.
        Usage: eigVl(Mtrx(A))
        Related: egv, jordan
        Examples:
        egvl([[4,1],[-4,0]]);egvl([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);egvl([[1,1,3],[1,3,1],[3,1,1]])"
        '''
def eigenvals(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the sequence of the (calculable) eigenvalues of a matrix.
        Related: egv, jordan
        Examples:
        eigenvals([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);eigenvals([[1,1,3],[1,3,1],[3,1,1]]);eigenvals([[4,1],[-4,0]])"
        '''
def eigenvalues(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the sequence of the (calculable) eigenvalues of a matrix.
        Usage: eigenvalues(Mtrx)
        Related: egv, jordan
        Examples:
        eigenvals([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);eigenvals([[1,1,3],[1,3,1],[3,1,1]]);eigenvals([[4,1],[-4,0]])"
        '''
def eigenvectors(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Computes the eigenvectors of a diagonalizable matrix.
        Usage: eigenvectors(Mtrx)
        Related: egvl, jordan
        Examples:
        egv([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);egv([[1,1,3],[1,3,1],[3,1,1]])"
        '''
def eigenvects(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Computes the eigenvectors of a diagonalizable matrix.
        Usage: eigenvects(Mtrx)
        Related: egvl, jordan
        Examples:
        egv([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);egv([[1,1,3],[1,3,1],[3,1,1]])"
        '''
def element(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Shows a point chosen on a curve or a real chosen in an interval
        Related: is_element
        Examples:
         t:=element(0..1); t:=element(0..1,0.3); t:=element(0..1,0.3,0.02); P:=element(circle(i,1),t); M:=element(circle(i,1)); N:=element(circle(i,1),pi/2)"
        '''
def eliminate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Eliminates the variables vars in a list of algebraic equations
        Examples:
        eliminate([x=v0*t,y=y0-g*t^2],t);eliminate([x+y+z+t-2,x*y*t=1,x^2+t^2=z^2],[x,z])"
        '''
def ellipse(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: ellipse(F1,F2,M)=ellipse focus F1,F2 through M or such as MF1+MF2=2*a (geo2d) and ellipse(p(x,y)) draws the conic if deg(p)=2.
        Related: hyperbola, parabola
        Examples:
        ellipse(-1,1,point(1+i));ellipse(-1,1,1+sqrt(5));ellipse(2x^2+3y^2-x*y-10);ellipse(point(-1,0,0),point(1,0,0),point(1,1,1));ellipse(x^2+2y^2-y-2)"
        '''
def entry(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n+1-th question of the command history if n>=0 or, the (-n)th previous question if n<0 (by defaults n=-1 for the previous question).
        Usage: entry(Intg(n))
        Related: ans
        Examples:
        quest();quest(2);quest(-2)"
        '''
def envelope(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the envelope of the curves with equation Xpr=0, when t move.
        Related: tangent, locus
        Examples:
        envelope(y+x*tan(t)-2*sin(t),t);envelope(v+u*tan(t)-3*sin(t),[u,v,t])"
        '''
def epsilon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value of epsilon of the CAS configuration.
        Related:  epsilon2zero
        Examples:
        epsilon()"
        '''
def epsilon2zero(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Values < epsilon are replaced by zero
        Related: evalf
        Examples:
        epsilon2zero(1e-13+x+5)"
        '''
def equal(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Infixed symbol that connects the 2 members of an equation.
        Related: equal, equal2diff, equal2list, left, right
        Examples:
         x+4=2; x^2-3x+2=0; equal(x+4,2)"
        '''
def equal2diff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: A=B or equal(A,B) is converted into the difference A-B
        Related: left, right, equal2list, equal, =
        Examples:
        equal2diff(x=2);equal2diff(equal(x,2))"
        '''
def equal2list(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: A=B or equal(A,B)is converted into the list [A,B]
        Related: left, right, equal2diff, equal, =
        Examples:
        equal2list(x=2);equal2list(equal(x,2))"
        '''
def equation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: equation returns the cartesian equation of a curve
        Related: parameq
        Examples:
        equation(line(1-i,i),[x,y])"
        '''
def equilateral_triangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: equilateral_triangle(A,B) (resp equilateral_triangle(A,B,P)) draws the direct equilateral triangle ABC of side AB (resp in the half-plane ABP).
        Related: triangle
        Examples:
        equilateral_triangle(point(1+i),0);equilateral_triangle(0,1+i,C);equilateral_triangle(point(0,0,0),point(3,3,3),point(0,0,3));equilateral_triangle(point(0,0,0),point(3,3,3),point(0,0,3),C)"
        '''
def erf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the approximate value of 2/sqrt(pi)*int(exp(-t^2),t,0,x0).
        Related: erfc
        Examples:
        erf(1);erf(1/(sqrt(2)))*1/2"
        '''
def erfc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the approximate value of 2/sqrt(pi)*int(exp(-t^2),t,x0,+infinity).
        Related: erf
        Examples:
        erfc(1);erfc(1/(sqrt(2)))*1/2"
        '''
def error(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Generates the display of an error in a program
        Usage: hro(Str)
        Related: try, catch
        Examples:
        error(""Argument should be integer"");error(""je provoque une erreur"")"
        '''
def est_permu(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the argument is a permutation and 0 otherwise
        Usage: st_perm(Lst)
        Related: is_cycle, permu2cycles
        Examples:
        is_permu([4,2,3,1]);is_permu([4,2,3,1,0])"
        '''
def euler(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euler's function (euler(n)=card({p<n,gcd(n,p)=1})).
        Related: gcd
        Examples:
        euler(11);euler(6)"
        '''
def euler_gamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euler's constant=euler_gamma=limit(sum(1/k,k,1,n)-ln(n),n,+infinity).
        Examples:
         evalf(euler_gamma)"
        '''
def euler_lagrange(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the (system of) Euler-Lagrange equation(s) for the functional F=int(f,x=a..b).
        Usage: euler_lagrange(Expr(f),[(Var(x),[Var||Lst(y)]) || y(x) || Lst(y(x))])
        Related: dsolve, bvpsolve, convex
        Examples:
        euler_lagrange(x^2*y'^2+y^2);euler_lagrange(sqrt(x'^2+y'^2),[x(t),y(t)]); assume(y>=0):; euler_lagrange(sqrt((1+y'^2)/y),t,y)"
        '''
def eval_level(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Evaluation level in interactive mode
        Examples:
        eval_level();eval_level(1); purge(a,b,c);eval_level(1);a:=b+1; b:=c+1;c:=3;; purge(a,b,c);eval_level(2);a:=b+1; b:=c+1;c:=3;; purge(a,b,c);eval_level(3);a:=b+1; b:=c+1;c:=3;"
        '''
def evala(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Simplify the expression.
        Usage: evala(Expr)
        Related: simplify
        Examples:
        normal(2*x+y=1);normal(2*x*2);normal((2*x+1)^2)"
        '''
def evalb(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Boolean evaluation of the argument
        Related: evalf, eval
        Examples:
        evalb(a==2);evalb(sqrt(2)+pi>a)"
        '''
def evalc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns an complex expression simplified with the format real+i*imag.
        Related: normal
        Examples:
        evalc(-3+4*i+exp(i));evalc(1/(x+y*i))"
        '''
def evalf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Numerical evaluation of the first argument (we can give the number of digits as second argument)
        Related: evalb, eval
        Examples:
        evalf(2/3);evalf(2/3,2);evalf(2*sin(1));evalf(2*sin(1),40);evalf(sqrt(2)+pi);evalf(sqrt(2)+pi,30)"
        '''
def evalm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Evaluates its argument.
        Usage: evalm(Expr)
        Related: evalf
        Examples:
        eval(2*sin(pi))"
        '''
def even(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the integer is even, else returns 0.
        Related: odd
        Examples:
        even(6);even(1251)"
        '''
def evolute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Evolute of a curve C.
        Related: curvature, osculating_circle
        Examples:
        evolute(plot(x^2));evolute([t,t^2],t);evolute([3*exp(t/2)*cos(t),3*exp(t/2)*sin(t)],t)"
        '''
def exact(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Converts the expression to a rational or real expression.
        Usage: exact(Expr)
        Examples:
        -2;float2rational(1.5);float2rational(1.4141);float2rational(0.156381102937)"
        '''
def exbisector(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the exterior bisector of the angle (AB,AC) given by 3 points A,B,C.
        Related: angle, bisector
        Examples:
        exbisector(0,1,i)"
        '''
def excircle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: excircle(A,B,C) draws the A-excircle of the ABC triangle.
        Related: incircle, circumcircle
        Examples:
        excircle(0,1,1+i)"
        '''
def execute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Instruction transforming a string into a command or into a number.
        Usage: execute(Str)
        Related: string
        Examples:
        expr(""ifactor(54)"");expr(""123"");expr(""0123"");expr(sin,x)"
        '''
def exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Exponential or Option of the convert or convertir command (id trig2exp).
        Related: ln, convert, trig2exp
        Examples:
        exp(0); convert(cos(x),exp)"
        '''
def exp2list(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list made with the right member of (var=expr0 or var=expr1), to be used after solve in TI mode.
        Related: list2exp
        Examples:
        exp2list((x=2) or (x=0));exp2list((x=3 and y=9) or (x=-1 and y=1) )"
        '''
def exp2pow(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Transforms exp(n*ln(x)) in x^n.
        Related: pow2exp
        Examples:
        exp2pow(exp(3*ln(x)));exp2pow(exp(x*ln(x)))"
        '''
def exp2trig(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Transforms the complex exponential into sine and cosine.
        Related: trig2exp, atrig2ln
        Examples:
        exp2trig(exp(i*x));exp2trig(exp(-i*x))"
        '''
def expand(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Full distribution of * and / over + and -
        Related: texpand, normal, simplify, ratnormal
        Examples:
        expand((x+y)*(z+1));expand((a+b+c)/d);expand((y+x)*(z+y)*(x+z));expand((x+3)^4);expand((2*x-2*1)*(x^2-3*x+2)+(x^2-2*x+3)*(2*x-3*1))"
        '''
def expexpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Expands exponentials.
        Related: texpand, lnexpand, trigexpand
        Examples:
        expexpand(exp(3*x))"
        '''
def expln(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the convert or convertir command (id trig2exp).
        Related: exp, ln, convert, trig2exp
        Examples:
         convert(cos(x),expln)"
        '''
def exponential(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability at x of the exponential law of parameter lambda.
        Related: exponential_cdf, exponential_icdf, randvector, ranm
        Examples:
        exponential(2.1,3.5);exponential(2.1,0.5); randvector(3,exponential,1.2); ranm(4,3,exponential,1.2)"
        '''
def exponential_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a exponential random variable of parameter lambda is lower than x0 (or between x0 and y0).
        Related: exponentiald, exponential_icdf
        Examples:
        exponential_cdf(4.2,2.1);exponential_cdf(4.2,2.1,3.2)"
        '''
def exponential_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a exponential random variable of parameter lambda is lower than h is p (0<=p<=1).
        Related: exponential_cdf, exponentiald
        Examples:
        exponential_icdf(4.2,0.95);exponential_icdf(4.2,0.6)"
        '''
def exponential_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the coefficients (a,b) of y=b*a^x : it is the best exponential which approx the points where the coordinates are the rows of A (or the 2 lists).
        Related: logarithmic_regression
        Examples:
        exponential_regression([[1.0,2.0],[0.0,1.0],[4.0,7.0]]);exponential_regression([1.0,0.0,4.0],[2.0,1.0,7.0])"
        '''
def exponential_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the plot of y=b*a^x : it is the best exponential which approx the points where the coordinates are the rows of A (or the 2 lists).
        Related: logarithmic_regression_plot
        Examples:
        exponential_regression_plot([[1.0,2.0],[0.0,1.0],[4.0,7.0]]);exponential_regression_plot([1.0,0.0,4.0],[2.0,1.0,7.0])"
        '''
def exponentiald(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability at x of the exponential law of parameter lambda.
        Usage: exponentiald(Real(lambda),Real(x))
        Related: exponential_cdf, exponential_icdf, randvector, ranm
        Examples:
        exponential(2.1,3.5);exponential(2.1,0.5); randvector(3,exponential,1.2); ranm(4,3,exponential,1.2)"
        '''
def exponentiald_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a exponential random variable of parameter lambda is lower than x0 (or between x0 and y0).
        Usage: exponentiald_cdf(Real(lambda),Real(x0),[Real(y0)])
        Related: exponentiald, exponential_icdf
        Examples:
        exponential_cdf(4.2,2.1);exponential_cdf(4.2,2.1,3.2)"
        '''
def exponentiald_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a exponential random variable of parameter lambda is lower than h is p (0<=p<=1).
        Usage: exponentiald_icdf(Real(lambda),Real(x0),Real(p))
        Related: exponential_cdf, exponentiald
        Examples:
        exponential_icdf(4.2,0.95);exponential_icdf(4.2,0.6)"
        '''
def export_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Writes G to the file 'graphname.dot' in directory 'path/to' in dot format, returns 1 on success and 0 on failure.
        Usage: export_graph(Graph(G),Str(""path/to/graphname""))
        Related: import_graph
        Examples:
        export_graph(complete_graph(5),""K5"")"
        '''
def expovariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a random real according to the exponential distribution of parameter a>0.
        Usage: expovariate(Real(a))
        Related: rand, randpoly, randnorm, randvector
        Examples:
        randexp(1);randexp(2)"
        '''
def expr(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Instruction transforming a string into a command or into a number.
        Related: string
        Examples:
        expr(""ifactor(54)"");expr(""123"");expr(""0123"");expr(sin,x)"
        '''
def extend(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Concatenates two lists or two strings or two sequences or 2 matrix; L:=concat(L,L1) or L.concat(L1).
        Usage: extend(Lst,Lst||Seq,Seq||Str,Str||Mtrx,Mtrx)
        Related: append, cat, semi_augment, border, +
        Examples:
        concat([1,2],[3,4,5]);concat(""bon"",""jour"");concat([[1,2],[3,4]],[[4,5,6],[6,7,8]]); L:=[1,2];L.concat([3,4,5]); S:=""abcd"";S.concat(""efghi"")"
        '''
def extract_measure(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: extract_measure gives as answer the value calculated by the argument.
        Related: angleatraw, distanceatraw, angleat, distanceat, slopeatraw, areaatraw, perimeteratraw, slopeat, areaat, perimeterat
        Examples:
        extract_measure(distanceatraw(0,1+i,(1+i)/2));extract_measure(angleatraw(0,1,1+i,1)); A:=point(0);B:=point(1+i);a:=distanceatraw(A,B,(1+i)/2);extract_measure(a)"
        '''
def extrema(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Search extrema of an expression
        Usage: extrema(Expr,Var,a,b)
        Examples:
        extrema(-2*cos(x)-cos(x)^2,x);extrema((x^3-1)^4/(2x^3+1)^4,x=0..inf);extrema(x/2-2*sin(x/2),x=-12..12);extrema(x-ln(abs(x)),x); assume(a>=0):;extrema(x^2+a*x,x);extrema(x^7+3x^6+3x^5+x^4+2x^2-x,x);extrema((x^2+x+1)/(x^4+1),x);extrema(x^2+exp(-x),x);extrema(exp(-x)*ln(x),x);extrema(tan(x)*(x^3-5x^2+1),x=-0.5);extrema(tan(x)*(x^3-5x^2+1),x=0.5);extrema(exp(x^2-2x)*ln(x)*ln(1-x),x=0.5);extrema(ln(2+x-sin(x)^2),x=0..2*pi);extrema(x^3-2x*y+3y^4,[x,y]);extrema((2x^2-y)*(y-x^2),[x,y])  //Peano surface;extrema(5x^2+3y^2+x*z^2-z*y^2,[x,y,z]);extrema(3*atan(x)-2*ln(x^2+y^2+1),[x,y]);extrema(x*y,x+y=1,[x,y]);extrema(sqrt(x*y),x+y=2,[x,y]);extrema(x*y,x^3+y^3=16,[x,y]);extrema(x^2+y^2,x*y=1,[x=0..inf,y=0..inf]);extrema(ln(x*y^2),2x^2+3y^2=8,[x,y]);extrema(y^2+4y+2x-x^2,x+2y=2,[x,y]); assume(a>0):;extrema(x/a^2+a*y^2,x+y=a,[x,y]);extrema(6x+3y+2z,4x^2+2y^2+z^2=70,[x,y,z]);extrema(x*y*z,x+y+z=1,[x,y,z]);extrema(x*y^2*z^2,x+y+z=5,[x,y,z]);extrema(4y-2z,[2x-y-z=2,x^2+y^2=1],[x,y,z]);extrema((x-3)^2+(y-1)^2+(z-1)^2,x^2+y^2+z^2=4,[x,y,z]);extrema(x+3y-z,2x^2+y^2=z,[x,y,z]);extrema(2x*y+2y*z+x*z,x*y*z=4,[x,y,z]);extrema(x+y+z,[x^2+y^2=1,2x+z=1],[x,y,z]); assume(a>0):;extrema(x+y+z,[y^2-x^2=a,x+2z=1],[x,y,z]);extrema((x-u)^2+(y-v)^2,[x^2/4+y^2/9=1,(u-3)^2+(v+5)^2=1],[u,v,x,y]);extrema(x2^6+x1^3+4x1+4x2,x1^5+x2^4+x1+x2=0,[x1,x2]);extrema(x*y,-2x^3+15x^2*y+11y^3-24y=0,[x,y]);extrema(x2^4-x1^4-x2^8+x1^10,[x1,x2],order_size=1);extrema(x2^4-x1^4-x2^8+x1^10,[x1,x2]);extrema(x2^6+x1^3+4x1+4x2,x1^5+x2^4+x1+x2=0,[x1,x2]);extrema(x2^6+x1^3+2x1^2-x2^2+4x1+4x2,x1^5+x2^4+x1+x2=0,[x1,x2]);extrema(3x^2-2x*y+y^2-8y,[x,y]);extrema(x^3+3x*y^2-15x-12y,[x,y]);extrema(4x*y-x^4-y^4,[x,y]);extrema(x*sin(y),[x,y]);extrema(x^4+y^4,[x,y]);extrema(x^3*y-x*y^3,[x,y])  ;extrema(x^2+y^2+z^2,x^4+y^4+z^4=1,[x,y,z]);extrema(3x+3y+8z,[x^2+z^2=1,y^2+z^2=1],[x,y,z]);extrema(2x^2+y^2,x^4-x^2+y^2=5,[x,y]);extrema((3x^4-4x^3-12x^2+18)/(12*(1+4y^2)),[x,y]);extrema(x-y+z,[x^2+y^2+z^2=1,x+y+2z=1],[x,y,z]);extrema(ln(x)+2*ln(y)+3*ln(z)+4*ln(u)+5*ln(v),x+y+z+u+v=1,[x,y,z,u,v]);extrema(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,y,z]);extrema(x+y-exp(x)-exp(y)-exp(x+y),[x,y]);extrema(x^2*sin(y)-4*x,[x,y])    ;extrema((1+y*sinh(x))/(1+y^2+tanh(x)^2),[x,y]);extrema((1+y*sinh(x))/(1+y^2+tanh(x)^2),y=x^2,[x,y])"
        '''
def ezgcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: GCD of 2 polynomials with at least 2 variables, with the ezgcd algorithm.
        Related: gcd, modgcd, heugcd, psrgcd
        Examples:
        ezgcd(x^2-2*xy+y^2-1,x-y);ezgcd((x+1)^4-y^4,(x+1-y)^2);ezgcd((x+y-1)*(x+y+1),(x+y+1)^2)"
        '''
def f2nd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list built with the numerator and the denominator of the simplified fraction .
        Related: simp2, numer, denom, getNum, getDenom
        Examples:
        f2nd(42/12);f2nd((x^2+2*x+1)/(x^2-1))"
        '''
def fMax(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the abscissa of the maximum of the expression.
        Related: fMin
        Examples:
        fMax(-x^2+2*x+1,x);fMax(-x^2+2*x+1,x=1..2)"
        '''
def fMin(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the abscissa of the minimum of the expression.
        Related: fMax
        Examples:
        fMin(x^2-2*x+1,x);fMin(x^2-2*x+1,x=1..2);fMin((x-3)^2+(y-5)^2+1,[],[x,y],[1,1]);fMin((x-3)^2+(y-5)^2+1,[x+y^2=1],[x,y],[1,1])"
        '''
def fPart(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the fractional part (if x<0 then frac(x)+floor(x)+1=x else frac(x)+floor(x)=x).
        Related: floor, iPart, trunc
        Examples:
        fPart(1/2);fPart(-1/2);fPart(1.2);fPart(-1.2);fPart([3.4,sqrt(2)])"
        '''
def faces(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of the faces (1 face=matrix(n,3) where the n rows are the n vertices of the face) of the polyhedron P.
        Related: polyhedron
        Examples:
        faces(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]));faces(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))[2]"
        '''
def facteurs_premiers(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of prime factors of an integer (each factor is followed by its multiplicity).
        Usage: facteurs_premiers(Intg(a) or LstIntg)
        Related: ifactor, factors
        Examples:
        ifactors(36);ifactors([36,52])"
        '''
def factor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorizes a polynomial.
        Related: ifactor, partfrac, normal
        Examples:
        factor(x^4-1);factor(x^4-4,sqrt(2));factor(x^4+12*x^3+54*x^2+108*x+81)"
        '''
def factor_xn(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorizes x^n in P (n=degree of polynomial P).
        Related: ifactor, partfrac, normal
        Examples:
        factor_xn(x^4-1);factor_xn(x^4+12*x^3+54*x^2+108*x+81)"
        '''
def factorial(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: factorial(n)=n!. For non-integers,factorial(a)=a! = G(a + 1). This calculates the Gamma function.
        Related: comb, perm
        Examples:
        factorial(4);factorial(1.2)"
        '''
def factoriser(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorizes a polynomial.
        Usage: factoriser(Expr)
        Related: ifactor, partfrac, normal
        Examples:
        factor(x^4-1);factor(x^4-4,sqrt(2));factor(x^4+12*x^3+54*x^2+108*x+81)"
        '''
def factoriser_entier(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorization of an integer into prime factors.
        Usage: factoriser_entier(Intg(a))
        Related: factor, ecm_factor
        Examples:
        ifactor(50);ifactor(123456789)"
        '''
def factoriser_sur_C(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorization of the expression in ℂ (on the Gauss integers if there are more than 2 variables).
        Usage: factoriser_sur_C(Expr)
        Related: factor
        Examples:
        cFactor(x^2*y+y);cFactor(x^2*y^2+y^2+4*x^2+4);cFactor(x^2*y^2+y^2+2*x^2+2)"
        '''
def factors(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of prime factors of a polynomial (each factor is followed by its multiplicity).
        Related: factor, ifactors
        Examples:
        factors(x^4-1);factors([x^2,x^2-1])"
        '''
def fadeev(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the pcar or charpoly command to specify the algorithm.
        Related: pcar
        Examples:
         pcar([[4,1,-2],[1,2,-1],[2,1,0]],fadeev)"
        '''
def false(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: boolean equal to false or 0.
        Related: true
        Examples:
         a:=false"
        '''
def falsepos_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving an numerical equation.
        Usage: alsepos_solve(Opt)
        Related: fsolve
        Examples:
         fsolve(cos(x)=x,x,0..1,bisection_solver); fsolve(cos(x)=x,x,0..1,brent_solver); fsolve(cos(x)=x,x,0..1,falsepos_solver); fsolve(cos(x)=x,x,0,newton_solver); fsolve(cos(x)=x,x,0,secant_solver); fsolve(cos(x)=x,x,0,steffenson_solver)"
        '''
def fclose(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Closes the file f.
        Related: fprint, fopen
        Examples:
        fclose(f)"
        '''
def fcoeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the polynomial describe by the list (root or pole, order).
        Related: pcoeff, froot, proot
        Examples:
        fcoeff([1,2,0,1,3,-1])"
        '''
def fdistrib(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Full distribution of * and / over + and -
        Related: texpand, normal, simplify, ratnormal
        Examples:
        expand((x+y)*(z+1));expand((a+b+c)/d);expand((y+x)*(z+y)*(x+z));expand((x+3)^4);expand((2*x-2*1)*(x^2-3*x+2)+(x^2-2*x+3)*(2*x-3*1))"
        '''
def fft(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Fast Fourier Transform in ℝ or in the field ℤ/pℤ, with a as primitive n-th root of 1 (n=size(L)).
        Related: ifft
        Examples:
        fft([1,2,3,4,0,0,0,0]);fft(ranm(128),22798,35969)"
        '''
def fieldplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: fieldplot(f(t,y),[t,y]) draws the plotfield of the diff equation y'=f(t,y).
        Related: interactive_plotode, odeplot, odesolve, desolve
        Examples:
        fieldplot(sin(t*y),[t=-5..5,y=-3..3],xstep=0.5,ystep=0.5);fieldplot(-t*y,[t,y]);fieldplot(-t*y,[t,y],normalize);fieldplot(-t*y,[t,y],normalize,xstep=0.5,ystep=0.5);fieldplot(-t*y,[t=-6.868..6.868,y=-6.868..6.868],normalize)"
        '''
def find(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of positions of an object in a list, a string or a set.
        Usage: find(Expr,Vect)
        Related: index, member
        Examples:
        find(1,[3,x,1,2,1,3]);find(2,[0,1,3,2,4,2,5])[0];find(""a"",""abracadabrant"");find(""ab"",""abracadabrant"");find(1,%{4,3,1,2%})"
        '''
def find_cycles(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of elementary cycles of the digraph G. If option ""length"" is specified, only cycles of length k resp. of length between l and u are returned.
        Usage: find_cycles(Graph(G,[length=k||l..u]))
        Related: is_acyclic
        Examples:
        find_cycles(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}));find_cycles(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}),length=3);find_cycles(digraph(%{[1,2],[1,3],[3,1],[1,4],[2,3],[4,3],[4,5],[5,3],[5,6],[7,6],[8,6],[8,7]%}),length=3..4)"
        '''
def findhelp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the help about the command (if ? is infixed see when) .
        Related: ifte, when
        Examples:
        findhelp(ifactor)"
        '''
def fisher(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability of the Fisher-Snedecor law (n and m are the numbers of degrees of freedom).
        Related: fisher_cdf, fisher_icdf, randvector, ranm
        Examples:
        fisher(4,10,2.1);fisher(4,4,2.1); randvector(5,fisher,4,6); ranm(2,3,fisher,4,6)"
        '''
def fisher_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Fisher-Snedecor random variable is lower than x0 (n and m are the numbers of degrees of freedom).
        Related: UTPF, fisher_icdf, fisherd
        Examples:
        fisher_cdf(4,4,2.1);fisher_cdf(4,10,3.5)"
        '''
def fisher_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such as the probability that a Fisher-Snedecor random variable is lower than h is p (n and m are the numbers of degrees of freedom and 0<=p<=1).
        Related: fisher_cdf, fisherd
        Examples:
        fisher_icdf(4,10,0.95);fisher_icdf(4,10,0.05)"
        '''
def fisherd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability of the Fisher-Snedecor law (n and m are the numbers of degrees of freedom).
        Usage: fisherd(Intg(n),Intg(m),Real(x0))
        Related: fisher_cdf, fisher_icdf, randvector, ranm
        Examples:
        fisher(4,10,2.1);fisher(4,4,2.1); randvector(5,fisher,4,6); ranm(2,3,fisher,4,6)"
        '''
def fisherd_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Fisher-Snedecor random variable is lower than x0 (n and m are the numbers of degrees of freedom).
        Usage: fisherd_cdf(Intg(n),Intg(m),Real(x0))
        Related: UTPF, fisher_icdf, fisherd
        Examples:
        fisher_cdf(4,4,2.1);fisher_cdf(4,10,3.5)"
        '''
def fisherd_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such as the probability that a Fisher-Snedecor random variable is lower than h is p (n and m are the numbers of degrees of freedom and 0<=p<=1).
        Usage: fisherd_icdf(Intg(n),Intg(m),Real(p))
        Related: fisher_cdf, fisherd
        Examples:
        fisher_icdf(4,10,0.95);fisher_icdf(4,10,0.05)"
        '''
def fitdistr(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the distribution of type D which fits most closely to the i.i.d. samples in the list L.
        Usage: fitdistr(Lst(L),Fnc(D))
        Related: normald, poisson, exponentiald, geometric, gammad, betad, cauchyd, weibulld, sample, randvector, randvar
        Examples:
        fitdistr(randvector(1000,weibulld,1/2,1),weibull); X:=randvar(normal,stddev=9.5):;Y:=randvar(normal,stddev=1.5):;S:=sample(eval(X/Y,0),1000):;Z:=fitdistr(S,cauchy); X:=randvar(normal,mean=5,variance=2):;S:=sample(exp(X),1000):;fitdistr(log(S),normal)"
        '''
def flatten(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Recursively flatten a list containing lists.
        Related: mat2list
        Examples:
        flatten([[1,[2,3],4],[5,6]])"
        '''
def float2rational(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Converts the expression to a rational or real expression.
        Examples:
        -2;float2rational(1.5);float2rational(1.4141);float2rational(0.156381102937)"
        '''
def floor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the greatest integer <= to the argument
        Related: round, ceil, iPart, trunc
        Examples:
        floor(-2.5);floor(2.5-4.2*i)"
        '''
def flow_polynomial(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the flow polynomial [or its value at point x] of undirected unweighted graph G.
        Usage: flow_polynomial(Graph(G),[Var(x)])
        Related: chromatic_polynomial, reliability_polynomial, tutte_polynomial
        Examples:
        flow_polynomial(graph(""tetrahedron""));flow_polynomial(graph(""tetrahedron""),5)"
        '''
def fmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Usage: fmod(Real(a),Real(b))
        Examples:
        fmod(10.0,pi)"
        '''
def foldl(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the composition of the binary operator or function op, with an identity or initial value id onto its arguments r1, r2, ..., associating from the left.
        Usage: foldl(op,id,Seq(r1,r2,...))
        Related: apply, foldr, map
        Examples:
        foldl(F,init,a,b,c)"
        '''
def foldr(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the composition of the binary operator or function op, with an identity or initial value id onto its arguments r1, r2, ..., associating from the right.
        Usage: foldr(op,id,Seq(r1,r2,...))
        Related: apply, foldl, map
        Examples:
        foldr(F,init,a,b,c)"
        '''
def fonction_derivee(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the derivative function of the function f.
        Usage: fonction_derivee(Fnc(f))
        Related: diff, ', @
        Examples:
        function_diff(sin+id);function_diff(sq@sin+id);function_diff(ln)(x,y);function_diff(ln)([x,y]); (function_diff @@3)(ln)('x') "
        '''
def forward(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: The turtle takes n steps forward (by default n=10).
        Usage: forward(NULL or Real(n))
        Related: recule, saute
        Examples:
         avance 30;avance(30)"
        '''
def fourier_an(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n-th Fourier coefficient an=2/T*integrate(f(x)*cos(2*pi*n*x/T),a,a+T).
        Related: fourier_cn, fourier_bn, assume
        Examples:
        fourier_an(x^2,n);fourier_an(x^2,x,2*pi,n,-pi)"
        '''
def fourier_bn(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n-th Fourier coefficient bn=2/T*integrate(f(x)*sin(2*pi*n*x/T),a,a+T).
        Related: fourier_cn, fourier_an, assume
        Examples:
        fourier_bn(x^2,n);fourier_bn(x^2,x,2*pi,n,-pi)"
        '''
def fourier_cn(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n-th Fourier coefficient cn=1/T*integrate(f(x)*exp(-2*i*pi*n*x/T),a,a+T).
        Related: fourier_an, fourier_bn, assume
        Examples:
        fourier_cn(x^2,n);fourier_cn(x^2,x,2*pi,n,-pi)"
        '''
def fprint(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Writes in the file f some data.
        Related: fopen, fclose
        Examples:
        fprint(f,x+1,""2"");fprint(f,""blabla"");fprint(f,Unquoted,""blabla"")"
        '''
def frac(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the fractional part (if x<0 then frac(x)+floor(x)+1=x else frac(x)+floor(x)=x).
        Usage: frac(Real||LstReal)
        Related: floor, iPart, trunc
        Examples:
        fPart(1/2);fPart(-1/2);fPart(1.2);fPart(-1.2);fPart([3.4,sqrt(2)])"
        '''
def fracmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the fraction a/b such as b*Xpr=a mod n, -sqrt(n)/2<a<=sqrt(n)/2 and 0<=b<sqrt(n)/2.
        Related: mod, smod
        Examples:
        fracmod(41,121)"
        '''
def frame_2d(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: frame_2d() draws the axes of the graphic-screen 2-d.
        Related: frame_3d, Ox_2d_unit_vector, Oy_2d_unit_vector
        Examples:
        frame_2d()"
        '''
def frequencies(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the frequencies of a list values.
        Related: histogram, cumulated_frequencies, bar_plot, classes
        Examples:
        frequencies([1,2,1,1,2,1,2,4,3,3]);frequencies([(rand(6)+1)$(k=1..100)])"
        '''
def frobenius_norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Frobenius norm of a matrix A (=sqrt(sum |aij|^2)).
        Related: l1norm, l2 norm, linfnorm, matrix_norm
        Examples:
        frobenius_norm([[1,2,3],[3,-9,6],[4,5,6]])"
        '''
def froot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of roots and poles of F with their multiplicity.
        Related: proot, fcoeff, pcoeff, realroot, complexroot, rationalroot, crationalroot
        Examples:
        froot((x^5-2*x^4+x^3)/(x-3));froot((x^5-2*x^4+x^3)/(x-1))"
        '''
def fsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Numerical solution of an equation or a system of equation.
        Related: cfsolve, nSolve, solve, csolve, lpsolve, nlpsolve
        Examples:
        fsolve(cos(x)=x,x,-1..1,bisection_solver);fsolve(cos(x)=x,x,0,newton_solver);fsolve([x^2+y-2,x+y^2-2],[x,y],[0,0],newtonj_solver);fsolve([x^2+y-2,x+y^2-2],[x,y])"
        '''
def fullparfrac(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the convert or convertir command (id at the option partfrac).
        Usage: ullparfra(Opt)
        Related: convert
        Examples:
         convert(1/(x^2-1),parfrac); convert(1/(x^2-1),fullparfrac)"
        '''
def funcplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Plot a 1 variable or 2 variables expression with superposition.
        Usage: funcplot(Expr,[Var(x) or VectVar] ,[Intg(color)])
        Related: plot, plot3d, plotparam, animate, animate3d, plotdensity
        Examples:
        plotfunc(-2*x+1,x=1..2,color=red);plotfunc([-2*x+1,x^2-2],x=-2..2,color=[red,yellow],xstep=0.2);plotfunc(x^2-y^2,[x,y],xstep=0.5,ystep=0.3);plotfunc(x^2+y^2,[x=-1..1,y=-2..2],nstep=900);plotfunc((x+i*y)^2,[x=-1..1,y=-2..2],nstep=900,affichage=rempli)"
        '''
def function_diff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the derivative function of the function f.
        Related: diff, ', @
        Examples:
        function_diff(sin+id);function_diff(sq@sin+id);function_diff(ln)(x,y);function_diff(ln)([x,y]); (function_diff @@3)(ln)('x') "
        '''
def fxnd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list built with the numerator and the denominator of the simplified fraction .
        Usage: fxnd(Frac or RatFrac)
        Related: simp2, numer, denom, getNum, getDenom
        Examples:
        f2nd(42/12);f2nd((x^2+2*x+1)/(x^2-1))"
        '''
def gammad(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the density of probability of the Gamma law (=x^(a-1)*exp(-b*x)*b^a/Gamma(a)).
        Related: gammad_cdf;, gammad_icdf
        Examples:
        gammad(2.2,1.5,0.8)"
        '''
def gammad_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a Gamma random variable (with a and b as parameters) is lower than x0 or between x0 and y0.
        Related: gammad, gammad_icdf
        Examples:
        gammad_cdf(2,1,2.96);gammad_cdf(2,1,1.4,2.96)"
        '''
def gammad_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a Gamma random variable is lower than h is p (0<=p<=1).
        Related: gammad_cdf, gammad
        Examples:
        gammad_icdf(2,1,0.95);gammad_icdf(2,1,0.5)"
        '''
def gammavariate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a random real according to the Gamma distribution of parameter a>0 and b>0
        Usage: gammavariate(Real(a),Real(b))
        Related: rand, randpoly, randnorm, randvector
        Examples:
        randgammad(1,2);randgammad(1.5,4)"
        '''
def gauss(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Split a quadratic form as a sum/difference of square
        Related: cholesky
        Examples:
        gauss(x^2+2*a*x*y,[x,y])"
        '''
def gauss15(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the area command
        Usage: auss1(Opt)
        Related: area
        Examples:
         area(x^2,x=0..1,5,simpson); area(x^2,x=0..1,5,rombergt); area(x^2,x=0..1,5,rombergm);area(x^2,x=0..1,5,gauss15)"
        '''
def gauss_seidel_linsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Resolution of a linear system A*X=b  by the iterative Gauss-Seidel method (by default omega=1) or by relaxation method, with eps as error margin and a number of iterations inferior to maxiter.
        Related: jacobi_linsolve, linsolve
        Examples:
         a:=[[100,2],[2,100]];gauss_seidel_linsolve(a,[0,1],1e-12);; a:=[[100,2],[2,100]];gauss_seidel_linsolve(table(a),[0,1],1e-12); ; a:=[[100,2],[2,100]];gauss_seidel_linsolve(1.5,a,[0,1],1e-12);; a:=[[100,2],[2,100]];gauss_seidel_linsolve(1.5,table(a),[0,1],1e-12); "
        '''
def gaussian_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Gaussian windowing function with parameter 0<a<=0.5 (by default a=0.1) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: gaussian_window(Lst,[Real(a)],[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bohman_window, cosine_window, bartlett_hann_window, hamming_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(gaussian_window(randvector(1000,0..1),0.4))"
        '''
def gaussjord(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Row reduction to echelon form of AX=b (M=A|(-b)) [Reduction on columns 0..k-1]
        Usage: gaussjord(Mtrx(M),[Intg(k)]||Opt)
        Related: ker, image, det, Rref, pivot, ref, keep_pivot
        Examples:
        rref([[3,1,-2],[3,2,2]]);rref([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]]);rref([[2,1,1,-1],[1,1,2,-1],[1,2,1,-4]],2);rref([[1,1,0,0,-a1],[0,1,1,0,-a2],[0,0,1,1,-a3],[1,0,0,1,-a4]],keep_pivot)"
        '''
def gaussquad(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the approximate value of integrate(f(x),x,a,b) by adaptive Gaussian quadratures with 15 points.
        Related: integrate, romberg
        Examples:
        gaussquad(exp(x^2),x,0,1);gaussquad(x^2,x,0,1);gaussquad(exp(-x^2),x,-1,1)"
        '''
def gbasis(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Groebner basis of the ideal spanned by the list of polynomials.
        Related: greduce, gbasis_max_pairs, gbasis_simult_primes
        Examples:
        gbasis([x^2-y^3,x+y^2],[x,y]);gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3]);gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],tdeg);gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1],[x1,x2,x3],plex);gbasis([x1+x2+x3,x1*x2+x1*x3+x2*x3,x1*x2*x3-1] mod 29,[x1,x2,x3])"
        '''
def gbasis_max_pairs(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Gbasis fine-tuning: maximal number of S-pairs to be reduced simultaneously inside F4 algorithm (default 32768, 0 means no limit). Set it to a smaller value if short in memory.
        Usage: gbasis_max_pairs(Intg)
        Related: gbasis, gbasis_simult_primes, gbasis_reinject
        Examples:
        gbasis_max_pairs(4096);gbasis_max_pairs(0)"
        '''
def gbasis_reinject(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Gbasis fine-tuning: in the modular algorithm of a gbasis over Q, adds a partial reconstruction of the basis if the ratio of new elements is greater than a and the speed ratio of the 2nd run/1st run is >= b (default a=0.2 and b=1/6.)
        Usage: gbasis_reinject(Real(a),[Real(b)])
        Related: gbasis, gbasis_max_pairs, gbasis_reinject 
        Examples:
        gbasis_reinject(0.1);gbasis_reinject(0.1,0.05)"
        '''
def gbasis_simult_primes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Gbasis fine-tuning: maximal number of Groebner basis modulo a prime that are computed simultaneously to rebuild a Groebner basis over Q (default 16). Set it to a smaller value if short in memory.
        Usage: gbasis_simult_primes(Intg)
        Related: gbasis, gbasis_max_pairs, gbasis_reinject 
        Examples:
        gbasis_simult_primes(3)"
        '''
def gcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the greatest common divisor of 2 polynomials of several variables or of 2 integers or of 2 rationals.
        Related: lcm, euler, modgcd, ezgcd, psrgcd, heugcd, Gcd
        Examples:
        gcd(45,75);gcd(15/7,50/9);gcd(x^2-2*x+1,x^3-1);gcd(t^2-2*t+1,t^2+t-2);gcd((x^2-1)*(y^2-1)*z^2,x^3*y^3*z+(-(y^3))*z+x^3*z-z)"
        '''
def gcdex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extended greatest common divisor of 2 polynomials.
        Usage: gcdex((Poly or Lst),(Poly or Lst),[Var])
        Related: gcd, iegcd
        Examples:
        egcd((x-1)^2,x^3-1);egcd((X-1)^2,X^3-1,X);egcd([1,-2,1],[1,0,0,-1]);egcd([1,-2,1],[1,-1,2])"
        '''
def genpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the reconstruction of a n-variables polynomial Q(-b/2<=coef<=b/2) from a (n-1)-variable polynomial P and a base b (subst(Q,var=b)=P).
        Examples:
        genpoly(15,4,x);genpoly(7*y+5,6,x);genpoly(7*y-5*z,10,x)"
        '''
def geometric(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value at k of the geometric law of parameter p (0<p<1).
        Related: geometric_cdf, geometric_icdf, randvector, ranm
        Examples:
        geometric(0.3,4);geometric(0.5,5); randvector(3,geometric,0.3); ranm(4,3,geometric,0.3)"
        '''
def geometric_cdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the probability that a geometric random variable of parameter p (0<p<1) is lower than k (or between k and m).
        Related: geometric, geometric_icdf
        Examples:
        geometric_cdf(0.3,4);geometric_cdf(0.3,4,5)"
        '''
def geometric_icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns h such that the probability that a geometric random variable of parameter p (0<p<1) is lower than h is x (0<=x<=1).
        Related: geometric_cdf, geometric
        Examples:
        geometric_icdf(0.3,0.95)"
        '''
def getDenom(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the denominator of the unsimplified expression (except for rational number).
        Related: denom, getNum, numer, f2nd
        Examples:
        getDenom(25/15);getDenom((x^3-1)/(x^2-1));getDenom(1+(x^3-1)/x^2)"
        '''
def getKey(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Instruction in a program, returns 0 if no key is pressed and else returns the ascii code of the pressed key.
        Related: getType
        Examples:
        getKey()"
        '''
def getNum(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the numerator of the unsimplified expression (except for rational number).
        Related: numer, denom, getDenom, f2nd
        Examples:
        getNum(25/15);getNum((x^3-1)/(x^2-1));getNum(1+(x^3-1)/x^2)"
        '''
def getType(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the type of the argument (STR,EXPR,FUNC,NUM,LIST,MAT,VAR,NONE,PIC...).
        Related: getKey
        Examples:
        getType(""aze"");getType(2+i);getType(x->cos(2*x));getType(1.414)"
        '''
def get_edge_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return the attributes tag1, tag2, ... assigned to edge e in G as a sequence of the corresponding values.
        Usage: get_edge_attribute(Graph(G),Edge(e),Seq(tag1=value1,tag2=value2,..))
        Related: discard_edge_attribute, set_edge_attribute, list_edge_attributes
        Examples:
        get_edge_attribute(cycle_graph(3),[1,2],""cost"")"
        '''
def get_edge_weight(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the weight of the edge e in the weighted graph G.
        Usage: get_edge_weight(Graph(G),Edge(e))
        Related: is_weighted, make_weighted, set_edge_weight, weight_matrix
        Examples:
        get_edge_weight(graph(%{[[1,2],5],[[2,3],6]%}),[1,2])"
        '''
def get_graph_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return the graph attributes tag1, tag2, ..., as a sequence of the corresponding values.
        Usage: get_graph_attribute(Graph(G),Seq(tag1=value1,tag2=value2,..))
        Related: discard_graph_attribute, set_graph_attribute, list_graph_attributes
        Examples:
        get_graph_attribute(cycle_graph(3),""name"")"
        '''
def get_vertex_attribute(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return the attributes tag1, tag2, ... assigned to vertex v in G as a sequence of the corresponding values.
        Usage: get_vertex_attribute(Graph(G),Vrtx(v),Seq(tag1=value1,tag2=value2,..))
        Related: discard_vertex_attribute, set_vertex_attribute, list_vertex_attributes
        Examples:
        get_vertex_attribute(cycle_graph(3),1,""supply"")"
        '''
def girth(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the length of the shortest cycle in the undirected unweighted graph G.
        Usage: girth(Graph(G))
        Related: odd_girth
        Examples:
        girth(graph(""petersen""));girth(hypercube_graph(3))"
        '''
def gl_showaxes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option that shows or hides axes.
        Usage: l_showaxe(Opt=Boolean)
        Related: switch_axes, axes
        Examples:
         gl_showaxes=true;plot(sin(x)); gl_showaxes=false;plot(sin(x)) "
        '''
def grad(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the gradient of the expression Xpr
        Related: hessian
        Examples:
        grad(2*x^2*y-x*z^3,[x,y,z])"
        '''
def gramschmidt(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns an orthonormal base of E of base B for the scalar product Sp
        Examples:
        -2;gramschmidt([1,1+x],(p,q)->integrate(p*q,x,-1,1))"
        '''
def graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Create an (un)directed (un)weighted graph from vertices V, edges E, and/or adjacency or weight matrix A. All parameters are optional.
        Usage: graph([Lst(V)],[Set(E)],[Mtrx(A)],[options])
        Related: digraph, trail
        Examples:
        graph(5);graph([a,b,c]);graph([1,2,3],%{[1,2],[2,3],[3,1]%});graph(trail(1,2,3,4,1),directed=true);graph([a,b,c],[[0,2,0],[2,0,3],[0,3,0]]);graph(""petersen"");graph([[0,1,1,0],[1,0,0,1],[1,0,0,0],[0,1,0,0]])"
        '''
def graph_automorphisms(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the sequence of generators of Aut(G), the automorphism group of G. Each element is a permutation in form of list of disjoint cycles.
        Usage: graph_automorphisms(Graph(G))
        Related: cycles2permu, isomorphic_copy, permute_vertices
        Examples:
        graph_automorphisms(graph(""petersen""))"
        '''
def graph_charpoly(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value p(x) of the characteristic polynomial p of G. If x is omitted, a list of coefficients of p is returned.
        Usage: graph_charpoly(Graph(G),[Var(x)])
        Related: graph_spectrum, charpoly
        Examples:
        graph_charpoly(graph(%{[1,2],[2,3]%}));graph_charpoly(graph(""shrikhande""))"
        '''
def graph_complement(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return the graph with the same vertex set as G, but whose edge (arc) set consists of the edges (arcs) not present in G.
        Usage: graph_complement(Graph(G))
        Related: edges
        Examples:
        graph_complement(cycle_graph(5))"
        '''
def graph_diameter(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the maximum distance between a pair of vertices in G or +infinity if G is disconnected.
        Usage: graph_diameter(Graph(G))
        Related: allpairs_distance, dijkstra, shortest_path, vertex_distance
        Examples:
        graph_diameter(graph(""petersen""))"
        '''
def graph_equal(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff the input graphs G1 and G2 are equal, that is when the sets of vertices and edges of G1 and G2, as well as the orderings of vertices in both graphs, mutually coincide. If the graphs are weighted (they must both be (un)weighted and (un)directed), weights given to the same edge in two graphs must be equal.
        Usage: graph_equal(Graph(G1),Graph(G2))
        Related: edges, graph_vertices
        Examples:
        graph_equal(graph([1,2,3],%{[1,2],[2,3],[3,1]%}),graph(trail(1,2,3,1)))"
        '''
def graph_join(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graph obtained by connecting every vertex from G with every vertex from H. The vertex labels in the resulting graph are strings of form ""1:u"" and ""2:v"" where u and v are vertices from G and H, respectively.
        Usage: graph_join(Graph(G),Graph(H))
        Related: disjoint_union, graph_union
        Examples:
        edges(graph_join(cycle_graph(3),graph(2)))"
        '''
def graph_power(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the k-th power of G, where two vertices are connected iff there exists a path of length at most k in the original graph.
        Usage: graph_power(Graph(G),Intg(k))
        Related: adjacency matrix, graph_diameter, shortest_path
        Examples:
        edges(graph_power(path_graph(5),3))"
        '''
def graph_rank(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graph rank of G. If optional set E of edges is given, rank of the spanning subgraph of G with edge set E is returned.
        Usage: graph_rank(Graph(G),[Lst(E)])
        Related: connected_components, number_of_vertices
        Examples:
        graph_rank(graph(%{[1,2],[3,4],[4,5]%}));graph_rank(graph(%{[1,2],[3,4],[4,5]%}),[[1,2],[3,4])"
        '''
def graph_spectrum(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graph spectrum of G as a list of lists with two elements, each containing an eigenvalue and its multiplicity.
        Usage: graph_spectrum(Graph(G))
        Related: graph_charpoly, seidel_spectrum, is_integer_graph
        Examples:
        graph_spectrum(cycle_graph(5))"
        '''
def graph_union(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the union of the graphs G1, G2, ... The set of vertices of the resulting graph is the union of the sets of vertices of the input graphs and the set of edges of the resulting graph is the union of sets of edges of the input graphs. If the input graphs are weighted, the weight of any common edge is the sum of the weights of that edge in G1, G2, ...
        Usage: graph_union(Seq(G1,G2,...))
        Related: disjoint_union, graph_join
        Examples:
        edges(graph_union(cycle_graph(4),path_graph(5)))"
        '''
def graph_vertices(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return the list of vertices in G.
        Usage: graph_vertices(Graph(G))
        Related: add_vertex, graph, neighbors, permute_vertices, relabel_vertices
        Examples:
        graph_vertices(graph(%{[a,c],[b,c],[a,b]%}))"
        '''
def greduce(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the remainder of the division of a polynomial by a Groebner basis.
        Related: gbasis
        Examples:
        greduce(x*y-1,[x^2-y^2,2*x*y-y^2,y^3],[x,y]);greduce(x1^2*x3^2,[x3^3-1,-x2^2-x2*x3-x3^2,x1+x2+x3],[x1,x2,x3],tdeg);greduce(x1^2*x3^2-x2,[x3^3-1,-x2^2-x2*x3-x3^2,x1+x2+x3],[x1,x2,x3])"
        '''
def greedy_color(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of vertex colors (positive integers) obtained by coloring vertices one at a time [in the order given by permutation p], assigning to it the smallest available color.
        Usage: greedy_color(Graph(G),[Permu(p)])
        Related: is_vertex_colorable, chromatic_number
        Examples:
        greedy_color(graph(""petersen""))"
        '''
def grid_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a [triangular] grid graph on m*n vertices, where m,n>=2.
        Usage: grid_graph(Intg(m),Intg(n),[triangle])
        Related: torus_grid_graph
        Examples:
        grid_graph(5,8)"
        '''
def groupermu(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the group of permutations generated by a and b.
        Examples:
        groupermu([1,2,0],[3,1,2,0])"
        '''
def hadamard(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hadamard bound of a matrix or element by element multiplication of 2 matrix
        Related: .*, *
        Examples:
        hadamard([[1,2],[3,4]]);hadamard([[1,2],[3,4]],[[3,4],[5,6]])"
        '''
def half_cone(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws an half-cone with vertex A, direction v and with half_angle=t [and with altitude h].
        Related: cone, cylinder
        Examples:
        half_cone([0,0,0],[0,0,1],pi/6);half_cone([0,0,0],[0,1,1],pi/6,-4)"
        '''
def half_line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: half_line(A,B) draws the half-line AB with A as origin.
        Related: line
        Examples:
        half_line(i,1+i);half_line(point(i),point(1+i))"
        '''
def halftan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Transforms sin(x),cos(x) and tan(x) as function of tan(x/2).
        Examples:
        halftan(sin(x));halftan(cos(x));halftan(tan(x))"
        '''
def halftan_hyp2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Transforms the trigonometric functions in tan(x/2) and hyperbolic functions in exp
        Related: hyp2exp, halftan
        Examples:
        halftan_hyp2exp(sin(x)+sinh(x))"
        '''
def halt(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Put a program in step-by-step debug mode
        Examples:
        halt()"
        '''
def hamdist(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Bit Hamming distance.
        Examples:
        hamdist(0x12,0x38)"
        '''
def hamming_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Hamming windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: hamming_window(Lst,[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bohman_window, cosine_window, gaussian_window, bartlett_hann_window, hann_poisson_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(hamming_window(randvector(1000,0..1)))"
        '''
def hann_poisson_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Hann-Poisson windowing function with parameter a (by default a=1) to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: hann_poisson_window(Lst,[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bohman_window, cosine_window, gaussian_window, hamming_window, bartlett_hann_window, hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(hann_poisson_window(randvector(1000,0..1),2))"
        '''
def hann_window(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Applies the Hann windowing function to the given signal u (or to the elements with indices between n1 and n2) and returns the result in a new list.
        Usage: hann_window(Lst,[Interval(n1..n2)])
        Related: blackman_harris_window, blackman_window, bohman_window, cosine_window, gaussian_window, hamming_window, hann_poisson_window, bartlett_hann_window, parzen_window, poisson_window, riemann_window, triangle_window, tukey_window, welch_window
        Examples:
         scatterplot(hann_window(randvector(1000,0..1)))"
        '''
def harmonic_conjugate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the harmonic conjugate C  toward A and B of 3 points or of 3 parallel or concurrent lines or the line of conjugates of a point in respect to 2 lines.
        Related: is_harmonic, harmonic_division
        Examples:
        harmonic_conjugate(0,2,3/2);harmonic_conjugate(0,1+i,2+2*i);harmonic_conjugate(line(0,1+i),line(0,3+i),line(0,i));harmonic_conjugate(line(0,1+i),line(0,3+i),point(3/2+i))"
        '''
def harmonic_division(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the 4 points (resp lines) and affects the last argument, such as the 4 points (resp lines) are in a harmonic division.
        Related: harmonic_conjugate, is_harmonic
        Examples:
        harmonic_division(0,2,3/2,D);harmonic_division(0,1+i,2+2*i,D);harmonic_division(line(i,0),line(i,1+i),line(i,3+2*i),D);harmonic_division(line(0,1+i),line(0,3+i),line(0,i),D)"
        '''
def has(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Checks if a variable is in an expression
        Related: lname, lvar
        Examples:
        has(x+y,x);has(x+y,n)"
        '''
def has_arc(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff the arc e=[i,j] is contained in digraph G or, if e={i,j} is a set, iff G has both edges [i,j] and [j,i].
        Usage: has_arc(Graph(G),Edge(e))
        Related: edges, has_edge
        Examples:
        has_arc(digraph(trail(1,2,3,4,1)),[4,2]);has_arc(digraph(trail(1,2,3,4,1)),%{4,2%})"
        '''
def has_edge(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff the edge e=[i,j] is contained in undirected graph G.
        Usage: has_edge(Graph(G),Edge(e))
        Related: edges, has_arc
        Examples:
        has_edge(graph(trail(1,2,3,4,1)),[2,4])"
        '''
def hasard(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: (hasard n)=a random integer (resp (hasard p,n)=a real or hasard(p..n)=a real function) with uniform distribution in 0..n-1 (resp in [p;n])(hasard= (hasard 0,1)=a random real in [0,1[) or hasard(n,b1,b2)=n integers between b1 and b2 or hasard(n,L)=n elements of L. If hasard has only one argument, () are not necessary (compatibility with turtle language).
        Related: rand, randpoly, ranm, randvector, srand
        Examples:
         hasard 4; hasard(4);hasard(0,2); hasard 0..2; f:=hasard 0..2;hasard(3,1,10);hasard(3,[""r"",""r"",""r"",""b"",""n""])"
        '''
def head(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Shows the first element of a vector or a sequence or a string.
        Related: back, tail, mid, left, right
        Examples:
        head(1,2,3);head([1,2,3]);head(""bonjour"")"
        '''
def heading(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the turtle cap in degrees or turns the turtle with the cap given by the argument.
        Usage: heading(NULL or Real)
        Related: position, initialise
        Examples:
         cap;cap();cap 90"
        '''
def heapify(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Partial ordering of a list as a heap
        Usage: heapify(List)
        Related: heappush, heappop
        "
        '''
def heappop(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Removes and returns the root node of a heap
        Usage: heappop(List)
        Related: heapify, heappush
        "
        '''
def heappush(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Adds an object in a heap
        Usage: heappush(List,Object)
        Related: heapify, heappop
        "
        '''
def hermite(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Hermite polynomial of degree n or the Hermite normal form for a polynomial coefficients matrix (I,U such that I*A=U)
        Related: legendre, laguerre, smith, ihermite, ismith
        Examples:
        hermite(3); n:=5; a:=ranm(n,n) % 17; l,u:=hermite(x-a);normal(l*(x-a)-u);"
        '''
def hessenberg(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Matrix reduction to Hessenberg form. Returns [P,B] such that B=inv(P)*A*P, by default n=0 the result is exact else the result is numeric. For n=-1 B is triangular, n=-2 P is orthogonal and if n is prime the result is mod n.
        Related: SCHUR
        Examples:
        hessenberg([[1,2,3],[4,5,6],[7,8,1]]);hessenberg([[1,2,3,4],[4,5,6,7],[7,8,9,0],[0,1,2,3]]);hessenberg([[1,2,3],[4,5,6],[7,8,1]],-1);hessenberg([[1,2,3],[4,5,6],[7,8,1]],-2);hessenberg([[1,2,3],[4,5,6],[7,8,1]],3)"
        '''
def hessian(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the hessian of the expression Xpr
        Related: grad
        Examples:
        hessian(2*x^2*y-x*z,[x,y,z])"
        '''
def heugcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: GCD of 2 polynomials, with the algorithm called heuristic pgcd.
        Related: gcd, modgcd, ezgcd, psrgcd
        Examples:
        heugcd(x^4-1,(x-1)^2)"
        '''
def hexagon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns and draws the hexagon of side AB (ABCDEF is direct) (in the plane ABP.
        Related: isopolygon, polygon
        Examples:
        hexagon(i,1+i);hexagon(i,1+i,C,D,E,F);hexagon(point(0,0,0),point(3,3,3),point(0,0,3));hexagon(point(0,0,0),point(3,3,3),point(0,0,3),C,D,E,F)"
        '''
def highlight_edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Change color of edge e resp. colors of edges in E of the input graph V to c resp C (by default red) and return the modified copy of G.
        Usage: highlight_edges(Graph(G),Edge(e)||Lst(E),[Color(c)||Lst(C)])
        Related: highlight_vertex, highlight_subgraph, highlight_trail
        Examples:
         draw_graph(highlight_edges(cycle_graph(3),[1,2]))"
        '''
def highlight_subgraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Change colors of edges and vertices from the sugbraph S or list of subgraphs S1, S2, ... of G to c1 and c2, respectively (red and green by default), and return the modified copy of G.
        Usage: highlight_subgraph(Graph(G),Graph(S)||Lst(S1,S2,..),Seq(c1,c2))
        Related: highlight_edges, highlight_vertex, highlight_trail
        Examples:
         draw_graph(highlight_subgraph(cycle_graph(5),path_graph(3)))"
        '''
def highlight_trail(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Change colors of edges in G which lie along the trail t resp. trails in T to c resp. C (by default red) and return the modified copy of G.
        Usage: highlight_trail(Graph(G),Trail(t)||Lst(T),[Color(c)||Lst(C)])
        Related: highlight_edges, highlight_subgraph, highlight_vertex
        Examples:
         draw_graph(highlight_trail(cycle_graph(5),trail(1,2,3),green)"
        '''
def highlight_vertex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Change the color of vertex v resp. colors of vertices from V in G to c resp. C (green by default) and return the modified copy of G.
        Usage: highlight_vertex(Graph(G),Vrtx(v)||Lst(V),[Color(c)||Lst(C)])
        Related: highlight_edges, highlight_subgraph, highlight_trail
        Examples:
         draw_graph(highlight_vertex(cycle_graph(3),1))"
        '''
def highpass(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the result of applying a simple first-order highpass RC filter with cutoff frequency c (the default samplerate is 44100) to the given signal s.
        Usage: highpass(Lst(s),Real(c),[Intg(samplerate)])
        Related: lowpass, moving_average
        Examples:
         f:=unapply(periodic(sign(x),x,-1/880,1/880),x):;s:=createwav(apply(f,soundsec(1))):;playsnd(highpass(s,5000))"
        '''
def hilbert(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the order n Hilbert matrix : Hjk=1/(j+k+1) j,k=1..n
        Examples:
        hilbert(4)"
        '''
def histogram(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the histogram of data, optional arguments are eff (number of data for each data element) or nc the number of classes or the classes minimum and size
        Related: cumulated_frequencies, classes, bar_plot, frequencies
        Examples:
        histogram([1,2,1,1,2,1,2,4,3,3]);histogram([1,2,1,1,2,1,2,4,3,3],0.5,1);histogram(seq(rand(1000),k,0,100),0,100);histogram(binomial,10,.5);histogram([[0,1],[1,4],[2,3],[3,2],[4,1]]);histogram([[1.5..1.65,50],[1.65..1.7,20],[1.7..1.8,30]]);histogram(seq(rand(1000),k,0,100),0,100);histogram(seq(rand(1000),k,0,100),10)"
        '''
def hold(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns its argument unevaluated (and also a:=quote(a) that purge a).
        Usage: hold(Expr)
        Examples:
        quote(1+2);quote(1/x+1/(x-1));quote((x+1)*(x-1))"
        '''
def homothety(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: homothety(C,k,A)=point A1 such as vect(C,A1)=k*vect(C,A) i.e in 2d it is the similarity center C, coeff abs(k) and angle arg(k).
        Related: similarity, inversion
        Examples:
        homothety(1+i,1/3,i);homothety(point(1,1,1),1/3,point(0,1,0)); h:=homothety(1+i,1/3);h(i); h:=homothety(point(1,1,1),1/3);h(point(0,1,0))"
        '''
def horner(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the value of P(a) calculated with Horner's method. With horner(liste_alpha_i,liste_x_i,x), evals an interpolation polynomial from the divided differences at x.
        Related: convert, base, revlist
        Examples:
        horner(x^2+1,2);horner([1,0,1],2);horner(x^2+y*x+y^3-1,2,y); X:=[0.0,1.0,2.0]; A:=lagrange(X,exp,lagrange); horner(A,X,1.5);"
        '''
def hybrid_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving a system of numerical equations.
        Usage: ybrid_solve(Opt)
        Related: fsolve
        Examples:
         fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)"
        '''
def hybridj_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving a system of numerical equations.
        Usage: ybridj_solve(Opt)
        Related: fsolve
        Examples:
         fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)"
        '''
def hybrids_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving a system of numerical equations.
        Usage: ybrids_solve(Opt)
        Related: fsolve
        Examples:
         fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)"
        '''
def hybridsj_solver(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Argument for fsolve giving the method for solving a system of numerical equations.
        Usage: ybridsj_solve(Opt)
        Related: fsolve
        Examples:
         fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],dnewton_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrid_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybrids_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],hybridsj_solver); fsolve([x^2+y-2,x+y^2-2],[x,y],[2,2],newtonj_solver)"
        '''
def hyp2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Transforms the hyperbolic functions with the exponential function
        Related: halftan_hyp2exp
        Examples:
        hyp2exp(cosh(x))"
        '''
def hyperbola(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: hyperbola(F1,F2,M)=hyperbole focus F1,F2 through M or (|MF1-MF2|=2*a geo2d) and hyperbola(p(x,y)) draws the conic if deg(p)=2.
        Related: ellipse, parabola
        Examples:
        hyperbola(-1,1,point(1+i));hyperbola(-1,1,sqrt(5)-1);hyperbola(point(-1,0,0),point(1,0,0),point(1,1,1));hyperbola(x^2-y^2+y+2)"
        '''
def hypercube_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Constructs and returns the hypercube graph in dimension n (with 2^n vertices).
        Usage: hypercube_graph(Intg(n))
        Related: graph
        Examples:
        hypercube_graph(3)"
        '''
def iPart(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the argument without its fractional part (type=DOM_FLOAT).
        Related: fPart, floor, trunc
        Examples:
        iPart(4.3);iPart(sqrt(2));iPart(4.3,sqrt(2))"
        '''
def iabcuv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns [u,v] such as au+bv=c for 3 integers a,b,c.
        Related: iegcd, abcuv
        Examples:
        iabcuv(21,28,7);iabcuv(21,28,14);iabcuv(21,28,1)"
        '''
def ibasis(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Basis of the intersection of two vector spaces
        Related: basis
        Examples:
        ibasis([[1,0,0],[0,1,0]],[[1,1,1],[0,0,1]])"
        '''
def ibpdv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Integration by parts of f(x)=u(x)*v'(x) with f(x) as 1st argument and v(x) (or 0) as 2nd argument. You can specify a variable of integration and also the calculus of the integrate (bounds a and b).
        Related: ibpu, int
        Examples:
        ibpdv(ln(x),x);ibpdv(ln(x),x,x,1,3);ibpdv(x*ln(x),x^2/2);ibpdv([x*ln(x),-1],0);ibpdv(ibpdv(ln(x),x,x,2,3),0,x,2,3)"
        '''
def ibpu(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Integration by parts of f(x)=u(x)*v'(x) with f(x) as 1st argument and u(x) (or 0) as 2nd argument. You can specify a variable of integration and also the calculus of the integrate (bounds a and b).
        Related: ibpdv, int
        Examples:
        ibpu(ln(x),ln(x));ibpu(ln(x),ln(x),x,1,3);ibpu(x*ln(x),ln(x));ibpu([x*ln(x),-1],0);ibpu(ibpu(ln(x),ln(x),x,2,3),0,x,2,3)"
        '''
def icdf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Inverse cumulated distribution function.
        Related: cdf, binomial_icdf, normald_icdf
        Examples:
        icdf(binomial,10,0.5,0.6);icdf(normald,0.0,1.0,0.975)"
        '''
def ichinrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Chinese remainders for integers.
        Related: gcd, fracmod, chinrem, chrem
        Examples:
        ichinrem([2,7],[3,5]);ichinrem([2%7,3%5]);ichinrem([2%7,3%5,1%9]);ichinrem([(x+1)%2,(x+2)%3,(3*x-1)%5])"
        '''
def ichrem(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Chinese remainders for integers.
        Usage: ichrem(LstIntg(a,p),LstIntg(b,q))
        Related: gcd, fracmod, chinrem, chrem
        Examples:
        ichinrem([2,7],[3,5]);ichinrem([2%7,3%5]);ichinrem([2%7,3%5,1%9]);ichinrem([(x+1)%2,(x+2)%3,(3*x-1)%5])"
        '''
def icomp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of compositions of n into k parts.
        Usage: icomp(Intg(n),Intg(k),[zeros=true||false])
        Related: sum
        Examples:
        icomp(4,2);icomp(6,3,zeros=false)"
        '''
def icontent(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: GCD of the integer coefficients of a polynomial.
        Examples:
        icontent(24x^3+6x^2-12x+18);icontent(24t^3+6t^2-12t+18,t)"
        '''
def icosahedron(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws an icosahedron with center A, vertex B and such that the plane ABC contains one vertex among the 5 nearest vertices from B.
        Related: octahedron, dodecahedron, cube, tetrahedron
        Examples:
        icosahedron([0,0,0],[sqrt(5),0,0],[1,2,0]);icosahedron(evalf([0,0,0],[3,2,4],[1,1,0]))"
        '''
def id(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Is the name of the identity function (ℝ^n -> ℝ^n).
        Related: sq, sqrt
        Examples:
        id(1,2,3)"
        '''
def identity(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the identity matrix of specified dimension n.
        Related: ranm
        Examples:
        identity(3);identity(5)"
        '''
def idivis(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of divisors of an integer.
        Related: divis, ifactors
        Examples:
        idivis(36);idivis([36,49])"
        '''
def idn(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the identity matrix of specified dimension n.
        Usage: idn(Intg(n))
        Related: ranm
        Examples:
        identity(3);identity(5)"
        '''
def iegcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extended greatest common divisor of 2 integers.
        Related: gcd, iabcuv, egcd
        Examples:
        iegcd(45,75);iegcd(21,28);iegcd(30,49)"
        '''
def ifactor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Factorization of an integer into prime factors.
        Related: factor, ecm_factor
        Examples:
        ifactor(50);ifactor(123456789)"
        '''
def ifactors(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of prime factors of an integer (each factor is followed by its multiplicity).
        Related: ifactor, factors
        Examples:
        ifactors(36);ifactors([36,52])"
        '''
def igamma(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Calculus of gamma at a point (a,x). If a and x>0, igamma(a,x)=int(e^{-t}*t^{a-1},t=0..x), (igamma(a,x,1)=igamma(a,x)/Gamma(a)).
        Related: Psi, Beta, Gamma, ugamma
        Examples:
        igamma(5.0,2.0);igamma(-5.1,2.1);igamma(5.0,2.0,1)"
        '''
def igcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the greatest common divisor of 2 polynomials of several variables or of 2 integers or of 2 rationals.
        Usage: igcd((Intg(a) or Poly),(Intg(b) or Poly))
        Related: lcm, euler, modgcd, ezgcd, psrgcd, heugcd, Gcd
        Examples:
        gcd(45,75);gcd(15/7,50/9);gcd(x^2-2*x+1,x^3-1);gcd(t^2-2*t+1,t^2+t-2);gcd((x^2-1)*(y^2-1)*z^2,x^3*y^3*z+(-(y^3))*z+x^3*z-z)"
        '''
def igcdex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Extended greatest common divisor of 2 integers.
        Usage: igcdex(Intg,Intg)
        Related: gcd, iabcuv, egcd
        Examples:
        iegcd(45,75);iegcd(21,28);iegcd(30,49)"
        '''
def ihermite(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Hermite normal form of a matrix with coefficients in ℤ : returns L,U such that L is invertible in ℤ, U upper triangular and U=L*A.
        Related: ismith
        Examples:
        ihermite([[9,-36,30], [-36,192,-180], [30,-180,180]]);ihermite([[1,2,3],[4,5,6],[7,8,9]])"
        '''
def ilaplace(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Inverse Laplace transform of a rational fraction
        Related: laplace, ztrans, invztrans, Heaviside
        Examples:
        ilaplace(1/(x^2+1)^2);ilaplace(s/(s^4-1),s,x);ilaplace(exp(-s)/s,s,x)"
        '''
def im(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the imaginary part of a complex number
        Related: re, conj
        Examples:
        im(1+2*i);im((1+2*i)^2);im([1+2*i,(1+2*i)^2])"
        '''
def imag(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the imaginary part of a complex number
        Usage: imag(Cplx)
        Related: re, conj
        Examples:
        im(1+2*i);im((1+2*i)^2);im([1+2*i,(1+2*i)^2])"
        '''
def image(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Image of a linear application of matrix M
        Related: ker, rref
        Examples:
        image([[1,2],[3,6]]);image([[1,2,3],[1,3,6],[2,5,9]])"
        '''
def implicitdiff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Implicit differentiation
        Usage: implicitdiff(constr,[depvars],y,diffvars)
        Related: diff
        Examples:
        implicitdiff(x^2*y+y^2=1,y,x);implicitdiff(R=P*V/T,P,T);implicitdiff([x^2+y=z,x+y*z=1],[y(x),z(x)],y,x);implicitdiff([x^2+y=z,x+y*z=1],[y(x),z(x)],[y,z],x);implicitdiff(y=x^2/z,y,x);implicitdiff(y=x^2/z,y,z);implicitdiff(y^3+x^2=1,y,x);implicitdiff(y^3+x^2=1,y,x,x);implicitdiff(a*x^3*y-2y/z=z^2,y(x,z),x);implicitdiff(a*x^3*y-2y/z=z^2,y(x,z),x,z);implicitdiff([-2x*z+y^2=1,x^2-exp(x*z)=y],[y(x),z(x)],y,x);implicitdiff([-2x*z+y^2=1,x^2-exp(x*z)=y],[y(x),z(x)],[y,z],x);implicitdiff([a*sin(u*v)+b*cos(w*x)=c,u+v+w+x=z,u*v+w*x=z],[u(x,z),v(x,z),w(x,z)],u,z);implicitdiff(x*y,-2x^3+15x^2*y+11y^3-24y=0,y(x),x$2);implicitdiff((x-u)^2+(y-v)^2,[x^2/4+y^2/9=1,(u-3)^2+(v+5)^2=1],[v(u,x),y(u,x)],u,x);implicitdiff(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,z,y],order_size=1);implicitdiff(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,z,y],order_size=2,[1,-1,0]); pd:=implicitdiff(x*y*z,-2x^3+15x^2*y+11y^3-24y=0,[x,z,y],order_size=4,[0,z,0]);pd[4,0,0]"
        '''
def implicitplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: plotimplicit(f(x,y),x,y) or plotimplicit(f(x,y),[x,y]) graph of f(x,y)=0.
        Usage: implicitplot(Expr,Var1,Var2)
        Related: plotcontour, unfactored, plotinequation
        Examples:
        plotimplicit(x^2+y^2-1,x,y);plotimplicit(x^4+y^4=x^2-y^2);plotimplicit(x^2+y^2-1,x,y,unfactored);plotimplicit(x^2+4*y^3-1);plotimplicit(x^2+4*y^3-k)$(k=-5..5);plotimplicit(y^3=x^3-x^2,x,y,xstep=0.1,ystep=0.1);plotimplicit(y^3=x^3-x^2,[x,y],xstep=0.1,ystep=0.1);plotimplicit((x+5)^2+(y+4)^2-1,x=-6..-4,y=-5..-3);plotimplicit((x+5)^2+(y+4)^2-1,[x=-6..-4,y=-5..-3])"
        '''
def import_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graph constructed from instructions in the file 'path/to/graphname.dot' (in dot format), or ""undef"" on failure.
        Usage: import_graph(Str(""path/to/graphname[.dot]""))
        Examples:
        import_graph(""K5.dot"")"
        '''
def inString(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Tests if e is in the string l (returns -1 or k if l[k]=e).
        Related: contains
        Examples:
        inString(""abcd"",""b"");inString(""abcd"",""e"")"
        '''
def in_ideal(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Checks whether a polynomial or list of polynomials belongs to an ideal given by a Grobner basis (2nd argument) with respect to a variable list.
        Related: gbasis, greduce
        Examples:
        in_ideal((x+y)^2,[y^2,x^2+2*x*y],[x,y]);in_ideal(x+y,[y^2,x^2+2*x*y],[x,y])"
        '''
def incidence_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the incidence matrix of G whose rows are indexed by the vertices and columns by the edges (in order defined by the command 'edges').
        Usage: incidence_matrix(Graph(G))
        Related: incident_edges
        Examples:
        incidence_matrix(graph(""tetrahedron""))"
        '''
def incident_edges(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of all edges incident to the vertex v of G (or to the vertices in the list v).
        Usage: incident_edges(Graph(G),Vrtx(v))
        Related: adjacency_matrix, vertex_degree, incidence_matrix, neighbors
        Examples:
        incident_edges(cycle_graph(8),[1,5,7])"
        '''
def incircle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: incircle(A,B,C) draws the incircle of the ABC triangle.
        Related: excircle, circumcircle
        Examples:
        incircle(0,1,1+i)"
        '''
def increasing_power(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pseudo-variable to control display of polynomial
        Usage: increasing_power(:=Intg(0 or 1))
        Related: cas_setup
        Examples:
         increasing_power:=1; increasing_power:=0"
        '''
def independence_number(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the independence number of G.
        Usage: independence_number(Graph(G))
        Related: clique_number, graph_complement, maximum_clique, maximum_independent_set
        Examples:
        independence_number(complete_graph(3,4))"
        '''
def indets(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of variables in the expression.
        Usage: indets(Expr)
        Related: has, lvar
        Examples:
        lname(exp(x)*2*sin(y))"
        '''
def index(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Index of the first position of an object in a list, a string or a set or return an error message.
        Usage: index(Vect,Expr)
        Related: find, member
        Examples:
        index([3,x,1,2,1,3],1);index([0,1,3,2,4,2,5],2);index(%{4,3,1,2%},1);index(""abracadabrant"",""c"")"
        '''
def induced_subgraph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the subgraph of G induced by the vertices in list V.
        Usage: induced_subgraph(Graph(G),Lst(V))
        Related: subgraph
        Examples:
        induced_subgraph(cycle_graph(6),[1,2,6])"
        '''
def inequationplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Shows the graph of the solution of inequations with 2 variables.
        Usage: inequationplot(Expr,[x=xrange,y=yrange],[xstep],[ystep])
        Related: plotfunc, plotcontour, plotdensity, plotimplicit
        Examples:
        plotinequation(x^2-y^2<3);plotinequation(x^2-y^2<3,[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1);plotinequation(3-(x^2-y^2),[x=-2..2,y=-2..2],xstep=0.1,ystep=0.1);plotinequation([x+y>3,x^2<y],[x,y],xstep=0.2,ystep=0.2)"
        '''
def inf(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: String concatenation or addition element by element of 2 expressions or 2 lists or 2 matrix or of 2 points (infixed operator).
        Related: concat, .+
        Examples:
         ""bon""+""jour""; 1+2; [1,2]+[3,4,5]; point(2+i)+point(1+2i); point(1+2*i)+2+i"
        '''
def infinity(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Unsigned infinity
        Related: +infinity, -infinity
        "
        '''
def insert(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns l where the element b is of index n.
        Related: tail, mid, remove, suppress
        Examples:
        insert([0,1,2,3],2,5);insert(""0123"",2,""5"")"
        '''
def insmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Installs a dynamic module creates the commands that are, for example, in the file libprogfr.so putting the pwd of this file.
        Related: rmmod, lsmod
        Examples:
        insmod(""/home/parisse/giac/src/libprogfr.so"")"
        '''
def int(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Indefinite integral, you can specify a variable of integration or the calculus of the integrate (bounds a and b).
        Related: Int, diff, plotarea, romberg, gaussquad
        Examples:
        int(1/x);int(1/(4+t^2),t);int(1/(1-x^4),x,2,3)"
        '''
def intDiv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euclidean quotient of 2 integers.
        Usage: intDiv(Intg(a),Intg(b))
        Related: irem, smod, quo
        Examples:
        iquo(125,15);iquo(125,41);iquo(-7,3);iquo(25+12*i,5+7*i)"
        '''
def integer(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: DOM_INT or integer or DOM_int is an integer which is the type of an integer variable, it is the value of the type command. DOM_INT is used for integers < 2^31. It is also an option of the assume command.
        Usage: ntege(Opt)
        Related: type, assume, DOM_FLOAT, DOM_SYMBOLIC
        Examples:
         type(2^31); DOM_INT+0; assume(a,DOM_INT); assume(a,integer); a:=2;type(a)"
        '''
def integrate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Indefinite integral, you can specify a variable of integration or the calculus of the integrate (bounds a and b).
        Usage: integrate(Expr,[Var(x)],[Real(a)],[Real(b)])
        Related: Int, diff, plotarea, romberg, gaussquad
        Examples:
        integrate(1/x);integrate(1/(4+t^2),t);int(1/(1-x^4),x,2,3)"
        '''
def integrer(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Indefinite integral, you can specify a variable of integration or the calculus of the integrate (bounds a and b).
        Usage: integrer(Expr,[Var(x)],[Real(a)],[Real(b)])
        Related: Int, diff, plotarea, romberg, gaussquad
        Examples:
        int(1/x);int(1/(4+t^2),t);int(1/(1-x^4),x,2,3)"
        '''
def inter(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: With 2 arguments (resp 3 arguments) gives the intersection of 2 curves or surfaces as a vector (resp a point close to the point given as third argument).
        Related: intersect, head
        Examples:
        inter(line(i,1-i),circle(0,1));inter(line(i,1-i),circle(0,1),point(-i));inter(plane(x=y+3),cone([0,0,0],[0,0,1],pi/6));inter(plane(x=y+3),cone([0,0,0],[0,0,1],pi/6));inter(line(i,1-i),circle(0,1))[0]"
        '''
def interactive_odeplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws (in DispG) a solution for each point t0+i*y0 clicked with the mouse (Esc=halt).
        Usage: interactive_odeplot(Expr,VectVar)
        Related: odeplot, plotfield, odesolve, desolve
        Examples:
        interactive_plotode(sin(t*y),[t,y]);interactive_plotode(-t*y,[t,y])"
        '''
def interactive_plotode(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws (in DispG) a solution for each point t0+i*y0 clicked with the mouse (Esc=halt).
        Related: odeplot, plotfield, odesolve, desolve
        Examples:
        interactive_plotode(sin(t*y),[t,y]);interactive_plotode(-t*y,[t,y])"
        '''
def interp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the polynomial of degree n-1 such that P(xk)=yk=f(x_k) k=0..n-1 or the list of divided differences if the last argument is lagrange
        Usage: interp((Lst_xk,Lst_yk)||Mtrx_2*n||(Lst_xk,Fnc(f)),[Var||[]||lagrange])
        Related: spline
        Examples:
        lagrange([1,3,4],[0,1,2]);lagrange([1,3,4],[0,1,2],t); f(x):=exp(-x); lagrange([1,3,4],f);lagrange([[1,3,4],[0,1,2]]);lagrange([1,3,4],[0,1,2],[]); X:=[1,3,4]; divdiff:=lagrange(X,[0,1,2],lagrange); horner(divdiff,X,5);;lagrange([[1,3,4],[0,1,2]],y);lagrange([-1,0,1],[1/e-1,0,e-1]); f(x):=exp(x)-1;lagrange([-1,0,1],f);lagrange([0,1,2],[1,exp(1),exp(2)],lagrange);lagrange([0,1,2],exp,lagrange)"
        '''
def interval(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"No help available for  .. 
        Best match has score 1
        See also: 1/ [..] 2/ @@ 
        "
        '''
def interval2center(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the center of the interval or the object.
        Related: center2interval
        Examples:
        interval2center(2..5);interval2center(3)"
        '''
def interval_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the interval graph with respect to intervals a..b, c..d, ... on the real line. It has one vertex per interval and two vertices are connected iff the corresponding intervals intersect.
        Usage: interval_graph(Seq||Lst(a..b,c..d,...))
        Related: graph, kneser_graph
        Examples:
        interval_graph([0..8,1..pi,exp(1)..20,7..18,11..14,17..24,23..25])"
        '''
def inv(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the inverse of an expression or matrix.
        Related: Inv
        Examples:
        inv(9/5);inv([[1,2],[3,4]])"
        '''
def inverse(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the inverse of an expression or matrix.
        Usage: inverse(Expr||Mtrx)
        Related: Inv
        Examples:
        inv(9/5);inv([[1,2],[3,4]])"
        '''
def inversion(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: inversion(C,k,A)=point A1 such as A1 on line(C,A) and mes_alg(CA1*CA)=k
        Related: homothety
        Examples:
        inversion(i,1/2,1+i);inversion([1,1,1],-1/2,point(-1,-1,-1)); inver:=inversion(i,1/2);inver(i); inver:=inversion([1,1,1],-1/2);inver(point(-1,-1,-1))"
        '''
def invisible_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a point.
        Usage: nvisible_poin(Opt)
        Related: display
        Examples:
         F:=display(point(2+1.5*i),point_point); F:=display(point(2+1.5*i),rhombus_point)"
        '''
def invlaplace(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Inverse Laplace transform of a rational fraction
        Usage: invlaplace(Expr,[Var],[IlapVar])
        Related: laplace, ztrans, invztrans, Heaviside
        Examples:
        ilaplace(1/(x^2+1)^2);ilaplace(s/(s^4-1),s,x);ilaplace(exp(-s)/s,s,x)"
        '''
def invztrans(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Inverse z transform of a rational fraction
        Related: ztrans, laplace, invlaplace
        Examples:
        invztrans(1/(x^2+1)^2);invztrans(z/(z^4-1),z,n)"
        '''
def iquo(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euclidean quotient of 2 integers.
        Related: irem, smod, quo
        Examples:
        iquo(125,15);iquo(125,41);iquo(-7,3);iquo(25+12*i,5+7*i)"
        '''
def iquorem(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euclidean quotient and remainder of 2 integers.
        Related: irem, iquo, quorem
        Examples:
        iquorem(125,15);iquorem(125,41);iquorem(25+12*i,5+7*i)"
        '''
def iratrecon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the fraction a/b such as b*Xpr=a mod n, -sqrt(n)/2<a<=sqrt(n)/2 and 0<=b<sqrt(n)/2.
        Usage: iratrecon(Expr(Xpr),Intg(n))
        Related: mod, smod
        Examples:
        fracmod(41,121)"
        '''
def irem(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Euclidean remainder of 2 integers.
        Related: iquo, smod, rem, mod
        Examples:
        irem(125,15);irem(125,41);irem(-7,3);irem(25+12*i,5+7*i)"
        '''
def isPrime(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Primality testing (=true or false).
        Usage: isPrime(Intg(a))
        Related: prevprime, nextprime, is_prime, is_pseudoprime
        Examples:
        isprime(1999);isprime(9856989898997);isprime(9856989898997789789)"
        '''
def is_acyclic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff digraph G has no topological ordering.
        Usage: is_acyclic(Graph(G))
        Related: topologic_sort, topological_sort
        Examples:
        is_acyclic(digraph(%{[c,a],[c,b],[c,d],[a,d],[b,d],[a,b]%}))"
        '''
def is_arborescence(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff the directed and unweighted graph G is an arborescence.
        Usage: is_arborescence(Graph(G))
        Related: is_acyclic, is_forest, is_tree
        Examples:
        is_arborescence(digraph(%{[1,2],[1,3]%}));is_arborescence(digraph(%{[1,2],[2,3],[3,1]%}))"
        '''
def is_biconnected(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is biconnected.
        Usage: is_biconnected(Graph(G))
        Related: biconnected_components, is_connected, is_triconnected
        Examples:
        is_biconnected(path_graph(5));is_biconnected(cycle_graph(5));is_biconnected(graph(""petersen""))"
        '''
def is_bipartite(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is bipartite graph [and assign to P the list of partitions represented as lists of vertices].
        Usage: is_bipartite(Graph(G),[Var(P)])
        Related: random_bipartite_graph, draw_graph
        Examples:
        is_bipartite(graph(""desargues""))"
        '''
def is_clique(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff undirected graph G is a clique (a complete graph).
        Usage: is_clique(Graph(G))
        Related: clique_number, induced_subgraph, maximum_clique
        Examples:
        is_clique(complete_graph(3))"
        '''
def is_collinear(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the points are aligned,2 if the points are the same and 0 otherwise.
        Related: is_concyclic
        Examples:
        is_collinear(0,i,1+i,2*i);is_collinear(point(0),point(1+i),point(2,2),point(-1-i));is_collinear(point(0,0,0),point(1,1,0),point(2,2,0),point(-1,-1,1))"
        '''
def is_concyclic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the points are on a circle and 0 otherwise.
        Related: is_collinear
        Examples:
        is_concyclic(0,i,1+i,1,1/2+i*(1/2+sqrt(2)/2));is_concyclic(1,-1,i,-i,1+i,-1-i)"
        '''
def is_conjugate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the 3 (resp 4) arguments are conjugated toward a circle (resp 2 lines) and 0 otherwise.
        Related: harmonic_conjugate, pole, polar
        Examples:
        is_conjugate(circle(0,1+i),point(1-i),point(3+i));is_conjugate(circle(0,1),point((1+i)/2),line(1+i,2));is_conjugate(circle(0,1),line(1+i,2),point((1+i)/2));is_conjugate(circle(0,1),line(1+i,2),line((1+i)/2,0));is_conjugate(point(1+i),point(3+i),point(i),point(3/2+i));is_conjugate(line(0,1+i),line(2,3+i),line(3,4+i),line(3/2,5/2+i));is_conjugate(line(0,1+i),line(0,3+i),line(0,i),line(0,3/2+i));is_conjugate(line(0,1+i),line(0,3+i),line(0,i),point(3/2+i));is_conjugate(line(0,1+i),line(0,3+i),point(3/2+i),line(0,i));is_conjugate(line(0,1+i),line(0,3+i),point(i),point(3/2+i))"
        '''
def is_connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is connected.
        Usage: is_connected(Graph(G))
        Related: connected_components, is_biconnected, is_triconnected
        Examples:
        is_connected(path_graph(5));is_connected(cycle_graph(5));is_connected(graph_complement(complete_graph(3,4)))"
        '''
def is_coplanar(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Test if 4 points are in the same plan.
        Examples:
        is_coplanar([0,0,0],[1,2,-3],[1,1,-2],[2,1,-3])"
        '''
def is_cospherical(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Test if 5 points are on the same sphere.
        Usage: is_cospherical(Pnt,Pnt,Pnt,Pnt)
        Examples:
        is_cospherical([-1,0,0],[1,0,0],[0,1,0],[0,-1,0],[0,0,1])"
        '''
def is_cut_set(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true if removing edges in the list E from G increases the number of connected components of G, else returns false.
        Usage: is_cut_set(Graph(G),Lst(E))
        Related: connected_components, delete_edge
        Examples:
        is_cut_set(graph(trail(1,2,3,4,5,6,4,1,3)),[[1,4],[3,4]])"
        '''
def is_cycle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the argument is a cycle and 0 otherwise.
        Related: is_permu, cycle2perm, cycles2permu
        Examples:
        is_cycle([1,0,5]);is_cycle([1,0,5,1])"
        '''
def is_directed(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is directed.
        Usage: is_directed(Graph(G))
        Related: is_weighted, digraph, make_directed
        Examples:
        is_directed(digraph(3))"
        '''
def is_element(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the point is on the geometric object and 0 otherwise.
        Related: element, member, contains
        Examples:
        is_element(point(i),square(0,1));is_element(point(i),circle(point(0),point(2)))"
        '''
def is_equilateral(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the 3 points (or the object) built an equilateral triangle and 0 otherwise.
        Related: is_isosceles, is_rectangle
        Examples:
        is_equilateral(0,2,1+i*sqrt(3));is_equilateral(point(0),point(1+i),point(2,2));is_equilateral(triangle(0,2,1+i*sqrt(3)))"
        '''
def is_eulerian(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Return true iff G is eulerian [and write the corresponding eulerian trail to T].
        Usage: is_eulerian(Graph(G),[Var(T)])
        Related: path_graph, trail
        Examples:
        is_eulerian(complete_graph(4));is_eulerian(complete_graph(5));is_eulerian(graph(trail(1,2,3,1,4,3,5,4)),T);is_eulerian(digraph(%{[1,4],[1,3],[2,1],[3,2],[4,5],[5,1]%}))"
        '''
def is_forest(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is a forest (disjoint union of trees).
        Usage: is_forest(Graph(G))
        Related: is_tree
        Examples:
        is_forest(graph(trail(1,2,3,4),trail(5,2,6,7),trail(8,9,10)))"
        '''
def is_graphic_sequence(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff there exists a graph with degree sequence equal to the list L.
        Usage: is_graphic_sequence(Lst(L))
        Related: degree_sequence, sequence_graph
        Examples:
        is_graphic_sequence([3,2,4,2,3,4,5,7])"
        '''
def is_hamiltonian(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true if G is a Hamiltonian graph (and stores the Hamiltonian circuit in hc if unassigned identifier is given), else returns false.
        Usage: is_hamiltonian(Graph(G),[Var(hc)])
        Related: traveling_salesman
        Examples:
        is_hamiltonian(graph(""petersen""));is_hamiltonian(hypercube_graph(5),C);is_hamiltonian(digraph(%{[1,2],[1,3],[2,3],[2,4],[3,2],[3,4],[4,1]%}))"
        '''
def is_harmonic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the 4 points are in a harmonic division and 0 otherwise.
        Related: is_conjugate
        Examples:
        is_harmonic(0,2,3/2,3);is_harmonic(0,1+i,1,i)"
        '''
def is_harmonic_circle_bundle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the circles built a beam, 2 if they have the same center, 3 if they are the same and 0 otherwise.
        Related: is_harmonic_line_bundle
        Examples:
        is_harmonic_circle_bundle([circle(0,i),circle(4,i),circle(0,point(1/2))]);is_harmonic_circle_bundle([circle(0,1+i),circle(2,1+i),circle(1+i,point(1-i))])"
        '''
def is_harmonic_line_bundle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the lines have a common point, 2 if they are parallels, 3 if they are the same and 0 otherwise.
        Related: is_harmonic_circle_bundle
        Examples:
        is_harmonic_line_bundle([line(0,1+i),line(0,2+i),line(0,1),line(0,3+i)]);is_harmonic_line_bundle([line(0,1+i),line(2,3+i),line(3,4+i),line(-1,i)])"
        '''
def is_inside(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Checks whether a point is inside a polygon or a circle.
        Related: is_element
        Examples:
        is_inside(point(0),circle(-1,1));is_inside(point(1-i),triangle([1,2-i,3+i]))"
        '''
def is_integer_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff the spectrum of G consists only of integers.
        Usage: is_integer_graph(Graph(G))
        Related: graph_spectrum
        Examples:
        is_integer_graph(graph(""levi""))"
        '''
def is_isomorphic(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true if the input graphs G1 and G2 are isomorphic, else returns false. If an unassigned identifier 'I' is given, the isomorphism is stored to it in form of a list.
        Usage: is_isomorphic(Graph(G1),Graph(G2),[Var(I)])
        Related: isomorphic_copy, permute_vertices
        Examples:
         G1:=graph(""petersen""); G2:=kneser_graph(5,2); is_isomorphic(G1,G2,I)"
        '''
def is_isosceles(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1, 2 or 3 if the 3 points (or the object) built an isosceles triangle with vertices 1, 2, or 3, returns 4 if the 3 points (or the object) built an equilateral triangle and 0 otherwise.
        Related: is_equilateral, is_right_triangle
        Examples:
        is_isosceles(0,i,1+i);is_isosceles(point(0),point(1+i),point(2,2));is_isosceles(triangle(0,i,1+i))"
        '''
def is_network(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true if G is a network with the source s and sink t, else returns false. If s,t are not given, the output is a sequence of two sets of vertices: sources and sinks.
        Usage: is_network(Graph(G),[Vrtx(s),Vrtx(t)])
        Related: random_network, maxflow
        Examples:
        is_network(digraph(trail(1,2,3,4,5,6,4,7)));is_network(digraph(trail(1,2,3,4,5,6,4,7)),1,7);is_network(digraph(trail(1,2,3,4,5,6,4,1)))"
        '''
def is_orthogonal(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the 2 circles are orthogonal (orthogonal tangents at a point of intersection) or if the 2 lines are orthogonal and 0 otherwise.
        Related: is_parallel, is_perpendicular
        Examples:
        is_orthogonal(line(0,1+i),line(1,i));is_orthogonal(circle(0,1+i),circle(2,1+i));is_orthogonal(line([2,3,-2],[-1,-1,-1]),line([1,0,0],[1,2,8]))"
        '''
def is_parallel(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if 2 lines are parallel and 0 otherwise.
        Related: is_perpendicular
        Examples:
        is_parallel(line(0,i),line(1,1+i));is_parallel(line([2,3,-2],[-1,-1,-1]),plane([-1,-1,-1],[1,2,-3],[0,0,0]));is_parallel(line([0,0,0],[-1,-1,-1]),line([2,3,-2],[-1,-1,-1]))"
        '''
def is_parallelogram(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1,2,3 or 4 if the 4 points (or the object) built a parallelogram, (2 for a rhombus, 3 for a rectangle, 4 for a square) and 0 otherwise.
        Related: est_rectangle, is_square, is_rhombus
        Examples:
        is_parallelogram(0,i,1+i,1);is_parallelogram(1,-1,i,-i);is_parallelogram(sommets(parallelogram(1,-1,-i,C)))"
        '''
def is_permu(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the argument is a permutation and 0 otherwise
        Related: is_cycle, permu2cycles
        Examples:
        is_permu([4,2,3,1]);is_permu([4,2,3,1,0])"
        '''
def is_perpendicular(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if 2 lines are perpendicular
        Related: is_parallel, is_orthogonal
        Examples:
        is_perpendicular(line(0,i),line(1,1+i));is_perpendicular(line([2,3,-2],[-1,-1,-1]),line([1,0,0],[1,2,8]));is_perpendicular(plane([0,0,0],[1,2,-3],[1,1,-2]),plane([-1,-1,-1],[1,2,-3],[0,0,0]));is_perpendicular(line([2,3,-2],[-1,-1,-1]),plane([0,0,0],[1,2,-3],[1,1,-2]))"
        '''
def is_planar(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is planar.
        Usage: is_planar(Graph(G))
        Related: draw_graph, random_planar
        Examples:
        is_planar(complete_graph(4));is_planar(complete_graph(5))"
        '''
def is_prime(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Mixed or ""p-1"" Pocklington [1] or APRCL test [2] (returns the coefficients for a proof of primality, 1 or 0)
        Related: prevprime, nextprime, is_pseudoprime, isprime
        Examples:
        is_prime(1999);is_prime(9856989898997);is_prime(9856989898997789789);is_prime(9856989898997789789,1)"
        '''
def is_pseudoprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Pseudo-prime test (0 not prime, 1 probably prime, 2 prime)
        Related: prevprime, nextprime, is_prime
        Examples:
        is_pseudoprime(1999);is_pseudoprime(9856989898997);is_pseudoprime(9856989898997789789)"
        '''
def is_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1, 2 or 3 if the 3 points (or the object) built an rectangular triangle with vertex 1, 2 or 3 and 0 otherwise [or 1 if the 4 points (or the object) built a rectangle, 2 if the 4 points (or the object) built a square and 0 otherwise].
        Related: is_equilateral, is_isosceles, is_parallelogram, is_rhombus, is_square
        Examples:
        is_rectangle(0,i,1+i);is_rectangle(point(0),point(1+i),point(2,2));is_rectangle(triangle(0,i,1+i));is_rectangle(point(0),point(2,2),point(1,3),point(-1,1));is_rectangle(rectangle(point(0),point(2,2),1/2));is_rectangle(sommets(rectangle(point(0),point(2,2),1/2)))"
        '''
def is_regular(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff max and min degrees of G are equal (if G is directed then out- and in-degrees must be equal for each vertex of G).
        Usage: is_regular(Graph(G))
        Related: degree_sequence, maximum_degree, minimum_degree, random_regular_graph, vertex_degree
        Examples:
        is_regular(complete_graph(5))"
        '''
def is_rhombus(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 or 2 if the 4 points (or the object) built a rhombus (2 for a square) and 0 otherwise.
        Related: est_rectangle, is_parallelogram, is_square
        Examples:
        is_rhombus(0,i,1+i,1);is_rhombus(1,-1,i,-i);is_rhombus(sommets(rhombus(1,-1,pi/4,C,D)))"
        '''
def is_square(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns 1 if the 4 points built a square and 0 otherwise.
        Related: est_rectangle, is_parallelogram, is_rhombus
        Examples:
        is_square(0,i,1+i,1);is_square(1,-1,i,-i);is_square(sommets(square(0,i,C,D)))"
        '''
def is_strongly_connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff digraph G is strongly connected.
        Usage: is_strongly_connected(Graph(G))
        Related: connected_components, is_connected, strongly_connected_components
        Examples:
        is_strongly_connected(digraph([1,2,3],%{[1,2],[1,3],[2,3],[3,2]%}))"
        '''
def is_strongly_regular(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is strongly regular and optionally outputs srg=[k,l,m] where k is the vertex degree and l resp. m is the number of common neighbors for adjacent resp. non-adjacent vertices.
        Usage: is_strongly_regular(Graph(G),[Var(srg)])
        Related: is_regular, adjacency_matrix, seidel_spectrum
        Examples:
        is_strongly_regular(graph(""clebsch""));is_strongly_regular(graph(""shrikhande""),s); s"
        '''
def is_tournament(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is a tournament.
        Usage: is_tournament(Graph(G))
        Related: has_edge, random_tournament
        Examples:
        is_tournament(digraph(%{[1,2],[2,3],[3,1]%}))"
        '''
def is_tree(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is a tree.
        Usage: is_tree(Graph(G))
        Related: is_forest, random_tree, tree_height
        Examples:
        is_tree(random_tree(15));is_tree(path_graph(4));is_tree(cycle_graph(5))"
        '''
def is_triconnected(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is triconnected.
        Usage: is_triconnected(Graph(G))
        Related: is_connected, is_biconnected
        Examples:
        is_triconnected(graph(""soccerball""));is_triconnected(graph(""petersen""));is_triconnected(cycle_graph(5))"
        '''
def is_two_edge_connected(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff undirected graph G is two-edge-connected (has no bridges).
        Usage: is_two_edge_connected(Graph(G))
        Related: two_edge_connected_components, edge_connectivity
        Examples:
        is_two_edge_connected(cycle_graph(4));is_two_edge_connected(path_graph(4))"
        '''
def is_vertex_colorable(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff the vertices of G can be colored by using at most k colors. If true is returned and an identifier col is given, the colors of the vertices are stored in it.
        Usage: is_vertex_colorable(Graph(G),Intg(k),[Var(col)])
        Related: greedy_color, chromatic_number
        Examples:
        is_vertex_colorable(graph(""petersen""),2);is_vertex_colorable(graph(""petersen""),3,cols)"
        '''
def is_weighted(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns true iff G is weighted.
        Usage: is_weighted(Graph(G))
        Related: get_edge_weight, make_weighted, set_edge_weight, weight_matrix
        Examples:
        is_weighted(graph(%{[a,b],[b,c]%});is_weighted(graph(%{[[a,b],2],[[b,c],3]%})"
        '''
def ismith(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Smith normal form of a matrix with coefficients in ℤ : returns U,B,V such that U and V invertible in ℤ, B diagonal, B[j,j] divide B[j+1,j+1] and B=U*A*V.
        Related: ihermite, smith
        Examples:
        ismith([[9,-36,30],[-36,192,-180],[30,-180,180]]);ismith([[1,2,3],[4,5,6],[7,8,9]])"
        '''
def isobarycenter(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: isobarycenter(A,B,C,...) draws the isobarycenter of the n points A,B,C,...
        Related: barycenter, midpoint
        Examples:
        isobarycenter(-1,1-i,i)"
        '''
def isom(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Find elements of a 2-d or 3-d isometry
        Related: mkisom
        Examples:
        isom([[0,1],[1,0]])"
        '''
def isomorphic_copy(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a copy of G with neighbors structure reordered according to sigma.
        Usage: isomorphic_copy(Graph(G),Permu(sigma))
        Related: graph_vertices, permute_vertices, relabel_vertices
        Examples:
        isomorphic_copy(cycle_graph(5),randperm(5))"
        '''
def isopolygon(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws a regular polygon having abs(n) vertices, given if n>0 by 2 vertices (or 2 vertices and 1 point of the plane) and  if n<0 by its center and 1 vertex (or its center, 1 vertex and 1 point of the plane).
        Related: polygon, hexagon
        Examples:
        isopolygon(0,1,5);isopolygon(0,1,-5);isopolygon(point(0,0,0),point(3,3,3),point(0,0,3),5);isopolygon(point(0,0,0),point(3,3,3),point(0,0,3),-5)"
        '''
def isosceles_triangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the isosceles triangle ABC AB=AC et angle(AB,AC)=t (or in the plane ABP angle(AB,AC)=angle(AB,AP) or angle(AB,AC)=t).
        Related: triangle
        Examples:
        isosceles_triangle(i,1,pi/4);isosceles_triangle(1,i,pi/4,C);isosceles_triangle(point(0,0,0),point(3,3,3),point(0,0,3));isosceles_triangle(point(0,0,0),point(3,3,3),[point(0,0,3),pi/4],C)"
        '''
def isprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Primality testing (=true or false).
        Related: prevprime, nextprime, is_prime, is_pseudoprime
        Examples:
        isprime(1999);isprime(9856989898997);isprime(9856989898997789789)"
        '''
def ithprime(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n-th prime number less than 2.10^8.
        Related: nextprime, prevprime
        Examples:
        ithprime(1229);ithprime(1000)"
        '''
def jacobi_equation(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Jacobi equation for stationary function y0(x) in a problem of minimizing the functional int(f(x,y,y'),x=a..b).
        Usage: jacobi_equation(Expr(f),Var(x),Var(y),Expr(y0),Var(h),Real(a))
        Related: conjugate_equation, euler_lagrange
        Examples:
        jacobi_equation(-1/2*y'(t)^2+y(t)^2/2,t,y,sin(t),h,0)"
        '''
def jacobi_linsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Resolution of a linear system  A*X=b  by the iterative Jacobi method with eps as error margin  and a number of iterations inferior to maxiter.
        Related: gauss_seidel_linsolve, linsolve
        Examples:
         a:=[[100,2],[2,100]];jacobi_linsolve(a,[0,1],1e-12);; a:=[[100,2],[2,100]];jacobi_linsolve(table(a),[0,1],1e-12); "
        '''
def jacobi_symbol(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Jacobi symbol
        Related: legendre_symbol
        Examples:
        jacobi_symbol(132,5);jacobi_symbol(132,25)"
        '''
def jordan(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list made by the matrix of passage and the Jordan form of a matrix.
        Related: egv, egvl, rat_jordan
        Examples:
        jordan([[0,2],[1,0]]);jordan([[-2,-2,1],[-2,1,-2],[1,-2,-2]]);jordan([[1,1,-1,2,-1],[2,0,1,-4,-1],[0,1,1,1,1],[0,1,2,0,1],[0,0,-3,3,-1]])"
        '''
def kde(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Estimates the probability density function from which the (presumably independent) samples in list L are drawn.
        Usage: kde(Lst(L),[options])
        Related: random_variable, sample
        Examples:
        kernel_density([1,2,3,2],bandwidth=1/4,exact); X:=randvar(gammad,mean=5,stddev=2):;kernel_density(sample(X,500),bins=50); Y:=randvar(normal,mean=5,stddev=1.5):;plot(kernel_density(sample(Y,1000),bins=50,piecewise),x=0..10)"
        '''
def keep_pivot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the rref command.
        Related: rref
        Examples:
         rref([[1,1,0,0,-a1],[0,1,1,0,-a2],[0,0,1,1,-a3],[1,0,0,1,-a4]],keep_pivot)"
        '''
def ker(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Kernel of a linear application of matrix M
        Related: image, rref, Nullspace
        Examples:
        ker([[1,2],[3,6]]);ker([[1,2,3],[1,3,6],[2,5,9]])"
        '''
def kernel(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Kernel of a linear application of matrix M
        Usage: kernel(Mtrx)
        Related: image, rref, Nullspace
        Examples:
        ker([[1,2],[3,6]]);ker([[1,2,3],[1,3,6],[2,5,9]])"
        '''
def kernel_density(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Estimates the probability density function from which the (presumably independent) samples in list L are drawn.
        Usage: kernel_density(Lst(L),[options])
        Related: random_variable, sample
        Examples:
        kernel_density([1,2,3,2],bandwidth=1/4,exact); X:=randvar(gammad,mean=5,stddev=2):;kernel_density(sample(X,500),bins=50); Y:=randvar(normal,mean=5,stddev=1.5):;plot(kernel_density(sample(Y,1000),bins=50,piecewise),x=0..10)"
        '''
def kneser_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Kneser graph K(n,k) with comb(n,k) vertices (n<=20).
        Usage: kneser_graph(Intg(n),Intg(k))
        Related: odd_graph
        Examples:
        kneser_graph(5,2)"
        '''
def kolmogorovd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Kolmogorov-Smirnov distribution, 1-2*sum((-1)^(k-1)*exp(-k^2*x^2),k,1,inf)
        Examples:
        kolmogorovd(1.36)"
        '''
def kolmogorovt(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Kolmogorov-Smirnov adequation test to a continuous distribution law, between 2 samples l1 l2 (unknown law) or between a sample l1 and a distribution law s.
        Related: chisquaret, normalt, studentt
        Examples:
        kolmogorovt(randvector(100,normald,0,1),randvector(100,normald,0,1));kolmogorovt(randvector(100,normald,0,1),randvector(100,normald,3,1));kolmogorovt(randvector(100,normald,0,1),normald(0,1));kolmogorovt(randvector(100,normald,0,1),student(2))"
        '''
def kovacicsols(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Solves a linear homogeneous second-order ODE eq for y(x) with rational coefficients in variable x.
        Usage: kovacicsols(Expr||Lst(eq),[Var(x),[Var(y)]])
        Related: desolve
        Examples:
        kovacicsols(y''=y*(1/x-3/16/x^2));kovacicsols(y''-y*27/(36*(x-1)^2),x,y);kovacicsols(x''+3*(t^2-t+1)/(16*(t-1)^2*t^2)*x,t,x);kovacicsols(y''+y'=6y/x^2);kovacicsols(y''+(19-x^2)*y=0,x,y);kovacicsols((1+x^2)^2*y''+3y=0,x,y);kovacicsols([48t*(t+1)*(5t-4),8*(25t+16)*(t-2),-(5t+68)],t)"
        '''
def kspaths(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a list of k shortest paths from s to t in the (weighted) (di)graph G.
        Usage: kspaths(Graph(G),Vrtx(s),Vrtx(t),Intg(k))
        Related: dijkstra, shortest_path
        Examples:
        kspaths(digraph(%{[[""C"",""D""],3],[[""C"",""E""],2],[[""D"",""F""],4],[[""E"",""D""],1],[[""E"",""F""],2],[[""E"",""G""],3],[[""F"",""G""],2],[[""F"",""H""],1],[[""G"",""H""],2]%}),""C"",""H"",5);kspaths(graph(""soccerball""),3,33,4)"
        '''
def l1norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the l1 norm of the vector=sum of the absolute values of its coordinates or matrix norm according to l1.
        Related: l2norm, maxnorm, matrix_norm
        Examples:
        ou triple norme d'une matrice selon l1.;l1norm([3,-4,2]);l1norm([[1,2,3],[3,-9,6],[4,5,6]])"
        '''
def l2norm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the l2 norm of a vector = sqrt(x1^2+x2^2+...xn^2) or matrix norm induced by l2 norm.
        Usage: l2norm(Vect or Mtrx)
        Related: maxnorm, l1norm
        Examples:
        norm([1,2]);norm([1,2,3,-4]);norm([[1,2],[3,-4]]);norm([[1,2,3],[3,-9,6],[4,5,6]])"
        '''
def lagrange(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the polynomial of degree n-1 such that P(xk)=yk=f(x_k) k=0..n-1 or the list of divided differences if the last argument is lagrange
        Related: spline
        Examples:
        lagrange([1,3,4],[0,1,2]);lagrange([1,3,4],[0,1,2],t); f(x):=exp(-x); lagrange([1,3,4],f);lagrange([[1,3,4],[0,1,2]]);lagrange([1,3,4],[0,1,2],[]); X:=[1,3,4]; divdiff:=lagrange(X,[0,1,2],lagrange); horner(divdiff,X,5);;lagrange([[1,3,4],[0,1,2]],y);lagrange([-1,0,1],[1/e-1,0,e-1]); f(x):=exp(x)-1;lagrange([-1,0,1],f);lagrange([0,1,2],[1,exp(1),exp(2)],lagrange);lagrange([0,1,2],exp,lagrange)"
        '''
def laguerre(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n-th Laguerre polynomial
        Related: legendre, hermite
        Examples:
        laguerre(4)"
        '''
def laplace(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Laplace transform
        Related: invlaplace, ztrans, invztrans, Heaviside
        Examples:
        laplace(exp(x)*sin(x));laplace(sin(x)^2,x,s);laplace(Heaviside(x-1),x,s)"
        '''
def laplacian(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Laplacian of the expression Xpr with respect to the list of variables and laplacian(n) for n  integer or float integer returns the matrix of size n of the discret laplacian en dimension 1.
        Examples:
        -2;laplacian(exp(z)*cos(x*y),[x,y,z]);laplacian(3);laplacian(3.0)"
        '''
def laplacian_matrix(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the Laplacian matrix L=D-A of undirected graph G where D resp. A is the degree matrix resp. the adjacency matrix of G.
        Usage: laplacian_matrix(Graph(G),[normal])
        Related: adjacency_matrix, degree_sequence, number_of_spanning_trees
        Examples:
        laplacian_matrix(graph(trail(1,2,3,4,5,2)));laplacian_matrix(graph(trail(1,2,3,4,5,2)),normal)"
        '''
def latex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the evaluated expression written in latex.
        Related: mathml
        Examples:
        latex(1/2);latex((x^4-1)/(x^2+3))"
        '''
def lcf_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the graph constructed from LCF notation J[^k] given the list of integers J [and a positive integer k, by default 1].
        Usage: lcf_graph(Lst(J),[Intg(k)])
        Related: graph
        Examples:
        lcf_graph([-3,3],4)"
        '''
def lcm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the lowest common multiple of 2 polynomials of several variables or of 2 integers or of 2 rationals.
        Related: gcd
        Examples:
        lcm(6,4);lcm(1251,123);lcm(5/7,50/9);lcm(x^2-2*x+1,x^3-1);lcm(t^2-2*t+1,t^2+t-2);lcm((x^2-1)*(y^2-1)*z^2,x^3*y^3*z+(-(y^3))*z+x^3*z-z)"
        '''
def lcoeff(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the coefficient of the term of highest degree of a polynomial (l=leading).
        Related: tcoeff
        Examples:
        lcoeff(-2*x^3+x^2+7*x);lcoeff([-2,1,7,0])"
        '''
def ldegree(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the valuation (degree of the term of lowest degree) of the polynomial P.
        Usage: ldegree(Poly(P))
        Related: degree, tcoeff
        Examples:
        valuation(x^4+x^3);valuation([1,1,0,0,0]);valuation(x^5+3*x^2);valuation([5,0,0,3,0,0])"
        '''
def left(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the left part of an equality, of an interval, of a list or of a string.
        Related: right, mid, tail, head
        Examples:
        left(a=b);left(x^2+1=5);left(1..5);left(""abcdefg"",3)"
        '''
def left_rectangle(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the plotarea command and of the area command.
        Usage: eft_rectangl(Opt)
        Related: plotarea, area
        Examples:
         plotarea(x^2,x=0..1,5,trapezoid); plotarea(x^2,x=0..1,5,middle_point); plotarea(x^2,x=0..1,5,right_rectangle); plotarea(x^2,x=0..1,5,left_rectangle); area(x^2,x=0..1,5,middle_point); area(x^2,x=0..1,5,trapezoid)"
        '''
def legend(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: legend(za,""here"") (or legend([20,60],""here"")) ""here"" is written at the point of affix za (or at the pixel position [20,60]) and legend=[""m"",""s""] write ""m"",""s"" as units on the axis.
        Related: labels, angle
        Examples:
        legend(1+i,""Hello"");legend(point([0,2,3],""Hello"");legend(point(0,1),""Hello"",vert);legend(point(0,1,0),""Hello"",vert);legend(1+i,""Hello"",quadrant4,red);legend([30,20],""bonjour""); r:=evalf(sqrt(2));legend([30,20],string(r)); r:=evalf(sqrt(2));legend([30,20],r); legende=[""m"",""s""];point(1,1);; display(legend(1+i,""A""),red); point(2+i,legend=""2+i"",display=quadrant2+red); point([2,2*i],legend=""1+i"",display=quadrant2+red); polygon(2,1,i,2*i,legend=""1+i"",display=quadrant2+red)"
        '''
def legendre(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the n-th Legendre polynomial
        Examples:
        legendre(4)"
        '''
def legendre_symbol(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Legendre symbol.
        Related: jacobi_symbol
        Examples:
        legendre_symbol(132,5);legendre_symbol(132,25)"
        '''
def length(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the size of a list, a string or a sequence.
        Usage: length(Lst or Str or Seq)
        Related: sizes, dim, degree
        Examples:
        size([1,2,3]);size(""bonjour"");size(1,2,3)"
        '''
def lgcd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the greatest common divisor of a list of polynomials or of integers
        Related: gcd, lcm, euler, content
        Examples:
        lgcd([45,75,20,15]);lgcd([x^2-2*x+1,x^3-1,x-1]);lgcd(x^2-2*x+1,x^3-1,x-1)"
        '''
def lhs(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the left part of an equality, of an interval, of a list or of a string.
        Usage: lhs(Equal(a=b) or Interval(a..b) or Str,Intg)
        Related: right, mid, tail, head
        Examples:
        left(a=b);left(x^2+1=5);left(1..5);left(""abcdefg"",3)"
        '''
def ligne_chapeau_carre(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ap_square_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def ligne_chapeau_plat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ap_flat_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def ligne_chapeau_rond(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ap_round_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def ligne_polygonale(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the polygons joining for j fixed and for k=0..nrows, the points (xk,yk) where xk=element row k column 0 et yk=element row k column j ,when the xk are sorted (we obtain ncols-1 polygons).
        Usage: ligne_polygonale(Mtrx)
        Related: scatterplot, listplot, polygonscatterplot
        Examples:
        polygonplot([[1,2,3],[2,0,1],[-1,2,3]])"
        '''
def ligne_polygonale_pointee(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the points (xk,yk) and the polygons joining for j fixed and for k=0..nrows, the points (xk,yk) where xk=element row k column 0 et yk=element row k column j ,when the xk are sorted (we obtain ncols-1 polygons).
        Usage: ligne_polygonale_pointee(Mtrx)
        Related: scatterplot, polygonplot, listplot
        Examples:
        polygonscatterplot([[1,2,3],[2,0,1],[-1,2,3]])"
        '''
def ligne_tiret(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def ligne_tiret_point(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ashdot_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def ligne_tiret_pointpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command for a line.
        Usage: ashdotdot_lin(Opt)
        Related: display
        Examples:
         display(line(y=x),green+dash_line+line_width_2); d:=display(line(2+i,1),cap_round_line)"
        '''
def ligne_trait_plein(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command to display with color.
        Usage: lac(Opt)
        Related: display
        Examples:
         F:=display(point(2+1.5*i),red); F:=display(point(2+1.5*i),point_point+green)"
        '''
def limit(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Limit of an expression at a limit point (a or +/-infinity)(d=-1 for limit inf and +1 for limit sup).
        Related: series, taylor, taux_accroissement
        Examples:
        limit((n*tan(x)-tan(n*x))/(sin(n*x)-n*sin(x)),x,0);limit(sin(x)/(x^2-3*x),x,0);limit((2*x-1)/exp(1/(x-1)),x,+infinity);limit(exp(1/x),x,0,1);limit(exp(1/x),x,0,-1);limit(taux_accroissement(x^n,1,1+h),h,0)"
        '''
def limite(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Limit of an expression at a limit point (a or +/-infinity)(d=-1 for limit inf and +1 for limit sup).
        Usage: limite(Expr,Var,Val,[Dir(d)])
        Related: series, taylor, taux_accroissement
        Examples:
        limit((n*tan(x)-tan(n*x))/(sin(n*x)-n*sin(x)),x,0);limit(sin(x)/(x^2-3*x),x,0);limit((2*x-1)/exp(1/(x-1)),x,+infinity);limit(exp(1/x),x,0,1);limit(exp(1/x),x,0,-1);limit(taux_accroissement(x^n,1,1+h),h,0)"
        '''
def lin(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Linearization of exponentials
        Related: tlin, texpand
        Examples:
        lin(exp(x)^n);lin((exp(x)^3+exp(x))^2)"
        '''
def line(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: line(A,B) (resp line(A,slope=m) or line(A,[1,m]) or line(a*x+b*y+c=0) or line(a*x+b*y+c*z+d=0,aa*x+bb*y+cc*z+dd=0) or line(A,u)) draws the line AB (resp the line going through A with slope m or with direction vector u or of equation the argument) in the plane or in the 3D space.
        Related: point, plane, slope
        Examples:
        line(i,1+i);line(point(-i),point(1+i));line(1+i,slope=2);line([0,0,0],[1,1,1]);line(x+y=1);line(x+y+z=0,x+y=0);line([1+t,-1+t],t);line([1+t,2-t,-1+3*t],t);line(1-i,slope=slope(line(1,2i)))"
        '''
def line_graph(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the line graph of undirected graph G.
        Usage: line_graph(Graph(G))
        Related: plane_dual
        Examples:
        line_graph(hypercube_graph(3))"
        '''
def line_inter(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Gives one of the intersections of 2 curves or surfaces (or the intersection near A or not in L).
        Usage: line_inter(Curve,Curve,[Pnt(A)||LstPnt(L)])
        Related: intersect, head
        Examples:
        single_inter(line(i,1-i),line(0,1));single_inter(line(i,1-i),circle(0,1));single_inter(line(i,1+2*i),circle(0,1),[point(i)]);single_inter(line(-1-i,1+2*i),circle(0,1),point(-1));single_inter(circle(1,sqrt(2)),circle(0,1));single_inter(plane(x=y),plane(y=z));single_inter(line(x=y+1,y=2*z),plane(y=z))"
        '''
def line_paper(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws in the rectangle [xmin..xmax]*[ymin..ymax], the lines x=n*ux in the axes OxY of angle t!=0.
        Examples:
        line_paper(0.4,pi/3);line_paper(0.4,pi/3,x=-1..4,y=-2..2);line_paper(0.5,3*pi/4)"
        '''
def line_segments(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of the line_segments (1 line=segment) of the polyhedron P.
        Related: polyhedron
        Examples:
        line_segments(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]));line_segments(polyhedron([0,0,0],[0,5,0],[0,0,5],[1,2,6]))[2]"
        '''
def linear_interpolate(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Make a regular sample from a polygonal line defined by a 2 rows matrix
        Related: polygonplot
        Examples:
        linear_interpolate([[1,2,6,9],[3,4,6,7]],1,9,1)"
        '''
def linear_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the coefficients a and b of y=a*x+b ;it is the best line approx the points where the coordinates are the rows of A (or the 2 lists).
        Related: polynomial_regression, power_regression, logistic_regression
        Examples:
        linear_regression([[0.0,0.0],[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]]);linear_regression([0.0,1.0,2.0,3.0,4.0],[0.0,1.0,4.0,9.0,16.0])"
        '''
def linear_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the plot of y=a*x+b ;it is the best line approx the points where the coordinates are the rows of A (or the 2 lists).
        Related: polynomial_regression_plot, power_regression_plot
        Examples:
        linear_regression_plot([[0.0,0.0],[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]]);linear_regression_plot([0.0,1.0,2.0,3.0,4.0],[0.0,1.0,4.0,9.0,16.0])"
        '''
def lineariser(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Linearization of exponentials
        Usage: lineariser(Expr)
        Related: tlin, texpand
        Examples:
        lin(exp(x)^n);lin((exp(x)^3+exp(x))^2)"
        '''
def lineariser_trigo(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Trigonometric linearization
        Usage: lineariser_trigo(ExprTrig)
        Related: texpand, lin
        Examples:
        tlin(sin(x)^3);tlin(cos(x)*cos(y))"
        '''
def linfnorm(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Matrix norm induced by linfinity norm.
        Usage: linfnorm(Mtrx)
        Related: l1norm, l2norm, matrix_norm, frobenius_norm
        Examples:
        linfnorm([[1,2,3],[3,-9,6],[4,5,6]])"
        '''
def linsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Linear equations system solver.
        Related: solve, proot, simult, gaussjord, pivot, ref, conjugate_gradient
        Examples:
        linsolve([x+y+z=1,x-y=2,2*x-z=3],[x,y,z]);linsolve([m*x+y=a,x+m*y=b],[x,y]);linsolve([x+y-z-1,x-y+1,x-y-z-1]%2,[x,y,z]);linsolve([[3,4],[1,2]],[0,1]); p,l,u:=lu([[3,4],[1,2]]); linsolve(p,l,u,[0,1]) ;linsolve([2*x+y+z=1,x+y+2*z=1,x+2*y+z=4],[x,y,z]);linsolve([[2,1,1],[1,1,2],[1,2,1]],[1,1,4]); p,l,u:=lu([[2,1,1],[1,1,2],[1,2,1]]);linsolve(p,l,u,[1,1,4]); a:=[[100,2],[2,100]];linsolve(evalf(a),[0,1]);"
        '''
def linspace(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: linspace(a,b,n) creates a list of n elements at regular intervals between a and b, by default n=100 (compatibility with scilab).
        Examples:
        linspace(0,1,11)"
        '''
def lis_phrase(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Instruction in a program so that you can input a string and store it in var.
        Usage: is_phras([Str],Var(Var))
        Related: input
        Examples:
        InputStr(""nom?"",N)"
        '''
def list2exp(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Invert exp2list
        Related: exp2list
        Examples:
        list2exp([[3,9],[- 1,1]],[x, y]);list2exp(solve(x^2-1=0),x)"
        '''
def list2mat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the matrix with n columns and where terms are the list l completed eventually by 0.
        Related: mat2list
        Examples:
        list2mat([1,8,4,9],1);list2mat([1,8,4,9],2)"
        '''
def list_edge_attributes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of attributes assigned to edge e of G in form tag=value.
        Usage: list_edge_attributes(Graph(G),Edge(e))
        Related: set_edge_attribute, get_edge_attribute, discard_edge_attribute
        "
        '''
def list_graph_attributes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of graph attributes of G in form tag=value.
        Usage: list_graph_attributes(Graph(G))
        Related: set_graph_attribute, get_graph_attribute, discard_graph_attribute
        "
        '''
def list_vertex_attributes(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the list of attributes assigned to vertex v of G in form tag=value.
        Usage: list_vertex_attributes(Graph(G),Vrtx(v))
        Related: set_vertex_attribute, get_vertex_attribute, discard_vertex_attribute
        "
        '''
def listplot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Draws the polygonal line through the points of abscissa 0,...,n and ordinate l=[y0,...,yn] or the line through the points of abscissa the first M column and ordinate the second column.
        Related: polygonplot, scatterplot, polygonscatterplot
        Examples:
        listplot([13,10,15,16]);listplot([1,13],[2,10],[3,15],[4,16]);listplot([[0,13],[2,10],[4,15]])"
        '''
def lll(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: (S,A,L,O):=lll(M), short basis of a lattice (L*O=A*M=S).
        Examples:
        lll([[1234,3452,4521],[3425,2241,1543],[5643,3425,8721]])"
        '''
def ln(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Natural logarithm or Option of the convert or convertir command (id trig2exp).
        Related: exp, convert, trig2exp, log10
        Examples:
        ln(1);ln(e); convert(cos(x),ln)"
        '''
def lname(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of variables in the expression.
        Related: has, lvar
        Examples:
        lname(exp(x)*2*sin(y))"
        '''
def lncollect(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Collect logarithms. Applies ln(a)+n*ln(b)->ln(a*b^n) for integers n.
        Related: texpand
        Examples:
        lncollect(ln(x)+2*ln(y))"
        '''
def lnexpand(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Expands logarithms.
        Related: texpand, expexpand, trigexpand
        Examples:
        lnexpand(ln(3*x))"
        '''
def locus(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: locus(M,A) draws the locus of M (or locus(d,A) draws the envelope of d) when A:=element(C) (C is a curve). The example instructions below, must be written in a geometric level on different lines.
        Related: envelope, trace
        Examples:
         A:=element(circle(i,1+i));M:=homothety(0,2,A);locus(M,A); A:=element(line(x=0));d:=perpen_bisector(1,A);locus(d,A)"
        '''
def log(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Natural logarithm or Option of the convert or convertir command (id trig2exp).
        Related: exp, convert, trig2exp, log10
        Examples:
        ln(1);ln(e); convert(cos(x),ln)"
        '''
def log10(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Common logarithm (base 10).
        Related: alog10, ln
        Examples:
        log10(10)"
        '''
def logarithmic_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the coefficients a and b of y=a*ln(x)+b : it is the best logarithm which approx the points where the coordinates are the rows of A (or the 2 lists).
        Related: exponential_regression
        Examples:
        logarithmic_regression([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]]);logarithmic_regression([1.0,2.0,3.0,4.0],[1.0,4.0,9.0,16.0])"
        '''
def logarithmic_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the plot of y=a*ln(x)+b : it is the best logarithm which approx the points where the coordinates are the rows of A (or the 2 lists).
        Related: exponential_regression_plot
        Examples:
        logarithmic_regression_plot([[1.0,1.0],[2.0,4.0],[3.0,9.0],[4.0,16.0]]);logarithmic_regression_plot([1.0,2.0,3.0,4.0],[1.0,4.0,9.0,16.0])"
        '''
def logb(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Logarithm of base b.
        Related: log, log10
        Examples:
        logb(5,2);logb(7,10)"
        '''
def logistic_regression(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns y,y',C,y'max,xmax,R : y is a logistic function (sol of y'/y=a*y+b), such that y(x0)=y0 and where [y'(x0),y'(x0+1)...] is the best approximation of L.
        Related: polynomial_regression, power_regression, linear_regression
        Examples:
        logistic_regression(evalf([1,2,4,6,8,7,5]),1,2);logistic_regression([0.0,1.0,2.0,3.0,4.0],0.0,1.0)"
        '''
def logistic_regression_plot(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the plot of a logistic function y such that y(x0)=y0 and where [y'(x0),y'(x0+1)...] is the best approximation of L.
        Related: polynomial_regression_plot, power_regression_plot, linear_regression_plot
        Examples:
        logistic_regression_plot(evalf([1,2,4,6,8,7,5]),1,2);logistic_regression_plot([0.0,1.0,2.0,3.0,4.0],0.0,1.0)"
        '''
def lower(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the lower matrix (under the diagonal, included) or write lowercase
        Usage: lower(Mtrx||Strng)
        Related: diag, upper
        Examples:
        lower([[1,2,3],[4,5,6],[7,8,9]]);lower(""HELLO"")"
        '''
def lowest_common_ancestor(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the lowest common ancestor of nodes u and v in the tree graph T with root r, or the list of lowest common ancestors of all pairs [uk,vk].
        Usage: lowest_common_ancestor(Graph(T),Vrtx(r),Seq(u,v)||Lst([u1,v1],[u2,v2],...))
        Related: is_tree, tree_height
        Examples:
         T:=random_tree(30); lowest_common_ancestor(T,15,10,20); T:=random_tree(30); lowest_common_ancestor(T,15,[[10,20],[11,19]])"
        '''
def lowpass(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the result of applying a simple first-order lowpass RC filter with cutoff frequency c (the default samplerate is 44100) to the given signal s.
        Usage: lowpass(Lst(s),Real(c),[Intg(samplerate)])
        Related: highpass, moving_average
        Examples:
         f:=unapply(periodic(sign(x),x,-1/880,1/880),x):;s:=createwav(apply(f,soundsec(1))):;playsnd(lowpass(s,1000))"
        '''
def lp_assume(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_assum(Opt)
        Related: lpsolve
        "
        '''
def lp_bestprojection(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_bestprojectio(Opt)
        Related: lpsolve
        "
        '''
def lp_binary(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_binar(Opt)
        Related: lpsolve
        "
        '''
def lp_binaryvariables(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_binaryvariable(Opt)
        Related: lpsolve
        "
        '''
def lp_breadthfirst(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_breadthfirs(Opt)
        Related: lpsolve
        "
        '''
def lp_depthfirst(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_depthfirs(Opt)
        Related: lpsolve
        "
        '''
def lp_depthlimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_depthlimi(Opt)
        Related: lpsolve
        "
        '''
def lp_firstfractional(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_firstfractiona(Opt)
        Related: lpsolve
        "
        '''
def lp_gaptolerance(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_gaptoleranc(Opt)
        Related: lpsolve
        "
        '''
def lp_hybrid(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_hybri(Opt)
        Related: lpsolve
        "
        '''
def lp_initialpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_initialpoin(Opt)
        Related: lpsolve
        "
        '''
def lp_integer(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_intege(Opt)
        Related: lpsolve
        "
        '''
def lp_integertolerance(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_integertoleranc(Opt)
        Related: lpsolve
        "
        '''
def lp_integervariables(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_integervariable(Opt)
        Related: lpsolve
        "
        '''
def lp_interiorpoint(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_interiorpoin(Opt)
        Related: lpsolve
        "
        '''
def lp_iterationlimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_iterationlimi(Opt)
        Related: lpsolve
        "
        '''
def lp_lastfractional(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_lastfractiona(Opt)
        Related: lpsolve
        "
        '''
def lp_maxcuts(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_maxcut(Opt)
        Related: lpsolve
        "
        '''
def lp_maximize(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_maximiz(Opt)
        Related: lpsolve
        "
        '''
def lp_method(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_metho(Opt)
        Related: lpsolve
        "
        '''
def lp_mostfractional(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_mostfractiona(Opt)
        Related: lpsolve
        "
        '''
def lp_nodelimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_nodelimi(Opt)
        Related: lpsolve
        "
        '''
def lp_nodeselect(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_nodeselec(Opt)
        Related: lpsolve
        "
        '''
def lp_nonnegative(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_nonnegativ(Opt)
        Related: lpsolve
        "
        '''
def lp_nonnegint(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_nonnegin(Opt)
        Related: lpsolve
        "
        '''
def lp_pseudocost(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_pseudocos(Opt)
        Related: lpsolve
        "
        '''
def lp_simplex(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_simple(Opt)
        Related: lpsolve
        "
        '''
def lp_timelimit(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_timelimi(Opt)
        Related: lpsolve
        "
        '''
def lp_variables(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_variable(Opt)
        Related: lpsolve
        "
        '''
def lp_varselect(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_varselec(Opt)
        Related: lpsolve
        "
        '''
def lp_verbose(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Options for lpsolve command
        Usage: p_verbos(Opt)
        Related: lpsolve
        "
        '''
def lpsolve(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: solves a (mixed integer/binary) LP problem in general form
        Usage: lpsolve(Expr(o),[List(c)],[bounds],[options])
        Related: nlpsolve, fsolve
        Examples:
        lpsolve(2x+y-z+4,[x<=1,y>=2,x+3y-z=2,2x-y+z<=8,-x+y<=5]);lpsolve(-4x-5y,[x+2y<=6,5x+4y<=20,0<=x,0<=y]);lpsolve(-7x+2y,[4x-12y<=20,-x+3y<=3],x=-5..5,y=0..inf,lp_maximize=true);lpsolve(x-y-2z+3,[-3x-y+z<=3,2x-3y>=4z,x-z=y,x>=0,y<=0],lp_maximize);lpsolve(-x-y,[y<=3x+1/2,y<=-5x+2],assume=lp_nonnegative);lpsolve(x+y,[x<=8,-x+y<=4,-x+2y>=6,2x+y<=25,3x+y>=18,-x+2y>=6],assume=lp_nonnegative);lpsolve(45.55x1+21.87x2,[1.64x1+2.67x2<=31.2,2.11x1+2.3x2>=13.9],assume=lp_nonnegative);lpsolve(3x+4y,[x<=4,x+3y<=15,-x+2y>=5,x-y>=9,x+y=6],assume=lp_nonnegative,lp_maximize=true);lpsolve(-6x+4y+z,[5x-10y<=20,2z-3y=6,-x+3y<=3],x=1..20,y=0..inf);lpsolve(-5x-7y,[7x+y<=35,-x+3y<=6],assume=integer);lpsolve(x+3y+3z,[x+3y+2z<=7,2x+2y+z<=11],assume=lp_nonnegative,lp_integervariables=[x,z],lp_maximize);lpsolve(2x+5y,[3x-y=1,x-y<=5],assume=nonnegint);lpsolve(x1+x2,[2x1+5x2<=16,6x1+5x2<=30],assume=nonnegint,lp_maximize);lpsolve(8x1+11x2+6x3+4x4,[5x1+7x2+4x3+3x4<=14],assume=lp_binary,lp_maximize);lpsolve(x1+x2,[1867x1+1913x2=3618894],assume=nonnegint,lp_verbose=true)"
        '''
def lsmod(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Displays the installed dynamic libraries.
        Related: insmod, rmmod
        Examples:
        lsmod()"
        '''
def lsq(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the vector (resp matrix) X which is the minimum of the euclidean (resp Frobenius) norm of A*X-B corresponding to the linear system A*X=B when B is a vector (resp matrix).
        Usage: lsq(Mtrx(A),(Mtrx || Vect)(B))
        Related: lu, QR
        Examples:
        LSQ([[1,2],[3,4]],[5,11]);LSQ([[1,2],[3,4]],[[5,-1],[11,-1]])"
        '''
def lu(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: For a numerical matrix A, returns p permutation, L and U such that PA=LU (P=permu2mat(p)).
        Related: qr, cholesky, LU
        Examples:
        lu([[1,2],[3,4]]);lu([[6,12,18],[5,14,31],[3,8,18]])"
        '''
def lvar(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: List of variables of an object (with rational dependence).
        Related: lname, has
        Examples:
        lvar(exp(x)*2*sin(y));lvar(exp(x)*2*sin(y)+ln(x))"
        '''
def mRow(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Multiplies the row n1 of the matrix A by Xpr.
        Related: rowAdd, mRowAdd
        Examples:
        mRow(12,[[1,2],[3,4],[5,6]],0)"
        '''
def mRowAdd(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Multiplies the row n1 of the matrix A by Xpr, then adds it to the row n2.
        Related: rowAdd, mRow
        Examples:
        mRowAdd(12,[[1,2],[3,4],[5,6]],0,2)"
        '''
def magenta(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Option of the display command to display with color.
        Usage: agent(Opt)
        Related: display
        Examples:
         F:=display(point(2+1.5*i),red); F:=display(point(2+1.5*i),point_point+green)"
        '''
def make_directed(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns the copy of undirected graph G in which every edge is converted to a pair of arcs [and with weights specified by matrix A].
        Usage: make_directed(Graph(G),[Mrtx(A)])
        Related: is_directed, make_weighted, underlying_graph
        Examples:
        make_directed(cycle_graph(4),[[0,0,0,1],[2,0,1,3],[0,1,0,4],[5,0,4,0]])"
        '''
def make_weighted(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a copy of G with edge/arc weights set as specified by matrix M. If M is omitted, a suqare matrix of ones is used. If G is undirected, M is assumed to be symmetric.
        Usage: make_weighted(Graph(G),[Mrtx(M)])
        Related: get_edge_weight, is_weighted, make_directed, set_edge_weight, underlying_graph, weight_matrix
        Examples:
        make_weighted(cycle_graph(3),[[0,2,3],[2,0,1],[3,1,0]])"
        '''
def makelist(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Returns a list made with a function or with a constant.
        Related: seq, range, makemat, $
        Examples:
        makelist(x->x^2,1,10,2);makelist(4,1,10);makelist(4,5,10);makelist(x->ifte(x<5,""A"",""B""),1,10)"
        '''
def makemat(self,*args)->Pygen:
        r'''From Giac's documentation:
        (from giac's help:)"Description: Create a matrix.
        Related: matrix
        Examples:
        makemat((j,k)->j+k,3,2);ma