#!/usr/bin/env python3
"""
Setup script for featrixsphere package
"""

from setuptools import setup, find_packages
from pathlib import Path

# Read the README file
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

# Read version from __init__.py
def get_version():
    version_file = this_directory / "featrixsphere" / "__init__.py"
    if version_file.exists():
        for line in version_file.read_text().splitlines():
            if line.startswith("__version__"):
                return line.split('"')[1]
    return "0.1.0"

setup(
    name="featrixsphere",
    version=get_version(),
    author="Featrix",
    author_email="support@featrix.com",
    description="Transform any CSV into a production-ready ML model in minutes, not months.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Featrix/sphere",
    project_urls={
        "Bug Tracker": "https://github.com/Featrix/sphere/issues",
        "Documentation": "https://github.com/Featrix/sphere#readme",
        "Source Code": "https://github.com/Featrix/sphere",
    },
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Internet :: WWW/HTTP :: HTTP Servers",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.20.0",  # HTTP API calls
        "pandas>=1.0.0",     # CSV operations - core functionality
    ],
    extras_require={
        "dev": [
            "pytest>=6.0",
            "pytest-cov>=2.0",
            "black>=21.0",
            "flake8>=3.8",
            "mypy>=0.800",
        ],
    },
    entry_points={
        "console_scripts": [
            "featrix=featrixsphere.cli:main",
        ],
    },
    keywords=[
        "machine learning",
        "artificial intelligence", 
        "neural networks",
        "embedding spaces",
        "prediction",
        "classification",
        "regression",
        "csv",
        "api",
        "client",
        "featrix",
        "sphere",
        "automl",
        "no-code ml",
    ],
    include_package_data=True,
    zip_safe=False,
) 