const SvgSerpSearchAPI = (props) => (
  <svg
    version="1.0"
    viewBox="0 0 610 610"
    xmlns="http://www.w3.org/2000/svg"
    zoomAndPan="magnify"
    {...props}
  >
    <path
      d="M0 0 C1.76074316 1.76074316 1.13244814 4.08663737 1.14663696 6.43295288 C1.14618378 7.21167755 1.14573059 7.99040222 1.14526367 8.79272461 C1.14862228 9.60895798 1.1519809 10.42519135 1.15544128 11.26615906 C1.16498033 13.97823588 1.16689587 16.69025117 1.16796875 19.40234375 C1.17117926 21.2794243 1.17454317 23.15650459 1.17805481 25.03358459 C1.18405347 28.97381165 1.18589395 32.91401675 1.18530273 36.85424805 C1.18520107 41.91316633 1.19885482 46.9719444 1.21607494 52.03082943 C1.22717161 55.9091914 1.22922266 59.78751923 1.22869301 63.66589546 C1.2298766 65.53148444 1.23431943 67.39707419 1.24202538 69.26264763 C1.25177844 71.8678264 1.24896592 74.47269756 1.24291992 77.07788086 C1.24853943 77.8545813 1.25415894 78.63128174 1.25994873 79.43151855 C1.22831551 84.77168449 1.22831551 84.77168449 -1 87 C-2.96290824 87.77186524 -4.94570562 88.49356926 -6.9375 89.1875 C-21.61303218 94.75352323 -32.1936787 103.51927082 -38.78125 117.95703125 C-42.10359763 126.25225178 -43.25241235 133.86303691 -43.3125 142.75 C-43.31813965 143.54220947 -43.3237793 144.33441895 -43.32958984 145.15063477 C-43.17133621 157.97052038 -38.11152406 169.6774025 -29.2578125 178.96875 C-17.29763912 189.72876757 -1.60965405 194.62749013 14.31640625 194.30859375 C32.27078445 192.80446238 48.81641116 186.82254812 61 173 C70.38295755 160.12210596 72.52186173 146.58063062 71 131 C70.16428571 126.99140435 68.88098262 123.62634579 67 120 C66.59910156 119.17628906 66.19820312 118.35257812 65.78515625 117.50390625 C59.8915977 106.55384529 50.31459121 98.62253047 40 92 C38.31038412 90.89907382 36.62278289 89.79504768 34.9375 88.6875 C34.20402344 88.21699219 33.47054687 87.74648437 32.71484375 87.26171875 C31 86 31 86 30 84 C29.90174931 81.38110314 29.8636963 78.7888214 29.87060547 76.16967773 C29.86797699 74.95732956 29.86797699 74.95732956 29.86529541 73.7204895 C29.86088404 71.04150259 29.86381211 68.36258136 29.8671875 65.68359375 C29.86651432 63.8279672 29.86554418 61.97234073 29.86428833 60.11671448 C29.86281238 56.22534344 29.86496287 52.33399533 29.86962891 48.44262695 C29.8753301 43.4430913 29.87204407 38.44360928 29.86605644 33.44407558 C29.86245144 29.61208183 29.86358906 25.7801009 29.86618423 21.94810677 C29.86685347 20.10402482 29.86602521 18.25994173 29.86370468 16.41586113 C29.86117873 13.84418506 29.86501775 11.2725972 29.87060547 8.70092773 C29.86858124 7.9315538 29.86655701 7.16217987 29.86447144 6.36949158 C29.88573659 1.11426341 29.88573659 1.11426341 31 0 C33.04687986 -0.1034028 35.09738246 -0.13523086 37.14686584 -0.14044189 C37.79640572 -0.14341302 38.44594561 -0.14638414 39.11516851 -0.1494453 C41.308644 -0.15816948 43.50206514 -0.15964381 45.69555664 -0.16113281 C47.26265582 -0.16575931 48.82975386 -0.17078374 50.39685059 -0.17617798 C54.6730594 -0.18934253 58.94925247 -0.19575778 63.22547841 -0.20018864 C65.90566102 -0.20312008 68.58583936 -0.2072256 71.26601982 -0.21169281 C79.67448948 -0.22539425 88.08294934 -0.23504118 96.49142939 -0.2388947 C106.15035802 -0.24334632 115.80914308 -0.2607466 125.46802813 -0.2898953 C132.95541316 -0.31169181 140.44275842 -0.32160886 147.93017477 -0.32293582 C152.38887543 -0.32397349 156.84744167 -0.32965241 161.30610847 -0.34775543 C208.04878522 -0.52647061 250.41279319 4.61092692 285.5625 38.1875 C299.03923113 51.97139309 308.53059604 68.95074577 315 87 C315.41507813 88.06089844 315.83015625 89.12179688 316.2578125 90.21484375 C318.98622391 98.08526128 319.20575191 105.19822912 319.1015625 113.47265625 C319.09056519 115.13850769 319.09056519 115.13850769 319.0793457 116.8380127 C319.06032416 119.55882544 319.03367973 122.27933586 319 125 C308.65576969 125.11587892 298.31169392 125.2047078 287.9669466 125.25906086 C283.16335935 125.28514854 278.36021634 125.32053133 273.55688477 125.37719727 C268.92086106 125.43154682 264.28526448 125.46142677 259.64894676 125.47438622 C257.88067081 125.48362084 256.1124181 125.50165429 254.34432411 125.52865028 C251.86616234 125.56498111 249.38976243 125.56994387 246.91137695 125.56762695 C246.18129425 125.58560333 245.45121155 125.60357971 244.69900513 125.62210083 C240.79744211 125.58266484 239.17480057 125.144504 236.12785339 122.62565613 C234.04504692 120.05558546 232.07442411 117.46717073 230.1875 114.75 C220.11533894 100.73573845 209.19919422 91.21117226 191.65625 88.17578125 C174.59859472 85.68493229 158.44156454 88.33711587 144.09765625 98.375 C143.40542969 98.91125 142.71320313 99.4475 142 100 C141.02289063 100.74765625 140.04578125 101.4953125 139.0390625 102.265625 C135.76962723 105.01905026 133.55618181 108.13802718 131.3125 111.75 C130.92384766 112.36617188 130.53519531 112.98234375 130.13476562 113.6171875 C122.97150766 125.28341342 121.03931776 139.01732642 123.68359375 152.48046875 C128.34100562 168.65579547 136.76920411 179.61242073 151.140625 188.29296875 C155.57461772 190.64514782 160.1463108 192.03034021 164.99609375 193.2890625 C167 194 167 194 168 196 C168.09636545 197.92971747 168.12796218 199.8628003 168.12939453 201.79492188 C168.13254669 203.0095813 168.13569885 204.22424072 168.13894653 205.47570801 C168.13591019 207.45226379 168.13591019 207.45226379 168.1328125 209.46875 C168.13348588 210.82873553 168.13445619 212.18872094 168.13571167 213.54870605 C168.13718703 216.40015813 168.13503928 219.2515789 168.13037109 222.10302734 C168.12467389 225.76175173 168.12795376 229.42040276 168.13394356 233.07912445 C168.13755354 235.88776199 168.13640857 238.69638208 168.13381577 241.50502014 C168.13282231 243.51144457 168.13586431 245.51786968 168.13894653 247.52429199 C168.13579437 248.73895142 168.13264221 249.95361084 168.12939453 251.20507812 C168.12820114 252.81485535 168.12820114 252.81485535 168.12698364 254.45715332 C168 257 168 257 167 259 C164.54667379 259.79688333 162.11020757 260.50654412 159.625 261.1875 C145.15961854 265.46662752 135.42677714 273.26278417 128.1875 286.5625 C121.01831036 301.26263655 120.71376055 316.30795932 125.625 331.8125 C131.85497778 347.19058642 142.74676379 354.24133883 156.95654297 361.02050781 C166.68242313 365.68242313 166.68242313 365.68242313 168 367 C168.10043271 369.64200061 168.1361685 372.2578859 168.12939453 374.90039062 C168.13202301 376.14178047 168.13202301 376.14178047 168.13470459 377.4082489 C168.13912393 380.15760362 168.13618483 382.90689457 168.1328125 385.65625 C168.13348552 387.55814629 168.13445552 389.46004249 168.13571167 391.36193848 C168.13718875 395.35344255 168.13503375 399.34492429 168.13037109 403.33642578 C168.1246738 408.46490507 168.12795275 413.59333202 168.13394356 418.72180939 C168.13754889 422.65074054 168.13641072 426.57965918 168.13381577 430.5085907 C168.13314642 432.40012112 168.13397519 434.29165265 168.13629532 436.18318176 C168.13882138 438.82202177 168.13498191 441.46077581 168.12939453 444.09960938 C168.13141876 444.88925583 168.13344299 445.67890228 168.13552856 446.49247742 C168.11426251 451.88573749 168.11426251 451.88573749 167 453 C165.2410657 453.09632045 163.47822841 453.1218751 161.71665955 453.12025452 C160.57095993 453.12162918 159.42526031 453.12300385 158.24484253 453.12442017 C156.97673737 453.12082489 155.7086322 453.11722961 154.40209961 453.11352539 C153.06206769 453.11324352 151.72203561 453.11340125 150.38200378 453.1139679 C146.73340562 453.11425587 143.08484005 453.1083592 139.43624949 453.10139394 C135.62722484 453.09516034 131.8181995 453.0945566 128.00917053 453.09336853 C120.79142246 453.09025523 113.57368946 453.08204186 106.35594803 453.07201904 C98.14084743 453.06085786 89.92574612 453.05534744 81.71063983 453.05032361 C64.80708449 453.03985925 47.90354384 453.02225983 31 453 C29.47418466 449.94836932 29.85269243 446.76485089 29.85473633 443.41674805 C29.85137772 442.63444824 29.8480191 441.85214844 29.84455872 441.04614258 C29.83503415 438.45131862 29.8331047 435.85655912 29.83203125 433.26171875 C29.82881916 431.46051507 29.82545512 429.65931165 29.82194519 427.85810852 C29.81594976 424.07768143 29.81410566 420.29727721 29.81469727 416.5168457 C29.81479878 411.67460263 29.80115906 406.83250653 29.78392506 401.99029827 C29.77279992 398.26794259 29.77077824 394.54562233 29.77130699 390.82325172 C29.77012717 389.03829251 29.76570527 387.25333237 29.75797462 385.46838951 C29.74816664 382.96930069 29.7510562 380.47052959 29.75708008 377.97143555 C29.75146057 377.2351442 29.74584106 376.49885284 29.74005127 375.74024963 C29.76454789 371.73662594 30.07473316 368.54694673 32 365 C34.43359375 363.515625 34.43359375 363.515625 37.4375 362.25 C51.962486 355.45774036 61.73045896 344.55775783 68 330 C72.58062882 317.19325922 72.17022562 302.71789034 66.3828125 290.28125 C63.69075868 285.15132769 61.11102404 281.07488317 57 277 C57 276.34 57 275.68 57 275 C56.34 275 55.68 275 55 275 C55 274.34 55 273.68 55 273 C54.43925781 272.73832031 53.87851562 272.47664063 53.30078125 272.20703125 C50.77283225 270.88082371 48.53385393 269.31300787 46.1875 267.6875 C32.99893974 259.20787535 17.53412628 256.19592197 2.1875 259.1875 C-15.70060356 263.31255836 -29.1568709 272.58735024 -40.1875 287.125 C-42.74785151 290.18469405 -44.8433371 290.5032742 -48.81637955 290.86983871 C-52.25518757 291.07481924 -55.68495669 291.13925633 -59.12841797 291.12939453 C-60.28114952 291.13202301 -60.28114952 291.13202301 -61.45716858 291.13470459 C-63.96886527 291.13906635 -66.48049024 291.13620706 -68.9921875 291.1328125 C-70.747162 291.13348676 -72.50213641 291.1344578 -74.2571106 291.13571167 C-77.9201141 291.13718058 -81.58309311 291.13505853 -85.24609375 291.13037109 C-89.9471727 291.12464891 -94.64819486 291.12797356 -99.34927177 291.13394356 C-102.96597729 291.13754942 -106.58266924 291.13641091 -110.19937515 291.13381577 C-111.9337782 291.13314787 -113.66818246 291.13397013 -115.40258408 291.13629532 C-117.81773932 291.13882496 -120.23280098 291.13497798 -122.64794922 291.12939453 C-123.36689865 291.13141876 -124.08584808 291.13344299 -124.82658386 291.13552856 C-129.77146017 291.11426991 -129.77146017 291.11426991 -132 290 C-132.07042505 268.8839229 -132.12315088 247.76786547 -132.15543652 226.6516943 C-132.17083309 216.84466029 -132.19178271 207.03769972 -132.22631836 197.23071289 C-132.25644364 188.67196569 -132.27562721 180.11327174 -132.28226548 171.55447298 C-132.28613905 167.03262102 -132.29508725 162.51092122 -132.31719017 157.98911858 C-132.52983958 112.66754086 -128.13686465 71.08363221 -95 37 C-70.02708107 11.955113 -35.5428609 -2.26776536 0 0 Z "
      fill="#625FEC"
      transform="translate(206,74)"
    />
    <path
      d="M0 0 C1.13072182 0.00539291 1.13072182 0.00539291 2.2842865 0.01089478 C3.46956436 0.01067574 3.46956436 0.01067574 4.67878723 0.01045227 C7.30309245 0.0111516 9.92732759 0.01894489 12.55162048 0.02676392 C14.36623089 0.02862803 16.18084179 0.03005196 17.99545288 0.03105164 C22.78111653 0.03487737 27.56675003 0.04470813 32.35240173 0.05575562 C37.23195488 0.06596854 42.11151287 0.070549 46.99107361 0.07559204 C56.57246709 0.08633035 66.15383816 0.10340744 75.73521423 0.12442017 C75.85255672 24.07436213 75.9404499 48.02426036 75.99427509 71.97443295 C76.01994292 83.0975251 76.05487219 94.22043757 76.1124115 105.34341431 C76.1625992 115.0499593 76.19458798 124.75637402 76.20565671 134.46304518 C76.21211624 139.59203815 76.22705285 144.7206588 76.26386452 149.84953117 C76.45771357 177.97344621 75.78301464 204.11486054 63.73521423 230.12442017 C63.44308044 230.77024048 63.15094666 231.41606079 62.84996033 232.08145142 C49.85593017 260.26507951 23.5456776 282.04914617 -5.25697327 292.81192017 C-18.24340852 297.19541625 -31.48396066 300.38478663 -45.26478577 300.12442017 C-47.05335639 298.33584954 -46.38469156 295.92318882 -46.38920593 293.54232788 C-46.38561066 292.74175964 -46.38201538 291.94119141 -46.37831116 291.11636353 C-46.37845718 290.27741043 -46.37860321 289.43845734 -46.37875366 288.57408142 C-46.37805426 285.78744972 -46.37026062 283.000884 -46.36244202 280.21426392 C-46.36057793 278.28755225 -46.35915398 276.36084011 -46.3581543 274.43412781 C-46.35432836 269.35254619 -46.34449743 264.27099297 -46.33345032 259.18942261 C-46.32323783 254.00825383 -46.31865703 248.82708048 -46.31361389 243.64590454 C-46.30287522 233.47206391 -46.28579789 223.2982444 -46.26478577 213.12442017 C-45.02017794 212.44774018 -43.7688168 211.78347297 -42.51478577 211.12442017 C-41.81869202 210.75317017 -41.12259827 210.38192017 -40.40541077 209.99942017 C-38.26478577 209.12442017 -38.26478577 209.12442017 -34.26478577 209.12442017 C-33.76978577 208.13442017 -33.76978577 208.13442017 -33.26478577 207.12442017 C-32.06853577 206.56754517 -30.87228577 206.01067017 -29.63978577 205.43692017 C-19.21968156 200.34760011 -12.80710339 189.77923388 -8.88978577 179.18692017 C-6.65384206 172.58602549 -6.05363013 166.95256077 -6.01478577 159.99942017 C-5.99416077 159.09965454 -5.97353577 158.19988892 -5.95228577 157.27285767 C-5.88259772 145.1471382 -10.18071676 132.77421519 -18.49525452 123.76504517 C-24.7283764 117.98599177 -32.21864029 113.87355026 -39.61830139 109.78872681 C-42.13228697 108.39453699 -44.22013499 107.16907095 -46.26478577 105.12442017 C-46.59277344 102.50805664 -46.59277344 102.50805664 -46.69813538 99.14932251 C-46.73994431 97.89396698 -46.78175323 96.63861145 -46.8248291 95.34521484 C-46.96245641 89.58706761 -47.06089549 83.82859704 -47.129776 78.06924438 C-47.1698007 75.03142645 -47.24622192 71.99792914 -47.35536194 68.96182251 C-47.4871679 65.28902818 -47.5541416 61.62025096 -47.57606697 57.9452095 C-47.59495208 56.55020809 -47.63603877 55.1553127 -47.70040703 53.76166916 C-47.89716678 49.26265026 -47.81358404 45.37464882 -46.26478577 41.12442017 C-42.28745797 37.49194038 -38.11967642 35.46094906 -33.26478577 33.12442017 C-21.98497222 25.58032926 -13.90126774 14.63356308 -7.28822327 2.91738892 C-5.34924446 -0.47952434 -3.80125951 0.00765162 0 0 Z "
      fill="#625FEC"
      transform="translate(449.26478576660156,226.87557983398438)"
    />
    <path
      d="M0 0 C0.74661392 -0.00175232 1.49322784 -0.00350464 2.26246643 -0.00531006 C4.74067484 -0.00972477 7.21881229 -0.00678984 9.69702148 -0.00341797 C11.42138177 -0.00409162 13.14574197 -0.00506215 14.87010193 -0.00631714 C18.492512 -0.007794 22.11489747 -0.00564176 25.73730469 -0.00097656 C30.36163857 0.00469089 34.98591402 0.00146071 39.6102457 -0.00454903 C43.17663504 -0.00818051 46.74301079 -0.00700369 50.30940056 -0.00442123 C52.0128982 -0.00375755 53.7163971 -0.00456071 55.41989326 -0.00690079 C71.81667315 -0.02446484 71.81667315 -0.02446484 79.75561523 1.12939453 C79.94446289 1.71736816 80.13331055 2.3053418 80.32788086 2.91113281 C81.11005031 5.32695446 81.92914946 7.72836897 82.75561523 10.12939453 C83.03405273 10.95697266 83.31249023 11.78455078 83.59936523 12.63720703 C85.95063655 19.10320315 89.22713147 23.97596078 93.75561523 29.12939453 C94.29057617 29.75845703 94.82553711 30.38751953 95.37670898 31.03564453 C102.17448059 38.46917895 111.56585181 42.17806748 120.63842773 46.14892578 C122.75561523 47.12939453 122.75561523 47.12939453 123.75561523 48.12939453 C123.85604795 50.77139514 123.89178373 53.38728043 123.88500977 56.02978516 C123.88763824 57.271175 123.88763824 57.271175 123.89031982 58.53764343 C123.89473917 61.28699815 123.89180007 64.0362891 123.88842773 66.78564453 C123.88910075 68.68754082 123.89007075 70.58943702 123.8913269 72.49133301 C123.89280399 76.48283708 123.89064898 80.47431883 123.88598633 84.46582031 C123.88028904 89.5942996 123.88356798 94.72272656 123.88955879 99.85120392 C123.89316412 103.78013507 123.89202595 107.70905371 123.889431 111.63798523 C123.88876165 113.52951565 123.88959042 115.42104718 123.89191055 117.31257629 C123.89443662 119.9514163 123.89059715 122.59017034 123.88500977 125.22900391 C123.887034 126.01865036 123.88905823 126.80829681 123.8911438 127.62187195 C123.86987775 133.01513202 123.86987775 133.01513202 122.75561523 134.12939453 C91.55092472 136.33268138 60.04805812 124.28884186 36.44311523 104.25439453 C11.2572627 82.22253225 -6.2851184 50.79641047 -9.24438477 17.12939453 C-9.43323687 11.79463931 -9.36626085 6.46485861 -9.24438477 1.12939453 C-6.27550686 -0.35504442 -3.2546913 -0.00930507 0 0 Z "
      fill="#625FEB"
      transform="translate(83.244384765625,392.87060546875)"
    />
    <path
      d="M0 0 C1.60226635 0.01324313 3.20457164 0.02241825 4.80688477 0.02746582 C10.72862358 0.07453105 16.64952723 0.2001847 22.5703125 0.31640625 C35.8115625 0.50203125 49.0528125 0.68765625 62.6953125 0.87890625 C62.6953125 52.35890625 62.6953125 103.83890625 62.6953125 156.87890625 C62.3653125 156.87890625 62.0353125 156.87890625 61.6953125 156.87890625 C61.6953125 106.38890625 61.6953125 55.89890625 61.6953125 3.87890625 C57.7353125 4.20890625 53.7753125 4.53890625 49.6953125 4.87890625 C47.19193347 4.95441925 44.6871303 4.99721125 42.18261719 4.99243164 C41.52737564 4.99257767 40.87213409 4.99272369 40.19703674 4.99287415 C38.08705012 4.99219193 35.97715818 4.98448143 33.8671875 4.9765625 C32.38218229 4.97469227 30.89717646 4.97327123 29.41217041 4.97227478 C25.54565663 4.96849716 21.67918175 4.95870882 17.81268311 4.9475708 C13.85038784 4.93725312 9.88808614 4.9327552 5.92578125 4.92773438 C-1.81772587 4.91708118 -9.56120119 4.90006358 -17.3046875 4.87890625 C-17.59085937 5.66652344 -17.87703125 6.45414063 -18.171875 7.265625 C-19.43978464 10.19056139 -20.65161157 11.19862483 -23.3046875 12.87890625 C-24.3046875 9.87890625 -24.3046875 9.87890625 -23.73336792 7.64808655 C-18.81259261 -2.02223775 -9.43761925 -0.25946204 0 0 Z "
      fill="#6360D8"
      transform="translate(462.3046875,226.12109375)"
    />
    <path
      d="M0 0 C44.55 0.33 89.1 0.66 135 1 C135.33 1.99 135.66 2.98 136 4 C91.45 4 46.9 4 1 4 C0.67 2.68 0.34 1.36 0 0 Z "
      fill="#5B56CB"
      transform="translate(236,523)"
    />
    <path
      d="M0 0 C1.32 0 2.64 0 4 0 C4 27.72 4 55.44 4 84 C3.01 84.495 3.01 84.495 2 85 C-0.48104951 81.27842573 -0.26798754 78.43594364 -0.22705078 74.13208008 C-0.22734283 73.33184921 -0.22763489 72.53161835 -0.22793579 71.70713806 C-0.22654205 69.06115896 -0.21097884 66.41546118 -0.1953125 63.76953125 C-0.19158253 61.93536025 -0.18873548 60.10118726 -0.18673706 58.26701355 C-0.17909938 53.43859357 -0.15944972 48.61029384 -0.1373291 43.78192139 C-0.11687359 38.85528185 -0.10773597 33.92862289 -0.09765625 29.00195312 C-0.07620397 19.33458257 -0.04206637 9.66730128 0 0 Z "
      fill="#6764E4"
      transform="translate(370,442)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C2.02312283 12.06534858 2.04091478 23.13069145 2.05181217 34.19605923 C2.05704113 39.33359566 2.06413901 44.47111563 2.07543945 49.60864258 C2.08626787 54.5623141 2.09227674 59.51596974 2.09487724 64.46965218 C2.09673157 66.36397616 2.10035234 68.25829924 2.10573006 70.1526165 C2.11293989 72.79634386 2.11399097 75.44000471 2.11352539 78.08374023 C2.11712067 78.87495773 2.12071594 79.66617523 2.12442017 80.48136902 C2.11405216 85.88594784 2.11405216 85.88594784 1 87 C-0.85287502 87.07226502 -2.70833878 87.0838122 -4.5625 87.0625 C-6.08037109 87.04896484 -6.08037109 87.04896484 -7.62890625 87.03515625 C-8.41136719 87.02355469 -9.19382813 87.01195312 -10 87 C-10 86.34 -10 85.68 -10 85 C-7.03 85 -4.06 85 -1 85 C-1.00222061 83.94986221 -1.00444122 82.89972443 -1.00672913 81.81776428 C-1.02696015 71.94354419 -1.04197195 62.06932828 -1.05181217 52.1950922 C-1.0570411 47.11808982 -1.06413892 42.04110411 -1.07543945 36.96411133 C-1.08626799 32.06879448 -1.09227676 27.17349371 -1.09487724 22.27816582 C-1.09673155 20.40617049 -1.10035228 18.53417609 -1.10573006 16.66218758 C-1.11294004 14.04959301 -1.11399096 11.43706573 -1.11352539 8.82446289 C-1.11712067 8.04259613 -1.12071594 7.26072937 -1.12442017 6.45516968 C-1.11405216 1.11405216 -1.11405216 1.11405216 0 0 Z "
      fill="#6360CE"
      transform="translate(205,440)"
    />
    <path
      d="M0 0 C1.65 0 3.3 0 5 0 C5 0.66 5 1.32 5 2 C5.66 2 6.32 2 7 2 C7 1.34 7 0.68 7 0 C9.9375 0.375 9.9375 0.375 13 1 C14.35144654 3.70289308 14.11975165 5.80069806 14.11352539 8.82666016 C14.11344986 10.04777496 14.11337433 11.26888977 14.11329651 12.52700806 C14.10818952 13.86435995 14.10297352 15.20171143 14.09765625 16.5390625 C14.0957914 17.90383859 14.09436781 19.26861534 14.09336853 20.63339233 C14.08954863 24.22715093 14.07972283 27.82086917 14.06866455 31.41461182 C14.05843911 35.08108982 14.05386848 38.74757435 14.04882812 42.4140625 C14.0381001 49.60939341 14.02102999 56.80469105 14 64 C12.02 64.495 12.02 64.495 10 65 C10 44.54 10 24.08 10 3 C8.02 3 6.04 3 4 3 C1.625 1.5 1.625 1.5 0 0 Z "
      fill="#5F5DE7"
      transform="translate(360,267)"
    />
    <path
      d="M0 0 C0 27.72 0 55.44 0 84 C-1.98 84.495 -1.98 84.495 -4 85 C-3.67 57.28 -3.34 29.56 -3 1 C-5.64 1 -8.28 1 -11 1 C-11 0.67 -11 0.34 -11 0 C-3.375 -1.125 -3.375 -1.125 0 0 Z "
      fill="#5553CF"
      transform="translate(207,75)"
    />
    <path
      d="M0 0 C0 2.83967231 -0.40267181 5.23735711 -1 8 C-2.65 8.33 -4.3 8.66 -6 9 C-6 9.68238235 -6 10.36476471 -6 11.06782532 C-6 67.375 -6 67.375 -8 71 C-8.66 70.67 -9.32 70.34 -10 70 C-10.23208294 61.75942438 -10.4095607 53.52022095 -10.51812172 45.27718163 C-10.57023819 41.44907312 -10.64086033 37.62320527 -10.75439453 33.79638672 C-10.86335801 30.10033977 -10.92289792 26.40644131 -10.94877243 22.7089119 C-10.96719912 21.30123678 -11.00319016 19.89367483 -11.05730057 18.4869194 C-11.21741538 14.15030644 -11.23603395 10.17702671 -10 6 C-7.00028031 3.07582229 -3.90707384 1.45113557 0 0 Z "
      fill="#6E6AE7"
      transform="translate(413,262)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1.88492433 4.56504685 2.15592231 8.99024653 2.17358398 13.62597656 C2.180271 14.3649115 2.18695801 15.10384644 2.19384766 15.86517334 C2.20782898 17.45947927 2.21974462 19.0538044 2.22979546 20.64813995 C2.2462833 23.16961274 2.26951889 25.69094115 2.29469299 28.21234131 C2.36529092 35.37748992 2.4257954 42.54269321 2.47680664 49.70800781 C2.50853119 54.09812491 2.5497742 58.48806775 2.59700203 62.87804413 C2.61304317 64.55101152 2.62535495 66.22401889 2.63390923 67.89704132 C2.6460141 70.2287428 2.67013774 72.56003052 2.69702148 74.89160156 C2.6979052 75.93266052 2.6979052 75.93266052 2.69880676 76.99475098 C2.66462242 80.93936342 2.66462242 80.93936342 5 84 C3.34385343 84.38218767 1.67542976 84.71395102 0 85 C-1.74516379 83.25483621 -1.13026903 80.85035052 -1.1328125 78.4765625 C-1.13474609 77.25122803 -1.13667969 76.02589355 -1.13867188 74.76342773 C-1.13453135 73.38395051 -1.12995991 72.00447452 -1.125 70.625 C-1.12411377 69.92835236 -1.12322754 69.23170471 -1.12231445 68.51394653 C-1.08896695 45.67315289 -0.50573139 22.83413809 0 0 Z "
      fill="#6E6CE7"
      transform="translate(404,442)"
    />
    <path
      d="M0 0 C1.65 0.33 3.3 0.66 5 1 C5 1.66 5 2.32 5 3 C3.68 3.33 2.36 3.66 1 4 C1.66 5.32 2.32 6.64 3 8 C1.27473958 8.68359375 -0.45052083 9.3671875 -2.17578125 10.05078125 C-4.35374897 11.18407066 -5.4915402 12.04066448 -7 14 C-7.50718056 16.9988613 -7.50718056 16.9988613 -7.51171875 20.41796875 C-7.56489258 22.29838867 -7.56489258 22.29838867 -7.61914062 24.21679688 C-7.64169922 25.52712891 -7.66425781 26.83746094 -7.6875 28.1875 C-7.72067666 29.52282013 -7.75516666 30.85810832 -7.79101562 32.19335938 C-7.87362057 35.46215504 -7.94273229 38.73067812 -8 42 C-8.33 42 -8.66 42 -9 42 C-9.33 32.76 -9.66 23.52 -10 14 C-10.33 28.85 -10.66 43.7 -11 59 C-11.33 59 -11.66 59 -12 59 C-12 41.51 -12 24.02 -12 6 C-4 2 -4 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6563E6"
      transform="translate(415,434)"
    />
    <path
      d="M0 0 C1.37091797 0.04447266 1.37091797 0.04447266 2.76953125 0.08984375 C5.1875 0.25 5.1875 0.25 9 1 C11.21654478 4.32129885 11.1788108 7.06616233 11 11 C10.01 11 9.02 11 8 11 C8 9.02 8 7.04 8 5 C7.29391602 4.98018066 6.58783203 4.96036133 5.86035156 4.93994141 C2.65653006 4.84459585 -0.54664801 4.73495487 -3.75 4.625 C-5.41675781 4.57859375 -5.41675781 4.57859375 -7.1171875 4.53125 C-8.18710938 4.49257813 -9.25703125 4.45390625 -10.359375 4.4140625 C-11.34389648 4.3826416 -12.32841797 4.3512207 -13.34277344 4.31884766 C-16.00852201 3.99897742 -17.70616405 3.35631379 -20 2 C-13.37210725 -0.46619265 -7.00530999 -0.26195972 0 0 Z "
      fill="#645FD6"
      transform="translate(154,393)"
    />
    <path
      d="M0 0 C1.65 0 3.3 0 5 0 C5 0.66 5 1.32 5 2 C5.66 2 6.32 2 7 2 C7 1.34 7 0.68 7 0 C9.97 0.495 9.97 0.495 13 1 C12.84152588 1.90177979 12.68305176 2.80355957 12.51977539 3.73266602 C11.74005792 9.22229268 11.76595807 14.74196022 11.68359375 20.27734375 C11.66281265 21.4438295 11.64203156 22.61031525 11.62062073 23.81214905 C11.55549089 27.52054224 11.49641083 31.22900332 11.4375 34.9375 C11.39427999 37.45899126 11.3506646 39.98047577 11.30664062 42.50195312 C11.19984716 48.66789799 11.0980143 54.83390967 11 61 C11.99 61 12.98 61 14 61 C13.67 62.32 13.34 63.64 13 65 C12.01 65 11.02 65 10 65 C10 44.54 10 24.08 10 3 C8.02 3 6.04 3 4 3 C1.625 1.5 1.625 1.5 0 0 Z "
      fill="#6661D2"
      transform="translate(360,267)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 28.05 1 56.1 1 85 C-1.475 85.495 -1.475 85.495 -4 86 C-3.51391769 85.66916916 -3.02783539 85.33833832 -2.52702332 84.9974823 C-0.19290454 81.94424736 -0.56070155 78.73356402 -0.56762695 75.0402832 C-0.5574353 74.23029877 -0.54724365 73.42031433 -0.53674316 72.58578491 C-0.50653875 69.90738068 -0.49733598 67.22933363 -0.48828125 64.55078125 C-0.47144006 62.69417627 -0.45329058 60.83758274 -0.43388367 58.98100281 C-0.38631663 54.09349136 -0.35655069 49.20602629 -0.33044434 44.31835938 C-0.30067258 39.33128701 -0.25413067 34.34437457 -0.20898438 29.35742188 C-0.12287503 19.57169812 -0.05556373 9.78594152 0 0 Z "
      fill="#3737CA"
      transform="translate(206,441)"
    />
    <path
      d="M0 0 C-1.36859018 4.12760975 -3.19974067 6.49667813 -6.25 9.5625 C-11.1608413 14.82241564 -14.12838389 20.44595852 -17 27 C-19 24 -19 24 -18.7578125 21.95703125 C-18.171875 19.97135417 -17.5859375 17.98567708 -17 16 C-16.34 16 -15.68 16 -15 16 C-15 15.34 -15 14.68 -15 14 C-14.34 14 -13.68 14 -13 14 C-13 12.68 -13 11.36 -13 10 C-12.34 10 -11.68 10 -11 10 C-11 9.34 -11 8.68 -11 8 C-10.01 7.67 -9.02 7.34 -8 7 C-7.67 6.01 -7.34 5.02 -7 4 C-3.57142857 0 -3.57142857 0 0 0 Z "
      fill="#615BDA"
      transform="translate(183,168)"
    />
    <path
      d="M0 0 C12.21 0 24.42 0 37 0 C37 0.99 37 1.98 37 3 C30.73 3.33 24.46 3.66 18 4 C18 3.34 18 2.68 18 2 C12.06 2 6.12 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#8682E0"
      transform="translate(90,393)"
    />
    <path
      d="M0 0 C1.59134766 -0.03867187 1.59134766 -0.03867187 3.21484375 -0.078125 C6.0625 0.25 6.0625 0.25 7.94140625 1.765625 C8.31136719 2.25546875 8.68132812 2.7453125 9.0625 3.25 C3.98163204 4.09681133 -0.78578377 4.34038099 -5.9375 4.25 C-5.9375 7.55 -5.9375 10.85 -5.9375 14.25 C-6.9275 14.745 -6.9275 14.745 -7.9375 15.25 C-7.9375 10.63 -7.9375 6.01 -7.9375 1.25 C-5.23187257 -0.10281371 -3.01856345 0.04390638 0 0 Z "
      fill="#6562DB"
      transform="translate(81.9375,392.75)"
    />
    <path
      d="M0 0 C0.99 0 1.98 0 3 0 C2.67 2.97 2.34 5.94 2 9 C1.67 9 1.34 9 1 9 C0.67 23.85 0.34 38.7 0 54 C-0.33 54 -0.66 54 -1 54 C-1.02526648 46.47030348 -1.04283141 38.9406178 -1.05493164 31.41088867 C-1.0599737 28.84708243 -1.06680714 26.28327909 -1.07543945 23.71948242 C-1.08751064 20.04344979 -1.09322942 16.36745502 -1.09765625 12.69140625 C-1.10281754 11.53725723 -1.10797882 10.38310822 -1.11329651 9.19398499 C-1.11337204 8.13296066 -1.11344757 7.07193634 -1.11352539 5.97875977 C-1.115746 5.03944107 -1.11796661 4.10012238 -1.12025452 3.13233948 C-1 1 -1 1 0 0 Z "
      fill="#635DE2"
      transform="translate(404,439)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C0.85899586 3.93768809 0.71129067 7.87509905 0.5625 11.8125 C0.52318359 12.91271484 0.48386719 14.01292969 0.44335938 15.14648438 C0.1757452 22.12503863 -0.28839823 29.05249661 -1 36 C-1.33 36 -1.66 36 -2 36 C-2.0496011 31.67669221 -2.0858144 27.35353715 -2.10986328 23.0300293 C-2.11989352 21.56059888 -2.13352101 20.09118829 -2.15087891 18.62182617 C-2.17525898 16.50434463 -2.18651286 14.38712801 -2.1953125 12.26953125 C-2.20578613 10.99698486 -2.21625977 9.72443848 -2.22705078 8.41333008 C-2.00942228 5.14164829 -1.41502625 2.93042634 0 0 Z "
      fill="#736FE5"
      transform="translate(373,270)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C1.53730015 5.29227942 -0.90159458 7.02922065 -4.0625 9.75 C-4.98160156 10.54921875 -5.90070313 11.3484375 -6.84765625 12.171875 C-7.55792969 12.77515625 -8.26820313 13.3784375 -9 14 C-9.99 13.67 -10.98 13.34 -12 13 C-12 12.01 -12 11.02 -12 10 C-11.01 9.67 -10.02 9.34 -9 9 C-8.34 8.01 -7.68 7.02 -7 6 C-6.01 6 -5.02 6 -4 6 C-4 5.34 -4 4.68 -4 4 C-3.34 4 -2.68 4 -2 4 C-2 3.34 -2 2.68 -2 2 C-1.34 2 -0.68 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#635EDC"
      transform="translate(488,486)"
    />
    <path
      d="M0 0 C0.67095703 0.58007812 0.67095703 0.58007812 1.35546875 1.171875 C4.8521026 4.18390075 8.37407463 7.14321031 12 10 C10.34385343 10.38218767 8.67542976 10.71395102 7 11 C6.67 10.67 6.34 10.34 6 10 C5.67 10.66 5.34 11.32 5 12 C4.34 12 3.68 12 3 12 C2.4843841 9.9375364 1.9844447 7.90926073 1.625 5.8125 C1.41875 5.214375 1.2125 4.61625 1 4 C0.01 3.67 -0.98 3.34 -2 3 C-1.34 2.01 -0.68 1.02 0 0 Z "
      fill="#5B57DF"
      transform="translate(339,420)"
    />
    <path
      d="M0 0 C6.27 0 12.54 0 19 0 C15 4 15 4 11.109375 4.171875 C9.65432351 4.05282533 8.20095307 3.91150184 6.75 3.75 C6.00492188 3.68425781 5.25984375 3.61851562 4.4921875 3.55078125 C2.65964035 3.38632189 0.82947345 3.19571111 -1 3 C-0.67 2.01 -0.34 1.02 0 0 Z "
      fill="#6E68DB"
      transform="translate(209,328)"
    />
    <path
      d="M0 0 C0.33 0.66 0.66 1.32 1 2 C3.52733235 2.65555119 3.52733235 2.65555119 6 3 C6 3.66 6 4.32 6 5 C-3.41002278 9.59225513 -3.41002278 9.59225513 -8 9 C-7.67 8.01 -7.34 7.02 -7 6 C-3.4375 4.3125 -3.4375 4.3125 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#605BE0"
      transform="translate(449,510)"
    />
    <path
      d="M0 0 C0 0.66 0 1.32 0 2 C1.98 2.66 3.96 3.32 6 4 C6 5.32 6 6.64 6 8 C-3.59453303 5.29384966 -3.59453303 5.29384966 -7 1 C-4.53721199 -0.231394 -2.7204945 -0.07159196 0 0 Z "
      fill="#5E5CDC"
      transform="translate(146,508)"
    />
    <path
      d="M0 0 C1.65 0.33 3.3 0.66 5 1 C5 1.66 5 2.32 5 3 C3.68 3.33 2.36 3.66 1 4 C1.66 5.32 2.32 6.64 3 8 C-0.05263664 8.98120464 -1.94736336 8.98120464 -5 8 C-5 6.35 -5 4.7 -5 3 C-3.35 2.67 -1.7 2.34 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6B66E6"
      transform="translate(415,434)"
    />
    <path
      d="M0 0 C2.31 0.33 4.62 0.66 7 1 C7.33 1.99 7.66 2.98 8 4 C6.23225581 4.53122363 4.46065917 5.04964073 2.6875 5.5625 C1.70136719 5.85253906 0.71523438 6.14257812 -0.30078125 6.44140625 C-3 7 -3 7 -6 6 C-6 5.01 -6 4.02 -6 3 C-4.02 3 -2.04 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#6862DF"
      transform="translate(432,517)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C2.46733615 5.57989423 2.17261016 8.24854513 -0.5 11.9375 C-1.325 12.948125 -2.15 13.95875 -3 15 C-3.99 14.67 -4.98 14.34 -6 14 C-4.16508812 9.25981099 -2.08058541 4.63586749 0 0 Z "
      fill="#5E57DE"
      transform="translate(274,404)"
    />
    <path
      d="M0 0 C1.98 0.66 3.96 1.32 6 2 C6 5.10551666 5.4606285 6.35261084 4 9 C1.83125748 8.49396008 0.00032373 8.00016187 -2 7 C-2 5.68 -2 4.36 -2 3 C-1.34 2.67 -0.68 2.34 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#605CD8"
      transform="translate(490,115)"
    />
    <path
      d="M0 0 C2.46477712 2.30193899 4.31755197 4.75988654 6.1875 7.5625 C6.71730469 8.34753906 7.24710937 9.13257813 7.79296875 9.94140625 C9 12 9 12 9 14 C7.68 13.67 6.36 13.34 5 13 C5 12.34 5 11.68 5 11 C4.34 11 3.68 11 3 11 C1 8 1 8 1 5 C0.34 5 -0.32 5 -1 5 C-0.67 3.35 -0.34 1.7 0 0 Z "
      fill="#625DE0"
      transform="translate(333,239)"
    />
    <path
      d="M0 0 C1.32 0 2.64 0 4 0 C3.9375 1.75 3.9375 1.75 3 4 C-0.67238347 6.86059344 -3.29553866 8 -8 8 C-7.34 6.68 -6.68 5.36 -6 4 C-4.68 4 -3.36 4 -2 4 C-2 3.34 -2 2.68 -2 2 C-1.34 2 -0.68 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#716FDB"
      transform="translate(354,334)"
    />
    <path
      d="M0 0 C1.32 0.33 2.64 0.66 4 1 C3.34 2.98 2.68 4.96 2 7 C2.66 7 3.32 7 4 7 C4 7.66 4 8.32 4 9 C4.66 9.33 5.32 9.66 6 10 C5.01 10.66 4.02 11.32 3 12 C3 11.34 3 10.68 3 10 C2.34 10 1.68 10 1 10 C0.67 7.69 0.34 5.38 0 3 C-1.65 3 -3.3 3 -5 3 C-5 2.34 -5 1.68 -5 1 C-3.35 1 -1.7 1 0 1 C0 0.67 0 0.34 0 0 Z "
      fill="#6E6AE4"
      transform="translate(260,339)"
    />
    <path
      d="M0 0 C0.33 0.66 0.66 1.32 1 2 C1.99 2 2.98 2 4 2 C4.33 3.32 4.66 4.64 5 6 C5.66 6 6.32 6 7 6 C7.28875 6.639375 7.5775 7.27875 7.875 7.9375 C8.82823451 10.15206079 8.82823451 10.15206079 11 11 C11 11.66 11 12.32 11 13 C8.73828125 12.84765625 8.73828125 12.84765625 6 12 C3.98046875 9.49609375 3.98046875 9.49609375 2.1875 6.4375 C1.58292969 5.42558594 0.97835938 4.41367188 0.35546875 3.37109375 C-0.09183594 2.58863281 -0.53914063 1.80617187 -1 1 C-0.67 0.67 -0.34 0.34 0 0 Z "
      fill="#5A56DE"
      transform="translate(437,186)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C3 5.62 3 10.24 3 15 C2.34 15 1.68 15 1 15 C-0.44207941 12.11584117 -0.09394887 9.58278472 -0.0625 6.375 C-0.05347656 5.18648438 -0.04445313 3.99796875 -0.03515625 2.7734375 C-0.02355469 1.85820312 -0.01195312 0.94296875 0 0 Z "
      fill="#6B65DC"
      transform="translate(324,380)"
    />
    <path
      d="M0 0 C2.64 0 5.28 0 8 0 C8 0.99 8 1.98 8 3 C3.71 3.99 -0.58 4.98 -5 6 C-5 5.34 -5 4.68 -5 4 C-4.34 4 -3.68 4 -3 4 C-3 3.34 -3 2.68 -3 2 C-2.01 2 -1.02 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6865DC"
      transform="translate(369,158)"
    />
    <path
      d="M0 0 C2 1 4 2 6 3 C6 4.32 6 5.64 6 7 C6.66 7 7.32 7 8 7 C8 7.66 8 8.32 8 9 C8.66 9.33 9.32 9.66 10 10 C8.68 10.33 7.36 10.66 6 11 C4.98805294 9.92781799 3.99081943 8.84173622 3 7.75 C2.443125 7.14671875 1.88625 6.5434375 1.3125 5.921875 C0 4 0 4 0 0 Z "
      fill="#6B67DF"
      transform="translate(102,475)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C0.53563715 5.63714903 0.53563715 5.63714903 -1.9375 7.3125 C-4 8 -4 8 -7 8 C-5.50902342 4.2047869 -3.24299151 2.38957269 0 0 Z "
      fill="#6662DE"
      transform="translate(256,428)"
    />
    <path
      d="M0 0 C2.84614024 2.84614024 2.45579076 5.80369142 2.625 9.625 C2.68300781 10.68460937 2.68300781 10.68460937 2.7421875 11.765625 C2.83647724 13.50998524 2.91932891 15.25495691 3 17 C2.01 17 1.02 17 0 17 C0 11.39 0 5.78 0 0 Z "
      fill="#6A64D4"
      transform="translate(279,377)"
    />
    <path
      d="M0 0 C2.31 0.33 4.62 0.66 7 1 C4.71540242 3.28459758 2.87462656 3.97129748 -0.125 5.125 C-1.03507813 5.47820312 -1.94515625 5.83140625 -2.8828125 6.1953125 C-3.58148438 6.46085938 -4.28015625 6.72640625 -5 7 C-4.67 5.68 -4.34 4.36 -4 3 C-2.68 2.67 -1.36 2.34 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6458DC"
      transform="translate(194,160)"
    />
    <path
      d="M0 0 C13.71428571 1.71428571 13.71428571 1.71428571 17 5 C10.23333989 5.2706664 5.25056081 4.44278222 0 0 Z "
      fill="#6460DA"
      transform="translate(438,83)"
    />
    <path
      d="M0 0 C1.32 0.33 2.64 0.66 4 1 C1.74259377 3.33524782 -0.2805761 5.18705073 -3 7 C-3.99 7 -4.98 7 -6 7 C-6 6.01 -6 5.02 -6 4 C-5.34 4 -4.68 4 -4 4 C-4 3.34 -4 2.68 -4 2 C-2.68 2 -1.36 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6A66E0"
      transform="translate(352,166)"
    />
    <path
      d="M0 0 C3.5742977 0.32493615 5.55712453 0.63870686 8.375 2.9375 C10 5 10 5 10 7 C6.00118212 6.38479725 3.19641774 4.39731331 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6860DC"
      transform="translate(242,161)"
    />
    <path
      d="M0 0 C2 2 2 2 2.1953125 4.1640625 C2.17210937 4.97617187 2.14890625 5.78828125 2.125 6.625 C2.10695313 7.44226563 2.08890625 8.25953125 2.0703125 9.1015625 C2.03550781 10.04128906 2.03550781 10.04128906 2 11 C1.01 10.67 0.02 10.34 -1 10 C-2.31223496 6.06329512 -1.24296256 3.87511856 0 0 Z M-1 12 C-0.67 13.32 -0.34 14.64 0 16 C-0.66 16 -1.32 16 -2 16 C-1.67 14.68 -1.34 13.36 -1 12 Z "
      fill="#6865DD"
      transform="translate(445,390)"
    />
    <path
      d="M0 0 C4.95 0.33 9.9 0.66 15 1 C15 1.33 15 1.66 15 2 C10.38 2.66 5.76 3.32 1 4 C0.67 2.68 0.34 1.36 0 0 Z "
      fill="#5754D9"
      transform="translate(200,330)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C0.88590318 2.10478604 0.75834639 4.20884577 0.625 6.3125 C0.52058594 8.07013672 0.52058594 8.07013672 0.4140625 9.86328125 C0 13 0 13 -2 16 C-3.37946226 10.6200972 -2.60279984 6.21458854 -1 1 C-0.67 0.67 -0.34 0.34 0 0 Z "
      fill="#726DE7"
      transform="translate(80,166)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C2.34 1 1.68 1 1 1 C0.9175 1.763125 0.835 2.52625 0.75 3.3125 C-0.14615794 6.52373261 -1.21611025 7.29374499 -4 9 C-4.66 8.67 -5.32 8.34 -6 8 C-4.26440562 4.942048 -2.61527381 2.36620011 0 0 Z "
      fill="#6562DE"
      transform="translate(115,107)"
    />
    <path
      d="M0 0 C0 0.66 0 1.32 0 2 C-8.91 1.67 -17.82 1.34 -27 1 C-27 0.67 -27 0.34 -27 0 C-22.87536584 -0.19622046 -18.75028427 -0.38050216 -14.625 -0.5625 C-13.449375 -0.61857422 -12.27375 -0.67464844 -11.0625 -0.73242188 C-9.94101562 -0.78076172 -8.81953125 -0.82910156 -7.6640625 -0.87890625 C-6.10872803 -0.94960327 -6.10872803 -0.94960327 -4.52197266 -1.02172852 C-2 -1 -2 -1 0 0 Z "
      fill="#5F5DBC"
      transform="translate(372,525)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C2.71905418 2.8141927 2.42493567 4.62635001 2.125 6.4375 C1.88136719 7.95150391 1.88136719 7.95150391 1.6328125 9.49609375 C1.42398437 10.32238281 1.21515625 11.14867187 1 12 C0.01 12.495 0.01 12.495 -1 13 C-1.02708567 11.39592672 -1.04643483 9.7917215 -1.0625 8.1875 C-1.07410156 7.29417969 -1.08570313 6.40085938 -1.09765625 5.48046875 C-1 3 -1 3 0 0 Z "
      fill="#6E6EED"
      transform="translate(326,205)"
    />
    <path
      d="M0 0 C0.89621015 2.68863046 1.47095006 5.22248781 2 8 C2.185625 8.928125 2.37125 9.85625 2.5625 10.8125 C2.7790625 11.8953125 2.7790625 11.8953125 3 13 C2.01 13.495 2.01 13.495 1 14 C-0.32 9.71 -1.64 5.42 -3 1 C-2.01 0.67 -1.02 0.34 0 0 Z "
      fill="#7470EA"
      transform="translate(83,435)"
    />
    <path
      d="M0 0 C1.62490954 -0.02698189 3.24994633 -0.04638757 4.875 -0.0625 C5.77992188 -0.07410156 6.68484375 -0.08570313 7.6171875 -0.09765625 C10 0 10 0 12 1 C12 1.66 12 2.32 12 3 C8.04 3 4.08 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#7A76DA"
      transform="translate(141,393)"
    />
    <path
      d="M0 0 C1.93681161 -0.08107583 3.8745934 -0.13922475 5.8125 -0.1875 C6.89144531 -0.22230469 7.97039062 -0.25710938 9.08203125 -0.29296875 C12 0 12 0 13.88671875 1.51171875 C14.25410156 2.00285156 14.62148437 2.49398438 15 3 C4.44191344 3.18451025 4.44191344 3.18451025 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#7A76DB"
      transform="translate(76,393)"
    />
    <path
      d="M0 0 C2.97 0.33 5.94 0.66 9 1 C9 1.66 9 2.32 9 3 C5.33694766 3.74926071 2.57644848 4.2380014 -1 3 C-0.67 2.01 -0.34 1.02 0 0 Z "
      fill="#605DDE"
      transform="translate(201,267)"
    />
    <path
      d="M0 0 C0.66 0 1.32 0 2 0 C2.33 1.32 2.66 2.64 3 4 C1.35 4.33 -0.3 4.66 -2 5 C-2 6.32 -2 7.64 -2 9 C-3.32 8.67 -4.64 8.34 -6 8 C-5.04956626 6.66102417 -4.08940853 5.32894573 -3.125 4 C-2.59132813 3.2575 -2.05765625 2.515 -1.5078125 1.75 C-1.01023437 1.1725 -0.51265625 0.595 0 0 Z "
      fill="#5E59D8"
      transform="translate(436,239)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 2.97 1 5.94 1 9 C-1.64 9 -4.28 9 -7 9 C-6.67 8.34 -6.34 7.68 -6 7 C-4.68 7 -3.36 7 -2 7 C-1.34 4.69 -0.68 2.38 0 0 Z "
      fill="#6A64DD"
      transform="translate(524,189)"
    />
    <path
      d="M0 0 C1.90318884 2.85478326 2.4619099 4.41941308 3.125 7.6875 C3.29257812 8.49574219 3.46015625 9.30398437 3.6328125 10.13671875 C3.75398437 10.75160156 3.87515625 11.36648437 4 12 C2.68 11.67 1.36 11.34 0 11 C-1.28571429 3.57142857 -1.28571429 3.57142857 0 0 Z "
      fill="#5E53DF"
      transform="translate(520,161)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C2 1.66 2 2.32 2 3 C2.99 2.67 3.98 2.34 5 2 C4.67 2.99 4.34 3.98 4 5 C3.34 5 2.68 5 2 5 C1.67 6.32 1.34 7.64 1 9 C-0.41377341 6.36095629 -1.37240135 3.92879371 -2 1 C-1.34 0.67 -0.68 0.34 0 0 Z "
      fill="#6A66E7"
      transform="translate(90,141)"
    />
    <path
      d="M0 0 C1.65 0.33 3.3 0.66 5 1 C5 1.66 5 2.32 5 3 C4.34 3 3.68 3 3 3 C3 4.32 3 5.64 3 7 C1.68 7 0.36 7 -1 7 C-0.67 4.69 -0.34 2.38 0 0 Z "
      fill="#706AE9"
      transform="translate(93,133)"
    />
    <path
      d="M0 0 C0.33 1.32 0.66 2.64 1 4 C0.34 4 -0.32 4 -1 4 C-1 5.32 -1 6.64 -1 8 C-3.5 9.75 -3.5 9.75 -6 11 C-6.33 10.01 -6.66 9.02 -7 8 C-5.37660195 6.29115995 -3.70680947 4.62553283 -2 3 C-1.34 3 -0.68 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#645FD6"
      transform="translate(101,124)"
    />
    <path
      d="M0 0 C1.32 0.33 2.64 0.66 4 1 C1.525 4.465 1.525 4.465 -1 8 C-1.99 7.67 -2.98 7.34 -4 7 C-4 6.01 -4 5.02 -4 4 C-3.34 4 -2.68 4 -2 4 C-1.67 3.34 -1.34 2.68 -1 2 C-0.67 1.34 -0.34 0.68 0 0 Z "
      fill="#5957D7"
      transform="translate(338,348)"
    />
    <path
      d="M0 0 C2.625 1.3125 2.625 1.3125 5 3 C5 3.66 5 4.32 5 5 C3.35 5.66 1.7 6.32 0 7 C-0.66 5.02 -1.32 3.04 -2 1 C-1.34 0.67 -0.68 0.34 0 0 Z "
      fill="#5E5BDF"
      transform="translate(466,93)"
    />
    <path
      d="M0 0 C0 0.66 0 1.32 0 2 C-0.66 2 -1.32 2 -2 2 C-2 2.99 -2 3.98 -2 5 C-2.66 5 -3.32 5 -4 5 C-4.33 5.99 -4.66 6.98 -5 8 C-5.66 8 -6.32 8 -7 8 C-7.66 8.66 -8.32 9.32 -9 10 C-8.42110619 6.71245489 -7.45171589 5.06327505 -5.0625 2.75 C-4.53785156 2.22921875 -4.01320313 1.7084375 -3.47265625 1.171875 C-2 0 -2 0 0 0 Z "
      fill="#615EDD"
      transform="translate(268,419)"
    />
    <path
      d="M0 0 C0.99 0 1.98 0 3 0 C3 0.66 3 1.32 3 2 C3.66 2 4.32 2 5 2 C5.33 3.65 5.66 5.3 6 7 C3.5625 6.3125 3.5625 6.3125 1 5 C0.1875 2.375 0.1875 2.375 0 0 Z "
      fill="#7975E3"
      transform="translate(123,496)"
    />
    <path
      d="M0 0 C0 0.66 0 1.32 0 2 C1.32 2.66 2.64 3.32 4 4 C3.67 4.99 3.34 5.98 3 7 C-2.875 3.25 -2.875 3.25 -4 1 C-2 0 -2 0 0 0 Z "
      fill="#5751DC"
      transform="translate(118,490)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C2.1875 3.4375 2.1875 3.4375 1 6 C0.01 6.33 -0.98 6.66 -2 7 C-2.33 5.35 -2.66 3.7 -3 2 C-2.01 1.34 -1.02 0.68 0 0 Z "
      fill="#5B58E2"
      transform="translate(502,469)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C0.67 2.31 0.34 4.62 0 7 C-1.65 7.33 -3.3 7.66 -5 8 C-3.6299034 5.0490227 -2.06764583 2.51713405 0 0 Z "
      fill="#6D68E6"
      transform="translate(437,415)"
    />
    <path
      d="M0 0 C3.3 0 6.6 0 10 0 C9.67 1.32 9.34 2.64 9 4 C6.03 4 3.06 4 0 4 C0 2.68 0 1.36 0 0 Z "
      fill="#7B77E2"
      transform="translate(129,393)"
    />
    <path
      d="M0 0 C0.66 0 1.32 0 2 0 C2 3.63 2 7.26 2 11 C1.01 11.33 0.02 11.66 -1 12 C-0.67 8.04 -0.34 4.08 0 0 Z "
      fill="#7E7AEB"
      transform="translate(75,189)"
    />
    <path
      d="M0 0 C0.66 0 1.32 0 2 0 C2.66 1.98 3.32 3.96 4 6 C3.01 6.99 2.02 7.98 1 9 C1 7.68 1 6.36 1 5 C0.34 5 -0.32 5 -1 5 C-0.67 3.35 -0.34 1.7 0 0 Z "
      fill="#615ED7"
      transform="translate(515,151)"
    />
    <path
      d="M0 0 C0 0.66 0 1.32 0 2 C-1.43534841 2.2226746 -2.87345525 2.42761906 -4.3125 2.625 C-5.11300781 2.74101563 -5.91351563 2.85703125 -6.73828125 2.9765625 C-9 3 -9 3 -12 1 C-7.93631321 0.22596442 -4.13574827 -0.0984702 0 0 Z "
      fill="#5E5DD8"
      transform="translate(186,522)"
    />
    <path
      d="M0 0 C0.66 0 1.32 0 2 0 C2.33 0.99 2.66 1.98 3 3 C1.78515625 4.82421875 1.78515625 4.82421875 0.0625 6.6875 C-0.50339844 7.31011719 -1.06929688 7.93273437 -1.65234375 8.57421875 C-2.09707031 9.04472656 -2.54179687 9.51523437 -3 10 C-3.66 9.01 -4.32 8.02 -5 7 C-4.01 7 -3.02 7 -2 7 C-2 5.68 -2 4.36 -2 3 C-1.34 3 -0.68 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#5755D7"
      transform="translate(496,477)"
    />
    <path
      d="M0 0 C-1.625 2 -1.625 2 -4 4 C-7.25 4.25 -7.25 4.25 -10 4 C-4.4 -2.2 -4.4 -2.2 0 0 Z "
      fill="#6460DB"
      transform="translate(263,256)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C1.5020163 4.73487777 1.12508244 6.81237635 -1 10 C-1.33 7.36 -1.66 4.72 -2 2 C-1.34 2 -0.68 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#605ADC"
      transform="translate(332,186)"
    />
    <path
      d="M0 0 C1.32 0 2.64 0 4 0 C4 0.99 4 1.98 4 3 C5.65 2.67 7.3 2.34 9 2 C8.01 3.485 8.01 3.485 7 5 C4.03 4.01 1.06 3.02 -2 2 C-1.34 1.34 -0.68 0.68 0 0 Z "
      fill="#5855CD"
      transform="translate(402,160)"
    />
    <path
      d="M0 0 C-2.35968744 2.09749995 -3.54616994 2.96905704 -6.75 3.1875 C-7.86375 3.0946875 -7.86375 3.0946875 -9 3 C-8.67 2.01 -8.34 1.02 -8 0 C-5.13822943 -1.43088528 -3.06624227 -0.59991697 0 0 Z "
      fill="#6A65D6"
      transform="translate(450,516)"
    />
    <path
      d="M0 0 C1.65 0.33 3.3 0.66 5 1 C5 1.66 5 2.32 5 3 C0.56923077 5.09230769 0.56923077 5.09230769 -2.3125 4.625 C-2.869375 4.41875 -3.42625 4.2125 -4 4 C-4 3.34 -4 2.68 -4 2 C-2.68 2 -1.36 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#7D74E7"
      transform="translate(415,434)"
    />
    <path
      d="M0 0 C0.33 0.99 0.66 1.98 1 3 C-0.4375 5.6875 -0.4375 5.6875 -2 8 C-2.99 7.67 -3.98 7.34 -5 7 C-4.34 5.35 -3.68 3.7 -3 2 C-2.01 2 -1.02 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6D68DE"
      transform="translate(273,411)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C1.02 3.31 -0.96 5.62 -3 8 C-4.32 7.34 -5.64 6.68 -7 6 C-4 4 -4 4 -1 4 C-0.67 2.68 -0.34 1.36 0 0 Z "
      fill="#4744CE"
      transform="translate(175,346)"
    />
    <path
      d="M0 0 C0.33 0.99 0.66 1.98 1 3 C-1.70879335 4.35439668 -4.00933268 4.06501451 -7 4 C-7 3.34 -7 2.68 -7 2 C-4 0 -4 0 0 0 Z "
      fill="#5E5AD2"
      transform="translate(199,332)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 2.64 1 5.28 1 8 C0.34 8 -0.32 8 -1 8 C-1 9.65 -1 11.3 -1 13 C-1.33 13 -1.66 13 -2 13 C-2 9.7 -2 6.4 -2 3 C-1.34 3 -0.68 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#716DDD"
      transform="translate(279,221)"
    />
    <path
      d="M0 0 C1.32 0.66 2.64 1.32 4 2 C-1.75 7 -1.75 7 -4 7 C-4 6.01 -4 5.02 -4 4 C-3.34 4 -2.68 4 -2 4 C-2 3.34 -2 2.68 -2 2 C-1.34 2 -0.68 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#5D58DA"
      transform="translate(344,172)"
    />
    <path
      d="M0 0 C1.65 0.33 3.3 0.66 5 1 C1.31912647 3.45391569 -1.44355588 3.22802759 -5.6875 3.125 C-6.7403418 3.11146484 -6.7403418 3.11146484 -7.81445312 3.09765625 C-9.54311525 3.07413704 -11.27160145 3.03826713 -13 3 C-13 2.67 -13 2.34 -13 2 C-8.71 2 -4.42 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#625DD4"
      transform="translate(127,394)"
    />
    <path
      d="M0 0 C1.32 0 2.64 0 4 0 C4 0.66 4 1.32 4 2 C5.65 2 7.3 2 9 2 C9 3.65 9 5.3 9 7 C7.4972763 6.02501855 5.99788037 5.04490611 4.5 4.0625 C3.6646875 3.51722656 2.829375 2.97195313 1.96875 2.41015625 C1.3190625 1.94480469 0.669375 1.47945313 0 1 C0 0.67 0 0.34 0 0 Z "
      fill="#504DD4"
      transform="translate(251,340)"
    />
    <path
      d="M0 0 C2.475 0.99 2.475 0.99 5 2 C5 3.65 5 5.3 5 7 C3.02 5.68 1.04 4.36 -1 3 C-0.67 2.01 -0.34 1.02 0 0 Z "
      fill="#5B57E3"
      transform="translate(419,338)"
    />
    <path
      d="M0 0 C2.34058637 2.12780579 3.70700306 4.11562221 5 7 C4.01 7.495 4.01 7.495 3 8 C2.34 7.67 1.68 7.34 1 7 C1 6.34 1 5.68 1 5 C0.34 5 -0.32 5 -1 5 C-0.67 3.35 -0.34 1.7 0 0 Z "
      fill="#5850C8"
      transform="translate(333,239)"
    />
    <path
      d="M0 0 C0.26252625 4.33168317 -0.70756464 7.8803623 -2 12 C-2.33 12 -2.66 12 -3 12 C-4.35 4.63636364 -4.35 4.63636364 -2.625 1.5 C-1 0 -1 0 0 0 Z "
      fill="#6862DD"
      transform="translate(84,160)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C2.34 1 1.68 1 1 1 C1 1.66 1 2.32 1 3 C-0.32 3 -1.64 3 -3 3 C-3 3.66 -3 4.32 -3 5 C-4.65 5 -6.3 5 -8 5 C-7.67 4.01 -7.34 3.02 -7 2 C-4.69 2 -2.38 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6561D8"
      transform="translate(147,87)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C2.34 3.64 1.68 6.28 1 9 C0.34 9 -0.32 9 -1 9 C-0.7215625 7.824375 -0.7215625 7.824375 -0.4375 6.625 C0.25962266 4.02910225 0.25962266 4.02910225 -1 2 C-0.67 1.34 -0.34 0.68 0 0 Z "
      fill="#5956D7"
      transform="translate(518,432)"
    />
    <path
      d="M0 0 C0.66 0 1.32 0 2 0 C2 0.66 2 1.32 2 2 C4.31 2.33 6.62 2.66 9 3 C8.67 3.66 8.34 4.32 8 5 C5.125 4.75 5.125 4.75 2 4 C0.625 1.9375 0.625 1.9375 0 0 Z "
      fill="#615BD9"
      transform="translate(348,259)"
    />
    <path
      d="M0 0 C0.66 0 1.32 0 2 0 C1.75 1.875 1.75 1.875 1 4 C-1.0625 5.25 -1.0625 5.25 -3 6 C-3.66 5.34 -4.32 4.68 -5 4 C-4.34 3.34 -3.68 2.68 -3 2 C-2.01 2 -1.02 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6762E2"
      transform="translate(472,500)"
    />
    <path
      d="M0 0 C2.97 0.495 2.97 0.495 6 1 C6 1.66 6 2.32 6 3 C3.36 3.33 0.72 3.66 -2 4 C-1.34 2.68 -0.68 1.36 0 0 Z "
      fill="#716CE0"
      transform="translate(361,436)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1.33 2.64 1.66 5.28 2 8 C0.68 8 -0.64 8 -2 8 C-2.20086443 4.28400809 -2.1519437 3.22791555 0 0 Z "
      fill="#5D5BD4"
      transform="translate(162,226)"
    />
    <path
      d="M0 0 C-0.6875 2.4375 -0.6875 2.4375 -2 5 C-4.625 5.8125 -4.625 5.8125 -7 6 C-7 4 -7 4 -5.1875 1.875 C-3 0 -3 0 0 0 Z "
      fill="#6A64D9"
      transform="translate(183,168)"
    />
    <path
      d="M0 0 C1.32 0 2.64 0 4 0 C3.67 1.32 3.34 2.64 3 4 C1.35 4 -0.3 4 -2 4 C-2 3.34 -2 2.68 -2 2 C-1.34 2 -0.68 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#6764D5"
      transform="translate(354,334)"
    />
    <path
      d="M0 0 C0.33 0.99 0.66 1.98 1 3 C0.34 3 -0.32 3 -1 3 C-1.33 4.32 -1.66 5.64 -2 7 C-2.99 6.67 -3.98 6.34 -5 6 C-2.25 1.125 -2.25 1.125 0 0 Z "
      fill="#605ADB"
      transform="translate(271,243)"
    />
    <path
      d="M0 0 C1.32 0.33 2.64 0.66 4 1 C4 2.98 4 4.96 4 7 C3.34 7 2.68 7 2 7 C2 5.68 2 4.36 2 3 C1.34 3 0.68 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#655FD5"
      transform="translate(328,233)"
    />
    <path
      d="M0 0 C2.64 0.33 5.28 0.66 8 1 C4.73454239 2.88391785 1.71888239 3.49287967 -2 4 C-2 3.34 -2 2.68 -2 2 C-1.34 2 -0.68 2 0 2 C0 1.34 0 0.68 0 0 Z "
      fill="#5554CB"
      transform="translate(366,160)"
    />
    <path
      d="M0 0 C2.1875 1.4375 2.1875 1.4375 4 3 C2.02 3.99 2.02 3.99 0 5 C-0.99 4.34 -1.98 3.68 -3 3 C-3 2.34 -3 1.68 -3 1 C-2.01 0.67 -1.02 0.34 0 0 Z "
      fill="#6D66F0"
      transform="translate(424,520)"
    />
    <path
      d="M0 0 C2.31 0.33 4.62 0.66 7 1 C7.33 1.99 7.66 2.98 8 4 C5.61435923 3.42415568 3.33317216 2.77772405 1 2 C0.67 2.66 0.34 3.32 0 4 C0 2.68 0 1.36 0 0 Z "
      fill="#5E5BDF"
      transform="translate(432,517)"
    />
    <path
      d="M0 0 C0.99 0.66 1.98 1.32 3 2 C2.01 2.99 1.02 3.98 0 5 C-0.99 4.67 -1.98 4.34 -3 4 C-3 3.01 -3 2.02 -3 1 C-2.01 0.67 -1.02 0.34 0 0 Z "
      fill="#5A58D3"
      transform="translate(479,495)"
    />
    <path
      d="M0 0 C1.32 0.66 2.64 1.32 4 2 C4 3.32 4 4.64 4 6 C2.35 4.35 0.7 2.7 -1 1 C-0.67 0.67 -0.34 0.34 0 0 Z "
      fill="#4844D8"
      transform="translate(110,485)"
    />
    <path
      d="M0 0 C0.33 0.66 0.66 1.32 1 2 C1.66 2 2.32 2 3 2 C3 2.99 3 3.98 3 5 C3.66 5 4.32 5 5 5 C4.67 5.99 4.34 6.98 4 8 C2 6.25 2 6.25 0 4 C0 2.68 0 1.36 0 0 Z "
      fill="#6360D9"
      transform="translate(269,354)"
    />
    <path
      d="M0 0 C0.99 0 1.98 0 3 0 C3.33 1.65 3.66 3.3 4 5 C3.01 5 2.02 5 1 5 C0.67 3.35 0.34 1.7 0 0 Z "
      fill="#5652C2"
      transform="translate(431,348)"
    />
    <path
      d="M0 0 C2.5 1.375 2.5 1.375 5 3 C5 3.66 5 4.32 5 5 C3.68 5 2.36 5 1 5 C1 4.34 1 3.68 1 3 C0.34 3 -0.32 3 -1 3 C-0.67 2.01 -0.34 1.02 0 0 Z "
      fill="#605CE0"
      transform="translate(343,253)"
    />
    <path
      d="M0 0 C1.875 0.25 1.875 0.25 4 1 C5.25 3.0625 5.25 3.0625 6 5 C4.68 5 3.36 5 2 5 C2 4.34 2 3.68 2 3 C1.34 3 0.68 3 0 3 C0 2.01 0 1.02 0 0 Z "
      fill="#655CD6"
      transform="translate(496,121)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C2 3.64 2 6.28 2 9 C0.4375 7.3125 0.4375 7.3125 -1 5 C-0.6875 2.25 -0.6875 2.25 0 0 Z "
      fill="#514EDB"
      transform="translate(326,375)"
    />
  </svg>
);
export default SvgSerpSearchAPI;
