# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class A2BBreakdown(BaseModel):
    """
    A2B Breakdown - Shows the total, and each sub-element within an A2B Category  # noqa: E501
    """
    total: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The total value of all the components within this category.")
    currency: Optional[StrictStr] = Field(None, description="The currency. Applies to the Total, as well as all the componenents.")
    components: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = Field(None, description="The individual components that make up the category. For example, the Start category may have Cost, Unrealised gains and accrued interest components.")
    __properties = ["total", "currency", "components"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> A2BBreakdown:
        """Create an instance of A2BBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if currency (nullable) is None
        # and __fields_set__ contains the field
        if self.currency is None and "currency" in self.__fields_set__:
            _dict['currency'] = None

        # set to None if components (nullable) is None
        # and __fields_set__ contains the field
        if self.components is None and "components" in self.__fields_set__:
            _dict['components'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> A2BBreakdown:
        """Create an instance of A2BBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return A2BBreakdown.parse_obj(obj)

        _obj = A2BBreakdown.parse_obj({
            "total": obj.get("total"),
            "currency": obj.get("currency"),
            "components": obj.get("components")
        })
        return _obj
