# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from lusid.models.output_transaction import OutputTransaction
from lusid.models.portfolio_id import PortfolioId

class AccountedTransaction(BaseModel):
    """
    The Valuation Point Data Response for the Fund and specified date.  # noqa: E501
    """
    accounting_date: Optional[datetime] = Field(None, alias="accountingDate", description="The transaction's accounting date.")
    journal_entry_action: Optional[StrictStr] = Field(None, alias="journalEntryAction", description="The journal entry line action associated with this transaction.")
    transaction: Optional[OutputTransaction] = None
    portfolio_id: Optional[PortfolioId] = Field(None, alias="portfolioId")
    __properties = ["accountingDate", "journalEntryAction", "transaction", "portfolioId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountedTransaction:
        """Create an instance of AccountedTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of transaction
        if self.transaction:
            _dict['transaction'] = self.transaction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of portfolio_id
        if self.portfolio_id:
            _dict['portfolioId'] = self.portfolio_id.to_dict()
        # set to None if journal_entry_action (nullable) is None
        # and __fields_set__ contains the field
        if self.journal_entry_action is None and "journal_entry_action" in self.__fields_set__:
            _dict['journalEntryAction'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountedTransaction:
        """Create an instance of AccountedTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountedTransaction.parse_obj(obj)

        _obj = AccountedTransaction.parse_obj({
            "accounting_date": obj.get("accountingDate"),
            "journal_entry_action": obj.get("journalEntryAction"),
            "transaction": OutputTransaction.from_dict(obj.get("transaction")) if obj.get("transaction") is not None else None,
            "portfolio_id": PortfolioId.from_dict(obj.get("portfolioId")) if obj.get("portfolioId") is not None else None
        })
        return _obj
