# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.resource_id import ResourceId

class BookTransactionsRequest(BaseModel):
    """
    BookTransactionsRequest
    """
    allocation_ids: conlist(ResourceId, max_items=5000, min_items=1) = Field(..., alias="allocationIds", description="A collection of Allocation IDs")
    transaction_properties: Optional[Dict[str, PerpetualProperty]] = Field(None, alias="transactionProperties", description="A collection of properties")
    __properties = ["allocationIds", "transactionProperties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BookTransactionsRequest:
        """Create an instance of BookTransactionsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in allocation_ids (list)
        _items = []
        if self.allocation_ids:
            for _item in self.allocation_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['allocationIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in transaction_properties (dict)
        _field_dict = {}
        if self.transaction_properties:
            for _key in self.transaction_properties:
                if self.transaction_properties[_key]:
                    _field_dict[_key] = self.transaction_properties[_key].to_dict()
            _dict['transactionProperties'] = _field_dict
        # set to None if transaction_properties (nullable) is None
        # and __fields_set__ contains the field
        if self.transaction_properties is None and "transaction_properties" in self.__fields_set__:
            _dict['transactionProperties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BookTransactionsRequest:
        """Create an instance of BookTransactionsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BookTransactionsRequest.parse_obj(obj)

        _obj = BookTransactionsRequest.parse_obj({
            "allocation_ids": [ResourceId.from_dict(_item) for _item in obj.get("allocationIds")] if obj.get("allocationIds") is not None else None,
            "transaction_properties": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("transactionProperties").items()
            )
            if obj.get("transactionProperties") is not None
            else None
        })
        return _obj
