# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field
from lusid.models.order import Order
from lusid.models.resource_id import ResourceId

class CancelOrderAndMoveRemainingResult(BaseModel):
    """
    CancelOrderAndMoveRemainingResult
    """
    cancelled_order: Optional[Order] = Field(None, alias="cancelledOrder")
    new_order: Optional[Order] = Field(None, alias="newOrder")
    new_block_id: Optional[ResourceId] = Field(None, alias="newBlockId")
    __properties = ["cancelledOrder", "newOrder", "newBlockId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CancelOrderAndMoveRemainingResult:
        """Create an instance of CancelOrderAndMoveRemainingResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of cancelled_order
        if self.cancelled_order:
            _dict['cancelledOrder'] = self.cancelled_order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of new_order
        if self.new_order:
            _dict['newOrder'] = self.new_order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of new_block_id
        if self.new_block_id:
            _dict['newBlockId'] = self.new_block_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CancelOrderAndMoveRemainingResult:
        """Create an instance of CancelOrderAndMoveRemainingResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CancelOrderAndMoveRemainingResult.parse_obj(obj)

        _obj = CancelOrderAndMoveRemainingResult.parse_obj({
            "cancelled_order": Order.from_dict(obj.get("cancelledOrder")) if obj.get("cancelledOrder") is not None else None,
            "new_order": Order.from_dict(obj.get("newOrder")) if obj.get("newOrder") is not None else None,
            "new_block_id": ResourceId.from_dict(obj.get("newBlockId")) if obj.get("newBlockId") is not None else None
        })
        return _obj
