# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, constr

class CashElection(BaseModel):
    """
    Cash election for Events that result in a cash payment.  # noqa: E501
    """
    election_key: constr(strict=True, min_length=1) = Field(..., alias="electionKey", description="Unique key used to identify this election.")
    exchange_rate: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="exchangeRate", description="The exchange rate if this is not the declared CashElection.  Defaults to 1 if Election is Declared.")
    dividend_rate: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="dividendRate", description="The payment rate for this CashElection.")
    is_chosen: Optional[StrictBool] = Field(None, alias="isChosen", description="Has this election been chosen.  Only one Election may be Chosen per Event.")
    is_declared: Optional[StrictBool] = Field(None, alias="isDeclared", description="Is this the declared CashElection.  Only one Election may be Declared per Event.")
    is_default: Optional[StrictBool] = Field(None, alias="isDefault", description="Is this election the default.  Only one Election may be Default per Event")
    dividend_currency: StrictStr = Field(..., alias="dividendCurrency", description="The payment currency for this CashElection.")
    __properties = ["electionKey", "exchangeRate", "dividendRate", "isChosen", "isDeclared", "isDefault", "dividendCurrency"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CashElection:
        """Create an instance of CashElection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if exchange_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.exchange_rate is None and "exchange_rate" in self.__fields_set__:
            _dict['exchangeRate'] = None

        # set to None if dividend_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.dividend_rate is None and "dividend_rate" in self.__fields_set__:
            _dict['dividendRate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CashElection:
        """Create an instance of CashElection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CashElection.parse_obj(obj)

        _obj = CashElection.parse_obj({
            "election_key": obj.get("electionKey"),
            "exchange_rate": obj.get("exchangeRate"),
            "dividend_rate": obj.get("dividendRate"),
            "is_chosen": obj.get("isChosen"),
            "is_declared": obj.get("isDeclared"),
            "is_default": obj.get("isDefault"),
            "dividend_currency": obj.get("dividendCurrency")
        })
        return _obj
