# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class CompleteRelation(BaseModel):
    """
    Representation of a relation containing details of source and target entities, and both outward and inward descriptions.  # noqa: E501
    """
    href: Optional[StrictStr] = None
    version: Optional[Version] = None
    relation_definition_id: ResourceId = Field(..., alias="relationDefinitionId")
    source_entity_id: Dict[str, StrictStr] = Field(..., alias="sourceEntityId")
    target_entity_id: Dict[str, StrictStr] = Field(..., alias="targetEntityId")
    outward_description: constr(strict=True, min_length=1) = Field(..., alias="outwardDescription")
    inward_description: constr(strict=True, min_length=1) = Field(..., alias="inwardDescription")
    effective_from: Optional[datetime] = Field(None, alias="effectiveFrom")
    __properties = ["href", "version", "relationDefinitionId", "sourceEntityId", "targetEntityId", "outwardDescription", "inwardDescription", "effectiveFrom"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRelation:
        """Create an instance of CompleteRelation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relation_definition_id
        if self.relation_definition_id:
            _dict['relationDefinitionId'] = self.relation_definition_id.to_dict()
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRelation:
        """Create an instance of CompleteRelation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompleteRelation.parse_obj(obj)

        _obj = CompleteRelation.parse_obj({
            "href": obj.get("href"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "relation_definition_id": ResourceId.from_dict(obj.get("relationDefinitionId")) if obj.get("relationDefinitionId") is not None else None,
            "source_entity_id": obj.get("sourceEntityId"),
            "target_entity_id": obj.get("targetEntityId"),
            "outward_description": obj.get("outwardDescription"),
            "inward_description": obj.get("inwardDescription"),
            "effective_from": obj.get("effectiveFrom")
        })
        return _obj
