# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import BaseModel, Field, conlist, constr
from lusid.models.compliance_rule_result_portfolio_detail import ComplianceRuleResultPortfolioDetail
from lusid.models.resource_id import ResourceId

class ComplianceRuleResultDetail(BaseModel):
    """
    ComplianceRuleResultDetail
    """
    rule_id: ResourceId = Field(..., alias="ruleId")
    affected_portfolios_details: conlist(ComplianceRuleResultPortfolioDetail) = Field(..., alias="affectedPortfoliosDetails")
    affected_orders: conlist(ResourceId) = Field(..., alias="affectedOrders")
    template_id: ResourceId = Field(..., alias="templateId")
    template_description: constr(strict=True, min_length=1) = Field(..., alias="templateDescription")
    template_variation: constr(strict=True, min_length=1) = Field(..., alias="templateVariation")
    status: constr(strict=True, min_length=1) = Field(...)
    rule_name: constr(strict=True, min_length=1) = Field(..., alias="ruleName")
    rule_description: constr(strict=True, min_length=1) = Field(..., alias="ruleDescription")
    outcome: constr(strict=True, min_length=1) = Field(...)
    __properties = ["ruleId", "affectedPortfoliosDetails", "affectedOrders", "templateId", "templateDescription", "templateVariation", "status", "ruleName", "ruleDescription", "outcome"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ComplianceRuleResultDetail:
        """Create an instance of ComplianceRuleResultDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of rule_id
        if self.rule_id:
            _dict['ruleId'] = self.rule_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in affected_portfolios_details (list)
        _items = []
        if self.affected_portfolios_details:
            for _item in self.affected_portfolios_details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['affectedPortfoliosDetails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in affected_orders (list)
        _items = []
        if self.affected_orders:
            for _item in self.affected_orders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['affectedOrders'] = _items
        # override the default output from pydantic by calling `to_dict()` of template_id
        if self.template_id:
            _dict['templateId'] = self.template_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ComplianceRuleResultDetail:
        """Create an instance of ComplianceRuleResultDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ComplianceRuleResultDetail.parse_obj(obj)

        _obj = ComplianceRuleResultDetail.parse_obj({
            "rule_id": ResourceId.from_dict(obj.get("ruleId")) if obj.get("ruleId") is not None else None,
            "affected_portfolios_details": [ComplianceRuleResultPortfolioDetail.from_dict(_item) for _item in obj.get("affectedPortfoliosDetails")] if obj.get("affectedPortfoliosDetails") is not None else None,
            "affected_orders": [ResourceId.from_dict(_item) for _item in obj.get("affectedOrders")] if obj.get("affectedOrders") is not None else None,
            "template_id": ResourceId.from_dict(obj.get("templateId")) if obj.get("templateId") is not None else None,
            "template_description": obj.get("templateDescription"),
            "template_variation": obj.get("templateVariation"),
            "status": obj.get("status"),
            "rule_name": obj.get("ruleName"),
            "rule_description": obj.get("ruleDescription"),
            "outcome": obj.get("outcome")
        })
        return _obj
