# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, constr

class ComplianceTemplateParameter(BaseModel):
    """
    ComplianceTemplateParameter
    """
    name: constr(strict=True, min_length=1) = Field(..., description="The name for the required Compliance Template Parameter")
    description: constr(strict=True, min_length=1) = Field(..., description="The description for the required Compliance Template Parameter")
    type: constr(strict=True, min_length=1) = Field(..., description="The type for the required Compliance Template Parameter")
    __properties = ["name", "description", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ComplianceTemplateParameter:
        """Create an instance of ComplianceTemplateParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ComplianceTemplateParameter:
        """Create an instance of ComplianceTemplateParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ComplianceTemplateParameter.parse_obj(obj)

        _obj = ComplianceTemplateParameter.parse_obj({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "type": obj.get("type")
        })
        return _obj
