# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, constr, validator

class CreateSequenceRequest(BaseModel):
    """
    CreateSequenceRequest
    """
    code: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The code of the sequence definition to create")
    increment: Optional[StrictInt] = Field(None, description="The value to increment between each value in the sequence")
    min_value: Optional[StrictInt] = Field(None, alias="minValue", description="The minimum value of the sequence")
    max_value: Optional[StrictInt] = Field(None, alias="maxValue", description="The maximum value of the sequence")
    start: Optional[StrictInt] = Field(None, description="The start value of the sequence")
    cycle: Optional[StrictBool] = Field(None, description="Set to true to start the sequence over again when it reaches the end. Defaults to false if not provided.")
    pattern: Optional[constr(strict=True, max_length=44, min_length=1)] = Field(None, description="The pattern to be used to generate next values in the sequence. Defaults to null if not provided.")
    __properties = ["code", "increment", "minValue", "maxValue", "start", "cycle", "pattern"]

    @validator('code')
    def code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('pattern')
    def pattern_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[A-Za-z0-9_-]*\{\{seqValue\}\}[A-Za-z0-9_-]*$", value):
            raise ValueError(r"must validate the regular expression /^[A-Za-z0-9_-]*\{\{seqValue\}\}[A-Za-z0-9_-]*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateSequenceRequest:
        """Create an instance of CreateSequenceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if increment (nullable) is None
        # and __fields_set__ contains the field
        if self.increment is None and "increment" in self.__fields_set__:
            _dict['increment'] = None

        # set to None if min_value (nullable) is None
        # and __fields_set__ contains the field
        if self.min_value is None and "min_value" in self.__fields_set__:
            _dict['minValue'] = None

        # set to None if max_value (nullable) is None
        # and __fields_set__ contains the field
        if self.max_value is None and "max_value" in self.__fields_set__:
            _dict['maxValue'] = None

        # set to None if start (nullable) is None
        # and __fields_set__ contains the field
        if self.start is None and "start" in self.__fields_set__:
            _dict['start'] = None

        # set to None if pattern (nullable) is None
        # and __fields_set__ contains the field
        if self.pattern is None and "pattern" in self.__fields_set__:
            _dict['pattern'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateSequenceRequest:
        """Create an instance of CreateSequenceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateSequenceRequest.parse_obj(obj)

        _obj = CreateSequenceRequest.parse_obj({
            "code": obj.get("code"),
            "increment": obj.get("increment"),
            "min_value": obj.get("minValue"),
            "max_value": obj.get("maxValue"),
            "start": obj.get("start"),
            "cycle": obj.get("cycle"),
            "pattern": obj.get("pattern")
        })
        return _obj
