# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, constr, validator

class CreditRating(BaseModel):
    """
    Object describing a credit rating,  which assesses the stability and credit worthiness of a legal entity  and hence its likelihood of defaulting on its outstanding obligations (typically debt).  # noqa: E501
    """
    rating_source: constr(strict=True, max_length=64, min_length=1) = Field(..., alias="ratingSource", description="The provider of the credit rating, which will typically be an agency such as Moody's or Standard and Poor.")
    rating: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The credit rating provided by the rating source. This would expected to be consistent with the rating scheme of that agency/source.")
    __properties = ["ratingSource", "rating"]

    @validator('rating_source')
    def rating_source_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('rating')
    def rating_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-+\/]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-+\/]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreditRating:
        """Create an instance of CreditRating from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreditRating:
        """Create an instance of CreditRating from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreditRating.parse_obj(obj)

        _obj = CreditRating.parse_obj({
            "rating_source": obj.get("ratingSource"),
            "rating": obj.get("rating")
        })
        return _obj
