# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field
from lusid.models.dialect_id import DialectId
from lusid.models.dialect_schema import DialectSchema
from lusid.models.version import Version

class Dialect(BaseModel):
    """
    The language/format of a translatable entity. Entities can be LUSID native or external and the Dialect describes  1) the system that understands the entity and  2) applicable validation for the entity, in the form of a schema.  # noqa: E501
    """
    id: DialectId = Field(...)
    var_schema: DialectSchema = Field(..., alias="schema")
    version: Optional[Version] = None
    __properties = ["id", "schema", "version"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Dialect:
        """Create an instance of Dialect from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Dialect:
        """Create an instance of Dialect from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Dialect.parse_obj(obj)

        _obj = Dialect.parse_obj({
            "id": DialectId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "var_schema": DialectSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None
        })
        return _obj
