# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, constr
from lusid.models.lusid_instrument import LusidInstrument

class ExchangeTradedOptionContractDetails(BaseModel):
    """
    Most, if not all, information about contracts is standardised. See, e.g. https://www.cmegroup.com/ for  common codes and similar data. This appears to be in common use by well known market information providers, e.g. Bloomberg and Refinitiv.  There is a lot of overlap with this and FuturesContractDetails but as that is an established DTO we must duplicate a number of fields here  # noqa: E501
    """
    dom_ccy: StrictStr = Field(..., alias="domCcy", description="Currency in which the contract is paid.")
    strike: Union[StrictFloat, StrictInt] = Field(..., description="The option strike, this can be negative for some options.")
    contract_size: Union[StrictFloat, StrictInt] = Field(..., alias="contractSize", description="Size of a single contract. By default this should be set to 1000 if otherwise unknown and is defaulted to such.")
    country: constr(strict=True, min_length=1) = Field(..., description="Country (code) for the exchange.")
    delivery_type: constr(strict=True, min_length=1) = Field(..., alias="deliveryType", description="The delivery type, cash or physical. An option on a future is physically settled if upon exercising the  holder receives a future.    Supported string (enumeration) values are: [Cash, Physical].")
    description: constr(strict=True, min_length=1) = Field(..., description="Description of contract")
    exchange_code: constr(strict=True, min_length=1) = Field(..., alias="exchangeCode", description="Exchange code for contract. This can be any string to uniquely identify the exchange (e.g. Exchange Name, MIC, BBG code).")
    exercise_date: datetime = Field(..., alias="exerciseDate", description="The last exercise date of the option.")
    exercise_type: constr(strict=True, min_length=1) = Field(..., alias="exerciseType", description="The exercise type, European, American or Bermudan.    Supported string (enumeration) values are: [European, Bermudan, American].")
    option_code: constr(strict=True, min_length=1) = Field(..., alias="optionCode", description="Option Contract Code, typically one or two letters, e.g. OG => Option on Gold.")
    option_type: constr(strict=True, min_length=1) = Field(..., alias="optionType", description="The option type, Call or Put.    Supported string (enumeration) values are: [Call, Put].")
    underlying: LusidInstrument = Field(...)
    underlying_code: constr(strict=True, min_length=1) = Field(..., alias="underlyingCode", description="Code of the underlying, for an option on futures this should be the futures code.")
    delivery_days: Optional[StrictInt] = Field(None, alias="deliveryDays", description="Number of business days between exercise date and settlement of the option payoff or underlying.")
    business_day_convention: Optional[StrictStr] = Field(None, alias="businessDayConvention", description="The adjustment type to apply to dates that fall upon a non-business day, e.g. modified following or following.  Supported string (enumeration) values are: [NoAdjustment, Previous, P, Following, F, ModifiedPrevious, MP, ModifiedFollowing, MF, HalfMonthModifiedFollowing, Nearest].")
    settlement_calendars: Optional[conlist(StrictStr)] = Field(None, alias="settlementCalendars", description="An array of strings denoting calendars used in calculating the option settlement date.")
    __properties = ["domCcy", "strike", "contractSize", "country", "deliveryType", "description", "exchangeCode", "exerciseDate", "exerciseType", "optionCode", "optionType", "underlying", "underlyingCode", "deliveryDays", "businessDayConvention", "settlementCalendars"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExchangeTradedOptionContractDetails:
        """Create an instance of ExchangeTradedOptionContractDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of underlying
        if self.underlying:
            _dict['underlying'] = self.underlying.to_dict()
        # set to None if business_day_convention (nullable) is None
        # and __fields_set__ contains the field
        if self.business_day_convention is None and "business_day_convention" in self.__fields_set__:
            _dict['businessDayConvention'] = None

        # set to None if settlement_calendars (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_calendars is None and "settlement_calendars" in self.__fields_set__:
            _dict['settlementCalendars'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExchangeTradedOptionContractDetails:
        """Create an instance of ExchangeTradedOptionContractDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExchangeTradedOptionContractDetails.parse_obj(obj)

        _obj = ExchangeTradedOptionContractDetails.parse_obj({
            "dom_ccy": obj.get("domCcy"),
            "strike": obj.get("strike"),
            "contract_size": obj.get("contractSize"),
            "country": obj.get("country"),
            "delivery_type": obj.get("deliveryType"),
            "description": obj.get("description"),
            "exchange_code": obj.get("exchangeCode"),
            "exercise_date": obj.get("exerciseDate"),
            "exercise_type": obj.get("exerciseType"),
            "option_code": obj.get("optionCode"),
            "option_type": obj.get("optionType"),
            "underlying": LusidInstrument.from_dict(obj.get("underlying")) if obj.get("underlying") is not None else None,
            "underlying_code": obj.get("underlyingCode"),
            "delivery_days": obj.get("deliveryDays"),
            "business_day_convention": obj.get("businessDayConvention"),
            "settlement_calendars": obj.get("settlementCalendars")
        })
        return _obj
