# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from lusid.models.break_code_source import BreakCodeSource
from lusid.models.group_reconciliation_definition_comparison_ruleset_ids import GroupReconciliationDefinitionComparisonRulesetIds
from lusid.models.group_reconciliation_definition_currencies import GroupReconciliationDefinitionCurrencies
from lusid.models.group_reconciliation_definition_portfolio_entity_ids import GroupReconciliationDefinitionPortfolioEntityIds
from lusid.models.group_reconciliation_definition_recipe_ids import GroupReconciliationDefinitionRecipeIds
from lusid.models.resource_id import ResourceId
from lusid.models.transaction_date_windows import TransactionDateWindows
from lusid.models.version import Version

class GroupReconciliationDefinition(BaseModel):
    """
    GroupReconciliationDefinition
    """
    id: Optional[ResourceId] = None
    display_name: Optional[StrictStr] = Field(None, alias="displayName", description="The name of the Group Reconciliation Definition")
    description: Optional[StrictStr] = Field(None, description="The description of the Group Reconciliation Definition")
    portfolio_entity_ids: Optional[GroupReconciliationDefinitionPortfolioEntityIds] = Field(None, alias="portfolioEntityIds")
    recipe_ids: Optional[GroupReconciliationDefinitionRecipeIds] = Field(None, alias="recipeIds")
    currencies: Optional[GroupReconciliationDefinitionCurrencies] = None
    transaction_date_windows: Optional[TransactionDateWindows] = Field(None, alias="transactionDateWindows")
    comparison_ruleset_ids: Optional[GroupReconciliationDefinitionComparisonRulesetIds] = Field(None, alias="comparisonRulesetIds")
    break_code_source: Optional[BreakCodeSource] = Field(None, alias="breakCodeSource")
    href: Optional[StrictStr] = Field(None, description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.")
    version: Optional[Version] = None
    __properties = ["id", "displayName", "description", "portfolioEntityIds", "recipeIds", "currencies", "transactionDateWindows", "comparisonRulesetIds", "breakCodeSource", "href", "version"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationDefinition:
        """Create an instance of GroupReconciliationDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of portfolio_entity_ids
        if self.portfolio_entity_ids:
            _dict['portfolioEntityIds'] = self.portfolio_entity_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recipe_ids
        if self.recipe_ids:
            _dict['recipeIds'] = self.recipe_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currencies
        if self.currencies:
            _dict['currencies'] = self.currencies.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_date_windows
        if self.transaction_date_windows:
            _dict['transactionDateWindows'] = self.transaction_date_windows.to_dict()
        # override the default output from pydantic by calling `to_dict()` of comparison_ruleset_ids
        if self.comparison_ruleset_ids:
            _dict['comparisonRulesetIds'] = self.comparison_ruleset_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of break_code_source
        if self.break_code_source:
            _dict['breakCodeSource'] = self.break_code_source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationDefinition:
        """Create an instance of GroupReconciliationDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationDefinition.parse_obj(obj)

        _obj = GroupReconciliationDefinition.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "portfolio_entity_ids": GroupReconciliationDefinitionPortfolioEntityIds.from_dict(obj.get("portfolioEntityIds")) if obj.get("portfolioEntityIds") is not None else None,
            "recipe_ids": GroupReconciliationDefinitionRecipeIds.from_dict(obj.get("recipeIds")) if obj.get("recipeIds") is not None else None,
            "currencies": GroupReconciliationDefinitionCurrencies.from_dict(obj.get("currencies")) if obj.get("currencies") is not None else None,
            "transaction_date_windows": TransactionDateWindows.from_dict(obj.get("transactionDateWindows")) if obj.get("transactionDateWindows") is not None else None,
            "comparison_ruleset_ids": GroupReconciliationDefinitionComparisonRulesetIds.from_dict(obj.get("comparisonRulesetIds")) if obj.get("comparisonRulesetIds") is not None else None,
            "break_code_source": BreakCodeSource.from_dict(obj.get("breakCodeSource")) if obj.get("breakCodeSource") is not None else None,
            "href": obj.get("href"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None
        })
        return _obj
