# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from lusid.models.group_reconciliation_user_review_break_code import GroupReconciliationUserReviewBreakCode
from lusid.models.group_reconciliation_user_review_comment import GroupReconciliationUserReviewComment
from lusid.models.group_reconciliation_user_review_match_key import GroupReconciliationUserReviewMatchKey

class GroupReconciliationUserReview(BaseModel):
    """
    GroupReconciliationUserReview
    """
    break_codes: Optional[conlist(GroupReconciliationUserReviewBreakCode)] = Field(None, alias="breakCodes", description="A list of break codes shared between the reconciliation runs of the same run instance and result hash.")
    match_keys: Optional[conlist(GroupReconciliationUserReviewMatchKey)] = Field(None, alias="matchKeys", description="A list of match keys shared between the reconciliation runs of the same run instance and result hash.")
    comments: Optional[conlist(GroupReconciliationUserReviewComment)] = Field(None, description="A list of comments shared between the reconciliation runs of the same run instance and result hash.")
    __properties = ["breakCodes", "matchKeys", "comments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationUserReview:
        """Create an instance of GroupReconciliationUserReview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in break_codes (list)
        _items = []
        if self.break_codes:
            for _item in self.break_codes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['breakCodes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in match_keys (list)
        _items = []
        if self.match_keys:
            for _item in self.match_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['matchKeys'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item in self.comments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comments'] = _items
        # set to None if break_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.break_codes is None and "break_codes" in self.__fields_set__:
            _dict['breakCodes'] = None

        # set to None if match_keys (nullable) is None
        # and __fields_set__ contains the field
        if self.match_keys is None and "match_keys" in self.__fields_set__:
            _dict['matchKeys'] = None

        # set to None if comments (nullable) is None
        # and __fields_set__ contains the field
        if self.comments is None and "comments" in self.__fields_set__:
            _dict['comments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationUserReview:
        """Create an instance of GroupReconciliationUserReview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationUserReview.parse_obj(obj)

        _obj = GroupReconciliationUserReview.parse_obj({
            "break_codes": [GroupReconciliationUserReviewBreakCode.from_dict(_item) for _item in obj.get("breakCodes")] if obj.get("breakCodes") is not None else None,
            "match_keys": [GroupReconciliationUserReviewMatchKey.from_dict(_item) for _item in obj.get("matchKeys")] if obj.get("matchKeys") is not None else None,
            "comments": [GroupReconciliationUserReviewComment.from_dict(_item) for _item in obj.get("comments")] if obj.get("comments") is not None else None
        })
        return _obj
