# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist
from lusid.models.resource_id import ResourceId

class InstrumentEventConfiguration(BaseModel):
    """
    InstrumentEventConfiguration
    """
    transaction_template_scopes: Optional[conlist(StrictStr, max_items=1)] = Field(None, alias="transactionTemplateScopes")
    recipe_id: Optional[ResourceId] = Field(None, alias="recipeId")
    __properties = ["transactionTemplateScopes", "recipeId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentEventConfiguration:
        """Create an instance of InstrumentEventConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of recipe_id
        if self.recipe_id:
            _dict['recipeId'] = self.recipe_id.to_dict()
        # set to None if transaction_template_scopes (nullable) is None
        # and __fields_set__ contains the field
        if self.transaction_template_scopes is None and "transaction_template_scopes" in self.__fields_set__:
            _dict['transactionTemplateScopes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentEventConfiguration:
        """Create an instance of InstrumentEventConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentEventConfiguration.parse_obj(obj)

        _obj = InstrumentEventConfiguration.parse_obj({
            "transaction_template_scopes": obj.get("transactionTemplateScopes"),
            "recipe_id": ResourceId.from_dict(obj.get("recipeId")) if obj.get("recipeId") is not None else None
        })
        return _obj
