# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, constr, validator

class InstrumentResolutionDetail(BaseModel):
    """
    InstrumentResolutionDetail
    """
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers", description="Unique instrument identifiers")
    lusid_instrument_id: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, alias="lusidInstrumentId", description="LUSID's internal unique instrument identifier, resolved from the instrument identifiers")
    instrument_scope: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, alias="instrumentScope", description="The scope in which the instrument lies.")
    launch_price: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="launchPrice", description="The launch price set when a shareclass is added to the fund. Defaults to 1.")
    launch_date: Optional[datetime] = Field(None, alias="launchDate", description="The launch date set when a shareclass is added to the fund. Defaults to Fund Inception Date.")
    __properties = ["instrumentIdentifiers", "lusidInstrumentId", "instrumentScope", "launchPrice", "launchDate"]

    @validator('lusid_instrument_id')
    def lusid_instrument_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('instrument_scope')
    def instrument_scope_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentResolutionDetail:
        """Create an instance of InstrumentResolutionDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "lusid_instrument_id",
                            "instrument_scope",
                          },
                          exclude_none=True)
        # set to None if lusid_instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.lusid_instrument_id is None and "lusid_instrument_id" in self.__fields_set__:
            _dict['lusidInstrumentId'] = None

        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        # set to None if launch_price (nullable) is None
        # and __fields_set__ contains the field
        if self.launch_price is None and "launch_price" in self.__fields_set__:
            _dict['launchPrice'] = None

        # set to None if launch_date (nullable) is None
        # and __fields_set__ contains the field
        if self.launch_date is None and "launch_date" in self.__fields_set__:
            _dict['launchDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentResolutionDetail:
        """Create an instance of InstrumentResolutionDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentResolutionDetail.parse_obj(obj)

        _obj = InstrumentResolutionDetail.parse_obj({
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "launch_price": obj.get("launchPrice"),
            "launch_date": obj.get("launchDate")
        })
        return _obj
