# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, StrictStr, constr

class InstrumentSearchProperty(BaseModel):
    """
    InstrumentSearchProperty
    """
    key: StrictStr = Field(..., description="The property key of instrument property to search for. This will be from the 'Instrument' domain and will take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Isin' or 'Instrument/MyScope/AssetClass'.")
    value: constr(strict=True, min_length=1) = Field(..., description="The value of the property e.g. 'US0378331005' or 'Equity'.")
    __properties = ["key", "value"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentSearchProperty:
        """Create an instance of InstrumentSearchProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentSearchProperty:
        """Create an instance of InstrumentSearchProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentSearchProperty.parse_obj(obj)

        _obj = InstrumentSearchProperty.parse_obj({
            "key": obj.get("key"),
            "value": obj.get("value")
        })
        return _obj
