# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, constr
from lusid.models.currency_and_amount import CurrencyAndAmount
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.resource_id import ResourceId

class PlacementRequest(BaseModel):
    """
    A request to create or update a Placement.  # noqa: E501
    """
    id: ResourceId = Field(...)
    parent_placement_id: Optional[ResourceId] = Field(None, alias="parentPlacementId")
    block_ids: conlist(ResourceId) = Field(..., alias="blockIds", description="The IDs of the Blocks associated with this placement.")
    properties: Optional[Dict[str, PerpetualProperty]] = Field(None, description="Client-defined properties associated with this order.")
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers", description="The instrument ordered.")
    quantity: Union[StrictFloat, StrictInt] = Field(..., description="The quantity of given instrument ordered.")
    state: constr(strict=True, min_length=1) = Field(..., description="The state of this placement (typically a FIX state; Open, Filled, etc).")
    side: constr(strict=True, min_length=1) = Field(..., description="The side (Buy, Sell, ...) of this placement.")
    time_in_force: constr(strict=True, min_length=1) = Field(..., alias="timeInForce", description="The time in force applicable to this placement (GTC, FOK, Day, etc)")
    type: constr(strict=True, min_length=1) = Field(..., description="The type of this placement (Market, Limit, etc).")
    created_date: datetime = Field(..., alias="createdDate", description="The active date of this placement.")
    limit_price: Optional[CurrencyAndAmount] = Field(None, alias="limitPrice")
    stop_price: Optional[CurrencyAndAmount] = Field(None, alias="stopPrice")
    counterparty: Optional[StrictStr] = Field(None, description="Optionally specifies the market entity this placement is placed with.")
    execution_system: Optional[constr(strict=True, max_length=256, min_length=1)] = Field(None, alias="executionSystem", description="Optionally specifies the execution system in use.")
    entry_type: Optional[constr(strict=True, max_length=256, min_length=1)] = Field(None, alias="entryType", description="Optionally specifies the entry type of this placement.")
    __properties = ["id", "parentPlacementId", "blockIds", "properties", "instrumentIdentifiers", "quantity", "state", "side", "timeInForce", "type", "createdDate", "limitPrice", "stopPrice", "counterparty", "executionSystem", "entryType"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlacementRequest:
        """Create an instance of PlacementRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_placement_id
        if self.parent_placement_id:
            _dict['parentPlacementId'] = self.parent_placement_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in block_ids (list)
        _items = []
        if self.block_ids:
            for _item in self.block_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['blockIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of limit_price
        if self.limit_price:
            _dict['limitPrice'] = self.limit_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop_price
        if self.stop_price:
            _dict['stopPrice'] = self.stop_price.to_dict()
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if counterparty (nullable) is None
        # and __fields_set__ contains the field
        if self.counterparty is None and "counterparty" in self.__fields_set__:
            _dict['counterparty'] = None

        # set to None if execution_system (nullable) is None
        # and __fields_set__ contains the field
        if self.execution_system is None and "execution_system" in self.__fields_set__:
            _dict['executionSystem'] = None

        # set to None if entry_type (nullable) is None
        # and __fields_set__ contains the field
        if self.entry_type is None and "entry_type" in self.__fields_set__:
            _dict['entryType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlacementRequest:
        """Create an instance of PlacementRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PlacementRequest.parse_obj(obj)

        _obj = PlacementRequest.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "parent_placement_id": ResourceId.from_dict(obj.get("parentPlacementId")) if obj.get("parentPlacementId") is not None else None,
            "block_ids": [ResourceId.from_dict(_item) for _item in obj.get("blockIds")] if obj.get("blockIds") is not None else None,
            "properties": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "quantity": obj.get("quantity"),
            "state": obj.get("state"),
            "side": obj.get("side"),
            "time_in_force": obj.get("timeInForce"),
            "type": obj.get("type"),
            "created_date": obj.get("createdDate"),
            "limit_price": CurrencyAndAmount.from_dict(obj.get("limitPrice")) if obj.get("limitPrice") is not None else None,
            "stop_price": CurrencyAndAmount.from_dict(obj.get("stopPrice")) if obj.get("stopPrice") is not None else None,
            "counterparty": obj.get("counterparty"),
            "execution_system": obj.get("executionSystem"),
            "entry_type": obj.get("entryType")
        })
        return _obj
