# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from lusid.models.from_recipe import FromRecipe

class RecipeValue(BaseModel):
    """
    Recipe value represents a data that is then used to perform an atomic operation which is then used in composition of Configuration Recipe.  This object either includes the data itself (in json form or as simple string) or is a reference where the data can be obtained from (from a Configuration Recipe say).  Only one field is to be populated.  # noqa: E501
    """
    as_json: Optional[StrictStr] = Field(None, alias="asJson", description="Field to allow providing a potentially complex json value.")
    as_string: Optional[StrictStr] = Field(None, alias="asString", description="For simple value, a single input value, note complex nested objects are not allowed here.")
    from_recipe: Optional[FromRecipe] = Field(None, alias="fromRecipe")
    __properties = ["asJson", "asString", "fromRecipe"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RecipeValue:
        """Create an instance of RecipeValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of from_recipe
        if self.from_recipe:
            _dict['fromRecipe'] = self.from_recipe.to_dict()
        # set to None if as_json (nullable) is None
        # and __fields_set__ contains the field
        if self.as_json is None and "as_json" in self.__fields_set__:
            _dict['asJson'] = None

        # set to None if as_string (nullable) is None
        # and __fields_set__ contains the field
        if self.as_string is None and "as_string" in self.__fields_set__:
            _dict['asString'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RecipeValue:
        """Create an instance of RecipeValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RecipeValue.parse_obj(obj)

        _obj = RecipeValue.parse_obj({
            "as_json": obj.get("asJson"),
            "as_string": obj.get("asString"),
            "from_recipe": FromRecipe.from_dict(obj.get("fromRecipe")) if obj.get("fromRecipe") is not None else None
        })
        return _obj
