# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field

class ReconciliationLine(BaseModel):
    """
    In evaluating a left and right hand side holding or valuation set, two data records result. These are then compared based on a set of  rules. This results in either a match or failure to match. If there is a match both left and right will be present, otherwise one will not.  A difference will be present if a match was calculated.  The options used in comparison may result in elision of results where an exact or tolerable match is made.  # noqa: E501
    """
    left: Optional[Dict[str, Dict[str, Any]]] = Field(None, description="Left hand side of the comparison")
    right: Optional[Dict[str, Dict[str, Any]]] = Field(None, description="Right hand side of the comparison")
    difference: Optional[Dict[str, Dict[str, Any]]] = Field(None, description="Difference between LHS and RHS of comparison")
    result_comparison: Optional[Dict[str, Dict[str, Any]]] = Field(None, alias="resultComparison", description="The logical or semantic description of the difference, e.g. \"Matches\" or \"MatchesWithTolerance\" or \"Failed\".")
    __properties = ["left", "right", "difference", "resultComparison"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReconciliationLine:
        """Create an instance of ReconciliationLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if left (nullable) is None
        # and __fields_set__ contains the field
        if self.left is None and "left" in self.__fields_set__:
            _dict['left'] = None

        # set to None if right (nullable) is None
        # and __fields_set__ contains the field
        if self.right is None and "right" in self.__fields_set__:
            _dict['right'] = None

        # set to None if difference (nullable) is None
        # and __fields_set__ contains the field
        if self.difference is None and "difference" in self.__fields_set__:
            _dict['difference'] = None

        # set to None if result_comparison (nullable) is None
        # and __fields_set__ contains the field
        if self.result_comparison is None and "result_comparison" in self.__fields_set__:
            _dict['resultComparison'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReconciliationLine:
        """Create an instance of ReconciliationLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReconciliationLine.parse_obj(obj)

        _obj = ReconciliationLine.parse_obj({
            "left": obj.get("left"),
            "right": obj.get("right"),
            "difference": obj.get("difference"),
            "result_comparison": obj.get("resultComparison")
        })
        return _obj
