# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field
from lusid.models.model_property import ModelProperty

class SetPersonIdentifiersRequest(BaseModel):
    """
    SetPersonIdentifiersRequest
    """
    identifiers: Optional[Dict[str, ModelProperty]] = Field(None, description="Identifiers to set for a Person. Identifiers not included in the request will not be amended.")
    __properties = ["identifiers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetPersonIdentifiersRequest:
        """Create an instance of SetPersonIdentifiersRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in identifiers (dict)
        _field_dict = {}
        if self.identifiers:
            for _key in self.identifiers:
                if self.identifiers[_key]:
                    _field_dict[_key] = self.identifiers[_key].to_dict()
            _dict['identifiers'] = _field_dict
        # set to None if identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.identifiers is None and "identifiers" in self.__fields_set__:
            _dict['identifiers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetPersonIdentifiersRequest:
        """Create an instance of SetPersonIdentifiersRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetPersonIdentifiersRequest.parse_obj(obj)

        _obj = SetPersonIdentifiersRequest.parse_obj({
            "identifiers": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("identifiers").items()
            )
            if obj.get("identifiers") is not None
            else None
        })
        return _obj
