# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field
from lusid.models.share_class_amount import ShareClassAmount

class ShareClassPnlBreakdown(BaseModel):
    """
    The breakdown of PnL for a Share Class on a specified date.  # noqa: E501
    """
    apportioned_non_class_specific_pnl: Dict[str, ShareClassAmount] = Field(..., alias="apportionedNonClassSpecificPnl", description="Bucket of detail for PnL within the queried period not explicitly allocated to any share class but has been apportioned to the share class.")
    class_pnl: Dict[str, ShareClassAmount] = Field(..., alias="classPnl", description="Bucket of detail for PnL specific to the share class within the queried period.")
    total_pnl: Dict[str, ShareClassAmount] = Field(..., alias="totalPnl", description="Bucket of detail for the sum of class PnL and PnL not specific to a class within the queried period.")
    __properties = ["apportionedNonClassSpecificPnl", "classPnl", "totalPnl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ShareClassPnlBreakdown:
        """Create an instance of ShareClassPnlBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in apportioned_non_class_specific_pnl (dict)
        _field_dict = {}
        if self.apportioned_non_class_specific_pnl:
            for _key in self.apportioned_non_class_specific_pnl:
                if self.apportioned_non_class_specific_pnl[_key]:
                    _field_dict[_key] = self.apportioned_non_class_specific_pnl[_key].to_dict()
            _dict['apportionedNonClassSpecificPnl'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in class_pnl (dict)
        _field_dict = {}
        if self.class_pnl:
            for _key in self.class_pnl:
                if self.class_pnl[_key]:
                    _field_dict[_key] = self.class_pnl[_key].to_dict()
            _dict['classPnl'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in total_pnl (dict)
        _field_dict = {}
        if self.total_pnl:
            for _key in self.total_pnl:
                if self.total_pnl[_key]:
                    _field_dict[_key] = self.total_pnl[_key].to_dict()
            _dict['totalPnl'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ShareClassPnlBreakdown:
        """Create an instance of ShareClassPnlBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ShareClassPnlBreakdown.parse_obj(obj)

        _obj = ShareClassPnlBreakdown.parse_obj({
            "apportioned_non_class_specific_pnl": dict(
                (_k, ShareClassAmount.from_dict(_v))
                for _k, _v in obj.get("apportionedNonClassSpecificPnl").items()
            )
            if obj.get("apportionedNonClassSpecificPnl") is not None
            else None,
            "class_pnl": dict(
                (_k, ShareClassAmount.from_dict(_v))
                for _k, _v in obj.get("classPnl").items()
            )
            if obj.get("classPnl") is not None
            else None,
            "total_pnl": dict(
                (_k, ShareClassAmount.from_dict(_v))
                for _k, _v in obj.get("totalPnl").items()
            )
            if obj.get("totalPnl") is not None
            else None
        })
        return _obj
