# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, constr

class SideDefinitionRequest(BaseModel):
    """
    SideDefinitionRequest
    """
    security: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The field or property key defining the side's security, or instrument.")
    currency: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The field or property key defining the side's currency.")
    rate: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The field or property key defining the side's rate.")
    units: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The value, field or property key defining the side's units.")
    amount: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The value, field or property key defining the side's amount")
    notional_amount: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, alias="notionalAmount", description="The value, field or property key defining the side's notional amount")
    current_face: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, alias="currentFace", description="The value, field or property key defining the side's current face / outstanding notional.")
    __properties = ["security", "currency", "rate", "units", "amount", "notionalAmount", "currentFace"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SideDefinitionRequest:
        """Create an instance of SideDefinitionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if notional_amount (nullable) is None
        # and __fields_set__ contains the field
        if self.notional_amount is None and "notional_amount" in self.__fields_set__:
            _dict['notionalAmount'] = None

        # set to None if current_face (nullable) is None
        # and __fields_set__ contains the field
        if self.current_face is None and "current_face" in self.__fields_set__:
            _dict['currentFace'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SideDefinitionRequest:
        """Create an instance of SideDefinitionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SideDefinitionRequest.parse_obj(obj)

        _obj = SideDefinitionRequest.parse_obj({
            "security": obj.get("security"),
            "currency": obj.get("currency"),
            "rate": obj.get("rate"),
            "units": obj.get("units"),
            "amount": obj.get("amount"),
            "notional_amount": obj.get("notionalAmount"),
            "current_face": obj.get("currentFace")
        })
        return _obj
