# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class SimpleRoundingConvention(BaseModel):
    """
    Certain bonds will follow certain rounding conventions.  For example, Thai government bonds will round accrued interest and cashflow values 2dp, whereas for  French government bonds, the rounding is to 7dp.  # noqa: E501
    """
    precision: Optional[StrictInt] = Field(None, description="The precision of the rounding. The decimal places or significant figures to which the rounding takes place.")
    rounding_type: Optional[StrictStr] = Field(None, alias="roundingType", description="The type of rounding.  e.g. Round Up, Round Down    Supported string (enumeration) values are: [Down, Up, Nearest].")
    __properties = ["precision", "roundingType"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SimpleRoundingConvention:
        """Create an instance of SimpleRoundingConvention from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if rounding_type (nullable) is None
        # and __fields_set__ contains the field
        if self.rounding_type is None and "rounding_type" in self.__fields_set__:
            _dict['roundingType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SimpleRoundingConvention:
        """Create an instance of SimpleRoundingConvention from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SimpleRoundingConvention.parse_obj(obj)

        _obj = SimpleRoundingConvention.parse_obj({
            "precision": obj.get("precision"),
            "rounding_type": obj.get("roundingType")
        })
        return _obj
