# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, constr
from lusid.models.dependency_source_filter import DependencySourceFilter

class SpecificHoldingPricingInfo(BaseModel):
    """
    Allows a user to specify fallbacks/overrides using Holding fields for sources that match a particular DependencySourceFilter.  # noqa: E501
    """
    dependency_source_filter: DependencySourceFilter = Field(..., alias="dependencySourceFilter")
    field: constr(strict=True, min_length=1) = Field(..., description="The Holding field which the fallback/override should use to create a price quote.")
    __properties = ["dependencySourceFilter", "field"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SpecificHoldingPricingInfo:
        """Create an instance of SpecificHoldingPricingInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of dependency_source_filter
        if self.dependency_source_filter:
            _dict['dependencySourceFilter'] = self.dependency_source_filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SpecificHoldingPricingInfo:
        """Create an instance of SpecificHoldingPricingInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SpecificHoldingPricingInfo.parse_obj(obj)

        _obj = SpecificHoldingPricingInfo.parse_obj({
            "dependency_source_filter": DependencySourceFilter.from_dict(obj.get("dependencySourceFilter")) if obj.get("dependencySourceFilter") is not None else None,
            "field": obj.get("field")
        })
        return _obj
