# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, constr
from lusid.models.staging_rule_approval_criteria import StagingRuleApprovalCriteria
from lusid.models.staging_rule_match_criteria import StagingRuleMatchCriteria

class StagingRule(BaseModel):
    """
    StagingRule
    """
    rule_id: constr(strict=True, max_length=64, min_length=1) = Field(..., alias="ruleId", description="The ID of the staging rule.")
    description: Optional[constr(strict=True, max_length=1024, min_length=0)] = Field(None, description="A description for the staging rule.")
    status: constr(strict=True, min_length=1) = Field(..., description="Whether the rule is 'Active' or 'Inactive'.")
    match_criteria: StagingRuleMatchCriteria = Field(..., alias="matchCriteria")
    approval_criteria: StagingRuleApprovalCriteria = Field(..., alias="approvalCriteria")
    __properties = ["ruleId", "description", "status", "matchCriteria", "approvalCriteria"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagingRule:
        """Create an instance of StagingRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of match_criteria
        if self.match_criteria:
            _dict['matchCriteria'] = self.match_criteria.to_dict()
        # override the default output from pydantic by calling `to_dict()` of approval_criteria
        if self.approval_criteria:
            _dict['approvalCriteria'] = self.approval_criteria.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagingRule:
        """Create an instance of StagingRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagingRule.parse_obj(obj)

        _obj = StagingRule.parse_obj({
            "rule_id": obj.get("ruleId"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "match_criteria": StagingRuleMatchCriteria.from_dict(obj.get("matchCriteria")) if obj.get("matchCriteria") is not None else None,
            "approval_criteria": StagingRuleApprovalCriteria.from_dict(obj.get("approvalCriteria")) if obj.get("approvalCriteria") is not None else None
        })
        return _obj
