# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr
from lusid.models.data_map_key import DataMapKey

class StructuredResultData(BaseModel):
    """
    An item of structured result data that is to be inserted into Lusid. This will typically be a Json or Xml document that  contains a set of result data appropriate to a specific entity such as an instrument or potentially an index.  # noqa: E501
    """
    document_format: constr(strict=True, max_length=128, min_length=0) = Field(..., alias="documentFormat", description="The format of the accompanying document.")
    version: Optional[StrictStr] = Field(None, description="The semantic version of the document format; MAJOR.MINOR.PATCH")
    name: Optional[constr(strict=True, max_length=256, min_length=1)] = Field(None, description="The name or description for the document")
    document: constr(strict=True, max_length=1000000, min_length=0) = Field(..., description="The document that will be stored (or retrieved) and which describes a unit result data entity such as a set of prices or yields")
    data_map_key: Optional[DataMapKey] = Field(None, alias="dataMapKey")
    __properties = ["documentFormat", "version", "name", "document", "dataMapKey"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StructuredResultData:
        """Create an instance of StructuredResultData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data_map_key
        if self.data_map_key:
            _dict['dataMapKey'] = self.data_map_key.to_dict()
        # set to None if version (nullable) is None
        # and __fields_set__ contains the field
        if self.version is None and "version" in self.__fields_set__:
            _dict['version'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StructuredResultData:
        """Create an instance of StructuredResultData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StructuredResultData.parse_obj(obj)

        _obj = StructuredResultData.parse_obj({
            "document_format": obj.get("documentFormat"),
            "version": obj.get("version"),
            "name": obj.get("name"),
            "document": obj.get("document"),
            "data_map_key": DataMapKey.from_dict(obj.get("dataMapKey")) if obj.get("dataMapKey") is not None else None
        })
        return _obj
