# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr, validator

class StructuredResultDataId(BaseModel):
    """
    An identifier that uniquely describes an item of structured result data such as the risk to an interest curve or a set of yields or analytics on an index.  # noqa: E501
    """
    source: constr(strict=True, max_length=256, min_length=1) = Field(..., description="The platform or vendor that provided the structured result data, e.g. 'client'. This is primarily of interest when data could have been sourced from multiple sources")
    code: Optional[constr(strict=True, max_length=256, min_length=1)] = Field(None, description="The identifier for the entity that this id describes. It could be an index, instrument or other form of structured data")
    effective_at: Optional[StrictStr] = Field(None, alias="effectiveAt", description="The effectiveAt or cut label that this item of structured result data is/was updated/inserted with.")
    result_type: Optional[StrictStr] = Field(None, alias="resultType", description="An identifier that denotes the class of data that the id points to. This is not the same as the format, but a more generic identifier such as 'risk result', 'cashflow', 'index' or similar.")
    __properties = ["source", "code", "effectiveAt", "resultType"]

    @validator('source')
    def source_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('code')
    def code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StructuredResultDataId:
        """Create an instance of StructuredResultDataId from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if code (nullable) is None
        # and __fields_set__ contains the field
        if self.code is None and "code" in self.__fields_set__:
            _dict['code'] = None

        # set to None if effective_at (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_at is None and "effective_at" in self.__fields_set__:
            _dict['effectiveAt'] = None

        # set to None if result_type (nullable) is None
        # and __fields_set__ contains the field
        if self.result_type is None and "result_type" in self.__fields_set__:
            _dict['resultType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StructuredResultDataId:
        """Create an instance of StructuredResultDataId from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StructuredResultDataId.parse_obj(obj)

        _obj = StructuredResultDataId.parse_obj({
            "source": obj.get("source"),
            "code": obj.get("code"),
            "effective_at": obj.get("effectiveAt"),
            "result_type": obj.get("resultType")
        })
        return _obj
