# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class TradeTicket(BaseModel):
    """
    The base class for representing a Trade Ticket in LUSID.  # noqa: E501
    """
    trade_ticket_type: StrictStr = Field(..., alias="tradeTicketType", description="The available values are: LusidTradeTicket, ExternalTradeTicket")
    __properties = ["tradeTicketType"]

    @validator('trade_ticket_type')
    def trade_ticket_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('LusidTradeTicket', 'ExternalTradeTicket'):
            raise ValueError("must be one of enum values ('LusidTradeTicket', 'ExternalTradeTicket')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TradeTicket:
        """Create an instance of TradeTicket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TradeTicket:
        """Create an instance of TradeTicket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TradeTicket.parse_obj(obj)

        _obj = TradeTicket.parse_obj({
            "trade_ticket_type": obj.get("tradeTicketType")
        })
        return _obj
