# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, constr, validator

class TransactionQueryParameters(BaseModel):
    """
    TransactionQueryParameters
    """
    start_date: constr(strict=True, min_length=1) = Field(..., alias="startDate", description="The lower bound effective datetime or cut label (inclusive) from which to build the transactions.")
    end_date: constr(strict=True, min_length=1) = Field(..., alias="endDate", description="The upper bound effective datetime or cut label (inclusive) from which to retrieve transactions.")
    query_mode: Optional[StrictStr] = Field(None, alias="queryMode", description="The date to compare against the upper and lower bounds for the effective datetime or cut label. Defaults to 'TradeDate' if not specified. The available values are: TradeDate, SettleDate")
    show_cancelled_transactions: Optional[StrictBool] = Field(None, alias="showCancelledTransactions", description="Option to specify whether or not to include cancelled transactions in the output. Defaults to False if not specified.")
    __properties = ["startDate", "endDate", "queryMode", "showCancelledTransactions"]

    @validator('query_mode')
    def query_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('TradeDate', 'SettleDate'):
            raise ValueError("must be one of enum values ('TradeDate', 'SettleDate')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionQueryParameters:
        """Create an instance of TransactionQueryParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionQueryParameters:
        """Create an instance of TransactionQueryParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionQueryParameters.parse_obj(obj)

        _obj = TransactionQueryParameters.parse_obj({
            "start_date": obj.get("startDate"),
            "end_date": obj.get("endDate"),
            "query_mode": obj.get("queryMode"),
            "show_cancelled_transactions": obj.get("showCancelledTransactions")
        })
        return _obj
