# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, constr, validator
from lusid.models.trade_ticket import TradeTicket

class TranslateTradeTicketRequest(BaseModel):
    """
    A collection of instruments to translate, along with the target dialect to translate into.  # noqa: E501
    """
    tickets: Dict[str, TradeTicket] = Field(..., description="The collection of trade tickets to translate.                Each trade ticket should be keyed by a unique correlation id. This id is ephemeral  and is not stored by LUSID. It serves only as a way to easily identify each instrument in the response.")
    dialect: constr(strict=True, max_length=256, min_length=1) = Field(..., description="The target dialect that the given instruments should be translated to.")
    __properties = ["tickets", "dialect"]

    @validator('dialect')
    def dialect_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z]*$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z]*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslateTradeTicketRequest:
        """Create an instance of TranslateTradeTicketRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in tickets (dict)
        _field_dict = {}
        if self.tickets:
            for _key in self.tickets:
                if self.tickets[_key]:
                    _field_dict[_key] = self.tickets[_key].to_dict()
            _dict['tickets'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslateTradeTicketRequest:
        """Create an instance of TranslateTradeTicketRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslateTradeTicketRequest.parse_obj(obj)

        _obj = TranslateTradeTicketRequest.parse_obj({
            "tickets": dict(
                (_k, TradeTicket.from_dict(_v))
                for _k, _v in obj.get("tickets").items()
            )
            if obj.get("tickets") is not None
            else None,
            "dialect": obj.get("dialect")
        })
        return _obj
