# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr, validator
from lusid.models.instrument_event import InstrumentEvent
from lusid.models.perpetual_property import PerpetualProperty

class UpsertInstrumentEventRequest(BaseModel):
    """
    UpsertInstrumentEventRequest
    """
    instrument_event_id: constr(strict=True, max_length=64, min_length=1) = Field(..., alias="instrumentEventId", description="Free string that uniquely identifies the event within the corporate action source")
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers", description="The set of identifiers which determine the instrument this event relates to.")
    description: Optional[constr(strict=True, max_length=1024, min_length=0)] = Field(None, description="The description of the instrument event.")
    instrument_event: InstrumentEvent = Field(..., alias="instrumentEvent")
    properties: Optional[conlist(PerpetualProperty)] = Field(None, description="The properties attached to this instrument event.")
    sequence_number: Optional[StrictInt] = Field(None, alias="sequenceNumber", description="The order of the instrument event relative others on the same date (0 being processed first). Must be non negative.")
    participation_type: Optional[StrictStr] = Field('Mandatory', alias="participationType", description="Is participation in this event Mandatory, MandatoryWithChoices, or Voluntary.")
    __properties = ["instrumentEventId", "instrumentIdentifiers", "description", "instrumentEvent", "properties", "sequenceNumber", "participationType"]

    @validator('instrument_event_id')
    def instrument_event_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[\s\S]*$", value):
            raise ValueError(r"must validate the regular expression /^[\s\S]*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertInstrumentEventRequest:
        """Create an instance of UpsertInstrumentEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of instrument_event
        if self.instrument_event:
            _dict['instrumentEvent'] = self.instrument_event.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item in self.properties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['properties'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if participation_type (nullable) is None
        # and __fields_set__ contains the field
        if self.participation_type is None and "participation_type" in self.__fields_set__:
            _dict['participationType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertInstrumentEventRequest:
        """Create an instance of UpsertInstrumentEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertInstrumentEventRequest.parse_obj(obj)

        _obj = UpsertInstrumentEventRequest.parse_obj({
            "instrument_event_id": obj.get("instrumentEventId"),
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "description": obj.get("description"),
            "instrument_event": InstrumentEvent.from_dict(obj.get("instrumentEvent")) if obj.get("instrumentEvent") is not None else None,
            "properties": [PerpetualProperty.from_dict(_item) for _item in obj.get("properties")] if obj.get("properties") is not None else None,
            "sequence_number": obj.get("sequenceNumber"),
            "participation_type": obj.get("participationType") if obj.get("participationType") is not None else 'Mandatory'
        })
        return _obj
