# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist, constr
from lusid.models.model_property import ModelProperty

class UpsertInstrumentPropertyRequest(BaseModel):
    """
    UpsertInstrumentPropertyRequest
    """
    identifier_type: constr(strict=True, min_length=1) = Field(..., alias="identifierType", description="The unique identifier type to search for the instrument, for example 'Figi'.")
    identifier: constr(strict=True, min_length=1) = Field(..., description="A value of that type to identify the instrument to upsert properties for, for example 'BBG000BLNNV0'.")
    properties: Optional[conlist(ModelProperty)] = Field(None, description="A set of instrument properties and associated values to store for the instrument. Each property must be from the 'Instrument' domain.")
    __properties = ["identifierType", "identifier", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertInstrumentPropertyRequest:
        """Create an instance of UpsertInstrumentPropertyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item in self.properties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['properties'] = _items
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertInstrumentPropertyRequest:
        """Create an instance of UpsertInstrumentPropertyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertInstrumentPropertyRequest.parse_obj(obj)

        _obj = UpsertInstrumentPropertyRequest.parse_obj({
            "identifier_type": obj.get("identifierType"),
            "identifier": obj.get("identifier"),
            "properties": [ModelProperty.from_dict(_item) for _item in obj.get("properties")] if obj.get("properties") is not None else None
        })
        return _obj
