# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from lusid.models.metric_value import MetricValue
from lusid.models.quote_id import QuoteId

class UpsertQuoteRequest(BaseModel):
    """
    The details of the quote including its unique identifier, value and lineage.  Please note the Unit field on MetricValue is nullable on the upsert but there  is validation within the quote store to make sure this field is populated.  In the absence of a real unit then we recommend putting something in line with  the data in QuoteId.QuoteSeriesId.quoteType e.g. InterestRate.  # noqa: E501
    """
    quote_id: QuoteId = Field(..., alias="quoteId")
    metric_value: Optional[MetricValue] = Field(None, alias="metricValue")
    lineage: Optional[StrictStr] = Field(None, description="Description of the quote's lineage e.g. 'FundAccountant_GreenQuality'.")
    scale_factor: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="scaleFactor", description="An optional scale factor for non-standard scaling of quotes against the instrument. For example, if you wish the quote's Value to be scaled down by a factor of 100, enter 100. If not supplied, the default ScaleFactor is 1.")
    __properties = ["quoteId", "metricValue", "lineage", "scaleFactor"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertQuoteRequest:
        """Create an instance of UpsertQuoteRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of quote_id
        if self.quote_id:
            _dict['quoteId'] = self.quote_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metric_value
        if self.metric_value:
            _dict['metricValue'] = self.metric_value.to_dict()
        # set to None if lineage (nullable) is None
        # and __fields_set__ contains the field
        if self.lineage is None and "lineage" in self.__fields_set__:
            _dict['lineage'] = None

        # set to None if scale_factor (nullable) is None
        # and __fields_set__ contains the field
        if self.scale_factor is None and "scale_factor" in self.__fields_set__:
            _dict['scaleFactor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertQuoteRequest:
        """Create an instance of UpsertQuoteRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertQuoteRequest.parse_obj(obj)

        _obj = UpsertQuoteRequest.parse_obj({
            "quote_id": QuoteId.from_dict(obj.get("quoteId")) if obj.get("quoteId") is not None else None,
            "metric_value": MetricValue.from_dict(obj.get("metricValue")) if obj.get("metricValue") is not None else None,
            "lineage": obj.get("lineage"),
            "scale_factor": obj.get("scaleFactor")
        })
        return _obj
