# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist, constr

class ValuationSchedule(BaseModel):
    """
    Specification object for the valuation schedule, how do we determine which days we wish to perform a valuation upon.  # noqa: E501
    """
    effective_from: Optional[StrictStr] = Field(None, alias="effectiveFrom", description="If present, the EffectiveFrom and EffectiveAt dates are interpreted as a range of dates for which to perform a valuation.  In this case, valuation is calculated for the portfolio(s) for each business day in the given range.")
    effective_at: constr(strict=True, min_length=1) = Field(..., alias="effectiveAt", description="The market data time, i.e. the time to run the valuation request effective of.")
    tenor: Optional[constr(strict=True, max_length=16, min_length=0)] = Field(None, description="Tenor, e.g \"1D\", \"1M\" to be used in generating the date schedule when effectiveFrom and effectiveAt are both given and are not the same.")
    roll_convention: Optional[constr(strict=True, max_length=50, min_length=0)] = Field(None, alias="rollConvention", description="When Tenor is given and is \"1M\" or longer, this specifies the rule which should be used to generate the date schedule.    For example, \"EndOfMonth\" to generate end of month dates, or \"1\" to specify the first day of the applicable month.")
    holiday_calendars: Optional[conlist(StrictStr)] = Field(None, alias="holidayCalendars", description="The holiday calendar(s) that should be used in determining the date schedule.  Holiday calendar(s) are supplied by their names, for example, \"CoppClark\".   Note that when the calendars are not available (e.g. when the user has insufficient permissions),   a recipe setting will be used to determine whether the whole batch should then fail or whether the calendar not being available should simply be ignored.")
    valuation_date_times: Optional[conlist(StrictStr)] = Field(None, alias="valuationDateTimes", description="If given, this is the exact set of dates on which to perform a valuation. This will replace/override all other specified values if given.")
    business_day_convention: Optional[constr(strict=True, max_length=50, min_length=0)] = Field(None, alias="businessDayConvention", description="When Tenor is given and is not equal to \"1D\", there may be cases where \"date + tenor\" land on non-business days around month end.  In that case, the BusinessDayConvention, e.g. modified following \"MF\" would be applied to determine the next GBD.")
    __properties = ["effectiveFrom", "effectiveAt", "tenor", "rollConvention", "holidayCalendars", "valuationDateTimes", "businessDayConvention"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ValuationSchedule:
        """Create an instance of ValuationSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if effective_from (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_from is None and "effective_from" in self.__fields_set__:
            _dict['effectiveFrom'] = None

        # set to None if tenor (nullable) is None
        # and __fields_set__ contains the field
        if self.tenor is None and "tenor" in self.__fields_set__:
            _dict['tenor'] = None

        # set to None if roll_convention (nullable) is None
        # and __fields_set__ contains the field
        if self.roll_convention is None and "roll_convention" in self.__fields_set__:
            _dict['rollConvention'] = None

        # set to None if holiday_calendars (nullable) is None
        # and __fields_set__ contains the field
        if self.holiday_calendars is None and "holiday_calendars" in self.__fields_set__:
            _dict['holidayCalendars'] = None

        # set to None if valuation_date_times (nullable) is None
        # and __fields_set__ contains the field
        if self.valuation_date_times is None and "valuation_date_times" in self.__fields_set__:
            _dict['valuationDateTimes'] = None

        # set to None if business_day_convention (nullable) is None
        # and __fields_set__ contains the field
        if self.business_day_convention is None and "business_day_convention" in self.__fields_set__:
            _dict['businessDayConvention'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ValuationSchedule:
        """Create an instance of ValuationSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ValuationSchedule.parse_obj(obj)

        _obj = ValuationSchedule.parse_obj({
            "effective_from": obj.get("effectiveFrom"),
            "effective_at": obj.get("effectiveAt"),
            "tenor": obj.get("tenor"),
            "roll_convention": obj.get("rollConvention"),
            "holiday_calendars": obj.get("holidayCalendars"),
            "valuation_date_times": obj.get("valuationDateTimes"),
            "business_day_convention": obj.get("businessDayConvention")
        })
        return _obj
