# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, constr
from lusid.models.lusid_instrument import LusidInstrument
from lusid.models.weighted_instrument_in_line_lookup_identifiers import WeightedInstrumentInLineLookupIdentifiers

class WeightedInstrument(BaseModel):
    """
    Specification for a holding or quantity of (weight for) an instrument on a given date.  # noqa: E501
    """
    quantity: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The quantity of the instrument that is owned.")
    holding_identifier: Optional[constr(strict=True, max_length=256, min_length=0)] = Field(None, alias="holdingIdentifier", description="Identifier for the instrument.  For a single, unique trade or transaction this can be thought of as equivalent to the transaction identifier, or  a composite of the sub-holding keys for a regular sub-holding. When there are multiple transactions sharing the same underlying instrument  such as purchase of shares on multiple dates where tax implications are different this would not be the case.    In an inlined aggregation request if this is wanted to identify a line item, it can be specified in the set of aggregation keys given on the aggregation  request that accompanies the set of weighted instruments.")
    instrument: Optional[LusidInstrument] = None
    in_line_lookup_identifiers: Optional[WeightedInstrumentInLineLookupIdentifiers] = Field(None, alias="inLineLookupIdentifiers")
    instrument_scope: Optional[constr(strict=True, max_length=256, min_length=0)] = Field(None, alias="instrumentScope", description="The scope in which to resolve the instrument, if no inlined definition is provided.  If left empty, the default scope will be used.")
    __properties = ["quantity", "holdingIdentifier", "instrument", "inLineLookupIdentifiers", "instrumentScope"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WeightedInstrument:
        """Create an instance of WeightedInstrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of instrument
        if self.instrument:
            _dict['instrument'] = self.instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of in_line_lookup_identifiers
        if self.in_line_lookup_identifiers:
            _dict['inLineLookupIdentifiers'] = self.in_line_lookup_identifiers.to_dict()
        # set to None if holding_identifier (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_identifier is None and "holding_identifier" in self.__fields_set__:
            _dict['holdingIdentifier'] = None

        # set to None if in_line_lookup_identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.in_line_lookup_identifiers is None and "in_line_lookup_identifiers" in self.__fields_set__:
            _dict['inLineLookupIdentifiers'] = None

        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WeightedInstrument:
        """Create an instance of WeightedInstrument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WeightedInstrument.parse_obj(obj)

        _obj = WeightedInstrument.parse_obj({
            "quantity": obj.get("quantity"),
            "holding_identifier": obj.get("holdingIdentifier"),
            "instrument": LusidInstrument.from_dict(obj.get("instrument")) if obj.get("instrument") is not None else None,
            "in_line_lookup_identifiers": WeightedInstrumentInLineLookupIdentifiers.from_dict(obj.get("inLineLookupIdentifiers")) if obj.get("inLineLookupIdentifiers") is not None else None,
            "instrument_scope": obj.get("instrumentScope")
        })
        return _obj
