# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, constr, validator

class WorkspaceItemCreationRequest(BaseModel):
    """
    A request to create an item in a workspace.  # noqa: E501
    """
    format: StrictInt = Field(..., description="A simple integer format identifier.")
    name: constr(strict=True, max_length=64, min_length=1) = Field(..., description="A workspace item's name.")
    group: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The group containing a workspace item.")
    description: constr(strict=True, max_length=1024, min_length=0) = Field(..., description="The description of a workspace item.")
    content: Optional[Any] = Field(..., description="The content associated with a workspace item.")
    type: constr(strict=True, max_length=6000, min_length=0) = Field(..., description="The type of the workspace item.")
    __properties = ["format", "name", "group", "description", "content", "type"]

    @validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('group')
    def group_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\s\S]*$", value):
            raise ValueError(r"must validate the regular expression /^[\s\S]*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkspaceItemCreationRequest:
        """Create an instance of WorkspaceItemCreationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if content (nullable) is None
        # and __fields_set__ contains the field
        if self.content is None and "content" in self.__fields_set__:
            _dict['content'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkspaceItemCreationRequest:
        """Create an instance of WorkspaceItemCreationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkspaceItemCreationRequest.parse_obj(obj)

        _obj = WorkspaceItemCreationRequest.parse_obj({
            "format": obj.get("format"),
            "name": obj.get("name"),
            "group": obj.get("group"),
            "description": obj.get("description"),
            "content": obj.get("content"),
            "type": obj.get("type")
        })
        return _obj
