# OpenI PyPi

> PYPI package for 启智AI协作平台。

# 使用说明安装

- 启智平台提供的Python工具包，使用户能在本地上传数据集。
- 用户可以获取镜像内存放代码，数据集，模型，输出结果的路径
- 可以使用公共函数实现数据集的拷贝，模型的上传等
- 使用说明：
  - 使用前请在平台个人设置中获取token：[点击跳转token获取界面](https://openi.pcl.ac.cn/user/settings/applications)
  - 当前版本为了解决用户上传数据集的需求，建议在本地使用。后续版本将适配代码仓配置、隐藏token及云脑任务。

## 安装

*适配python3.6及以上版本*

```bash
pip install -U openi-test
```

## 本地上传数据集示例

**dataset.upload_file(file, username, repository, token, cluster = "NPU")**

*上传本地单个文件到启智平台数据集，支持断点续传*

- `file`        **str, 必填**：文件路径(包含文件名，支持linux与mac路径，也支持windows文件路径如d:\\xxx)
- `username`    **str, 必填**：上传数据集所属项目owner用户名，可以是用户或组织
- `repository`  **str, 必填**：数据集所属项目路径，此为仓库地址中的名字，更改过名称的项目需填写仓库地址中的路径
- `token`       **str, 必填**：用户启智上获取的令牌token，并对该数据集有权限
- `cluster`     **str, 选填, 默认"NPU"**：可填入GPU或NPU，上传至不同的存储集群

```python


from openi.dataset import upload_file
upload_file(
    file = "", # 必填，文件路径(包含文件名)
    username = "", # 必填，数据集所属项目用户名
    repository = "", # 必填，数据集所属项目名
    token = "", #必填，用户启智上获取的令牌token，并对该项目数据集有权限
  
    cluster = "", # 选填，可填入GPU或NPU，不填写后台默认为NPU
    app_url = "" #选填, 默认为平台地址，用户不用填写，开发测试用
    file = "", 
    username = "", 
    repository = "", 
    token = "", 
    cluster = ""
    )

```

界面如下：

![alt](./media/4.png)

## GPU，GCU资源获取路径函数及示例：

```
#公共函数
from openi.path import (
    get_code_path,
    get_data_path,
    get_pretrain_model_path,
    get_output_path,
    push_output_to_openi,
)
#使用方法：
code_path = get_code_path()
data_path = get_data_path()
pretrain_model_path = get_pretrain_model_path()
output_path = get_output_path()
push_output_to_openi = push_output_to_openi()


```


## NPU资源使用公共函数及示例

```
#公共函数
from openi.cloudbrain import (
    openi_multidataset_to_env  启智集群任务将数据集拷贝到训练镜像
    c2net_multidataset_to_env  智算集群任务将数据集拷贝到训练镜像
    pretrain_to_env            将预训练模型文件拷贝到训练镜像
    env_to_openi               将训练镜像的输出结果拷贝回启智平台
    obs_copy_file              通过mox拷贝文件
    obs_copy_folder 	   通过mox拷贝文件夹
)
#使用方法：
openi_multidataset_to_env(args.multi_data_url, data_dir)
c2net_multidataset_to_env(args.multi_data_url, data_dir)
pretrain_to_env(args.pretrain_url, pretrain_dir)
env_to_openi(train_dir,args.train_url)
obs_copy_file(obs_path_file,local_path_file)
obs_copy_folder(obs_path,local_path)
```

test
