"""add reply id to attachments

Revision ID: 1b0ab951adca
Revises: ce7f46f445dc
Create Date: 2025-08-27 14:14:16.237272

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "1b0ab951adca"
down_revision = "ce7f46f445dc"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("attachment_file", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "reply_id",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                default=uuid.uuid4,
                nullable=True,
            )
        )

    with op.batch_alter_table("software", schema=None) as batch_op:
        batch_op.alter_column(
            "version", existing_type=sa.VARCHAR(length=20), nullable=True
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("software", schema=None) as batch_op:
        batch_op.alter_column(
            "version", existing_type=sa.VARCHAR(length=20), nullable=False
        )

    with op.batch_alter_table("attachment_file", schema=None) as batch_op:
        batch_op.drop_column("reply_id")

    # ### end Alembic commands ###
