"""add playlist_id field to notification

Revision ID: 5f1620d191af
Revises: 71d546ace0ee
Create Date: 2025-10-01 17:25:30.645533

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "5f1620d191af"
down_revision = "71d546ace0ee"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("notification", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "playlist_id",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                default=uuid.uuid4,
                nullable=True,
            )
        )
        batch_op.alter_column(
            "task_id", existing_type=sa.UUID(), nullable=True
        )
        batch_op.drop_constraint("notification_uc", type_="unique")
        batch_op.create_unique_constraint(
            "notification_uc",
            [
                "person_id",
                "author_id",
                "comment_id",
                "reply_id",
                "playlist_id",
                "type",
            ],
        )
        batch_op.create_index(
            batch_op.f("ix_notification_playlist_id"),
            ["playlist_id"],
            unique=False,
        )
        batch_op.create_foreign_key(None, "playlist", ["playlist_id"], ["id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("notification", schema=None) as batch_op:
        batch_op.drop_constraint(None, type_="foreignkey")
        batch_op.drop_index(batch_op.f("ix_notification_playlist_id"))
        batch_op.drop_constraint("notification_uc", type_="unique")
        batch_op.create_unique_constraint(
            "notification_uc",
            ["person_id", "author_id", "comment_id", "reply_id", "type"],
            postgresql_nulls_not_distinct=False,
        )
        batch_op.alter_column(
            "task_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.drop_column("playlist_id")
    # ### end Alembic commands ###
